<?php
//
// jsrsServer.php - javascript remote scripting server include
//
// Orginal Author:  Brent Ashley [jsrs@megahuge.com]
// PHP version   :  S?stien Cramatte [sebastien@webeclaireur.com]
//		    Pierre Cailleux [cailleux@noos.fr]
// Date		 :  May 2001
//
// see jsrsClient.js for version info
//
//  see license.txt for copyright and license info

function jsrsDispatch($validFuncs){
  $func = jsrsBuildFunc($validFuncs);

  if ($func != ""){
    $retval=null;

    eval("\$retval =  " . $func . ";");

    if (strlen($retval)>0){
      jsrsReturn($retval."");
    } else {
      jsrsReturn("");
    }
  } else {
    jsrsReturnError("function builds as empty string");
  }
}

function jsrsDispatchPag($validFuncs ){
  $func = jsrsBuildFunc($validFuncs);

  if ($func != ""){
    $retval;

    eval("\$retval =  " . $func . ";");

    if (strlen($retval)>0){
      jsrsReturn2($retval."");
    } else {
      jsrsReturn2("");
    }
  } else {
    jsrsReturnError("function builds as empty string");
  }
}

function jsrsDispatchFile($validFuncs ){
  $func = jsrsBuildFunc($validFuncs);

  if ($func != ""){
    $retval=null;

    eval("\$retval =  " . $func . ";");
  }
}

function jsrsReturn($payload) {
  global $cnf;
  global $C;
  if(!isset($C)) $C = (isset($_REQUEST['C']) ? $_REQUEST['C'] : "");

  Print (
      "<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN' 'http://www.w3.org/TR/html4/loose.dtd'>"
    . "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=".$cnf["html_charset"]."\"><title></title></head><body onload=\"p=document.layers?parentLayer:window.parent;p.jsrsLoaded('"
    . $C . "');\">"
    . "<form accept-charset=\"".$cnf["html_charset"]."\" name=\"jsrs_Form\" action=\"jsrs_Form\"><textarea name=\"jsrs_Payload\" id=\"jsrs_Payload\">"
    . jsrsEscape($payload) . "</textarea></form></body></html>");

    exit();
}

function jsrsReturn2($payload) {
  global $cnf;
  global $C;
  if(!isset($C)) $C = (isset($_REQUEST['C']) ? $_REQUEST['C'] : "");

  Print (
      "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=".$cnf["html_charset"]."\"></head><body onload=\"p=document.layers?parentLayer:window.parent;p.jsrsLoadedPag('"
    . $C . "', this.document.getElementById('imagen'));\">"
    . "<div id='jsrs_Payload' name='jsrs_Payload'>"
    . $payload . "</div>
	</body></html>");

    exit();
}

function jsrsEscape($str){
  // escape ampersands so special chars aren't interpreted
  //$tmp = str_replace( "&", "&amp;", $str );
  //$tmp2 = str_replace( "<", "&lt;", $tmp );
  // escape slashes  with whacks so end tags don't interfere with return html
  //$temp = str_replace( "\/" , "\\/",$tmp2);
  //  $temp2 = str_replace("&m;" , "hola",$temp);
  //print $temp;
	$temp = $str;
	$temp=str_replace("\n","<br />", $temp );
	$temp=str_replace("<", "&lt;"  , $temp );
	$temp=str_replace("\/","\\//"  , $temp);
	$temp=str_replace("&", "&amp;" , $temp);
	$temp=str_replace("¿", "&#191;", $temp);
	$temp=str_replace("º", "&#186;", $temp);
	$temp=str_replace("ª", "&#350;", $temp);

	$temp=str_replace("á","&#225;",$temp);
	$temp=str_replace("é","&#233;",$temp);
	$temp=str_replace("í","&#237;",$temp);
	$temp=str_replace("ó","&#243;",$temp);
	$temp=str_replace("ú","&#250;",$temp);

	$temp=str_replace("Á","&#193;",$temp);
	$temp=str_replace("É","&#201;",$temp);
	$temp=str_replace("Í","&#205;",$temp);
	$temp=str_replace("Ó","&#211;",$temp);
	$temp=str_replace("Ú","&#218;",$temp);

	$temp=str_replace("ü","&#252;",$temp);
	$temp=str_replace("Ü","&#220;",$temp);

	$temp=str_replace("ñ", "&#241;", $temp);
	$temp=str_replace("Ñ", "&#209;", $temp);

	return $temp;
//return str_replace("\/" , "\\/",$tmp);
}

/////////////////////////////
//
// user functions
function jsrsReturnError($str){
  global $C;
  if(!isset($C)) $C = (isset($_REQUEST['C']) ? $_REQUEST['C'] : "");

  // escape quotes
  $cleanStr = str_replace("\'","\\'",$str);

  // !!!! --- Warning -- !!!
  $cleanStr = "jsrsError: " . str_replace("\"", "\\\"", $cleanStr);
  print ("<html><head></head><body "
         . "onload=\"p=document.layers?parentLayer:window.parent;p.jsrsError('" . $C . "','" . urlencode($str) . "');\"><div id=\"ojsrs\" name=\"ojsrs\">"
         . $cleanStr . "</div></body></html>" );
  exit();
}

function jsrsArrayToString( $a, $delim ){
  // user function to flatten 1-dim array to string for return to client
  $d = "~~~";
  if (!isset($delim)) $d = $delim;
  return implode($a,$d);
}

function jsrsStringToArray( $a, $delim ){
  $d = "~~~";
  if (!isset($delim)) $d = $delim;
  return explode($d,$a);
}

function jsrsBuildFunc($validFuncs)
{
	global $F;
	if(!isset($F)) $F = (isset($_REQUEST['F']) ? $_REQUEST['F'] : "");

	$func = "";
	if ($F != "")
	{
		$func = $F;
    // make sure it's in the dispatch list
  	if (strpos(strtoupper($validFuncs),strtoupper($func))===false)
			jsrsReturnError($func . " is not a valid function" );

		$func .= "(";
		$i = 0;

		//--- To optimize ! ---
		eval("global \$P$i;");
		eval("if(!isset(\$P$i)) \$P$i = (isset(\$_REQUEST['P$i']) ? \$_REQUEST['P$i']:'');");

		//echo "<script>alert('0x. ".substr(str_replace(chr(13),'-+-',$_REQUEST['P3']),strpos(str_replace(chr(13),'-+-',$_REQUEST['P3']),'observaciones'))."')</script>";

		$Ptmp = "P". $i;

		while ($$Ptmp!="")
		{
			$parm = $$Ptmp;

			//$parm = addSlashes($parm);

// 			echo "<script>alert('1x. ".$parm[0].substr($parm,strpos($parm,'observaciones'))."')</script>";

			$parm = substr($parm,1,strlen($parm)-2);

			//echo "<script>alert('2x. ".$parm[0].substr($parm,strpos($parm,'observaciones'))."')</script>";

			$func .= "\"" . $parm . "\",";

			//echo "<script>alert('".str_replace('~','\\n',substr($func,strpos($func, "observaciones")))."')</script>";

			$i++;
			eval("global \$P$i;");
			eval("if(!isset(\$P$i)) \$P$i = (isset(\$_REQUEST['P$i']) ? \$_REQUEST['P$i']:'');");
			$Ptmp = "P". $i;
		}

		if (substr($func,strlen($func)-1,1)==",")
    	$func = substr($func,0,strlen($func)-1);

		$func .= ")";
  }

	//jsrsReturnError($func. "xButil");
	//	  echo "<script>alert('".str_replace('~','\\n',substr($func,1000))."')</script>";
	return $func;
}

function jsrsEvalEscape($thing) {
 $tmp = str_replace($thing,"\r\n","\n");
 return $tmp;
}

function jsrsAddSlashes($str) {
   $pattern = array(
       "/\\\\/"  , "/\n/"    , "/\r/"    , "/\"/"    ,
       "/\'/"    , "/&/"    , "/</"    , "/>/"
   );
   $replace = array(
       "\\\\\\\\", "\\n"    , "\\r"    , "\\\""    ,
       "\\'"    , "\\x26"  , "\\x3C"  , "\\x3E"
   );
   return preg_replace($pattern, $replace, $str);
}

function jsrsAddSlashesHTML($str) {
   $pattern = array(
       "/\\\\/"  ,
       "/&/"    , "/</"    , "/>/" ,
       "/\"/" , "/\n/", "/\xAA/", "/\'/", "/\r/"
   );
   $replace = array(
       "\\\\\\\\" ,
        "&amp;"  , "&lt;"  , "&gt;" ,
       "&quot;" , "\\n", "&#350;", "\\'", ""
   );
   return preg_replace($pattern, $replace, $str);
}
?>
