///////////////////////////////////////////////////////////////////////
/** 1. oBusca
 *
 *  Busca una etiqueta HTML y devuelve un apuntador al obejto HTML
 *  recibe de parametro un texto que es el nombre del id a buscar
 * \param n - String, Id a buscar en el HTML
 * \param [d] - Objeto, parametro opcional, un objeto donde se puede buscar el identificador
 * \return elem - Objeto, Devuelve el objeto si lo encuentra.
 */
function oBusca(n, d)
{
	var p,i,x=null;
	if(!d) d=document;
	if((p=n.indexOf("?")) > 0 && parent.frames.length)
	{
    	d=parent.frames[n.substring(p+1)].document;
		n=n.substring(0,p);
	}
  	for(i=0;!x&&d.layers&&i<d.layers.length;i++)
		x=oBusca(n,d.layers[i].document);
  	if(!x && !(x=d[n])&&d.all)
	{
		x=d.all[n];
		if(x && x.length)
		{
			for(_i=0; _i<x.length; _i++)
			{
				if(x[_i].id == n )
				{
					_tmpL = x.length;
					x= x[_i];
					_i += _tmpL + 1;
				}
			}
		}
	}
  	if(!x && d.getElementById)
		x=d.getElementById(n);
	if(!x && d.forms)
		for (i=0;!x&&i<d.forms.length;i++)
			x=d.forms[i][n];
//alert("x: " + x);
	return x;
}
///////////////////////////////////////////////////////////////////////
/** 2. max_win
 *  Maximiza la ventana de trabajo
*/
  function max_win()
  {
    window.resizeTo(screen.availWidth, screen.availHeight);
    window.moveTo(0,0);
  }
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** 3. win_data
 * Devuelve el tamao disponible de la ventana del navegador
 */
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 function win_data()
 {
 // constructor
	this.width  = (oNav.ns || oNav.ff) ? window.innerWidth  : 0;
	this.height = (oNav.ns || oNav.ff) ? window.innerHeight : 0;
 // metodo que actualiza los datos
	this.size = _win_data_consulta;
 }
 function _win_data_consulta()
 {
	this.width = (oNav.ns || oNav.ff) ? window.innerWidth : document.body.offsetWidth;
	this.height = (oNav.ns || oNav.ff) ? window.innerHeight : document.body.offsetHeight;
 }
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** 4. dialog
 * Muestra la ventana de dialogos y la carga
 * \param titulo - String, Titulo que se le asigna a la Ventana
 * \param win - String, Contenido HTML de la Ventana
 */
function dialog(titulo, win)
{
  win_bdy= oBusca('divWinText0');
	win_bdy.innerHTML = win;
	win_msg= oBusca('divWinHead0');
	win_msg.innerHTML = titulo;
//	oWin[0].x = $x;
//	oWin[0].y = $y;
//	oWin[0].w = $w;
//	oWin[0].h = $h;
//	oWin[0].lastx = 0;
//	oWin[0].lasty = 0;
//	oWin[0].bg = $bg;
//	oWin[0].bgo = $bgo;
	oWin[0].showIt();
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** 5. id_Browser
 * Identifica el navegador
 * Esta funcion no debe ser llamada directamente, a cambio use la variable oNav
 * \return this - Objeto, devuelve un objeto que identifica el navegador.
 * \sa oNav
 */
function id_Browser()
{
	var d=document;
	this.agt=navigator.userAgent.toLowerCase();
	this.major = parseInt(navigator.appVersion);
	this.dom=(d.getElementById)?1:0;
	this.ns=(d.layers);
	this.ns4up=(this.ns && this.major >=4);
	this.ns6=(this.dom&&navigator.appName=="Netscape");
	this.ff =(navigator.userAgent.match(/firefox/i))?true:false;  // identificando a firefox
	this.op=(window.opera? 1:0);
	this.ie=(d.all);
	this.ie4=(d.all&&!this.dom)?1:0;
	this.ie4up=(this.ie && this.major >= 4);
	this.ie5=(d.all&&this.dom);
	this.ie7=(navigator.userAgent.match(/MSIE 7.0/i))?true:false;  // identificando a IE8
	this.ie8=(navigator.userAgent.match(/MSIE 8.0/i))?true:false;  // identificando a IE8
	this.win=((this.agt.indexOf("win")!=-1) || (this.agt.indexOf("16bit")!=-1));
	this.mac=(this.agt.indexOf("mac")!=-1);
	//this.wWidth = (this.ns || this.ff) ? window.innerWidth : document.body.offsetWidth;
	//this.wHeight = (this.ns || this.ff) ? window.innerHeight : document.body.offsetHeight;
}
////////////////////////////////////////////////////////////////////////////////
/** 6. oNav
 * Variable que identifica el navegador
 * \return obj - Objeto,
 *         .agt
 *         .major
 *         .dom
 *         .ns
 *         .ns4up
 *         .ns6
 *         .op
 *         .ie
 *         .ie4
 *         .ie4up
 *         .ie5
 *         .win
 *         .mac
 * \sa id_Browser
 */
var oNav = new id_Browser();
var oVentana = new win_data();
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 7. push and shift for IE5
function Array_push() {
	var A_p = 0;
	for (A_p = 0; A_p < arguments.length; A_p++) {
		this[this.length] = arguments[A_p];
	}
	return this.length;
}
if (typeof Array.prototype.push == "undefined") { Array.prototype.push = Array_push; }
function Array_shift() {
	var A_s = 0;
	var response = this[0];
	for (A_s = 0; A_s < this.length-1; A_s++) {
		this[A_s] = this[A_s + 1];
	}
	this.length--;
	return response;
}
if (typeof Array.prototype.shift == "undefined") { Array.prototype.shift = Array_shift; }
Array.prototype._swapItems = function(ind1,ind2){ var _tmp = this[ind1]; this[ind1] = this[ind2];	this[ind2] = _tmp; }
Array.prototype._removeAt = function(ind){ for(var _i=ind;_i<this.length;_i++){ this[_i] = this[_i+1]; } this.length--; }
Array.prototype._insertAt = function(ind,value){ this[this.length] = null; for(var _i=this.length-1;_i>=ind;_i--){ this[_i] = this[_i-1]; } this[ind] = value; }
Array.prototype._find = function(pattern){for(var _i=0;_i<this.length;_i++){ if(pattern==this[_i]){ return _i; } } return -1; }
Array.prototype._delAt = function(ind){ if(Number(ind)<0 || this.length==0 || Number(ind)>=this.length){ return false; } for(var _i=ind;_i<this.length;_i++){ this[_i]=this[_i+1]; } this.length--; }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * 8. correctPNG
 * Corrige el problema de la transparencia de los PNG
 */
function correctPNG() // correctly handle PNG transparency in Win IE 5.5 or higher.
   {
   for(var i=0; i<document.images.length; i++)
      {
	  var img = document.images[i]
	  var imgName = img.src.toUpperCase()
	  if (imgName.substring(imgName.length-3, imgName.length) == "PNG")
	     {
		 var imgID = (img.id) ? "id='" + img.id + "' " : ""
		 var imgClass = (img.className) ? "class='" + img.className + "' " : ""
		 var imgTitle = (img.title) ? "title='" + img.title + "' " : "title='" + img.alt + "' "
	    var imgStyle = "display:inline-block;" + img.style.cssText
		 if (img.align == "left") imgStyle = "float:left;" + imgStyle
		 if (img.align == "right") imgStyle = "float:right;" + imgStyle
		 if (img.parentElement.href) imgStyle = "cursor:hand;" + imgStyle
		 var strNewHTML = "<span " + imgID + imgClass + imgTitle
		 + " style=\"" + "width:" + img.width + "; height:" + img.height + ";" + imgStyle + ";"
	    + "filter:progid:DXImageTransform.Microsoft.AlphaImageLoader"
		 + "(src=\'" + img.src + "\', sizingMethod='scale');\"></span>"
		 img.outerHTML = strNewHTML;
		 i = i-1;
	     }
      }
   }
if(oNav.ie5 && !oNav.ie8) { window.attachEvent("onload", correctPNG); }
//if(oNav.ie5) { window.attachEvent("onload", correctPNG); }
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** 9. cargaVarias
 * Funcion encargada de cargar otros scripts requeridos y partes del cuerpo
 *
 * \autor EG - 21-01-2005
 */
function cargaVarias()
{
 var oDiv=document.createElement("DIV");
 oDiv.id = "overDiv";
 oDiv.style.cssText = "position:absolute;visibility:hidden;z-index:99;";
 document.body.appendChild(oDiv);
/*
 oHead = document.getElementsByTagName("head");
 oBody =  document.body;
 var oScript = document.createElement("script");
 oScript.src= "/axys_comun/libs/js/overlib.js";
 oScript.type = "text/javascript";
 oBody = oBusca("_body");
 oHead = oBusca("_head");
 oHead.insertBefore(oScript, oHead.firstChild);
*/
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** 10. obj_show
 * Muestra un objeto
 * \param o - Objeto, Objeto que se desea mostrar u ocultar
 * \param disp - String, Acepta 'block' o 'inline'
 * \sa obj_hide, oNav
 */
function obj_show(o,disp) { (oNav.ns)? '':(!disp)? o.style.display="inline":o.style.display=disp; (oNav.ns)? o.visibility='show':o.style.visibility='visible'; };
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** 11. obj_hide
 * Oculta un Objeto
 * \param o - Objeto, Objeto que se desea mostrar u ocultar
 * \param disp - String, Acepta 'none'
 * \sa obj_show, oNav
 */
function obj_hide(o,disp) {
	(oNav.ns)? '':(arguments.length!=2)? o.style.display="none":o.style.display=disp;
	(oNav.ns)? o.visibility='hide':o.style.visibility='hidden';
};
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** 12. obj_setStyle
 * Fija un estilo especifico de un objeto
 * \param o - Objeto, a Modificar
 * \param s - String, Nombre del Estilo a Modificar
 * \param v - String, Valor de la propiedad estilo a modificar
 * \sa obj_getStyle, oNav
 */
function obj_setStyle(o,s,v) { if(oNav.ie5||oNav.dom) eval("o.style."+s+" = '" + v +"'"); };
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** 13. obj_getStyle
 * Devuelve un estilo especifico de un objeto
 * \param o - Objeto, a Interrogar
 * \param s - String, Nombre del Estilo a Consultar
 * \sa obj_setStyle, oNav
 */
function obj_getStyle(o,s) { if(oNav.ie5||oNav.dom) return eval("o.style."+s); };
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  14. Adiciona Evento a un Objeto
function obj_addEvt(o,e,f,c){ if(o.addEventListener)o.addEventListener(e,f,c);else if(o.attachEvent)o.attachEvent("on"+e,f);else eval("o.on"+e+"="+f) }
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  15. Escribe HTML en un objeto
function obj_writeHTML(o,h) { if(o) {if(oNav.ns) {var doc=o.document; doc.write(h); doc.close(); return false;}	if(typeof(o.innerHTML)=="string"){ o.innerHTML=""; o.innerHTML=h; return false;} } }
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  16. Lee HTML de un objeto
function obj_readHTML(o) { if(oNav.ns){var doc=o.document;doc.read(h);doc.close();return false;} if(o) if(typeof(o.innerHTML)=="string"){ return o.innerHTML;} }
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// KEY's
// Para agregar la tecla, metyer un script similar a este en cada HTML
/*
<script>
    var oKey = new obj_keyevt();
    oKey.addKey(67,-1,"location='http://e1.f124.mail.yahoo.com/ym/ShowFolder?rb=Inbox&YY=22637&YN=1'","shift+ctrl"); // Check Mail | CTRL-C
    oKey.addKey(80,-1,"location='http://e1.f124.mail.yahoo.com/ym/Compose?YY=22637'","shift+ctrl"); // Compose | CTRL-P
    oKey.addKey(70,-1,"location='http://e1.f124.mail.yahoo.com/ym/Folders?YY=22637'","shift+ctrl"); // Folders | CTRL-F
    oKey.addKey(83,-1,"location='http://e1.f124.mail.yahoo.com/ym/Search?YY=22637'","shift+ctrl"); // Search | CTRL-S
    oKey.addKey(72,-1,"location='http://help.yahoo.com/help/e1/mail'","shift+ctrl"); // Help | CTRL-H
function Init()   // esta funcion debe ser llamada en el evento onload
{
		if(document.getElementById)
		{
		    	document.onkeydown = function(evt) { oKey.keyevent(evt); }
		}
}
</script>
*/
/*
var K_SHIFT_KEYCODE = 16;
var K_CTRL_KEYCODE = 17;
var K_ALT_KEYCODE = 18;
var K_SHIFT = "shift";
var K_CTRL = "ctrl";
var K_ALT = "alt";
var obj_keyevt = new obj_keyevt2();
 obj_keyevt.count=0;
function obj_keyevt2(elm)
{
	this.id = "keyevt"+obj_keyevt.count++;
	eval(this.id + "=this");
	this.keys = new Array();
	this.shift=0;
	this.ctrl=0;
	this.alt=0;
	this.addKey = obj_addKey;
	this.keyevent = obj_keyevent;
	this.checkModKeys = obj_checkModKeys;
};
function obj_addKey(cdom,cns4,a,m)
{
	if(oNav.ie||oNav.dom) this.keys[cdom] = [a,m];
	else this.keys[cns4] = [a,m];
};
//var YLIB_COUNT=0;
function obj_keyevent(evt)
{
	if(oNav.ie||oNav.op) evt=event;
	var k = (oNav.ie||oNav.op||oNav.ns6)? evt.keyCode:evt.which;
	this.checkModKeys(evt,k);
	if(this.keys[k]==null) return false;
	var m = this.keys[k][1];
	if((this.shift && (m.indexOf(K_SHIFT) != -1) || !this.shift && (m.indexOf(K_SHIFT) == -1)) && (this.ctrl && (m.indexOf(K_CTRL) != -1) || !this.ctrl && (m.indexOf(K_CTRL) == -1)) && (this.alt && (m.indexOf(K_ALT) != -1) || !this.alt && (m.indexOf(K_ALT) == -1)))
	{
		var a = this.keys[k][0];
		a = eval(a);
		if(typeof a == "function") a();
	}
};
function obj_checkModKeys(e,k)
{
	if(oNav.dom)
	{
		this.shift = e.shiftKey;
		this.ctrl = e.ctrlKey;
		this.alt = e.altKey;
	}
	else
	{
		// for opera
		this.shift = (k==K_SHIFT_KEYCODE) ? 1:0;
		this.ctrl = (k==K_CTRL_KEYCODE) ? 1:0;
		this.alt = (k==K_ALT_KEYCODE) ? 1:0;
	}
return false;
};
var oKey = new obj_keyevt2();
function tecla()
{
  eventChooser = (oNav.ns) ? keyStroke.which : event.keyCode;
  which = String.fromCharCode(eventChooser).toLowerCase();
  //alert(which);
  alert(which.charCodeAt(0));
  //String.prototype.charCodeAt
}
*/
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 17. newImagen - Crea una grafica HTML y devuelve referencia al objeto creado
function newImagen (arg) {
	if (document.images) {
		rslt = new Image();
		rslt.src = arg;
		return rslt;
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 18. changeImagenes - Cambia una imagen por otra
function changeImagenes()
{
	d = document;
	if (d.images) {
		var img;
		for (var i=0; i<changeImagenes.arguments.length; i+=2) {
			img = null;
			if((changeImagenes.arguments[i].tagName) == 'IMG')
			{
				img = changeImagenes.arguments[i];
			}
			else
			{
				if (d.layers) {img = oBusca(changeImagenes.arguments[i],0);}
				else {img = d.images[changeImagenes.arguments[i]];}
			}
			if (img) {img.src = changeImagenes.arguments[i+1];}
		}
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// 19. trim - Elimina espacios en blanco al final y al inicio de una cadena
function trim(s) {
	s += "";

  while (s.substring(0,1) == ' ') {
    s = s.substring(1,s.length);
  }
  while (s.substring(s.length-1,s.length) == ' ') {
    s = s.substring(0,s.length-1);
  }
  return s;
}
function String_trim() {
	_str_tmp = new String;
	_str_tmp = this.replace(/(^\s*)|(\s*$)/g, "");

  while (_str_tmp.substring(0,1) == ' ') {
    _str_tmp = _str_tmp.substring(1,_str_tmp.length);
  }
  while (_str_tmp.substring(_str_tmp.length-1,_str_tmp.length) == ' ') {
    _str_tmp = _str_tmp.substring(0,_str_tmp.length-1);
  }
  return _str_tmp;
}
if (typeof String.prototype.trim == "undefined") {
	String.prototype.trim = String_trim;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// 20. addEvento - Adiciona un evento a un objeto
/**
 * \param sObj - String Nombre del objeto a quien se le debe adicionar la funcion
 * \param sEvento - String cadena de evento 'blur', 'click'
 * \param fnListen - Objeto Funcion, Nombre de la funcion que se lanzara en el evento debe ir sin comillas
 * \autor EG - 03-02-2005-20-2
 *
 *Events
    onabort - Fires when the user aborts the download of an image.
    onactivate - Fires when the object is set as the active element.
    onafterprint - Fires on the object immediately after its associated document prints or previews for printing.
    onafterupdate - Fires on a databound object after successfully updating the associated data in the data source object.
    onbeforeactivate - Fires immediately before the object is set as the active element.
    onbeforecopy - Fires on the source object before the selection is copied to the system clipboard.
    onbeforecut - Fires on the source object before the selection is deleted from the document.
    onbeforedeactivate - Fires immediately before the activeElement is changed from the current object to another object in the parent document.
    onbeforeeditfocus - Fires before an object contained in an editable element enters a UI-activated state or when an editable container object is control selected.
    onbeforepaste - Fires on the target object before the selection is pasted from the system clipboard to the document.
    onbeforeprint - Fires on the object before its associated document prints or previews for printing.
    onbeforeunload - Fires prior to a page being unloaded.
    onbeforeupdate - Fires on a databound object before updating the associated data in the data source object.
    onblur - Fires when the object loses the input focus.
    onbounce - Fires when the behavior property of the marquee object is set to "alternate" and the contents of the marquee reach one side of the window.
    oncellchange - Fires when data changes in the data provider.
    onchange - Fires when the contents of the object or selection have changed.
    onclick - Fires when the user clicks the left mouse button on the object.
    oncontextmenu - Fires when the user clicks the right mouse button in the client area, opening the context menu.
    oncontrolselect - Fires when the user is about to make a control selection of the object.
    oncopy - Fires on the source element when the user copies the object or selection, adding it to the system clipboard.
    oncut - Fires on the source element when the object or selection is removed from the document and added to the system clipboard.
    ondataavailable - Fires periodically as data arrives from data source objects that asynchronously transmit their data.
    ondatasetchanged - Fires when the data set exposed by a data source object changes.
    ondatasetcomplete - Fires to indicate that all data is available from the data source object.
    ondblclick - Fires when the user double-clicks the object.
    ondeactivate - Fires when the activeElement is changed from the current object to another object in the parent document.
    ondrag - Fires on the source object continuously during a drag operation.
    ondragend - Fires on the source object when the user releases the mouse at the close of a drag operation.
    ondragenter - Fires on the target element when the user drags the object to a valid drop target.
    ondragleave - Fires on the target object when the user moves the mouse out of a valid drop target during a drag operation.
    ondragover - Fires on the target element continuously while the user drags the object over a valid drop target.
    ondragstart - Fires on the source object when the user starts to drag a text selection or selected object.
    ondrop - Fires on the target object when the mouse button is released during a drag-and-drop operation.
    onerror - Fires when an error occurs during object loading.
    onerrorupdate - Fires on a databound object when an error occurs while updating the associated data in the data source object.
    onfilterchange - Fires when a visual filter changes state or completes a transition.
    onfinish - Fires when marquee looping is complete.
    onfocus - Fires when the object receives focus.
    onfocusin - Fires for an element just prior to setting focus on that element.
    onfocusout - Fires for the current element with focus immediately after moving focus to another element.
    onhelp - Fires when the user presses the F1 key while the browser is the active window.
    onkeydown - Fires when the user presses a key.
    onkeypress - Fires when the user presses an alphanumeric key.
    onkeyup - Fires when the user releases a key.
    onlayoutcomplete - Fires when the print or print preview layout process finishes filling the current LayoutRect object with content from the source document.
    onload - Fires immediately after the browser loads the object.
    onlosecapture - Fires when the object loses the mouse capture.
    onmousedown -    Fires when the user clicks the object with either mouse button.
    onmouseenter -     Fires when the user moves the mouse pointer into the object.
    onmouseleave -    Fires when the user moves the mouse pointer outside the boundaries of the object.
    onmousemove -    Fires when the user moves the mouse over the object.
    onmouseout -   Fires when the user moves the mouse pointer outside the boundaries of the object.
    onmouseover -    Fires when the user moves the mouse pointer into the object.
    onmouseup -     Fires when the user releases a mouse button while the mouse is over the object.
    onmousewheel -     Fires when the wheel button is rotated.
    onmove -    Fires when the object moves.
    onmoveend -    Fires when the object stops moving.
    onmovestart -    Fires when the object starts to move.
    onpaste -    Fires on the target object when the user pastes data, transferring the data from the system clipboard to the document.
    onpropertychange -     Fires when a property changes on the object.
    onreadystatechange -    Fires when the state of the object has changed.
    onreset -    Fires when the user resets a form.
    onresize -    Fires when the size of the object is about to change.
    onresizeend -     Fires when the user finishes changing the dimensions of the object in a control selection.
    onresizestart -    Fires when the user begins to change the dimensions of the object in a control selection.
    onrowenter -    Fires to indicate that the current row has changed in the data source and new data values are available on the object.
    onrowexit -    Fires just before the data source control changes the current row in the object.
    onrowsdelete -    Fires when rows are about to be deleted from the recordset.
    onrowsinserted -     Fires just after new rows are inserted in the current recordset.
    onscroll -     Fires when the user repositions the scroll box in the scroll bar on the object.
    onselect -    Fires when the current selection changes.
    onselectionchange -     Fires when the selection state of a document changes.
    onselectstart -     Fires when the object is being selected.
    onstart -     Fires at the beginning of every loop of the marquee object.
    onstop -     Fires when the user clicks the Stop button or leaves the Web page.
    onsubmit -     Fires when a FORM is about to be submitted.
    onunload - Fires immediately before the object is unloaded.
 */
function addEvento(sObj, sEvento, fnListen)
{
 _oD = oBusca(sObj);
 if (_oD.addEventListener)
 {
   _oD.addEventListener(sEvento, fnListen, false);
 }
 else if (_oD.attachEvent)
 {
   _evt  = "on" + sEvento;
   _oD.attachEvent(_evt, fnListen);
 }
 else
 {
   _cad = "_oD.on" + sEvento + " = fnListen;";
   eval(_cad);
 }
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 21.
function ArraytoString(s, delim)
{
  var d = (delim == null)? '~' : delim;
  return s.join(d);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 22.
function StringtoArray(txt, delim)
{
  var d = (delim == null)? '~' : delim;
  var s = new String(txt);
  return s.split(d);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 23.
function cambiaClass(obj, class1, class2)
{
//alert(obj.className + "\n" + obj + "\n" + class1+ "\n" +class2);
   if(obj.className == class1)
   { obj.className = class2; }
   else
   { obj.className = class1; }
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 24.
function globalW()
{	if (document.all) {return document.body.clientWidth} else {return self.innerWidth}  }
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 25.
function globalH()
{	if (document.all) {return document.body.clientHeight} else {return self.innerHeight}  }
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 26.
function scrollLeft()
{	if (document.all) {return document.body.scrollLeft} else {return self.pageXOffset}  }
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 27.
function scrollTop()
{	if (document.all) {return document.body.scrollTop} else {return self.pageYOffset}  }
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 28. Funciones para el ToolBar
var clicked="";
var gtype=".gif";
var selstate="_over";
var img_dir= "/img/";
function writeButton(urld, url, name, w, h, alt, target, hsp)
{
	gname = name;
	while(typeof(document[name])!="undefined") name += "x";
	reg(gname, name);
	if (alt != "") alt = " alt=\"" + alt + "\"";
	if (target != "") target = " target=\"" + target + "\"";
	if (w > 0) w = " width=\""+w+"\""; else w = "";
	if (h > 0) h = " height=\""+h+"\""; else h = "";
	if (url != "") url = " href=\"" + urld + url + "\"";
	document.write("<a " + url + evs(name, alt) + target + ">");
	if (hsp == -1) hsp =" align=\"right\"";
	else if (hsp > 0) hsp = " hspace=\""+hsp+"\"";
	else hsp = "";
	document.write("<img src=\""+img_dir+gname+gtype+"\" name=\"" + name + "\"" + w + h + alt + hsp + " border=\"0\" /></a>");
}
function turn_over(name) {
	if (document.images != null && clicked != name) {
		document[name].src = document[name+"_over"].src;
	}
}
function turn_off(name) {
	if (document.images != null && clicked != name) {
		document[name].src = document[name+"_off"].src;
	}
}
function reg(gname,name)
{
if (document.images)
	{
	document[name+"_off"] = new Image();
	document[name+"_off"].src = img_dir+gname+gtype;
	document[name+"_over"] = new Image();
	document[name+"_over"].src = img_dir+gname+"_over"+gtype;
	}
}
function evs(name){ return " onmouseover=\"turn_over('"+ name + "')\" onmouseout=\"turn_off('"+ name + "')\""}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 29.
function abs(n)
{
 n = eval(n);
 if(n <= (-0)) { n = n * (-1);}
 return n;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 30.
function importXML(sFile)
{
	if(trim(sFile) != "")
	{
		if (document.implementation && document.implementation.createDocument)
		{
			xmlDoc = document.implementation.createDocument("", "", null);
			xmlDoc.onload = _manXML;
		}
		else if (window.ActiveXObject)
		{
			xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
			xmlDoc.onreadystatechange = function () {
				if (xmlDoc.readyState == 4) _manXML()
			};
	 	}
		else
		{
			alert('Su Browser no puede manejar este Script!!!');
			return;
		}
		 xmlDoc.load(trim(sFile));
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 31.
function _manXML()
{
 if(manXML) { manXML(); }
}

	//-------------------------------------------------------------------------------------
	// doDrag event - called when dragging
	//
	function doDrag(e) {
if(oNav.ie){e = event;}
		// Calculates the difference between the last mouse position
		// and the current position.
		//
	        var difX=e.clientX-window.lastX;
	        var difY=e.clientY-window.lastY;
		// If mode equals resize... (see beginDrag function)
		//
		if(dd_mode=="resize") {
			// Then the drag operation is just for the little resize icon.
			//
			// Retrieves the x and y position for the dd_resize2 div and adding
			// the dif value.
			// NOTE that the dd_resize2 includes the dd_resize image (icon).
			//
		        var newX1 = parseInt(document.getElementById("dd_resize2").style.left)+difX;
		        var newY1 = parseInt(document.getElementById("dd_resize2").style.top)+difY;
			// Sets the new position
		        document.getElementById("dd_resize2").style.left=newX1+"px";
		        document.getElementById("dd_resize2").style.top=newY1+"px";
		} else {
			// Same thing but now for dd_area...
			// In this case the user is dragging the image instead the little resize icon.
			//
		        var newX1 = parseInt(document.getElementById("dd_area").style.left)+difX;
		        var newY1 = parseInt(document.getElementById("dd_area").style.top)+difY;
		        document.getElementById("dd_area").style.left=newX1+"px";
		        document.getElementById("dd_area").style.top=newY1+"px";
		}
		// Stores the current mouse position.
		//
	        window.lastX=e.clientX;
	        window.lastY=e.clientY;
	}
	//----------------------------------------------------------------------------
	// When drag begins, this function is called.. see addEventListener calls
	// in start function.
	//
	function beginDrag(e) {
if(oNav.ie){e = event;}
		e.preventDefault();
		// Stores the current mouse position for further use.
		//
	        window.lastX=e.clientX;
	        window.lastY=e.clientY;
		// Register doDrag event handler to receive generic onmousemove events.
		//
	        window.onmousemove=doDrag;
		// Register endDrag event handler to receive generic onmouseup events.
		//
	        window.onmouseup=endDrag;
		// Verify the attribute of the event's target.
		myattr=e.target.getAttribute("ID");
		if(myattr=="dd_resize") {
			// If the attribute's value is dd_resize,
			// the user clicked over the dd_resize image,
			// and the dd_mode should be resized.
			dd_mode="resize";
		} else {
			// Else the user just clicked over the image, so the mode is set to drag.
			//
			dd_mode="drag";
		}
	}
	//----------------------------------------------------------------------------
	// Called when the mouse button is released
	//
	function endDrag(e) {
if(oNav.ie){e = event;}
		// Releases the onmousemove event.
	        window.onmousemove=null;
		// If the operation is resize then...
		if(dd_mode=="resize") {
			// DOM Steps to resize the image.
			// Stores the x and y position of the dd_resize2 icon area and the dd_image are
			var oldX1 = parseInt(document.getElementById("dd_resize2").style.left);
		   var oldY1 = parseInt(document.getElementById("dd_resize2").style.top);
			var oldX2 = parseInt(document.getElementById("dd_image").style.left);
		   var oldY2 = parseInt(document.getElementById("dd_image").style.top);
 			// Since user was resizing by dragging the dd_resize2 div element, the
			// oldX1 and oldY1 values represent the new resize position.
			// In this case, the difference between oldX1 and oldX2 is the new width.
			ddx=oldX1-oldX2;
			// And the difference between oldY1 and oldY2 is the new height.
			ddy=oldY1-oldY2;
			// Dynamicallty sets the width and height attributes.
			imagg=document.getElementById("img");
			imagg.setAttribute("width",""+ddx+"");
			imagg.setAttribute("height",""+ddy+"");
			// dd_area is an area in the background of the image. It is a border.
			// Its width and height values are the same as those for ddx and ddy plus 2 pixels.
			// NOTE that dd_area in the HTML is a single div with gray background,
			// so the size can be changed directly by setting style width and height
			// properties.
			//
			ndx=ddx+2;
			document.getElementById("dd_area").style.width=ndx+"px";
			ndy=ddy+2;
			document.getElementById("dd_area").style.height=ndy+"px";
		}
	}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 32. Cambia el valor de un INPUT tipo RADIO o CHECKBOX
function Input_Change()
{
 obj = arguments[0];
 dest_mostrar = arguments[1];
 nomArr = arguments[2];
 tamArr = arguments[3];

 if(dest_mostrar != "")
 {
 	if(obj.checked)
	 {
	 	obj_show(oBusca("ibx_" + dest_mostrar));
	 }
 	else
	 {
	 	obj_hide(oBusca("ibx_" + dest_mostrar));
	 }
 }
 if(nomArr != "")
 {
	 cadena = new String();
	 _encA = false;
	 for(n=0; n<tamArr; n++)
	 {
	   _tmp = oBusca("opc_" + nomArr + n);
	   if((typeof(_tmp) == 'object') && _tmp != null)
	   {
	 		_encA = true;
			if(_tmp.checked) {cadena += _tmp.value+",";}
		}
	 }
	if(_encA)  oBusca(nomArr).value = cadena.trim();
 }
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 33. Modifica el status area
function estado(str)
{
	t = msg_estado_form_timer*1000;
	otST = false;
	otST = oBusca("divActionStatus");

	if (str != "")
	{
	  str += "<br/><table><tr><td><a href=\"javascript:copy_clip(divActionStatus.innerText);\">copiar</a></td><td><a href=\"javascript:estado('');\">cerrar</a></td></tr></table>";
		setTimeout("obj_writeHTML(otST,'')" , t);
 	}
 	else
 	{
		setTimeout("obj_writeHTML(otST,'')" , 0);
	}
	str = "&nbsp;&nbsp;&nbsp;" + str + "&nbsp;&nbsp;&nbsp;";

	if(otST == null)
	{
		 var oDiv=document.createElement("DIV");
		 oDiv.id = "divActionStatus";
		 //oDiv.style.cssText = "position:absolute;visibility:hidden;z-index:99;";
		 document.body.appendChild(oDiv);
		otST = oBusca("divActionStatus");
 	}

	if(otST != null)
	{
	  obj_writeHTML(otST,str);
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 34. Bloque la escritura de Numeros en un INPUT si se ejecuta en el evento onKeyPress
// ejemplo <input type="text" onkeypress="return blockNumbers(event);" />
function blockNumbers(e)
{
	var key;
	var keychar;
	var reg;

	if(window.event) {
		// for IE, e.keyCode or window.event.keyCode can be used
		key = e.keyCode;
	}
	else if(e.which) {
		// netscape
		key = e.which;
	}
	else {
		// no event, so pass through
		return true;
	}

	keychar = String.fromCharCode(key);
	reg = /\d/;
	return !reg.test(keychar);
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 35. Copia el texto de la variable meintext al Clipboard (Portapapeles)
function copy_clip(meintext)
{
	if (window.clipboardData)
   {
		// the IE-manier
		window.clipboardData.setData("Text", meintext);
		// waarschijnlijk niet de beste manier om Moz/NS te detecteren;
		// het is mij echter onbekend vanaf welke versie dit precies werkt:
   }
   else if (window.netscape)
   {
	   // dit is belangrijk maar staat nergens duidelijk vermeld:
	   // you have to sign the code to enable this, or see notes below
	   netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
	   // maak een interface naar het clipboard
	   var clip = Components.classes['@mozilla.org/widget/clipboard;1'].createInstance(Components.interfaces.nsIClipboard);
	   if (!clip) return true;
	   // maak een transferable
	   var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);
	   if (!trans) return true;
	   // specificeer wat voor soort data we op willen halen; text in dit geval
	   trans.addDataFlavor('text/unicode');
	   // om de data uit de transferable te halen hebben we 2 nieuwe objecten nodig   om het in op te slaan
		var str = new Object();
		var len = new Object();
		var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
		var copytext=meintext;
	   str.data=copytext;
	   trans.setTransferData("text/unicode",str,copytext.length*2);
	   var clipid=Components.interfaces.nsIClipboard;
	   if (clip)
			clip.setData(trans,null,clipid.kGlobalClipboard);
	}
	//alert("Following info was copied to your clipboard:\n\n" + meintext);
   return false;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 36.
function isNull(a) { return typeof a == 'object' && !a; }
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 37. Adds a function to the onload event
function addLoadFunction(newFunction)
{
    // If window.onload is a function
	if(typeof window.onload == "function")
	{
    	var previousOnload = window.onload;

	    // New window.onload
		window.onload = function()
		{
			previousOnload();
			newFunction();
		}
	}
	else
	{
		window.onload = newFunction;
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 38. Remove other site's frames
function removeFrames()
{
    // If the page location does not equal the window location
    if(window.self.location.href != window.top.location.href)
    {
        window.top.location.replace(window.self.location.href);
    }
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 39.
function msg_error()
{
 var _err = arguments[0];
 alert("ERROR 911 \n" + _err);
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 40.
function msg_alerta()
{
 var _avs = arguments[0];
 alert("AVISO \n" + _avs);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 41. Ejecuta en el evento onKeyPress
// ejemplo <input type="text" onkeypress="return _onKeyPress(event);" />
function _onKeyPress(e)
{
	var key;
	var keychar;
	var reg;

	if(window.event) {
		// for IE, e.keyCode or window.event.keyCode can be used
		key = e.keyCode;
	}
	else if(e.which) {
		// netscape
		key = e.which;
	}
	else {
		// no event, so pass through
		return true;
	}

	//keychar = String.fromCharCode(key);
	return (key);
}


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 42. Ejecuta en el evento onBlur
// ejemplo <input type="text" onBlur="this.value=formatCurrency(this.value);" />
function formatCurrency(num)
{
  num = num.toString().replace(/\$|\,/g,'');
// EG - 28 Marzo 2006
  if(num.length == 0 )
	{
      return ("");
	}
	else
  {
  if(isNaN(num)) num = "0";
  sign  = (num == (num = Math.abs(num)));
  num   = Math.floor(num*100+0.50000000001);
  cents = num%100;
  num   = Math.floor(num/100).toString();
  if(cents<10)
    cents = "0" + cents;
  for (var i = 0; i < Math.floor((num.length-(1+i))/3); i++)
    num = num.substring(0,num.length-(4*i+3))+','+
  num.substring(num.length-(4*i+3));
  return (((sign)?'':'-') + '$' + num + '.' + cents);
  }
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 43. Ejecuta en el evento onBlur
// ejemplo <input type="text" onBlur="this.value=formatMiles(this.value);" />
function formatMiles(num,cant_dec, showDecCero )
{
// alert(num + "\n\n" +cant_dec);
//alert("975\n" + num.toString().length);
  num = num.toString().replace(/\$|\,/g,'');
// EG - 28 Marzo 2006
  if(num.length == 0 )
	{
		sign = true;
		decs = "";
	}
	else
	{
  if(isNaN(num)) num=0;
// alert(num + "\nedg\n" +cant_dec);

  sign  = (num == (num = Math.abs(num)));
  cant_dec = Math.pow(10,cant_dec);
  num   = Math.floor(num*cant_dec+0.50000000001);
  decs = num%cant_dec;
  num   = Math.floor(num/cant_dec).toString();

	ori_num = num;
//
  if(decs<10)
    decs = "0" + decs;
  for (var i = 0; i < Math.floor((num.length-(1+i))/3); i++)
    num = num.substring(0,num.length-(4*i+3))+','+
  num.substring(num.length-(4*i+3));
  if (decs > 0)
    decs = "." + decs;
  else
   {
// alert(showDecCero);
	 if(showDecCero)
	    decs = ".00"; // decs = ".00"; modified by xButil 8/28/2007 12:49:39 AM
	 else
   	 decs = ""; // decs = ".00"; modified by xButil 8/28/2007 12:49:39 AM
	}
}
// EG - 28 Marzo 2006
  return (((sign)?'':'-') + num + decs);
//	 return ori_num + decs;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 44.
function formatNumero(num)
{
	num = num.toString().replace(/\$|\,/g,'');
// EG - 28 Marzo 2006
	if(num.length == 0 )
	{
		sign = true;
	}
	else
	{
      sign  = (num == (num = Math.abs(num)));
	}
	return (((sign)?'':'-') + num);
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** 45.
 *  Encuentra el Padre HTML de un Objeto, de un tipo definido
 *	 gets nearest parent of specified type
 *	@param obj - (OBJETO) input object
 *	@param tag - (string) tag to find as parent
 *	@returns (objecto). Objeto Padre (including spec. obj) de tipo especificado.
 *	@type privado
*/
function getFirstParentOfType()
{
 var obj = arguments[0];
 var tag = arguments[1];

  if(typeof(obj) == "object")
  {
  	while(obj.tagName!=tag && obj.tagName!="BODY")
  	{
  		obj = obj.parentNode;
  	}
  }
	return obj;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** 46.
 */
function buscarForm()
{
	var sObj = arguments[0];
	var nPos = arguments[1]?arguments[1]:0;
// alert("sO: " + sObj + "\nnPos: " + nPos);
	if( typeof(form_datos) == "object" )
	{
		if( form_datos.length > 0 )
		{
			for(n=0; n<form_datos.length; n++)
			{
				if(trim(form_datos[n][3]) == trim(sObj))
				{
					return (form_datos[n][nPos]);
				}
			}
		}
	}

	switch(nPos)
	{
		case 6:
			return sObj.replace("oSel", "oWinSel");
		break;
	}

return "";
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** 47. FUNCIONES DE DEPURACION
 * 2007-09-05 egonpin@gmail.com
 */
function depuraArgs(sArgs)
{
	var tA = StringtoArray(sArgs,separador_reg);
	var cad = new String();
	var tP = 0;
	var tD = "";

	for(n=0; n < tA.length; n++)
	{
	   tA[n] = StringtoArray(tA[n],separador_col);
	   
	   cad += tA[n] + "\n\n";
	   tD += tA[n] + "\n\n";
	   if(tP != tA[n][0] )
	   {
		   alert(tD);
		   tD = "";
		   tP = tA[n][0];
	   }
	}
   alert(tD);
	alert(cad);
}

////////////////////////////////////////////////////////////////////////////////
/** 49. Estados del Sistema
 * 2008-03-17 egonpin@gmail.com
 */
function EstadoSistema(txt)
{
 var oAnun = oBusca("axysDivEstado");

 if(!oAnun)
 {
   var oNew = document.createElement("div");
	oNew.id = "axysDivEstado";
	oNew.className = "cEstado";

	oBusca("divMenu").appendChild(oNew);
	oBusca("axysDivEstado").className = "cEstado";

	oAnun = oBusca("axysDivEstado");
	var sHtm = "";
	sHtm += "";
	obj_writeHTML(oAnun, sHtm);
 }

 if(oAnun)
 {
	if(txt.length >0)
	{
		obj_writeHTML(oAnun, "Estado Formulario: <b>"+txt+"</b>");
	}
	else
	{
		obj_writeHTML(oAnun, "");
	}
 }
}
