//
// ---------------------------------------------------------------------- //
//                             RESUMEN                                    //
// ---------------------------------------------------------------------- //
// 
// El objetivo de las siguientes funciones en JavaScript es
// validar los datos que ingrese el usuario en un formulario antes
// de que estos datos vayan al servidor.
//
// Varias de ellas toman un parametro opcional E.O.K (eok) (emptyOK
// - true si se acepta que el valor este vacio, false si no
// se acepta). El valor por omision es el que indique la
// variable global defaultEmptyOK definida mas abajo.
//
// Esta variable indica si está bien dejar las casillas
// en blanco como regla general
//
// --------------------------------------------------------------------------------------------------- //
//                                       LISTA DE FUNCIONES                                            //
// --------------------------------------------------------------------------------------------------- //
//                                                                                                     //
//  FUNCIONES DE MANEJO Y CONTROL:                                                                     //
//                                                                                                     //
//  esEntero (S)       -->  Verifica si S es un Numero Entero (Sin Decimales)                          //
//  esNumero (S)       -->  Verifica si S es un Numero Cualquiera                                      //
//  esAlfabetico (S)   -->  Verifica si S es un string de tipo Alfabetico (A - Z) o (a - z)            //
//  esAlfanumerico (S) -->  Verifica si S es un string de tipo Alfabetico y/o Numerico                 //
//  esNumeroTel (S)    -->  Verifica si S es un string del tipo Alfanumerico con caracteres especiales //
//  esColor (S)    		 -->  Verifica si S es un '#' + Numero Hexadecimal (0123456789ABCDEF)            //
//  esHexadecimal (S)  -->  Verifica si S es un Numero Hexadecimal (0123456789ABCDEF)                  //
//  esEmail (S)        -->  Verifica si S es un string de tipo Alfanumerico con formato de E-Mail      //
//  esFecha (S)        -->  Verifica si S es una Fecha en el formato valido del formulario             //
//                                                                                                     //
// FUNCIONES INTERNAS:                                                                                 //
//                                                                                                     //
// esEmpty (S)                  -->  S es vacio o solo son espacios                                    //
// esLetra (C)                  -->  C es una letra                                                    //
// esDigito (C)                 -->  C es un digito                                                    //
// esLetraODigito (C)           -->  C es letra o digito                                               //
//                                                                                                     //
// FUNCIONES PARA REFORMATEAR DATOS:                                                                   //
//                                                                                                     //
// stripCharsInBag (S, bag)     -->   quita de S los caracteres en bag                                 //
// stripCharsNotInBag (S, bag)  -->   quita de S los caracteres NO en bag                              //
//                                                                                                     //
// FUNCIONES PARA PREGUNTARLE AL USUARIO:                                                              //
//                                                                                                     //
// statBar (S)                  -->   pone S en la barra de estado                                     //
// warnEmpty (elCampo, S)       -->   indica que elCampo esta vacio                                    //
// warnInvalid (elCampo, S)     -->   indica que elCampo es invalido                                   //
//                                                                                                     //
//                                                                                                     //
// --------------------------------------------------------------------------------------------------- //
//                            LISTA DE ERRORES NUMERICOS [function checkCampo()]                       //
// --------------------------------------------------------------------------------------------------- //
// Lista de codigos de error que el validador retorna                                                  //
//                                                                                                     //
//  0 = Ok. Sin errores                                                                                //
// -1 = El campo esta vacio, y es obligatorio                                                          //
// -2 = El campo contiene errores                                                                      //
//                                                                                                     //
// --------------------------------------------------------------------------------------------------- //

var defaultEmptyOK = false

// Esta variable indica si se debe verificar la presencia de comillas
// u otros símbolos extraños en un campo, por omisión no, porque
// siempre crea problemas con las bases de datos o programas CGI
var checkNiceness = true;

// listas de caracteres
var Digitos = "0123456789";
//var LetrasMinusculas = " abcdefghijklmnopqrstuvwxyzáéíóúñü";
//var LetrasMayusculas = " ABCDEFGHIJKLMNOPQRSTUVWXYZÁÉÍÓÚÑÜ";
var LetrasMinusculas = " abcdefghijklmnopqrstuvwxyz";
var LetrasMayusculas = " ABCDEFGHIJKLMNOPQRSTUVWXYZ";
var CaracteresEspeciales = " \t\n\r";

// caracteres admitidos en Nros de telefono
var CaracteresTelefono = "()-+ ";
// caracteres admitidos en los Nros Hexadecimales
var CaracteresHexadecimal = "ABCDEFabcdef0123456789";

// formato de fecha del sistema
var fmt_date = fmt_date ? fmt_date : 'yyyy-mm-dd';

// ---------------------------------------------------------------------- //
//                     TEXTOS PARA LOS MENSAJES                           //
// ---------------------------------------------------------------------- //

// m abrevia "missing" (faltante)
var mMessageBS = "ATENCI&Oacute;N !!!... Los campos en ROJO son de caracter OBLIGATORIO, por lo tanto, NO se deben dejar en blanco."
var mMessage   = "ATENCI&Oacute;N !!!... Este campo es OBLIGATORIO";
var mMessage2  = "ATENCI&Oacute;N !!!... Faltan campos OBLIGATORIOS";
// p abrevia "prompt"
var pPrompt       = "ERROR: ";
var pAlfanumerico = " Ingrese un texto que contenga solo letras y/o n&uacute;meros";
var pAlfabetico   = " Ingrese un texto que contenga solo letras";
var pEntero       = " Ingrese un n&uacute;mero entero";
var pNumero       = " Ingrese un n&uacute;mero";
var pNumeroTel    = " Ingrese un n&uacute;mero de tel&eacute;fono";
var pEmail        = " Ingrese una direcci&oacute;n de correo electr&oacute;nico v&aacute;lida";
var pNombre       = " Ingrese un texto que contenga solo letras, n&uacute;meros o espacios";
var pNice         = " No puede utilizar comillas aqu&iacute;";
var pColor        = " No es n&uacute;mero de color v&aacute;lido";
var pHexadecimal  = " No es n&uacute;mero Hexadecimal v&aacute;lido";

// ---------------------------------------------------------------------- //
//                FUNCIONES PARA MANEJO DE ARREGLOS                       //
// ---------------------------------------------------------------------- //

function HecerArray(n)
{
//*** BUG: If I put this line in, I get two error messages:
//(1) Window.length can't be set by assignment
//(2) daysInMonth has no property indexed by 4
//If I leave it out, the code works fine.
//   this.length = n;
   for (var i = 1; i <= n; i++) 
   {
      this[i] = 0
   }
   return this
}

// ---------------------------------------------------------------------- //
//                  CODIGO PARA FUNCIONES BASICAS                         //
// ---------------------------------------------------------------------- //


// s es vacio
function esEmpty(s)
{   
    return ((s == null) || (s.length == 0))
}

// s es vacio o solo caracteres de espacio
function esCaracteresEspeciales (s)
{   
    var i;
    if (esEmpty(s)) 
       return true;
    for (i = 0; i < s.length; i++)
    {
        var c = s.charAt(i);
        // si el caracter en que estoy no aparece en CaracteresEspeciales,
        // entonces retornar falso
        if (CaracteresEspeciales.indexOf(c) == -1) return false;
    }
    return true;
}

// Quita todos los caracteres que que estan en "bag" del string "s" s.
function stripCharsInBag (s, bag)
{   
    var i;
    var returnString = "";

    // Buscar por el string, si el caracter no esta en "bag",
    // agregarlo a returnString

    for (i = 0; i < s.length; i++)
    {   
        var c = s.charAt(i);
        if (bag.indexOf(c) == -1) returnString += c;
    }

    return returnString;
}

// Lo contrario, quitar todos los caracteres que no estan en "bag" de "s"
function stripCharsNotInBag (s, bag)
{   
    var i;
    var returnString = "";
    for (i = 0; i < s.length; i++)
    {
        var c = s.charAt(i);
        if (bag.indexOf(c) != -1) returnString += c;
    }
    return returnString;
}

// Quitar todos los espacios en blanco de un string
function stripCaracteresEspeciales (s)
{   
    return stripCharsInBag (s, CaracteresEspeciales)
}

function charEnString (c, s)
{   
    for (i = 0; i < s.length; i++)
    {   
        if (s.charAt(i) == c) return true;
    }
    return false
}

// Quita todos los espacios que antecedan al string
function stripInicialCaracteresEspeciales (s)
{   
    var i = 0;
    while ((i < s.length) && charEnString (s.charAt(i), CaracteresEspeciales))
       i++;
    return s.substring (i, s.length);
}

// c es una letra del alfabeto espanol
function esLetra (c)
{
    return( ( LetrasMayusculas.indexOf( c ) != -1 ) || ( LetrasMinusculas.indexOf( c ) != -1 ) )
}

// c es un Numero Hexadecimal
function esCaracterHexadecimal (c)
{
    return( CaracteresHexadecimal.indexOf( c ) != -1 )
    //return( ( CaracteresHexadecimal.indexOf( c ) != -1 ) || ( CaracteresHexadecimal.indexOf( c ) != -1 ) )
}

// c es un digito
function esDigito (c)
{   
    return ((c >= "0") && (c <= "9"))
}

// c es letra o digito
function esLetraODigito (c)
{   
    return (esLetra(c) || esDigito(c))
}


// ====================================================================== //
//                 Funciones de Validacion de Campos                      //
// ====================================================================== //

// ---------------------------------------------------------------------- //
//                          NO VALIDAR                                    //
// ---------------------------------------------------------------------- //

// No valida el contenido del campo
function noValidar ()
{
  return true;
}


// ---------------------------------------------------------------------- //
//                          NUMEROS                                       //
// ---------------------------------------------------------------------- //

// s es un numero entero (con o sin signo)
function esEntero (s)
{   
    var i;
    if (esEmpty(s))
       if (esEntero.arguments.length == 1) 
           return defaultEmptyOK;
       else 
           return (esEntero.arguments[1] == true);
    
    for (i = 0; i < s.length; i++)
    {   
        var c = s.charAt(i);
        if( i != 0 ) 
        {
            if (!esDigito(c)) 
                return false;
        } 
        else 
        {
            if (!esDigito(c) && (c != "-") || (c == "+")) 
                return false;
        }
    }
    return true;
}

// s es un numero (entero o flotante, con o sin signo)
function esNumero (s)
{   
    var i;
    var dotAppeared;
    dotAppeared = false;
    if (esEmpty(s))
       if (esNumero.arguments.length == 1) 
           return defaultEmptyOK;
       else 
           return (esNumero.arguments[1] == true);
    for (i = 0; i < s.length; i++)
    {   
        var c = s.charAt(i);
        if( i != 0 )
        {
            if ( c == "." )
            {
                if( !dotAppeared )
                    dotAppeared = true;
                else
                    return false;
            }
            else
               if (!esDigito(c))
                   return false;
        }
        else
        {
            if ( c == "." )
            {
                if( !dotAppeared )
                    dotAppeared = true;
                else
                    return false;
            }
            else
                if (!esDigito(c) && (c != "-") || (c == "+"))
                    return false;
        }
    }
    return true;
}

// ---------------------------------------------------------------------- //
//                        STRINGS SIMPLES                                 //
// ---------------------------------------------------------------------- //

// s tiene solo letras
function esAlfabetico (s)
{   
    var i;

    if (esEmpty(s))
       if (esAlfabetico.arguments.length == 1) 
           return defaultEmptyOK;
       else 
           return (esAlfabetico.arguments[1] == true);
    for (i = 0; i < s.length; i++)
    {   
        // Check that current character is letter.
        var c = s.charAt(i);
        if (!esLetra(c))
        return false;
    }
    return true;
}

// s tiene solo letras y numeros
function esAlfanumerico (s)
{   
    if (esEmpty(s))
       if (esAlfanumerico.arguments.length == 1) 
          return defaultEmptyOK;
       else 
          return (esAlfanumerico.arguments[1] == true);

    for (i = 0; i < s.length; i++)
    {   
        var c = s.charAt(i);
        if (! (esLetra(c) || esDigito(c) ) )
            return false;
    }
    return true;
}

// s tiene solo letras, numeros o espacios en blanco
function esNombre (s)
{
    if (esEmpty(s))
       if (esNombre.arguments.length == 1)
          return defaultEmptyOK;
       else 
          return (esAlfanumerico.arguments[1] == true);
    return( esAlfanumerico( stripCharsInBag(s, CaracteresEspeciales)));
}

// ---------------------------------------------------------------------- //
//                               COLOR                                    //
// ---------------------------------------------------------------------- //

// s es un color hexadecimal valido
function esColor (s)
{
    var i;

    if (esEmpty(s))
       if (esColor.arguments.length == 1)
           return defaultEmptyOK;
       else
           return (esColor.arguments[1] == true);

    // Check that first character is '#'.
    var c = s.charAt(0);
		if (c != '#')
      return false;

    for (i = 1; i < s.length; i++)
    {
			var c = s.charAt(i);
    	// Check that current character is Hexadecimal.
      if (!esCaracterHexadecimal(c))
      	return false;
    }
    return true;
}

// ---------------------------------------------------------------------- //
//                               HEXADECIMAL                              //
// ---------------------------------------------------------------------- //

// s es un numero hexadecimal valido
function esHexadecimal (s)
{
    var i;

    if (esEmpty(s))
       if (esHexadecimal.arguments.length == 1)
           return defaultEmptyOK;
       else
           return (esHexadecimal.arguments[1] == true);

    for (i = 0; i < s.length; i++)
    {
			var c = s.charAt(i);
    	// Check that current character is Hexadecimal.
      if (!esCaracterHexadecimal(c))
      	return false;
    }
    return true;
}

// ---------------------------------------------------------------------- //
//                           FONO o EMAIL                                 //
// ---------------------------------------------------------------------- //

// s es numero de telefono valido
function esNumeroTel (s)
{   
    var modString;
    if (esEmpty(s))
       if (esNumeroTel.arguments.length == 1) 
           return defaultEmptyOK;
       else 
           return (esNumeroTel.arguments[1] == true);
    modString = stripCharsInBag(s, CaracteresTelefono);
    return (esEntero(modString))
}

// s es una direccion de correo valida
function esEmail (s)
{
    if (esEmpty(s))
       if (esEmail.arguments.length == 1) 
           return defaultEmptyOK;
       else 
           return (esEmail.arguments[1] == true);
    if (esCaracteresEspeciales(s)) 
       return false;
    var i = 1;
    var sLength = s.length;
    while ((i < sLength) && (s.charAt(i) != "@"))
    { 
        i++
    }
    if ((i >= sLength) || (s.charAt(i) != "@")) 
        return false;
    else 
        i += 2;
    while ((i < sLength) && (s.charAt(i) != "."))
    { 
        i++
    }
    if ((i >= sLength - 1) || (s.charAt(i) != ".")) 
        return false;
    else 
        return true;
}

function esComillas(s)
{
        var i = 1;
        var sLength = s.length;
        var b = 1;
        while(i<sLength) 
        {
            if( (s.charAt(i) == "\"") || (s.charAt(i) == "'" ) )
                b = 0;
            i++;
        }
        return b;
}

// ---------------------------------------------------------------------- //
//                  FUNCIONES PARA RECLAMARLE AL USUARIO                  //
// ---------------------------------------------------------------------- //

// pone el string s en la barra de estado
function statBar (s)
{
	window.status = s
}

// notificar que el campo elCampo esta vacio
function warnEmpty (elCampo)
{
	var campo_mensaje;
	var oMensaje;
	var oGridSB;

	if (elCampo.className.indexOf('igx') != -1)
	{
      //elCampo.className = elCampo.className.replace("igxInputRO", "igxInputErr");
      //elCampo.className = "igxInputErr";
      elCampo.style.background = "red";
      oGridSB = "igxSB_"+elCampo.id.substr(0,elCampo.id.indexOf('_xx_'));
      //campo_mensaje = "igxMsg_"+elCampo.id;
      oMensaje = oBusca(oGridSB);
      oMensaje.className = "igxMsgErr";
	}
	else
	{
      elCampo.className = "ibxInputErr";
      campo_mensaje = "ibxMsg_"+elCampo.id;
      oMensaje = oBusca(campo_mensaje);
      oMensaje.className = "ibxMsgErr";
  }
  obj_writeHTML(oMensaje, mMessage);
  statBar(mMessageBS);
  //return false;
  return -1;
}

// notificar que el campo elCampo es invalido
function warnInvalid (elCampo, s)
{
	var campo_mensaje;
	var oMensaje;
	var oGridSB;

	if (elCampo.className.indexOf('igx') != -1)
	{
    elCampo.style.background = "red";
    //elCampo.className = "igxInputErr";
		oGridSB = "igxSB_"+elCampo.id.substr(0,elCampo.id.indexOf('_xx_'));
    oMensaje = oBusca(oGridSB);
    oMensaje.className = "igxMsgErr";
	}
	else
	{
      //elCampo.className = elCampo.className.replace("ibxInput", "ibxInputErr");
      //elCampo.className = elCampo.className.replace("ibxInputRO", "ibxInputErr");
      elCampo.className = "ibxInputErr";
      campo_mensaje = "ibxMsg_"+elCampo.id;
      oMensaje = oBusca(campo_mensaje);
      oMensaje.className = "ibxMsgErr";
	}
	obj_writeHTML(oMensaje,(pPrompt + s));
	statBar(pPrompt + s);
	//return false;
	return -2;
}

// el corazon de todo: checkCampo
function checkCampo(elCampo, LaFuncion, emptyOK, s)
{
	var msg;
	var campo_mensaje;
	var oMensaje;
	var prefijo_campo = "ibx";

	elCampo.className = elCampo.className.replace("Err", "");

	if (elCampo.className.indexOf("igx") != -1)
      prefijo_campo = "igx";

	if (checkCampo.arguments.length == 1)
	{
      statBar("Dato Correcto");
	if (elCampo.className.indexOf("igx") == -1)
      elCampo.className = prefijo_campo+"Input";
      campo_mensaje = prefijo_campo+"Msg_"+elCampo.id;
      oMensaje = oBusca(campo_mensaje);
      oMensaje.className = prefijo_campo+"Msg";
      return 0;
	}
	else
	{
      if (checkCampo.arguments.length < 3) 
          emptyOK = defaultEmptyOK;
      if (checkCampo.arguments.length == 4)
      {
          msg = s;
      }
      else
      {
          if( LaFuncion == esAlfabetico )   msg = pAlfabetico;
          if( LaFuncion == esAlfanumerico ) msg = pAlfanumerico;
          if( LaFuncion == esEntero )       msg = pEntero;
          if( LaFuncion == esNumero )       msg = pNumero;
          if( LaFuncion == esEmail )        msg = pEmail;
          if( LaFuncion == esNumeroTel )    msg = pNumeroTel;
          if( LaFuncion == esNombre )       msg = pNombre;
          if( LaFuncion == esColor )        msg = pColor;
          if( LaFuncion == esHexadecimal)   msg = pHexadecimal;
      }
  
      if ((emptyOK == true) && (esEmpty(elCampo.value)))
      {
      	statBar("Dato Correcto");
			if (elCampo.className != prefijo_campo+"InputRO")
			{
	          if (elCampo.className.indexOf("igx") == -1)
			 	elCampo.className = prefijo_campo+"Input";
			}
			campo_mensaje = prefijo_campo+"Msg_"+elCampo.id;
			oMensaje = oBusca(campo_mensaje);
			oMensaje.className = prefijo_campo+"Msg";
			obj_writeHTML(oMensaje,"");
			//return true;
			return 0;
      }
  
      if ((emptyOK == false) && (esEmpty(elCampo.value)))
      {
 			return warnEmpty(elCampo);
		}
  
      if ( checkNiceness && !esComillas(elCampo.value))
			return warnInvalid(elCampo, pNice);
  
      if (LaFuncion(elCampo.value) == true)
		{
			statBar("Dato Correcto");
			if (elCampo.className.match("InputRO") == null)
			{
	    	if( LaFuncion == esColor )
			{
 				if (elCampo.className.indexOf("igx") == -1)
					elCampo.className = elCampo.className.replace("InputRO", prefijo_campo+"InputCP");
			}
			else
		   	{
				if (elCampo.className.indexOf("igx") == -1)
		   			elCampo.className = elCampo.className.replace("InputRO", prefijo_campo+"Input");
			}
		}
        campo_mensaje = prefijo_campo+"Msg_"+elCampo.id;
        oMensaje = oBusca(campo_mensaje);
        oMensaje.className = prefijo_campo+"Msg";
        obj_writeHTML(oMensaje,"");
        //return true;
        return 0;
      }
		else
			return warnInvalid(elCampo, msg);
	}
}
