/** @var _aGrid
 *  (ARRAY) Coleccion de Grids (PUBLICO) */
var _aGrid = new Array();
/** @var dirLibsPHP
 *  Variable Global Directorio de Instalación */
var dirLibsPHP = (dirLibsPHP)?dirLibsPHP:new String("/axys_comun/libs");
/** _oGrilla
 * @constructor
 * @see grillaData
 *  1. Objeto Fundamental _oGrilla */
function _oGrilla()
{
	this.id 				= new String("igx_"); /**< Id General del Objeto (R/W) */
	this.cant_filas  	= new Number(1);
	this.nom_tabla   	= new String(""); // Nombre de la Grilla, funciona como nombre de la tabla para grid_db
	this.campos      	= new Array();
	this.pk        	= new String(""); // Nombre del Primary Key (R/W)
	this.filtro      	= new String(""); // Filtro que se usara como parte del Where
	this.data        	= new Array();   // Array que guarda los datos de la Grilla y controla los registros
	this._found      	= new Array(2);  // Array que se llena con la Fila y la Columna que se encuentre con la funcion buscaInput
	this._nom_obj    	= new String(""); // nombre del Objeto puro
	this.init        	= _initGrilla; // Inicializa el objeto
	this.muestra  	  	= _muestra_Grid; // Metodo para mostrar las partes del componente (W)
	this.oculta 	  	= _Oculta_Grid;  // Metodo para ocultar las partes del componente (W)
	this.insFila      = _insFila_Grid; // Metodo para insertar una Fila (W)
	this.buscaInput   = _buscaInput_Grid; // Metodo para Buscar un Input dentro del Control
	this.BuscaFila    = _BuscaFila_Grid; // Metodo para Buscar una Fila en el Control Proc. # 34
	this.buscaColumna = _buscaColumna_Grid; // Metodo para Buscar una Columna en el Control Proc. # 36
	this.delFila 	   = _delFila_Grid; // Metodo para Marcar una Fila para ser Borrada
	this.selecFila    = _selecFila_Grid; // Metodo para Marcar una Fila para Seleccion
	this._igualaRD    = _igualaRowID_data_Grid; // Metodo para igualar el ROWID con el Tam DATA (W)
	this.onchangeData = _cambiaData_Grid;  // Proc. # 21
	this.vaciar       = _vaciar_Grid;  // Metodo para dejar la Grid en Blanco
	this.idTB 			= new String("igxTB_"); // Id de la Botonera (R)
	this.idGrid 		= new String("igxGrid_"); // Id que contiene Titulos y Datos (R)
	this.idT 			= new String("igxT_"); // Id de la Tabla de Titulos (R)
	this.idD   			= new String("igxD_"); // Id de la Tabla de Datos (R)
	this.idSB  			= new String("igxSB_"); // Id de la Tabla de Datos (R)
	this.idROWIDs  	= new String("igxROWIDs_"); // Id del DIV de ID`s (R)
	this.idROWID   	= new String("igxROWID_"); // Id de la TABLE de ID`s (R)
	this.nodeName   	= new String("GRILLA");
	this.visCTRL 		= new Number(1); // Visibilidad del Control (R)
	this.visTB 			= new Number(1); // Visibilidad de la Botonera (R)
	this.visGRID   	= new Number(1); // Visibilidad del Grid (R)
	this.visT 			= new Number(1); // Visibilidad de los Titulos de Grid (R)
	this.visD 			= new Number(1); // Visibilidad de los Datos de Grid (R)
	this.visSB 			= new Number(1); // Visibilidad de la Status Bar (R)
	this.visROWIDs 	= new Number(1); // Visibilidad del ROWID (R)
	this.oDES      	= null; // Objeto Destino HTML del Control (R)
	this.oTB       	= null; // Objeto Destino HTML de la ToolBar (R)
	this.oGRID     	= null; // Objeto Destino HTML del GRID (R)
	this.oT        	= null; // Objeto Destino HTML de los Titulos del Grid (R)
	this.oD        	= null; // Objeto Destino HTML de los Datos del Grid (R)
	this.oSB       	= null; // Objeto Destino HTML de la StatusBar (R)
	this.oROWIDs   	= null; // Objeto Destino HTML de los RowIds (R)
	this.oROWID    	= null; // Objeto Destino HTML de RowId (R)
	this.hModFila  	= new Array(); // Modelo de Fila
	this.llenadoSQL   = new _ollenadoSQL_Grid; // Objeto Proc. # 17
	this.carac_data 	= new _ogrillaData_Grid; // Objeto Data que contiene las caracteristicas del data - Proc. # 22
	this.enlaceOtros  = new _oenlaceOtros_Grid; // Objeto Proc. # 23
	// Evento para despues de ejecutar
	this.eafter_ejecutar = _fafter_ejecutar_Grid; // Proc. # 30
	this.eva_ejecutar = new String("");
	// Constantes de Control de Estado
	this.ke 				= new _kEstado_Grid; // Objeto de constantes Proc. # 74
	// Cadenas de Guardado
	this.posFG 			= null;
	this.Args0 			= new String("");
	this.Args3 			= new String("");
	this.aColumnas 	= new Array();
	this.aTipoCols 	= new Array();
	this.genCadGuardar 	= _generaCadenaGuardar_Grid; // Proc. # 32
	this.genDataJson 	= _generaCadenaDataJS_Grid; // Proc. # 37
	// La siguiente linea se debe poner a en false para Produccion
	this.Depura 		= false;
	this.DataDepura 	= _depura_data_Grid; // Proc. # 33
	// 06-11-2007 EG
	this.llenadoMAN   = _ejecutar_llenadoMANUAL_Grid; // Proc. # 35
}
/** @fn oGrid
 *  2. Objeto Fundamental oGrid (PUBLICA)
 * @param _nombre - (STRING) Identificador del Objeto
 * @return  tmpOBJ - (Objeto) _oGrilla
*/
function oGrid()
{
	var _nombre = arguments[0].replace(".", "__");
  var tmpOBJ 	= new _oGrilla();
  var n = null;
  var tmpCell = null;
	tmpOBJ.id 		  = "igx_"       + _nombre;
	tmpOBJ.idTB 	  = "igxTB_"     + _nombre;
	tmpOBJ.idGrid   = "igxGrid_"   + _nombre;
	tmpOBJ.idT 		  = "igxT_"      + _nombre;
	tmpOBJ.idD 		  = "igxD_"      + _nombre;
	tmpOBJ.idSB 	  = "igxSB_"     + _nombre;
	tmpOBJ.idROWIDs = "igxROWIDs_" + _nombre;
	tmpOBJ.idROWID  = "igxROWID_"  + _nombre;
	tmpOBJ._nom_obj   = _nombre;
	tmpOBJ.nom_tabla  = arguments[0];
  tmpOBJ.oDES 	= oBusca(tmpOBJ.id);
  tmpOBJ.oTB 		= oBusca(tmpOBJ.idTB);
	tmpOBJ.oGRID 	= oBusca(tmpOBJ.idGrid);
  tmpOBJ.oT 		= oBusca(tmpOBJ.idT);
  tmpOBJ.oD 		= oBusca(tmpOBJ.idD);
  tmpOBJ.oSB 		= oBusca(tmpOBJ.idSB);
	tmpOBJ.oROWIDs = oBusca(tmpOBJ.idROWIDs);
	tmpOBJ.oROWID 	= oBusca(tmpOBJ.idROWID);
	if(tmpOBJ.oD.rows.length >= 1)
	{
		var tmpCell = tmpOBJ.oD.rows[0].cells;
		for(n=0; n<tmpCell.length; n++)
		{
   		tmpOBJ.hModFila.push(tmpCell[n].innerHTML);
		}
      tmpOBJ.oD.deleteRow(0);
	}
	_aGrid.push(tmpOBJ);
	return tmpOBJ;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  3. - Muestra las partes del componente
 *      Recibe 1 parametro, nombre de la parte
 * @param _parte - (STRING)
 *     'SB' - Barra de Estado, 'D' - Datos del Grid, 'T' - Titulos del Grid, 'GRID' - Titulos y Datos, 'TB' - ToolBar, 'CTRL' - Control Total
 *
 * @see _Oculta
 * @author EG - (egonpin@gmail.com) - 27/05/2005 - 15/05/2006
 */
function _muestra_Grid()
{
	var _parte = arguments[0];
	switch(_parte)
	{
		case 'SB':
		  obj_show(this.oSB);
		  this.visSB = 1;
		break;
		case 'D':
		  obj_show(this.oD);
		  this.visD = 1;
		break;
		case 'T':
		  obj_show(this.oT);
		  this.visT = 1;
		break;
		case 'GRID':
		  obj_show(this.oGRID);
		  this.visGRID = 1;
		break;
		case 'TB':
		  obj_show(this.oTB);
		  this.visTB = 1;
		break;
		case 'CTRL':
		  obj_show(this.oDES);
		  this.visCTRL = 1;
		break;
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  4. - Oculta las partes del componente
 *      Recibe 1 parametro, nombre de la parte
 * @param _parte - (STRING)
 *     'SB' - Barra de Estado, 'D' - Datos del Grid, 'T' - Titulos del Grid, 'GRID' - Titulos y Datos, 'TB' - ToolBar, 'CTRL' - Control Total
 *
 * @see _muestra
 * @author EG - (egonpin@gmail.com) - 27/05/2005 - 15/05/2006
 */
function _Oculta_Grid()
{
	var _parte = arguments[0];
	switch(_parte)
	{
		case 'SB':
		  obj_hide(this.oSB);
		  this.visSB = 0;
		break;
		case 'D':
		  obj_hide(this.oD);
		  this.visD = 0;
		break;
		case 'T':
		  obj_hide(this.oT);
		  this.visT = 0;
		break;
		case 'GRID':
		  obj_hide(this.oGRID);
		  this.visGRID = 0;
		break;
		case 'TB':
		  obj_hide(this.oTB);
		  this.visTB = 0;
		break;
		case 'CTRL':
		  obj_hide(this.oDES);
		  this.visCTRL = 0;
		break;
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  5. - Inserta Fila
 *       Inserta #n de Filas en la posisicion inidicada
 * @param _cant - [ NUMBER ]
 *       Numero de filas a Insertar
 * @param _posicion - [ NUMBER ]
 *      posicion en la que inserta, si esta vacio inserta al final de la tabla,
 *       si se le manda un numero inserta antes de dicha posicion
 * @param _1eraVez - [ STRING ]
 *       Usado solo por las funciones init, parametro interno
 * @see
 * @author EG - (egonpin@gmail.com) - 15/05/2006
 */
function _insFila_Grid()
{
	var _cant 		 = arguments[0]?arguments[0]:1;
	var _posicion  = arguments[1]?arguments[1]:-1;
	var _1eraVez 	 = arguments[2]?true:false;
	var _nom_tabla_aux = this.nom_tabla.replace(".", "__");
	var _array_aux3 = new Array();
	// var _estado = 0; // Registro Nulo
	var ori_pos = _posicion;
	var n = null;
	var m = null;
	var _array_aux1 = null;
	var _array_aux2 = null;
	var new_num = null;
	var _tmpFila = null;
	var _tmpCell = null;
	var _id = null;
	var InN = null;
// if(this.data.length -1 >= 0) alert( this.data[this.data.length -1][0] +" == "+ this.ke.Nulo );
	if( this.data.length && (this.data[this.data.length -1][0] == this.ke.Nulo) ) // Registro Nulo
 	{
		msg_error("El ultimo registro es Nulo");
	}
 	else
	{
		for(n=0; n<_cant; n++)
		{
			_array_aux1 = new Array ();
			// Busca el siguiente ID que se pueda usar
			new_num = this.carac_data.num_reg + 1;
			if(this.carac_data.num_reg >= (n+1)) { new_num = this.carac_data.num_reg + n + 1; }
			else { new_num = n + 1; }
//       InN = this.data.length == 0 ? 1 : this.data.length + 1;
      InN = this.data.length == 0 ? 1 : new_num;
			if(_posicion != -1 ) _posicion += n;
			_tmpFila = this.oD.insertRow( _posicion );
			for(m=0; m<this.hModFila.length; m++)
			{
				_tmpCell = _tmpFila.insertCell(-1);
				_id = _nom_tabla_aux + "_xx_" + (InN ) + "_yy_" + this.campos[m];
				_tmpCell.innerHTML = this.hModFila[m].replace(/_xx_1_yy_/g, ("_xx_" + (InN ) + "_yy_") );
				// added by xButil 2006-05-25 12:07:44 p.m.
				// Cuadra el tamaño inicial de las celdas de las columnas al mismo tamaño de las de los titulos
				// *** Solo Firefox --- oBusca(_id).style.width = oBusca(_nom_tabla_aux + "_xx_0_yy_" + this.campos[m]).clientWidth;
				// *** Nombre estandar de la Clase que asigna el tamaño y propiedades adicionales a cada columna ***
				oBusca(_id).className = oBusca(_id).className + " igxCol_" + _nom_tabla_aux + "__" + this.campos[m];
        _tmpCell.className = 'igxCeldas';
				if(this.carac_data.num_reg < new_num)
					this.carac_data.num_reg = new_num;
				_array_aux2 = new Array (_id, 0, this.campos[m]);
   	    _array_aux1.push(_array_aux2);
			}
			_array_aux3.push( new Array(this.ke.Nulo, _array_aux1, false, InN) );
		}
		// Agrega a Data JS
		if(ori_pos != -1 )
		{
			for(n=0; n<_array_aux3.length; n++)
			{
				this.data.splice((ori_pos+n),0,_array_aux3[n]);
			}
		}
		else
		{
			for(n=0; n<_array_aux3.length; n++)
			{
				this.data.push(_array_aux3[n]);
			}
		}
	}
   this._igualaRD(_1eraVez);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  6. - Inicializa el Objeto
 *
 * @see _oGrilla, oGrid
 * @author EG - xButil - (egonpin@gmail.com - xbutil@gmail.com) - 18/05/2006
 */
function _initGrilla()
{
	this.llenadoSQL.init(this);
	this.carac_data.init(this);
	this.enlaceOtros.init(this);
	this.insFila(this.cant_filas, -1, "1eraVez");
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  7. - Organiza visualmente el Objeto
 *
 * @author xButil - (xbutil@gmail.com) - 19/05/2006
 */
function _maquillaGrilla()
{
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  8. - Iguala el ROWID tabla con el Tamaño del DATA
 *
 * @see _eClick_Grid
 * @author EG - (egonpin@gmail.com) - 19/05/2006
 */
function _igualaRowID_data_Grid()
{
	var _1eravez = arguments[0]?true:false;
	var n = null;
	var _Resta = null;
	var _LastV = null;
	var _tmpR = null;
	var _tmpC = null;
	if(_1eravez)
	{
		for( n=(this.oROWID.rows.length - 1); n>=0; n-- )
		{
			this.oROWID.deleteRow(n);
		}
	}
	if(this.oROWID.rows.length < this.oD.rows.length)
	{
		_Resta = this.oD.rows.length - this.oROWID.rows.length;
    _LastV = 0;
		if(this.oROWID.rows.length > 0)
		{
// 			_LastV = eval(this.oROWID.rows[this.oROWID.rows.length-1].cells[0].innerHTML);
			_LastV = this.cant_filas;
		}
		for(n=1; n<= _Resta; n++ )
		{
			_tmpR = this.oROWID.insertRow(-1);
			_tmpC = _tmpR.insertCell(-1);
			_tmpC.innerHTML = (_LastV + n);
			_tmpC.className = "igxROWID";
			_tmpC.onclick = new Function("e","pGrilla","_eClick_Grid(e||window.event,'" + this.id + "')");
		}
	}
	// Iguala la cantidad de Filas de La Tabla de Datos con las Filas de la Tabla de ROWID
	if(this.oROWID.rows.length > this.oD.rows.length)
	{
		_Resta = this.oROWID.rows.length - this.oD.rows.length;
		for( n=0; n<_Resta; n++ )
		{
			if (this.oROWID.rows.length > 0)
				this.oROWID.deleteRow(this.oROWID.rows.length - 1);
		}
	}
	this.cant_filas = this.oROWID.rows.length;
	// Added by xBUTIL 2006-07-26 10:01:15 p.m.
	// corrige el numero de filas en el array [carac_data]
	this.carac_data.regs = this.oROWID.rows.length;
	this.oSB.innerHTML = "Registros: " + this.oROWID.rows.length;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  9. - Controla el evento onchange de los input
 *       Al cambiar el Input actualiza el Data
 *
 * @param _obj - (Objeto) INPUT HTML que lanza el evento
 * @see _cambiaData_Grid
 *
 * @author EG - (egonpin@gmail.com) - 19/05/2006
 */
function cambiaInput_Grid()
{
 var _obj = arguments[0];
 var _oGrilla = null;
 var _tmpPrevio = null;
	// Identifica si es de un Grid
	if( (_obj.id.indexOf("_xx_") != -1) && (_obj.id.indexOf("_yy_") != -1) )
	{
     _oGrilla = buscaInputGrilla(_obj.id);
		if(_oGrilla != null)
		{
      _tmpPrevio = _oGrilla.data[_oGrilla._found[0]][1][_oGrilla._found[1]][1];
      _oGrilla.data[_oGrilla._found[0]][1][_oGrilla._found[1]][1] = _obj.value;
      _oGrilla.data[_oGrilla._found[0]][0] = eval(_oGrilla.data[_oGrilla._found[0]][0]);
      switch( eval(_oGrilla.data[_oGrilla._found[0]][0]) )
      {
        case _oGrilla.ke.Nulo:
        {
         	_oGrilla.data[_oGrilla._found[0]][0] = _oGrilla.ke.Nuevo ;
        }
        break;
        case _oGrilla.ke.Nuevo:
        {
         	_oGrilla.data[_oGrilla._found[0]][0] = _oGrilla.ke.Nuevo ;
        }
        break;
        case _oGrilla.ke.sinModificar:
        {
          if( (_tmpPrevio) != (_obj.value) )
         	    _oGrilla.data[_oGrilla._found[0]][0] = _oGrilla.ke.Modificado ;
        }
        break;
        case _oGrilla.ke.Modificado:
        {
         	_oGrilla.data[_oGrilla._found[0]][0] = _oGrilla.ke.Modificado ;
        }
        break;
      }
     _oGrilla.DataDepura();
    }
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  10. - Busca el id de un Input en el array data
 *
 * @param _idI - (STRING) Cadena a buscar en el array data
 * @return this - Retorna la Grilla
 * @author EG - (egonpin@gmail.com) - 19/05/2006
 */
function _buscaInput_Grid()
{
 var _idI = arguments[0];
 var _lF = null;
 var m = null;
 for(_lF=0; _lF<this.data.length; _lF++)
 {
	for(m=0; m<this.data[_lF][1].length; m++)
	 {
		if(_idI == this.data[_lF][1][m][0])
		{
			this._found[0] = _lF;
			this._found[1] = m;
			return(this);
		}
	 }
 }
 return(null);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  11. - Busca el id de un Input en el array _aGrid
 *
 * @param _idI - (STRING) Cadena a buscar en el array _aGrid
 * @return _oFound - Retorna una Referencia a la Grilla
 *	@type privado
 * @author EG - (egonpin@gmail.com) - 22/05/2006
 */
function buscaInputGrilla()
{
 var _idI = arguments[0];
 var _oFound = null;
 var n = null;
 for(n=0; n<_aGrid.length; n++)
 {
 	_oFound = _aGrid[n].buscaInput(_idI);
	if(_oFound != null)
		n = _aGrid.length;
 }
 return(_oFound);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  12. - Marca para su elimnación una Fila
 *
 * @param _idFila - (NUMBER) Fila a Borrar
 *	@ingroup privado
 * @author EG - (egonpin@gmail.com) - 22/05/2006
 */
function _delFila_Grid()
{
	var _idFila = (arguments[0] != null)?arguments[0]:-2;
	var _n = null;
	var _oTMP = null;
	var _nRow = null;
	var _m = null;
	if(_idFila == -2) // Borra Filas seleccionadas
	{
		for(_n=0; _n<this.data.length; _n++)
		{
          // Si el primer registro es nulo - No hace nada
   		if (_n == 0 && this.data[_n][0] == this.ke.Nulo)
			{
     			this.oROWID.rows[_n].firstChild.className = this.oROWID.rows[_n].firstChild.className.replace(/seleccionado/, "");
				break;
			}
			if(this.data[_n][2] == true) // El registro esta Seleccionado
			{
				_oTMP = getFirstParentOfType( oBusca(this.data[_n][1][this.data[_n][1].length -1][0]), "TR" );
				if(typeof(_oTMP) == "object")
				{
  				_oTMP = getFirstParentOfType(_oTMP.parentNode, "TR");
  				_nRow = _oTMP.rowIndex;
  				_oTMP = getFirstParentOfType(_oTMP, "TABLE");
  				_oTMP.deleteRow(_nRow);
  				//_oTMP.deleteRow(_n);
        }
				this._igualaRD();
				//Commented by xButil 2006-07-10 03:23:03 p.m.
				switch (eval(this.data[_n][0]))
				{
					case this.ke.Nulo:
						this.data.splice(_n,1);
						_n=-1;
					break;
					case this.ke.Nuevo:
						this.data.splice(_n,1);
						_n=-1;
					break;
					case this.ke.sinModificar:
						this.data[_n][0] = this.ke.Borrado;
					break;
					case this.ke.Modificado:
						this.data[_n][0] = this.ke.Borrado;
					break;
				}
				for( _m=(this.oROWID.rows.length - 1); _m>=0; _m-- )
				{
      			this.oROWID.rows[_m].firstChild.className = this.oROWID.rows[_m].firstChild.className.replace(/seleccionado/, "");
				}
			}
		}
	}
	if(_idFila >= 0 )// Borra 1 fila especificada por numero de posicion
	{
      _oTMP = getFirstParentOfType( oBusca(this.data[_idFila][1][this.data[_idFila][1].length -1][0]), "TR" );
		if(typeof(_oTMP) == "object")
		{
  		  _oTMP = getFirstParentOfType(_oTMP.parentNode, "TR");
  		  _nRow = _oTMP.rowIndex;
  		  _oTMP = getFirstParentOfType(_oTMP, "TABLE");
  		  _oTMP.deleteRow(_nRow);
      }
		this._igualaRD();
      this.data.splice(_idFila,1);
   }
	// IMPORTANTE: Garantiza que si se borrar todos lo registros por lo menos se genere automáticamente uno NULO
   if (this.data.length == 0)
		this.insFila();
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  13. - Selección de Fila
 *
 * @param _idFila - (NUMBER) Fila a Seleccionar
 *	@ingroup privado
 * @author EG - (egonpin@gmail.com) - 23/05/2006
 */
function _selecFila_Grid()
{
	var _idFila = arguments[0];
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  14. - Controlador de Evento Click
 *
 * @param evt - (OBJETO) Evento lanzado
 * @param idGrilla - (STRING) Data HTML
 * @ingroup privado
 * @author EG - (egonpin@gmail.com) - 23/05/2006
 */
function _eClick_Grid()
{
	var evt = arguments[0];
	var idGrilla = arguments[1];
	var _oEvt = (oNav.ie5)?evt.srcElement:evt.target;
	var _oPadre = buscaGrilla(idGrilla);
	var _pos = null;
//(buscaGrilla(idGrilla)).llenadoSQL.ejecutar();
	if(_oPadre != null)
	{
		_pos = new Number(_oEvt.innerHTML);
		if(_oPadre.data[_pos - 1][2] == true)
		{
			_oPadre.data[_pos - 1][2] = false;
      _oEvt.className = _oEvt.className.replace(/seleccionado/, "");
		}
		else
		{
			_oPadre.data[_pos - 1][2] = true;
      _oEvt.className = _oEvt.className + "seleccionado";
		}
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  16. - Busca una grilla por su nombre en el Array de Grillas
 * @param idObj - (string) Grilla a buscar
 * @see _aGrid, _oGrilla
 * @return oR - (Objeto) _oGrilla
 * @author EG - (egonpin@gmail.com) - 24/05/2006
*/
function buscaGrilla()
{
 var idObj = arguments[0];
 var oR = null;
 var n = null;
 for(n=0; n<_aGrid.length; n++)
 {
	if(_aGrid[n].id == idObj)
	{
		oR = _aGrid[n];
  	n = _aGrid.length;
	}
 }
return(oR);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  17. - LLena la Grilla desde una Consulta SQL
 * @constructor
 * @see _oGrilla, grillaData
 * @author EG - (egonpin@gmail.com) - 24/05/2006
*/
function _ollenadoSQL_Grid()
{
	this.nom_tabla    = new String(""); // Nombre de la Tabla a consultar (R/W)
	this.campos       = new String(""); // Administra los campos de la Consulta (R)
	this.pk        	  = new String(""); // Nombre del Primary Key (R/W)
	this.sFiltro      = new String(""); // Filtro que se usara como parte del Where
	this.parent       = null;
	this.nodeName     = new String("LLENADOSQL");
	this.init         = _initllenadoSQL_Grid;
	this.ejecutar     = _ejecutar_llenadoSQL_Grid;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  18. - Inicializa el llenado la Grilla desde una Consulta SQL
 *	@param oParent - (OBJETO) Grilla Padre
 * @see _ollenadoSQL_Grid
 * @author EG - (egonpin@gmail.com) - 24/05/2006
*/
function _initllenadoSQL_Grid()
{
	this.parent 		= arguments[0];
	this.nom_tabla 	= this.parent.nom_tabla;
	this.campos     = this.parent.campos;
	this.pk      		= this.parent.pk;
	this.sFiltro    = ""; //this.parent.sFiltro;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  19. - Dispara el llenado la Grilla desde una Consulta SQL
 * @see _ollenadoSQL_Grid, _ret_ejecutar_llenadoSQL_Grid
 * @author EG - (egonpin@gmail.com) - 24/05/2006
*/
function _ejecutar_llenadoSQL_Grid()
{
	var args = new Array();
	args[0] = dirInstall;
	args[1] = this.nom_tabla;
	args[2] = this.pk;
	args[3] = ArraytoString(this.campos, ",");
	args[4] = this.filtro;
	args[5] = this.parent.id;
	args[6] = this.ke.Nuevo;
	jsrsExecute(dirLibsPHP + 'grid_db.php?'+sid, _ret_ejecutar_llenadoSQL_Grid, 'ejecutar_llenadoSQL', args, false);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  20. - Retorno del SR ConsultaData
 * @see _ollenadoSQL_Grid, _ejecutar_llenadoSQL_Grid
 * @author EG - (egonpin@gmail.com) - 26/05/2006
*/
function _ret_ejecutar_llenadoSQL_Grid()
{
  var str = arguments[0];
	var args = new Array();
	var _str = null;
	var _estado = null;
	var error = null;
	var _padre = null;
	var _oPadre = null;
	var _aD = null;
	var n = null;
	var m = null;
	var _aT1 = null;
	var _aT2 = null;
	var _p = null;
	var _tmp_reg = null;
//  str = str.replace( /\\'/g, "'" );
   Anuncio ("Cargando Grilla");
 	eval(str);
 	_str = _str.replace( /\\n/g, " " );
 	_str = _str.replace( /\\/g, "" );
   _str = _str.replace( /&quot;/g, "\"" );
  Anuncio ("Cargando Grilla");
	_oPadre = (buscaGrilla(_padre));
	if(error != "") msg_error(error);
	_aD = StringtoArray(_str, separador_reg);
	for(n=0; n<_aD.length; n++)
	{
	 	_aT1 = StringtoArray(_aD[n], separador_col);
		_aT2 = new Array();
		_p = 0;
		for(m=0; m<_aT1.length; m+=2)
		{
			_aT2[_p] = new Array( eval(_aT1[m]) , eval(_aT1[1+m]) );
			_p++;
		}
		_aD[n] = _aT2;
	}
  Anuncio ("Cargando Grilla");
  if( _oPadre.data.length && (_oPadre.data[_oPadre.data.length -1][0] != 0) )
  {
		_oPadre.insFila(); // Agregar un nuevo registro en Blanco
  }
	for(n=0; n<_aD.length; n++) // Recorriendo Registro
	{
      Anuncio("Cargando Registro " + n);
		  if( _oPadre.data.length && (_oPadre.data[_oPadre.data.length -1][0] != 0) )
		  {
				_oPadre.insFila(); // Agregar un nuevo registro en Blanco
		  }
		if( _oPadre.data.length && (_oPadre.data[_oPadre.data.length -1][0] == 0) ) // Registro Nulo
		{
			_tmp_reg = _oPadre.data[_oPadre.data.length -1][1]; // Ultimo Registro de HTML
			for(m=0; m<_aD[n].length; m++) // Recorriendo Columnas
			{
				for(_p=0; _p<_tmp_reg.length; _p++) // Buscando el Campo a Guardar en el data
				{
					if( _tmp_reg[_p][2] == _aD[n][m][0] )
					{
            		_tmp_reg[_p][1] = _aD[n][m][1]; // Guardando el Valor JS
						oBusca(_tmp_reg[_p][0]).value = _tmp_reg[_p][1]; //_aD[n][m][1]; // Guardando el Valor HTML
            		_oPadre.data[_oPadre.data.length -1][0] = _estado; // Depende de ke
						_p = _tmp_reg.length;
 					}
				}
			}
		}
	}
 for(n=0; n<_oPadre.data.length; n++)
 {
  _oPadre.data[n][2] = false;
 }
 Anuncio("");
 if(_oPadre.eva_ejecutar.trim() != "")
 {
   eval(_oPadre.eva_ejecutar.trim());
 }
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  21. - Controla los cambios del Data
 *       Al cambiar el Data si se lanza esta funcion actualiza los Input
 *       si no alcanzan crea mas input y si sobran se borran
 *
 * @see cambiaInput_Grid
 *
 * @author EG - (egonpin@gmail.com) - 30/05/2006
 */
function _cambiaData_Grid()
{
	if(this != null)
	{
		/* verifico el tamaño de data y el tamaño de HTML
			los igualo con insfila en un for
			 paso los datos de data
		*/
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  22. - Objeto Caracteristicas del Data
 * @constructor
 * @see cambiaInput_Grid, _ollenadoSQL_Grid
 *
 * @author EG - (egonpin@gmail.com) - 30/05/2006
 */
function _ogrillaData_Grid()
{
	this.cols 		= new Number(0); // Numero de Columnas
	this.regs 		= new Number(0); // Numero de Registros
	this.num_reg 	= new Number(0); // Almacena el ultimo id generado en la grilla
	this.parent    = null;
	this.nodeName  = new String("GRILLADATA");
	this.init      = _initgrillaData_Grid; // Proc. # 25
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  23. - Objeto que se enlaza con otros controles
 * Sirve para enlazar datos de otros controles con el Control Grilla
 * @constructor
 * @see cambiaInput_Grid, _ollenadoSQL_Grid
 *
 * @author EG - (egonpin@gmail.com) - 05/06/2006
 */
function _oenlaceOtros_Grid()
{
 	this.nom_tabla = new String("");
 	this.campos    = new Array();
	this.pk        = new String("");
	this.filtro    = new String("");
	this._filtros  = new Array();
	this.estado    = null;
	this.ejecutar 	= _ejecutar_enlaceOtros_Grid; // Proc. # 24
	this.parent    = null;
	this.nodeName  = new String("ENLACEOTROSGRILLA");
	this.init      = _initenlaceOtros_Grid; // Proc. # 26
	this.borrar    = _borrar_enlaceOtros_Grid;
	this.adicionar = _adicionar_enlaceOtros_Grid;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  24. - Ejecuta el enlace desde otros Controles
 * Sirve para enlazar datos de otros controles con el Control Grilla
 *
 * @see _oenlaceOtros_Grid
 *
 * @author EG - (egonpin@gmail.com) - 05/06/2006
 */
function _ejecutar_enlaceOtros_Grid()
{
	var args = new Array();
	var _sFiltros = "";
	var _nl = null;
	if(this.filtro != "")
	{
		_sFiltros += this.filtro + " AND ";
	}
	for(_nl=0; _nl < this._filtros.length; _nl++)
	{
		if( eval(this._filtros[_nl][0]) != "" )
		{
			if((_nl > 0) && (_nl < this._filtros.length))
			{
				if(_sFiltros.trim() != "")
				_sFiltros = _sFiltros + " " + this._filtros[_nl-1][3] + " ";
			}
	      _sFiltros = this._filtros[_nl][1] +" "+ this._filtros[_nl][2] +" ("+ eval(this._filtros[_nl][0]) + ") ";
		}
	}
	args[0] = dirInstall;
	args[1] = this.nom_tabla;
	args[2] = this.pk;
	if(typeof(this.campos)!= "string")
		args[3] = ArraytoString(this.campos, ",");
	else
		args[3] = trim(this.campos);
	args[4] = _sFiltros;
	args[5] = this.parent.id;
	args[6] = this.estado; // this.parent.ke.Nuevo; //
	if(_sFiltros != "")
	jsrsExecute(dirLibsPHP + 'grid_db.php?'+sid, _ret_ejecutar_llenadoSQL_Grid, 'ejecutar_llenadoSQL', args, false);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  25. - Inicializa el _ogrillaData
 * @param oParent - (OBJETO) Grilla Padre
 * @see _ogrillaData
 * @author EG - (egonpin@gmail.com) - 05/06/2006
*/
function _initgrillaData_Grid()
{
	this.parent 	= arguments[0];
	this.cols 		= 0;
	this.regs 		= 0;
	this.num_reg 	= 0;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  26. - Inicializa el llenado la Grilla desde una Consulta SQL
 * @param oParent - (OBJETO) Grilla Padre
 * @see _oenlaceOtros_Grid
 * @author EG - (egonpin@gmail.com) - 05/06/2006
*/
function _initenlaceOtros_Grid()
{
  this.parent 	 = arguments[0];
	this.nom_tabla = this.parent.nom_tabla;
 	this.campos    = this.parent.campos;
	this.filtro    = this.parent.filtro;
	this.pk        = this.parent.pk;
	this.estado    = this.parent.ke.Nulo;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  27. - Borra un Filtro
 * @param nPos - (NUMBER) Posicion del Filtro a Eliminar
 * @see _oenlaceOtros_Grid
 * @author EG - (egonpin@gmail.com) - 05/06/2006
*/
function _borrar_enlaceOtros_Grid()
{
 var nPos = arguments[0]?arguments[0]:(this._filtros.length - 1);
	if(nPos >= this._filtros.length)
	{
		msg_error("Posición Inexistente");
		return(-1);
	}
	else
	{
		this._filtros.splice(nPos,1);
		return(this._filtros.length);
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  28. - Inicializa el llenado la Grilla desde una Consulta SQL
 * @param valInput - (STRING) Input a consultar
 * @param sCampo - (STRING) Campo a afectar
 * @param sOpera - (STRING) Operacion a efectuar entre sCampo idInput.value
 * @param sCondicion - (STRING) Condicion para enlazar con el siguiente filtro
 *
 * @ingroup privado
 * @see _oenlaceOtros_Grid
 * @author EG - (egonpin@gmail.com) - 05/06/2006
*/
function _adicionar_enlaceOtros_Grid()
{
 var valInput 	= arguments[0]?arguments[0]:null;
 var sCampo    	= arguments[1]?arguments[1]:null;
 var sOpera    	= arguments[2]?arguments[2]:"=";
 var sCondicion = arguments[3]?arguments[3]:"AND";
 var _nPos = null;
	if(typeof(valInput) != "string")
	{ msg_error("Uso: adicionar \n 'sVal', 'sCampo', 'sOpera', 'sCondicion'"); }
	else
	{
		 _nPos = this._filtros.push(new Array(valInput, sCampo, sOpera, sCondicion));
		 if(_nPos < 0)
			{ msg_error("Fallo la adición del Filtro"); }
		 else
			{ return (_nPos -1); }
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  29. - Deja en Blanco un Grid
 * @ingroup privado
 * @author xButil - (xbutil@gmail.com) - 2006-07-10
*/
function _vaciar_Grid()
{
  var _n = null;
  var _m = null;
  if (this.data.length > 0)
	{
      _m = this.data.length;
		for(_n=(_m-1); _n>=0; _n--)
		{
//	      this.data[_n][2] = true;
   		this.delFila(_n);
		}
   }
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  30. - Evento Despues de llamar la funcion ejecutar
 * @ingroup privado
 * @author EG - (egonpin@gmail.com) - 31/05/2007
*/
function _fafter_ejecutar_Grid()
{
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * 31. - Objeto de Constantes de Estado
 * @constructor
 * @ingroup privado
 * @author EG - (egonpin@gmail.com) - 22/06/2007
*/
function _kEstado_Grid()
{
 this.Nulo = 0;
 this.Nuevo = 1;
 this.sinModificar = 2;
 this.Modificado = 3;
 this.Borrado = 4;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * 32. - Función para Generar las cadenas para Guardar que seran enviadas por un SR
 * @ingroup privado
 * @author EG - (egonpin@gmail.com) - 22/06/2007
*/
function _generaCadenaGuardar_Grid()
{
  var _n = 0;
  var _m = 0;
  var _o = 0;
  var ctrlAdd = false;
// 	var separador_col = (separador_col) ? separador_col : ",";
// 	var separador_reg = (separador_reg) ? separador_reg : ";";
	this.Args0 = new String("");
	this.Args3 = new String("");
  // Intercepción de Errores
  if( typeof (this.posFG) == "number")
  {
      // Recorre las Filas
    	for(_n=0; _n<this.data.length; _n++)
      {
      if( (this.data[_n][0] != this.ke.Nulo) || (this.data[_n][0] != this.ke.sinModificar) )
      {
			  // Verifica con la PK si el campo se Insert, Update o Delete
		  switch( eval(this.data[_n][0]) )
        {
          case this.ke.Nuevo:
          {
            this.Args0 += this.posFG + separador_col + _n + separador_col + "0"; // 0 INSERT
            ctrlAdd = true;
          }
          break;
          case this.ke.Modificado:
          {
            this.Args0 += this.posFG + separador_col + _n + separador_col + "1"; // 1 UPDATE
            ctrlAdd = true;
          }
          break;
          case this.ke.Borrado:
          {
            this.Args0 += this.posFG + separador_col + _n + separador_col + "2"; // 2 DELETE
            ctrlAdd = true;
          }
          break;
        }
 			if((_n < (this.data.length - 1) ) && (ctrlAdd == true) )
        {
         this.Args0 += separador_reg;  // separador de registro, omite el ultimo
         ctrlAdd = false;
        }
        // Recorre las Columnas
				for(_m=0; _m<this.data[_n][1].length; _m++)
				{
// alert( this.data[_n][1][_m] + "\n" + this.aColumnas.length);
   			  switch( eval(this.data[_n][0]) )
   			  {
            case this.ke.Nuevo:
            {
      				  for(_o=0; _o < this.aColumnas.length; _o++)
      				  {
// alert(  trim(this.data[_n][1][_m][2]) + "\n" + trim(this.aColumnas[_o]) );
                  if(( trim(this.data[_n][1][_m][2]) == trim(this.aColumnas[_o]) ) && (trim(this.data[_n][1][_m][2]) != trim(this.pk)))
                  {
                    if( trim(this.aTipoCols[_o]) == "N" )
                    {
// 	alert(formatNumero(this.data[_n][1][_m][1]) + "\n" + (this.data[_n][1][_m][1]));
        						this.Args3 += this.posFG + separador_col + _n + separador_col + this.data[_n][1][_m][2] + separador_col + formatNumero(this.data[_n][1][_m][1]) + separador_reg ;
                    }
                    else
                    {
        						this.data[_n][1][_m][1] += "";
                        this.data[_n][1][_m][1] = this.data[_n][1][_m][1].replace(/,/g, "&#44;");   // ,
        //                 this.data[_n][1][_m][1] = this.data[_n][1][_m][1].replace(/;/g, "&#59;");   // ;
                        this.data[_n][1][_m][1] = this.data[_n][1][_m][1].replace(/chr(34)/g, "&#34;");  // "
        						this.Args3 += this.posFG + separador_col + _n + separador_col + this.data[_n][1][_m][2] + separador_col + this.data[_n][1][_m][1] + separador_reg ;
                    }
                    _o = this.aColumnas.length;
                  }
                }
            }
            break;
            case this.ke.Modificado:
            {
      				  for(_o=0; _o<this.aColumnas.length; _o++)
      				  {
                  if( trim(this.data[_n][1][_m][2]) == trim(this.aColumnas[_o]) )
                  {
                    if( trim(this.aTipoCols[_o]) == "N" )
                    {
        								this.Args3 += this.posFG + separador_col + _n + separador_col + this.data[_n][1][_m][2] + separador_col + formatNumero(this.data[_n][1][_m][1]) + separador_reg ;
                    }
                    else
                    {
        							  this.data[_n][1][_m][1] += "";
                        this.data[_n][1][_m][1] = this.data[_n][1][_m][1].replace(/,/g, "&#44;");   // ,
//                         this.data[_n][1][_m][1] = this.data[_n][1][_m][1].replace(/;/g, "&#59;");   // ;
                        this.data[_n][1][_m][1] = this.data[_n][1][_m][1].replace(/chr(34)/g, "&#34;");  // "
        								this.Args3 += this.posFG + separador_col + _n + separador_col + this.data[_n][1][_m][2] + separador_col + this.data[_n][1][_m][1] + separador_reg ;
                    }
                    _o = this.aColumnas.length;
                  }
                }
            }
            break;
            case this.ke.Borrado:
            {
                  if( trim(this.data[_n][1][_m][2]) == trim(this.pk) )
                  {
                    if( trim(this.aTipoCols[_o]) == "N" )
                    {
        								this.Args3 += this.posFG + separador_col + _n + separador_col + this.data[_n][1][_m][2] + separador_col + formatNumero(this.data[_n][1][_m][1]) + separador_reg ;
                    }
                  }
            }
            break;
          }
        }
	 		}
      }
  }
  else
  {
    msg_error("Error GDJS: \n Falta Definir la variable posFG de la Grilla " + this.id);
  }
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * 33. - Función para Depurar el objeto Data
 * @ingroup privado
 * @author EG - (egonpin@gmail.com) - 04/07/2007
*/
function _depura_data_Grid()
{
 if(this.Depura == true)
 {
     var _s = new String("");
     _s += "Pos   Estado \n";
     for(var n=0; n<this.data.length; n++)
     {
       _s += n + " :     " + this.data[n][0] + "\n";
     }
     alert(_s);
 }
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  34. - Busca el un Numero de Fila especifico en el array data y devuelve su posicion real del array data
 *
 * @param _iN - (INTEGER) Numero de Reg. a buscar en el array _aGrid
 * @return _oFound - Retorna el Valor de Posicion dondese encontro el registro
 *	@type privado
 * @author EG - (egonpin@gmail.com) - 13/09/2007
 */
function _BuscaFila_Grid()
{
 var _iN = arguments[0];
 var _oFound = null;
 var n = null;
 for(n=0; n<this.data.length; n++)
 {
	if(eval(this.data[n][3]) == eval(_iN)) _oFound = n;
	if(_oFound != null)
		n = this.data.length;
 }
 return(_oFound);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *  35. - Llenado Manual
 * @param _str - (STRING) Cadena data a cargar
 * @param _duplicaReg - (BOOLEAN) Verifica que los registros ingresen una sola vez a la grilla [ TRUE - Duplica Regs   -  FALSE - No Duplica ]
 * @see _ollenadoSQL_Grid, _ejecutar_llenadoSQL_Grid
 * @author EG - (egonpin@gmail.com) - 06/11/2007
*/
function _ejecutar_llenadoMANUAL_Grid()
{
/*
El formato de _str debe ser nom_columna  - separador_col - valor_columna ... separador_reg
*/
	var args = new Array();
	var _str = arguments[0]?arguments[0] : null;
	var _duplicaReg = arguments[1]?arguments[1] : false;
	var _estado = arguments[2]?arguments[2] : this.ke.Nuevo;
	var _oPadre = null;
	var _aD = null;
	var n = null;
	var m = null;
	var _aT1 = null;
	var _aT2 = null;
	var _p = null;
	var _tmp_reg = null;
	var _encontrado = new Array();

   Anuncio ("Cargando Grilla");

 	_str = _str.replace( /\\n/g, " " );
 	_str = _str.replace( /\\/g, "" );
   _str = _str.replace( /&quot;/g, "\"" );

  Anuncio ("Cargando Grilla");
	_oPadre = this;
	_aD = StringtoArray(_str, separador_reg);

	for(n=0; n<_aD.length; n++)
	{
	 	_aT1 = StringtoArray(_aD[n], separador_col);
		_aT2 = new Array();
		_p = 0;
		for(m=0; m<_aT1.length; m+=2)
		{
			_aT2[_p] = new Array( (_aT1[m]) , (_aT1[1+m]) );
			_p++;
		}
		_aD[n] = _aT2;
	}
  Anuncio ("Cargando Grilla");

	if(_duplicaReg == false)
	{
		for(n=0; n<_aD.length; n++)
  		{
  		   if( trim(_aD[n][0][0]) == trim(_oPadre.pk) )
  		   {
				for(m=0; m<_oPadre.data.length; m++)
				{
					if(_oPadre.buscaColumna( trim(_aD[n][0][0]), m ) != null)
	  		      {
						if(trim(_oPadre.data[_oPadre._found[0]][1][_oPadre._found[1]][1]) ==  trim(_aD[n][0][1]) )
						{
						 _encontrado.push(n);
						}
					}
				}
			}
		}

		_encontrado.sort();
		_encontrado = _encontrado.reverse();
		for(n=0; n<_encontrado.length; n++)
		{
			_aD.splice(_encontrado[n],1); // remuevo los que ya estan en la grilla
		}
	}

	for(n=0; n<_aD.length; n++) // Recorriendo Registro
		{
	      Anuncio("Cargando Registro " + n);
			  if( _oPadre.data.length && (_oPadre.data[_oPadre.data.length -1][0] != 0) )
			  {
					_oPadre.insFila(); // Agregar un nuevo registro en Blanco
			  }
			if( _oPadre.data.length && (_oPadre.data[_oPadre.data.length -1][0] == 0) ) // Registro Nulo
			{
				_tmp_reg = _oPadre.data[_oPadre.data.length -1][1]; // Ultimo Registro de HTML
				for(m=0; m<_aD[n].length; m++) // Recorriendo Columnas
				{
					for(_p=0; _p<_tmp_reg.length; _p++) // Buscando el Campo a Guardar en el data
					{
						if( _tmp_reg[_p][2] == _aD[n][m][0] )
						{
	            		_tmp_reg[_p][1] = _aD[n][m][1]; // Guardando el Valor JS
							oBusca(_tmp_reg[_p][0]).value = _tmp_reg[_p][1]; //_aD[n][m][1]; // Guardando el Valor HTML
	            		_oPadre.data[_oPadre.data.length -1][0] = _estado; // Depende de ke
							_p = _tmp_reg.length;
	 					}
					}
				}
			}
		}

 for(n=0; n<_oPadre.data.length; n++)
 {
  _oPadre.data[n][2] = false;
 }
 Anuncio("");
 if(_oPadre.eva_ejecutar.trim() != "")
 {
   eval(_oPadre.eva_ejecutar.trim());
 }
}
////////////////////////////////////////////////////////////////////////
/**
 *  36. - Busca una Columna en el array data
 *
 * @param _idI - (STRING) Cadena a buscar en el array data
 * @param _nFila - (INTEGER) Numero de Fila donde se buscara la columna
 * @return this - Retorna la Grilla
 * @author EG - (egonpin@gmail.com) - 19/05/2006
 */
function _buscaColumna_Grid()
{
 var _idI = arguments[0];
 var _nFila = arguments[1]?arguments[1]:0;
 var m = null;
	for(m=0; m<this.data[_nFila][1].length; m++)
	 {
		if(_idI == this.data[_nFila][1][m][2])
		{
			this._found[0] = _nFila;
			this._found[1] = m;
			return(this);
		}
	 }
 return(null);
}
/////////////////////////////////////////////////////////////////////////////////////////////
/**
 * 37. - Devuelve el data de Grilla en Objeto
 *
 * @ingroup privado
 * @author EG - (egonpin@gmail.com) - 22/10/2009
 * return array - objeto
 */
function _generaCadenaDataJS_Grid()
{
  var _n = 0;
  var _m = 0;
  var _o = 0;
  var ctrlAdd = false;
	var oRet = new Array();

  // Intercepción de Errores
  if( typeof (this.posFG) == "number")
  {
      // Recorre las Filas
    	for(_n=0; _n<this.data.length; _n++)
      {
      if( (this.data[_n][0] != this.ke.Nulo) || (this.data[_n][0] != this.ke.sinModificar) )
      {
			var oN ={"_col": null};
        // Recorre las Columnas
				for(_m=0; _m<this.data[_n][1].length; _m++)
				{
					oN._col = _m;
   			  switch( eval(this.data[_n][0]) )
   			  {
            case this.ke.Nuevo:
            {
  				  for(_o=0; _o < this.aColumnas.length; _o++)
  				  {
                  if(( trim(this.data[_n][1][_m][2]) == trim(this.aColumnas[_o]) ) && (trim(this.data[_n][1][_m][2]) != trim(this.pk)))
                  {
                    if( trim(this.aTipoCols[_o]) == "N" )
                    {
//        						this.Args3 += this.posFG + separador_col + _n + separador_col + this.data[_n][1][_m][2] + separador_col + formatNumero(this.data[_n][1][_m][1]) + separador_reg ;
        						eval("oN." + trim(this.data[_n][1][_m][2])+ "="+ formatNumero(this.data[_n][1][_m][1]));
                    }
                    else
                    {
        						this.data[_n][1][_m][1] += "";
                        this.data[_n][1][_m][1] = this.data[_n][1][_m][1].replace(/,/g, "&#44;");   // ,
        //                 this.data[_n][1][_m][1] = this.data[_n][1][_m][1].replace(/;/g, "&#59;");   // ;
                        this.data[_n][1][_m][1] = this.data[_n][1][_m][1].replace(/chr(34)/g, "&#34;");  // "
        						eval("oN." + trim(this.data[_n][1][_m][2])+ "='"+ this.data[_n][1][_m][1]) + "'";
//alert("entro 1");
                    }
                    _o = this.aColumnas.length;
                  }
               }
            }
            break;
            case this.ke.Modificado:
            {
      			for(_o=0; _o<this.aColumnas.length; _o++)
      			{
                  if( trim(this.data[_n][1][_m][2]) == trim(this.aColumnas[_o]) )
                  {
                    if( trim(this.aTipoCols[_o]) == "N" )
                    {
        						this.Args3 += this.posFG + separador_col + _n + separador_col + this.data[_n][1][_m][2] + separador_col + formatNumero(this.data[_n][1][_m][1]) + separador_reg ;
        						eval("oN." + trim(this.data[_n][1][_m][2])+ "="+ formatNumero(this.data[_n][1][_m][1]));
                    }
                    else
                    {
        						this.data[_n][1][_m][1] += "";
                        this.data[_n][1][_m][1] = this.data[_n][1][_m][1].replace(/,/g, "&#44;");   // ,
//                      this.data[_n][1][_m][1] = this.data[_n][1][_m][1].replace(/;/g, "&#59;");   // ;
                        this.data[_n][1][_m][1] = this.data[_n][1][_m][1].replace(/chr(34)/g, "&#34;");  // "
//      						this.Args3 += this.posFG + separador_col + _n + separador_col + this.data[_n][1][_m][2] + separador_col + this.data[_n][1][_m][1] + separador_reg ;
        						eval("oN." + trim(this.data[_n][1][_m][2])+ "='"+ this.data[_n][1][_m][1]) +"'";
                    }
                    _o = this.aColumnas.length;
                  }
               }
            }
            break;
            case this.ke.Borrado:
            {
                  if( trim(this.data[_n][1][_m][2]) == trim(this.pk) )
                  {
                    if( trim(this.aTipoCols[_o]) == "N" )
                    {
        						this.Args3 += this.posFG + separador_col + _n + separador_col + this.data[_n][1][_m][2] + separador_col + formatNumero(this.data[_n][1][_m][1]) + separador_reg ;
        						eval("oN." + trim(this.data[_n][1][_m][2])+ "="+ formatNumero(this.data[_n][1][_m][1]));
                    }
                  }
            }
            break;
          }
        }
// Fin for Columnas
		oRet.push(oN);
	 		}
      }
	return oRet;
  }
  else
  {
    msg_error("Error GDJS: \n Falta Definir la variable posFG de la Grilla " + this.id);
  }
}
