<?php
set_time_limit(1800);

$separador_string = "__@x@x@__";

$output = "";
$literalStrings = array();

$files = array("ch_tree_ftiens4.js","ch_tree_ua.js","color_picker.js","listar_db.js","forms_db_fx.js");  // Nombre del Archivo JS a comprimir

foreach($files as $file)
//foreach (glob("*.js") as $file)
{
	echo "- $file ";

	//echo "\nReading File...\n";
	echo ".";
	$lines = file($file);

	//echo "- Replacing literal strings...\n";
	echo ".";
	$output = replaceLiteralStrings($lines);

	//echo "- Removing comments...\n";
	echo ".";
	$output = removeComments($output);

	//echo "- Compressing white space...\n";
	echo ".";
	$output = compressWhiteSpace($output);

	//echo "- Combining literal strings...\n";
	echo ".";
	$output = combineLiteralStrings($output);

	//echo "- Restoring literal strings...\n";
	echo ".";
	$output = restoreLiteralStrings($output);

	//echo "- Writing new File...\n";
	echo ".";
	writeNewJSFile($output);

	echo "OK!\n";

}
//================================================
// Funciones de limpieza de los comentarios
//================================================

function replaceLiteralStrings($lines)
{
	global $literalStrings, $separador_string, $output;
	
	foreach ($lines as $num_line => $line)
	{
		$j = 0;
		$inQuote = false;
	  while ($j <= strlen($line))
		{
	  	$c = substr($line, $j, 1);

			if (!$inQuote) // If not already in a string, look for the start of one.
			{
	      if ($c == '"' || $c == "'")
				{
	        $inQuote = true;
	        $escaped = false;
					$quoteChar = $c;
	        $literal = $c;
	      }
	    	else
	      	$output .= $c;
	    }
	    else  // Already in a string, look for end and copy characters.
			{
	    	if ($c == $quoteChar && !$escaped)
				{
	        $inQuote = false;
	        $literal .= $quoteChar;
	        $output .= $separador_string . count($literalStrings) . $separador_string;
	        $literalStrings[count($literalStrings)] = $literal;
	      }
	      else if ($c == "\\" && !$escaped)
	        $escaped = true;
	      else
	        $escaped = false;
	      $literal .= $c;
	    }
	    $j++;
	  }
	}
	return $output;
}

function restoreLiteralStrings($output)
{
	global $literalStrings, $separador_string;

	foreach ($literalStrings as $num_literal => $literal)
    $output = str_replace($separador_string . $num_literal . $separador_string, $literal, $output);

  return $output;
}

function removeComments($output)
{
	global $num_comment_line;
	
	$_str = "";
	$_str_ini = "";
	$_str_end = "";
	
	$lines = explode("\n", $output);

	$_comment = false;
	foreach ($lines as $num_line => $line)
	{
		for ($i = 1; $i <= 2; $i++)
		{
			$_pos = strpos($line, "\x2f\x2f");   // Busca //
			$_pos_ini = strpos($line, "\x2f*");  // Busca /*
			$_pos_end = strpos($line, "*\x2f");  // Busca */

	 		// Remueve comentarios del tipo [//] de las lineas que no son comentarios
	 		if (is_int($_pos) && is_int($_pos_end) && $_pos < $_pos_end && !$_comment)
	 		{
	 			$line = substr($line, 0, $_pos);
	 		}
	 		// Remueve comentarios del tipo //
	 		if (is_int($_pos) && !is_int($_pos_end) && !$_comment)
	 		{
	 			$line = substr($line, 0, $_pos);
	 		}
	 		// Remueve comentarios [/*] y Avisa que se inicia un comentario en bloque
	 		if (is_int($_pos_ini) && !is_int($_pos_end))
	 		{
				$line = substr($line, 0, $_pos_ini);
				$_comment = true;
	 		}

	 		if (is_int($_pos_ini) && is_int($_pos_end) && $_pos_ini > $_pos_end)
	 		{
				$line = "Paso 5 --".substr($line, $_pos_end+2, $_pos_ini);
				$_comment = true;
	 		}

			if (!is_int($_pos_ini) && is_int($_pos_end) && $_comment)
	  	{
				$line = substr($line, $_pos_end+2);
	 			$_comment = false;
			}
	 		// Remueve comentarios [/* */]
	 		// Remueve todos los posibles comentarios [/* */] dentro de la misma línea
	 		while (is_int($_pos_ini) && is_int($_pos_end) && $_pos_ini < $_pos_end)
	 		{
	 			$line = substr($line, 0, $_pos_ini) . substr($line, $_pos_end+2);
	 			$_pos_ini = strpos($line, "\x2f*");
	 			$_pos_end = strpos($line, "*\x2f");
	 		}
		}
		if (!$_comment)
			$_str .= trim($line)."";
 	}
  return $_str;
}

function compressWhiteSpace($output)
{
	// Condense white space.
 	$output = preg_replace("@\s\s+@", " ", $output);
	$output = preg_replace("@^\s(.*)@", "$1", $output);
	$output = preg_replace("@(.*)\s$@", "$1", $output);
	// Remove uneccessary white space around operators, braces and parentices.
	$output = preg_replace("@\s([\x21\x25\x26\x28\x29\x2a\x2b\x2c\x2d\x2f\x3a\x3b\x3c\x3d\x3e\x3f\x5b\x5d\x5c\x7b\x7c\x7d\x7e])@", "$1", $output);
 	$output = preg_replace("@([\x21\x25\x26\x28\x29\x2a\x2b\x2c\x2d\x2f\x3a\x3b\x3c\x3d\x3e\x3f\x5b\x5d\x5c\x7b\x7c\x7d\x7e])\s@", "$1", $output);
	$output = preg_replace("@\s([\!\=\+\|\)\(\,\>\<\;])@", "$1", $output);
	$output = preg_replace("@([\!\=\+\|\)\(\,\>\<\;])\s@", "$1", $output);
	return $output;
}

function combineLiteralStrings($output)
{
	//$output = preg_replace("@\"\+\"@", "", $output);
	//$output = preg_replace("@\'\+\'@", "", $output);
	return $output;
}

function writeNewJSFile($output)
{
	global $file;
	$new_file = str_replace(".js", ".xz.js", $file);
	$handle = fopen ($new_file, 'w+');
	fwrite ($handle, $output);
	fclose ($handle); 
}

?>
