// Upload JavaScript
////////////////////////////////////////////////////////////////////////
// 0. - Declaracion de variables
// 1. Control Upload - Crea un Controlador Upload
// 2. Objeto Control Upload
// 3. Funcion _Inicio_cUL
// 4. Funcion _Type_cUL
// 5. Visibilidad - Muestra u Oculta una parte o una opcion del control
// 6. Busca un Control UpLoad
// 7. Funcion de Subida de Archivo

// Requerimientosbien
// scriptaculous

////////////////////////////////////////////////////////////////////////
// 0. Variables
var _aUpload = new Array();
var dirLibsPHP = (dirLibsPHP)?dirLibsPHP:new String("/axys_comun/libs");

////////////////////////////////////////////////////////////////////////
/**
 1. Control Upload - Crea un Controlador Upload

 * \param sDest 	- ( STRING ) nombre del Objeto destino, parte de un HTML
 * \return oUpload - ( Objeto ) devuelve un objeto Upload, el cual permite controlar el Upload
 * \author EG - (egonpin@gmail.com) - 17/01/2008
 */
function objUL()
{
	var sDest   = new String(arguments[0]);
	var bInicio = arguments[1]? arguments[1]:false;
	var oUL    = new _cUpload();

   oUL.idDest = trim(sDest);

	if(bInicio == true) oUL.Inicio(sDest);

	return oUL;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 2. Objeto Control Upload
 * \ingroup fPrivada
 * \author EG - (egonpin@gmail.com) - 17/01/2008
*/
var _cUpload = Class.create();
_cUpload.prototype = {
   // Publico
   initialize: function()
	{

   this.id        = new String("");  // R

	this.idCampo   = new String(""); // R/W - Nombre (ID) del Input de retorno
	this.sRuta     = new String("./"); // R/W - Ruta donde se guardara el archivo en el servidor
   this.idRet     = new String(""); // R - Id que retorna la BD (Mod Bodega de Archivos), identifica al archivo
   this.txtBSubida = new String(""); // R/W - Txt para Activar la Subida puede ser un Boton o una imagen
   this.txtBRemove = new String(""); // R/W - Txt para Activar la Remoción puede ser un Boton o una imagen
   this.bAuto     = true; // R/W - La subida es automatica, no se requiere el boton de subir

   this.tipoCtrl  = new Number(0); // R/W - Tipo de Control
                                    /*
                                       0 - Upload Normal Default
                                       1 - Bodega de Archivos
												*/

	this.estilo    = new Number(0); // R/W - Generador de Estilos Visuales predeterminados del control - x Implementar
	this.cantMaxUpload = new Number(1); // R/W x Implementar
	this.tamMaxUpload = 0; // R/W x Implementar
	this.visBRemove = true;


	// Opciones para tipo de Control 0
   this.veriSEsc  = true; // R/W - Booleano, True verifica si el archivo existe en el destino y pide confirmación para sobreescribirlo

   this.tipo      = _Type_cUL;
   this.Inicio    = _Inicio_cUL;
   this.mostrar   = _vis_cUL;

   // Privado
   this.Parent		= null; // R - Referencia al Objeto PADRE HTML

   this.idDest 	= null;  // R - ID HTML del DIV Escritorio
   this.oDest 		= null; // R - Referencia al Objeto HTML
   this.visDest   = true;  // R

   this.idCRet  	= new String("");  // R
   this.oCRet  	= null; // R - Referencia al Objeto HTML
   this.visCRet   = false;  // R

   this.idULStn  	= new String("");  // R
   this.oULStn  	= null; // R - Referencia al Objeto HTML
   this.visULStn  = true;  // R

   this.idBadic  	= new String("");  // R
   this.oBadic  	= null; // R - Referencia al Objeto HTML
   this.visBadic  = false;  // R

	this.idFile    = new String("");

	this.oCampo    = null; // R - Referencia Obj HTML, Input de Retorno
	this.oFile     = null; // R - Referencia Obj HTML, Input File

	this.idFrame 	= new String(""); // R
	this.oFrame 	= null; // R - Referencia Obj HTML, Piscina Frame
   this.visFrame  = false;  // R

	this.idForm 	= new String(""); // R
	this.oForm 		= null; // R - Referencia Obj HTML, Form

	this.idIDir    = new String(""); // R
	this.oIDir     = null; // R - Referencia Obj HTML, input hidden Direccion

	this.idmsgUL   = new String(""); // R
	this.omsgUL    = null; // R - Referencia Obj HTML, Div para Mensajes del UL

	this.Upload    = _Upload_cUL;
	this.Remove    = _Remove_cUL;
	this.Vaciar    = _Vaciar_cUL;
	this.onBlur 	= _onBlur_cUL;
	this.Editar 	= _estED_cUL;
	}

}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 3. Funcion _Inicio_cUL
 * \ingroup fPrivada
 * \param sDest 	- ( STRING ) nombre del Objeto destino, parte de un HTML
 * \author EG - (egonpin@gmail.com) - 14/08/2007
*/
function _Inicio_cUL()
{
   var sDest 	= arguments[0]?new String(arguments[0]):this.idDest;
   var sHTM    = new String();
   var _evt1   = new String("");

  	this.id     	= "" + trim(sDest);
   this.idCRet  	= "cr" + this.id;
   this.idULStn  	= "Stn" + this.id;
   this.idBadic  	= "Bot" + this.id;
   this.idFile    = "F" + this.id;
   this.idFrame   = "FR" + this.id;
   this.idForm    = "Form" + this.id;
   this.idIDir    = "IDir" + this.id;
   this.idmsgUL   = "msg" + this.id;

	if(this.idCampo.trim() == "")
	{
      this.idCampo = "IN_" + this.id;
	}

	if(this.txtBSubida.trim() == "")
	{
      this.txtBSubida = "Subir";
	}
	if(this.txtBRemove.trim() == "")
	{
      this.txtBRemove = "Remover";
	}


   this.idDest = trim(sDest);
  	this.Parent = $(sDest);

	if(this.bAuto == false)
	{
   	_evt1 = "";
	}
	else
	{
   	_evt1 = " onchange=\"buscaUL('" + this.id.trim() +"').Upload(event);\" ";
	}

   sHTM += "<div id='" + this.id + "' class='UpLoad'>";
   sHTM += "<div id='" + this.idCRet + "' class='ULCasillaRetorno'>";
		if( !$(this.idCampo.trim()) ) { sHTM += "<input id='" + this.idCampo.trim() +"'>"; }
	sHTM += "</div>";
	sHTM += "<form id='" + this.idForm + "' name='" + this.idForm + "' method='post' enctype='multipart/form-data' action='" + dirLibsPHP + "upload_sr.php?" + sid + "&ctrl=" + this.id + "&Fun=Subir' target='" + this.idFrame + "'>";
		sHTM += "<input id='" + this.idIDir.trim() + "' name='" + this.idIDir.trim() + "' type='hidden' value='" + this.sRuta.trim() + "'>";
	  	sHTM += "<div id='" + this.idULStn + "' class='ULInputStn'><input class='axibFile' size='30' id='" + this.idFile.trim() + "' name='" + this.idFile.trim() + "' type='file' " + _evt1 + "></div>";
	sHTM += "</form>";
	sHTM += "<div id='" + this.idBadic + "' class='ULBotAdic' >" + this.txtBSubida + "</div>";
	sHTM += "<div id='"+ this.idmsgUL +"' class='ULmsg'></div>";
	sHTM += "<iframe id='" + this.idFrame + "' name='"+ this.idFrame +"' src='' width='400' height='100'></iframe>";
	sHTM += "</div>";

	this.Parent.update(sHTM);

	this.oFrame = $(this.idFrame);
  	this.oBadic = $(this.idBadic);
  	this.oCRet = $(this.idCRet);

	this.oFrame.hide();
	this.oBadic.hide();
  	this.oCRet.hide();

	this.oBadic.onclick = this.Upload.bindAsEventListener(this);

  	this.oDest = $(this.id);
  	this.oULStn = $(this.idULStn);

  	this.oCampo = $(this.idCampo);
  	this.oFile  = $(this.idFile);
	this.oForm  = $(this.idForm);
	this.oIDir 	= $(this.idIDir);
	this.omsgUL = $(this.idmsgUL);
// alert(sHTM+ "\n\n"+this.idForm + "\n" + this.oCRet + "\n" + this.oForm + "\n" + $(this.idForm) + "\n" + this.oBadic);
	this.omsgUL.hide();

	if(this.bAuto == false)
	{
		this.oBadic.show();
	}
	else
	{
		this.oBadic.hide();
	}

   _aUpload.push(this);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 4. Funcion _Type_cUL
 * \ingroup fPrivada
 * \return sTipo 	- ( STRING ) Tipo de Objeto
 * \author EG - (egonpin@gmail.com) - 14/08/2007
*/
function _Type_cUL() { return "Upload"; }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 5. Visibilidad - Muestra u Oculta una parte o una opcion del control
 * \ingroup fPrivada
 * \param sDes 	- ( STRING ) parte a ocultar si es de tipo String oculta ese objeto
 * \param bStd    - ( BOOLEAN ) TRUE lo muestra, FALSE lo oculta
 * \author EG - (egonpin@gmail.com) - 14/08/2007
*/
function _vis_cUL()
{
 	var sDes = arguments[0];
 	var bStd = arguments[1]?arguments[1]:null;
 	var _tmp = null;

 	var tipoDes = new String(typeof(sDes));

 	if( tipoDes.trim() == "string" )
	{
	  switch( sDes.trim() )
	  {
		case "RET":
		   if(bStd == null) bStd = !this.visCRet;
         this.visCRet = bStd;
         if(bStd == true)  {  this.oCRet.show(); }
		   else  { this.oCRet.hide(); }
		break;
		case "BRO":
		   if(bStd == null) bStd = !this.visULStn;
         this.visULStn = bStd;
         if(bStd == true)  {  this.oULStn.show(); }
		   else  { this.oULStn.hide(); }
		break;
		case "BOT":
		   if(bStd == null) bStd = !this.visBadic;
         this.visBadic = bStd;
         if(bStd == true)  { this.oBadic.show(); }
		   else  { this.oBadic.hide(); }
		break;
		case "FRA":
		   if(bStd == null) bStd = !this.visFrame;
         this.visFrame = bStd;
         if(bStd == true)  { this.oFrame.show(); }
		   else  { this.oFrame.hide(); }
		break;
		case "CTRL":
		   if(bStd == null) bStd = !this.visDest;
         this.visDest = bStd;
         if(bStd == true)  {  this.oDest.show(); }
		   else  { this.oDest.hide(); }
		break;
		default:
			_tmp = $(sDes);
			if(_tmp)
			{
		      if(bStd == true)  {  _tmp.show(); }
		      else  { _tmp.hide(); }
			}
		break;
	  }
	}
}

////////////////////////////////////////////////////////////////////////////////
/** 6. - Busca un Control UpLoad
 * \param _sID - (STRING) Nombre del Control a Buscar
 * \author EG - (egonpin@gmail.com) - 24/01/2008
 */
function _localiza_cUL()
{
	var _sID = arguments[0];
	var _objx = null;
  _objx = _aUpload.find(function(_obj) { return _obj.id == _sID; });
	return _objx;
}

function buscaUL()
{
  var _sID = arguments[0];
  return _localiza_cUL(_sID);
}

////////////////////////////////////////////////////////////////////////////////
/** 7. - Funcion de Subida de Archivo
 * \author EG - (egonpin@gmail.com) - 24/01/2008
 */
function _Upload_cUL(evt)
{
if(evt)
{
 var aTmp = StringtoArray(sid, "=");
 this.omsgUL.update( "<img src='" + dirLibImages + "loading.gif' class='imgUL' alt='Subiendo...' />" );
 this.oIDir.value = this.sRuta.trim();
//    alert("Nombre: " + this.id + "\nArchivo: " + this.oFile.value + "\nDestino:" + this.oIDir.value );
 this.oBadic.hide();
 this.omsgUL.show();

	if(this.oFile.value.trim() == "" )
	{
	  this.omsgUL.update("Seleccione un Archivo...");
	  this.oBadic.show();
	}
	else
	{

	var _valida = true;
   if(typeof(_beforeUl)=="function")
   {
    _valida = _beforeUl();
   }

  if((_valida==true)&&(this.tipoCtrl == 0)) // Upload Normal
	{
	 if(this.veriSEsc == true) // Verificar Si el archivo existe y se sobreescribe
	 {
		Anuncio("Verificando...");
		 new Ajax.Request(
			dirLibsPHP + "/upload_sr.php",
			{
			  method: 'get',
			  parameters: { sidname: aTmp[1].trim(), Fun: 'Verificar', ctrl: this.id.trim(), file: this.oFile.value.trim(), dir: this.sRuta.trim() },
			  onSuccess: function(transport)
			  {
				Anuncio("...");
				var response = transport.responseXML.documentElement;
			   var nVer = response.getElementsByTagName("verificado")[0].childNodes[0].nodeValue;
			   var sCtrl = response.getElementsByTagName("control")[0].childNodes[0].nodeValue;
			   var sFile = response.getElementsByTagName("file")[0].childNodes[0].nodeValue;
				var oCtrl = buscaUL(sCtrl);
// alert( "Verificación: " +nVer + "\nControl: " + sCtrl + "\nFile: " + sFile + "\n" + oCtrl );
				if(nVer == 1)
				{
				   if(confirm("Desea Sobreescribir el Archivo " + sFile + "?") )
				   {
					 Anuncio("Subiendo...");
					  oCtrl.oForm.submit();
					}
					else
					{
					 if(oCtrl)
					 {
					  Anuncio("");
                 oCtrl.omsgUL.update("");
					  oCtrl.oBadic.show();
					 }
					}
				}
				else
				{
				 Anuncio("Subiendo...");
				 oCtrl.oForm.submit();
				}

				return;
			  },
			  onFailure: function(transport)
			  {
			   var response = transport.responseText;
			   Anuncio("1K: " + response);
			  }
			}
		 );
	 }
	 else
	 {
	  Anuncio("Subiendo...");
	  this.oForm.submit();
	 }
	}
	else{
   this.oBadic.show();
 this.omsgUL.hide();
}
}
}}
////////////////////////////////////////////////////////////////////////////////
/** 8. - Funcion de Respuesta a una Subida de Archivo
 * \author EG - (egonpin@gmail.com) - 29/01/2008
 */
function _Response_cUL(str, nErr, sCtrl, sNomFile)
{

// alert(
// 	arguments[0] + "\n" +
// 	arguments[1] + "\n" +
// 	arguments[2] + "\n" +
// 	arguments[3] + "\n"
// );

	var oCtrl = buscaUL(sCtrl);

	if(oCtrl) oCtrl.omsgUL.update( "" + str );

	if(nErr == 1) // Subio sin errores
	{
 	   oCtrl.oBadic.update(oCtrl.txtBRemove);
		oCtrl.oBadic.onclick = oCtrl.Remove.bindAsEventListener(oCtrl);

		var _tmp = oCtrl.oFile.value;
//alert(oCtrl.oFile.type);
// EG 2008-07-17 Error en IE no puede escribir la propiedad type de un control, por tal razon reemplazo la siguiente instruccion por un hide
		if(Prototype.Browser.IE || Prototype.Browser.WebKit)
		{
			oCtrl.oULStn.hide();
		}
		else
		{
	 	   oCtrl.oFile.type = "text";
		}

		// EG - 2010 12 07 Esta linea se repite varias veces por una especie de bug de velocidad, dejar asi.
		if(oCtrl.oFile.value != _tmp) {
	 	   oCtrl.oFile.value = _tmp;
	 	   oCtrl.oFile.value = _tmp;
		   oCtrl.oFile.readOnly = "true";
	 	   oCtrl.oFile.value = _tmp;
		}

	   if(oCtrl.tipoCtrl == 0 ) // Upload Normal
	   {
		 oCtrl.oCampo.value = sNomFile.trim();
		 Anuncio("");
		}

	   oCtrl.oBadic.show();

	   if(typeof( responseUpload )  == "function")
				{ responseUpload(oCtrl.oCampo.value, oCtrl.sRuta, oCtrl.id ,oCtrl.idCampo); }
	}

	if(nErr == 0) // Subio con errores
	{
	   Anuncio("Intentelo más tarde");
		oCtrl.omsgUL.update( "<span style='color: red'>No se pudo subir su archivo adjunto, verifique el tamaño y el tipo de archivo</span>" );
		oCtrl.omsgUL.show();
	   oCtrl.oBadic.show();

	   if(oCtrl.tipoCtrl == 0 ) // Upload Normal
	   {
		   oCtrl.oCampo.value = "";
		}
	}
}

////////////////////////////////////////////////////////////////////////
/** 9. - Funcion para Remover un Archivo
 * \author EG - (egonpin@gmail.com) - 29/01/2008
 */
function _Remove_cUL(evt)
{
if( confirm("Está Seguro de Borrar la Imagen?") )
if(evt)
{
	Anuncio("Removiendo...");
	var aTmp = StringtoArray(sid, "=");
 this.omsgUL.update( "<img src='" + dirLibImages + "loading.gif' class='imgUL' alt='Eliminando...' />" );
 this.oIDir.value = this.sRuta.trim();
//  alert("Nombre: " + this.id + "\nArchivo: " + this.oFile.value + "\nDestino:" + this.oIDir.value );
 this.oBadic.hide();
 this.omsgUL.show();

	if(this.tipoCtrl == 0) // Upload Normal
	{
		 new Ajax.Request(
			dirLibsPHP + "/upload_sr.php",
			{
			  method: 'get',
			  parameters: {sidname: aTmp[1].trim(), Fun: 'Remover', ctrl: this.id.trim(), file: this.oFile.value.trim(), dir: this.sRuta.trim()},
			  onSuccess: function(transport)
			  {
				var response = transport.responseXML.documentElement;
			   var nVer = response.getElementsByTagName("eliminado")[0].childNodes[0].nodeValue;
			   var sCtrl = response.getElementsByTagName("control")[0].childNodes[0].nodeValue;
			   var sFile = response.getElementsByTagName("file")[0].childNodes[0].nodeValue;
				var oCtrl = buscaUL(sCtrl);

				if(nVer == 1)
				{
// EG 2008-07-17 Error en IE no puede escribir la propiedad type de un control, por tal razon reemplazo la siguiente instruccion por un hide
					if(Prototype.Browser.IE || Prototype.Browser.WebKit)
					{
						oCtrl.oULStn.show();
					}
					else
					{
			 	   oCtrl.oFile.type = "file";
					}

		   		oCtrl.oFile.readOnly = "false";
				oCtrl.oFile.removeAttribute('readOnly');
				   oCtrl.oBadic.update(oCtrl.txtBSubida);
					oCtrl.oBadic.onclick = oCtrl.Upload.bindAsEventListener(oCtrl);
				   oCtrl.oBadic.show();
				   oCtrl.omsgUL.update("");
	   		   $(oCtrl.idCampo).value = "";
				   oCtrl.omsgUL.hide();
				   Anuncio("");

				   if(typeof( responseRemove ) == "function")
					{ responseRemove(oCtrl.oCampo.value, oCtrl.sRuta, oCtrl.id ,oCtrl.idCampo); }
				}
				else
				{
				  //console.log('no se pudo remover');
				   //oCtrl.omsgUL.update("El Archivo "+ sFile +" No Pudo ser Removido");
				   //oCtrl.omsgUL.show();
				   oCtrl.oBadic.update(oCtrl.txtBRemove);
					oCtrl.oBadic.onclick = oCtrl.Remove.bindAsEventListener(oCtrl);
	   			oCtrl.oBadic.show();
	   			oCtrl.omsgUL.hide();
				   Anuncio("El Archivo "+ sFile +" No Pudo ser Removido");
				}
			  },
			  onFailure: function(transport)
			  {
			   var response = transport.responseText;
// 			   alert("1K: " + response);
			  }
			}
		 );
	}
}
}

////////////////////////////////////////////////////////////////////////
/** 10. - Funcion para Limpiar un Control Upload
 * \author EG - (egonpin@gmail.com) - 12/02/2008
 */
function _Vaciar_cUL()
{
	//console.log(Prototype.Browser);
	if(Prototype.Browser.IE || Prototype.Browser.WebKit)
	{
		this.oULStn.show();
	}
	else
	{
   this.oFile.type = "file";
	}

   $(this.idCampo).value = "";
   this.oFile.readOnly = "false";
	this.oFile.removeAttribute('readOnly');
   this.oBadic.update(this.txtBSubida);
	this.oBadic.onclick = this.Upload.bindAsEventListener(this);
   $(this.idCampo).value = "";
   this.oBadic.show();
   this.omsgUL.hide();
   this.omsgUL.update("");

   Anuncio("");
}
////////////////////////////////////////////////////////////////////////////////
/** 11. - Funcion para Evento onBlur en Control Upload
 * \author EG - (egonpin@gmail.com) - 22/05/2008
 */
function _onBlur_cUL()
{
/*
 alert(this.id + "\n" +
	this.idCampo   + "\n" +
	this.sRuta     + "\n" +
   this.idRet     + "\n" +
   this.txtBSubida + "\n" +
   this.txtBRemove + "\n" +
   this.bAuto     + "\n" +
   this.tipoCtrl  + "\n" +
	this.estilo    + "\n" +
	this.cantMaxUpload + "\n" +
	this.tamMaxUpload + "\n" +
	this.visBRemove + "\n" +
   this.veriSEsc  + "\n" +
   this.Parent		+ "\n" +
   this.idDest 	+ "\n" +
   this.visDest  + "\n" +
   this.idCRet  + "\n" +
   this.visCRet   + "\n" +
   this.idULStn  	+ "\n" +
   this.visULStn  + "\n" +
   this.idBadic  	+ "\n" +
   this.visBadic  + "\n" +
	this.idFile    + "\n" +
	this.idFrame 	+ "\n" +
   this.visFrame  + "\n" +
	this.idForm 	+ "\n" +
	this.idIDir    + "\n"
 );
*/
// alert(this.idCampo  + "\n" + this.oCampo.value);
 var cF = this.oCampo.value;
 cF = cF.split("/");
 //alert(cF);
}
////////////////////////////////////////////////////////////////////////////////
/** 12. - Funcion para poner un Upload en Modo de Edicion
 * \author EG - (egonpin@gmail.com) - 15/08/2008
 */
function _estED_cUL()
{
	   this.oBadic.update(this.txtBRemove);
		this.oBadic.onclick = this.Remove.bindAsEventListener(this);

// EG 2008-07-17 Error en IE no puede escribir la propiedad type de un control, por tal razon reemplazo la siguiente instruccion por un hide
		if(Prototype.Browser.IE || Prototype.Browser.WebKit)
		{
			this.oULStn.hide();
		}
		else
		{
	 	   this.oFile.type = "text";
		}

		var _tmp = new String(this.oCampo.value);
		this.oFile.value = _tmp.slice(1+_tmp.lastIndexOf("/"));
	   this.oFile.readOnly = "true";

}

////////////////////////////////////////////////////////////////////////
/** 13. - Destruye una instancia en el Array de Uploads
 * \param _sID - (STRING) Nombre del objeto
 * \author EG - 2012-06-22
 */
function _destruye_cUL()
{
	var _sID = arguments[0];
	var x=0;
 	for(x=0; x<_aUpload.length; x++)
	{
		if(trim(_aUpload[x].id) == trim(_sID) )
		{
//			$(_aUpload[x].id).remove();
			_aUpload[x] = null;
			_aUpload.splice(x,1);
			x=_aUpload.length;
		}
	}
	return true;
}
function destruyeUpload(_sID) { return _destruye_cUL(_sID); }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* Upload Js
  egonpin@gmail.com
  2008/01/17
*/
