/** \defgroup Principal JavaScript Document - SELECTOR
 *Objeto Selector, permiter escoger un valor o varios desde una tabla especifica
 * y devuelve dicho valor en el campo indicado.
 * @{
 * @} */

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/** \defgroup Variables Declaracion de Variables
 * \ingroup Principal
 * @{ */
	  var oCampo = new Array();      /**< Variable Global */
	  var oSelector = new Array();   /**< Variable Global */
	  var ofs = new Array(); 				 /**< Variable Global */
	  var oBus = new Array(); 			 /**< Variable Global */
	  var oRb = new Array(); 				 /**< Variable Global */
	  var oSel = new Array(); 			 /**< Variable Global */
	  var oMostrar = new Array(); 	 /**< Variable Global */
	  var aPags = new Array(); 			 /**< Variable Global */
	  var oArgsSel = new Array(); 	 /**< Variable Global - Lleva los parametros que se le pasan a la funcion selector*/
	  var dirLibsPHP = (dirLibsPHP) ? dirLibsPHP : ""; 				 /**< Variable Global - Controla el directorio de instalacion de la funcion */
/*
 * Este array es blanqueado cada vez que se presiona el boton buscar y es cambiado cada vez que se cambia de pagina
 */
	  var gSel = new Array();
/** @} */

////////////////////////////////////////////////////////////////////////////////

/// Publica - Selector es la funcion principal que debe ser invocada desde la pagina web
/**
 * \ingroup Principal
 * \param apunta - String Id del campo input
 * \param tabla - String Nombre de la Tabla (con esquema)
 * \param campos - String Lista de campos a mostrar en el selector, separados por coma (,)
 * \param maquilla - String Cadena de campos a devolver en el espacio de maquillaje
 * \param _where - String Cadena SQL valida para complementar el select sql
 * \param valor - String Un valor
 * \param titulo - String Titulo que llevara el Objeto Selector
 * \param subtitulo - String Subtitulo que aparecera al alado del input de busqueda
 * \param columnas - String Indica el numero de columnas en que se va a ver la respuesta, este parametro
 * \param campo_dest - String Indica el campo destino en el que hay que regresar el dato, si no se especifica este parametro, este se hara igual al 1er campo (apunta)
 * define un comportamiento especial del control selector, si es cero ( 0 ), el control solo dejara seleccionar
 * un dato, si es mayor de cero ( >0 ), dejara seleccionar 'n' datos y los mostrara en columnas,
 * el numero de las columnas lo fija este mismo numero.
 *
 *
 * \htmlonly
   <b>  Ejemplo - HTML: </b>
  <pre>
  &lt;!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd"&gt;
    &lt;html&gt;
  &lt;head&gt;
  &lt;meta http-equiv="content-type" content="text/html"&gt;
   &lt;title&gt;prueba&lt;/title&gt;
   	&lt;script type="text/javascript" src="/axys_comun/libs/js/jsrsClient.js"&gt;&lt;/script&gt;
   	&lt;script type="text/javascript" src="/axys_comun/libs/js/varias.js"&gt;&lt;/script&gt;
   	&lt;script type="text/javascript" src="selector.js"&gt;&lt;/script&gt;
  &lt;/head&gt;
  &lt;body&gt;&lt;span id="hhh"&gt;&lt;/span&gt;
   &lt;form action="alert('envia')"&gt;
     &lt;table border="0"&gt;
 				&lt;tr&gt;
        &lt;td&gt;Cedula:
        &lt;input type="text" id="oid" name="oid" value="" /&gt;
        &lt;span id="cs_oid"&gt;&lt;/span&gt;
        &lt;/td&gt;
        &lt;/tr&gt;
	&lt;tr&gt;&lt;td&gt; Datos: &lt;input type="text" id="id_dato" name="id_dato" value="" /&gt; &lt;span id="cs_id_dato"&gt;&lt;/span&gt;&lt;/td&gt;&lt;/tr&gt;
   &lt;/table&gt;
    &lt;/form&gt;
  &lt;script type="text/javascript"&gt;
     dirLibsPHP = "";
     dirInstall= "";
 	  selector("oid", 'xcomun.campos_db', "nom_esquema, nom_tabla", "nom_campo", "ORDER BY nom_funcion_js", "", "Busqueda de Nuips", "Buscar Nuip", "0", "id_nuip_padre" );
 	  selector("id_dato", "ssockets.hw_datos", "id_dato,oid,tableoid,puerto_dato" , "oid", "", "", "Busqueda de Datos", "Buscar HW", "6" );
  &lt;/script&gt;
  &lt;/body&gt;
  &lt;/html&gt;
  </pre>
  \endhtmlonly

 * \author EG - (egonpin@gmail.com) - 21/12/2004
*/

////////////////////////////////////////////////////////////////////////////////

/** \defgroup fPrivada Funciones Privadas
 * \ingroup Principal
 * @{
 * @}
 */

/** Mostrar
 * Muestra u oculta un Selector
 * \ingroup fPrivada
 * \param apunta - String, Id del campo a apuntar
 * \author EG - (egonpin@gmail.com) - 21/12/2004
 */

/*
	function Mostrar(apunta)
	{
		img_disable = "img_" + apunta;
		if(oSelector[apunta].style.display == 'none')
		{
			obj_setStyle(oSelector[apunta],"top",oBusca("divContenido").scrollTop+100);
			obj_show(oSelector[apunta]);
			_img = oBusca("img_"+apunta);
			_w = (oNav.ns) ? "100%" : screen.width;
			_h = (oNav.ns) ? "100%" : screen.height;
			obj_setStyle(_img,"width",_w);
			obj_setStyle(_img,"height",_h);
			obj_setStyle(_img,"top",oBusca("divContenido").scrollTop-50);
			//alert(apunta);
			oCampo[apunta] = oBusca(apunta);
			obj_show(_img);
			if(!oBus[apunta]) { oBus[apunta] = oBusca("txtBusca['" + apunta + "']"); }
			if(!oMostrar[apunta]) { oMostrar[apunta] = oBusca("ibxMsg_" + apunta ); }
			//oBus[apunta].value = oCampo[apunta].value + "\n" ;
			oBus[apunta].value = oCampo[apunta].value ;
			if (oMostrar[apunta].className == "ibxMsgErr") { oBus[apunta].value = ""; }
		}
		else
		{
			oDestino = oBusca("sub['" + apunta + "']");
			obj_writeHTML(oDestino, "");
			obj_hide(oSelector[apunta]);
			obj_hide(oBusca(img_disable));
			checkCampo(oBusca(apunta));
		}
	}

////////////////////////////////////////////////////////////////////////////////

/** Carga el valor escogido desde un selector al campo apunta
 * \ingroup fPrivada
 * \param objetivo - String, Id del campo a apuntar
 * \param apunta - String, Valor del objeto seleccionado
 * \param obj - Object, Objeto seleccionado
 * \author EG - (egonpin@gmail.com) - 21/12/2004
 */

/*
function Retorna(objetivo, apunta, obj)
	{
		// alert(objetivo +' *** '+ apunta +' *** '+ obj);
		var _nom = "rb_old" ;
		if(ofs[_nom]) { ofs[_nom].checked = false; }
		obj.className = "fila_sel";
		ofs["rf_old"] = obj;
		if(!oRb["rb" + apunta]) { oRb["rb" + apunta] = oBusca("rb" + apunta ); }
		ofs[_nom] = oRb["rb" + apunta];
		oRb["rb" + apunta].checked = true;
		oSel["ret" + objetivo] = oRb["rb" + apunta].value;
		oSel["ver" + apunta] = oBusca("ver" + apunta ).innerHTML;
		oCampo[objetivo].value = oSel["ret" + objetivo];
		obj_writeHTML(oMostrar[objetivo], oSel["ver" + apunta]);
		Mostrar(objetivo);
		if(eval("window." + oBusca(objetivo).id + "_onselect"))
		{ eval("window." + oBusca(objetivo).id + "_onselect(oBusca(objetivo))"); }
	}

////////////////////////////////////////////////////////////////////////////////
/** carga_Selector
 * \ingroup fPrivada
 * \param apunta - String
 * \param tabla - String
 * \param campos - String
 * \param maquilla - String
 * \param _where - String
 * \param valor - String
 * \param columnas - String
 * \param campo_dest - String
 * \sa ret_cuentaSelector, reg_Selector
 * \author EG - (egonpin@gmail.com) - 21/12/2004
 */

/*
function carga_selector(apunta, tabla, campos, maquilla, _where, valor, columnas, campo_dest)
{
	_where2 = trim(arguments[4]);
//	if(_where2.indexOf("\enlace(\i"))
//	{
//		_wh = "" + eval(_where2);
//	}
//	else
//	{
		_wh = "" + _where2;
//	}

	gSel[apunta] = new Array();
	if(arguments[5] == "")
	{
		_obj = oBusca("txtBusca['" + apunta + "']");
		arguments[5] = _obj.value;
	}
	jsrsPOST = true;
	var args = new Array();
	args[0] = trim(arguments[0]);
	args[1] = trim(arguments[1]);
	args[2] = trim(arguments[2]);
	args[3] = trim(arguments[3]);
	args[4] = trim(_wh);
	args[5] = trim(arguments[5]);
	args[6] = trim(arguments[6]);
	args[7] = trim(dirInstall);
	args[8] = trim(arguments[7]);
	jsrsExecute(dirLibsPHP + 'selector.php', ret_cuentaSelector, 'reg_Selector', args, false);
}

////////////////////////////////////////////////////////////////////////////////
/** ret_cuentaSelector
 * \ingroup fPrivada
 * \param str - String, Cadena devuelta por el SR
 * \sa carga_selector
 * \author EG - (egonpin@gmail.com) - 21/12/2004
 */
/*
function ret_cuentaSelector(str)
{
	//alert(str);
  args = new Array();
  _registros = 0;
  error = "";
  eval(str);

	if(error != "") alert(error);

  _oPag = oBusca("paginador_" + args[0]);
  _oSB = oBusca("sB_" + args[0]);
  txt = ("Halladas " + _registros + " coincidencias ");

  obj_writeHTML(_oSB, txt);
  if(_registros >  eval(num_registros_x_pagina))
  {
		if(!gSel[args[0]]) { var av = new Array(); av["regs"]=_registros; gSel[args[0]]=av; }
	  aPags[args[0]] = args;
	  Paginador(_registros, args[0], 1, 1);
	}
	else
	{
	 	args[7] = dirInstall;
		jsrsExecute(dirLibsPHP + 'selector.php', ret_Selector, 'Selector', args, false);
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
/** valor_Selector
 * \ingroup fPrivada
 * \param apunta - String
 * \param tabla - String
 * \param campos - String
 * \param maquilla - String
 * \param titulos - String
 * \param _where - String
 * \param valor - String
 * \param campo_dest - String
 * \sa ret_valorSelector, ret_cuentaSelector, reg_Selector
 * \author EG - (egonpin@gmail.com) - 02/02/2005
 */
	function valor_selector(apunta, tabla, campos, maquilla, _where, valor, columnas, campo_dest, SQLmanual)
	{
		gSel[apunta] = new Array();
		if(arguments[5] == "")
		{
			_obj = oBusca("txtBusca['" + apunta + "']");
			arguments[5] = _obj.value;
		}

		jsrsPOST = true;
		var args = new Array();
		args[0] = arguments[0];
		args[1] = arguments[1];
		args[2] = arguments[2];
		args[3] = arguments[3];
		args[4] = arguments[4];
		args[5] = arguments[5];
		args[6] = arguments[6];
		args[7] = dirInstall;
		args[8] = arguments[7];
// Le quite el SQL Manual y empezo a funcionar todo 2006-10-17 EG
		args[9] = arguments[8];
		//alert("0: "+args[0]+"\n1: "+args[1]+"\n2: "+args[2]+"\n3: "+args[3]+"\n4: "+args[4]+"\n5: "+args[5]+"\n6: "+args[6]+"\n7: "+args[7]+"\n8: "+args[8]);

		jsrsExecute(dirLibsPHP+"selector.php?"+sid, ret_valorSelector, 'valor_Selector', args, false);
	}

////////////////////////////////////////////////////////////////////////////////
/** ret_valorSelector
 * \ingroup fPrivada
 * \param str - String, Cadena devuelta por el SR
 * \sa valor_selector
 * \author EG - (egonpin@gmail.com) - 02/02/2005
 */
function ret_valorSelector(str)
{
	_apunta = "";
	_str    = "";
	error   = "";
	eval(str);
// alert(str);
	if(trim(error) != "")
	{
		estado(error);
		obj = oBusca(_apunta);
  	obj.className = "ibxInputErr";
  	obj = oBusca("ibxMsg_" + _apunta);
  	obj.className = "ibxMsgErr";
  	obj_writeHTML(obj, _str);
  }
  else
  {
		obj = oBusca("ibxMsg_" + _apunta);
  	obj_writeHTML(obj, _str);
  	//alert(_str)
	}
}

////////////////////////////////////////////////////////////////////////////////
/** Paginador
 * \ingroup fPrivada
 * \param _regs - Integer, numero de registros de la Consulta
 * \param _apunta - String
 * \param _cmd - String o Integer
 * \param _pag - Integer
 * \sa Selector, ret_Selector
 * \author EG - (egonpin@gmail.com) - 21/12/2004
 */
	function Paginador(_regs, _apunta, _cmd, _pag)
	{
		//alert(_regs)
		///   paginador inicio
		_num_datos = eval(_regs);
		// calculamos numero de paginas
		_num_registros_x_pagina =  eval(num_registros_x_pagina);
		_num_paginas_x_linea = eval(num_paginas_x_linea);
		////
		if ( _num_datos > _num_registros_x_pagina ) { _paginas = Math.ceil(_num_datos / _num_registros_x_pagina); }
		else  { _paginas = 1; }
		// calculamos numero de paginas x linea
		if ( _paginas > _num_paginas_x_linea )  { _paginas_x_lineas = Math.ceil(_paginas / _num_paginas_x_linea); }
		else  { _paginas_x_lineas = 1; }
		///  comandos
		if(typeof(_cmd) == "number") { _pagina_actual = eval(_cmd); }
		else
		{
			if(_cmd == "retroceder")
			{
				if( _pag > 1 ) { _pag -= 1; }
			}
			else
			{
				if(_cmd == "avanzar") { if( (_pag + 1) <= _paginas ) { _pag += 1; } }
			}
		}
		// generamos paginador
		_oPag = oBusca("paginador_" + _apunta);
		/////
		_val_fin = _pag * _num_paginas_x_linea ;
		_val_ini = _val_fin - _num_paginas_x_linea + 1;
		///
		if( _val_fin > _paginas)  { _val_fin = _paginas; }
		///
		_cad_tit = "<table class='cPaginador'><tr>";
		///
		if( _pag <= 1 )  { _cad_tit += "<td><\/td>"; }
		else  { _cad_tit += "<td><a href=\"javascript:Paginador( "+ _regs + ", '" + _apunta + "', " +"'retroceder', " + _pag + " )\">&lt;&lt;<\/a><\/td>"; }
		_oSB = oBusca("sB_" + args[0]);
		txt = ("Halladas " + _regs +  " coincidencias, Pagina " + _pagina_actual + " de " + _paginas);
		obj_writeHTML(_oSB, txt);
		if(gSel[_apunta]) { gSel[_apunta]["pag"] = _pagina_actual; }
		///
		for(n=_val_ini; n<=_val_fin; n++)
		{
			if( _pagina_actual == n )  { _cad_tit += "<td>"+ n +"<\/td>"; }
			else  { _cad_tit += "<td><a href=\"javascript:Paginador("+ _regs + ", '" + _apunta + "', " + n + ", " + _pag + ")\">"+ n +"<\/a><\/td>"; }
		}
		// avance de paginas
		if( _pag >= _paginas_x_lineas )
		{ _cad_tit += "<td><\/td><\/tr><\/table>"; }
		else
		{ _cad_tit += "<td><a href=\"javascript:Paginador(" + _regs + ", '" + _apunta + "', 'avanzar', " + _pag + ")\">&gt;&gt;<\/a><\/td><\/tr><\/table>"; }
		///
		obj_writeHTML(_oPag, _cad_tit);

		REG_offset = (_pagina_actual * _num_registros_x_pagina) - _num_registros_x_pagina ;
		new_where = aPags[_apunta][4] + " LIMIT " + _num_registros_x_pagina + " OFFSET " + REG_offset + " " ;
		var pars = new Array();
		pars[0] = aPags[_apunta][0];
		pars[1] = aPags[_apunta][1];
		pars[2] = aPags[_apunta][2];
		pars[3] = aPags[_apunta][3];
		pars[4] = new_where;
		pars[5] = aPags[_apunta][5];
		pars[6] = aPags[_apunta][6];
		pars[7] = dirInstall;
		pars[8] = aPags[_apunta][8];

//		alert(pars)
		jsrsExecute(dirLibsPHP + 'selector.php', ret_Selector, 'Selector', pars, false);
	}

////////////////////////////////////////////////////////////////////////////////
/** ret_Selector
 * \ingroup fPrivada
 * \param str - String, cadena devuelta desde el SR
 * \sa Paginador
 * \author EG - (egonpin@gmail.com) - 21/12/2004
 */
	function ret_Selector(str)
	{
		_apunta = "";
		_str = "";
		error = "";
		eval(str);
		if(error != "") alert(error);
		_pn = "P" + gSel[_apunta]["pag"];
		oDestino = oBusca("sub['" + _apunta + "']");
		obj_writeHTML(oDestino, "<table border='0' cellpading='0' cellspacing='2' >" + _str + "<\/table>");
		aOri = oBusca('rb' + _apunta);
		//marca las filas que antes se habian marcado
		_aT = gSel[_apunta][_pn] ;
		if(_aT)
		{
			for(n=0; n<_aT.length; n++)
			{
				_encontrado = false;
				for(m=0; m<aOri.length; m++)
				{
					if( _aT[n]["id"] == aOri[m].value )
					{
						_encontrado = true;
						aOri[m].checked = !aOri[m].checked;
					}
				}
			}
		}
	}

////////////////////////////////////////////////////////////////////////////////

/** kEnter
 * \ingroup fPrivada
 * \author EG - (egonpin@gmail.com) - 02/02/2005
 */
	function kEnter( apunta , tabla , campos , maquilla , _where ,  valor, columnas, campo_dest, e )
	{
		eventChooser = (oNav.ns) ? e.which : e.keyCode;
		which = String.fromCharCode(eventChooser).toLowerCase();
		if(which.charCodeAt(0) == 13) carga_selector(apunta , tabla , campos , maquilla , _where , valor, columnas, campo_dest );
	}

////////////////////////////////////////////////////////////////////////////////

/**
 * \ingroup fPrivada
 * \author EG - (egonpin@gmail.com) - 02/02/2005
 */
	function Marca(apunta, valor_id, obj_origen, columnas)
	{
		//alert("apunta " + apunta  + "  val_id " + valor_id + "  obj_ori " + obj_origen + "  cols " + columnas)
		_pn = "P" + gSel[apunta]["pag"];
		aOri = oBusca('rb' + apunta + "[]");
		vchk = 0;
		if( !gSel[apunta]["paginas"] )
		{
			gSel[apunta]["paginas"] = new Array();
		}
		if( !gSel[apunta][_pn] )
		{
			gSel[apunta][_pn] = new Array();
			var _aT2 = new Array();
			_aT2["id"] = "retorna";
			_aT2["valor"] = "";
			_aT2["html"] = "";
			gSel[apunta][_pn].push(_aT2);
			gSel[apunta]["paginas"].push(_pn);
		}

		if(!columnas) { columnas = 100; }

		_apuntadores = "";
		_tabla = oBusca("t" + apunta);
/*
		if(_tabla)
		{
			for(m=0; m<_tabla.cells.length; m++)
			{
				cad += "<td id='" + _tabla.cells[m].id + "'>" + _tabla.cells[m].innerHTML + " que es esto<\/td>";
			}
		}
*/
		_aT = gSel[apunta][_pn] ;
		cad = "";
		if( !aOri.length )
		{
			tmp = aOri;
			aOri = new Array();
			aOri.push(tmp);
		}

		for(n=0; n<aOri.length; n++)
		{
			if(aOri[n].value == valor_id)
			{
				aOri[n].checked = !aOri[n].checked;
				if(aOri[n].checked)
				{
					var _aT2 = new Array();
					_aT2["id"] = aOri[n].value;
					_aT2["valor"] = oBusca("ver" + aOri[n].value).innerHTML;
					gSel[apunta][_pn].push(_aT2);
				}
				else
				{
					for(p=1; p< gSel[apunta][_pn].length ; p++ )
					{
						if( gSel[apunta][_pn][p]["id"] == aOri[n].value )
						{
							gSel[apunta][_pn].splice(p,1);
						}
					}
				}
			}
			if(vchk == 0 && cad.substring(cad.length -4) != "<tr>") { cad += "<tr>"; }
			//alert("" + aOri[n].checked + "   " + cad.search("vg_"+aOri[n].value) )
			if(aOri[n].checked && (cad.search("vg_"+aOri[n].value) == -1 ))
			{
				_apuntadores += aOri[n].value + ",";
				cad += "<td id='vg_" + aOri[n].value + "' class='Resultado'>" + oBusca("ver" + aOri[n].value).innerHTML + "<\/td>";
				vchk += 1;
			}
			if(vchk == columnas)
			{
				vchk = 0;
				cad += "<\/tr>";
			}
		}

		if(vchk != 0) { cad += "<\/tr>"; }
		if(cad.substring(cad.length -4) == "<tr>") { cad = cad.substring(0, cad.length -4); }
		_apuntadores = _apuntadores.substring(0, (_apuntadores.length -1) );
		gSel[apunta][_pn][0]["valor"] = _apuntadores;
		gSel[apunta][_pn][0]["html"] = cad;
		_apuntadores = "";
		cad = "";
		for(n=0; n<gSel[apunta]["paginas"].length; n++)
		{
			_pn = gSel[apunta]["paginas"][n];
			if((_apuntadores.substring(_apuntadores.length -1) != ",") && (_apuntadores != ""))
			{
				_apuntadores += ",";
			}
			_apuntadores += gSel[apunta][_pn][0]["valor"];
			cad += gSel[apunta][_pn][0]["html"];
		}
		cad = "<table id='t" + apunta + "' class='Resultado'>" + cad + "<\/table>";
		oSel["ver" + valor_id] = oBusca("ver" + valor_id ).innerHTML;
		obj_writeHTML(oMostrar[apunta], cad);
		oCampo[apunta].value = _apuntadores;
	}

////////////////////////////////////////////////////////////////////////////////

/**
 * \ingroup fPrivada
 * \param _this    	- JS, Objeto INPUT  que contiene el dato a validar
 * \param LaFuncion 	- Funcion JS, Objeto que validara el tipo de dato
 * \param emptyOK    - Boolean, Objeto que permite hacer que un campo sea obligatorio o No
 *                      TRUE - No Obligatorio
 *                      FALSE - Depende de la BD xcomun.campos_db
 * \sa checkCampo
 * \author EG - (egonpin@gmail.com) - 02/02/2005
 * \note
  * - la funcion de verificaion del tipo de campo tiene que devolver el numero del error
 *   (-#) Error / (0) Ok. Sin Errores / (+#) Ok. Un indicador util para oids, id, etc.
 */
	function veriSel(_this, LaFuncion, emptyOK)
	{
//alert("592 VeriSel \nVerifico" + _this + "\n" + LaFuncion + "\n" + emptyOK + "\n" +  checkCampo(_this, LaFuncion, emptyOK));
		if (checkCampo(_this, LaFuncion, emptyOK) == 0)
		{
			if(trim(_this.value) != "")
			{
				//alert("597 verisel \n"+ oArgsSel[_this.id][0] + "\n" + _this.id);
				if(typeof(oArgsSel[_this.id]) != "undefined")
				{
					if(oArgsSel[_this.id].length >10)
					{ _tmp201 = eval(oArgsSel[_this.id][10]); }
					else
					{ _tmp201 = oArgsSel[_this.id][4]; }
					if(trim(_tmp201) != "")
					{
						_tmp201 += " AND " + _this.id + "='" + _this.value +"'";
					}
					//alert("+++"+_tmp201+"+++");
//alert("607 veriSel \n" + oArgsSel[_this.id] + "\n" + _tmp201 +"\n"+ _this.value )
					//alert((oArgsSel[_this.id][0]+" +++ "+ oArgsSel[_this.id][1]+" +++ "+ oArgsSel[_this.id][2]+" +++ "+ oArgsSel[_this.id][3]+" +++ "+ _tmp201+" +++ "+ _this.value+" +++ "+ oArgsSel[_this.id][8]+" +++ "+ oArgsSel[_this.id][9]))
					valor_selector(oArgsSel[_this.id][0], oArgsSel[_this.id][1], oArgsSel[_this.id][2], oArgsSel[_this.id][3], _tmp201, _this.value, oArgsSel[_this.id][8], oArgsSel[_this.id][9]);
				}
			}
			else if(trim(_this.value) == "")
			{
				obj = oBusca("ibxMsg_" + oArgsSel[_this.id][0]);
				obj_writeHTML(obj, "");
			}
			if(eval("window." + _this.id + "_onblur"))
			{
				eval("window." + _this.id + "_onblur(_this)");
			}
		}
	}

////////////////////////////////////////////////////////////////////////////////
/*
  Esta funcion recibe el nombre de unos campos INPUT, busca su valor
  y genera una cadena para SQL aplicable a un where.
*/
	function enlace()
	{
		cad = "";
		for(n=0; n<arguments.length; n++)
		{
			_oT = oBusca(arguments[n]);
			_oTv = trim(_oT.value);
			if(_oTv != "")
			{
				if(n>0) { cad += " OR ";}
				cad += arguments[n] + "='"  + _oTv +  "'";
			}
		}
		return(cad);
	}

////////////////////////////////////////////////////////////////////////////////
	function fSQL()
	{
		// fSQL( "(,id_via,=);(AND,id_via,>=);(,id_via,id_via)" );
		cTxt = arguments[0];
		aTxt = StringtoArray(cTxt, ';');
		aArr = new Array(aTxt.length);
		for(n=0; n<aTxt.length; n++)
		{
			tam = aTxt[n].length;
			if((aTxt[n].substr(0,1) == '(') && (aTxt[n].substr(tam-1,1) == ')') )
			{ aTxt[n] = aTxt[n].substr(1,tam-2); }
			aArr[n] = StringtoArray(aTxt[n], ',');
		}

		// contar los argumentos, cada argumento sera un array de 3
		/*
		conector booleanos - sale de un array
		id del campo
		operandos booleanos - sale de un array - si no esta en la lista busquelo
		como id de campo
		*/
		var operadores = new Array();
		var conectores = new Array();

		conectores[0] = "OR";
		conectores[1] = "AND";

		operadores[0] = ">";
		operadores[1] = "<";
		operadores[2] = ">=";
		operadores[3] = "=";
		operadores[4] = "<=";
		operadores[5] = "LIKE";

		//  verificando que todos los parametros sean array de tamao 3
		for(n=0; n<aArr.length; n++)
		{
			if((typeof(aArr[n]) != "object") || (aArr[n].length != 3))
			{ alert("Todos los parametros deben ser ARRAY de tamano 3"); return(false); }
		}

		cad = "";
		for(n=0; n<aArr.length; n++)
		{
			aT = aArr[n];
			conector = "";
			objeto = "";
			oT = false;
			oT2 = false;
			operador = "";
			for(m=0; m<conectores.length; m++) { if(conectores[m] == aT[0]) {conector = conectores[m];} }
			// se puede implementar para que verifique si es una variable de JS
			oT = oBusca(aT[1]);
			//oT = oBusca('id_via');
			if(!oT) { alert("No se encontro el campo " + aT[1]); return(false); }
			for(m=0; m<operadores.length; m++) { if(operadores[m] == aT[2]) {operador = operadores[m];} }
			if(n == 0) {conector = "";} else {conector = " " + conector;}
			// no se encontro el operador puede ser un Between
			if(operador == "")
			{
				oT2 = oBusca(aT[2]);
				if(oT2)
				{
					operador = " BETWEEN '" + oT.value + "' AND '" + oT2.value + "'";
					cad += conector + " " + oT.id + operador;
				}
				else
				{	return(false);}
			}
			else
			{
				cad += conector + " " + oT.id + operador + "'"+ oT.value + "'";
			}
		}
		return("WHERE " + cad);
	}
////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * 33. - Selecciona el valor de la tabla o vista sin abrir el Selector (Listar) (Privado)
 *
 * \author xButil - (xbutil@gmail.com) - 02/02/2006
 */
function veriSelnew(_this, LaFuncion, emptyOK, nomSelector)
{
	var prefijo_campo = "ibx";
	if (checkCampo(_this, LaFuncion, emptyOK) == 0)
	{
		//alert(oBusca(_this.id));
		if(trim(_this.value) != "")
		{
			if (nomSelector == "")
				_oL = buscaListar('oSel_'+_this.name); // .name x .id
			else
				_oL = buscaListar(nomSelector); // .name x .id
			_tmp201 = "";
			// el "0" debe ser tipo texto o sino JODE como un berraco
			// OJO: Revisar el valor _oL.pk.replace ... es temporal mientras se finaliza la funcion
			//alert(_oL.pk+" ++++++ "+_oL.tabla+" ++++++ "+_oL.campos+" ++++++ "+_oL.pk.replace('id_','nom_')+" ++++++ "+_tmp201 +" ++++++ "+_this.value+" ++++++ "+"0"+" ++++++ "+_oL.idRetorno);
			//_oL.pk.replace('id_','nom_') debe ser numerico indicando el numero de la columna
//alert(_oL.SQLmanual + "\n"  );
			if (_oL.SQLmanual == "")
			{
				_oL.filtrar();
//alert(_oL.SQL);
				if(_oL.SQL != "")
            	_sSQL = _oL.construyeSQL(true, _oL.campos);
				else
            	_sSQL = "";
			}
			else
            _sSQL = _oL.SQLmanual;
//alert("738\n" + _oL.construyeSQL(true, _oL.campos));
//alert("747\n" + _oL.pk +"\n"+ _oL.tabla +"\n"+ _oL.campos +"\n"+ _oL.colRetorno_Maq +"\n"+ _tmp201 +"\n"+ _this.value +"\n"+ "0" +"\n"+ _this.id +"\n"+ _sSQL);
			if(_oL != null)
				valor_selector(_oL.pk, _oL.tabla, _oL.campos, _oL.colRetorno_Maq, _tmp201 , _this.value, "0", _this.id, _sSQL);
		}
		else if(trim(_this.value) == "")
		{
			if (_this.className.indexOf("igx") != -1)
         	prefijo_campo = "igx";

			obj = oBusca(prefijo_campo+"Msg_" + _this.id);
			obj_writeHTML(obj, "");
		}
		if(eval("window." + _this.id + "_onblur"))
		{
			eval("window." + _this.id + "_onblur(_this)");
		}
	}
}
