// JavaScript Document Escritorio
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 0.  - Declaracion de variables
// 1.  - objESC() - Funcion declaradora              (PUBLICO)
// 2.  - Declaracion del Objeto Control Escritorio
// 3.  - _Incio_cEsc()
// 4.  - _Type_cEsc()
// 5.  - _vis_cEsc()
// 6.  - _ref_cEsc()
// 7.  - objICO() - Funcion declaradora              (PUBLICO)
// 8.  - Declaración del Objeto Control Icono
// 9.  - _vis_cIco()
// 10. - _Inicio_cIco()
// 11. - _ref_cIco()

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Requerimientos
// - Libreria JS de multiples utilidades (varias.js)

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 0. Variables
var _aEscritorio = new Array();
var _aIcono = new Array();
var dirLibsPHP = (dirLibsPHP)?dirLibsPHP:new String("/axys_comun/libs");

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 1. Control Escritorio - Crea una Malla Escritorio y su respectivo controlador

 * \param sDest 	- ( STRING ) nombre del Objeto destino, parte de un HTML
 * \return oEscritorio - ( Objeto ) devuelve un objeto Escritorio, el cual permite controlar el Escritorio
 * \author EG - (egonpin@gmail.com) - 14/08/2007
 */
function objESC()
{
	var sDest  = new String(arguments[0]);
	var oESC   = new _oEscritorio();

   oESC.Inicio(sDest);

	return oESC;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 2. Objeto Control Escritorio
 * \ingroup fPrivada
 * \author EG - (egonpin@gmail.com) - 14/08/2007
*/
function _oEscritorio()
{
   // Publico
   this.id        = new String("");  // R
   this.visDest   = new Boolean(true);  // R
   this.visCab    = new Boolean(true);  // R
   this.visCue    = new Boolean(true);  // R
   this.visPie    = new Boolean(true);  // R
   this.visCueBg  = new Boolean(true);  // R
   this.backgCue  = new String("");  // R/W

   this.tipo      = _Type_cEsc;
   this.Inicio    = _Inicio_cEsc;
   this.mostrar   = _vis_cEsc;
   this.refresca  = _ref_cEsc;

   // Privado
   this.idDest 	= new String("");  // ID HTML del DIV Escritorio
   this.idCab     = new String("");  // ID HTML del DIV Cabeza
   this.idCue     = new String("");  // ID HTML del DIV Cuerpo
   this.idCueBg   = new String("");  // ID HTML del Div de Background del Cuerpo
   this.idPie     = new String("");  // ID HTML del DIV Pie
   this.oDest 		= null; // Referencia al Objeto HTML
   this.oCab 		= null; // Referencia al Objeto HTML Cabeza
   this.oCue 		= null; // Referencia al Objeto HTML Cuerpo
   this.oCueBg    = null; // Referencia al Objeto HTML Background del Cuerpo
   this.oPie 		= null; // Referencia al Objeto HTML Pie
   this.Parent		= null; // Referencia al Objeto PADRE HTML
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 3. Funcion _Inicio_cEsc
 * \ingroup fPrivada
 * \param sDest 	- ( STRING ) nombre del Objeto destino, parte de un HTML
 * \author EG - (egonpin@gmail.com) - 14/08/2007
*/
function _Inicio_cEsc()
{
   var sDest 	= new String(arguments[0]);
   var sHTM    = new String();
   
   this.id     = "Esc_" + trim(sDest);
   this.idCab  = "H" + this.id;
   this.idCue  = "B" + this.id;
   this.idCueBg  = "B" + this.id + "_bg";
   this.idPie  = "F" + this.id;
   this.idDest = trim(sDest);
  	this.Parent = oBusca( sDest );

   sHTM += "<div id='" + this.id + "' class='Escritorio'>";
   sHTM += " <div id='" + this.idCab + "' class='HEscritorio'></div>";
   sHTM += " <div id='" + this.idCue + "' class='BEscritorio'>";
   sHTM += "  <div id='" + this.idCueBg + "'></div>";
   sHTM += " </div>";
   sHTM += "<div id='" + this.idPie + "' class='FEscritorio'></div>";
   sHTM += "</div>";

   obj_writeHTML(this.Parent, sHTM);
  	this.oDest = oBusca(this.id);
  	this.oCab = oBusca(this.idCab);
  	this.oCue = oBusca(this.idCue);
  	this.oCueBg = oBusca(this.idCueBg);
  	this.oPie = oBusca(this.idPie);

   this.refresca();
   _aEscritorio.push(this);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 4. Funcion _Type_cEsc
 * \ingroup fPrivada
 * \return sTipo 	- ( STRING ) Tipo de Objeto
 * \author EG - (egonpin@gmail.com) - 14/08/2007
*/
function _Type_cEsc() { return "Escritorio"; }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 5. Visibilidad - Muestra u Oculta una parte o una opcion del control
 * \ingroup fPrivada
 * \param sDes 	- ( STRING ) parte a ocultar si es de tipo String oculta ese objeto
 * \param bStd    - ( BOOLEAN ) TRUE lo muestra, FALSE lo oculta
 * \author EG - (egonpin@gmail.com) - 14/08/2007
*/
function _vis_cEsc()
{
 	var sDes = arguments[0];
 	var bStd = arguments[1];
 	var _tmp = null;

 	var tipoDes = new String(typeof(sDes));

 	if( tipoDes.trim() == "string" )
	{
	  switch( sDes.trim() )
	  {
		case "CAB":
         this.visCab = bStd;
         if(bStd == true)  {  obj_show(this.oCab); }
		   else  { obj_hide(this.oCab); }
		break;
		case "CUE":
         this.visCue = bStd;
         if(bStd == true)  {  obj_show(this.oCue); }
		   else  { obj_hide(this.oCue); }
		break;
		case "CUEbg":
         this.visCueBg = bStd;
         if(bStd == true)  {  obj_show(this.oCueBg); }
		   else  { obj_hide(this.oCueBg); }
		break;
		case "PIE":
         this.visPie = bStd;
         if(bStd == true)  {  obj_show(this.oPie); }
		   else  { obj_hide(this.oPie); }
		break;
		case "CTRL":
         this.visDest = bStd;
         if(bStd == true)  {  obj_show(this.oDest); }
		   else  { obj_hide(this.oDest); }
		break;
		default:
			_tmp = oBusca(sDes);
			if(_tmp)
			{
		      if(bStd == true)  {  obj_show(_tmp); }
		      else  { obj_hide(_tmp); }
			}
		break;
	  }
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 6. Refresca - Repinta el Escritorio
 * \ingroup fPrivada
 * \author EG - (egonpin@gmail.com) - 14/08/2007
*/
function _ref_cEsc()
{
   var sHTM = new String();
   
 // Refresca Background
 if( trim(this.backgCue) != "" )
 {
   sHTM = "<img src='" + trim(this.backgCue) + "' style='border: 0px none Transparent;'>";
   obj_writeHTML(this.oCueBg,sHTM);
 }
 
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 7. Control Icono - Crea un Icono y su respectivo controlador
 * \param sDest 	- ( STRING ) nombre del Objeto destino, parte de un HTML
 * \return oIcono - ( Objeto ) devuelve un objeto Icono, el cual permite controlar el Icono
 * \author EG - (egonpin@gmail.com) - 14/08/2007
 */
function objICO()
{
	var sDest  = new String(arguments[0]);
	var oICO   = new _oIcono();

   oICO.Inicio(sDest);

	return oICO;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 8. Objeto Icono
 * \ingroup fPrivada
 * \author EG - (egonpin@gmail.com) - 14/08/2007
*/
function _oIcono()
{
 this.id       = new String("");  // - R
 this.Img      = new String("");  // Dirección de la Imagen - R/W
 this.altImg   = new String("");  // Texto Alternativo de la Imagen - R/W
 this.Txt      = new String("");  // Texto que acompaña al Icono - R/W
 this.posTxt   = new String("");  // ARRIBA - ABAJO - IZQUIERDA - DERECHA - R/W
 this.Enlace   = new String("");  // Texto del enlace a Ejecutarse - R/W
 this.desEnlace = new String("");  // Destino del Enlace [OPTIONAL] - R/W
 this.visIco   = new Boolean(true);
 this.visTxt   = new Boolean(true);
 this.visDest  = new Boolean(true);
 this.enableLink = new Boolean(true);
 
 this.idTxt    = new String("");
 this.idA      = new String("");
 this.idICO    = new String("");
 this.oA       = null;
 this.oIco     = null;
 this.oTxt     = null;
 this.oDest    = null;
 this.parent   = null;
 
 this.Inicio    = _Inicio_cIco;
 this.mostrar   = _vis_cIco;
 this.refresca  = _ref_cIco;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 9. Visibilidad - Muestra u Oculta una parte o una opcion del control
 * \ingroup fPrivada
 * \param sDes 	- ( STRING ) parte a ocultar si es de tipo String oculta ese objeto
 * \param bStd    - ( BOOLEAN ) TRUE lo muestra, FALSE lo oculta
 * \author EG - (egonpin@gmail.com) - 14/08/2007
*/
function _vis_cIco()
{
 	var sDes = arguments[0];
 	var bStd = arguments[1];
 	var _tmp = null;

 	var tipoDes = new String(typeof(sDes));

 	if( tipoDes.trim() == "string" )
	{
	  switch( sDes.trim() )
	  {
		case "ICO":
         this.visIco = bStd;
         if(bStd == true)  {  obj_show(this.oIco); }
		   else  { obj_hide(this.oIco); }
		break;
		case "TXT":
         this.visTxt = bStd;
         if(bStd == true)  {  obj_show(this.oTxt); }
		   else  { obj_hide(this.oTxt); }
		break;
		case "CTRL":
         this.visDest = bStd;
         if(bStd == true)  {  obj_show(this.oDest); }
		   else  { obj_hide(this.oDest); }
		break;
		default:
			_tmp = oBusca(sDes);
			if(_tmp)
			{
		      if(bStd == true) { obj_show(_tmp); }
		      else  { obj_hide(_tmp); }
			}
		break;
	  }
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 10. Funcion _Inicio_cIco
 * \ingroup fPrivada
 * \param sDest 	- ( STRING ) nombre del Objeto destino, parte de un HTML
 * \author EG - (egonpin@gmail.com) - 14/08/2007
*/
function _Inicio_cIco()
{
   var sDest 	= new String(arguments[0]);
   var sHTM    = new String();

   this.id     = "Ico_" + trim(sDest);
   this.idICO  = "iIco_" + trim(sDest);
   this.idA    = "A_" + trim(sDest);
   this.idTxt  = "Txt_" + trim(sDest);
   this.idDest = trim(sDest);
  	this.Parent = oBusca( sDest );

   sHTM += "<div id='" + this.id + "' class='Icono'>"
   sHTM += "<a href='" + this.Enlace + "' target='" +  this.desEnlace + "' class='IconoLink' name='" + this.idA + "' id='" + this.idA + "'>";
   sHTM += "<img id='" + this.idICO + "' class='Icono' alt='" + trim(this.altImg) +"' src='"+ trim(this.Img) +"'>";
   sHTM += "</a>";
   sHTM += "</div>";

   obj_writeHTML(this.Parent, sHTM);
  	this.oDest  = oBusca(this.id);
  	this.oA     = oBusca(this.idA);
  	this.oIco   = oBusca(this.idICO);
  	this.oTxt   = oBusca(this.idTxt);

   this.refresca();
   _aIcono.push(this);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 11. Funcion _ref_cIco
 * \ingroup fPrivada
 * \author EG - (egonpin@gmail.com) - 14/08/2007
*/
function _ref_cIco()
{
   var oDiv = null;
   this.oIco.src= this.Img;

   oDiv = document.createElement("div");
   oDiv.id = this.idTxt;
   oDiv.className = 'TxtIcono';
   oDiv.innerHTML =  trim(this.Txt);
   
   if(this.posTxt == "ARRIBA")
   {
//       oDiv.style.width = this.oIco.width;
//       oDiv.style.clear = "both";
      this.oA.insertBefore(oDiv, this.oIco);
   }
   if(this.posTxt == "IZQUIERDA")
   {
//       oDiv.style.width = this.oIco.width;
// alert(oDiv.style.);
//       oDiv.style = "float:left;";
      this.oA.insertBefore(oDiv, oBusca("d" + this.idIco));
   }
   if(this.posTxt == "ABAJO")
   {
      oDiv.style.width = this.oIco.width;
      oDiv.style.clear = "none";
      this.oA.appendChild(oDiv);
   }
   if(this.posTxt == "DERECHA")
   {
      oDiv.style.width = this.oIco.width;
      oDiv.style.clear = "right";
      this.oA.appendChild(oDiv);
   }

}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 12. Funcion _malla_oEsc
 Definición del Objeto Malla que contendra las celdas
 * \ingroup fPrivada
 * \author EG - (egonpin@gmail.com) - 14/08/2007
*/
function _malla_oEsc()
{
/*
Hummmmmmmmmmmmmm, la malla tambien tendra operaciones como mover icono a otra casilla, adicionar casilla, borrar casilla
la malla objeto tendra un data de tipo array en el que se definiran los iconos
  data - array cada elemento del array sera una casilla de la malla
  Ahora cada elemento del array sera tambien de tipo array asi:
	 [0] - Posicion X
	 [1] - Posicion Y
	 [2] - Tipo - (ICONO, SEPARADOR)
	 [3] - id HTML destino (DIV)
	 [4] - Objeto referencia al HTML
	 [5] - Id objeto Icono
*/
 this.data = new Array(); // Array data del escritorio
 this.cambiaW = _cambiaW_cMalla;  // Cambia el Ancho de una casilla X Y
 this.cambiaH = _cambiaH_cMalla; // Cambia el Alto de una casilla X Y
 this.creaIco = _creaIco_cMalla; // Crea un Icono a la Malla, en una posicion X Y
 this.moverIco = _moverIco_cMalla; // Mueve el Icono de ls posicion X Y a otra posicion X Y que este vacia
 this.borrarIco = _borCasilla_cMalla; // Elimina el Icono de una Casilla
 this.mostrar = _mostrarCasilla_cMalla; // Muestra TRUE oculta FALSE  una casilla X Y
 this.Inicio = _Inicio_cMalla;

// Privada
// x Implementar puede ser interesante pero necesitaraia X Y
// this.adicionar = _addCasilla_cMalla;

}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 13. Funcion _cambiaW_cMalla
Cambia el Ancho de una Casilla X Y
 * \param nX - ( INTEGER ) Posicion X a afectar
 * \param nY - ( INTEGER ) Posicion Y a afectar
 * \param nW - ( INTEGER ) Ancho a asignar
 * \ingroup fPrivada
 * \author EG - (egonpin@gmail.com) - 14/09/2007
*/
function _cambiaW_cMalla()
{
 var nX = new Number(arguments[0]);
 var nY = new Number(arguments[1]);
 var nW = new Number(arguments[2]);

}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 14. Funcion _cambiaH_cMalla
Cambia el Alto de una Casilla X Y
 * \param nX - ( INTEGER ) Posicion X a afectar
 * \param nY - ( INTEGER ) Posicion Y a afectar
 * \param nH - ( INTEGER ) Alto a asignar
 * \ingroup fPrivada
 * \author EG - (egonpin@gmail.com) - 14/09/2007
*/
function _cambiaH_cMalla()
{
 var nX = new Number(arguments[0]);
 var nY = new Number(arguments[1]);
 var nH = new Number(arguments[2]);

}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 15. Funcion _creaIco_cMalla
Crea un Icono en una Casilla X Y
 * \param nX - ( INTEGER ) Posicion X a afectar
 * \param nY - ( INTEGER ) Posicion Y a afectar
 * \ingroup fPrivada
 * \author EG - (egonpin@gmail.com) - 14/09/2007
*/
function _creaIco_cMalla()
{
 var nX = new Number(arguments[0]);
 var nY = new Number(arguments[1]);

}
