<?php

////////////////////////////////////////////////////////////////////////
//  Declaracin de la clase BD
////////////////////////////////////////////////////////////////////////
class BD
{
////////////////////////////////////////////////////////////////////////
   function BD() {
                global $cnf;

                $this->dbname   = $cnf["dbname"];       // Nombre de la base de datos
                $this->host     = $cnf["dbhost"];       // Nombre del Host
                $this->port     = $cnf["dbport"];       // Nombre del puerto

                if ($cnf["usuarios_db"])
                {
                        $this->user     = $_SESSION["login"];   // Nombre del Usuario que accede
                        $this->pass     = $_SESSION["passwd"];  // Contraseña
                }
                else
                {
                        $this->user     = $cnf["dbuser"];       // Nombre del Usuario del config.inc.php
                        $this->pass     = $cnf["dbpass"];       // Contraseña
                }

                $this->dbase      = false;                          // Objeto base
                $this->error      = -1;               // numero del Ultimo Error generado
                $this->error_msg = "";               // Cadena String de error
                $this->error_int = -1;               // numero del Ultimo Error generado por el motor DB
                $this->status     = "";
                $this->result    = false;
        }
////////////////////////////////////////////////////////////////////////
        function conectar($cadena="") {
                global $cnf;
           switch ($cnf["db"])
                {
                        case "postgres":
                                if($cadena == "" )
                                {
                                        if ($this->port == "" and $this->host=="")
                                                $cadena = "dbname=".$this->dbname." user=".$this->user." password=".$this->pass;
                                        else
                                        	$cadena = "dbname=".$this->dbname." port=".$this->port." host=".$this->host." user=".$this->user." password=".$this->pass;
        }
        $this->dbase = @pg_connect($cadena);
        @pg_set_client_encoding($this->dbase, $cnf['html_charset']);
                        break;
                        case "mySQL":
                                $this->dbase = @mysql_connect($this->host.":".$this->port, $this->user, $this->pass);
                                if($this->dbase)
                                        @mysql_select_db($this->dbname);
                        break;
                }
                $this->status_con();
        }
////////////////////////////////////////////////////////////////////////
        function status_con() {
                global $cnf;
                global $m_;

                switch ($cnf["db"])
                {
                        case "postgres":
                                $this->status    = @pg_connection_status($this->dbase);
                                $this->error     = $this->status;
                        $this->error_msg = @pg_last_error($this->dbase);
                                if($this->dbase)
                        {
                                        $this->status    = @pg_connection_status($this->dbase);
                                        $this->error     = $this->status;
                                $this->error_msg = @pg_last_error($this->dbase);
                                        //return $this->error;
                                }
                                else
                                {
                                        $this->status    = @pg_connection_status($this->dbase);
                                        $this->error     = $this->status;
                                        //$this->error     = 1;
                                $this->error_msg = $m_['err_conectar_db']." - ".@pg_last_error($this->dbase);
                                }
                        break;
                        case "mySQL":
                        $this->error     = @mysql_errno($this->dbase);
                        $this->error_msg = @mysql_error($this->dbase);
                        if(!$this->dbase)
                        {
                                $this->error     = @mysql_errno($this->dbase);
                                $this->error_msg = @mysql_error($this->dbase);
                                }
                                else
                                {
                                //$this->error     = 1;
                                $this->error_msg = "";
                                        return $this->error;
                                }
                break;
                }
        }
////////////////////////////////////////////////////////////////////////
        function status($result=-2)
        {
                global $cnf;
                //if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

                //if($result == -2)
                //{
                //      $result = $this->result;
                //}
                switch ($cnf["db"])
                {
                        case 'postgres':
                                if($result != false) // Se compara de esta forma para asegurar el estado booleano FALSE, cualquier otro valor podria resultar como VERDADERO
                                {
                                        $this->status = @pg_result_status($result);
                                        $this->error  = $this->status;
                                }
                                else
                                {
                                        $this->status = 7;
                                        $this->error  = 7;
                                }
                                $this->error_msg = (@pg_last_error($this->dbase));
                        break;
                        case 'mySQL':
                                if($result != false) // Se compara de esta forma para asegurar el estado booleano FALSE, cualquier otro valor podria resultar como VERDADERO
                                {
                        $this->error     = mysql_errno($this->dbase);
                                $this->error_msg = mysql_error();
                                }
                                else
                                {
                                        $this->status = 7;
                                        $this->error  = 7;
                                $this->error_msg = mysql_error();
                                }
                                //echo "<script>alert(\"DB_FX --- ".$this->error_msg." --- ".$cnf["db"]."\")</script>";
                        break;
                }
        }
////////////////////////////////////////////////////////////////////////
        function close()
        {
                if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

                switch ($cnf["db"])
                {
                case 'postgres':
                        @pg_close($this->dbase);
                break;
                case 'mySQL':
                        @mysql_close($this->dbase);
                break;
                }
        }
////////////////////////////////////////////////////////////////////////
        function query($ssql)
        {
                if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

                switch ($cnf["db"])
                {
                        case 'postgres':
                        	$result = @pg_query($this->dbase, $ssql);
                                $this->status($result);
                                return $result;
                        break;
                        case 'mySQL':
                                $result = @mysql_query($ssql, $this->dbase);
                                $this->status($result);
                                return $result;
                        break;
                }
        }
////////////////////////////////////////////////////////////////////////
        function fetch_array($resultado = -2)
        {
                if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

                if($resultado == -2)
                {
                   $resultado = $this->result;
                }
                switch ($cnf["db"])
                {
                case 'postgres':
                        return @pg_fetch_array($resultado, NULL, PGSQL_BOTH);
                break;
                case 'mySQL':
                        return @mysql_fetch_array($resultado, MYSQL_BOTH);
                break;
                }
        }
////////////////////////////////////////////////////////////////////////
        function fetch_assoc($resultado = -2)
        {
                if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

                if($resultado == -2)
                {
                   $resultado = $this->result;
                }
                switch ($cnf["db"])
                {
                case 'postgres':
                        return @pg_fetch_assoc($resultado);
                break;
                case 'mySQL':
                        return @mysql_fetch_assoc($resultado);
                break;
                }
        }
////////////////////////////////////////////////////////////////////////
        function fetch_row($resultado=-2, $fila = 0)
        {
                global $cnf;
                //if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

                //if($resultado == -2)
                //{
                //   $resultado = $this->result;
                //}
                switch ($cnf["db"])
                {
                        case 'postgres':
                                return @pg_fetch_row($resultado, $fila);
                        break;
                        case 'mySQL':
                                return @mysql_fetch_row($resultado);
                        break;
                }
        }
////////////////////////////////////////////////////////////////////////
        function result_seek($resultado = -2, $fila = 0)
        {
                global $cnf;
                //if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

                //if($resultado == -2)
                //{
                //   $resultado = $this->result;
                //}
                switch ($cnf["db"])
                {
                        case 'postgres':
                                return @pg_result_seek($resultado, $fila);
                        break;
                        case 'mySQL':
                                return @mysql_data_seek($resultado, $fila);
                        break;
                }
        }
////////////////////////////////////////////////////////////////////////
        function num_rows($resultado = -2)
        {
                global $cnf;
                //if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

                if($resultado == -2)
                {
                   $resultado = $this->result;
                }
                switch ($cnf["db"])
                {
                case 'postgres':
                        return @pg_num_rows($resultado);
                break;
                case 'mySQL':
                        return @mysql_num_rows($resultado);
                break;
            }
        }
////////////////////////////////////////////////////////////////////////
        function num_fields($resultado = -2)
        {
                global $cnf;
                //if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

                if($resultado == -2)
                {
                  $resultado = $this->result;
                }
                switch ($cnf["db"])
                {
                        case 'postgres':
                                return @pg_num_fields($resultado);
                        break;
                        case 'mySQL':
                                return @mysql_num_fields($resultado);
                        break;
          }
        }
////////////////////////////////////////////////////////////////////////
        function field_name($resultado = -2, $col)
        {
                global $cnf;
                //if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

                if($resultado == -2)
                {
                   $resultado = $this->result;
                }
                switch ($cnf["db"])
                {
                 case 'postgres':
                        return @pg_field_name($resultado, $col);
                 break;
                 case 'mySQL':
                        return @mysql_field_name($resultado, $col);
                 break;
           }
        }
////////////////////////////////////////////////////////////////////////
        function field_table($resultado = -2, $col)
        {
                global $cnf;
                //if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

                if($resultado == -2)
                {
                   $resultado = $this->result;
                }
                switch ($cnf["db"])
                {
                 case 'postgres':
                        return "";
                        //return @pg_field_name($resultado, $col);
                 break;
                 case 'mySQL':
                        return @mysql_field_table($resultado, $col);
                 break;
           }
        }
////////////////////////////////////////////////////////////////////////
        function field_type($resultado = -2, $col)
        {
                global $cnf;

                if($resultado == -2)
                {
                   $resultado = $this->result;
                }
                switch ($cnf["db"])
                {
                        case 'postgres':
                                return @pg_field_type($resultado, $col);
                        break;
                        case 'mySQL':
                                return @mysql_field_type($resultado, $col);
                        break;
                }
        }
////////////////////////////////////////////////////////////////////////
        function affected_rows($resultado=-2)
        {
                global $cnf;

                if($resultado == -2)
                {
                   $resultado = $this->result;
                }
                switch ($cnf["db"])
                {
                        case 'postgres':
                                return @pg_affected_rows($resultado);
                        break;
                        case 'mySQL':
                                return @mysql_affected_rows($resultado);
                        break;
                }
        }

////////////////////////////////////////////////////////////////////////
} // End -- class BD


////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
global $db2;

function conectar_db7($remoto = true, $login = "", $passwd = "")
{
	global $db2;
	global $cnf;

	if($cnf["usuarios_db"] == true)
	{
		$dsn = $cnf["db"].'://'.$login.':'.$passwd.'@'.$cnf["dbhost"].':'.$cnf["dbport"].'/'.$cnf["dbname"];
	}
	else
	{
		$dsn = $cnf["db"].'://'.$cnf["dbuser"].':'.$cnf["dbpass"].'@'.$cnf["dbhost"].':'.$cnf["dbport"].'/'.$cnf["dbname"];
	}

	$db2 = ADONewConnection($dsn);
	$db2->SetFetchMode(ADODB_FETCH_ASSOC);
	//    $db = ADONewConnection($cnf["db"]);
	//$db->debug = true;

	//   if (!($db->Connect( $cnf["dbhost"], $cnf["dbuser"], $cnf["dbpass"] ) ) )
	if (!($db2) )
	{
		return false;
	}
	else
	{
		return true;
	}
}

global $db;
$db = new BD;

////////////////////////////////////////////////////////////
//=========================================================
// FUNCIONES PARA MANEJAR LA DB con o sin Scripts Remotos
//=========================================================
////////////////////////////////////////////////////////////


//===============================
// Function Conectar_DB
//===============================
function conectar_db($cadena="", $remoto=false) {
        global $cnf;
        global $m_;
        global $db;

        if ($db->user == "")
        {
                $db->user   = $cnf["dbuser"];
                $db->pass   = $cnf["dbpass"];
        }

        if($cadena == "")
                $db->conectar();
        else
                $db->conectar($cadena);

        if ($db->dbase)
                return "1"; // 1 = Si se conecto
        else
        {
                if($remoto=="true")
                   return $db->error_msg;
                else
                {
                        echo dialog(array($db->error."<br />".$db->error_msg ,"ERROR",""));
                exit;
                }
        }
}

//===============================
// Function query_db($resultado, $fila)
//===============================
function query_db($ssql, $remoto=false, $ignore=false) {
        global $m_;
        global $db;
        global $cnf;

        $result = $db->query("$ssql");
//var_dump($result);
//echo "\n $ssql";
        if (!$result)
        {
	       if($ignore == true)
	       {
	          return "ignore";
	       }
	       else
	       {
		       	$error_sql = pg_escape_string($ssql);
		       	$error_db = $db->error . "  -  " . addslashes( $db->error_msg );
				if( isset( $_SERVER['HTTP_X_FORWARDED_FOR'] )) { $ip = $_SERVER['HTTP_X_FORWARDED_FOR']; $tc = "HTTP_X_FORWARDED"; }
    			else if( isset( $_SERVER ['HTTP_VIA'] )) { $ip = $_SERVER['HTTP_VIA']; $tc = "HTTP_VIA"; }
    			else if( isset( $_SERVER ['REMOTE_ADDR'] )) { $ip = $_SERVER['REMOTE_ADDR']; $tc = "REMOTE_ADDR";  }
    			else { $ip = "NULL"; $tc= "NULL"; }
    			$login = $_SESSION['login'];
    			$dbname = $db->dbname;
    			$Esql = " INSERT INTO xapito.error_db ( ip, error_sql, login_tx, error_db, tipo_con, nom_db ) VALUES ('{$ip}', '{$error_sql}', '{$login}', '{$error_db}', '{$tc}', '{$dbname}') RETURNING id_error_db; ";
    			$resE = $db->query("$Esql");
    			$dErr = fetch_array_db($resE);
	       		if ($remoto=="true")
                {

                //        return "" . $m_['err_query_db'] . "<br /><br />$ssql<br />" . addslashes ( $db->error ) . " - " . addslashes( $db->error_msg ) ;
                        return "" . $m_['err_query_db'] . "<br />Se ha generado un error en la base de datos, informe al administrador del sistema "
                        		. "citando el caso de programa No. <b>{$dErr[0]}</b>";
                }
                else
                {
//                        echo dialog(array($m_['err_query_db'] . "<br /><br />$ssql<br />" . $db->error . " - " . $db->error_msg ,"ERROR",""));
                        echo dialog(array($m_['err_query_db'] . "<br />Se ha generado un error en la base de datos, informe al administrador del sistema "
                        		. "citando el caso de programa No. <b>{$dErr[0]}</b>" ,"ERROR",""));
                        exit;
                }
        	}
    }

        return $result;
}

//===============================
// Verifica el estado del ultimo query
// Function query_estado($error, $remoto)
//===============================
function query_estado($error_o_mensaje="err", $remoto = "false") {
        global $m_;
        global $db;

        if($error_o_mensaje == "err")
                $cad = $db->error;
        elseif($error_o_mensaje == "err_msg")
                $cad = $db->error_msg;

        if($remoto == "true")
        {
                return ("" . $cad) ;
        }
        else
        {
                return "";
        }
}

//===============================
// Function fetch_array($resultado)
//===============================
function fetch_array_db($resultado) {
        global $m_;
        global $db;
        return $db->fetch_array($resultado);
}

//===============================
// Function fetch_assoc($resultado)
//===============================
function fetch_assoc_db($resultado) {
        global $m_;
        global $db;
        return $db->fetch_assoc($resultado);
}

//===============================
// Function result_seek($resultado, $indice)
//===============================
function result_seek_db($resultado, $indice) {
        global $m_;
        global $db;
        return $db->result_seek($resultado, $indice);
}

//===============================
// Function num_rows_db($resultado) # de Filas
//===============================
function num_rows_db($resultado) {
        global $m_;
        global $db;
        return $db->num_rows($resultado);
}

//===============================
// Function num_fields_db($resultado) # de Columnas
//===============================
function num_fields_db($resultado) {
        global $m_;
        global $db;
        return $db->num_fields($resultado);
}

//===============================
// Function fetch_row_db($resultado, $fila)
//===============================
function fetch_row_db($resultado, $fila) {
        global $m_;
        global $db;
        return $db->fetch_row($resultado, $fila);
}

//===============================
// Function field_name_db($resultado, $col)
//===============================
function field_name_db($resultado, $col) {
        global $m_;
        global $db;
        return $db->field_name($resultado, $col);
}

//===============================
// Function field_table_db($resultado, $col)
//===============================
function field_table_db($resultado, $col) {
  global $m_;
  global $db;
  return $db->field_table($resultado, $col);
}

//===============================
// Function field_type_db($resultado, $col)
//===============================
function field_type_db($resultado, $col) {
        global $m_;
        global $db;
        return $db->field_type($resultado, $col);
}

//===============================
// Function affected_rows_db($resultado)
//===============================
function affected_rows_db($resultado=-2) {
        global $m_;
        global $db;
        return $db->affected_rows($resultado);
}

//===============================
// Function close_db($resultado)
//===============================
function close_db() {
  global $m_;
  global $db;
  return $db->close();
}


////////////////////////////////////////////////////////////////////////

//===============================
// Function GEN_CHLIST_DB
//===============================
function gen_chlist_db($params) {
  global $db;
  //

  //-- $field_key  = * Campo llave a traves del cual se cruza la consulta de la $table_list y la $table_sel de datos
  //-- $table_list = * Nombre de la tabla en la cual se encuentran los campos a listar
  //-- $field_list = * Campo que se muestra al usuario para determinado ID
  //-- $table_sel  = * Nombre de la tabla de la cual se sacan los datos ID de los campos a chequear en la $table_list.
  //-- $field_sel  = * Indica el campo a traves del cual se filtra la info de la tabla
  //-- $selected   = Indica cual es el valor de SELECT que debe marcarse por defecto al abrir el Formulario
  //-- $caption    = Adiciona este Caption a la Forma de Captura (Titulo del Campo)
  //-- $class      = Especifica la Clase CSS a la cual corresponde este campo
  //-- $ch_all     = Indica si se adiciona la funcion 'check_all' en JS para MARCAR todos los campos
  //-- $ch_none    = Indica si se adiciona la funcion 'check_none' en JS para DESMARCAR todos los campos
  //-- $enabled    = Por defecto = TRUE, especifica si el campo se habilita o no
  //-- $visible    = Por defecto = TRUE, especifica si el campo es visible o no
  //-- $readonly   = Por defecto = FALSE, especifica si el campo es de solo lectura o no
  //-- $cols       = Por defecto (1) Nmero de columnas para mostrar el listado de los campos
  //-- $direction  = H o V. Por defecto = H, especifica si el Caption lo ubica al lado del campo a capturar o encima

  $field_key  = $params[0];
  $table_list = $params[1];
  $field_list = $params[2];
  $table_sel  = $params[3];
  $field_sel  = $params[4];
  $selected   = $params[5];
  $caption    = $params[6];
  $class      = $params[7];
  $ch_all     = $params[8];  // x Dev
  $ch_none    = $params[9];  // x Dev
  $enabled    = $params[10]; // x Dev
  $visible    = $params[11]; // x Dev
  $readonly   = $params[12]; // x Dev
  $cols       = $params[13]; // x Dev
  $direction  = $params[14]; // x Dev

  if (!$enabled)
    $enabled = "DISABLE";
  else
    $enabled = '';
  if (!$visible)
    $visible = "style:display='none'";
  else
    $visible = '';
  if ($readonly)
    $readonly = "READONLY";
  else
    $readonly = '';

  conectar_db();

  $ssql = "SELECT $field_key, $field_list FROM $table_list ORDER BY $field_list";

  $result_list = query_db($ssql);

  $ssql = "SELECT $field_key FROM $table_sel WHERE $field_sel = '$selected' ORDER BY $field_key";

  $fields_sel = "";


  $cols=4;
  $new_row = true;
  echo "<table border=0 cellpadding=0 cellspacing=0>";
  while ($row_list = fetch_array_db($result_list))
  {
    $marcar = "";
    $result_sel = query_db($ssql);
    while ($row_sel = fetch_array_db($result_sel))
    {
      if ($row_list[$field_key] == $row_sel[$field_key])
      {
        $marcar = "CHECKED";
        $fields_sel[] = $row_sel[$field_key];
        break;
      }
    }
    // Se debe dejar la variable $row_list[1] en lugar de $row_list[$field_list] porque se pueden enviar campos
    // maquillados con otro nombre de campo diferente al contenido de la variable $field_list
    // Ejemplo:
    //    En el SELECT casa||carro||beca AS deseo;
    //    $field_list es igual al 'casa||carro||beca AS deseo'
    //    y este NO es el nombre del campo, el nombre del campo es 'deseo'.
    if ($new_row)
      echo "<tr>";
    echo "<td><INPUT CLASS='".$class."' TYPE=CHECKBOX NAME=".$field_key."[] ID='".$field_key."' VALUE='".$row_list[$field_key]."' $marcar $enabled $visible $readonly>".$row_list[1]."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<td>";
    $i++;
    if ($i == $cols)
    {
      echo "</tr>";
      $new_row = true;
      $i       = 0;
    }
    else
    {
      $new_row = false;
    }
  }
  echo "</table>";
}

// $table_list  = Nombre de la tabla en la cual se encuentran los campos a listar
// $field_key   = Campo llave a traves del cual se maneja el valor nico del registro
// $field_list  = Campo que se muestra al usuario para determinado ID
// $selected    = Indica cual es el valor de SELECT que debe marcarse por defecto
// $null        = .T. o .F. Indica si el campo en el cual se va a grabar el dato admite NULL o no
// $submit      = .T. o .F. Indica si se ejecuta SUBMIT en el momento de selecionar el campo
// $id_filtro   = Nombre del campo del formulario a traves del cual va a filtrar la informacion mostrada en este select

/*
function gen_select($params)
{
  global $db;
  //

  $table_list = $params[0];
  $field_key  = $params[1];
  $field_list = $params[2];
  $selected   = $params[3];
  $null       = $params[4];
  $submit     = $params[5];
  $id_filtro  = $params[6];

  conectar_db();
  echo $ssql;
  $ssql  = "SELECT $field_key, $field_list FROM $table_list";
  if ($id_filtro <> "")
  {
    if ($_POST[$id_filtro] <> "")
    {
      $ssql .= " WHERE $id_filtro = '".$_POST[$id_filtro]."'";
    }
    else
    {
      $ssql .= " WHERE $id_filtro IS NULL";
    }
  }
  $ssql .= " ORDER BY $field_list";
  $result = $db->query($ssql);

  // *******
  // Revisar el siguiente valor *** se deja temporalmente para solucionar el problema con el FILTRO al cargar el formulario por primera vez
  //if ($_POST[$id_filtro] == "")
  //{
  //  $_POST[$id_filtro] = 1;
  //}
  // *******


  // si el campo se requiere para el formulario verifica si existen datos b?cos en la tabla $table
  if (!$null && ($_POST[$id_filtro] <> ""))
  {
    if ($db->num_filas($result) == 0)
    {
      if ($id_filtro != "")
      {
        echo dialog(array("No existen datos en la tabla <b>$table_list</b><br>relacionado con el dato <b>$id_filtro = $_POST[$id_filtro]</b>.<br><br>
                Antes de continuar por favor dirigase a llenar estos datos o<br>seleccione otro valor para el dato <b>$id_filtro</b>.", "ERROR", ""));
      }
      else
      {
        echo dialog(array("No existen datos en la tabla <b>$table_list</b><br>los cuales son requisito de este formulario.<br><br>Por favor dirigase antes a llenar estos datos.", "ERROR", ""));
      }
      exit;
    }
  }

  $submit_text = "";
  if ($submit)
  {
    $submit_text = "onChange='javascript:document.campos.submit();'";  // Solo envia el formulario de nombre CAMPOS
  }
  echo "<select name=\"$field_key\" $submit_text>";
  if (isset($null) && $null)
  {
    echo "<option value=\"\" SELECTED='SELECTED'>----------</option>";
  }
  while ($row = pg_fetch_array($result))
  {
    if ($selected == $row[$field_key])
    {
      $marcar = "SELECTED='SELECTED'";
      $_POST[$field_list] = $row[$field_list];
    }
    else
    {
      $marcar = "";
    }
    if ($row[$field_key] != "assysdba" || $row[$field_list] != "assysdba")
      echo "<option value=".$row[$field_key]." $marcar>".$row[$field_list]."</option>";
  }
  echo "</select>";
}
*/

//======================================================================
//=================    FUNCIONES DE SEGURIDAD    =======================
//======================================================================

//===============================
// Function verificar_permiso
//===============================
function verificar_permiso($login, $permiso, $remoto=false, $log=false) {

	if(trim($permiso) == "") {return true;}

        global $cnf;
        global $db;
        conectar_db();

        if($remoto == true) { $login = $_SESSION['login']; }

        $ssql   = "SELECT count(*)
              FROM  usuarios_permisos
              WHERE id_permiso = '$permiso'
                AND login      = '$login'";

        $result = query_db($ssql);
        $row    = fetch_array_db($result);
    $cadena = "false";
// EG - 26 03 2007 agregue que el usuario dbxdba no se le verifique permisos
        if (($row[0] == 1) OR ($login == "dbxdba"))
        {
        if (!$remoto) return true;
                else return "true";
        }
        else
        {
                switch (strtoupper($cnf["db"]))
                {
                        case "POSTGRES":
                                $ssql = "SELECT nom_permiso, desc_permiso
                               FROM  permisos
                            WHERE id_permiso = '$permiso'
                           AND is_folder  = false";
                        break;
                        case "MYSQL":
                                $ssql = "SELECT nom_permiso, desc_permiso
                               FROM  permisos
                            WHERE id_permiso = '$permiso'
                           AND is_folder  = 0";
                        break;
                }
    $result = query_db($ssql);
    $row    = fetch_array_db($result);

    if (is_null($row[nom_permiso]))
    {
//                      if (!$remoto) {
                                $cadena = "<div style=\"color: Red; text-align: center;\">PERMISO NO DEFINIDO</div><br>Posible Causa: <br>Falta actualizar el listado de Permisos.<br>Por favor comun&iacute;quese con el Administrador del Sistema.<br><a href='javascript:window.history.back();'>Haga click aqu&iacute; para regresar</a>";
//                               }
//                      else { $cadena = "false"; }
    }
                else
    {
      if (trim($row[desc_permiso]) == '')
      {
//        if (!$remoto) {
                  $cadena = "<div style=\"color: Red; text-align: center;\">PERMISO DENEGADO</div><br> No tiene permiso para:<br><span style=\"font-weight: bolder;\">".$row[nom_permiso]. "</span><br><br>Si desea obtener este permiso, comun&iacute;quese con el Administrador del Sistema.<br><a href='javascript:window.history.back();'>Haga click aqu&iacute; para regresar</a>";
//                }
//                              else { $cadena = "false"; }
      }
                        else
                        {
//        if (!$remoto) {
                  $cadena = "<div style=\"color: Red; text-align: center;\">PERMISO DENEGADO</div><br> No tiene permiso para:<br><span style=\"font-weight: bolder;\">".$row[nom_permiso]. "</span><br><br>Si desea obtener este permiso, comun&iacute;quese con el Administrador del Sistema.<br><a href='javascript:window.history.back();'>Haga click aqu&iacute; para regresar</a>";
//                }
//                              else { $cadena = "false"; }
      }
                }

      if ((!$remoto) && ($cadena != "false" ))
                {
                  echo dialog(array($cadena,"ERROR",""));
                        if($log)
                        {
                                session_unset();
                                session_destroy();
                        }
                  exit;
                }
                else return $cadena;
  }
}

//===============================
// Function LOGIN
//===============================
function login($login, $passwd, $remoto=false, $nivel_usuario=true, $ws=false) {
//echo "L\n";
        global $cnf;
        global $m_;
        global $db;
        $ipRemota = $_SERVER['REMOTE_ADDR'];

        if ( ($remoto == true) AND ($login == "") ) {
	        $login  = $_SESSION["login"];
	        $passwd = $_SESSION["passwd"];
   		}

        if($ws === true) {
                if(trim($db->error_msg) != "") {
                        return Array(false, $db->error_msg, $db->error, 'p1');
                }
        }

    //    $login = pg_escape_string($login);

         if( !(buscaProhibidos("{$login}", true) AND buscaProhibidos("{$passwd}", true)) ) {
        	$error= "El usuario o la contraseña contienen Caracteres invalidos.";
        	$success = 'false';
        	if (!$remoto) {
        		echo dialog(array("El usuario o la contraseña contienen Caracteres invalidos.","INFO","",true));
        		exit;
        	}
        	else if($ws === true) {
        		return Array(false, "El usuario o la contraseña contienen Caracteres invalidos.", "002");
        		exit;
        	}
        	else {
        		return false;
        		exit;
        	}
        }

        $db->dbname = $cnf["dbname"];
        conectar_db("",$ws);

        $passwd = md5($passwd);

// EG 08/01/2009 - Usu Activo
        $ssql   = "SELECT is_activo, count(login) as cl, (NOW()::date - fec_tx::date) AS dias_pasabordo, dm_cambia_passwd
                       FROM xcomun.usuarios
                       WHERE login  = '$login'
                       AND passwd = '$passwd'
                       GROUP BY is_activo, fec_tx, dm_cambia_passwd; ";

                $result = query_db($ssql, $ws);

        if($ws === true) {
                if(trim($db->error_msg) != "") {
                        return Array(false, $db->error_msg, $db->error, 'p2');
                }
        }
        $rowUsuario    = fetch_array_db($result);

//echo $ssql;
//var_dump($result);
//echo $row[0] . " - " . $row[1] . " - ". count($row);
        if(trim($rowUsuario[1]) == "") {
         if (!$remoto) {
            echo dialog(array("El usuario o el pasabordo son erroneos","INFO","",true));
            exit;
          }
          else if($ws === true) {
                  return Array(false, "El usuario o el pasabordo son erroneos", "002");
          }
          else {
           return false;
                exit;
          }
        }

        if(($rowUsuario[0] == "f") OR ($rowUsuario[0] == "false") OR ($rowUsuario[0] == false)) {
            if (!$remoto) {
              echo dialog(array("El usuario esta desactivado, comuniquese con el Administrador","INFO","",true));
              exit;
            }
           else if($ws === true ) {
               return Array(false, "El usuario esta desactivado, comuniquese con el Administrador", "003");
            }
           else exit;
        }

         if ($nivel_usuario)
        {
                $ssql   = "SELECT count(*), id_nivel_usuario
                       FROM  usuarios
                       WHERE login  = '$login'
                                             AND passwd = '$passwd'
                                                GROUP BY id_nivel_usuario";
   }
        else
        {
                $ssql   = "SELECT count(*)
                       FROM  usuarios
                       WHERE login  = '$login'
                                             AND passwd = '$passwd'";
   }

        $result = query_db($ssql);
        $row    = fetch_array_db($result);
//echo "993\n";
//var_dump($row);
//echo "\nnivel: $nivel_usuario\n";
//var_dump($nivel_usuario);
        if ( ($row[0] == 1) AND (count($row)>0) )
        {
                if ($nivel_usuario)
                {
                        $id_grupos = "";
                        $nom_grupos = "";
                        $cnf["nivel_usuario"] = $row[1];

                        // Trae los IDs de los grupos a los que el usuario pertenece
                        $ssql   = "SELECT id_grupo
                               FROM  usuarios_grupos
                               WHERE login  = '$login'";
                        $result = query_db($ssql);
                        while($row = fetch_array_db($result))
                                $id_grupos .= $row[0].",";
// jsalert("EDG: $id_grupos");
                        $cnf["grupos_usuario"] = substr($id_grupos,0,strlen($id_grupos)-1);

                        // Trae los NOMBRES de los grupos a los que el usuario pertenece
                        $ssql   = "SELECT nom_grupo
                               FROM  grupos
                               WHERE id_grupo IN (".$cnf["grupos_usuario"].")";
                        $result = query_db($ssql);
                        while($row = fetch_array_db($result))
                                $nom_grupos .= $row[0]."<br />";
                        $cnf["grupos_usuario_maq"] = substr($nom_grupos,0,strlen($nom_grupos)-6);
                        //jsalert($cnf["grupos_usuario_maq"]);

                        // Configuracion x Grupo
                        $ssql = "SELECT nom_cnf, vr_cnf FROM cnf_grupos
                     WHERE id_grupo IN (".$cnf["grupos_usuario"].")";
                        $result = query_db($ssql, false, true);
                        if($result != "ignore")
                        {
                        while($row = fetch_array_db($result))
                        {
			               $cnf[$row[0]] = $row[1];
			               $_SESSION["cnf"][$row[0]] = $row[1];
            			}
         }

                }

                $cambiaPasswd = $rowUsuario[3];
//var_dump($cambiaPasswd); echo "\n";
//var_dump($rowUsuario[2]);          echo "\n";
//var_dump($_SESSION["cnf"]);  echo "\n";
                //Dias del Pasabordo
if(!isset($_SESSION["cnf"]["dias_cambia_passwd"])) {
	// Webservice
	$_SESSION["cnf"]["dias_cambia_passwd"] = 3650;
}
                if( $rowUsuario[2]  >= $_SESSION["cnf"]["dias_cambia_passwd"]) {
                	$cambiaPasswd = 2;
                }

                //Cambia Pasabordo
                if($cambiaPasswd != 0) {

                	//Redirecciones al cambio de pasabordo y de la razon
                	$pos = strrpos($_SERVER['SCRIPT_NAME'], '/');
                	$asd = substr($_SERVER['SCRIPT_NAME'], $pos+1 );

                	if(($asd != "cambia_passwd.php") AND ($asd != "cambia_passwd.sr.php") ) {
                		//header("Location: {$cnf['forms_path']}/cambia_passwd.php?razon={$cambiaPasswd}");
                		echo "<script type='text/javascript'><!--"
                				. "\n window.location='{$cnf['forms_path']}/cambia_passwd.php?razon={$cambiaPasswd}';"
                				. "\n //--> </script>";
        			}
                }

                xapito_Acceso($ipRemota, $login, 'I');

                if( function_exists('dataLogin') ) dataLogin($login);

                if (!$remoto) {return true;}
                else if($ws === true) {
                        return Array(true, "Bienvenido al sistema", "");
                }
                else return 'true';
        }
        else
        {
                if (!$remoto)
                {
                        echo dialog(array($m_['err_login'],"ERROR",""));
                        xapito_Acceso($ipRemota, $login, 'F');
                        return false;
                }
                else if($ws === true) {
                        return Array(false, "Acceso Denegado", "003");
                }
                else return 'false';
        }
}

////////////////////////  FUNCIONES XAPITO
/// EG - 2007 10
////////////////////////////////////////////////////////////////////////
function xapito_Acceso($ipRemota, $login, $evento) {
        conectar_db();
        $result = query_db("INSERT INTO xapito.x_acceso (ip, login, nom_evento) VALUES ( '$ipRemota', '$login', '$evento');");
}

//////////////////////  FUNCIONES NUEVAS DE MANEJO DE RECEPCION DE DATOS
/// EG - 2007 07
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
function dNdataGuardar( $operacion, $tablas, $pks, $values ) {
  global $cnf;
//jsalert($operacion);
  $OPERACIONES = explode($cnf["separador_reg"],$operacion);

  $TABLAS = explode($cnf["separador_reg"],$tablas);
  $PKS = explode($cnf["separador_reg"],$pks);
  $DATOS = explode($cnf["separador_reg"],$values);
  $n = 0;
  foreach($OPERACIONES as $v)
  {
//jsalert("0'. - ". $v );
//	 if(trim($v) != "") {
	 $OPERACIONES[$n] = explode($cnf["separador_col"], $v);
//jsalert($v);
	 //jsalert("($n)   ". $OPERACIONES[$n][0] . " - " .$OPERACIONES[$n][1]. " - ". $OPERACIONES[$n][2] );
	 $n++;
//	 }
  }
  reset($OPERACIONES);
  $n = 0;
  foreach($DATOS as $v)
  {
	 if(trim($v) != "") {
    $DATOS[$n] = explode($cnf["separador_col"],$v);
    $n++;
	 }
  }
  reset($DATOS);

  $dnD = array();
  $n = 0;
/////////////////////////////////////////
//jsalert($OPERACIONES[$n][0] . " - " .$OPERACIONES[$n][1]. " - ". $OPERACIONES[$n][2] );

  foreach($DATOS as $v)
  {
    $tmp = array();
    $tmp[0] = $v[0];  // Formulario
    $tmp[1] = $v[1];  // Registro
	 reset($OPERACIONES);
	 $O = $OPERACIONES;
//jsalert( 	 "{$O[0][0]} - {$O[0][1]} -- {$O[1][0]} - {$O[1][1]} " );
    foreach($OPERACIONES as $t)
    {
// jsalert(" {$t[0]} == {$v[0]}  AND  {$t[1]} == {$v[1]}  ");
		if( ($t[0] == $v[0]) AND ($t[1] == $v[1]) )
      {
        $tmp[2] = $t[2];  // Operacion
      }
//      else {
//		  $tmp[2] = 0;
//		}
    }
    $tmp[3] = $TABLAS[$v[0]];  // Tabla
    $tmp[4] = $PKS[$v[0]];  // PK
    $tmp[5] = $v[2];  // Nombre de Columna
    $tmp[6] = $v[3];  // Valor de Columna

// jsalert( "1. " .$tmp[0] . "   -  " . $tmp[1]. "   -  " . $tmp[2]. "   -  " . $tmp[3]. "   -  " . $tmp[4]. "   -  " . $tmp[5]. "   -  " . $tmp[6] );

    if($tmp[0] != "" AND $tmp[1] != "" AND $tmp[2] != "" AND $tmp[3] != "" AND $tmp[4] != "" AND $tmp[5] != "" AND $tmp[6] != "" )
    {
//  jsalert( "2. " . $tmp[0] . "   -  " . $tmp[1]. "   -  " . $tmp[2]. "   -  " . $tmp[3]. "   -  " . $tmp[4]. "   -  " . $tmp[5]. "   -  " . $tmp[6] );
      $dnD[$n] = $tmp;
      $n++;
    }
  }

return $dnD;
}

////////////////////////////////////////////////////////////////////////
function dNfiltrodatos($data = array(), $formulario = -1, $funcion = -1) {
 $sR = array();
 $n = 0;
 reset($data);
 foreach($data AS $v)
 {
   if($formulario == -1 )
   {
        if($funcion == -1)
        {
          $sR[$n] = $v;
          $n++;
        }
        else
        {
           if($v[2] == $funcion)
           {
              $sR[$n] = $v;
              $n++;
           }
        }
   }
   else
   {
// jsalert("$v[0]  -  $formulario");
     if($v[0] == $formulario)
     {
        if($funcion == -1)
        {
          $sR[$n] = $v;
          $n++;
        }
        else
        {
           if($v[2] == $funcion)
           {
              $sR[$n] = $v;
              $n++;
           }
        }
     }
   }
 }
 return $sR;
}
////////////////////////////////////////////////////////////////////////
function dNfiltroReg($data = array(), $nReg = 0 ) {
 $dataF = array();
 reset($data);

  foreach($data AS $v)
  {
   if( $v[1] == $nReg )
   {
         array_push($dataF,$v);
        }
  }

 return $dataF;
}

////////////////////////////////////////////////////////////////////////
function dNInsertCol($data = array(), $nom_col = "", $val_col = "" ) {
 $sR = array();
 $n = 0;
 $reg = -1;
 $found = false;

  reset($data);
  foreach($data AS $v) {
    if( $v[1] != $reg ) {
      $found = false;
    }

    $sR[$n] = $v;
    $n++;

    if( (trim($v[5])) == (trim($nom_col)) ) {
      $found = true;
    }

    if( ($found == false) AND ($v[1] != $reg ) ) {
      $sR[$n] = array( $v[0], $v[1], $v[2], $v[3], $v[4], $nom_col, $val_col );
      $reg = $v[1];
      $found = true;
      $n++;
    }

  }

  $found = false;
  foreach($sR AS $v) {
    if((trim($v[5])) == (trim($nom_col)) ) {
      $found = true;
      break;
    }
  }
  if($found == false) {
     $sR[$n] = array( $v[0], $v[1], $v[2], $v[3], $v[4], $nom_col, $val_col );
  }

 return $sR;
}

////////////////////////////////////////////////////////////////////////
function dNDeleteCol($data = array(), $nom_col = "" ) {
 $sR = array();
 $n = 0;
 reset($data);
  foreach($data AS $v)
  {
    if($v[5] != $nom_col )
    {
      $sR[$n] = $v;
      $n++;
    }
  }
 return $sR;
}

////////////////////////////////////////////////////////////////////////
function dNUpdateCol($data = array(), $nom_col = "", $new_val = "" ) {
 $sR = array();
 $n = 0;
 reset($data);
  foreach($data AS $v)
  {
    if(strtolower(trim($v[5])) == strtolower(trim($nom_col)) )
    {
      $sR[$n] = array( $v[0], $v[1], $v[2], $v[3], $v[4], $v[5], $new_val );
      $reg = $v[1];
      $n++;
    }
    else
    {
      $sR[$n] = $v;
      $n++;
    }
  }
 return $sR;
}

////////////////////////////////////////////////////////////////////////
function dNFindCol($data = array(), $nom_col = "") {
 $bR = false;
 reset($data);

  foreach($data AS $v) {
    if( strtolower(trim($v[5])) == strtolower(trim($nom_col)) ) {
      $bR = true;
      break;
    }
  }

 return ($bR);
}

////////////////////////////////////////////////////////////////////////
function dNretVal($data = array(), $nom_col = "" ) {
 $sR = "";
 reset($data);
  foreach($data AS $v)
  {
// jsalert("$v[5] -  $nom_col  -  ($v[6])");
    if($v[5] == $nom_col )
    {
      $sR = $v[6];
    }
  }
 return $sR;
}
////////////////////////////////////////////////////////////////////////
function dNAretVal($data = array(), $nom_col = "" ) {
 $sR = "";
 reset($data);
  foreach($data AS $v)
  {
    if($v[5] == $nom_col )
    {
      if($sR == "")
      {
              $sR .= $v[6];
                }
                else
                {
              $sR .= ", " . $v[6];
                }
    }
  }
 return $sR;
}

////////////////////////////////////////////////////////////////////////
function dNcount($data = array()) {
 $nR = 0;
 reset($data);
  foreach($data AS $v)
  {
      $nR += 1;
  }
 return $nR;
}
////////////////////////////////////////////////////////////////////////
function dNcountReg($data = array()) {
 $nR = 0;
 $regF = -1;
 reset($data);
  foreach($data AS $v)
  {
   if( $v[1] != $regF )
   {
                $nR ++;
                $regF = $v[1];
        }
  }
 return $nR;
}

////////////////////////////////////////////////////////////////////////
function dNgenSQL( $data = array() , $tipo = "text") {
 $sR = array();
 reset($data);
 $reg = -1;
 $n = 0;
 $campos = "";
 $values = "";
 $parejas = "";
 $valKey = "";
 $valKeyd = "";

  foreach($data AS $v)
  {
//  jsalert( $v[0] . " - " .  $v[1] . " - " .  $v[2] . " - " .  $v[3] . " - " .  $v[4] . " - " .  $v[5] . " - " .  $v[6] );
//var_dump($v);

    if($v[2] == 0 ) // INSERT
    {
// jsalert("Insert $reg - " . $v[1] );
      $opera = 0;
      $tabla =  $v[3];

      if( ($reg != -1) AND ($reg != $v[1]) )
      {
// jsalert($campos);
        $sR[$n] = "INSERT INTO $tabla ( $campos ) VALUES ( $values ); ";
        $n++;
        $campos = "";
        $values = "";
      }

        if($campos == "")
        {
          $campos = $v[5];
          if(trim($v[6]) == "") {
                        $values = "NULL";
              }
          else {
                        $values = "'" . trim($v[6]) . "'";
              }
        }
        else
        {
          $campos .= ", " . $v[5] ;
          if(trim($v[6]) == "") {
                        $values .= ", NULL";
              }
          else {
                        $values .= ", '" . trim($v[6]) . "'";
              }
        }

         $posicion = strpos($parejas, "$v[5] = '");
         if ($posicion === false)
         {
            if($parejas == "")
            {
                                  if(trim($v[6]) == "") {
                                        $parejas =  " $v[5] IS NULL";
                                  }
                                  else {
                                        $parejas =  " $v[5] = '$v[6]'";
                                  }

            }
            else
            {
                                  if(trim($v[6]) == "") {
                                        $parejas .=  " AND $v[5] IS NULL";
                                  }
                                  else {
                                        $parejas .=  " AND $v[5] = '$v[6]'";
                                  }
            }
         }

        $reg = $v[1];
    }

    if( ($reg == -1) AND  (trim($v[5]) == trim($v[4]) ))  $valKey = $v[6];
    if($v[2] == 1 ) // UPDATE
    {
// jsalert("Update $reg - " . $v[1] );
      $opera = 1;
      $tabla = $v[3];

      if( ($reg != -1) AND ($reg != $v[1]) )
      {
// jsalert($parejas . " - " . $valKey );
        $sR[$n] = "UPDATE $tabla SET $parejas WHERE $v[4] = $valKey; " ;
        $n++;
        $parejas = "";
      }

         $posicion = strpos($parejas, "$v[5] = '");
         if ($posicion === false)
         {
            if($parejas == "")
            {
// 2012-6-1  Se adiciono validacion para null aca y en el sig else molestaba en correspondencia_rec
				if(trim($v[6]) == "") {
					$parejas =  " $v[5] = NULL";
				} else {
					$parejas =  " $v[5] = '$v[6]'";
				}
            }
            else
            {
				if(trim($v[6]) == "") {
					$parejas .=  ", $v[5] = NULL";
				} else {
					$parejas .=  ", $v[5] = '$v[6]'";
				}
            }
         }

      $reg = $v[1];
      if(trim($v[5]) == trim($v[4]) )  $valKey = $v[6];
    }

    if($v[2] == 2 ) // DELETE
    {
// jsalert("Delete $reg - " . $v[1] );
      $opera = 2;
      $tabla =  $v[3];
      if($v[5] == $v[4] )  $valKeyd = $v[6];

      if( ($reg != -1) AND ($reg != $v[1]) )
      {
        $sR[$n] = "DELETE FROM $tabla WHERE $v[4] = $valKeyd; " ;
        $n++;
      }

      $reg = $v[1];
     }

  }
// jsalert($parejas);
// Inserta el ultimo n
// if(($n == 0))
   {
     if($opera == 0) $sR[$n] = "INSERT INTO $tabla ( $campos ) VALUES ( $values ) RETURNING $v[4]; ";
     // Eliminado por error el dia Dic 30 de 2013 "SELECT $v[4] FROM $tabla WHERE $parejas; "; // este retorno sirve cuando el registro insertado es unico
     if($opera == 1) $sR[$n] = "UPDATE $tabla SET $parejas WHERE $v[4] = $valKey RETURNING $v[4]; " ;
     if($opera == 2) $sR[$n] = "DELETE FROM $tabla WHERE $v[4] = $valKeyd RETURNING $v[4]; " ;
   }

reset($sR);
if($tipo == "text")
{
  $sql = "";
  foreach($sR AS $v)
  {
    $sql .= $v;
  }

 $sR = $sql;
}

 return $sR;
}

// 121126
function buscaProhibidos($txt, $adicional = false) {
	$nivel_error = 	error_reporting();
	error_reporting(0);

	$PROHIBE = Array();
	array_push($PROHIBE, "SELECT");
	array_push($PROHIBE, "UPDATE");
	array_push($PROHIBE, "INSERT");
	array_push($PROHIBE, "DELETE");
	array_push($PROHIBE, "FROM");
	array_push($PROHIBE, "pg_tables");
	array_push($PROHIBE, "pg_namespace");
	array_push($PROHIBE, "pg_class");

	if($adicional === true) {
		array_push($PROHIBE, "WHERE");
		array_push($PROHIBE,  "'");
		array_push($PROHIBE, html_entity_decode('&#039;'));
		array_push($PROHIBE, html_entity_decode('&#034;'));
		array_push($PROHIBE, '"');
		array_push($PROHIBE, html_entity_decode('&#096;'));
		array_push($PROHIBE, '`');
		array_push($PROHIBE, 'chr(');
	}

	$txt2 = html_entity_decode($txt);
	$txt3 = htmlentities($txt, ENT_QUOTES, "UTF-8");

//var_dump($txt);
//var_dump($txt2);
//var_dump($txt3);

	$resultado = true;

	for($n=0; $n < count($PROHIBE); $n++) {
		if( ( stripos($txt, "{$PROHIBE[$n]}") === FALSE )
		AND ( stripos($txt, "{$PROHIBE[$n]} ") === FALSE )
		AND ( stripos($txt, "{$PROHIBE[$n]}(") === FALSE ) ) {
			// No encontrado pal mas espacio
			// No encontrado pal mas parentesis
		}
		else {
			$resultado = false;
			$n += count($PROHIBE);
			break;
		}

		if( ( stripos($txt2, "{$PROHIBE[$n]}") === FALSE )
		AND ( stripos($txt2, "{$PROHIBE[$n]} ") === FALSE )
		AND ( stripos($txt2, "{$PROHIBE[$n]}(") === FALSE ) ) {
			// No encontrado pal mas espacio
			// No encontrado pal mas parentesis
		}
		else {
			$resultado = false;
			$n += count($PROHIBE);
			break;
		}

		if( ( stripos($txt3, "{$PROHIBE[$n]}") === FALSE )
		AND ( stripos($txt3, "{$PROHIBE[$n]} ") === FALSE )
		AND ( stripos($txt3, "{$PROHIBE[$n]}(") === FALSE ) ) {
			// No encontrado pal mas espacio
			// No encontrado pal mas parentesis
		}
		else {
			$resultado = false;
			$n += count($PROHIBE);
			break;
		}


	}

	error_reporting($nivel_error);
	return $resultado;
}
function construyeSQL($campoBUS, $sBUS, $sBUS2, $campos, $pk, $tabla, $sFiltro, $nLIMIT, $pagACT, $nOFFSET, $orden, $TipoOrd, $bConsulta
		, $titulos, $SQL="" ) {
	/*	var P1 = ArraytoString(this.campoBUS, separador_col);
	 var P2 = this.sBUS;
	var P3 = this.sBUS2;
	var P4 = this.campos;
	var P5 = this.pk;
	var P6 = this.tabla;
	var P7 = this.sFiltro;
	var P8 = this.nLIMIT;
	var P9 = this.pagACT;
	var P10 = this.nOFFSET;
	var P11 = this.orden;
	var P12 = this.TipoOrd;
	var P13 = false;
	var P14 = this.titulos;
	*/
	global $cnf;
//echo "$nLIMIT, $pagACT, $nOFFSET, $orden, $TipoOrd \n ";
//echo "$campoBUS, $sBUS, $sBUS2, $campos, $pk, $tabla, $sFiltro, $nLIMIT, $pagACT, $nOFFSET, $orden, $TipoOrd, $bConsulta, $titulos, $SQL";

	if( !buscaProhibidos($campoBUS)
			OR !buscaProhibidos($sBUS)
			OR !buscaProhibidos($sBUS2)
			OR !buscaProhibidos($campos)
			OR !buscaProhibidos($pk)
			OR !buscaProhibidos($tabla)
			OR !buscaProhibidos($sFiltro)
			OR !buscaProhibidos($nLIMIT)
			OR !buscaProhibidos($pagACT)
			OR !buscaProhibidos($nOFFSET)
			OR !buscaProhibidos($orden)
			OR !buscaProhibidos($TipoOrd)
			OR !buscaProhibidos($bConsulta)
			OR !buscaProhibidos($titulos) ) {

		return "ERROR SQL"; // ERROR -- SQL injection
	}
//echo $sFiltro;
	$SQL = filtrarSQL($sFiltro);

	//var_dump($sFiltro, $SQL);

	$campoBUS = explode(",", $campoBUS );

	$orden_ = "";
	$where_ = "";
	$wPart2_ = "";
	$buscado_ = "";

	$cadSQL_ = "";
	$sSQL = "";
	if(count($campoBUS) > 0 ) {$iCampoBuscar_ = true; } else { $iCampoBuscar_ = false; }
	// construyendo el SELECT

	// EG 2009-01-26
	if($TipoOrd == "A") {$TipoOrd = "ASC";}
	else if($TipoOrd == "D") {$TipoOrd = "DESC";}
	else if($TipoOrd == "ASC") {$TipoOrd = "ASC";}
	else if($TipoOrd == "DESC") {$TipoOrd = "DESC";}
	else {$TipoOrd = "ASC";}

	if (strlen(trim($SQLmanual)) > 0) {
		$sSQL = trim($SQLmanual);
	}
	else
	{
		if($bConsulta == true)
		{
			if(trim($pk) != "")
			{
				$sSQL = "SELECT " . trim($campos) . "," . trim($pk) . " FROM " . trim($tabla) ;
			}
			else
				$sSQL = "SELECT " . trim($campos) . " FROM " . trim($tabla);
		}
		else
		{
			$sSQL = "SELECT * FROM " . trim($tabla);
		}
	}

	if(($bConsulta == "CBbd"))
	{
		$sSQL = "SELECT " . trim($campos) . " FROM " . trim($tabla);
		if(trim($pk) != "") {
			$sSQL = "SELECT " . trim($campos) . "," . trim($pk) . " FROM " . trim($tabla);
		}

		if(trim($titulos) != "") {
			$sSQL = "SELECT " . trim($campos) . "," . trim($pk) . " FROM " . trim($tabla);
		}

		if((trim(this.pk) != "") && (trim($titulos) != "")) {
			$sSQL = "SELECT " . trim($campos) . "," . trim($titulos) . "," . trim($pk) . " FROM " . trim($tabla);
		}
	}

	//construye LIMIT OFFSET
	$nOFFSET = ($nLIMIT * $pagACT) - $nLIMIT;

	if($nOFFSET < 0) { $nOFFSET = 0; }
	//construye ORDER BY
	if ($orden == "")
		$orden_ = "";
	else
		$orden_ = " ORDER BY " . $orden . " " . $TipoOrd;

	//construyendo el WHERE
	$where_ = trim($SQL);

	if (( strlen($where_) > 0) OR ( count($campoBUS) > 0))
	{
		$wPart2_ = "";
		$buscado_ = "" . trim($sBUS);

		if($iCampoBuscar_ == true)
		{
			if ( strlen($buscado_) > 0 AND count($campoBUS) > 0 )
			{
				for($m=0; $m < count($campoBUS); $m++)
				{
				if($wPart2_ != "" ) { $wPart2_ .= " OR "; }

				if($sBUS2 == "%")
				{
				// PARTIMOS LA CADENA BUSCADA y enlazamos cada palabra con una OR
					$aT_ = explode( ' ', $buscado_);
					for($n = 0; $n < count($aT_); $n++)
					{
						if(trim($campoBUS[$m]) != "" ) {
							//$wPart2_ .= "UPPER(" . $campoBUS[$m] . "::TEXT) LIKE UPPER('" . $sBUS2 . $aT_[$n] . $sBUS2 . "')" ;
							$wPart2_ .= "UPPER(" . $campoBUS[$m] . "::TEXT) LIKE UPPER('" . $aT_[$n] . "')" ;
							if( $n<(count($aT_) - 1) )
							{
								$wPart2_ .= " OR ";
							}
						}
					}
				}
				else
				{
							$wPart2_ .= "UPPER(" + $campoBUS[$m] . "::TEXT) LIKE UPPER('" . $buscado_ . "')" ;
				}
			}
									$wPart2_ = "( " . $wPart2_ . " )";
			}
			}
			else
			{
								$wPart2_ = "";
	}

	if(strlen($where_) > 0)
	{
		if(strlen($wPart2_) > 0) {
		$where_ .= " AND " . $wPart2_;
		} else {
		$where_ .= "";
		}
		}
		else
		{
			if(strlen($wPart2_) > 0) {
			$where_ = $wPart2_;
			} else {
			$where_ = "";
			}
			}
			}
			else {
				$where_ = "";
			}

			if (trim($where_) != "")
			{
			if ( strpos($sSQL, "WHERE") === false ) {
			$where_ = " WHERE " . $where_;
			} else {
					$where_ = " AND " . $where_;
			}
	}
	//END construyendo el WHERE

							if($bConsulta == true)
							{
							$cadSQL_ = $sSQL . " " . $where_ . " " . $orden_;
							if( $nLIMIT > 0 )
							{
								switch ( strtoupper($cnf["db"]) )
								{
									case "POSTGRES":
//echo "$nOFFSET";
										$cadSQL_ .= " LIMIT " . $nLIMIT . " OFFSET " . $nOFFSET;
										break;

									case "MYSQL":
										$cadSQL_ .= " LIMIT " . $nOFFSET . ", " . $nLIMIT;
										break;
								}
							}
							}
							else
							{
								$cadSQL_ = $sSQL . " " . $where_;
							}

							/*
							 if($bConsulta == "XML")
							 {
							_XMLcampos = arguments[1];
							this.sSQL = "SELECT " + _XMLcampos + " FROM " + this.tabla.trim();
							_cadSQL = ( this.sSQL + " "+ _where );
							}
							*/

							return $cadSQL_;
	}

function filtrarSQL($sFiltro) { // Filtra

		// fSQL( "(,id_via,=,formatNumero);(AND,id_via,>=,);(,id_via,id_via,)" );
		$cTxt = $sFiltro;
		$aTxt = explode(';', trim($cTxt));
		$aArr = Array();

		$tam = 0; // Tamaño de la cadena 0
		$cad = "";
		$aT = null;
		$conector = "";
		$objeto = "";
		$oT = false;
		$oT2 = false;
		$operador = "";
		$n = 0;
		$m = 0;

		for($n=0; $n < count($aTxt); $n++)
		{
			// Limpia Espacios
			$aTxt[$n] = trim($aTxt[$n]);

			// Limpia Corchetes
			$tam = strlen($aTxt[$n]);
			if($tam > 0) {
				if( ( substr($aTxt[$n], 0,1) == '(') && (substr($aTxt[$n], $tam-1, 1) == ')' ) ) {
					$aTxt[$n] = substr($aTxt[$n], 1,$tam-2);
				}

				$aArr[$n]= explode(',', $aTxt[$n]) ;
			}
		}
		// contar los argumentos, cada argumento sera un array de 4 o mayor
		/*
		conector booleanos - sale de un array
		id del campo
		operandos booleanos - sale de un array - si no esta en la lista busquelo como id de campo
		funcion JS para maquillar el valor antes de enviarlo
		*/

		$operadores = array();
		$conectores = array();

		$conectores[0] = "OR";
		$conectores[1] = "AND";

		$operadores[0] = ">";
		$operadores[1] = "<";
		$operadores[2] = ">=";
		$operadores[3] = "=";
		$operadores[4] = "!=";
		$operadores[5] = "<=";
		$operadores[6] = "LIKE";
		$operadores[7] = "IN";
		$operadores[8] = "IS";
		$operadores[9] = "ISNULL";
		$operadores[10] = "ISNOTNULL";
		$operadores[11] = "PARENTESISABRIR";
		$operadores[12] = "PARENTESISCERRAR";
		$operadores[13] = "ILIKE";

		for($n=0; $n < count($aArr); $n++) {
							$aT = $aArr[$n];
							$conector = "";
							$objeto = "";
							$oT = false;
							$oT2 = false;
							$operador = "";
							$valor = "";
							for($m=0; $m<count($conectores); $m++) { if($conectores[$m] == $aT[0]) {$conector = $conectores[$m]; } }
							$valor = $aT[3];

							for($m=0; $m<count($operadores); $m++) { if(trim($operadores[$m]) == trim($aT[2])) {$operador = $operadores[$m]; } }
							if($n == 0) {$conector = "";} else {$conector = " " . $conector;}

							// no se encontro el operador puede ser un Between
			if($operador == "")	{
							// Recibe un array de 5 parametros
							if(count($aT) == 5) {
							$operador = " BETWEEN '" . $valor . "' AND '" . $aT[4] . "'";
							$cad .= $conector . " " .  $aT[1] . $operador;
							}
							else
							{ return(false); }
			}
			else {
				if($operador == "ISNULL")
				{
							$cad .= $conector . " " . $aT[1] . " IS NULL ";
				}
				else if($operador == "ISNOTNULL")
				{
					$cad .= $conector . " " . $aT[1] . " IS NOT NULL ";
				}
				else if($operador == "IS")
				{
					$cad .= $conector . " " . $aT[1] . " " . $operador . " " . $aT[3];
				}
				else if($operador == "IN")
				{
								$oT2VAL_ = "";
								for($b=3; $b < count($aT); $b++ ) {
									if ($b > 3) { $oT2VAL_ .= ", "; }
									$oT2VAL_ .= trim($aT[$b]);
								}
							$cad .= $conector . " " .  $aT[1] . " " . $operador . " " . "(" . $oT2VAL_ . ")";
				}
				else if( $operador == "LIKE" )
				{
					$cad .= $conector . " UPPER( " .  $aT[1] . "::TEXT ) " . $operador . " ( " . "'". trim($aT[3]) . "' )";
				}
				else if( $operador == "ILIKE" )
				{
					$cad .= $conector . " ( " .  $aT[1] . "::TEXT ) " . $operador . " ( " . "'%". trim($aT[3]) . "%' )";
				}
				else if($operador == "PARENTESISABRIR")
				{
										$cad .= " {$conector} ( ";
				}
				else if($operador == "PARENTESISCERRAR")
				{
					$cad .= " ) ";
				}
				else {
					if ($valor != "")
					{
						$oT2VAL_ = trim($valor);
						if(strtoupper($oT2VAL_) == "TRUE")
						{
							$cad .= $conector . " " . $aT[1] . " " . $operador . " " . "TRUE";
						}
						else if(strtoupper($oT2VAL_) == "FALSE")
						{
							$cad .= $conector . " " .  $aT[1] . " " . $operador . " " . "FALSE";
						}
						else if( gettype(_oT2VAL) == "string" )
						{
							$cad .= $conector . " " .  $aT[1] . " " . $operador . " " . "'". $oT2VAL_ . "'";
						}
					}
				}
			}
		}

/*		if(this.SQL.trim() == "")
			this.SQL = cad;
		else
		{
			if(this.oriSQL != "")
				this.SQL = this.oriSQL + " AND " + cad;
			else
				this.SQL = cad;
		}
*/
		return $cad;
	}

?>
