// Upload JavaScript
/*
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 0. - Declaracion de variables
// 1. Control Upload - Crea un Controlador Upload
// 2. Objeto Control Upload
// 3. Funcion _Inicio_cUL
// 4. Funcion _Type_cUL
// 5. Visibilidad - Muestra u Oculta una parte o una opcion del control
// 6. Busca un Control UpLoad
// 7. Funcion de Subida de Archivo

// Requerimientos bien
// scriptaculous
*/
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 0. Variables
var _aUpload = new Array();
var _aUploadDir = new Array();
var dirLibsPHP = (dirLibsPHP)?dirLibsPHP:new String("/axys_comun/libs");

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 1. Control Upload - Crea un Controlador Upload

 * \param sDest 	- ( STRING ) nombre del Objeto destino, parte de un HTML
 * \return oUpload - ( Objeto ) devuelve un objeto Upload, el cual permite controlar el Upload
 * \author EG - 17/01/2008
 */
function objUL() {
	var sDest   = new String(arguments[0]);
	var bInicio = typeof(arguments[1]) != "undefined"? arguments[1]: true;
	var oUL     = new _cUpload();

	oUL.idDest = trim(sDest);
//console.log(bInicio);
	if(bInicio == true) oUL.Inicio(sDest);

	return oUL;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 2. Objeto Control Upload
 * \ingroup fPrivada
 * \author EG - 17/01/2008
*/
var _cUpload = Class.create();
_cUpload.prototype = {
   // Publico
   initialize: function() {

	this.id        = new String("");  // R

	this.idCampo   = new String(""); // R/W - Nombre (ID) del Input de retorno
	this.sRuta     = new String("./"); // R/W - Ruta donde se guardara el archivo en el servidor
	this.idRet     = new String(""); // R - Id que retorna la BD (Mod Bodega de Archivos), identifica al archivo
	this.txtBSubida = new String(""); // R/W - Txt para Activar la Subida puede ser un Boton o una imagen
	this.txtBRemove = new String(""); // R/W - Txt para Activar la Remocin puede ser un Boton o una imagen
	this.maxSize   = 0; // R/W - Valor mximo en bytes para subir un archivo - 0 para que la restriccion sea por PHP en la variable de entorno <upload_max_filesize>
	this.charWidth = 30; // R/W - Ancho del campo en caracteres a mostrar
	this.bAuto     = true; // R/W - La subida es automatica, no se requiere el boton de subir

	this.tipoCtrl  = new Number(0); // R/W - Tipo de Control
                                    /*
                                       0 - Upload Normal Default
                                       1 - Bodega de Archivos
												*/

	this.estilo    = new Number(0); // R/W - Generador de Estilos Visuales predeterminados del control - x Implementar
	this.cantMaxUpload = new Number(1); // R/W x Implementar
	this.tamMaxUpload = 0; // R/W x Implementar
	this.visBRemove = true;


	// Opciones para tipo de Control 0
   this.veriSEsc  = true; // R/W - Booleano, True verifica si el archivo existe en el destino y pide confirmacin para sobreescribirlo

   this.tipo      = _Type_cUL;
   this.Inicio    = _Inicio_cUL;
   this.mostrar   = _vis_cUL;

   // Privado
   this.Parent		= null; // R - Referencia al Objeto PADRE HTML

   this.idDest 	= null;  // R - ID HTML del DIV Escritorio
   this.oDest 		= null; // R - Referencia al Objeto HTML
   this.visDest   = true;  // R

   this.idCRet  	= new String("");  // R
   this.oCRet  	= null; // R - Referencia al Objeto HTML
   this.visCRet   = false;  // R

   this.idULStn  	= new String("");  // R
   this.oULStn  	= null; // R - Referencia al Objeto HTML
   this.visULStn  = true;  // R

   this.idBadic  	= new String("");  // R
   this.oBadic  	= null; // R - Referencia al Objeto HTML
   this.visBadic  = false;  // R

	this.idFile    = new String("");

	this.oCampo    = null; // R - Referencia Obj HTML, Input de Retorno
	this.oFile     = null; // R - Referencia Obj HTML, Input File

	this.idFrame 	= new String(""); // R
	this.oFrame 	= null; // R - Referencia Obj HTML, Piscina Frame
   this.visFrame  = false;  // R

	this.idForm 	= new String(""); // R
	this.oForm 		= null; // R - Referencia Obj HTML, Form

	this.idIDir    = new String(""); // R
	this.oIDir     = null; // R - Referencia Obj HTML, input hidden Direccion

	this.idmsgUL   = new String(""); // R
	this.omsgUL    = null; // R - Referencia Obj HTML, Div para Mensajes del UL

	this.Upload    = _Upload_cUL;
	this.Remove    = _Remove_cUL;
	this.Vaciar    = _Vaciar_cUL;
	this.onBlur 	= _onBlur_cUL;
	this.Editar 	= _estED_cUL;

	// Eventos
	this.responseUpload = null; // Funcion de respuesta despues de subir un archivo
	}

}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 3. Funcion _Inicio_cUL
 * \ingroup fPrivada
 * \param sDest 	- ( STRING ) nombre del Objeto destino, parte de un HTML
 * \author EG - 14/08/2007
*/
function _Inicio_cUL() {
   var sDest 	= arguments[0]?new String(arguments[0]):this.idDest;
   var sHTM    = new String();
   var _evt1   = new String("");

  	this.id     	= "" + trim(sDest);
   this.idCRet  	= "cr" + this.id;
   this.idULStn  	= "Stn" + this.id;
   this.idBadic  	= "Bot" + this.id;
   this.idFile    = "F" + this.id;
   this.idFrame   = "FR" + this.id;
   this.idForm    = "Form" + this.id;
   this.idIDir    = "IDir" + this.id;
   this.idmsgUL   = "msg" + this.id;

	if(this.idCampo.trim() == "")
	{
      this.idCampo = "IN_" + this.id;
	}

	if(this.txtBSubida.trim() == "")
	{
      this.txtBSubida = "Subir";
	}
	if(this.txtBRemove.trim() == "")
	{
      this.txtBRemove = "Remover";
	}

   this.idDest = trim(sDest);
  	this.Parent = $(this.idDest);

  	if(!this.Parent) {
		alert("Fallo la creacion del Objeto Upload");
	}

	if(this.bAuto == false)
	{
   	_evt1 = "";
	}
	else
	{
   	_evt1 = " onchange=\"buscaUL('" + this.id.trim() +"').Upload(event);\" ";
	}

//   sHTM += "<div id='" + this.id + "' class='UpLoad'>";
	sHTM += "<table cellspacing='0' cellpadding='0'><tr><td>";
	sHTM += "<div id='" + this.idCRet + "' class='ULCasillaRetorno'>";
		if( !$(this.idCampo.trim()) ) { sHTM += "<input class='axibFile' size='"+ this.charWidth + "' id='" + this.idCampo.trim() +"' readonly='readonly'>"; }
	sHTM += "</div>";
	sHTM += "<form id='" + this.idForm + "' name='" + this.idForm + "' method='post' enctype='multipart/form-data' action='" + dirLibsPHP + "upload_sr.php?" + sid + "&ctrl=" + this.id + "&Fun=Subir' target='" + this.idFrame + "'>";
		if (this.maxSize > 0)
			sHTM += "<input type='hidden' name='MAX_FILE_SIZE' value='"+ this.maxSize +"' />";
		sHTM += "<input id='" + this.idIDir.trim() + "' name='" + this.idIDir.trim() + "' type='hidden' value='" + this.sRuta.trim() + "'>";
	  	sHTM += "<div id='" + this.idULStn + "' class='ULInputStn'><input size='"+ this.charWidth + "' class='axibFile' id='" + this.idFile.trim() + "' name='" + this.idFile.trim() + "' type='file' " + _evt1 + "></div>";
	sHTM += "</form>";
	sHTM += "</td><td>";
	sHTM += "<div id='" + this.idBadic + "' class='ULBotAdic'>" + this.txtBSubida + "</div>";
	sHTM += "</td><tr><td colspan='2'>";
	sHTM += "<div id='"+ this.idmsgUL +"' class='ULmsg'></div>";
	sHTM += "</td></tr></table>";
	sHTM += "<iframe id='" + this.idFrame + "' name='"+ this.idFrame +"' src='' width='400' height='100'></iframe>";
//	sHTM += "</div>";

	this.Parent.update(sHTM);

	this.oFrame = $(this.idFrame);
  	this.oBadic = $(this.idBadic);
  	this.oCRet = $(this.idCRet);

	this.oFrame.hide();
	this.oBadic.hide();
  	this.oCRet.hide();

	this.oBadic.onclick = this.Upload.bindAsEventListener(this);

  	this.oDest = $(this.id);
  	this.oULStn = $(this.idULStn);

  	this.oCampo = $(this.idCampo);
  	this.oFile  = $(this.idFile);
	this.oForm  = $(this.idForm);
	this.oIDir 	= $(this.idIDir);
	this.omsgUL = $(this.idmsgUL);
// alert(sHTM+ "\n\n"+this.idForm + "\n" + this.oCRet + "\n" + this.oForm + "\n" + $(this.idForm) + "\n" + this.oBadic);
	this.omsgUL.hide();

	if(this.bAuto == false)	{
		this.oBadic.show();
	}
	else {
		this.oBadic.hide();
	}

   _aUpload.push(this);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 4. Funcion _Type_cUL
 * \ingroup fPrivada
 * \return sTipo 	- ( STRING ) Tipo de Objeto
 * \author EG - 14/08/2007
*/
function _Type_cUL() { return "Upload"; }

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 5. Visibilidad - Muestra u Oculta una parte o una opcion del control
 * \ingroup fPrivada
 * \param sDes 	- ( STRING ) parte a ocultar si es de tipo String oculta ese objeto
 * \param bStd    - ( BOOLEAN ) TRUE lo muestra, FALSE lo oculta
 * \author EG - 14/08/2007
*/
function _vis_cUL() {
 	var sDes = arguments[0];
 	var bStd = arguments[1]?arguments[1]:null;
 	var _tmp = null;

 	var tipoDes = new String(typeof(sDes));

 	if( tipoDes.trim() == "string" )
	{
	  switch( sDes.trim() )
	  {
		case "RET":
		   if(bStd == null) bStd = !this.visCRet;
         this.visCRet = bStd;
         if(bStd == true)  {  this.oCRet.show(); }
		   else  { this.oCRet.hide(); }
		break;
		case "BRO":
		   if(bStd == null) bStd = !this.visULStn;
         this.visULStn = bStd;
         if(bStd == true)  {  this.oULStn.show(); }
		   else  { this.oULStn.hide(); }
		break;
		case "BOT":
		   if(bStd == null) bStd = !this.visBadic;
         this.visBadic = bStd;
         if(bStd == true)  { this.oBadic.show(); }
		   else  { this.oBadic.hide(); }
		break;
		case "FRA":
		   if(bStd == null) bStd = !this.visFrame;
         this.visFrame = bStd;
         if(bStd == true)  { this.oFrame.show(); }
		   else  { this.oFrame.hide(); }
		break;
		case "CTRL":
		   if(bStd == null) bStd = !this.visDest;
         this.visDest = bStd;
         if(bStd == true)  {  this.oDest.show(); }
		   else  { this.oDest.hide(); }
		break;
		default:
			_tmp = $(sDes);
			if(_tmp)
			{
		      if(bStd == true)  {  _tmp.show(); }
		      else  { _tmp.hide(); }
			}
		break;
	  }
	}
}

////////////////////////////////////////////////////////////////////////////////
/** 6. - Busca un Control UpLoad
 * \param _sID - (STRING) Nombre del Control a Buscar
 * \author EG - 24/01/2008
 */
function _localiza_cUL() {
	var _sID = arguments[0];
	var _objx = null;
  _objx = _aUpload.find(function(_obj) { return _obj.id == _sID; });
	return _objx;
}

function buscaUL() {
  var _sID = arguments[0];
  return _localiza_cUL(_sID);
}

////////////////////////////////////////////////////////////////////////////////
/** 7. - Funcion de Subida de Archivo
 * \author EG - 24/01/2008
 */
function _Upload_cUL(evt) {
if(evt) {
 var aTmp = StringtoArray(sid, "=");
 this.omsgUL.update( "<img src='" + dirLibImages + "ax-ul-loading-blue.gif' class='imgUL' alt='Subiendo...' />" );
 this.oIDir.value = this.sRuta.trim();
//    alert("Nombre: " + this.id + "\nArchivo: " + this.oFile.value + "\nDestino:" + this.oIDir.value );
 this.oBadic.hide();
 this.oULStn.hide();
 this.omsgUL.show();

	if(this.oFile.value.trim() == "" )
	{
		this.omsgUL.update("<span style='color: red'>Por favor seleccione un archivo...</span>");
		if(this.bAuto == false)	{
			this.oBadic.show();
		}
		else {
			this.oBadic.hide();
		}
		this.oULStn.show();
 	}
	else
	{

	var _valida = true;
   if(typeof(_beforeUl)=="function")
   {
    _valida = _beforeUl();
   }

  if((_valida==true)&&(this.tipoCtrl == 0)) // Upload Normal
	{
	 if(this.veriSEsc == true) // Verificar Si el archivo existe y se sobreescribe
	 {
		Anuncio("Verificando...");
		 new Ajax.Request(
			dirLibsPHP + "/upload_sr.php",
			{
			  method: 'get',
			  parameters: { sidname: aTmp[1].trim(), Fun: 'Verificar', ctrl: this.id.trim(), file: this.oFile.value.trim(), dir: this.sRuta.trim() },
			  onSuccess: function(transport)
			  {
				Anuncio("...");
				var response = transport.responseXML.documentElement;
			   var nVer = response.getElementsByTagName("verificado")[0].childNodes[0].nodeValue;
			   var sCtrl = response.getElementsByTagName("control")[0].childNodes[0].nodeValue;
			   var sFile = response.getElementsByTagName("file")[0].childNodes[0].nodeValue;
				var oCtrl = buscaUL(sCtrl);
// alert( "Verificacin: " +nVer + "\nControl: " + sCtrl + "\nFile: " + sFile + "\n" + oCtrl );
				if(nVer == 1)
				{
				   if(confirm("Desea Sobreescribir el Archivo " + sFile + "?") )
				   {
					 Anuncio("Subiendo...");
					  oCtrl.oForm.submit();
					}
					else
					{
					 if(oCtrl)
					 {
					  Anuncio("");
						oCtrl.Vaciar();
						oCtrl.oULStn.show();
						oCtrl.omsgUL.hide();
						oCtrl.omsgUL.update("");
							if(oCtrl.bAuto == false)	{
								oCtrl.oBadic.show();
							}
							else {
								oCtrl.oBadic.hide();
							}
					 }
					}
				}
				else
				{
				 Anuncio("Subiendo...");
				 oCtrl.oForm.submit();
				}

				return;
			  },
			  onFailure: function(transport)
			  {
			   var response = transport.responseText;
			   Anuncio("1K: " + response);
			  }
			}
		 );
	 }
	 else
	 {
	  Anuncio("Subiendo...");
	  this.oForm.submit();
	 }
	}
	else{
		if(this.bAuto == false)	{
			this.oBadic.show();
		}
		else {
			this.oBadic.hide();
		}
 this.omsgUL.hide();
}
}
}}
////////////////////////////////////////////////////////////////////////
/** 8. - Funcion de Respuesta a una Subida de Archivo
 * \author EG - 29/01/2008
 */
function _Response_cUL(str, nErr, sCtrl, sNomFile) {

// alert(
// 	arguments[0] + "\n" +
// 	arguments[1] + "\n" +
// 	arguments[2] + "\n" +
// 	arguments[3] + "\n"
// );

	var oCtrl = buscaUL(sCtrl);

	if(oCtrl) oCtrl.omsgUL.update( "" + str );

	if(nErr == 1) // Subio sin errores
	{
 	   oCtrl.oBadic.update(oCtrl.txtBRemove);
		oCtrl.oBadic.onclick = oCtrl.Remove.bindAsEventListener(oCtrl);

// EG 2008-07-17 Error en IE no puede escribir la propiedad type de un control, por tal razon reemplazo la siguiente instruccion por un hide
//		var _tmp = oCtrl.oFile.value;
//alert(oCtrl.oFile.type);
// *** ANTES ***
/*		if(Prototype.Browser.IE)
		{
			oCtrl.oULStn.hide();
		}
		else
		{
			oCtrl.oFile.type = "text";
			oCtrl.oFile.readOnly = "true";
		}
*/
// xBt 2010-04-28 Todos los navegadores pueden hacer lo mismo que dejamos para IE
// *** DESPUES ***
		oCtrl.oULStn.hide();
		oCtrl.oCRet.show();
//		oCtrl.oFile.value = _tmp;
// *** FIN ***

	   if(oCtrl.tipoCtrl == 0 ) // Upload Normal
	   {
		//	$(oCtrl.idCampo).value = sNomFile.trim();
		 oCtrl.oCampo.value = sNomFile.trim();
		 Anuncio("");
		}

		if(oCtrl.bAuto == false)	{
			oCtrl.oBadic.show();
		}
		else {
			oCtrl.oBadic.hide();
		}

	   if(typeof( oCtrl.responseUpload )  == "function") {
			oCtrl.responseUpload(oCtrl.oCampo.value, oCtrl.sRuta, oCtrl.id ,oCtrl.idCampo);
		}
	   else if(typeof( responseUpload )  == "function") {
			responseUpload(oCtrl.oCampo.value, oCtrl.sRuta, oCtrl.id ,oCtrl.idCampo);
		}
	}

	if(nErr == 0) // Subio con errores
	{
		Anuncio("Intentelo ms tarde");
		if (oCtrl.maxSize > 0)
		{	oCtrl.omsgUL.update( "<span style='color: red'>No se subi el archivo, verifique el tamao y/o el tipo.<br />El tamao mximo permitido es de "+ oCtrl.maxSize +" bytes.</span>" ); }
		else
		{	oCtrl.omsgUL.update( "<span style='color: red'>No se subi el archivo, verifique el tamao y/o el tipo.</span>" ); }
		oCtrl.omsgUL.show();
		oCtrl.oULStn.show();
		if(oCtrl.bAuto == false)	{
			oCtrl.oBadic.show();
		}
		else {
			oCtrl.oBadic.hide();
		}

		if(oCtrl.tipoCtrl == 0 ) // Upload Normal
		{
			oCtrl.oCampo.value = "";
		}
	}
}

////////////////////////////////////////////////////////////////////////
/** 9. - Funcion para Remover un Archivo
 * \author EG - 29/01/2008
 */
function _Remove_cUL(evt) {
if( confirm("Est seguro de eliminar el archivo ?") )
if(evt) {
	Anuncio("Removiendo...");
	var aTmp = StringtoArray(sid, "=");
	this.omsgUL.update( "<img src='" + dirLibImages + "ax-ul-loading-red.gif' class='imgUL' alt='Eliminando...' />" );
	this.oIDir.value = this.sRuta.trim();
	//  alert("Nombre: " + this.id + "\nArchivo: " + this.oFile.value + "\nDestino:" + this.oIDir.value );
	this.oBadic.hide();
	this.omsgUL.show();

	if(this.tipoCtrl == 0) // Upload Normal
	{
		 new Ajax.Request(
			dirLibsPHP + "/upload_sr.php",
			{
			  method: 'get',
			  parameters: {sidname: aTmp[1].trim(), Fun: 'Remover', ctrl: this.id.trim(), file: this.oFile.value.trim(), dir: this.sRuta.trim()},
			  onSuccess: function(transport)
			  {
				var response = transport.responseXML.documentElement;
				var nVer = response.getElementsByTagName("eliminado")[0].childNodes[0].nodeValue;
				var sCtrl = response.getElementsByTagName("control")[0].childNodes[0].nodeValue;
				var sFile = response.getElementsByTagName("file")[0].childNodes[0].nodeValue;
				var oCtrl = buscaUL(sCtrl);

				if(nVer == 1)
				{
// EG 2008-07-17 Error en IE no puede escribir la propiedad type de un control, por tal razon reemplazo la siguiente instruccion por un hide
/* *** XBT - 2010-04-28 Hacer lo mismo de IE para los demas navegadores
 *** ANTES ***
 * 					if(Prototype.Browser.IE)
					{
						oCtrl.oULStn.show();
					}
					else
					{
						oCtrl.oFile.type = "file";
						oCtrl.oFile.readOnly = "false";
					}
*/
// *** DESPUES ***
					oCtrl.oCRet.hide();
					oCtrl.oULStn.show();
// *** FIN ****
					oCtrl.oBadic.update(oCtrl.txtBSubida);
					oCtrl.oBadic.onclick = oCtrl.Upload.bindAsEventListener(oCtrl);
					oCtrl.omsgUL.update("");
				//$(oCtrl.idCampo).value = "";

					if(oCtrl.bAuto == false)	{
						oCtrl.oBadic.show();
					}
					else {
						oCtrl.oBadic.hide();
					}
				   oCtrl.omsgUL.hide();
				   Anuncio("");

				   if(typeof( responseRemove ) == "function")
					{ responseRemove(oCtrl.oCampo.value, oCtrl.sRuta, oCtrl.id ,oCtrl.idCampo); }
				}
				else
				{
					//oCtrl.omsgUL.update("El Archivo "+ sFile +" No Pudo ser Removido");
					//oCtrl.omsgUL.show();
					oCtrl.oBadic.update(oCtrl.txtBRemove);
					oCtrl.oBadic.onclick = oCtrl.Remove.bindAsEventListener(oCtrl);
					if(oCtrl.bAuto == false)	{
						oCtrl.oBadic.show();
					}
					else {
						oCtrl.oBadic.hide();
					}
					oCtrl.omsgUL.hide();
					Anuncio("El Archivo "+ sFile +" No Pudo ser Removido");
				}
			  },
			  onFailure: function(transport)
			  {
				var response = transport.responseText;
//				alert("1K: " + response);
				oCtrl.omsgUL.update("<span style='color:red'>ERROR: El Archivo "+ sFile +" No Pudo ser Removido</span>");
				oCtrl.omsgUL.show();
				if(oCtrl.bAuto == false)	{
					oCtrl.oBadic.show();
				}
				else {
					oCtrl.oBadic.hide();
				}
	   			//oCtrl.omsgUL.hide();
			  }
			}
		 );
	}
}
}

////////////////////////////////////////////////////////////////////////
/** 10. - Funcion para Limpiar un Control Upload
 * \author EG - 12/02/2008
 */
function _Vaciar_cUL() {
/* *** XBT - 2010-04-28 Hacer lo mismo de IE para los demas navegadores
 *** ANTES ***
  	if(Prototype.Browser.IE)
	{
		this.oULStn.show();
	}
	else
	{
		this.oFile.type = "file";
		this.oFile.readOnly = "false";
	}
*/
// *** DESPUES ***
	this.oCRet.hide();
	this.oULStn.show();
// *** FIN ***
	this.oForm.reset();
	this.oBadic.update(this.txtBSubida);
	this.oBadic.onclick = this.Upload.bindAsEventListener(this);
	if(this.bAuto == false)	{
		this.oBadic.show();
	}
	else {
		this.oBadic.hide();
	}
	this.omsgUL.update("");
	jq.$("#"+this.idCampo).value = "";
	this.omsgUL.hide();
	Anuncio("");
}
////////////////////////////////////////////////////////////////////////
/** 11. - Funcion para Evento onBlur en Control Upload
 * \author EG - 22/05/2008
 */
function _onBlur_cUL() {
/*
 alert(this.id + "\n" +
	this.idCampo   + "\n" +
	this.sRuta     + "\n" +
   this.idRet     + "\n" +
   this.txtBSubida + "\n" +
   this.txtBRemove + "\n" +
   this.bAuto     + "\n" +
   this.tipoCtrl  + "\n" +
	this.estilo    + "\n" +
	this.cantMaxUpload + "\n" +
	this.tamMaxUpload + "\n" +
	this.visBRemove + "\n" +
   this.veriSEsc  + "\n" +
   this.Parent		+ "\n" +
   this.idDest 	+ "\n" +
   this.visDest  + "\n" +
   this.idCRet  + "\n" +
   this.visCRet   + "\n" +
   this.idULStn  	+ "\n" +
   this.visULStn  + "\n" +
   this.idBadic  	+ "\n" +
   this.visBadic  + "\n" +
	this.idFile    + "\n" +
	this.idFrame 	+ "\n" +
   this.visFrame  + "\n" +
	this.idForm 	+ "\n" +
	this.idIDir    + "\n"
 );
*/
// alert(this.idCampo  + "\n" + this.oCampo.value);
 var cF = this.oCampo.value;
 cF = cF.split("/");
 //alert(cF);
}
////////////////////////////////////////////////////////////////////////
/** 12. - Funcion para poner un Upload en Modo de Edicion
 * \author EG - 15/08/2008
 */
function _estED_cUL() {
	   this.oBadic.update(this.txtBRemove);
		this.oBadic.onclick = this.Remove.bindAsEventListener(this);

// EG 2008-07-17 Error en IE no puede escribir la propiedad type de un control, por tal razon reemplazo la siguiente instruccion por un hide
		if(Prototype.Browser.IE) {
			this.oULStn.hide();
		}
		else {
	 	   this.oFile.type = "text";
			this.oFile.readOnly = "true";
		}

		var _tmp = new String(this.oCampo.value);
		this.oFile.value = _tmp.slice(1+_tmp.lastIndexOf("/"));

}

////////////////////////////////////////////////////////////////////////
/* listaDir
 * Lista un directorio
*/
function listaDir(d) {
 	var parametros = { 'sidname': sidname[1], 'Fun': "listaArchivos", 'dir': d,  'filtro': this.filtro_archivos};

	jq.$.ajax({
		url: dirLibsPHP + "upload_sr.php"
		, type: 'POST'
		, data: parametros
		, dataType: "json"
		, success: function(data) {
			if(data.success == true) {
//console.log(data);
				jq.$("#acordion").accordion( "option", "active", 1 );
				oULurl_img_marca.Vaciar();
			}
		}
	});
}

////////////////////////////////////////////////////////////////////////
/* Objeto Upload-Directorio
 * Author: EG - 2010-6-12
*/
function objUD() {
	var sId   	= new String(arguments[0]);
	var sDest   = new String(arguments[1]);
	var sTit 	= new String(arguments[2]);
//console.log(typeof(arguments[3]))	;
	var bInicio = typeof(arguments[3]) != "undefined"? arguments[3]: true;
	var oUD     = new _cDirectorio();

	oUD.id 			= trim(sId);
	oUD.dir_ruta 	= trim(sDest);
	oUD.titulo 		= trim(sTit);

	if(bInicio == true) oUD.inicio();

	return oUD;
}

////////////////////////////////////////////////////////////////////////
/* Clase Upload-Directorio
 * Author: EG - 2010-6-12
*/
function _cDirectorio() {
	this.id 						= new String("");
	this.titulo 				= new String("");
	this.pag_actual 			= new Number(1);
	this.nro_archivos_pag 	= new Number(10);
	this.dir_ruta 				= new String("");  // sin slash al inicio
	this.data 					= new Array();
	this.nro_img_fila 		= new Number(3);
	this.mostrar_upl 			= new Boolean(true);
	this.plantillaDir 		= new String("<div style='position:relative; height:25px;'><div ?ctrlDir ><img align='absmiddle' src='"+dirLibImages+"/folder.png' /> ?1</div> </div>");

	this.plantilla 			= new String("<div style='?style;width:150px;height:150px; border:1px blue solid; position:relative;'><div width='144px' height='144px' onmouseOver='control_listaDir(this, true)' onmouseOut='control_listaDir(this, false)' ><img width='?5' height='?6' src='?0' alt='?1 - Tam: ?3 Tipo: ?4 ?8' title='?1 \n Tam: ?3 Tipo: ?4 ?8'/></div>  <div style=' height:25px; position:absolute; bottom:0'>   <div width='?5' name='control' onmouseOver='control_listaDir(this, true)' onmouseOut='control_listaDir(this, false)'>?controles</div></div>  </div>");

	this.listarDirs 			= new Boolean(false);
	this.carpetaAct 			= new String("");
	this.imgH 					= new String("144px");
	this.imgW 					= new String("144px");

	this.recarga 				= _lDir_listaDir;
	this.borrar 				= _borrar_listaDir;
	this.inicio 				= _inicio_listaDir;

	this.oWIN 					= null;
	this.oUpl 					= null;
	this.oDir 					= null;
	this.oPag 					= null;
	this.oCon 					= null;
	this.oTBar 					= null;
	this.oUL 					= null; // Objeto JS
	this.UL 						= new _cUL_caracteristicas();

	this.mostrar 				= _mostrar_listaDir;
	this.ocultar 				= _ocultar_listaDir;

	this.pintar 				= _pintar_listaDir;

	this.filtro_archivos 	= new Array();
}

////////////////////////////////////////////////////////////////////////
/* Listar Directorio
 * Author: EG - 2010-6-12
*/
function _lDir_listaDir() {

 	var parametros = { 'sidname': sidname[1], 'Fun': "listaArchivos"
		, 'dir': this.dir_ruta, 'filtro': (this.filtro_archivos), 'listarDirs': this.listarDirs, 'carpeta': this.carpetaAct};
	var ot = this;
	jq.$.ajax({
		url: dirLibsPHP + "upload_sr.php"
		, type: 'POST'
		, data: parametros
		, dataType: "json"
		, success: function(data) {
			if(data.success == true) {
				ot.data = data.dir;
				ot.pintar();
			}
		}
	});
}

////////////////////////////////////////////////////////////////////////
/* Pintar Dir
 * Author: EG - 2010-6-13
*/
function _pintar_listaDir() {
	// ?0 - ruta web
	// ?1 - nombre archivo
	// ?2 - tipo de archivo
	// ?3 - Tamao en bytes
	// ?4 - Mime
	// ?5 - width
	// ?6 - height
	// ?7 - N tipo de archivo
	/*
				1	IMAGETYPE_GIF
				2	IMAGETYPE_JPEG
				3	IMAGETYPE_PNG
				4	IMAGETYPE_SWF
				5	IMAGETYPE_PSD
				6	IMAGETYPE_BMP
				7	IMAGETYPE_TIFF_II (intel byte order)
				8	IMAGETYPE_TIFF_MM (motorola byte order)
				9	IMAGETYPE_JPC
				10	IMAGETYPE_JP2
				11	IMAGETYPE_JPX
				12	IMAGETYPE_JB2
				13	IMAGETYPE_SWC
				14	IMAGETYPE_IFF
				15	IMAGETYPE_WBMP
				16	IMAGETYPE_XBM
	*/
	// ?8 - String width - height

	/* Palabras Reservadas
	 * ?style
	 * ?controles
	 * ?ctrlDir
	*/
  var st = this.plantilla;
  var plR = "";
  var nH = "";
  var w = 0;
  var h = 0;
  var rel = 1;
  var nif = 1;
  var hCtr = "";

	// Paginador
	var nPag = (this.data.length/this.nro_archivos_pag).toFixed();
	if((this.data.length % this.nro_archivos_pag)>0 && (this.data.length % this.nro_archivos_pag)<0.5 ) { nPag += 1; }

	if(nPag > 1){
		var hPag = "";
		for(n=1; n<=nPag; n++) {
			if(hPag != "") { hPag += " - "; }
			hPag += "<a href='#' onclick='saltaPag_listaDir(this)' comp='"+this.id+"' pos='"+n+"' >"+n+"</a>";
		}
		this.oPag.html(hPag);
	}

	pagA = this.pag_actual;
	pagA -= 1;
	iniA = pagA * this.nro_archivos_pag;
	finA = iniA + this.nro_archivos_pag;
	if(finA > this.data.length) { finA = this.data.length; }

  // contenedor
	for(n=iniA; n<finA; n++) {
		if(this.data[n][2] == "file") { plR = this.plantilla; }
		else if(this.data[n][2] == "dir") { plR = this.plantillaDir; }
//console.log(!(trim(this.carpetaAct) == '' && trim(this.data[n][1]) == ".."), " - '", this.carpetaAct, "' == '' && '" , trim(this.data[n][1]), "' == '..'" );
		if(!(trim(this.carpetaAct) == '' && trim(this.data[n][1]) == "..")) {

			plR = plR.replace(/\?1/ig, this.data[n][1]);
			plR = plR.replace(/\?2/ig, this.data[n][2]);
			plR = plR.replace(/\?3/ig, this.data[n][3]);

			if( (this.data[n][4]) == null ) {
				plR = plR.replace(/\?0/ig, this.data[n][0]); // OJO Colocado por Boris
				plR = plR.replace(/\?0/ig, dirImg+"archivo.png" ); // OOJO Quitado por Boris - porque Oswalduchis ?
				plR = plR.replace(/\?4/ig, "");
			}
			else {
				plR = plR.replace(/\?0/ig, this.data[n][0]);
				plR = plR.replace(/\?4/ig, this.data[n][4]);
			}



			if( (this.data[n][5]) == null ) {
				if(this.data[n][5] > 144) {w = "144px";} else {w = "144px"; }
			}
			else {
				if(this.data[n][5] > 144) {w = "144px";} else {w = this.data[n][5] + "px"; }
			}

			if( (this.data[n][6]) == null ) {
				if(this.data[n][6] > 144) {h = "144px";} else {h = "144px"; }
			}
			else {
				if(this.data[n][6] > 144) {h = "144px";} else {h = this.data[n][6] + "px"; }
			}

//Inicio Boris
			if( (this.data[n][5]) == null ) {
				if(this.data[n][5] > 144) {w = "144px";} else {w = "144px"; }
			}
			if( (this.data[n][6]) == null ) {
				if(this.data[n][6] > 144) {h = "144px";} else {h = "144px"; }
			}

			if(this.data[n][6] > 144 || this.data[n][5] > 144) {
				if (this.data[n][6] >= this.data[n][5]){
					h = "144px";
					rel = this.data[n][6] / 144;
					w = this.data[n][5] / rel + "px";
				}
				else{
					w = "144px";
					rel = this.data[n][5] / 144;
					h = this.data[n][6]/rel + "px";
				}
			}

/*
console.log("***--Inicio--***");
console.log(this.data[n][5]);
console.log(this.data[n][6]);
console.log(rel);
console.log(w);
console.log(h);
console.log("***--Fin--***");
*/
// end Boris




			plR = plR.replace(/\?5/ig, w);
			plR = plR.replace(/\?6/ig, h);

			if( (this.data[n][7]) == null ) {
				plR = plR.replace(/\?7/ig, "");
			}
			else {
				plR = plR.replace(/\?7/ig, this.data[n][7]);
			}

			if( (this.data[n][8]) == null ) {
				plR = plR.replace(/\?8/ig, "");
			}
			else {
				plR = plR.replace(/\?8/ig, this.data[n][8]);
			}

			hCtr = "<a href='#' onclick='_borrar_listaDir(this)' comp='"+this.id+"' pos='"+n+"' ><img src='"+dirLibImages+"ax-upl-trash-icon16.png' alt='Eliminar Archivo' border=0/></a>";
			plR = plR.replace(/\?controles/ig, hCtr);

			hCtr = " onclick='_cambiar_listaDir(this)' comp='"+this.id+"' pos='"+n+"' ";
			plR = plR.replace(/\?ctrlDir/ig, hCtr);

			if(nif <= this.nro_img_fila) {
				plR = plR.replace(/\?style/ig, "float: left;");
	//			plR = plR.replace(/\?style/ig, "");
			}
			else {
				plR = plR.replace(/\?style/ig, "float: left;");
	//			plR = plR.replace(/\?style/ig, "clear: left;");
	//			plR = plR.replace(/\?style/ig, "<br />");
				nif = 0;
			}
			nif += 1;
			nH += plR;
		}
	}


	this.oCon.html(nH);
	jq.$("div[name='control']", this.oCon).hide();
//	jq.$("img", this.oCon).draggable({ revert: 'invalid' });
}

////////////////////////////////////////////////////////////////////////
/* Salta paginador
 * Author: EG - 2010-6-14
*/
function saltaPag_listaDir(o) {
	var oA = jq.$(o);
	oLD = buscaLD(oA.attr('comp'));
	if(oLD) {
		oLD.pag_actual = oA.attr('pos');
		oLD.pintar();
	}
}

////////////////////////////////////////////////////////////////////////
/* refresca Componente
 * Author: EG - 2010-6-14
*/
function refresca_listaDir(o) {
	var oA = jq.$(o);
	oLD = buscaLD(oA.attr('comp'));
	if(oLD) {
		oLD.recarga();
	}
}

////////////////////////////////////////////////////////////////////////
/* Ocultar Ventana
 * Author: EG - 2010-6-12
*/
function _ocultar_listaDir() {
	this.oWIN.dialog("close");
}

////////////////////////////////////////////////////////////////////////
/* Mostrar Ventana
 * Author: EG - 2010-6-12
*/
function _mostrar_listaDir() {
	this.oWIN.dialog("open");
}

////////////////////////////////////////////////////////////////////////
/* Inicia el Directorio
 * Author: EG - 2010-6-12
*/
function _inicio_listaDir() {
//	var _o = jq.$("<div id='"+ this.id +"' title='"+ this.titulo +"'><div id='UL_"+this.id+"'></div><div name='directorio'><div name='toolbar'><div style='float: left;'><a href='#' onclick='refresca_listaDir(this)' comp='"+this.id+"'><img src='"+dirLibImages+"ax-upl-Button-Refresh-icon16.png' border=0/></a></div></div><br/><div name='paginador'></div><div name='contenedor'></div> </div></div>");

	var _o = jq.$("<div id='"+ this.id +"' title='"+ this.titulo +"'><div id='UL_"+this.id+"'></div><div name='directorio'><div name='toolbar'><div style=''><button href='#' onclick='refresca_listaDir(this)' comp='"+this.id+"'><img align='absmiddle' src='"+dirLibImages+"ax-upl-Button-Refresh-icon16.png' border='0'/> Recargar contenidos </button></div></div><br/><div name='paginador'></div><div name='contenedor'></div> </div></div>");

	jq.$('body').append(_o);

	_o.dialog({
		autoOpen: false
	});

	var oT = this;
	{
		this.oUL = new objUL('UL_'+this.id, false);
		this.oUL.idCampo = 'ulData_'+this.id;
//		this.oUL.sRuta = '/' + this.dir_ruta + "/";
		this.oUL.sRuta = trim(this.dir_ruta);
		this.oUL.bAuto = this.UL.bAuto? this.UL.bAuto : false;
		this.oUL.txtBSubida = (trim(this.UL.txtBSubida) != "")? trim(this.UL.txtBSubida) : '<img src="'+dirLibImages+'ax-upl-up.png">';
		this.oUL.txtBRemove = (trim(this.UL.txtBRemove) != "")? trim(this.UL.txtBRemove) : '<img src="'+dirLibImages+'ax-upl-remove.png">';
		this.oUL.maxSize = (this.UL.maxSize != 0)? this.UL.maxSize : 2000000;
		this.oUL.charWidth = (this.UL.charWidth != 0)? this.UL.charWidth : 50;
		this.oUL.responseUpload = function(){
			this.Vaciar();
			oT.recarga();
		   if(typeof( oT.UL.responseUpload ) == "function")
					{ oT.UL.responseUpload(oT.oUL); }
		};
		this.oUL.Inicio();
//console.log(oT.UL);
	}

	{
		this.oWIN  = jq.$('#' + this.id);
		this.oUpl  = jq.$("div[id='UL_"+this.id+"']", this.oWIN);
		this.oDir  = jq.$("div[name='directorio']", this.oWIN);
		this.oPag  = jq.$("div[name='paginador']", this.oDir);
		this.oCon  = jq.$("div[name='contenedor']", this.oDir);
		this.oTBar = jq.$("div[name='toolbar']", this.oDir);
	}

	{
		this.recarga();
	}

	_aUploadDir.push(this);
}


////////////////////////////////////////////////////////////////////////
/* cambiar de Directorio
 * Author: EG - 2010-7-1
*/
function _cambiar_listaDir(o) {
	var arch = "";
	var oA = jq.$(o);
	var oLD = buscaLD(oA.attr('comp'));
	if(oLD) {
		if(trim(oLD.data[oA.attr('pos')][1]) == "..") {
			var aCA = oLD.carpetaAct.split('/');
			aCA.pop();
			oLD.carpetaAct = aCA.join("/");
//console.log(trim(oLD.carpetaAct) == trim(oLD.dir_ruta) , " - '" , trim(oLD.carpetaAct), "' == '", trim(oLD.dir_ruta), "'")
			if((trim(oLD.carpetaAct) == trim(oLD.dir_ruta)) || ((trim(oLD.carpetaAct)+"/") == trim(oLD.dir_ruta))) {
				oLD.carpetaAct = "";
			}
		}
		else {
			oLD.carpetaAct = oLD.data[oA.attr('pos')][0];
		}
	   oLD.recarga();
	}
}

////////////////////////////////////////////////////////////////////////
/* Borrar Archivo del Directorio
 * Author: EG - 2010-6-12
*/
function _borrar_listaDir(o) {
	var arch = "";
	var oA = jq.$(o);
	var oLD = buscaLD(oA.attr('comp'));
	if(oLD) {
		// Ventana modal
		if(jq.$('#miDia').length>0) {
			_tTxt = '#miDia';
		}
		else {
			_tTxt = "<div id='miDia' title='Verificacin' style='display:none'></div>";
		}

		var contDiv = "";
		var contData = "Archivo: " + oLD.data[oA.attr('pos')][1] + "<br/>";
		contData += "Tamao: " + oLD.data[oA.attr('pos')][3] + "<br/>";

		if( (oLD.data[oA.attr('pos')][4]) == null ) {
			contDiv = dirImg+"archivo.png";
		}
		else {
			contDiv = oLD.data[oA.attr('pos')][0];
			contData += "Mime: " + oLD.data[oA.attr('pos')][4] + "<br/>";
			contData += "Dim: " + oLD.data[oA.attr('pos')][8] + "<br/>";
		}

		jq.$(_tTxt).html("Desea Borrar el Archivo<br/><table><tr><td><img src='"+contDiv+"' width='144px' height='144px' /></td><td>"+contData+"</td></tr></table>").dialog({
			modal: true
			, buttons: {
				'si': function() {
					arch = oLD.data[oA.attr('pos')][1];

					var parametros = { 'sidname': sidname[1], 'Fun': "borrarArchivo", 'dir': oLD.dir_ruta, "archivo": arch };

					jq.$.ajax({
						url: dirLibsPHP + "upload_sr.php"
						, type: 'POST'
						, data: parametros
						, dataType: "json"
						, success: function(data) {
							if(data.success == true) {
								oLD.data = data.dir;
								oLD.pintar();
							}
							else {
								jqAlert("Error de Escritura", data.error);
							}
						}
					});
				}
				, 'no': function() { jq.$('#miDia').dialog('close'); }
			}
		});
	}

}

////////////////////////////////////////////////////////////////////////
/* Maneja la Barra de Controles
 * Author: EG - 2010-6-16
*/
function control_listaDir(o, bs) {
	var op = jq.$(o).parent();
	var ctrls = jq.$("div[name='control']", op);
	if(bs == true) {
		ctrls.show();
	}
	else {
		ctrls.hide();
	}
}

////////////////////////////////////////////////////////////////////////
/* Busca un Control Directorio
 * \param _sID - (STRING) Nombre del Control a Buscar
 * \author EG - 2010-06-14
 */
function _localiza_listaDir() {
	var _sID = arguments[0];
	var _objx = null;
	for(n=0; n<_aUploadDir.length; n++) {
		if( _aUploadDir[n].id == _sID ) {
			_objx = _aUploadDir[n];
			n += _aUploadDir.length;
		}
	}
	return _objx;
}

function buscaLD() {
  var _sID = trim(arguments[0]);
  return _localiza_listaDir(_sID);
}

////////////////////////////////////////////////////////////////////////
/*
 * Caracteristicas del Upload
 */
function _cUL_caracteristicas() {
	this.bAuto 				= false;
	this.txtBSubida 		= new String("");
	this.txtBRemove 		= new String("");
	this.maxSize 			= new Number(0);
	this.charWidth 		= new Number(30);
	this.veriSEsc 			= true;
	this.responseUpload 	= null;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* Upload Js
  EG - egonpin@gmail.com
  2010/05/18
  2008/01/17
*/
