<?php
global $cnf;

global $esqDB;
if( !is_array($esqDB) ) { $esqDB = array(); }

$esqDB['xcomun'] = array();
$esqDB['xapito'] = array();

if(isset($cnf['dbschema']) AND $cnf['dbschema'] === true)
{
	$xap = "xapito.";
	$xcm = "xcomun.";
}
else
{
	$xap = "xap_";
	$xcm = "xcm_";
}

$esqDB['login'] = "'{$_SESSION['login']}'";
$esqDB['grupo'] = "{$_SESSION['cnf']['grupo_activo']}";

$esqDB['xapito']['acceso'] = "{$xap}acceso";

$esqDB['xcomun']['cnf_grupos'] 			= "{$xcm}cnf_grupos";
$esqDB['xcomun']['grupos'] 				= "{$xcm}grupos";
$esqDB['xcomun']['permisos'] 				= "{$xcm}permisos";
$esqDB['xcomun']['sesiones'] 				= "{$xcm}sesiones";
$esqDB['xcomun']['usuarios'] 				= "{$xcm}usuarios";
$esqDB['xcomun']['usuarios_grupos'] 	= "{$xcm}usuarios_grupos";
$esqDB['xcomun']['usuarios_permisos'] 	= "{$xcm}usuarios_permisos";
$esqDB['xcomun']['campos_db'] 			= "{$xcm}campos_db";
$esqDB['xcomun']['documentos_nv'] 		= "{$xcm}documentos_nv";

function sql_xcm_usuarios($fun)
{
	global $esqDB;
	switch($fun)
	{
	 case 'verifica_login_con_nivel':
	 {
	 	return "SELECT (login), id_nivel_usuario, cant_sesiones_max, cant_sesiones, is_activo
	               FROM {$esqDB['xcomun']['usuarios']}
	               WHERE login  = ? AND passwd = ? ; ";
	 }
	 break;

   case 'verifica_login_sin_nivel':
	 {
	 	return "SELECT (login), 2 AS id_nivel_usuario, cant_sesiones_max, cant_sesiones, is_activo
	               FROM {$esqDB['xcomun']['usuarios']}
	               WHERE login  = ? AND passwd = ? ; ";
	 }
	 break;

   case 'actualiza_sesiones':
	 {
	 	return "UPDATE {$esqDB['xcomun']['usuarios']} SET cant_sesiones = ?
		                 WHERE login  = ?
						     AND passwd = ? ; ";

	 }
	 break;

  }
}

function sql_xcm_sesiones($fun = 'default')
{
	global $esqDB;
	switch($fun)
	{
		case 'default':
		{
		  return "SELECT login, fec_ingreso, ip, id_sesion
		  				FROM {$esqDB['xcomun']['sesiones']}
		  				WHERE login= ? ; ";
		}
		break;

		case 'guarda_login_semilla':
		{
		  return 'INSERT INTO public.xcm_sesiones ( "login", ip, semilla ) VALUES (?, ?, ?);';
		}
		break;

		case 'retorna_id_sesion':
		{
		  return "SELECT id_sesion
		  				FROM {$esqDB['xcomun']['sesiones']}
		  				WHERE login = ? AND ip = ? AND semilla = ? ; ";
		}
		break;

	}
}

function sql_xcm_usuariosgrupos($fun = 'default')
{
	global $esqDB;
	switch($fun)
	{
		case 'default':
		{
		  return "SELECT id_grupo
		           FROM {$esqDB['xcomun']['usuarios_grupos']}
		           WHERE login  = ? ; ";
		}
		break;
	}
}

function sql_xcm_grupos($fun = 'default')
{
	global $esqDB;
	switch($fun)
	{
		case 'default':
		{
		  return "SELECT nom_grupo
		               FROM {$esqDB['xcomun']['grupos']}
		               WHERE id_grupo IN (?); ";
		}
		break;
	}
}

function sql_xcm_cnf_grupos($fun = 'default')
{
	global $esqDB;
	switch($fun)
	{
		case 'default':
		{
		  return "SELECT nom_cnf, vr_cnf
		  				FROM {$esqDB['xcomun']['cnf_grupos']}
                  WHERE id_grupo IN (?); ";
		}
		break;
	}
}?>
