
CREATE OR REPLACE FUNCTION vot_resultados_planchas_fx(p_id_votacion integer)
  RETURNS SETOF vot_resultado2 AS
$BODY$DECLARE
r vot_resultado2;
v_cant_votos integer;
v_contador integer;
BEGIN
	SELECT COUNT(*) INTO v_cant_votos
	 FROM  vot_votos_planchas
	 WHERE id_votacion = $1;
	v_contador := 1;

	IF (v_cant_votos > 0) THEN
		FOR r IN SELECT (p.nom_plancha) AS maq_nom_nuip, count(*) AS nro_votos, round(count(*)/v_cant_votos::numeric*100,2) AS pct_votos, v.id_votacion
			  FROM  vot_votos_planchas v, vot_planchas p
			  WHERE v.id_plancha = p.id_plancha
			    AND v.id_votacion = $1
			  GROUP BY v.id_votacion
			  ORDER BY count(*) DESC
		LOOP
			r.conteo := v_contador;
			v_contador := v_contador + 1;
			RETURN NEXT r;
		END LOOP;
		RETURN;
	ELSE
		RAISE EXCEPTION 'No se han registrado votos.';
	END IF;
END$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION vot_resultados_planchas_fx(integer) OWNER TO dbxdba;
