<?php
session_name($_POST["sidname"]);
session_start();
if(count($_SESSION) == 0) {
	header("Content-Type: application/x-javascript; charset=utf-8");
	echo "<script type='text/javascript'>
			alert('Sesion expirada, por favor vuelva a ingresar.');
			window.location.replace('../');
		</script>";
	exit(0);
}
else {
	include_once($_SERVER['DOCUMENT_ROOT'].$_SESSION["cnf"]["install_path"]."/config/config.inc.php"); // ** NUEVO
	include_once("main_fx.php");

	if(isset($_POST["funcion"]) )
	{
		switch($_POST["funcion"])
		{
			 case 'guardaNuipGrupo': {
				fguardaNuipGrupo($_POST['idNS'], $_POST['idG']);
			 }
			 break;
			 case 'guardaNuip': {
				fguardaNuip($_POST['idTN'], $_POST['idN'], $_POST['nn'], $_POST['an'], $_POST['idTitN'], $_POST['ne'], $_POST['idNS'], $_POST['perfil']);
			 }
			 break;
			 case 'guardaProveedor': {
				fguardaProveedor($_POST['idP'], $_POST['obs'], $_POST['idNS']);
			 }
			 break;
			 case 'editaProveedor': {
				feditaProveedor($_POST['idNS']);
			 }
			 break;
			 case 'guardaTelefono': {
				fguardaTel($_POST['idNT'], $_POST['tel'], $_POST['idTT'], $_POST['idNS']);
			 }
			 break;
			 case 'borrarTelefono': {
				fborrarTel($_POST['idNT']);
			 }
			 break;
			 case 'guardaCorreoe': {
				fguardaEmail($_POST['idNE'], $_POST['email'], $_POST['idTD'], $_POST['idNS']);
			 }
			 break;
			 case 'borrarCorreoe': {
				fborrarEmail($_POST['idNE']);
			 }
			 break;
			 case 'guardaDireccion': {
				fguardaDir($_POST['idND'], $_POST['dir'], $_POST['idTD'], $_POST['idNS'], $_POST['idM']);
			 }
			 break;
			 case 'borrarDireccion': {
				fborrarDir($_POST['idND']);
			 }
			 break;
			 case 'borrarNuipGrupo': {
				fborrarNuipGrupo($_POST['idG'], $_POST['idNS']);
			 }
			 break;
		}

	}
}

////////////////////////////////////////////////////////////////////////
function feditaProveedor($id_nuip_serial) {
	if(trim($id_nuip_serial) == '' ) { $id_nuip_serial = "NULL"; } else { $id_nuip_serial = "'{$id_nuip_serial}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($id_nuip_serial == 'NULL')	{
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	$conn  = conectar_db("",true);

	if($aborto_proc == false) {
		{
			$sql = "SELECT id_proveedor, observa, id_nuip_serial FROM public.ped_proveedores"
					. " WHERE id_nuip_serial={$id_nuip_serial}; ";
			$err_txt = "Seleccionar";
		}

		$resultado = query_db($sql, true);
		$arrau = fetch_array_db($resultado);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} el proveedor";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			$sdata['data'] = Array( $arrau );
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(to_utf8($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function fguardaProveedor($id_proveedor, $observa, $id_nuip_serial) {
	if(trim($id_proveedor) == '' ) { $id_proveedor = "NULL"; } else { $id_proveedor = "'{$id_proveedor}'"; }
	if(trim($observa) == '' ) { $observa = "NULL"; } else { $observa = "'{$observa}'"; }
	if(trim($id_nuip_serial) == '' ) { $id_nuip_serial = "NULL"; } else { $id_nuip_serial = "'{$id_nuip_serial}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($id_nuip_serial == 'NULL')	{
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	$conn  = conectar_db("",true);

	if($aborto_proc == false) {
		$sql = "BEGIN; ";
		if($id_proveedor == 'NULL'){  // INSERT
			$sql .= "INSERT INTO public.ped_proveedores("
					. " id_nuip_serial, observa )"
					. " VALUES ({$id_nuip_serial}, {$observa}); "
					. " SELECT lastval() AS id_proveedor; ";
			$err_txt = "Insertar";
		}
		else {
			$sql .= "UPDATE public.ped_proveedores SET "
					. " id_proveedor={$id_proveedor}"
					. ", id_nuip_serial={$id_nuip_serial}"
					. ", observa={$observa} "
					. " WHERE id_proveedor = {$id_proveedor}; "
					. " SELECT {$id_proveedor} AS id_proveedor; ";
			$err_txt = "Actualizar";
		}

		$resultado = query_db($sql, true);
		$arrau = fetch_array_db($resultado);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} el proveedor";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			$sdata['data'] = Array( $arrau );
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(to_utf8($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function fborrarEmail($id_nuip_email) {
	if(trim($id_nuip_email) == '' ) { $id_nuip_email = "NULL"; } else { $id_nuip_email = "'{$id_nuip_email}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($id_nuip_email == 'NULL')	{
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	$conn  = conectar_db("",true);

	if($aborto_proc == false) {
		$sql = "BEGIN; ";
		{  // INSERT
			$sql .= "DELETE FROM public.xcm_nuips_emails"
			." WHERE id_nuip_email={$id_nuip_email}; ";
			$err_txt = "Suprimir";
		}

		$resultado = query_db($sql, true);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} el Correo-e";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;
	$sdata['sql'] = $sql;

	$sdata = json_encode(to_utf8($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function fguardaEmail($id_nuip_email, $email, $id_tipo_dir, $id_nuip_serial) {
	if(trim($id_nuip_email) == '' ) { $id_nuip_email = "NULL"; } else { $id_nuip_email = "'{$id_nuip_email}'"; }
	if(trim($email) == '' ) { $email = "NULL"; } else { $email = "'{$email}'"; }
	if(trim($id_tipo_dir) == '' ) { $id_tipo_dir = "NULL"; } else { $id_tipo_dir = "'{$id_tipo_dir}'"; }
	if(trim($id_nuip_serial) == '' ) { $id_nuip_serial = "NULL"; } else { $id_nuip_serial = "'{$id_nuip_serial}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($email == 'NULL' OR $id_nuip_serial == 'NULL')	{
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	$conn  = conectar_db("",true);

	if($aborto_proc == false) {
		$sql = "BEGIN; ";
		if($id_nuip_email == 'NULL'){  // INSERT
			$sql .= "INSERT INTO public.xcm_nuips_emails("
					. " id_nuip_serial, id_tipo_dir, email )"
					. " VALUES ({$id_nuip_serial}, {$id_tipo_dir}, {$email}); "
					. " SELECT lastval() AS id_nuip_email; ";
			$err_txt = "Insertar";
		}
		else {
			$sql .= "UPDATE public.xcm_nuips_emails SET "
					. " id_nuip_email={$id_nuip_email}"
					. ", id_nuip_serial={$id_nuip_serial}"
					. ", id_tipo_dir={$id_tipo_dir}"
					. ", email={$email} "
					. " WHERE id_nuip_email = {$id_nuip_email}; "
					. " SELECT {$id_nuip_email} AS id_nuip_email; ";
			$err_txt = "Actualizar";
		}

		$resultado = query_db($sql, true);
		$arrau = fetch_array_db($resultado);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} el correo-e";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			$sdata['data'] = Array( $arrau );
			$sdata['sql'] = $sql;
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(to_utf8($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function fborrarDir($id_nuip_dir) {
	if(trim($id_nuip_dir) == '' ) { $id_nuip_dir = "NULL"; } else { $id_nuip_dir = "'{$id_nuip_dir}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($id_nuip_dir == 'NULL')	{
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	$conn  = conectar_db("",true);

	if($aborto_proc == false) {
		$sql = "BEGIN; ";
		{  // INSERT
			$sql .= "DELETE FROM public.xcm_nuips_dirs"
			." WHERE id_nuip_dir={$id_nuip_dir}; ";
			$err_txt = "Suprimir";
		}

		$resultado = query_db($sql, true);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} la Direccin";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;
	$sdata['sql'] = $sql;

	$sdata = json_encode(to_utf8($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function fguardaDir($id_nuip_dir, $dir, $id_tipo_dir, $id_nuip_serial, $id_municipio) {
	if(trim($id_nuip_dir) == '' ) { $id_nuip_dir = "NULL"; } else { $id_nuip_dir = "'{$id_nuip_dir}'"; }
	if(trim($dir) == '' ) { $dir = "NULL"; } else { $dir = "'{$dir}'"; }
	if(trim($id_tipo_dir) == '' ) { $id_tipo_dir = "NULL"; } else { $id_tipo_dir = "'{$id_tipo_dir}'"; }
	if(trim($id_nuip_serial) == '' ) { $id_nuip_serial = "NULL"; } else { $id_nuip_serial = "'{$id_nuip_serial}'"; }
	if(trim($id_municipio) == '' ) { $id_municipio = "NULL"; } else { $id_municipio = "'{$id_municipio}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($dir == 'NULL' OR $id_nuip_serial == 'NULL')	{
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	$conn  = conectar_db("",true);

	if($aborto_proc == false) {
		$sql = "BEGIN; ";
		if($id_nuip_dir == 'NULL'){  // INSERT
			$sql .= "INSERT INTO public.xcm_nuips_dirs("
					. " id_nuip_serial, id_tipo_dir, dir )"
					. " VALUES ({$id_nuip_serial}, {$id_tipo_dir}, {$dir}); "
					. " SELECT lastval() AS id_nuip_dir; ";
			$err_txt = "Insertar";
		}
		else {
			$sql .= "UPDATE public.xcm_nuips_dirs SET "
					. " id_nuip_dir={$id_nuip_dir}"
					. ", id_nuip_serial={$id_nuip_serial}"
					. ", id_tipo_dir={$id_tipo_dir}"
					. ", id_municipio={$id_municipio}"
					. ", dir={$dir} "
					. " WHERE id_nuip_dir = {$id_nuip_dir}; "
					. " SELECT {$id_nuip_dir} AS id_nuip_dir; ";
			$err_txt = "Actualizar";
		}

		$resultado = query_db($sql, true);
		$arrau = fetch_array_db($resultado);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} la direcci&oacute;n";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			$sdata['data'] = Array( $arrau );
			$sdata['sql'] = $sql;
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(to_utf8($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function fborrarTel($id_nuip_tel) {
	if(trim($id_nuip_tel) == '' ) { $id_nuip_tel = "NULL"; } else { $id_nuip_tel = "'{$id_nuip_tel}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($id_nuip_tel == 'NULL')	{
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	$conn  = conectar_db("",true);

	if($aborto_proc == false) {
		$sql = "BEGIN; ";
		{  // INSERT
			$sql .= "DELETE FROM public.xcm_nuips_tels"
			." WHERE id_nuip_tel={$id_nuip_tel}; ";
			$err_txt = "Suprimir";
		}

		$resultado = query_db($sql, true);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} el Tel&eacute;fono";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;
	$sdata['sql'] = $sql;

	$sdata = json_encode(to_utf8($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function fguardaTel($id_nuip_tel, $telefono, $id_tipo_tel, $id_nuip_serial) {
	if(trim($id_nuip_tel) == '' ) { $id_nuip_tel = "NULL"; } else { $id_nuip_tel = "'{$id_nuip_tel}'"; }
	if(trim($telefono) == '' ) { $telefono = "NULL"; } else { $telefono = "'{$telefono}'"; }
	if(trim($id_tipo_tel) == '' ) { $id_tipo_tel = "NULL"; } else { $id_tipo_tel = "'{$id_tipo_tel}'"; }
	if(trim($id_nuip_serial) == '' ) { $id_nuip_serial = "NULL"; } else { $id_nuip_serial = "'{$id_nuip_serial}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($telefono == 'NULL' OR $id_nuip_serial == 'NULL')	{
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	$conn  = conectar_db("",true);

	if($aborto_proc == false) {
		$sql = "BEGIN; ";
		if($id_nuip_tel == 'NULL'){  // INSERT
			$sql .= "INSERT INTO public.xcm_nuips_tels("
					. " id_nuip_serial, id_tipo_tel, tel )"
					. " VALUES ({$id_nuip_serial}, {$id_tipo_tel}, {$telefono}); "
					. " SELECT lastval() AS id_nuip_tel; ";
			$err_txt = "Insertar";
		}
		else {
			$sql .= "UPDATE public.xcm_nuips_tels SET "
					. " id_nuip_tel={$id_nuip_tel}"
					. ", id_nuip_serial={$id_nuip_serial}"
					. ", id_tipo_tel={$id_tipo_tel}"
					. ", tel={$telefono} "
					. " WHERE id_nuip_tel = {$id_nuip_tel}; "
					. " SELECT {$id_nuip_tel} AS id_nuip_tel; ";
			$err_txt = "Actualizar";
		}

		$resultado = query_db($sql, true);
		$arrau = fetch_array_db($resultado);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} el telefono";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			$sdata['data'] = Array( $arrau );
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(to_utf8($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function fguardaNuipGrupo($id_nuip_serial, $id_grupo) {
	if(trim($id_nuip_serial) == '' ) { $id_nuip_serial = "NULL"; } else { $id_nuip_serial = "'{$id_nuip_serial}'"; }
	if(trim($id_grupo) == '' ) { $id_tipo_nuip = "NULL"; } else { $id_tipo_nuip = "'{$id_tipo_nuip}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($id_grupo == 'NULL' OR $id_nuip_serial == 'NULL')	{
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	$conn  = conectar_db("",true);

	if($aborto_proc == false) {
		$sql = "BEGIN; ";
		{  // INSERT
			$sql .= "INSERT INTO public.xcm_nuips_grupos(id_nuip_serial, id_grupo)"
					. " VALUES ({$id_nuip_serial}, {$id_grupo}); ";
			$err_txt = "Insertar";
		}

		$resultado = query_db($sql, true);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} el grupo";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(to_utf8($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function fborrarNuipGrupo($id_grupo, $id_nuip_serial) {
	if(trim($id_grupo) == '' ) { $id_grupo = "NULL"; } else { $id_grupo = "'{$id_grupo}'"; }
	if(trim($id_nuip_serial) == '' ) { $id_nuip_serial = "NULL"; } else { $id_nuip_serial = "'{$id_nuip_serial}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($id_grupo == 'NULL' OR $id_nuip_serial == 'NULL')	{
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	$conn  = conectar_db("",true);

	if($aborto_proc == false) {
		$sql = "BEGIN; ";
		{  // INSERT
			$sql .= "DELETE FROM public.xcm_nuips_grupos"
			." WHERE id_grupo={$id_grupo} AND id_nuip_serial={$id_nuip_serial}; ";
			$err_txt = "Suprimir";
		}

		$resultado = query_db($sql, true);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} el grupo";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;
	$sdata['sql'] = $sql;

	$sdata = json_encode(to_utf8($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function fguardaNuip($id_tipo_nuip, $id_nuip, $nom_nuip, $ape_nuip, $id_tit_nuip, $nom_empresa, $id_nuip_serial, $perfil) {
	if(trim($id_tipo_nuip) == '' ) { $id_tipo_nuip = "NULL"; } else { $id_tipo_nuip = "'{$id_tipo_nuip}'"; }
	if(trim($id_nuip) == '' ) { $id_nuip = "NULL"; } else { $id_nuip = "'{$id_nuip}'"; }
	if(trim($nom_nuip) == '' ) { $nom_nuip = "NULL"; } else { $nom_nuip = "'{$nom_nuip}'"; }
	if(trim($ape_nuip) == '' ) { $ape_nuip = "NULL"; } else { $ape_nuip = "'{$ape_nuip}'"; }
	if(trim($id_tit_nuip) == '' ) { $id_tit_nuip = "NULL"; } else { $id_tit_nuip = "'{$id_tit_nuip}'"; }
	if(trim($nom_empresa) == '' ) { $nom_empresa = "NULL"; } else { $nom_empresa = "'{$nom_empresa}'"; }
	if(trim($id_nuip_serial) == '' ) { $id_nuip_serial = "NULL"; } else { $id_nuip_serial = "'{$id_nuip_serial}'"; }
	if(trim($perfil) == '' ) { $perfil = "NULL"; } else { $perfil = "'{$perfil}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($nom_nuip == 'NULL')	{
		$aborto_proc = true;
		$error = "Falta Nombre ";
	}

	$conn  = conectar_db("",true);

	if($aborto_proc == false) {
		$sql = "BEGIN; ";
		if($id_nuip_serial == "NULL") {  // INSERT
			$sql .= "INSERT INTO public.xcm_nuips( "
				. "id_nuip, id_tipo_nuip, nom_nuip, ape_nuip, nom_empresa, id_titulo_nuip, login_tx ) "
				. " VALUES ({$id_nuip}, {$id_tipo_nuip}, {$nom_nuip}, {$ape_nuip}, {$nom_empresa}, {$id_tit_nuip}, {$login}); "
				. " SELECT lastval() AS id_nuip_serial;";
			$err_txt = "Insertar";
		}
		else { // UPDATE
			$sql .= "UPDATE public.xcm_nuips SET "
				. "id_nuip_serial={$id_nuip_serial}, id_nuip={$id_nuip}, id_tipo_nuip={$id_tipo_nuip}"
				. ", nom_nuip={$nom_nuip}, ape_nuip={$ape_nuip}, nom_empresa={$nom_empresa}, id_titulo_nuip={$id_tit_nuip}, login_tx={$login} "
				. " WHERE id_nuip_serial={$id_nuip_serial}; "
				. " SELECT {$id_nuip_serial} AS id_nuip_serial; ";
			$err_txt = "Actualizar";
		}

		$resultado = query_db($sql, true);
		$arrau = fetch_array_db($resultado);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} el nuip";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			$sdata['data'] = Array( $arrau );
			query_db("COMMIT;", true);

			$grupos = explode(",", $_SESSION["cnf"]["grupos_usuario"]);
			$maxn = count($grupos);

			if($arrau == false) { $arrau[0] = $id_nuip_serial; }
			for($n=0; $n<$maxn; $n++) {
				asignarNuipGrupo($arrau[0], $grupos[$n]);
				if($perfil != "NULL") {
					asignarNuipPerfil($arrau[0], $perfil, $grupos[$n]);
				}
			}
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(to_utf8($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function asignarNuipGrupo($id_nuip_serial, $id_grupo) {
	if(trim($id_nuip_serial) == '' ) { $id_nuip_serial = "NULL"; } else { $id_nuip_serial = "{$id_nuip_serial}"; }
	if(trim($id_grupo) == '' ) { $id_grupo = "NULL"; } else { $id_grupo = "'{$id_grupo}'"; }
	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($id_grupo == 'NULL' OR $id_nuip_serial == 'NULL')	{
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	$conn  = conectar_db("",true);

	if($aborto_proc == false) {
		$sql = "SELECT count(id_nuip_serial) AS conteo FROM public.xcm_nuips_grupos "
				." WHERE id_grupo={$id_grupo} AND id_nuip_serial={$id_nuip_serial}; ";
		$resultado = query_db($sql, true);
		$arrau = fetch_array_db($resultado);

		$sql = "BEGIN; ";
		if($arrau[0] == 0) { // INSERT
			$sql .= "INSERT INTO public.xcm_nuips_grupos(id_nuip_serial, id_grupo)"
					."	VALUES ({$id_nuip_serial}, {$id_grupo}); ";
			$err_txt = "Asignar";
		}
		$resultado = query_db($sql, true);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} el nuip al grupo";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
		}
		else {
			query_db("COMMIT;", true);
		}
	}

return(!$aborto_proc);
}

////////////////////////////////////////////////////////////////////////
function asignarNuipPerfil($id_nuip_serial, $perfil, $id_grupo) {
	if(trim($id_nuip_serial) == '' ) { $id_nuip_serial = "NULL"; } else { $id_nuip_serial = "{$id_nuip_serial}"; }
	if(trim($perfil) == '' ) { $perfil = "NULL"; } else { $perfil = "'{$perfil}'"; }
	if(trim($id_grupo) == '' ) { $id_grupo = "NULL"; } else { $id_grupo = "'{$id_grupo}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($perfil == 'NULL' OR $id_nuip_serial == 'NULL')	{
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	$conn  = conectar_db("",true);

	if($aborto_proc == false) {
		$sql = "SELECT count(id_nuip_serial) AS conteo FROM public.xcm_nuips_perfiles "
				." WHERE id_grupo={$id_grupo} AND id_nuip_serial={$id_nuip_serial} AND id_perfil={$perfil}; ";
		$resultado = query_db($sql, true);
		$arrau = fetch_array_db($resultado);

		$sql = "BEGIN; ";
		if($arrau[0] == 0) { // INSERT
			$sql .= "INSERT INTO public.xcm_nuips_perfiles(id_nuip_serial, id_grupo, id_perfil)"
					."	VALUES ({$id_nuip_serial}, {$id_grupo}, {$perfil}); ";
			$err_txt = "Asignar";
		}
		$resultado = query_db($sql, true);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} el nuip al perfil";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
		}
		else {
			query_db("COMMIT;", true);
		}
	}

return(!$aborto_proc);
}


function formularioJugadorPista() {
	global $cnf;

$campos['bol_torneo1'] = gen_campo_html(array("nom_campo_id"=>"id_bol_torneo1",
										"label_html"		=> "Seleccione Torneo: "
										, "type" 			=> "COMBOBOX"
										, "is_hidden" 		=> false
										, "is_null"			=> true
										, "is_horizontal"	=> true
										, "is_vertical"	=> false
									));
$campos['bol_torneo2'] = gen_campo_html(array("nom_campo_id"=>"id_bol_torn2",
										"label_html"		=> "Seleccione Torneo: "
										, "type" 			=> "COMBOBOX"
										, "is_hidden" 		=> false
										, "is_null"			=> true
										, "is_horizontal"	=> true
										, "is_vertical"	=> false
									));


$contSCRIPT =<<<contSCRIPT
	<script type='text/javascript'>
		jq.$(function()
		{
			Pistas();
			Jugadores();
			Equipos();

			var oCBx_t2 = objCB("id_bol_torn2",
										"public.bol_torneos",
										"id_bol_torneo",
									  "nom_torneo, desc_torneo, id_bol_torneo",
										1,
										""
										);
			oCBx_t2.isNull = true;
			oCBx_t2.isNullVis = true;
			oCBx_t2.orden = "nom_torneo";
			oCBx_t2.consulta(true);

			var oCBx_t1 = objCB("id_bol_torneo1",
										"public.bol_torneos",
										"id_bol_torneo",
									  "nom_torneo, desc_torneo, id_bol_torneo",
										1,
										""
										);
			oCBx_t1.isNull = true;
			oCBx_t1.isNullVis = true;
			oCBx_t1.orden = "nom_torneo";
			oCBx_t1.consulta(true);

			/////////////////////////////////////////////////////////////// Jugadores
			var oLis_jugadores = objListar("oSel_jugadores",
										"bol_jugadores",
										"id_bol_jugador",
										"nom_jugador, ape_jugador, nuip_jugador, correoe_jugador, tel_jugador, id_bol_empresa, id_bol_equipo, pct_acumulado, cant_juegos, id_bol_jugador",
										4,
										"Nombre(s), Apellido(s), Id, Correo Elec.", //nombre de los campos
										"", // Filtro
										"MULTISELECCION", // SELECCION, LISTA, EDICION
										10, 3);
			oLis_jugadores.enVentana = (false);
			oLis_jugadores.enable = true;
			oLis_jugadores.typeEDIT = 3;
			oLis_jugadores.colRetorno = oLis_jugadores.posCol("id_bol_jugador");
			oLis_jugadores.cargaInicial = false;
			oLis_jugadores.Inicio();
			oLis_jugadores.oculta("XML");
			oLis_jugadores.muestra("BUS");

			/////////////////////////////////////////////////////////////// Equipos
			var oLis_id_equipo = objListar("oSel_equipos",
										"bol_equipos",
										"id_bol_equipo",
										"nom_equipo, id_bol_equipo",
										1,
										"Equipo", //nombre de los campos
										"", // Filtro
										"MULTISELECCION", // SELECCION, LISTA, EDICION
										10, 3);
			oLis_id_equipo.enVentana = (false);
			oLis_id_equipo.enable = true;
			oLis_id_equipo.typeEDIT = 3;
			oLis_id_equipo.colRetorno = oLis_id_equipo.posCol("id_bol_equipo");
			oLis_id_equipo.cargaInicial = false;
			oLis_id_equipo.Inicio();
			oLis_id_equipo.oculta("XML");
			oLis_id_equipo.muestra("BUS");

		});

		function Equipos()
		{
			_sHTML = "<div id='posFTorn2'></div>";
			_sHTML += "<div >Seleccione la pista:</div>";
			_sHTML += "<div id='rPistas2'></div><br/>";
			_sHTML += "<div >Seleccione el equipo haciendo click en el smbolo:</div>";
			_sHTML += "<div id='oSel_equipos' width='100%'>Cargando Datos...</div>";

			_sHTML += "<button id='botSelEqu'>Grabar</button>";

			var vw = jq.$("<div>"+_sHTML+"</div>").attr({'title': 'Equipos', 'id': 'w_equipos'});
			jq.$('body').append(vw);

			var ot = jq.$('#torn2');
			jq.$('#torn2').remove();
			jq.$('#posFTorn2').append(ot);

			jq.$('#w_equipos').dialog({autoOpen: false });

			jq.$('#botSelEqu').button().click(
				function()
				{
					var tL = buscaListar('oSel_equipos');
					if(tL.aRetorno.length == 0)
					{
						jqAlert("Error", "Seleccione al menos un Equipo", "ERROR");
						return false;
					}
					var sidname = sid.split('=');
					var parametros = { "sidname":sidname[1]
									, "funcion" : "fAsignarEquipoPista"
									, "pista" : jq.$("input:checked", jq.$('#rPistas2')).attr('value')
									, "equipos" : tL.aRetorno.toJSON()
									, "torneo" : jq.$('#id_bol_torn2').attr('value') };

					jq.$.ajax(
					{
						url: "./bol_jugadores_pistas_sr.php"
						, type: 'POST'
						, data: parametros
						, dataType: "json"
						, success: function(data)
						{
							if(data.success == true)
							{
								var tL = buscaListar('oSel_jp');
								tL.cargaInicial = true;
								tL.refresca();
								jq.$('#w_equipos').dialog('close');
								jqAnuncio("Equipo asignado a Pista");
								tL = buscaListar('oSel_equipos');
								tL.sRetorno = new Array();
							}
							else
							{
								jqAlert("Error de Comunicacin", data.error, "ERROR");
							}
						}
					});
			});

			jq.$('#w_equipos').dialog("option", "modal", true).dialog("option", "width", "650px").dialog({open: function(e,ui)
				{
					var tL = buscaListar('oSel_equipos');
					tL.consulta();
				} });

			jq.$('#chkB_oSel_jugadores0').button();
		}

		function Jugadores()
		{
			_sHTML = "<div id='posFTorneo1'></div>";
			_sHTML += "<div id='rPistas_txt'>Seleccione la pista:</div>";
			_sHTML += "<div id='rPistas'></div><br/>";
			_sHTML += "<div id='rJugadores_txt'>Seleccione los jugadores haciendo click en el smbolo:</div>";
			_sHTML += "<div id='oSel_jugadores' width='100%'>Cargando Datos...</div>";

			_sHTML += "<button id='botSelJug'>Grabar</button>";

			var vw = jq.$("<div>"+_sHTML+"</div>").attr({'title': 'Jugadores', 'id': 'w_jugadores'});
			jq.$('body').append(vw);

			var ot = jq.$('#torneo1');
			jq.$('#torneo1').remove();
			jq.$('#posFTorneo1').append(ot);

			jq.$('#w_jugadores').dialog({autoOpen: false });

			jq.$('#botSelJug').button().click(
				function()
				{
					var tL = buscaListar('oSel_jugadores');
					if(tL.aRetorno.length == 0)
					{
						jqAlert("Error", "Seleccione al menos un Jugador", "ERROR");
						return false;
					}

					var sidname = sid.split('=');
					var parametros = { "sidname":sidname[1]
									, "funcion" : "AsignarJugadorPista"
									, "pista" : jq.$("input:checked", jq.$('#rPistas')).attr('value')
									, "jugadores" : tL.aRetorno.toJSON()
									, "torneo" : jq.$('#id_bol_torneo1').attr('value') };

					jq.$.ajax(
					{
						url: "./bol_jugadores_pistas_sr.php"
						, type: 'POST'
						, data: parametros
						, dataType: "json"
						, success: function(data)
						{
							if(data.success == true)
							{
								var ocheck = jq.$('input:checked', jq.$('#filtroPistas') );

								if(!ocheck.hasClass('cpistaOcupada')) {
									ocheck.addClass('cpistaOcupada').button({icons: {
										primary: 'ui-icon-circle-close'
									}});
								}
								ocheck.change();

								var tL = buscaListar('oSel_jp');
								tL.cargaInicial = true;
								tL.refresca();
								jq.$('#w_jugadores').dialog('close');
								jqAnuncio("Jugador asignado a Pista");
								tL = buscaListar('oSel_jugadores');
								tL.sRetorno = new Array();
							}
							else
							{
								jqAlert("Error de Comunicacin", data.error, "ERROR");
							}
						}
					});
			});

			jq.$('#w_jugadores').dialog("option", "modal", true).dialog("option", "width", "650px").dialog({open: function(e,ui)
				{
					var tL = buscaListar('oSel_jugadores');
					tL.consulta();
				} });

			jq.$('#chkB_oSel_jugadores0').button();
		}

		function Pistas()
		{
			consultaX("SELECT id_bol_pista, nom_pista, nro_pista, nro_juego, id_est_juego FROM bol_pistas ORDER BY nro_pista;"
				, 'retPistas'
				, ''
				, 'JSON');
		}
		function retPistas(d,c,f,p)
		{
			var txtP = "";
			var txtPE = "";
			var tPistasP = "";
			var n = 0;
			var cls = "";

			/////////////////////////////////////////////////////////////// Jugadores Pistas
			var oLis_JP = objListar('oSel_jp',
								'bol_jugadores_pistas_v1',
								'id_bol_jugadores_pista',
								'maq_nom_jugador, id_bol_jugadores_pista',
		 						1,
								'Jugador, Pista',
								'',
								'LISTA', // SELECCION, LISTA, EDICION
								10, 3);
			oLis_JP.enVentana = false;
			oLis_JP.enable = true;
			oLis_JP.typeEDIT = 3;
			oLis_JP.cargaInicial = false;
			oLis_JP.Inicio();
			oLis_JP.prnFunc[0] = "sacar_jugador";
			oLis_JP.prnTxt[0] = "<img src='"+dirLibImages+"ico_flecha_roja.png' onmouseover=\"overlib('Click aqu para sacar al Jugador de la Pista')\" onmouseout='nd();'>";
			oLis_JP.oculta('XML');
			oLis_JP.oculta('BUS');
			oLis_JP.muestra('PRN');

			for(n=0; n<d.length; n++)
			{
				if(n==0)
				{ chk = " checked='checked' "; }
				else
				{ chk = "";}

				// d[n][0] => id_bol_pista
				// d[n][1] => nom_pista
				// d[n][2] => nro_pista
				// d[n][3] => nro_juego
				// d[n][4] => id_est_juego

				val = " value='" + d[n][0] + "' ";

				if(d[n][4] == '2') {
					cls = " class='cpistaOcupada' ";
				}
				else {
					cls = " class='cpistaLibre' ";
				}

				txtP += "<input type='radio' id='radio"+n + "' name='radJugas' " + chk + val+ cls+" /><label for='radio"+n + "' >"+ d[n][1] +"</label>";
				txtPE += "<input type='radio' id='radi2"+n + "' name='radEqui' " + chk + val+ cls+" /><label for='radi2"+n + "' >"+ d[n][1] +"</label>";
				tPistasP += "<input type='radio' id='rPP"+n + "' name='radPP' " + val+ cls+" /><label for='rPP"+n + "' >"+ d[n][1] +"</label>";
			}

			jq.$('#filtroPistas').html(jq.$(tPistasP));
			jq.$('input', jq.$('#filtroPistas') ).change( function(e)
				{
					var t = null;
					if(e.target)
					{
						t = jq.$(e.target);
					}
					else
					{
						t = jq.$(e.srcElement);
					}

					jq.$('#b3').html( "Cerrar Juego en la " + t.button('option', 'label') ).val(t.val());
					if(t.hasClass('cpistaOcupada')) {
						jq.$('#b3').show();
					}
					else {
						jq.$('#b3').hide();
					}

					var tL = buscaListar('oSel_jp');
					tL.sFiltro = "(,id_bol_pista,=," + t.attr('value') + ")";
					tL.cargaInicial = true;
					tL.refresca();
				} ).map(function() {
					if(jq.$(this).hasClass('cpistaOcupada')) {
						jq.$(this).button({icons: {
							primary: 'ui-icon-circle-close'
						}});
					}
				});


			jq.$('#filtroPistas').buttonset();

			jq.$('#rPistas').append(jq.$(txtP));
			jq.$('#rPistas').buttonset();

			jq.$('#rPistas2').append(jq.$(txtPE));
			jq.$('#rPistas2').buttonset();

//			jq.$('#contJP').show();
		}

		function sacar_jugador(os, id, pos)
		{
//console.log(arguments);
			var sidname = sid.split('=');
			var parametros = { "sidname" : sidname[1]
									, "funcion" : "SacarJugadorPista"
									, "id" : id
								  };

			jq.$.ajax(
			{
				url: "./bol_jugadores_pistas_sr.php"
				, type: 'POST'
				, data: parametros
				, dataType: "json"
				, success: function(data)
				{
					if(data.success == true)
					{
						if(data.cant_juegos == 0) {
							var ocheck = jq.$('input:checked', jq.$('#filtroPistas') );

							if(ocheck.hasClass('cpistaOcupada')) {
								ocheck.removeClass('cpistaOcupada').button({icons: {
										primary: false
									}});
							}
							ocheck.change();
						}

						var tL = buscaListar('oSel_jp');
						tL.cargaInicial = true;
						jqAnuncio("Jugador sacado de la Pista");
						tL.refresca();
					}
					else
					{
						jqAlert("Error de Comunicacin", data.error, "ERROR");
					}
				}
			});
		}
	</script>
contSCRIPT;

$contHTML =<<<contHTML
Seleccione una Pista para Mostrar los Jugadores Actuales
	<div id='filtroPistas'></div>
	<div id='oSel_jp'></div>
	<div id='torneo1'>
		{$campos['bol_torneo1']['html']}
	</div>
	<div id='torn2'>
		{$campos['bol_torneo2']['html']}
	</div>
contHTML;

 header("Content-Type: application/html; charset=utf-8");
 echo to_utf8($contHTML);
 echo to_utf8($contSCRIPT);
}

?>
