<?php
session_name($_POST["sidname"]);
session_start();

if(count($_SESSION) == 0) {
	header('Location: ../includes/salida_segura.php');
	echo "
		<script type='text/javascript'>
			alert('Sesion expirada, por favor vuelva a ingresar.');
			window.location.replace('../');
		</script>
	";
	exit(0);
}
else {
	include_once($_SERVER['DOCUMENT_ROOT'].$_SESSION["cnf"]["install_path"]."/config/config.inc.php"); // ** NUEVO
	include_once("main_fx.php");

	if(isset($_POST["funcion"])) {
		switch($_POST["funcion"]) {
			case 'validaVotante': {
				fvalidaVotante($_POST["p1"]);
			} break;
			case 'consultaCandidatos': {
				fconsultaCandidatos($_POST["p1"], $_POST["p2"]);
			} break;
			case 'votar': {
				fvotar($_POST["p1"], $_POST["p2"], $_POST["p3"], $_POST["p4"]);
			} break;
		}
	}
}

////////////////////////////////////////////////////////////////////////
function fvalidaVotante($c1) {
	if(trim($c1) == '' ) { $c1 = "NULL"; } else { $c1 = "'{$c1}'"; }

	global $cnf;
	$error = "";
	$aborto_proc = false;
	$data = Array();
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";
	$grupo = 1;

	if($c1 == "NULL") {
		$error = "Faltan Datos";
		$aborto_proc = true;
	}

	if($aborto_proc == false) {
		$conn  = conectar_db("",true);
		$sql = "BEGIN; ";
		{// Validacion de NUIP
			{
				$sql = repare_ADOdbSQL(
					sql_votacion('valida_votante')
					, Array( $c1 )
					, true
				);
				$err_txt = "Consultar";
			}
			$resultado = query_db($sql, true);
			if (query_estado("err_msg", true) != "") {
				$error = "No se pudo {$err_txt} el censo electoral.";
				$aborto_proc = true;
				$sqlE = $sql;
			}
			else {
				$row = fetch_array_db($resultado);
				$sdata['valido'] = $row['conteo'];
			}
		}

		if($aborto_proc == false) {// Datos del Votante
			{
				$sql = repare_ADOdbSQL(
					sql_votacion('datos_votante')
					, Array( $c1 )
					, true
				);
				$err_txt = "Consultar";
			}
			$resultado = query_db($sql, true);
			if (query_estado("err_msg", true) != "") {
				$error = "No se pudo {$err_txt} los datos del Votante.";
				$aborto_proc = true;
				$sqlE = $sql;
			}
			else {
				$row = fetch_array_db($resultado);
				$sdata['nombre'] = trim($row['maq_nom_nuip']);
				$sdata['id'] = trim($row['maq_id_nuip']);
				$sdata['id_sede'] = trim($row['id_sede']);
			}
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sqlE;
		}
		else {
			$sdata['data'] = $data;
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}

	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function fvotar($c1, $c2, $c3, $id_sede) {
	if(count($c1) == 0 ) { $c1 = "NULL"; }
	if(trim($c2) == '' ) { $c2 = "NULL"; } else { $c2 = "'{$c2}'"; }
	if(trim($c3) == '' ) { $c3 = "NULL"; } else { $c3 = "'{$c3}'"; }
	if(trim($id_sede) == '' ) { $id_sede = "NULL"; } else { $id_sede = "'{$id_sede}'"; }

	global $cnf;
	$error = "";
	$aborto_proc = false;
	$data = Array();
	$sdata = Array();
	$is_plancha = 'f';

	if($c1 == "NULL" OR $c2 == "NULL" OR $c3 == "NULL") {
		$error = "Faltan Datos";
		$aborto_proc = true;
	}

	if($aborto_proc == false) {
		$conn  = conectar_db("",true);

		$sql = repare_ADOdbSQL( sql_utilidades('consultar_votacion')
			, Array($c2)
			, true
		);
		$err_txt = "Consultar";
		$resultado = query_db($sql, true);
		if (query_estado("err_msg", true) != "") {
			$error = "No se pudo {$err_txt} las Votaciones. ";
			$aborto_proc = true;
			$sqlE = $sql;
		}
		else {
			$row = fetch_array_db($resultado);
			$is_plancha = $row['is_plancha'];
		}

		$sql = "BEGIN; ";
		{// guardado de votos
			for($n=0; $n<count($c1); $n++) {
				if($is_plancha != 't') {
					$sql .= repare_ADOdbSQL(
						sql_votacion('guarda_voto')
						, Array( $c2, $c1[$n], $id_sede )
						, true
					);
				}
				else {
					$sql .= repare_ADOdbSQL(
						sql_votacion('guarda_voto_plancha')
						, Array( $c2, $c1[$n], $id_sede )
						, true
					);
				}
			}
			$err_txt = "Insertar";
			$resultado = query_db($sql, true);
			if (query_estado("err_msg", true) != "") {
				$error = "No se pudo {$err_txt} los Votos.";
				$aborto_proc = true;
				$sqlE = $sql;
			}
		}

		if($aborto_proc == false){ // Guarda Votacion
			{
				$sql = repare_ADOdbSQL(
					sql_votacion('guarda_votacion_nuip')
					, Array( $c2, $c3 )
					, true
				);
				$err_txt = "Guardar";
			}
			$resultado = query_db($sql, true);
			if (query_estado("err_msg", true) != "") {
				$error = "No se pudo {$err_txt} la votaci&oacute;n en la que particip&oacute; el Votante.";
				$aborto_proc = true;
				$sqlE = $sql;
			}
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sqlE;
		}
		else {
			query_db("COMMIT;", true);
		}

	}
	else {
		$sdata['error'] = $error;
	}

	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function fconsultaCandidatos($c1, $c2) {
	if(trim($c1) == '' ) { $c1 = "NULL"; } else { $c1 = "'{$c1}'"; }

	global $cnf;
	$error = "";
	$aborto_proc = false;
	$data = Array();
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";
	$grupo = 1;

	if($c1 == "NULL") {
		$error = "Faltan Datos";
		$aborto_proc = true;
	}

	if($aborto_proc == false) {
		$conn  = conectar_db("",true);
		$sql = "BEGIN; ";
		{// consultando los parametros de la votacion
			{
				$sql = repare_ADOdbSQL(
					sql_votacion('parametros_votacion')
					, Array( $c1 )
					, true
				);
				$err_txt = "Consultar";
			}
			$resultado = query_db($sql, true);
			if (query_estado("err_msg", true) != "") {
				$error = "No se pudo {$err_txt} la Votaci&oacute;n.";
				$aborto_proc = true;
				$sqlE = $sql;
			}
			else {
				$row = fetch_array_db($resultado);
				$sdata['cant_opciones']= $row['cant_opciones'];
				$sdata['is_voto_blanco']= $row['is_voto_blanco'];
				$sdata['is_salida_sin_votar']= $row['is_salida_sin_votar'];
				$sdata['nom_votacion']= $row['nom_votacion'];
				$sdata['is_plancha']= $row['is_plancha'];
			}
		}

		{// consultando los parametros de la sede
			{
				$sql = repare_ADOdbSQL(
					sql_votacion('consulta_sedes')
					, Array( $c2 )
					, true
				);
				$err_txt = "Consultar";
			}
			$resultado = query_db($sql, true);
			if (query_estado("err_msg", true) != "") {
				$error = "No se pudo {$err_txt} la Sede.";
				$aborto_proc = true;
				$sqlE = $sql;
			}
			else {
				$row = fetch_array_db($resultado);
				$sdata['nom_sede']= $row['nom_sede'];
			}
		}

		if($aborto_proc == false){
			 // Consultando Cartel
//echo "{$sdata['is_plancha']}";
			if($sdata['is_plancha'] == false OR $sdata['is_plancha'] === "f") { // Candidatos sueltos con foto
				{
					$sql = repare_ADOdbSQL(
						sql_votacion('consulta_candidatos')
						, Array( $c1 )
						, true
					);
					$err_txt = "Consultar";
				}
				$resultado = query_db($sql, true);
				if (query_estado("err_msg", true) != "") {
					$error = "No se pudo {$err_txt} la Planilla de votaci&oacute;n.";
					$aborto_proc = true;
					$sqlE = $sql;
				}
				else {
					while($row = fetch_array_db($resultado)) {
						array_push($data, $row);
					}
				}
			}
			else { // Planchas
				{
					$sql = repare_ADOdbSQL(
						sql_votacion('consulta_planchas')
						, Array( $c1 )
						, true
					);
					$err_txt = "Consultar";
				}
				$resultado = query_db($sql, true);
				if (query_estado("err_msg", true) != "") {
					$error = "No se pudo {$err_txt} las Planchas de votaci&oacute;n.";
					$aborto_proc = true;
					$sqlE = $sql;
				}
				else {
					// Consulta de Candidatos x Plancha
					while($row = fetch_array_db($resultado)) {
						{
							$sqlCP = repare_ADOdbSQL(
								sql_votacion('consulta_candidatos_plancha')
								, Array( $row['id_plancha'] )
								, true
							);
							$err_txt = "Consultar";
						}
						$resultadoCan = query_db($sqlCP, true);
						$dataCan = Array();
						if (query_estado("err_msg", true) != "") {
							$error = "No se pudo {$err_txt} los Candidatos de las Planchas.";
							$aborto_proc = true;
							$sqlE = $sqlCP;
						}
						else {
							while($rowCan = fetch_array_db($resultadoCan) ) {
								array_push($dataCan, $rowCan );
							}
						}

						array_push($data, array( $row, $dataCan ) );
					}

				}
			}
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sqlE;
		}
		else {
			$sdata['data'] = $data;
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}

	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

?>
