--
-- PostgreSQL database dump
--

-- Started on 2010-12-20 08:46:49 COT

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- TOC entry 8 (class 2615 OID 27499)
-- Name: votacion; Type: SCHEMA; Schema: -; Owner: dbxdba
--

CREATE SCHEMA votacion;


ALTER SCHEMA votacion OWNER TO dbxdba;

SET search_path = votacion, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- TOC entry 1592 (class 1259 OID 27517)
-- Dependencies: 1923 8
-- Name: planchas; Type: TABLE; Schema: votacion; Owner: dbxdba; Tablespace: 
--

CREATE TABLE planchas (
    id_plancha bigint NOT NULL,
    nom_plancha character varying(30) NOT NULL,
    desc_plancha text,
    id_zona integer DEFAULT 1 NOT NULL
);


ALTER TABLE votacion.planchas OWNER TO dbxdba;

--
-- TOC entry 1593 (class 1259 OID 27524)
-- Dependencies: 1925 8
-- Name: votacion; Type: TABLE; Schema: votacion; Owner: dbxdba; Tablespace: 
--

CREATE TABLE votacion (
    id_votacion bigint NOT NULL,
    id_programa bigint NOT NULL,
    id_plancha bigint,
    id_candidato bigint,
    fec_tx timestamp(0) without time zone DEFAULT now() NOT NULL
);


ALTER TABLE votacion.votacion OWNER TO dbxdba;

SET default_with_oids = false;

--
-- TOC entry 1594 (class 1259 OID 27528)
-- Dependencies: 8
-- Name: zonas_votacion; Type: TABLE; Schema: votacion; Owner: postgres; Tablespace: 
--

CREATE TABLE zonas_votacion (
    id_zona bigint NOT NULL,
    nom_zona character varying
);


ALTER TABLE votacion.zonas_votacion OWNER TO postgres;

--
-- TOC entry 1595 (class 1259 OID 27534)
-- Dependencies: 1728 8
-- Name: conteo_votos_v1; Type: VIEW; Schema: votacion; Owner: postgres
--

CREATE VIEW conteo_votos_v1 AS
    SELECT p.nom_plancha, p.desc_plancha, v.id_plancha, z.nom_zona, count(*) AS votos FROM planchas p, votacion v, zonas_votacion z WHERE ((p.id_plancha = v.id_plancha) AND (p.id_zona = z.id_zona)) GROUP BY z.nom_zona, v.id_plancha, p.nom_plancha, p.desc_plancha ORDER BY z.nom_zona, v.id_plancha;


ALTER TABLE votacion.conteo_votos_v1 OWNER TO postgres;

SET default_with_oids = true;

--
-- TOC entry 1596 (class 1259 OID 27538)
-- Dependencies: 8
-- Name: d_programacion; Type: TABLE; Schema: votacion; Owner: dbxdba; Tablespace: 
--

CREATE TABLE d_programacion (
    id_d_programacion bigint NOT NULL,
    id_programa bigint NOT NULL,
    id_sede bigint NOT NULL,
    id_plancha bigint NOT NULL,
    id_candidato bigint NOT NULL,
    id_sede2 bigint,
    id_sede3 bigint
);
ALTER TABLE ONLY d_programacion ALTER COLUMN id_programa SET STATISTICS 0;


ALTER TABLE votacion.d_programacion OWNER TO dbxdba;

--
-- TOC entry 1597 (class 1259 OID 27541)
-- Dependencies: 8
-- Name: d_programacion_id_d_programacion_seq; Type: SEQUENCE; Schema: votacion; Owner: postgres
--

CREATE SEQUENCE d_programacion_id_d_programacion_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.d_programacion_id_d_programacion_seq OWNER TO postgres;

--
-- TOC entry 1598 (class 1259 OID 27543)
-- Dependencies: 1596 8
-- Name: d_programacion_id_d_programacion_seq1; Type: SEQUENCE; Schema: votacion; Owner: dbxdba
--

CREATE SEQUENCE d_programacion_id_d_programacion_seq1
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.d_programacion_id_d_programacion_seq1 OWNER TO dbxdba;

--
-- TOC entry 1981 (class 0 OID 0)
-- Dependencies: 1598
-- Name: d_programacion_id_d_programacion_seq1; Type: SEQUENCE OWNED BY; Schema: votacion; Owner: dbxdba
--

ALTER SEQUENCE d_programacion_id_d_programacion_seq1 OWNED BY d_programacion.id_d_programacion;


--
-- TOC entry 1599 (class 1259 OID 27545)
-- Dependencies: 1929 1930 8
-- Name: programacion; Type: TABLE; Schema: votacion; Owner: dbxdba; Tablespace: 
--

CREATE TABLE programacion (
    id_programa bigint NOT NULL,
    descripcion text NOT NULL,
    fec_ini timestamp(0) without time zone DEFAULT now() NOT NULL,
    fec_fin timestamp(0) without time zone DEFAULT now() NOT NULL
);


ALTER TABLE votacion.programacion OWNER TO dbxdba;

--
-- TOC entry 1600 (class 1259 OID 27553)
-- Dependencies: 8
-- Name: sedes; Type: TABLE; Schema: votacion; Owner: dbxdba; Tablespace: 
--

CREATE TABLE sedes (
    id_sede bigint NOT NULL,
    nom_sede character varying(30) NOT NULL,
    desc_sede text
);


ALTER TABLE votacion.sedes OWNER TO dbxdba;

--
-- TOC entry 1602 (class 1259 OID 27566)
-- Dependencies: 1729 8
-- Name: d_programacion_v1; Type: VIEW; Schema: votacion; Owner: postgres
--

CREATE VIEW d_programacion_v1 AS
    SELECT v2.id_d_programacion, v2.descripcion, v2.fec_ini, v2.fec_fin, v2.nom_sede, v2.desc_sede, v2.nom_plancha, v2.id_candidato, v2.nom_nuip, v2.ape_nuip, v2.nom_sede2, v2.desc_sede2, vs.nom_sede AS nom_sede3, vs.desc_sede AS desc_sede3, v2.id_programa, v2.id_sede, v2.id_plancha, v2.id_sede2, v2.id_sede3 FROM ((SELECT v1.id_d_programacion, v1.descripcion, v1.fec_ini, v1.fec_fin, v1.nom_sede, v1.desc_sede, v1.nom_plancha, v1.id_candidato, v1.nom_nuip, v1.ape_nuip, vs.nom_sede AS nom_sede2, vs.desc_sede AS desc_sede2, v1.id_programa, v1.id_sede, v1.id_plancha, v1.id_sede2, v1.id_sede3 FROM ((SELECT dp.id_d_programacion, vpr.descripcion, vpr.fec_ini, vpr.fec_fin, vs.nom_sede, vs.desc_sede, vp.nom_plancha, dp.id_candidato, xn.nom_nuip, xn.ape_nuip, dp.id_programa, dp.id_sede, dp.id_plancha, dp.id_sede2, dp.id_sede3 FROM ((((d_programacion dp LEFT JOIN xcomun.nuips xn ON ((dp.id_candidato = xn.id_nuip))) LEFT JOIN planchas vp ON ((dp.id_plancha = vp.id_plancha))) LEFT JOIN sedes vs ON ((dp.id_sede = vs.id_sede))) LEFT JOIN programacion vpr ON ((dp.id_programa = vpr.id_programa)))) v1 LEFT JOIN sedes vs ON ((v1.id_sede2 = vs.id_sede)))) v2 LEFT JOIN sedes vs ON ((v2.id_sede3 = vs.id_sede))) ORDER BY v2.id_d_programacion;


ALTER TABLE votacion.d_programacion_v1 OWNER TO postgres;

--
-- TOC entry 1603 (class 1259 OID 27571)
-- Dependencies: 1730 8
-- Name: d_programacion_v2; Type: VIEW; Schema: votacion; Owner: postgres
--

CREATE VIEW d_programacion_v2 AS
    SELECT d.id_d_programacion, p.descripcion, s.nom_sede, pl.nom_plancha, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip) AS "coalesce", d.id_programa, d.id_sede, d.id_plancha, d.id_candidato FROM d_programacion d, programacion p, sedes s, planchas pl, xcomun.nuips n WHERE ((((d.id_sede = s.id_sede) AND (d.id_plancha = pl.id_plancha)) AND (d.id_candidato = n.id_nuip)) AND (d.id_programa = p.id_programa));


ALTER TABLE votacion.d_programacion_v2 OWNER TO postgres;

SET default_with_oids = false;

--
-- TOC entry 1604 (class 1259 OID 27575)
-- Dependencies: 8
-- Name: encuestados; Type: TABLE; Schema: votacion; Owner: postgres; Tablespace: 
--

CREATE TABLE encuestados (
    id_nuip bigint NOT NULL
);


ALTER TABLE votacion.encuestados OWNER TO postgres;

SET default_with_oids = true;

--
-- TOC entry 1605 (class 1259 OID 27578)
-- Dependencies: 8
-- Name: encuestas; Type: TABLE; Schema: votacion; Owner: dbxdba; Tablespace: 
--

CREATE TABLE encuestas (
    id_encuesta bigint NOT NULL,
    id_pregunta bigint NOT NULL,
    pregunta text NOT NULL
);


ALTER TABLE votacion.encuestas OWNER TO dbxdba;

--
-- TOC entry 1606 (class 1259 OID 27584)
-- Dependencies: 8
-- Name: encuestas_id_encuesta_seq; Type: SEQUENCE; Schema: votacion; Owner: postgres
--

CREATE SEQUENCE encuestas_id_encuesta_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.encuestas_id_encuesta_seq OWNER TO postgres;

--
-- TOC entry 1607 (class 1259 OID 27586)
-- Dependencies: 8 1605
-- Name: encuestas_id_encuesta_seq1; Type: SEQUENCE; Schema: votacion; Owner: dbxdba
--

CREATE SEQUENCE encuestas_id_encuesta_seq1
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.encuestas_id_encuesta_seq1 OWNER TO dbxdba;

--
-- TOC entry 1986 (class 0 OID 0)
-- Dependencies: 1607
-- Name: encuestas_id_encuesta_seq1; Type: SEQUENCE OWNED BY; Schema: votacion; Owner: dbxdba
--

ALTER SEQUENCE encuestas_id_encuesta_seq1 OWNED BY encuestas.id_encuesta;


--
-- TOC entry 1608 (class 1259 OID 27588)
-- Dependencies: 8
-- Name: fondomutual; Type: TABLE; Schema: votacion; Owner: postgres; Tablespace: 
--

CREATE TABLE fondomutual (
    cedula character(20) NOT NULL,
    pregunta1 character(25),
    pregunta2 character(25),
    "timestamp" timestamp without time zone
);


ALTER TABLE votacion.fondomutual OWNER TO postgres;

--
-- TOC entry 1609 (class 1259 OID 27591)
-- Dependencies: 8
-- Name: planchas_id_plancha_seq; Type: SEQUENCE; Schema: votacion; Owner: postgres
--

CREATE SEQUENCE planchas_id_plancha_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.planchas_id_plancha_seq OWNER TO postgres;

--
-- TOC entry 1610 (class 1259 OID 27593)
-- Dependencies: 8 1592
-- Name: planchas_id_plancha_seq1; Type: SEQUENCE; Schema: votacion; Owner: dbxdba
--

CREATE SEQUENCE planchas_id_plancha_seq1
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.planchas_id_plancha_seq1 OWNER TO dbxdba;

--
-- TOC entry 1988 (class 0 OID 0)
-- Dependencies: 1610
-- Name: planchas_id_plancha_seq1; Type: SEQUENCE OWNED BY; Schema: votacion; Owner: dbxdba
--

ALTER SEQUENCE planchas_id_plancha_seq1 OWNED BY planchas.id_plancha;


--
-- TOC entry 1611 (class 1259 OID 27595)
-- Dependencies: 8
-- Name: programacion_id_programa_seq; Type: SEQUENCE; Schema: votacion; Owner: postgres
--

CREATE SEQUENCE programacion_id_programa_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.programacion_id_programa_seq OWNER TO postgres;

--
-- TOC entry 1612 (class 1259 OID 27597)
-- Dependencies: 8 1599
-- Name: programacion_id_programa_seq1; Type: SEQUENCE; Schema: votacion; Owner: dbxdba
--

CREATE SEQUENCE programacion_id_programa_seq1
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.programacion_id_programa_seq1 OWNER TO dbxdba;

--
-- TOC entry 1989 (class 0 OID 0)
-- Dependencies: 1612
-- Name: programacion_id_programa_seq1; Type: SEQUENCE OWNED BY; Schema: votacion; Owner: dbxdba
--

ALTER SEQUENCE programacion_id_programa_seq1 OWNED BY programacion.id_programa;


--
-- TOC entry 1613 (class 1259 OID 27599)
-- Dependencies: 8
-- Name: respuestas; Type: TABLE; Schema: votacion; Owner: dbxdba; Tablespace: 
--

CREATE TABLE respuestas (
    id_respuesta bigint NOT NULL,
    id_encuesta bigint NOT NULL,
    id_pregunta bigint NOT NULL,
    respuesta text NOT NULL
);


ALTER TABLE votacion.respuestas OWNER TO dbxdba;

--
-- TOC entry 1614 (class 1259 OID 27605)
-- Dependencies: 8 1613
-- Name: respuestas_id_respuesta_seq1; Type: SEQUENCE; Schema: votacion; Owner: dbxdba
--

CREATE SEQUENCE respuestas_id_respuesta_seq1
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.respuestas_id_respuesta_seq1 OWNER TO dbxdba;

--
-- TOC entry 1991 (class 0 OID 0)
-- Dependencies: 1614
-- Name: respuestas_id_respuesta_seq1; Type: SEQUENCE OWNED BY; Schema: votacion; Owner: dbxdba
--

ALTER SEQUENCE respuestas_id_respuesta_seq1 OWNED BY respuestas.id_respuesta;


SET default_with_oids = false;

--
-- TOC entry 1615 (class 1259 OID 27607)
-- Dependencies: 8
-- Name: respuestas_txt; Type: TABLE; Schema: votacion; Owner: postgres; Tablespace: 
--

CREATE TABLE respuestas_txt (
    id_respuesta bigint NOT NULL,
    pregunta text,
    respuesta text,
    sede text
);


ALTER TABLE votacion.respuestas_txt OWNER TO postgres;

--
-- TOC entry 1616 (class 1259 OID 27613)
-- Dependencies: 8 1615
-- Name: respuestas_txt_id_respuesta_seq; Type: SEQUENCE; Schema: votacion; Owner: postgres
--

CREATE SEQUENCE respuestas_txt_id_respuesta_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.respuestas_txt_id_respuesta_seq OWNER TO postgres;

--
-- TOC entry 1993 (class 0 OID 0)
-- Dependencies: 1616
-- Name: respuestas_txt_id_respuesta_seq; Type: SEQUENCE OWNED BY; Schema: votacion; Owner: postgres
--

ALTER SEQUENCE respuestas_txt_id_respuesta_seq OWNED BY respuestas_txt.id_respuesta;


--
-- TOC entry 1617 (class 1259 OID 27615)
-- Dependencies: 8
-- Name: respuestas_txt_piloto; Type: TABLE; Schema: votacion; Owner: postgres; Tablespace: 
--

CREATE TABLE respuestas_txt_piloto (
    id_respuesta bigint,
    pregunta text,
    respuesta text,
    sede integer
);


ALTER TABLE votacion.respuestas_txt_piloto OWNER TO postgres;

--
-- TOC entry 1618 (class 1259 OID 27621)
-- Dependencies: 8
-- Name: sedes_id_sede_seq; Type: SEQUENCE; Schema: votacion; Owner: postgres
--

CREATE SEQUENCE sedes_id_sede_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.sedes_id_sede_seq OWNER TO postgres;

--
-- TOC entry 1619 (class 1259 OID 27623)
-- Dependencies: 8 1600
-- Name: sedes_id_sede_seq1; Type: SEQUENCE; Schema: votacion; Owner: dbxdba
--

CREATE SEQUENCE sedes_id_sede_seq1
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.sedes_id_sede_seq1 OWNER TO dbxdba;

--
-- TOC entry 1995 (class 0 OID 0)
-- Dependencies: 1619
-- Name: sedes_id_sede_seq1; Type: SEQUENCE OWNED BY; Schema: votacion; Owner: dbxdba
--

ALTER SEQUENCE sedes_id_sede_seq1 OWNED BY sedes.id_sede;


--
-- TOC entry 1620 (class 1259 OID 27625)
-- Dependencies: 8
-- Name: votacion_id_votacion_seq; Type: SEQUENCE; Schema: votacion; Owner: postgres
--

CREATE SEQUENCE votacion_id_votacion_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.votacion_id_votacion_seq OWNER TO postgres;

--
-- TOC entry 1621 (class 1259 OID 27627)
-- Dependencies: 8 1593
-- Name: votacion_id_votacion_seq1; Type: SEQUENCE; Schema: votacion; Owner: dbxdba
--

CREATE SEQUENCE votacion_id_votacion_seq1
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.votacion_id_votacion_seq1 OWNER TO dbxdba;

--
-- TOC entry 1996 (class 0 OID 0)
-- Dependencies: 1621
-- Name: votacion_id_votacion_seq1; Type: SEQUENCE OWNED BY; Schema: votacion; Owner: dbxdba
--

ALTER SEQUENCE votacion_id_votacion_seq1 OWNED BY votacion.id_votacion;


SET default_with_oids = true;

--
-- TOC entry 1622 (class 1259 OID 27629)
-- Dependencies: 8
-- Name: votos; Type: TABLE; Schema: votacion; Owner: dbxdba; Tablespace: 
--

CREATE TABLE votos (
    id_nuip bigint NOT NULL,
    nombres text,
    apellidos text,
    cod_alpina bigint,
    cod_sede character varying
);


ALTER TABLE votacion.votos OWNER TO dbxdba;

--
-- TOC entry 1623 (class 1259 OID 27635)
-- Dependencies: 1731 8
-- Name: votantes_sedes_v1; Type: VIEW; Schema: votacion; Owner: postgres
--

CREATE VIEW votantes_sedes_v1 AS
    SELECT s.nom_sede, v.nombres, v.id_nuip, v.cod_alpina FROM votos v, sedes s WHERE ((v.cod_sede)::text = s.desc_sede);


ALTER TABLE votacion.votantes_sedes_v1 OWNER TO postgres;

--
-- TOC entry 1624 (class 1259 OID 27639)
-- Dependencies: 1594 8
-- Name: zonas_votacion_id_zona_seq; Type: SEQUENCE; Schema: votacion; Owner: postgres
--

CREATE SEQUENCE zonas_votacion_id_zona_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE votacion.zonas_votacion_id_zona_seq OWNER TO postgres;

--
-- TOC entry 1998 (class 0 OID 0)
-- Dependencies: 1624
-- Name: zonas_votacion_id_zona_seq; Type: SEQUENCE OWNED BY; Schema: votacion; Owner: postgres
--

ALTER SEQUENCE zonas_votacion_id_zona_seq OWNED BY zonas_votacion.id_zona;


--
-- TOC entry 1928 (class 2604 OID 27705)
-- Dependencies: 1598 1596
-- Name: id_d_programacion; Type: DEFAULT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE d_programacion ALTER COLUMN id_d_programacion SET DEFAULT nextval('d_programacion_id_d_programacion_seq1'::regclass);


--
-- TOC entry 1933 (class 2604 OID 27706)
-- Dependencies: 1607 1605
-- Name: id_encuesta; Type: DEFAULT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE encuestas ALTER COLUMN id_encuesta SET DEFAULT nextval('encuestas_id_encuesta_seq1'::regclass);


--
-- TOC entry 1924 (class 2604 OID 27707)
-- Dependencies: 1610 1592
-- Name: id_plancha; Type: DEFAULT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE planchas ALTER COLUMN id_plancha SET DEFAULT nextval('planchas_id_plancha_seq1'::regclass);


--
-- TOC entry 1931 (class 2604 OID 27708)
-- Dependencies: 1612 1599
-- Name: id_programa; Type: DEFAULT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE programacion ALTER COLUMN id_programa SET DEFAULT nextval('programacion_id_programa_seq1'::regclass);


--
-- TOC entry 1934 (class 2604 OID 27709)
-- Dependencies: 1614 1613
-- Name: id_respuesta; Type: DEFAULT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE respuestas ALTER COLUMN id_respuesta SET DEFAULT nextval('respuestas_id_respuesta_seq1'::regclass);


--
-- TOC entry 1935 (class 2604 OID 27710)
-- Dependencies: 1616 1615
-- Name: id_respuesta; Type: DEFAULT; Schema: votacion; Owner: postgres
--

ALTER TABLE respuestas_txt ALTER COLUMN id_respuesta SET DEFAULT nextval('respuestas_txt_id_respuesta_seq'::regclass);


--
-- TOC entry 1932 (class 2604 OID 27711)
-- Dependencies: 1619 1600
-- Name: id_sede; Type: DEFAULT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE sedes ALTER COLUMN id_sede SET DEFAULT nextval('sedes_id_sede_seq1'::regclass);


--
-- TOC entry 1926 (class 2604 OID 27712)
-- Dependencies: 1621 1593
-- Name: id_votacion; Type: DEFAULT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE votacion ALTER COLUMN id_votacion SET DEFAULT nextval('votacion_id_votacion_seq1'::regclass);


--
-- TOC entry 1927 (class 2604 OID 27713)
-- Dependencies: 1624 1594
-- Name: id_zona; Type: DEFAULT; Schema: votacion; Owner: postgres
--

ALTER TABLE zonas_votacion ALTER COLUMN id_zona SET DEFAULT nextval('zonas_votacion_id_zona_seq'::regclass);


--
-- TOC entry 1957 (class 2606 OID 28210)
-- Dependencies: 1608 1608
-- Name: IndicePrimario; Type: CONSTRAINT; Schema: votacion; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY fondomutual
    ADD CONSTRAINT "IndicePrimario" PRIMARY KEY (cedula);


--
-- TOC entry 1952 (class 2606 OID 28212)
-- Dependencies: 1604 1604
-- Name: encuestados_pkey; Type: CONSTRAINT; Schema: votacion; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY encuestados
    ADD CONSTRAINT encuestados_pkey PRIMARY KEY (id_nuip);


--
-- TOC entry 1946 (class 2606 OID 28214)
-- Dependencies: 1596 1596
-- Name: pk_d_programacion; Type: CONSTRAINT; Schema: votacion; Owner: dbxdba; Tablespace: 
--

ALTER TABLE ONLY d_programacion
    ADD CONSTRAINT pk_d_programacion PRIMARY KEY (id_d_programacion);


--
-- TOC entry 1955 (class 2606 OID 28216)
-- Dependencies: 1605 1605
-- Name: pk_encuestas; Type: CONSTRAINT; Schema: votacion; Owner: dbxdba; Tablespace: 
--

ALTER TABLE ONLY encuestas
    ADD CONSTRAINT pk_encuestas PRIMARY KEY (id_encuesta);


--
-- TOC entry 1937 (class 2606 OID 28218)
-- Dependencies: 1592 1592
-- Name: planchas_nom_plancha_key; Type: CONSTRAINT; Schema: votacion; Owner: dbxdba; Tablespace: 
--

ALTER TABLE ONLY planchas
    ADD CONSTRAINT planchas_nom_plancha_key UNIQUE (nom_plancha);


--
-- TOC entry 1939 (class 2606 OID 28220)
-- Dependencies: 1592 1592
-- Name: planchas_pkey; Type: CONSTRAINT; Schema: votacion; Owner: dbxdba; Tablespace: 
--

ALTER TABLE ONLY planchas
    ADD CONSTRAINT planchas_pkey PRIMARY KEY (id_plancha);


--
-- TOC entry 1948 (class 2606 OID 28222)
-- Dependencies: 1599 1599
-- Name: programacion_pkey; Type: CONSTRAINT; Schema: votacion; Owner: dbxdba; Tablespace: 
--

ALTER TABLE ONLY programacion
    ADD CONSTRAINT programacion_pkey PRIMARY KEY (id_programa);


--
-- TOC entry 1959 (class 2606 OID 28224)
-- Dependencies: 1613 1613
-- Name: respuestas_pkey; Type: CONSTRAINT; Schema: votacion; Owner: dbxdba; Tablespace: 
--

ALTER TABLE ONLY respuestas
    ADD CONSTRAINT respuestas_pkey PRIMARY KEY (id_respuesta);


--
-- TOC entry 1961 (class 2606 OID 28226)
-- Dependencies: 1615 1615
-- Name: respuestas_txt_pkey; Type: CONSTRAINT; Schema: votacion; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY respuestas_txt
    ADD CONSTRAINT respuestas_txt_pkey PRIMARY KEY (id_respuesta);


--
-- TOC entry 1950 (class 2606 OID 28228)
-- Dependencies: 1600 1600
-- Name: sedes_pkey; Type: CONSTRAINT; Schema: votacion; Owner: dbxdba; Tablespace: 
--

ALTER TABLE ONLY sedes
    ADD CONSTRAINT sedes_pkey PRIMARY KEY (id_sede);


--
-- TOC entry 1941 (class 2606 OID 28230)
-- Dependencies: 1593 1593
-- Name: votacion_pkey; Type: CONSTRAINT; Schema: votacion; Owner: dbxdba; Tablespace: 
--

ALTER TABLE ONLY votacion
    ADD CONSTRAINT votacion_pkey PRIMARY KEY (id_votacion);


--
-- TOC entry 1963 (class 2606 OID 28232)
-- Dependencies: 1622 1622
-- Name: votos_cod_alpina_key; Type: CONSTRAINT; Schema: votacion; Owner: dbxdba; Tablespace: 
--

ALTER TABLE ONLY votos
    ADD CONSTRAINT votos_cod_alpina_key UNIQUE (cod_alpina);


--
-- TOC entry 1965 (class 2606 OID 28234)
-- Dependencies: 1622 1622
-- Name: votos_pkey; Type: CONSTRAINT; Schema: votacion; Owner: dbxdba; Tablespace: 
--

ALTER TABLE ONLY votos
    ADD CONSTRAINT votos_pkey PRIMARY KEY (id_nuip);


--
-- TOC entry 1943 (class 2606 OID 28236)
-- Dependencies: 1594 1594
-- Name: zonas_votacion_pkey; Type: CONSTRAINT; Schema: votacion; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY zonas_votacion
    ADD CONSTRAINT zonas_votacion_pkey PRIMARY KEY (id_zona);


--
-- TOC entry 1953 (class 1259 OID 28259)
-- Dependencies: 1605 1605
-- Name: cu_encuesta_pregunta; Type: INDEX; Schema: votacion; Owner: dbxdba; Tablespace: 
--

CREATE UNIQUE INDEX cu_encuesta_pregunta ON encuestas USING btree (id_encuesta, id_pregunta);


--
-- TOC entry 1944 (class 1259 OID 28260)
-- Dependencies: 1596 1596
-- Name: cu_id_candidato; Type: INDEX; Schema: votacion; Owner: dbxdba; Tablespace: 
--

CREATE UNIQUE INDEX cu_id_candidato ON d_programacion USING btree (id_candidato, id_programa);


--
-- TOC entry 1970 (class 2606 OID 28263)
-- Dependencies: 1601 1596
-- Name: fk_id_candidato; Type: FK CONSTRAINT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE ONLY d_programacion
    ADD CONSTRAINT fk_id_candidato FOREIGN KEY (id_candidato) REFERENCES xcomun.nuips(id_nuip);


--
-- TOC entry 1967 (class 2606 OID 28268)
-- Dependencies: 1593 1601
-- Name: fk_id_candidato; Type: FK CONSTRAINT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE ONLY votacion
    ADD CONSTRAINT fk_id_candidato FOREIGN KEY (id_candidato) REFERENCES xcomun.nuips(id_nuip);


--
-- TOC entry 1974 (class 2606 OID 28273)
-- Dependencies: 1605 1613 1613 1953 1605
-- Name: fk_id_encuesta_id_pregunta; Type: FK CONSTRAINT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE ONLY respuestas
    ADD CONSTRAINT fk_id_encuesta_id_pregunta FOREIGN KEY (id_encuesta, id_pregunta) REFERENCES encuestas(id_encuesta, id_pregunta);


--
-- TOC entry 1971 (class 2606 OID 28278)
-- Dependencies: 1592 1596 1938
-- Name: fk_id_plancha; Type: FK CONSTRAINT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE ONLY d_programacion
    ADD CONSTRAINT fk_id_plancha FOREIGN KEY (id_plancha) REFERENCES planchas(id_plancha);


--
-- TOC entry 1968 (class 2606 OID 28283)
-- Dependencies: 1938 1593 1592
-- Name: fk_id_plancha; Type: FK CONSTRAINT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE ONLY votacion
    ADD CONSTRAINT fk_id_plancha FOREIGN KEY (id_plancha) REFERENCES planchas(id_plancha);


--
-- TOC entry 1972 (class 2606 OID 28288)
-- Dependencies: 1596 1599 1947
-- Name: fk_id_programa; Type: FK CONSTRAINT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE ONLY d_programacion
    ADD CONSTRAINT fk_id_programa FOREIGN KEY (id_programa) REFERENCES programacion(id_programa);


--
-- TOC entry 1969 (class 2606 OID 28293)
-- Dependencies: 1947 1593 1599
-- Name: fk_id_programa; Type: FK CONSTRAINT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE ONLY votacion
    ADD CONSTRAINT fk_id_programa FOREIGN KEY (id_programa) REFERENCES programacion(id_programa);


--
-- TOC entry 1973 (class 2606 OID 28298)
-- Dependencies: 1949 1600 1596
-- Name: fk_id_sede; Type: FK CONSTRAINT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE ONLY d_programacion
    ADD CONSTRAINT fk_id_sede FOREIGN KEY (id_sede) REFERENCES sedes(id_sede);


--
-- TOC entry 1966 (class 2606 OID 28303)
-- Dependencies: 1592 1594 1942
-- Name: planchas_id_zona_fkey; Type: FK CONSTRAINT; Schema: votacion; Owner: dbxdba
--

ALTER TABLE ONLY planchas
    ADD CONSTRAINT planchas_id_zona_fkey FOREIGN KEY (id_zona) REFERENCES zonas_votacion(id_zona);


--
-- TOC entry 1977 (class 0 OID 0)
-- Dependencies: 8
-- Name: votacion; Type: ACL; Schema: -; Owner: dbxdba
--

REVOKE ALL ON SCHEMA votacion FROM PUBLIC;
REVOKE ALL ON SCHEMA votacion FROM dbxdba;
GRANT ALL ON SCHEMA votacion TO dbxdba;
GRANT ALL ON SCHEMA votacion TO admin;
GRANT USAGE ON SCHEMA votacion TO lectores;


--
-- TOC entry 1978 (class 0 OID 0)
-- Dependencies: 1592
-- Name: planchas; Type: ACL; Schema: votacion; Owner: dbxdba
--

REVOKE ALL ON TABLE planchas FROM PUBLIC;
REVOKE ALL ON TABLE planchas FROM dbxdba;
GRANT ALL ON TABLE planchas TO dbxdba;
GRANT ALL ON TABLE planchas TO admin;
GRANT SELECT,REFERENCES,TRIGGER ON TABLE planchas TO lectores;
GRANT ALL ON TABLE planchas TO PUBLIC;


--
-- TOC entry 1979 (class 0 OID 0)
-- Dependencies: 1593
-- Name: votacion; Type: ACL; Schema: votacion; Owner: dbxdba
--

REVOKE ALL ON TABLE votacion FROM PUBLIC;
REVOKE ALL ON TABLE votacion FROM dbxdba;
GRANT ALL ON TABLE votacion TO dbxdba;
GRANT ALL ON TABLE votacion TO admin;
GRANT SELECT,REFERENCES,TRIGGER ON TABLE votacion TO lectores;
GRANT ALL ON TABLE votacion TO PUBLIC;


--
-- TOC entry 1980 (class 0 OID 0)
-- Dependencies: 1596
-- Name: d_programacion; Type: ACL; Schema: votacion; Owner: dbxdba
--

REVOKE ALL ON TABLE d_programacion FROM PUBLIC;
REVOKE ALL ON TABLE d_programacion FROM dbxdba;
GRANT ALL ON TABLE d_programacion TO dbxdba;
GRANT ALL ON TABLE d_programacion TO admin;
GRANT SELECT,REFERENCES,TRIGGER ON TABLE d_programacion TO lectores;
GRANT ALL ON TABLE d_programacion TO PUBLIC;


--
-- TOC entry 1982 (class 0 OID 0)
-- Dependencies: 1599
-- Name: programacion; Type: ACL; Schema: votacion; Owner: dbxdba
--

REVOKE ALL ON TABLE programacion FROM PUBLIC;
REVOKE ALL ON TABLE programacion FROM dbxdba;
GRANT ALL ON TABLE programacion TO dbxdba;
GRANT ALL ON TABLE programacion TO admin;
GRANT SELECT,REFERENCES,TRIGGER ON TABLE programacion TO lectores;
GRANT ALL ON TABLE programacion TO PUBLIC;


--
-- TOC entry 1983 (class 0 OID 0)
-- Dependencies: 1600
-- Name: sedes; Type: ACL; Schema: votacion; Owner: dbxdba
--

REVOKE ALL ON TABLE sedes FROM PUBLIC;
REVOKE ALL ON TABLE sedes FROM dbxdba;
GRANT ALL ON TABLE sedes TO dbxdba;
GRANT ALL ON TABLE sedes TO admin;
GRANT SELECT,REFERENCES,TRIGGER ON TABLE sedes TO lectores;
GRANT ALL ON TABLE sedes TO PUBLIC;


--
-- TOC entry 1984 (class 0 OID 0)
-- Dependencies: 1604
-- Name: encuestados; Type: ACL; Schema: votacion; Owner: postgres
--

REVOKE ALL ON TABLE encuestados FROM PUBLIC;
REVOKE ALL ON TABLE encuestados FROM postgres;
GRANT ALL ON TABLE encuestados TO postgres;
GRANT ALL ON TABLE encuestados TO PUBLIC;
GRANT ALL ON TABLE encuestados TO admin;


--
-- TOC entry 1985 (class 0 OID 0)
-- Dependencies: 1605
-- Name: encuestas; Type: ACL; Schema: votacion; Owner: dbxdba
--

REVOKE ALL ON TABLE encuestas FROM PUBLIC;
REVOKE ALL ON TABLE encuestas FROM dbxdba;
GRANT ALL ON TABLE encuestas TO dbxdba;
GRANT ALL ON TABLE encuestas TO admin;
GRANT SELECT,REFERENCES,TRIGGER ON TABLE encuestas TO lectores;
GRANT ALL ON TABLE encuestas TO PUBLIC;


--
-- TOC entry 1987 (class 0 OID 0)
-- Dependencies: 1608
-- Name: fondomutual; Type: ACL; Schema: votacion; Owner: postgres
--

REVOKE ALL ON TABLE fondomutual FROM PUBLIC;
REVOKE ALL ON TABLE fondomutual FROM postgres;
GRANT ALL ON TABLE fondomutual TO postgres;
GRANT ALL ON TABLE fondomutual TO PUBLIC;


--
-- TOC entry 1990 (class 0 OID 0)
-- Dependencies: 1613
-- Name: respuestas; Type: ACL; Schema: votacion; Owner: dbxdba
--

REVOKE ALL ON TABLE respuestas FROM PUBLIC;
REVOKE ALL ON TABLE respuestas FROM dbxdba;
GRANT ALL ON TABLE respuestas TO dbxdba;
GRANT ALL ON TABLE respuestas TO admin;
GRANT SELECT,REFERENCES,TRIGGER ON TABLE respuestas TO lectores;
GRANT ALL ON TABLE respuestas TO PUBLIC;


--
-- TOC entry 1992 (class 0 OID 0)
-- Dependencies: 1615
-- Name: respuestas_txt; Type: ACL; Schema: votacion; Owner: postgres
--

REVOKE ALL ON TABLE respuestas_txt FROM PUBLIC;
REVOKE ALL ON TABLE respuestas_txt FROM postgres;
GRANT ALL ON TABLE respuestas_txt TO postgres;
GRANT ALL ON TABLE respuestas_txt TO PUBLIC;
GRANT ALL ON TABLE respuestas_txt TO admin;


--
-- TOC entry 1994 (class 0 OID 0)
-- Dependencies: 1617
-- Name: respuestas_txt_piloto; Type: ACL; Schema: votacion; Owner: postgres
--

REVOKE ALL ON TABLE respuestas_txt_piloto FROM PUBLIC;
REVOKE ALL ON TABLE respuestas_txt_piloto FROM postgres;
GRANT ALL ON TABLE respuestas_txt_piloto TO postgres;
GRANT ALL ON TABLE respuestas_txt_piloto TO PUBLIC;
GRANT ALL ON TABLE respuestas_txt_piloto TO admin;


--
-- TOC entry 1997 (class 0 OID 0)
-- Dependencies: 1622
-- Name: votos; Type: ACL; Schema: votacion; Owner: dbxdba
--

REVOKE ALL ON TABLE votos FROM PUBLIC;
REVOKE ALL ON TABLE votos FROM dbxdba;
GRANT ALL ON TABLE votos TO dbxdba;
GRANT ALL ON TABLE votos TO admin;
GRANT SELECT,REFERENCES,TRIGGER ON TABLE votos TO lectores;
GRANT ALL ON TABLE votos TO PUBLIC;


-- Completed on 2010-12-20 08:46:53 COT

--
-- PostgreSQL database dump complete
--

