-- vot_censo_electoral_v1

DROP VIEW vot_censo_electoral_v1;

CREATE VIEW vot_censo_electoral_v1 AS
 SELECT ce.fec_tx::DATE AS fec_tx
	, to_char(ce.fec_tx::TIME, 'HH12:MI:SS am') AS hor_tx
    , COALESCE((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || n.digito_verif::text, to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip
    , COALESCE((n.nom_nuip || ' '::text) || n.ape_nuip, n.nom_nuip, n.ape_nuip) AS maq_nom_nuip
    , n.nom_empresa
   FROM vot_censo_electoral ce, public.xcm_nuips n
  WHERE ce.id_nuip = n.id_nuip ;

ALTER TABLE vot_censo_electoral_v1 OWNER TO dbxdba;
