<?php
session_name($_POST["sidname"]);
session_start();

if(count($_SESSION) == 0) {
	header('Location: ../includes/salida_segura.php');
	echo "
		<script type='text/javascript'>
			alert('Sesion expirada, por favor vuelva a ingresar.');
			window.location.replace('../');
		</script>
	";
	exit(0);
}
else {
	include_once($_SERVER['DOCUMENT_ROOT'].$_SESSION["cnf"]["install_path"]."/config/config.inc.php"); // ** NUEVO
	include_once("main_fx.php");

	if(isset($_POST["funcion"])) {
		switch($_POST["funcion"]) {
			case 'limpiaCenso': {
				flimpiaCenso();
			} break;
			case 'clonarVotacion': {
				fclonarVotacion($_POST['idv'], $_POST['nomv']);
			} break;
		}
	}
}

////////////////////////////////////////////////////////////////////////
function fclonarVotacion($idV, $nomV) {
	if(trim($idV) == '' ) { $idV = "NULL"; } else { $idV = "'{$idV}'"; }
	if(trim($nomV) == '' ) { $nomV = "NULL"; } else { $nomV = "'{$nomV}'"; }

	global $cnf;
	$error = "";
	$aborto_proc = false;
	$sdata = Array();

	if($idV == "NULL" OR $nomV == "NULL") {
		$aborto_proc = true;
		$error = "Faltan Datos";
	}

	if($aborto_proc == false) {
		$conn  = conectar_db("",true);
		$sql = "BEGIN; ";
		{ // Leyendo Votacion
				$sql .= repare_ADOdbSQL(
					sql_utilidades('consultar_votacion')
					, Array($idV)
					, true
				);
				$err_txt = "Consultar";

			$resultado = query_db($sql, true);
			$data = fetch_array_db($resultado);
			if (query_estado("err_msg", true) != "") {
				$error = "No se pudo {$err_txt} la votaci&oacute;n. ";
				$aborto_proc = true;
				$sqlE = $sql;
			}
		}

		if($aborto_proc == false){ // Insercion de la Copia de Votacion
			$sql = repare_ADOdbSQL(
				sql_utilidades('insertar_votacion')
				, Array($nomV, $data[1], $data[2], $data[3], $data[4], $data[5] )
				, true
			);
			$err_txt = "Insertar";
			$resultado = query_db($sql, true);
			$data = fetch_array_db($resultado);
			if (query_estado("err_msg", true) != "") {
				$error = "No se pudo {$err_txt} la votaci&oacute;n. ";
				$aborto_proc = true;
				$sqlE = $sql;
			}
			else {
				$nuevo_id_votacion = $data[0];
			}
		}

		if($aborto_proc == false){ // Insercion de los Candidatos
			$sql = repare_ADOdbSQL(
				sql_utilidades('insertar_candidatos')
				, Array($nuevo_id_votacion, $idV )
				, true
			);
			$err_txt = "Insertar";

			$resultado = query_db($sql, true);
			if (query_estado("err_msg", true) != "") {
				$error = "No se pudo {$err_txt} los Candidatos. ";
				$aborto_proc = true;
				$sqlE = $sql;
			}
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sqlE;
		}
		else {
			$sdata['data'] = $data;
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}

	$sdata['success'] = !$aborto_proc;
	$sdata = json_encode(($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

////////////////////////////////////////////////////////////////////////
function flimpiaCenso() {
	global $cnf;
	$error = "";
	$aborto_proc = false;
	$sdata = Array();

	if($aborto_proc == false) {
		$conn  = conectar_db("",true);
		$sql = "BEGIN; ";
		{ // Limpiando Censo
				$sql .= repare_ADOdbSQL(
					sql_utilidades('limpiar_censo_electoral')
					, Array()
					, true
				);
				$err_txt = "Limpiar";

			$resultado = query_db($sql, true);
			if (query_estado("err_msg", true) != "") {
				$error = "No se pudo {$err_txt} al censo electoral. ";
				$aborto_proc = true;
				$sqlE = $sql;
			}
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sqlE;
		}
		else {
			$sdata['data'] = $data;
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}

	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}

?>
