
CREATE OR REPLACE VIEW vot_candidatos_v3 AS
 SELECT c.id_candidato_plancha
	, c.id_nuip_candidato
	, c.orden
	, c.tipo_candidato
	, c.id_plancha
	, CASE WHEN c.tipo_candidato=1 THEN 'Principal' ELSE 'Suplente' END AS maq_tipo_candidato
	, COALESCE((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || n.digito_verif::text, to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip
	, COALESCE((n.nom_nuip || ' '::text) || n.ape_nuip, n.nom_nuip, n.ape_nuip) AS maq_nom_nuip
   FROM vot_candidatos_plancha c, xcm_nuips n
  WHERE c.id_nuip_candidato = n.id_nuip;

COMMENT ON VIEW vot_candidatos_v3 IS 'v.20110316.1';
