<?php
session_name($_POST["sidname"]);
session_start();
if(count($_SESSION) == 0) {
	header('Location: ../includes/salida_segura.php');
	header("Content-Type: application/x-javascript; charset=utf-8");
	echo "<script type='text/javascript'>
			alert('Sesion expirada, por favor vuelva a ingresar.');
			window.location.replace('../');
		</script>";
	exit(0);
}
else {
	include_once($_SERVER['DOCUMENT_ROOT'].$_SESSION["cnf"]["install_path"]."/config/config.inc.php"); // ** NUEVO
	include_once("main_fx.php");

	if(isset($_POST["funcion"]) ){
		switch($_POST["funcion"]){
			case 'addPlancha': {
				faddPlancha($_POST['p1'], $_POST['p2'], $_POST['p3'], $_POST['p4']);
			} break;
			case 'addCandidato': {
				faddCandidato($_POST['p1'], $_POST['p2'], $_POST['p3'], $_POST['p4'], $_POST['p5']);
			} break;
			case 'delCandidato': {
				fdelCandidato($_POST['idR']);
			} break;
			case 'datavotacion': {
				fdatavotacion($_POST['p1']);
			} break;
			case 'cambiaPosCandidato':{
				fcambiaPosCandidato($_POST['pN'], $_POST['pV'], $_POST['pO'], $_POST['pON']);
			} break;
		}
	}
}

////////////////////////////////////////////////////////////////////////
function faddPlancha($idPlancha, $id_votacion, $nom_plancha, $desc_plancha) {
	if(trim($id_votacion) == '') { $id_votacion = "NULL"; } else { $id_votacion = "'{$id_votacion}'"; }
	if(trim($idPlancha) == '') { $idPlancha = "NULL"; } else { $idPlancha = "'{$idPlancha}'"; }
	if(trim($nom_plancha) == '') { $nom_plancha = "NULL"; } else { $nom_plancha = "'{$nom_plancha}'"; }
	if(trim($desc_plancha) == '') { $desc_plancha = "NULL"; } else { $desc_plancha = "'{$desc_plancha}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($id_votacion == 'NULL' OR $nom_plancha == 'NULL' ) {
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	if($aborto_proc == false) {
		$conn  = conectar_db("",true);

		$sql = "BEGIN; ";
		if($aborto_proc == false) {
			if($idPlancha == 'NULL') {
				$sql .= repare_ADOdbSQL(
						sql_planchas('insertar_plancha')
						, Array( $nom_plancha, $desc_plancha, $id_votacion )
						, true
					);
				$err_txt = "Insertar";
			}
			else {
				$sql .= repare_ADOdbSQL(
						sql_planchas('actualizar_plancha')
						, Array( $nom_plancha, $desc_plancha, $id_votacion, $idPlancha, $idPlancha )
						, true
					);
				$err_txt = "Actualizar";
			}
			$resultado = query_db($sql, true);
			$arrau = fetch_array_db($resultado);
			if (query_estado("err_msg", true) != "") {
			  $error = "No se pudo {$err_txt} la Plancha.";
			  $aborto_proc = true;
			}
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			$sdata['data'] = Array( $arrau );
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}
////////////////////////////////////////////////////////////////////////
function faddCandidato($id_votacion, $id_nuip, $tc, $orden, $idPlancha) {
	if(trim($id_votacion) == '') { $id_votacion = "NULL"; } else { $id_votacion = "'{$id_votacion}'"; }
	if(trim($idPlancha) == '') { $idPlancha = "NULL"; } else { $idPlancha = "'{$idPlancha}'"; }
	if(trim($id_nuip) == '') { $id_nuip = "NULL"; } else { $id_nuip = "'{$id_nuip}'"; }
	if(trim($tc) == '') { $tc = "1"; } else { $tc = "{$tc}"; }
	if(trim($orden) == '') { $orden = "0"; } else { $orden = "'{$orden}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($idPlancha == 'NULL' OR $id_nuip == 'NULL' ) {
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	if($aborto_proc == false) {
		$conn  = conectar_db("",true);

		$sql = "BEGIN; ";
		if($aborto_proc == false) {
			$sql .= repare_ADOdbSQL(
						sql_planchas('insertar_candidato')
						, Array( $idPlancha, $id_nuip, $orden, $tc )
						, true
					);
			$err_txt = "Insertar";
			$resultado = query_db($sql, true);
			$arrau = fetch_array_db($resultado);
			if (query_estado("err_msg", true) != "") {
			  $error = "No se pudo {$err_txt} el Candidato.<br/>El candidato puede estar repetido";
			  $aborto_proc = true;
			}
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			$sdata['data'] = Array( $arrau );
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}
////////////////////////////////////////////////////////////////////////
function fdelCandidato($id_reg) {
	if(trim($id_reg) == '') { $id_reg = "NULL"; } else { $id_reg = "'{$id_reg}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($id_reg == 'NULL') {
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	if($aborto_proc == false) {
		$conn  = conectar_db("",true);
		$sql = "BEGIN; ";
		{ // Borrado
		$sql .= repare_ADOdbSQL(
					sql_planchas('eliminar_candidato')
					, Array( $id_reg )
					, true
				);
			$err_txt = "Eliminar";
		}

		$resultado = query_db($sql, true);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} el Candidato de la Votaci&oacute;n; el Candidato puede que ya este Registrado";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}
////////////////////////////////////////////////////////////////////////
function fdataVotacion($id_reg) {
	if(trim($id_reg) == '') { $id_reg = "NULL"; } else { $id_reg = "'{$id_reg}'"; }

	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if($id_reg == 'NULL') {
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	if($aborto_proc == false) {
		$conn  = conectar_db("",true);
		$sql = "BEGIN; ";
		{ // Borrado
		$sql .= repare_ADOdbSQL(
					sql_utilidades('consultar_votacion')
					, Array( $id_reg )
					, true
				);
			$err_txt = "Consultar";
		}

		$resultado = query_db($sql, true);
		$arrau = fetch_array_db($resultado);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} la Votaci&oacute;n";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			$sdata['data'] = Array( $arrau );
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}
////////////////////////////////////////////////////////////////////////
function fcambiaPosCandidato($id_nuip_candidato, $idPlancha, $orden, $ordenN){
	global $cnf;
	$error = "";
	$err_txt = "";
	$aborto_proc = false;
	$sdata = Array();
	$login = "'{$_SESSION['login']}'";

	if(trim($id_nuip_candidato) == '' || trim($idPlancha) == '' || trim($orden) == '' || trim($ordenN) == ''){
		$aborto_proc = true;
		$error = "Faltan Datos ";
	}

	if($aborto_proc == false) {
		$conn  = conectar_db("",true);
		$sql = "BEGIN; ";
		{ // Borrado
		$sql .= repare_ADOdbSQL(
					sql_planchas('cambia_pos_candidato')
					, Array( $orden, $ordenN, $idPlancha, $ordenN, $id_nuip_candidato, $idPlancha )
					, true
				);
			$err_txt = "Organizar";
		}

		$resultado = query_db($sql, true);
		if (query_estado("err_msg", true) != "") {
		  $error = "No se pudo {$err_txt} el Candidato de la Votaci&oacute;n.";
		  $aborto_proc = true;
		}

		// Finalizacion del Proceso
		if($aborto_proc == true) {
			query_db("ROLLBACK;", true);
			$sdata['error'] = $error;
			$sdata['sql'] = $sql;
		}
		else {
			query_db("COMMIT;", true);
		}
	}
	else {
		$sdata['error'] = $error;
	}
	$sdata['success'] = !$aborto_proc;

	$sdata = json_encode(($sdata));

 header("Content-Type: application/json; charset=utf-8");
 header("Content-Size: " . strlen($sdata));
 echo($sdata);
}
?>
