<?php
{
global $esqDB;
//var_dump($esqDB);
if( !is_array($esqDB['votaciones']) ) { $esqDB['votaciones'] = array(); }
if( !is_array($esqDB['xcomun']) ) { $esqDB['xcomun'] = array(); }

$esqDB['votaciones']['tmp_nuips'] 			= 'public.tmp_nuips';
$esqDB['votaciones']['vot_censo_electoral'] = 'public.vot_censo_electoral';
$esqDB['votaciones']['vot_votaciones'] 		= 'public.vot_votaciones';
$esqDB['votaciones']['vot_candidatos'] 		= 'public.vot_candidatos';
$esqDB['votaciones']['vot_votos'] 			= 'public.vot_votos';
$esqDB['votaciones']['vot_votos_planchas']	= 'public.vot_votos_planchas';
$esqDB['votaciones']['vot_sedes']			= 'public.vot_sedes';
$esqDB['votaciones']['vot_votaciones_disp'] = 'public.vot_votaciones_disp';
$esqDB['votaciones']['vot_planchas'] 		= 'public.vot_planchas';
$esqDB['votaciones']['vot_candidatos_plancha'] = 'public.vot_candidatos_plancha';

$esqDB['votaciones']['vot_censo_electoral_v2'] = 'public.vot_censo_electoral_v2';
$esqDB['votaciones']['vot_candidatos_v2'] 	= 'public.vot_candidatos_v2';
$esqDB['votaciones']['vot_candidatos_v4'] 	= 'public.vot_candidatos_v4';

$esqDB['xcomun']['xcm_nuips'] 		= 'public.xcm_nuips';
$esqDB['xcomun']['nuips_grupos'] 	= 'public.xcm_nuips_grupos';

$esqDB['xcomun']['nuips_v1'] 		= 'public.xcm_nuips_v1';
}
//var_dump($esqDB);

function sql_utilidades($fun) {
 global $esqDB;
	switch($fun) {
		case 'limpiar_censo_electoral': {
			return "TRUNCATE {$esqDB['votaciones']['vot_censo_electoral']}; ";
		} break;
		case 'contar_censo_electoral': {
			return "SELECT COUNT(*) AS conteo FROM {$esqDB['votaciones']['vot_censo_electoral']}; ";
		} break;
		case 'consultar_votacion': {
			return "SELECT nom_votacion, desc_votacion, fec_ini, fec_fin, cant_opciones, is_voto_blanco, is_plancha "
				. " FROM vot_votaciones WHERE id_votacion = ?; ";
		} break;
		case 'insertar_votacion': {
			return "INSERT INTO vot_votaciones( nom_votacion, desc_votacion, fec_ini, fec_fin, cant_opciones, is_voto_blanco, login_tx, fec_tx ) "
				. " VALUES (?, ?, '?', '?', ?, '?', {$esqDB['login']}, NOW() ); "
				. " SELECT lastval() AS id_votacion; ";
		} break;
		case 'insertar_candidatos': {
			return "INSERT INTO vot_candidatos( id_votacion, id_nuip_candidato, path_img_candidato, login_tx, fec_tx, orden)"
				. " (SELECT ?, id_nuip_candidato, path_img_candidato, {$esqDB['login']}, NOW(), orden FROM vot_candidatos WHERE id_votacion = ? ); ";
		} break;
		case 'version': {
			return "v.20110114";
		} break;
	}
}

function sql_registro($fun) {
 global $esqDB;
	switch($fun) {
		case 'datos_votante': {
			return "SELECT maq_nom_nuip, maq_id_nuip FROM public.xcm_nuips_v1 "
			. " WHERE id_nuip = ?; ";
		} break;
		case 'version': {
			return "v.20101223";
		} break;
	}
}

function sql_tmp_nuips($fun) {
 global $esqDB;
	switch($fun) {
		case 'ins_tmp': {
			return "INSERT INTO {$esqDB['votaciones']['tmp_nuips']}("
			. "id_nuip, nom_nuip, ape_nuip, fec_nacimiento, nom_empresa,"
			. "	id_sexo, login_tx, fec_tx)"
            . " VALUES (?, ?, ?, TO_DATE(?,'DD-MM-YYYY'), ?,"
            . " ?, ?, NOW() ); ";
		} break;
		case 'del_repetidos': {
			return "DELETE FROM {$esqDB['votaciones']['tmp_nuips']} "
			. " WHERE id_nuip IN (SELECT id_nuip FROM public.xcm_nuips ); ";
		} break;
		case 'ins_nuips': {
			return "INSERT INTO public.xcm_nuips(id_nuip, nom_nuip, ape_nuip, fec_nacimiento, nom_empresa, id_sexo, login_tx, fec_tx) "
			. "	(SELECT id_nuip, nom_nuip, ape_nuip, fec_nacimiento, nom_empresa, id_sexo, login_tx, fec_tx "
			. "   FROM {$esqDB['votaciones']['tmp_nuips']}); ";
		} break;
		case 'ins_nuips_grupos': {
			return "INSERT INTO public.xcm_nuips_grupos (id_nuip_serial,id_grupo) "
			. " 	(SELECT xn.id_nuip_serial, ? "
			. "			  FROM {$esqDB['votaciones']['tmp_nuips']} tn, public.xcm_nuips xn "
			. " 		  WHERE	xn.id_nuip = tn.id_nuip); ";
		} break;
		case 'del_tmp': {
			return "TRUNCATE TABLE {$esqDB['votaciones']['tmp_nuips']}; ";
		} break;
		case 'version': {
			return "v.20101209";
		} break;
	}
}

function sql_votaciones($fun) {
 global $esqDB;
	switch($fun) {
		case 'insertar': {
			return "INSERT INTO {$esqDB['votaciones']['vot_votaciones']}("
			. " nom_votacion, desc_votacion, fec_ini, fec_fin,"
			. " login_tx, fec_tx, cant_opciones, is_voto_blanco, orden_db, is_salida_sin_votar, is_plancha, id_sede)"
            . " VALUES (?, ?, ?::DATE, ?::DATE,"
            . " {$esqDB['login']}, NOW(), ?, ?, ?, ?, ?, ? ); "
            . " SELECT lastval() AS id_votacion; ";
		} break;
		case 'actualizar': {
			return "UPDATE {$esqDB['votaciones']['vot_votaciones']} SET "
			. " id_votacion=?, nom_votacion=?, desc_votacion=?, fec_ini=?, fec_fin=? "
			. " , login_tx={$esqDB['login']}, fec_tx=NOW(), cant_opciones=?, is_voto_blanco=?, orden_db=?, is_salida_sin_votar=? "
			. " , is_plancha=?, id_sede=?"
			. " WHERE id_votacion=?; "
			. " SELECT ? AS id_votacion; ";
		} break;
		case 'eliminar': {
			return "DELETE FROM {$esqDB['votaciones']['vot_votaciones']} "
			. " WHERE id_votacion=?; ";
		} break;
		case 'version': {
			return "v.20110315";
		} break;
	}
}

function sql_candidatos($fun) {
 global $esqDB;
	switch($fun) {
		case 'insertar': {
			return "INSERT INTO {$esqDB['votaciones']['vot_candidatos']}("
				. " id_votacion, id_nuip_candidato, path_img_candidato, orden, login_tx, fec_tx) "
				. " VALUES (?, ?, ?, ?, {$esqDB['login']}, NOW()); "
				. " SELECT lastval() AS id_candidato; ";
		} break;
		case 'eliminar': {
			return "DELETE FROM {$esqDB['votaciones']['vot_candidatos']}"
				. " WHERE id_candidato = ?; ";
		} break;
		case 'cambia_pos_candidato': {
			return "UPDATE {$esqDB['votaciones']['vot_candidatos']} "
			     . " SET orden = ? "
			     . " WHERE orden = ? " // colocar a todos los anteriores o posteriores la nueva posicion
			     . "   AND id_votacion = ?; "
			     . "UPDATE {$esqDB['votaciones']['vot_candidatos']} "
			     . " SET orden = ? "
			     . " WHERE id_nuip_candidato = ? "
			     . "   AND id_votacion=?; ";
		} break;
		case 'version': {
			return "v.20101221";
		} break;
	}
}

function sql_planchas($fun) {
 global $esqDB;
	switch($fun) {
		case 'insertar_candidato': {
			return "INSERT INTO {$esqDB['votaciones']['vot_candidatos_plancha']}("
				. " id_plancha, id_nuip_candidato, orden, tipo_candidato, login_tx, fec_tx) "
				. " VALUES (?, ?, ?, ?, {$esqDB['login']}, NOW()); "
				. " SELECT lastval() AS id_candidato_plancha; ";
		} break;
		case 'insertar_plancha': {
			return "INSERT INTO {$esqDB['votaciones']['vot_planchas']}("
				. " nom_plancha, desc_plancha, id_votacion, login_tx, fec_tx) "
				. " VALUES (?, ?, ?, {$esqDB['login']}, NOW()); "
				. " SELECT lastval() AS id_plancha; ";
		} break;
		case 'actualizar_plancha': {
			return "UPDATE {$esqDB['votaciones']['vot_planchas']} SET "
				. " nom_plancha=?, desc_plancha=?, id_votacion=?, login_tx={$esqDB['login']}, fec_tx=NOW() "
				. " WHERE id_plancha=?; "
				. " SELECT ? AS id_plancha; ";
		} break;
		case 'eliminar_candidato': {
			return "DELETE FROM {$esqDB['votaciones']['vot_candidatos_plancha']}"
				. " WHERE id_candidato_plancha = ?; ";
		} break;
		case 'cambia_pos_candidato': {
			return "UPDATE {$esqDB['votaciones']['vot_candidatos_plancha']} "
			     . " SET orden = ? "
			     . " WHERE orden = ? " // colocar a todos los anteriores o posteriores la nueva posicion
			     . "   AND id_plancha = ?; "
			     . "UPDATE {$esqDB['votaciones']['vot_candidatos_plancha']} "
			     . " SET orden = ? "
			     . " WHERE id_nuip_candidato = ? "
			     . "   AND id_plancha=?; ";
		} break;
		case 'version': {
			return "v.20110316";
		} break;
	}
}

function sql_votacion($fun) {
 global $esqDB;
	switch($fun) {
		case 'datos_votante': {
			return "SELECT maq_nom_nuip, maq_id_nuip, id_sede FROM public.xcm_nuips_v2 "
			. " WHERE id_nuip = ?; ";
		} break;
		case 'valida_votante': {
			return "SELECT count(id_nuip) AS conteo FROM {$esqDB['votaciones']['vot_censo_electoral']} "
			. " WHERE id_nuip = ?; ";
		} break;
		case 'parametros_votacion': {
			return "SELECT nom_votacion, fec_ini, fec_fin, cant_opciones, is_voto_blanco, is_salida_sin_votar, is_plancha "
			. " FROM {$esqDB['votaciones']['vot_votaciones']} "
			. " WHERE id_votacion=?; ";
		} break;
		case 'consulta_candidatos': {
			return "SELECT id_candidato, id_votacion, id_nuip_candidato, path_img_candidato, maq_nom_nuip "
			. " FROM {$esqDB['votaciones']['vot_candidatos_v2']} "
			. " WHERE id_votacion=? ORDER BY orden, maq_nom_nuip; ";
		} break;
		case 'consulta_candidatos_plancha': {
			return "SELECT id_candidato_plancha, id_nuip_candidato, tipo_candidato, maq_nom_nuip "
			. " FROM {$esqDB['votaciones']['vot_candidatos_v4']} "
			. " WHERE id_plancha=? ORDER BY orden, maq_nom_nuip; ";
		} break;
		case 'consulta_planchas': {
			return "SELECT id_plancha, nom_plancha, desc_plancha "
			. " FROM {$esqDB['votaciones']['vot_planchas']} "
			. " WHERE id_votacion=? ORDER BY nom_plancha; ";
		} break;
		case 'consulta_sedes': {
			return "SELECT id_sede, nom_sede "
			. " FROM {$esqDB['votaciones']['vot_sedes']} "
			. " WHERE id_sede='?' ORDER BY nom_sede; ";
		} break;

		case 'guarda_voto': {
			return "INSERT INTO {$esqDB['votaciones']['vot_votos']}( "
			. " id_votacion, id_nuip_candidato, id_sede, fec_voto) "
			. " VALUES (?, ?, ?, NOW()); ";
		} break;
		case 'guarda_voto_plancha': {
			return "INSERT INTO {$esqDB['votaciones']['vot_votos_planchas']}( "
			. " id_votacion, id_plancha, id_sede, fec_voto) "
			. " VALUES (?, ?, ?, NOW()); ";
		} break;
		case 'guarda_votacion_nuip': {
			return "INSERT INTO {$esqDB['votaciones']['vot_votaciones_disp']}( "
			. " id_votacion, id_nuip, fec_tx) "
			. " VALUES (?, ?, NOW()); ";
		} break;
		case 'version': {
			return "v.20101221";
		} break;
	}
}

function sql_asociados($fun) {
 global $esqDB;
	switch($fun) {
		case 'ins_nuip': {
			return "INSERT INTO public.xcm_nuips ( "
			. "id_nuip, nom_nuip, ape_nuip, login_tx, fec_tx) "
			. " VALUES (?, ?, ?, {$esqDB['login']}, NOW()); "
			. " SELECT lastval() AS id_nuip_serial; ";
		} break;
		case 'upd_nuip': {
			return "UPDATE public.xcm_nuips SET "
			. " id_nuip_serial=?, id_nuip=?, nom_nuip=?, ape_nuip=?, login_tx={$esqDB['login']}, fec_tx=NOW() "
			. " WHERE id_nuip_serial = ?; "
			. " SELECT ? AS id_nuip_serial";
		} break;
		case 'count_nuips_grupos': {
			return "SELECT COUNT(*) AS total FROM public.xcm_nuips_grupos "
			. " WHERE id_nuip_serial=? AND id_grupo=?; ";
		} break;
		case 'ins_nuips_grupos': {
			return "INSERT INTO public.xcm_nuips_grupos (id_nuip_serial, id_grupo) VALUES (?, ?); ";
		} break;
		case 'version': {
			return "v.20110111";
		} break;
	}
}

function sql_censo($fun) {
 global $esqDB;
	switch($fun) {
		case 'eliminar_votante': {
			return "DELETE FROM {$esqDB['votaciones']['vot_censo_electoral']}"
				. " WHERE id_censo_electoral = ?; ";
		} break;
		case 'version': {
			return "v.20130129";
		} break;
	}
}

?>
