﻿
SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

 CREATE TRUSTED PROCEDURAL LANGUAGE 'plpgsql'
  HANDLER plpgsql_call_handler
  VALIDATOR plpgsql_validator;
ALTER LANGUAGE plpgsql OWNER TO dbxdba;

SET search_path = public, pg_catalog;

CREATE TYPE vot_resultado AS (
	maq_nom_nuip text,
	id_nuip_candidato bigint,
	cant_votos integer,
	pct_votos numeric,
	id_votacion integer
);

ALTER TYPE public.vot_resultado OWNER TO dbxdba;
COMMENT ON TYPE vot_resultado IS 'Estructura para retornar los resultados de las votaciones';


CREATE TYPE vot_resultado2 AS (
	maq_nom_nuip text,
	id_nuip_candidato bigint,
	cant_votos integer,
	pct_votos numeric,
	id_votacion integer,
	conteo integer
);

ALTER TYPE public.vot_resultado2 OWNER TO dbxdba;
COMMENT ON TYPE vot_resultado2 IS 'Estructura para retornar los resultados de la votacion';


--
-- TOC entry 20 (class 1255 OID 18173)
-- Dependencies: 489 6
-- Name: graba_usuario(integer, integer, character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION graba_usuario(vid_nuip_serial integer, vnit integer, vnombres character varying, vapellidos character varying, vcorreoe character varying, vpasabordo character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE
 vcontar INTEGER;
 vaux INTEGER;
BEGIN
	vaux := 0;
	-- Verificamos si el nit existe
	SELECT count(id_nuip) INTO vcontar FROM xcm_nuips WHERE id_nuip = vnit;
	IF (vcontar > 0) AND (vid_nuip_serial IS NULL) THEN
		RAISE EXCEPTION 'Error el Nit % ya existe.', vnit;
	END IF;

	-- insertamos o actualizamos el nit
	IF vid_nuip_serial IS NULL THEN
		INSERT INTO xcm_nuips(id_nuip, id_tipo_nuip, nom_nuip, ape_nuip) VALUES (vnit, 1, vnombres,
				vapellidos)
		RETURNING id_nuip_serial INTO vaux;
	ELSE
		UPDATE xcm_nuips
			SET id_nuip_serial=vid_nuip_serial, id_nuip=vnit, nom_nuip=vnombres, ape_nuip=vapellidos
		 WHERE id_nuip_serial = vid_nuip_serial
		 RETURNING id_nuip_serial INTO vaux;
	END IF;

	-- insertamos o actualizamos el correo electronico
		SELECT count(email) INTO vcontar FROM xcm_nuips_emails WHERE (id_nuip_serial = vaux) AND (TRIM(email) = TRIM(vcorreoe));
		IF vcontar <= 0 THEN
			INSERT INTO xcm_nuips_emails(
						id_nuip_serial, id_tipo_dir, email)
			 VALUES (vaux, 1, vcorreoe);
		END IF;

	-- asignamos el nuip al grupo de alalco
		SELECT count(id_grupo) INTO vcontar FROM xcm_nuips_grupos WHERE (id_nuip_serial = vaux) AND (id_grupo = 2);
		IF vcontar <= 0 THEN
			INSERT INTO xcm_nuips_grupos(
						id_nuip_serial, id_grupo)
			 VALUES (vaux, 2);
		END IF;

	-- verificamos que el usuario no exista, sino retornamos error
	SELECT count(id_nuip_serial) INTO vcontar FROM xcm_usuarios WHERE id_nuip_serial = vaux;
	IF (vcontar > 0) AND (vid_nuip_serial IS NULL) THEN
		RAISE EXCEPTION 'Error el Usuario % ya Existe.', vnit;
	END IF;

	-- insertamos el usuario
	IF (vid_nuip_serial IS NULL) THEN
		INSERT INTO xcm_usuarios(
					"login", passwd, id_nivel_usuario, id_nuip_serial, fec_creacion)
		 VALUES (vnit::VARCHAR, vpasabordo, 2, vaux, NOW());
	ELSE
		IF (vpasabordo IS NOT NULL) THEN
			UPDATE xcm_usuarios
				SET "login"= vnit::VARCHAR, passwd=vpasabordo, id_nivel_usuario=2, id_nuip_serial=vaux, fec_creacion=NOW()
			 WHERE (id_nuip_serial = vaux) AND ("login"=vnit::VARCHAR);
		END IF;
	END IF;

	-- asignamos el usuario al grupo de alalco
	SELECT count(id_grupo) INTO vcontar FROM xcm_usuarios_grupos WHERE ((id_grupo = 2) AND ("login" = vnit::VARCHAR));
	IF vcontar <= 0 THEN
		INSERT INTO xcm_usuarios_grupos(
            "login", id_grupo)
		VALUES (vnit::VARCHAR, 2);
	END IF;

	-- asigno permiso al usuario para el formulario nuevo clientes
	SELECT count(id_permiso) INTO vcontar FROM xcm_usuarios_permisos WHERE ((id_permiso = '000002000') AND ("login" = vnit::VARCHAR));
	IF vcontar <=0 THEN
		INSERT INTO xcm_usuarios_permisos(
			    "login", id_permiso, fec_tx, login_admin)
		VALUES (vnit::VARCHAR, '000002000', NOW(), 'dbxdba');
	END IF;
 RETURN vaux;
END;
$$;


ALTER FUNCTION public.graba_usuario(vid_nuip_serial integer, vnit integer, vnombres character varying, vapellidos character varying, vcorreoe character varying, vpasabordo character varying) OWNER TO dbxdba;

--
-- TOC entry 22 (class 1255 OID 29770)
-- Dependencies: 486 6 489
-- Name: vot_resultados_fx(integer); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION vot_resultados_fx(p_id_votacion integer) RETURNS SETOF vot_resultado2
    LANGUAGE plpgsql
    AS $_$DECLARE
r vot_resultado2;
v_cant_votos integer;
v_contador integer;
BEGIN
	SELECT COUNT(*) INTO v_cant_votos
	 FROM  vot_votos
	 WHERE id_votacion = $1;
	v_contador := 1;

	IF (v_cant_votos > 0) THEN
		FOR r IN SELECT COALESCE((n.nom_nuip || ' '::text) || n.ape_nuip, n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, v.id_nuip_candidato, count(*) AS nro_votos, round(count(*)/v_cant_votos::numeric*100,2) AS pct_votos ,v.id_votacion
			  FROM  vot_votos v, xcm_nuips n
			  WHERE v.id_nuip_candidato = n.id_nuip
			    AND v.id_votacion = $1
			  GROUP BY v.id_votacion, v.id_nuip_candidato, n.nom_nuip, n.ape_nuip
			  ORDER BY count(*) DESC
		LOOP
			r.conteo := v_contador;
			v_contador := v_contador + 1;
			RETURN NEXT r;
		END LOOP;
		RETURN;
	ELSE
		RAISE EXCEPTION 'No se han registrado votos.';
	END IF;
END$_$;


ALTER FUNCTION public.vot_resultados_fx(p_id_votacion integer) OWNER TO dbxdba;

CREATE TABLE vot_votaciones (
    id_votacion integer NOT NULL,
    nom_votacion character varying NOT NULL,
    desc_votacion text,
    fec_ini timestamp without time zone DEFAULT now() NOT NULL,
    fec_fin timestamp without time zone DEFAULT now() NOT NULL,
    login_tx character varying(30),
    fec_tx timestamp without time zone DEFAULT now() NOT NULL,
    cant_opciones integer DEFAULT 1 NOT NULL,
    is_voto_blanco boolean DEFAULT false NOT NULL,
    orden_db integer DEFAULT 1 NOT NULL,
    is_salida_sin_votar boolean DEFAULT false
);


ALTER TABLE public.vot_votaciones OWNER TO dbxdba;

--
-- TOC entry 21 (class 1255 OID 21366)
-- Dependencies: 489 6 463
-- Name: vot_votaciones_pendientes_fx(bigint); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION vot_votaciones_pendientes_fx(bigint) RETURNS SETOF vot_votaciones
    LANGUAGE plpgsql
    AS $_$
DECLARE
r vot_votaciones%rowtype;
BEGIN
FOR r IN SELECT *
			FROM vot_votaciones v
			WHERE v.id_votacion NOT IN (SELECT vd.id_votacion
							FROM vot_votaciones_disp vd
							WHERE vd.id_nuip = $1)
							AND now() BETWEEN v.fec_ini AND v.fec_fin
			ORDER BY orden_db
LOOP
	RETURN NEXT r;
END LOOP;
RETURN;
END
$_$;


ALTER FUNCTION public.vot_votaciones_pendientes_fx(bigint) OWNER TO dbxdba;

CREATE SEQUENCE conteo
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.conteo OWNER TO dbxdba;


CREATE TABLE tmp_nuips (
    id_nuip bigint,
    digito_verif smallint,
    id_tipo_nuip integer,
    nom_nuip text,
    ape_nuip text,
    nom_contacto text,
    notas text,
    fec_nacimiento timestamp without time zone,
    nom_empresa text,
    id_sexo integer,
    id_titulo_nuip integer,
    login_tx character varying(30),
    fec_tx timestamp without time zone DEFAULT now()
);


ALTER TABLE public.tmp_nuips OWNER TO dbxdba;
COMMENT ON TABLE tmp_nuips IS 'Temporal de Nuips';

--
-- TOC entry 1760 (class 1259 OID 21205)
-- Dependencies: 2110 2112 6
-- Name: vot_candidatos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE vot_candidatos (
    id_candidato bigint NOT NULL,
    id_votacion integer NOT NULL,
    id_nuip_candidato bigint NOT NULL,
    path_img_candidato character varying,
    login_tx character varying(30),
    fec_tx timestamp without time zone DEFAULT now() NOT NULL,
    orden integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.vot_candidatos OWNER TO dbxdba;

--
-- TOC entry 1676 (class 1259 OID 17643)
-- Dependencies: 2066 6
-- Name: xcm_nuips; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_nuips (
    id_nuip_serial bigint NOT NULL,
    id_nuip bigint,
    digito_verif smallint,
    id_tipo_nuip integer,
    nom_nuip text,
    ape_nuip text,
    nom_contacto text,
    notas text,
    fec_nacimiento timestamp without time zone,
    nom_empresa text,
    id_sexo integer,
    id_titulo_nuip integer,
    login_tx character varying(30),
    fec_tx timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.xcm_nuips OWNER TO dbxdba;

--
-- TOC entry 1765 (class 1259 OID 21356)
-- Dependencies: 1870 6
-- Name: vot_candidatos_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW vot_candidatos_v1 AS
    SELECT c.id_candidato, c.id_votacion, c.id_nuip_candidato, c.path_img_candidato, c.orden, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip FROM vot_candidatos c, xcm_nuips n WHERE (c.id_nuip_candidato = n.id_nuip);


ALTER TABLE public.vot_candidatos_v1 OWNER TO dbxdba;
COMMENT ON VIEW vot_candidatos_v1 IS 'v.20101221.1';


--
-- TOC entry 1766 (class 1259 OID 21360)
-- Dependencies: 1871 6
-- Name: vot_candidatos_v2; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW vot_candidatos_v2 AS
    SELECT c.id_candidato, c.id_votacion, c.id_nuip_candidato, c.path_img_candidato, c.orden, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip FROM vot_candidatos c, xcm_nuips n WHERE (c.id_nuip_candidato = n.id_nuip);


ALTER TABLE public.vot_candidatos_v2 OWNER TO dbxdba;

--
-- TOC entry 1725 (class 1259 OID 18342)
-- Dependencies: 2100 6
-- Name: vot_censo_electoral; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE vot_censo_electoral (
    id_censo_electoral bigint NOT NULL,
    id_nuip bigint NOT NULL,
    fec_tx timestamp without time zone DEFAULT now() NOT NULL,
    login_tx character varying(30)
);

ALTER TABLE public.vot_censo_electoral OWNER TO dbxdba;

--
-- TOC entry 1724 (class 1259 OID 18340)
-- Dependencies: 6 1725
-- Name: vot_censo_electoral_id_censo_electoral_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE vot_censo_electoral_id_censo_electoral_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.vot_censo_electoral_id_censo_electoral_seq OWNER TO dbxdba;
ALTER SEQUENCE vot_censo_electoral_id_censo_electoral_seq OWNED BY vot_censo_electoral.id_censo_electoral;

--
-- TOC entry 1769 (class 1259 OID 21490)
-- Dependencies: 1873 6
-- Name: vot_censo_electoral_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW vot_censo_electoral_v1 AS
    SELECT (ce.fec_tx)::date AS fec_tx, to_char(((ce.fec_tx)::time without time zone)::interval, 'HH12:MI:SS am'::text) AS hor_tx, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, n.nom_empresa FROM vot_censo_electoral ce, xcm_nuips n WHERE (ce.id_nuip = n.id_nuip);


ALTER TABLE public.vot_censo_electoral_v1 OWNER TO dbxdba;

--
-- TOC entry 1764 (class 1259 OID 21305)
-- Dependencies: 2116 6
-- Name: vot_votaciones_disp; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE vot_votaciones_disp (
    id_votacion_disp bigint NOT NULL,
    id_votacion integer NOT NULL,
    id_nuip bigint NOT NULL,
    fec_tx timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.vot_votaciones_disp OWNER TO dbxdba;

--
-- TOC entry 1763 (class 1259 OID 21303)
-- Dependencies: 1764 6
-- Name: vot_votaciones_disp_id_votacion_disp_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE vot_votaciones_disp_id_votacion_disp_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.vot_votaciones_disp_id_votacion_disp_seq OWNER TO dbxdba;
ALTER SEQUENCE vot_votaciones_disp_id_votacion_disp_seq OWNED BY vot_votaciones_disp.id_votacion_disp;

--
-- TOC entry 1757 (class 1259 OID 21168)
-- Dependencies: 6 1758
-- Name: vot_votaciones_id_votacion_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE vot_votaciones_id_votacion_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.vot_votaciones_id_votacion_seq OWNER TO dbxdba;
ALTER SEQUENCE vot_votaciones_id_votacion_seq OWNED BY vot_votaciones.id_votacion;

--
-- TOC entry 1762 (class 1259 OID 21286)
-- Dependencies: 2114 6
-- Name: vot_votos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE vot_votos (
    id_voto bigint NOT NULL,
    id_votacion integer NOT NULL,
    id_nuip_candidato bigint NOT NULL,
    fec_voto timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.vot_votos OWNER TO dbxdba;

--
-- TOC entry 1761 (class 1259 OID 21284)
-- Dependencies: 6 1762
-- Name: vot_votos_id_voto_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE vot_votos_id_voto_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vot_votos_id_voto_seq OWNER TO dbxdba;
ALTER SEQUENCE vot_votos_id_voto_seq OWNED BY vot_votos.id_voto;

--
-- TOC entry 1767 (class 1259 OID 21410)
-- Dependencies: 1872 6
-- Name: vot_votos_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW vot_votos_v1 AS
    SELECT COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, v.id_nuip_candidato, count(*) AS nro_votos, v.id_votacion FROM vot_votos v, xcm_nuips n WHERE (v.id_nuip_candidato = n.id_nuip) GROUP BY v.id_votacion, v.id_nuip_candidato, n.nom_nuip, n.ape_nuip ORDER BY count(*) DESC;


ALTER TABLE public.vot_votos_v1 OWNER TO dbxdba;
COMMENT ON VIEW vot_votos_v1 IS 'v.20101227.1';

--
-- TOC entry 1759 (class 1259 OID 21203)
-- Dependencies: 6 1760
-- Name: vota_candidatos_id_candidato_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE vota_candidatos_id_candidato_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.vota_candidatos_id_candidato_seq OWNER TO dbxdba;
ALTER SEQUENCE vota_candidatos_id_candidato_seq OWNED BY vot_candidatos.id_candidato;

--
-- TOC entry 1682 (class 1259 OID 17717)
-- Dependencies: 2073 6
-- Name: xcm_campos_db; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_campos_db (
    nom_esquema character varying NOT NULL,
    nom_tabla character varying NOT NULL,
    nom_columna character varying NOT NULL,
    nom_campo_es character varying,
    desc_campo_es character varying,
    nom_campo_en character varying,
    desc_campo_en character varying,
    nom_fx_valida_js character varying,
    is_nullable boolean DEFAULT false NOT NULL
);

ALTER TABLE public.xcm_campos_db OWNER TO dbxdba;

--
-- TOC entry 1683 (class 1259 OID 17724)
-- Dependencies: 2074 6
-- Name: xcm_db_departamentos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_departamentos (
    id_depto bigint NOT NULL,
    id_pais bigint NOT NULL,
    cod_interno character varying(30),
    is_activo boolean DEFAULT true NOT NULL,
    orden_db integer,
    nom_depto_es character varying(30) NOT NULL,
    abr_depto_es character varying(8),
    nom_depto_en character varying(30),
    abr_depto_en character varying(8),
    nom_depto_de character varying(30),
    abr_depto_de character varying(8),
    nom_depto_fr character varying(30),
    abr_depto_fr character varying(8)
);


ALTER TABLE public.xcm_db_departamentos OWNER TO dbxdba;
COMMENT ON TABLE xcm_db_departamentos IS 'Departamentos o Estado en Caso de Otros Paises.';

--
-- TOC entry 1684 (class 1259 OID 17728)
-- Dependencies: 6 1683
-- Name: xcm_db_departamentos_id_depto_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_departamentos_id_depto_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_db_departamentos_id_depto_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_db_departamentos_id_depto_seq OWNED BY xcm_db_departamentos.id_depto;

--
-- TOC entry 1685 (class 1259 OID 17730)
-- Dependencies: 2076 6
-- Name: xcm_db_municipios; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_municipios (
    id_municipio bigint NOT NULL,
    id_depto bigint NOT NULL,
    is_activo boolean DEFAULT true NOT NULL,
    is_capital_pais boolean,
    is_capital_depto boolean,
    orden_db integer,
    cod_interno character varying(30),
    nom_municipio_es character varying(30) NOT NULL,
    abr_municipio_es character varying(8),
    abr_municipio_fr character varying(8),
    nom_municipio_fr character varying(30),
    abr_municipio_de character varying(8),
    nom_municipio_de character varying(30),
    abr_municipio_en character varying(8),
    nom_municipio_en character varying(30)
);

ALTER TABLE public.xcm_db_municipios OWNER TO dbxdba;

--
-- TOC entry 1686 (class 1259 OID 17734)
-- Dependencies: 6 1685
-- Name: xcm_db_municipios_id_municipio_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_municipios_id_municipio_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_db_municipios_id_municipio_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_db_municipios_id_municipio_seq OWNED BY xcm_db_municipios.id_municipio;

--
-- TOC entry 1687 (class 1259 OID 17736)
-- Dependencies: 2078 6
-- Name: xcm_db_paises; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_paises (
    id_pais bigint NOT NULL,
    orden_db integer,
    nom_pais_es character varying NOT NULL,
    abr_pais_es character varying,
    nom_pais_en character varying,
    abr_pais_en character varying,
    nom_pais_de character varying,
    abr_pais_de character varying,
    nom_pais_fr character varying,
    abr_pais_fr character(1),
    is_activo boolean DEFAULT true NOT NULL,
    cod_interno character varying
);


ALTER TABLE public.xcm_db_paises OWNER TO dbxdba;

--
-- TOC entry 1688 (class 1259 OID 17743)
-- Dependencies: 1687 6
-- Name: xcm_db_paises_id_pais_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_paises_id_pais_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_db_paises_id_pais_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_db_paises_id_pais_seq OWNED BY xcm_db_paises.id_pais;

--
-- TOC entry 1677 (class 1259 OID 17672)
-- Dependencies: 6
-- Name: xcm_db_sexos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_sexos (
    id_sexo integer NOT NULL,
    orden_db integer,
    nom_sexo_es character varying,
    abr_sexo_es character varying,
    nom_sexo_en character varying,
    abr_sexo_en character varying,
    nom_sexo_de character varying,
    abr_sexo_de character varying,
    nom_sexo_fr character varying,
    abr_sexo_fr character varying,
    is_activo boolean,
    cod_interno character varying
);

ALTER TABLE public.xcm_db_sexos OWNER TO dbxdba;

--
-- TOC entry 1689 (class 1259 OID 17745)
-- Dependencies: 1677 6
-- Name: xcm_db_sexos_id_sexo_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_sexos_id_sexo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_db_sexos_id_sexo_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_db_sexos_id_sexo_seq OWNED BY xcm_db_sexos.id_sexo;

--
-- TOC entry 1690 (class 1259 OID 17747)
-- Dependencies: 2080 6
-- Name: xcm_db_tipos_dir; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_tipos_dir (
    id_tipo_dir integer NOT NULL,
    orden_db integer,
    nom_tipo_dir_es character varying,
    abr_tipo_dir_es character varying,
    nom_tipo_dir_en character varying,
    abr_tipo_dir_en character varying,
    nom_tipo_dir_de character varying,
    abr_tipo_dir_de character varying,
    nom_tipo_dir_fr character varying,
    abr_tipo_dir_fr character varying,
    is_activo boolean DEFAULT true NOT NULL,
    cod_interno character varying
);


ALTER TABLE public.xcm_db_tipos_dir OWNER TO dbxdba;

--
-- TOC entry 1691 (class 1259 OID 17754)
-- Dependencies: 6 1690
-- Name: xcm_db_tipos_dir_id_tipo_dir_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_tipos_dir_id_tipo_dir_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_db_tipos_dir_id_tipo_dir_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_db_tipos_dir_id_tipo_dir_seq OWNED BY xcm_db_tipos_dir.id_tipo_dir;

--
-- TOC entry 1678 (class 1259 OID 17678)
-- Dependencies: 2068 6
-- Name: xcm_db_tipos_nuips; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_tipos_nuips (
    id_tipo_nuip integer NOT NULL,
    orden_db integer,
    nom_tipo_nuip_es character varying NOT NULL,
    abr_tipo_nuip_es character varying,
    nom_tipo_nuip_en character varying,
    abr_tipo_nuip_en character varying,
    nom_tipo_nuip_de character varying,
    abr_tipo_nuip_de character varying,
    nom_tipo_nuip_fr character varying,
    abr_tipo_nuip_fr character varying,
    is_activo boolean DEFAULT true NOT NULL,
    cod_interno character varying
);

ALTER TABLE public.xcm_db_tipos_nuips OWNER TO dbxdba;

--
-- TOC entry 1692 (class 1259 OID 17756)
-- Dependencies: 1678 6
-- Name: xcm_db_tipos_nuips_id_tipo_nuip_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_tipos_nuips_id_tipo_nuip_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_db_tipos_nuips_id_tipo_nuip_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_db_tipos_nuips_id_tipo_nuip_seq OWNED BY xcm_db_tipos_nuips.id_tipo_nuip;

--
-- TOC entry 1693 (class 1259 OID 17758)
-- Dependencies: 6
-- Name: xcm_db_tipos_tel; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_tipos_tel (
    id_tipo_tel integer NOT NULL,
    orden_db integer,
    nom_tipo_tel_es character varying,
    abr_tipo_tel_es character varying,
    nom_tipo_tel_en character varying,
    abr_tipo_tel_en character varying,
    nom_tipo_tel_de character varying,
    abr_tipo_tel_de character varying,
    nom_tipo_tel_fr character varying,
    abr_tipo_tel_fr character varying,
    is_activo boolean,
    cod_interno character varying
);

ALTER TABLE public.xcm_db_tipos_tel OWNER TO dbxdba;

--
-- TOC entry 1694 (class 1259 OID 17764)
-- Dependencies: 1693 6
-- Name: xcm_db_tipos_tel_id_tipo_tel_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_tipos_tel_id_tipo_tel_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_db_tipos_tel_id_tipo_tel_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_db_tipos_tel_id_tipo_tel_seq OWNED BY xcm_db_tipos_tel.id_tipo_tel;

--
-- TOC entry 1679 (class 1259 OID 17685)
-- Dependencies: 6
-- Name: xcm_db_titulos_nuips; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_titulos_nuips (
    id_titulo_nuip integer NOT NULL,
    orden_db integer,
    nom_titulo_nuip_es character varying,
    abr_titulo_nuip_es character varying,
    nom_titulo_nuip_en character varying,
    abr_titulo_nuip_en character varying,
    nom_titulo_nuip_de character varying,
    abr_titulo_nuipo_de character varying,
    nom_titulo_nuip_fr character varying,
    abr_titulo_nuip_fr character varying,
    is_activo boolean,
    cod_interno character varying
);

ALTER TABLE public.xcm_db_titulos_nuips OWNER TO dbxdba;

--
-- TOC entry 1695 (class 1259 OID 17766)
-- Dependencies: 6 1679
-- Name: xcm_db_titulos_nuips_id_titulo_nuip_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_titulos_nuips_id_titulo_nuip_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_db_titulos_nuips_id_titulo_nuip_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_db_titulos_nuips_id_titulo_nuip_seq OWNED BY xcm_db_titulos_nuips.id_titulo_nuip;

--
-- TOC entry 1680 (class 1259 OID 17691)
-- Dependencies: 6
-- Name: xcm_grupos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_grupos (
    id_grupo bigint NOT NULL,
    id_nuip_serial bigint,
    nom_grupo character varying,
    desc_grupo character varying
);

ALTER TABLE public.xcm_grupos OWNER TO dbxdba;

--
-- TOC entry 1696 (class 1259 OID 17768)
-- Dependencies: 1680 6
-- Name: xcm_grupos_id_grupo_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_grupos_id_grupo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_grupos_id_grupo_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_grupos_id_grupo_seq OWNED BY xcm_grupos.id_grupo;

--
-- TOC entry 1697 (class 1259 OID 17770)
-- Dependencies: 2083 2084 6
-- Name: xcm_grupos_permisos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_grupos_permisos (
    id_grupo_permiso bigint NOT NULL,
    id_grupo bigint NOT NULL,
    id_permiso character varying NOT NULL,
    fec_tx timestamp without time zone DEFAULT '2008-09-24 08:40:40.471'::timestamp without time zone NOT NULL,
    login_admin character varying(30) DEFAULT "current_user"()
);

ALTER TABLE public.xcm_grupos_permisos OWNER TO dbxdba;

--
-- TOC entry 1698 (class 1259 OID 17778)
-- Dependencies: 6 1697
-- Name: xcm_grupos_permisos_id_grupo_permiso_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_grupos_permisos_id_grupo_permiso_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_grupos_permisos_id_grupo_permiso_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_grupos_permisos_id_grupo_permiso_seq OWNED BY xcm_grupos_permisos.id_grupo_permiso;


--
-- TOC entry 1699 (class 1259 OID 17780)
-- Dependencies: 1858 6
-- Name: xcm_grupos_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_grupos_v1 AS
    SELECT g.id_grupo, g.nom_grupo, g.desc_grupo, g.id_nuip_serial, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip FROM (xcm_grupos g LEFT JOIN xcm_nuips n ON ((g.id_nuip_serial = n.id_nuip_serial)));

ALTER TABLE public.xcm_grupos_v1 OWNER TO dbxdba;

--
-- TOC entry 1700 (class 1259 OID 17784)
-- Dependencies: 1859 6
-- Name: xcm_municipios_deptos_paises_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_municipios_deptos_paises_v1 AS
    SELECT db_m.id_municipio, db_m.nom_municipio_es, db_d.nom_depto_es, db_p.nom_pais_es FROM xcm_db_municipios db_m, xcm_db_departamentos db_d, xcm_db_paises db_p WHERE ((db_m.id_depto = db_d.id_depto) AND (db_d.id_pais = db_p.id_pais));

ALTER TABLE public.xcm_municipios_deptos_paises_v1 OWNER TO dbxdba;

--
-- TOC entry 1701 (class 1259 OID 17788)
-- Dependencies: 2086 6
-- Name: xcm_niveles_usuario; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_niveles_usuario (
    id_nivel_usuario smallint DEFAULT (0)::smallint NOT NULL,
    nom_nivel_usuario character varying NOT NULL
);

ALTER TABLE public.xcm_niveles_usuario OWNER TO dbxdba;

--
-- TOC entry 1702 (class 1259 OID 17795)
-- Dependencies: 6
-- Name: xcm_nuips_dirs; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_nuips_dirs (
    id_nuip_dir bigint NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_tipo_dir integer,
    dir text NOT NULL,
    id_municipio bigint
);

ALTER TABLE public.xcm_nuips_dirs OWNER TO dbxdba;

--
-- TOC entry 1703 (class 1259 OID 17801)
-- Dependencies: 1702 6
-- Name: xcm_nuips_dirs_id_nuip_dir_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_nuips_dirs_id_nuip_dir_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_nuips_dirs_id_nuip_dir_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_nuips_dirs_id_nuip_dir_seq OWNED BY xcm_nuips_dirs.id_nuip_dir;

--
-- TOC entry 1704 (class 1259 OID 17803)
-- Dependencies: 1860 6
-- Name: xcm_nuips_dirs_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_nuips_dirs_v1 AS
    SELECT n.id_nuip_serial, n.id_nuip, n.nom_nuip, n.ape_nuip, nt.dir, nt.id_nuip_dir, nt.id_municipio, dtt.id_tipo_dir, dtt.nom_tipo_dir_es, dtt.abr_tipo_dir_es, mun.nom_municipio_es FROM (((xcm_nuips_dirs nt LEFT JOIN xcm_nuips n ON ((nt.id_nuip_serial = n.id_nuip_serial))) LEFT JOIN xcm_db_municipios mun ON ((nt.id_municipio = mun.id_municipio))) LEFT JOIN xcm_db_tipos_dir dtt ON ((nt.id_tipo_dir = dtt.id_tipo_dir)));

ALTER TABLE public.xcm_nuips_dirs_v1 OWNER TO dbxdba;

--
-- TOC entry 1705 (class 1259 OID 17808)
-- Dependencies: 6
-- Name: xcm_nuips_emails; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_nuips_emails (
    id_nuip_email bigint NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_tipo_dir integer,
    email character varying NOT NULL
);

ALTER TABLE public.xcm_nuips_emails OWNER TO dbxdba;

--
-- TOC entry 1706 (class 1259 OID 17814)
-- Dependencies: 1705 6
-- Name: xcm_nuips_emails_id_nuip_email_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_nuips_emails_id_nuip_email_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_nuips_emails_id_nuip_email_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_nuips_emails_id_nuip_email_seq OWNED BY xcm_nuips_emails.id_nuip_email;

--
-- TOC entry 1707 (class 1259 OID 17816)
-- Dependencies: 1861 6
-- Name: xcm_nuips_emails_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_nuips_emails_v1 AS
    SELECT n.id_nuip_serial, n.id_nuip, n.nom_nuip, n.ape_nuip, nt.email, nt.id_nuip_email, dtt.id_tipo_dir, dtt.nom_tipo_dir_es, dtt.abr_tipo_dir_es FROM ((xcm_nuips_emails nt LEFT JOIN xcm_nuips n ON ((nt.id_nuip_serial = n.id_nuip_serial))) LEFT JOIN xcm_db_tipos_dir dtt ON ((nt.id_tipo_dir = dtt.id_tipo_dir)));

ALTER TABLE public.xcm_nuips_emails_v1 OWNER TO dbxdba;

--
-- TOC entry 1681 (class 1259 OID 17697)
-- Dependencies: 6
-- Name: xcm_nuips_grupos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_nuips_grupos (
    id_nuip_grupo bigint NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_grupo bigint NOT NULL
);

ALTER TABLE public.xcm_nuips_grupos OWNER TO dbxdba;

--
-- TOC entry 1708 (class 1259 OID 17821)
-- Dependencies: 1681 6
-- Name: xcm_nuips_grupos_id_nuip_grupo_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_nuips_grupos_id_nuip_grupo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_nuips_grupos_id_nuip_grupo_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_nuips_grupos_id_nuip_grupo_seq OWNED BY xcm_nuips_grupos.id_nuip_grupo;

--
-- TOC entry 1709 (class 1259 OID 17823)
-- Dependencies: 1862 6
-- Name: xcm_nuips_grupos_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_nuips_grupos_v1 AS
    SELECT COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, g.nom_grupo AS maq_nom_grupo, ng.id_grupo, n.id_nuip, n.digito_verif, tn.abr_tipo_nuip_es, n.nom_nuip, n.ape_nuip, (n.fec_nacimiento)::date AS fec_nacimiento, s.nom_sexo_es, ttn.nom_titulo_nuip_es, n.nom_empresa, n.nom_contacto, n.notas, n.id_nuip_serial, n.id_tipo_nuip, n.id_sexo, n.id_titulo_nuip FROM (((((xcm_nuips n LEFT JOIN xcm_db_tipos_nuips tn ON ((n.id_tipo_nuip = tn.id_tipo_nuip))) LEFT JOIN xcm_db_sexos s ON ((n.id_sexo = s.id_sexo))) LEFT JOIN xcm_db_titulos_nuips ttn ON ((n.id_titulo_nuip = ttn.id_titulo_nuip))) LEFT JOIN xcm_nuips_grupos ng ON ((n.id_nuip_serial = ng.id_nuip_serial))) LEFT JOIN xcm_grupos g ON ((ng.id_grupo = g.id_grupo)));

ALTER TABLE public.xcm_nuips_grupos_v1 OWNER TO dbxdba;

--
-- TOC entry 1710 (class 1259 OID 17828)
-- Dependencies: 1676 6
-- Name: xcm_nuips_id_nuip_serial_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_nuips_id_nuip_serial_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_nuips_id_nuip_serial_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_nuips_id_nuip_serial_seq OWNED BY xcm_nuips.id_nuip_serial;

--
-- TOC entry 1711 (class 1259 OID 17830)
-- Dependencies: 6
-- Name: xcm_nuips_tels; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_nuips_tels (
    id_nuip_tel bigint NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_tipo_tel integer NOT NULL,
    tel text NOT NULL
);

ALTER TABLE public.xcm_nuips_tels OWNER TO dbxdba;

--
-- TOC entry 1712 (class 1259 OID 17836)
-- Dependencies: 6 1711
-- Name: xcm_nuips_tels_id_nuip_tel_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_nuips_tels_id_nuip_tel_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_nuips_tels_id_nuip_tel_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_nuips_tels_id_nuip_tel_seq OWNED BY xcm_nuips_tels.id_nuip_tel;

--
-- TOC entry 1713 (class 1259 OID 17838)
-- Dependencies: 1863 6
-- Name: xcm_nuips_tels_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_nuips_tels_v1 AS
    SELECT n.id_nuip_serial, n.id_nuip, n.nom_nuip, n.ape_nuip, nt.id_nuip_tel, nt.tel, dtt.id_tipo_tel, dtt.nom_tipo_tel_es, dtt.abr_tipo_tel_es FROM ((xcm_nuips_tels nt LEFT JOIN xcm_nuips n ON ((nt.id_nuip_serial = n.id_nuip_serial))) LEFT JOIN xcm_db_tipos_tel dtt ON ((nt.id_tipo_tel = dtt.id_tipo_tel)));

ALTER TABLE public.xcm_nuips_tels_v1 OWNER TO dbxdba;

--
-- TOC entry 1714 (class 1259 OID 17843)
-- Dependencies: 1864 6
-- Name: xcm_nuips_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_nuips_v1 AS
    SELECT COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, n.id_nuip, n.nom_nuip, n.ape_nuip, n.fec_nacimiento, s.nom_sexo_es, ttn.nom_titulo_nuip_es, n.nom_empresa, n.nom_contacto, n.notas, n.id_nuip_serial, n.id_tipo_nuip, n.id_sexo, n.id_titulo_nuip FROM (((xcm_nuips n LEFT JOIN xcm_db_tipos_nuips tn ON ((n.id_tipo_nuip = tn.id_tipo_nuip))) LEFT JOIN xcm_db_sexos s ON ((n.id_sexo = s.id_sexo))) LEFT JOIN xcm_db_titulos_nuips ttn ON ((n.id_titulo_nuip = ttn.id_titulo_nuip)));

ALTER TABLE public.xcm_nuips_v1 OWNER TO dbxdba;

--
-- TOC entry 1715 (class 1259 OID 17848)
-- Dependencies: 2090 6
-- Name: xcm_permisos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_permisos (
    id_permiso character varying NOT NULL,
    id_padre character varying,
    nom_permiso character varying NOT NULL,
    desc_permiso text,
    nro_nivel smallint,
    is_folder boolean DEFAULT false NOT NULL,
    onchange character varying
);

ALTER TABLE public.xcm_permisos OWNER TO dbxdba;

--
-- TOC entry 1716 (class 1259 OID 17855)
-- Dependencies: 2091 2092 2093 2094 2095 6
-- Name: xcm_usuarios; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_usuarios (
    login character varying(30) NOT NULL,
    passwd character varying NOT NULL,
    id_nivel_usuario integer DEFAULT 1 NOT NULL,
    id_nuip_serial bigint NOT NULL,
    fec_creacion timestamp without time zone DEFAULT '2009-01-01 00:00:00'::timestamp without time zone NOT NULL,
    is_activo boolean DEFAULT true NOT NULL,
    cant_sesiones_max smallint DEFAULT (1)::smallint NOT NULL,
    cant_sesiones smallint DEFAULT (0)::smallint NOT NULL
);

ALTER TABLE public.xcm_usuarios OWNER TO dbxdba;

--
-- TOC entry 1717 (class 1259 OID 17866)
-- Dependencies: 6
-- Name: xcm_usuarios_grupos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_usuarios_grupos (
    id_usuario_grupo bigint NOT NULL,
    login character varying(30) NOT NULL,
    id_grupo bigint NOT NULL
);

ALTER TABLE public.xcm_usuarios_grupos OWNER TO dbxdba;

--
-- TOC entry 1718 (class 1259 OID 17869)
-- Dependencies: 6 1717
-- Name: xcm_usuarios_grupos_id_usuario_grupo_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_usuarios_grupos_id_usuario_grupo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_usuarios_grupos_id_usuario_grupo_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_usuarios_grupos_id_usuario_grupo_seq OWNED BY xcm_usuarios_grupos.id_usuario_grupo;

--
-- TOC entry 1719 (class 1259 OID 17871)
-- Dependencies: 1865 6
-- Name: xcm_usuarios_grupos_nuips_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_usuarios_grupos_nuips_v1 AS
    SELECT DISTINCT u.login, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, n.id_nuip, n.id_nuip_serial, COALESCE(ug.id_grupo, ng.id_grupo) AS id_grupo, u.id_nivel_usuario FROM (xcm_usuarios u LEFT JOIN xcm_usuarios_grupos ug ON (((ug.login)::text = (u.login)::text))), xcm_nuips n, xcm_nuips_grupos ng WHERE ((u.id_nuip_serial = n.id_nuip_serial) AND (n.id_nuip_serial = ng.id_nuip_serial)) ORDER BY u.login, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)), COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip), n.id_nuip, n.id_nuip_serial, COALESCE(ug.id_grupo, ng.id_grupo), u.id_nivel_usuario;

ALTER TABLE public.xcm_usuarios_grupos_nuips_v1 OWNER TO dbxdba;

--
-- TOC entry 1720 (class 1259 OID 17876)
-- Dependencies: 1866 6
-- Name: xcm_usuarios_grupos_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_usuarios_grupos_v1 AS
    SELECT ug.id_usuario_grupo, ug.login, g.nom_grupo, g.id_grupo FROM xcm_usuarios_grupos ug, xcm_grupos g WHERE (ug.id_grupo = g.id_grupo);

ALTER TABLE public.xcm_usuarios_grupos_v1 OWNER TO dbxdba;

--
-- TOC entry 1721 (class 1259 OID 17880)
-- Dependencies: 2097 6
-- Name: xcm_usuarios_permisos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_usuarios_permisos (
    id_usuario_permiso bigint NOT NULL,
    login character varying(30) NOT NULL,
    id_permiso character varying NOT NULL,
    fec_tx timestamp without time zone DEFAULT (now())::timestamp without time zone NOT NULL,
    login_admin character varying(30) NOT NULL
);

ALTER TABLE public.xcm_usuarios_permisos OWNER TO dbxdba;

--
-- TOC entry 1722 (class 1259 OID 17887)
-- Dependencies: 6 1721
-- Name: xcm_usuarios_permisos_id_usuario_permiso_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_usuarios_permisos_id_usuario_permiso_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.xcm_usuarios_permisos_id_usuario_permiso_seq OWNER TO dbxdba;
ALTER SEQUENCE xcm_usuarios_permisos_id_usuario_permiso_seq OWNED BY xcm_usuarios_permisos.id_usuario_permiso;

--
-- TOC entry 1723 (class 1259 OID 17889)
-- Dependencies: 1867 6
-- Name: xcm_usuarios_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_usuarios_v1 AS
    SELECT u.login, u.passwd, u.id_nivel_usuario, u.id_nuip_serial, u.fec_creacion, u.is_activo, u.cant_sesiones_max, u.cant_sesiones, n.id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip FROM (xcm_usuarios u LEFT JOIN xcm_nuips n ON ((u.id_nuip_serial = n.id_nuip_serial)));

ALTER TABLE public.xcm_usuarios_v1 OWNER TO dbxdba;
ALTER TABLE vot_candidatos ALTER COLUMN id_candidato SET DEFAULT nextval('vota_candidatos_id_candidato_seq'::regclass);
ALTER TABLE vot_censo_electoral ALTER COLUMN id_censo_electoral SET DEFAULT nextval('vot_censo_electoral_id_censo_electoral_seq'::regclass);
ALTER TABLE vot_votaciones ALTER COLUMN id_votacion SET DEFAULT nextval('vot_votaciones_id_votacion_seq'::regclass);
ALTER TABLE vot_votaciones_disp ALTER COLUMN id_votacion_disp SET DEFAULT nextval('vot_votaciones_disp_id_votacion_disp_seq'::regclass);
ALTER TABLE vot_votos ALTER COLUMN id_voto SET DEFAULT nextval('vot_votos_id_voto_seq'::regclass);
ALTER TABLE xcm_db_departamentos ALTER COLUMN id_depto SET DEFAULT nextval('xcm_db_departamentos_id_depto_seq'::regclass);
ALTER TABLE xcm_db_municipios ALTER COLUMN id_municipio SET DEFAULT nextval('xcm_db_municipios_id_municipio_seq'::regclass);
ALTER TABLE xcm_db_paises ALTER COLUMN id_pais SET DEFAULT nextval('xcm_db_paises_id_pais_seq'::regclass);
ALTER TABLE xcm_db_sexos ALTER COLUMN id_sexo SET DEFAULT nextval('xcm_db_sexos_id_sexo_seq'::regclass);
ALTER TABLE xcm_db_tipos_dir ALTER COLUMN id_tipo_dir SET DEFAULT nextval('xcm_db_tipos_dir_id_tipo_dir_seq'::regclass);
ALTER TABLE xcm_db_tipos_nuips ALTER COLUMN id_tipo_nuip SET DEFAULT nextval('xcm_db_tipos_nuips_id_tipo_nuip_seq'::regclass);
ALTER TABLE xcm_db_tipos_tel ALTER COLUMN id_tipo_tel SET DEFAULT nextval('xcm_db_tipos_tel_id_tipo_tel_seq'::regclass);
ALTER TABLE xcm_db_titulos_nuips ALTER COLUMN id_titulo_nuip SET DEFAULT nextval('xcm_db_titulos_nuips_id_titulo_nuip_seq'::regclass);
ALTER TABLE xcm_grupos ALTER COLUMN id_grupo SET DEFAULT nextval('xcm_grupos_id_grupo_seq'::regclass);
ALTER TABLE xcm_grupos_permisos ALTER COLUMN id_grupo_permiso SET DEFAULT nextval('xcm_grupos_permisos_id_grupo_permiso_seq'::regclass);
ALTER TABLE xcm_nuips ALTER COLUMN id_nuip_serial SET DEFAULT nextval('xcm_nuips_id_nuip_serial_seq'::regclass);
ALTER TABLE xcm_nuips_dirs ALTER COLUMN id_nuip_dir SET DEFAULT nextval('xcm_nuips_dirs_id_nuip_dir_seq'::regclass);
ALTER TABLE xcm_nuips_emails ALTER COLUMN id_nuip_email SET DEFAULT nextval('xcm_nuips_emails_id_nuip_email_seq'::regclass);
ALTER TABLE xcm_nuips_grupos ALTER COLUMN id_nuip_grupo SET DEFAULT nextval('xcm_nuips_grupos_id_nuip_grupo_seq'::regclass);
ALTER TABLE xcm_nuips_tels ALTER COLUMN id_nuip_tel SET DEFAULT nextval('xcm_nuips_tels_id_nuip_tel_seq'::regclass);
ALTER TABLE xcm_usuarios_grupos ALTER COLUMN id_usuario_grupo SET DEFAULT nextval('xcm_usuarios_grupos_id_usuario_grupo_seq'::regclass);
ALTER TABLE xcm_usuarios_permisos ALTER COLUMN id_usuario_permiso SET DEFAULT nextval('xcm_usuarios_permisos_id_usuario_permiso_seq'::regclass);

ALTER TABLE ONLY xcm_grupos
    ADD CONSTRAINT ak_cunom_grupo_xcm_grup UNIQUE (nom_grupo);
ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT ak_login_permiso_xcm_usua UNIQUE (login, id_permiso);
ALTER TABLE ONLY xcm_niveles_usuario
    ADD CONSTRAINT ak_nivel_xcm_nive UNIQUE (nom_nivel_usuario);
ALTER TABLE ONLY xcm_permisos
    ADD CONSTRAINT ak_nom_permiso_xcm_perm UNIQUE (nom_permiso);
ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT ak_nuip_dig_verifica__xcm_nuip UNIQUE (id_nuip, digito_verif);
ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT cu_id_permiso_id_grupo UNIQUE (id_grupo, id_permiso);
ALTER TABLE ONLY xcm_campos_db
    ADD CONSTRAINT pk_xcm_campos_db PRIMARY KEY (nom_esquema, nom_tabla, nom_columna);
ALTER TABLE ONLY xcm_db_departamentos
    ADD CONSTRAINT pk_xcm_db_departamentos PRIMARY KEY (id_depto);
ALTER TABLE ONLY xcm_db_municipios
    ADD CONSTRAINT pk_xcm_db_municipios PRIMARY KEY (id_municipio);
ALTER TABLE ONLY xcm_db_paises
    ADD CONSTRAINT pk_xcm_db_paises PRIMARY KEY (id_pais);
ALTER TABLE ONLY xcm_db_sexos
    ADD CONSTRAINT pk_xcm_db_sexos PRIMARY KEY (id_sexo);
ALTER TABLE ONLY xcm_db_tipos_nuips
    ADD CONSTRAINT pk_xcm_db_tipos_nuips PRIMARY KEY (id_tipo_nuip);
ALTER TABLE ONLY xcm_db_tipos_tel
    ADD CONSTRAINT pk_xcm_db_tipos_tel PRIMARY KEY (id_tipo_tel);
ALTER TABLE ONLY xcm_db_titulos_nuips
    ADD CONSTRAINT pk_xcm_db_titulos_nuips PRIMARY KEY (id_titulo_nuip);
ALTER TABLE ONLY xcm_grupos
    ADD CONSTRAINT pk_xcm_grupos PRIMARY KEY (id_grupo);
ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT pk_xcm_grupos_permisos PRIMARY KEY (id_grupo_permiso);
ALTER TABLE ONLY xcm_niveles_usuario
    ADD CONSTRAINT pk_xcm_niveles_usuario PRIMARY KEY (id_nivel_usuario);
ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT pk_xcm_nuips PRIMARY KEY (id_nuip_serial);
ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT pk_xcm_nuips_dirs PRIMARY KEY (id_nuip_dir);
ALTER TABLE ONLY xcm_nuips_emails
    ADD CONSTRAINT pk_xcm_nuips_emails PRIMARY KEY (id_nuip_email);
ALTER TABLE ONLY xcm_nuips_grupos
    ADD CONSTRAINT pk_xcm_nuips_grupos PRIMARY KEY (id_nuip_grupo);
ALTER TABLE ONLY xcm_nuips_tels
    ADD CONSTRAINT pk_xcm_nuips_tels PRIMARY KEY (id_nuip_tel);
ALTER TABLE ONLY xcm_permisos
    ADD CONSTRAINT pk_xcm_permisos PRIMARY KEY (id_permiso);
ALTER TABLE ONLY xcm_db_tipos_dir
    ADD CONSTRAINT pk_xcm_tipos_dir PRIMARY KEY (id_tipo_dir);
ALTER TABLE ONLY xcm_usuarios
    ADD CONSTRAINT pk_xcm_usuarios PRIMARY KEY (login);
ALTER TABLE ONLY xcm_usuarios_grupos
    ADD CONSTRAINT pk_xcm_usuarios_grupos PRIMARY KEY (id_usuario_grupo);
ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT pk_xcm_usuarios_permisos PRIMARY KEY (id_usuario_permiso);
ALTER TABLE ONLY vot_candidatos
    ADD CONSTRAINT vot_candidatos_id_votacion_key UNIQUE (id_votacion, id_nuip_candidato);
ALTER TABLE ONLY vot_censo_electoral
    ADD CONSTRAINT vot_censo_electoral_id_nuip_key UNIQUE (id_nuip);
ALTER TABLE ONLY vot_censo_electoral
    ADD CONSTRAINT vot_censo_electoral_pkey PRIMARY KEY (id_censo_electoral);
ALTER TABLE ONLY vot_votaciones_disp
    ADD CONSTRAINT vot_votaciones_disp_pkey PRIMARY KEY (id_votacion_disp);
ALTER TABLE ONLY vot_votaciones
    ADD CONSTRAINT vot_votaciones_nom_votacion_key UNIQUE (nom_votacion);
ALTER TABLE ONLY vot_votaciones
    ADD CONSTRAINT vot_votaciones_pkey PRIMARY KEY (id_votacion);
ALTER TABLE ONLY vot_votos
    ADD CONSTRAINT vot_votos_pkey PRIMARY KEY (id_voto);
ALTER TABLE ONLY vot_candidatos
    ADD CONSTRAINT vota_candidatos_pkey PRIMARY KEY (id_candidato);
ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT xcm_nuips_id_nuip_key UNIQUE (id_nuip);
ALTER TABLE ONLY tmp_nuips
    ADD CONSTRAINT xtmp_nuips_id_nuip_key UNIQUE (id_nuip);

CREATE UNIQUE INDEX cu_login ON xcm_usuarios USING btree (login);

CREATE INDEX idx_nom_pais_es ON xcm_db_paises USING btree (nom_pais_es);
CREATE INDEX idx_nombres_apellidos ON xcm_nuips USING btree (nom_nuip, ape_nuip);
CREATE INDEX idx_nuips_grupos_id_grupo ON xcm_nuips_grupos USING btree (id_nuip_serial, id_grupo);
CREATE INDEX ix_rpais ON xcm_db_departamentos USING btree (id_pais);

ALTER TABLE ONLY xcm_nuips_grupos
    ADD CONSTRAINT fk___nuips_gru_nuips FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_db_departamentos
    ADD CONSTRAINT fk__db_deptos_db_paises FOREIGN KEY (id_pais) REFERENCES xcm_db_paises(id_pais) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_db_municipios
    ADD CONSTRAINT fk__db_munici_db_depar FOREIGN KEY (id_depto) REFERENCES xcm_db_departamentos(id_depto) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_permisos
    ADD CONSTRAINT fk__id_permiso_id_padre FOREIGN KEY (id_padre) REFERENCES xcm_permisos(id_permiso) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_nuips_grupos
    ADD CONSTRAINT fk__nuips_nuips_grupos FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT fk__permisos_grupos_grupos FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_usuarios_grupos
    ADD CONSTRAINT fk__usuarios_grupos__usuarios FOREIGN KEY (login) REFERENCES xcm_usuarios(login) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_usuarios
    ADD CONSTRAINT fk__usuarios_niveles_usuario FOREIGN KEY (id_nivel_usuario) REFERENCES xcm_niveles_usuario(id_nivel_usuario) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_usuarios
    ADD CONSTRAINT fk__usuarios_nuips FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_usuarios_grupos
    ADD CONSTRAINT fk__usuarios_usuarios__grupos FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT fk_db_sexos_1 FOREIGN KEY (id_sexo) REFERENCES xcm_db_sexos(id_sexo) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT fk_db_tipos_nuip_1 FOREIGN KEY (id_tipo_nuip) REFERENCES xcm_db_tipos_nuips(id_tipo_nuip) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT fk_titulos_nuip_1 FOREIGN KEY (id_titulo_nuip) REFERENCES xcm_db_titulos_nuips(id_titulo_nuip) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT fk_usuarios__permisos_permiso FOREIGN KEY (id_permiso) REFERENCES xcm_permisos(id_permiso) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT fk_usuarios_permisos__usuarios FOREIGN KEY (login) REFERENCES xcm_usuarios(login) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_grupos
    ADD CONSTRAINT fk_xcm_grup_grupos_nu_xcm_nuip FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT fk_xcm_grup_gruposper_xcm_perm FOREIGN KEY (id_permiso) REFERENCES xcm_permisos(id_permiso) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_nuips_emails
    ADD CONSTRAINT fk_xcm_nuip_email_nuip_tipos FOREIGN KEY (id_tipo_dir) REFERENCES xcm_db_tipos_dir(id_tipo_dir) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT fk_xcm_nuip_nuipsdirs_xcm_nuip FOREIGN KEY (id_tipo_dir) REFERENCES xcm_db_tipos_dir(id_tipo_dir) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_nuips_tels
    ADD CONSTRAINT fk_xcm_nuip_nuipstels_xcm_db_t FOREIGN KEY (id_tipo_tel) REFERENCES xcm_db_tipos_tel(id_tipo_tel) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT fk_xcm_nuips_dirs FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_nuips_emails
    ADD CONSTRAINT fk_xcm_nuips_emails_nuip FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY xcm_nuips_tels
    ADD CONSTRAINT fk_xcm_nuips_tels_nuip FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;
ALTER TABLE ONLY vot_votaciones_disp
    ADD CONSTRAINT vot_votaciones_disp_id_nuip_fkey FOREIGN KEY (id_nuip) REFERENCES xcm_nuips(id_nuip);
ALTER TABLE ONLY vot_votaciones_disp
    ADD CONSTRAINT vot_votaciones_disp_id_votacion_fkey FOREIGN KEY (id_votacion) REFERENCES vot_votaciones(id_votacion);
ALTER TABLE ONLY vot_votos
    ADD CONSTRAINT vot_votos_id_nuip_candidato_fkey FOREIGN KEY (id_nuip_candidato) REFERENCES xcm_nuips(id_nuip) ON UPDATE CASCADE;
ALTER TABLE ONLY vot_votos
    ADD CONSTRAINT vot_votos_id_votacion_fkey FOREIGN KEY (id_votacion) REFERENCES vot_votaciones(id_votacion);
ALTER TABLE ONLY vot_candidatos
    ADD CONSTRAINT vota_candidatos_id_nuip_candidato_fkey FOREIGN KEY (id_nuip_candidato) REFERENCES xcm_nuips(id_nuip);
ALTER TABLE ONLY vot_candidatos
    ADD CONSTRAINT vota_candidatos_id_votacion_fkey FOREIGN KEY (id_votacion) REFERENCES vot_votaciones(id_votacion);
ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT xcm_nuips_dirs_id_municipio_fkey FOREIGN KEY (id_municipio) REFERENCES xcm_db_municipios(id_municipio) ON UPDATE CASCADE;

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;

REVOKE ALL ON SEQUENCE xcm_db_departamentos_id_depto_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_municipios_id_municipio_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_paises_id_pais_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_sexos_id_sexo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_tipos_dir_id_tipo_dir_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_tipos_nuips_id_tipo_nuip_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_tipos_tel_id_tipo_tel_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_titulos_nuips_id_titulo_nuip_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_grupos_id_grupo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_grupos_permisos_id_grupo_permiso_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_dirs_id_nuip_dir_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_emails_id_nuip_email_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_grupos_id_nuip_grupo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_id_nuip_serial_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_tels_id_nuip_tel_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_usuarios_grupos_id_usuario_grupo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_usuarios_permisos_id_usuario_permiso_seq FROM PUBLIC;
