--
-- PostgreSQL database dump
--

-- Started on 2011-03-24 09:51:02 COT

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- TOC entry 449 (class 2612 OID 34155)
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: dbx_fet
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO dbx_fet;

SET search_path = public, pg_catalog;

--
-- TOC entry 306 (class 1247 OID 34158)
-- Dependencies: 6 1636
-- Name: vot_resultado; Type: TYPE; Schema: public; Owner: dbx_fet
--

CREATE TYPE vot_resultado AS (
	maq_nom_nuip text,
	id_nuip_candidato bigint,
	cant_votos integer,
	pct_votos numeric,
	id_votacion integer
);


ALTER TYPE public.vot_resultado OWNER TO dbx_fet;

--
-- TOC entry 2222 (class 0 OID 0)
-- Dependencies: 306
-- Name: TYPE vot_resultado; Type: COMMENT; Schema: public; Owner: dbx_fet
--

COMMENT ON TYPE vot_resultado IS 'Estructura para retornar los resultados de las votaciones';


--
-- TOC entry 308 (class 1247 OID 34161)
-- Dependencies: 6 1637
-- Name: vot_resultado2; Type: TYPE; Schema: public; Owner: dbx_fet
--

CREATE TYPE vot_resultado2 AS (
	maq_nom_nuip text,
	id_nuip_candidato bigint,
	cant_votos integer,
	pct_votos numeric,
	id_votacion integer,
	conteo integer
);


ALTER TYPE public.vot_resultado2 OWNER TO dbx_fet;

--
-- TOC entry 2223 (class 0 OID 0)
-- Dependencies: 308
-- Name: TYPE vot_resultado2; Type: COMMENT; Schema: public; Owner: dbx_fet
--

COMMENT ON TYPE vot_resultado2 IS 'Estructura para retornar los resultados de la votacion';


--
-- TOC entry 19 (class 1255 OID 34162)
-- Dependencies: 449 6
-- Name: graba_usuario(integer, integer, character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: dbx_fet
--

CREATE FUNCTION graba_usuario(vid_nuip_serial integer, vnit integer, vnombres character varying, vapellidos character varying, vcorreoe character varying, vpasabordo character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE
 vcontar INTEGER;
 vaux INTEGER;
BEGIN
	vaux := 0;
	-- Verificamos si el nit existe
	SELECT count(id_nuip) INTO vcontar FROM xcm_nuips WHERE id_nuip = vnit;
	IF (vcontar > 0) AND (vid_nuip_serial IS NULL) THEN
		RAISE EXCEPTION 'Error el Nit % ya existe.', vnit;
	END IF;

	-- insertamos o actualizamos el nit
	IF vid_nuip_serial IS NULL THEN
		INSERT INTO xcm_nuips(id_nuip, id_tipo_nuip, nom_nuip, ape_nuip) VALUES (vnit, 1, vnombres,
				vapellidos)
		RETURNING id_nuip_serial INTO vaux;
	ELSE
		UPDATE xcm_nuips
			SET id_nuip_serial=vid_nuip_serial, id_nuip=vnit, nom_nuip=vnombres, ape_nuip=vapellidos
		 WHERE id_nuip_serial = vid_nuip_serial
		 RETURNING id_nuip_serial INTO vaux;
	END IF;

	-- insertamos o actualizamos el correo electronico
		SELECT count(email) INTO vcontar FROM xcm_nuips_emails WHERE (id_nuip_serial = vaux) AND (TRIM(email) = TRIM(vcorreoe));
		IF vcontar <= 0 THEN
			INSERT INTO xcm_nuips_emails(
						id_nuip_serial, id_tipo_dir, email)
			 VALUES (vaux, 1, vcorreoe);
		END IF;

	-- asignamos el nuip al grupo de alalco
		SELECT count(id_grupo) INTO vcontar FROM xcm_nuips_grupos WHERE (id_nuip_serial = vaux) AND (id_grupo = 2);
		IF vcontar <= 0 THEN
			INSERT INTO xcm_nuips_grupos(
						id_nuip_serial, id_grupo)
			 VALUES (vaux, 2);
		END IF;

	-- verificamos que el usuario no exista, sino retornamos error
	SELECT count(id_nuip_serial) INTO vcontar FROM xcm_usuarios WHERE id_nuip_serial = vaux;
	IF (vcontar > 0) AND (vid_nuip_serial IS NULL) THEN
		RAISE EXCEPTION 'Error el Usuario % ya Existe.', vnit;
	END IF;

	-- insertamos el usuario
	IF (vid_nuip_serial IS NULL) THEN
		INSERT INTO xcm_usuarios(
					"login", passwd, id_nivel_usuario, id_nuip_serial, fec_creacion)
		 VALUES (vnit::VARCHAR, vpasabordo, 2, vaux, NOW());
	ELSE
		IF (vpasabordo IS NOT NULL) THEN
			UPDATE xcm_usuarios
				SET "login"= vnit::VARCHAR, passwd=vpasabordo, id_nivel_usuario=2, id_nuip_serial=vaux, fec_creacion=NOW()
			 WHERE (id_nuip_serial = vaux) AND ("login"=vnit::VARCHAR);
		END IF;
	END IF;

	-- asignamos el usuario al grupo de alalco
	SELECT count(id_grupo) INTO vcontar FROM xcm_usuarios_grupos WHERE ((id_grupo = 2) AND ("login" = vnit::VARCHAR));
	IF vcontar <= 0 THEN
		INSERT INTO xcm_usuarios_grupos(
            "login", id_grupo)
		VALUES (vnit::VARCHAR, 2);
	END IF;

	-- asigno permiso al usuario para el formulario nuevo clientes
	SELECT count(id_permiso) INTO vcontar FROM xcm_usuarios_permisos WHERE ((id_permiso = '000002000') AND ("login" = vnit::VARCHAR));
	IF vcontar <=0 THEN
		INSERT INTO xcm_usuarios_permisos(
			    "login", id_permiso, fec_tx, login_admin)
		VALUES (vnit::VARCHAR, '000002000', NOW(), 'dbxdba');
	END IF;
 RETURN vaux;
END;
$$;


ALTER FUNCTION public.graba_usuario(vid_nuip_serial integer, vnit integer, vnombres character varying, vapellidos character varying, vcorreoe character varying, vpasabordo character varying) OWNER TO dbx_fet;

--
-- TOC entry 20 (class 1255 OID 34163)
-- Dependencies: 6 449 308
-- Name: vot_resultados_fx(integer); Type: FUNCTION; Schema: public; Owner: dbx_fet
--

CREATE FUNCTION vot_resultados_fx(p_id_votacion integer) RETURNS SETOF vot_resultado2
    LANGUAGE plpgsql
    AS $_$DECLARE
r vot_resultado2;
v_cant_votos integer;
v_contador integer;
BEGIN
	SELECT COUNT(*) INTO v_cant_votos
	 FROM  vot_votos
	 WHERE id_votacion = $1;
	v_contador := 1;

	IF (v_cant_votos > 0) THEN
		FOR r IN SELECT COALESCE((n.nom_nuip || ' '::text) || n.ape_nuip, n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, v.id_nuip_candidato, count(*) AS nro_votos, round(count(*)/v_cant_votos::numeric*100,2) AS pct_votos ,v.id_votacion
			  FROM  vot_votos v, xcm_nuips n
			  WHERE v.id_nuip_candidato = n.id_nuip
			    AND v.id_votacion = $1
			  GROUP BY v.id_votacion, v.id_nuip_candidato, n.nom_nuip, n.ape_nuip
			  ORDER BY count(*) DESC
		LOOP
			r.conteo := v_contador;
			v_contador := v_contador + 1;
			RETURN NEXT r;
		END LOOP;
		RETURN;
	ELSE
		RAISE EXCEPTION 'No se han registrado votos.';
	END IF;
END$_$;


ALTER FUNCTION public.vot_resultados_fx(p_id_votacion integer) OWNER TO dbx_fet;

--
-- TOC entry 22 (class 1255 OID 38025)
-- Dependencies: 449 6 308
-- Name: vot_resultados_planchas_fx(integer); Type: FUNCTION; Schema: public; Owner: dbx_fet
--

CREATE FUNCTION vot_resultados_planchas_fx(p_id_votacion integer) RETURNS SETOF vot_resultado2
    LANGUAGE plpgsql
    AS $_$DECLARE
r vot_resultado2;
v_cant_votos integer;
v_contador integer;
BEGIN
	SELECT COUNT(*) INTO v_cant_votos
	 FROM  vot_votos_planchas
	 WHERE id_votacion = $1;
	v_contador := 1;

	IF (v_cant_votos > 0) THEN
		FOR r IN SELECT (p.nom_plancha) AS maq_nom_nuip, p.id_plancha as id_nuip_candidato, count(*) AS nro_votos, round(count(*)/v_cant_votos::numeric*100,2)::Integer AS pct_votos, v.id_votacion
			  FROM  vot_votos_planchas v, vot_planchas p
			  WHERE v.id_plancha = p.id_plancha
			    AND v.id_votacion = $1
			  GROUP BY v.id_votacion, p.id_plancha, p.nom_plancha
			  ORDER BY count(*) DESC
		LOOP
			r.conteo := v_contador;
			v_contador := v_contador + 1;
			RETURN NEXT r;
		END LOOP;
		RETURN;
	ELSE
		RAISE EXCEPTION 'No se han registrado votos.';
	END IF;
END$_$;


ALTER FUNCTION public.vot_resultados_planchas_fx(p_id_votacion integer) OWNER TO dbx_fet;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 1638 (class 1259 OID 34164)
-- Dependencies: 2003 2004 2005 2006 2007 2008 2009 2011 6
-- Name: vot_votaciones; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE vot_votaciones (
    id_votacion integer NOT NULL,
    nom_votacion character varying NOT NULL,
    desc_votacion text,
    fec_ini timestamp without time zone DEFAULT now() NOT NULL,
    fec_fin timestamp without time zone DEFAULT now() NOT NULL,
    login_tx character varying(30),
    fec_tx timestamp without time zone DEFAULT now() NOT NULL,
    cant_opciones integer DEFAULT 1 NOT NULL,
    is_voto_blanco boolean DEFAULT false NOT NULL,
    orden_db integer DEFAULT 1 NOT NULL,
    is_salida_sin_votar boolean DEFAULT false,
    is_plancha boolean DEFAULT false NOT NULL
);


ALTER TABLE public.vot_votaciones OWNER TO dbx_fet;

--
-- TOC entry 21 (class 1255 OID 34177)
-- Dependencies: 310 6 449
-- Name: vot_votaciones_pendientes_fx(bigint); Type: FUNCTION; Schema: public; Owner: dbx_fet
--

CREATE FUNCTION vot_votaciones_pendientes_fx(bigint) RETURNS SETOF vot_votaciones
    LANGUAGE plpgsql
    AS $_$
DECLARE
r vot_votaciones%rowtype;
BEGIN
FOR r IN SELECT *
			FROM vot_votaciones v
			WHERE v.id_votacion NOT IN (SELECT vd.id_votacion
							FROM vot_votaciones_disp vd
							WHERE vd.id_nuip = $1)
							AND now() BETWEEN v.fec_ini AND v.fec_fin
			ORDER BY orden_db
LOOP
	RETURN NEXT r;
END LOOP;
RETURN;
END
$_$;


ALTER FUNCTION public.vot_votaciones_pendientes_fx(bigint) OWNER TO dbx_fet;

--
-- TOC entry 1639 (class 1259 OID 34178)
-- Dependencies: 6
-- Name: conteo; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE conteo
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.conteo OWNER TO dbx_fet;

--
-- TOC entry 2224 (class 0 OID 0)
-- Dependencies: 1639
-- Name: conteo; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('conteo', 1, false);


--
-- TOC entry 1640 (class 1259 OID 34180)
-- Dependencies: 2012 6
-- Name: tmp_nuips; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE tmp_nuips (
    id_nuip bigint,
    digito_verif smallint,
    id_tipo_nuip integer,
    nom_nuip text,
    ape_nuip text,
    nom_contacto text,
    notas text,
    fec_nacimiento timestamp without time zone,
    nom_empresa text,
    id_sexo integer,
    id_titulo_nuip integer,
    login_tx character varying(30),
    fec_tx timestamp without time zone DEFAULT now()
);


ALTER TABLE public.tmp_nuips OWNER TO dbx_fet;

--
-- TOC entry 2225 (class 0 OID 0)
-- Dependencies: 1640
-- Name: TABLE tmp_nuips; Type: COMMENT; Schema: public; Owner: dbx_fet
--

COMMENT ON TABLE tmp_nuips IS 'Temporal de Nuips';


--
-- TOC entry 1641 (class 1259 OID 34187)
-- Dependencies: 2013 2014 6
-- Name: vot_candidatos; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE vot_candidatos (
    id_candidato bigint NOT NULL,
    id_votacion integer NOT NULL,
    id_nuip_candidato bigint NOT NULL,
    path_img_candidato character varying,
    login_tx character varying(30),
    fec_tx timestamp without time zone DEFAULT now() NOT NULL,
    orden integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.vot_candidatos OWNER TO dbx_fet;

--
-- TOC entry 1705 (class 1259 OID 37960)
-- Dependencies: 2059 2060 6
-- Name: vot_candidatos_plancha; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE vot_candidatos_plancha (
    id_candidato_plancha bigint NOT NULL,
    id_plancha bigint NOT NULL,
    id_nuip_candidato bigint NOT NULL,
    orden integer,
    tipo_candidato integer DEFAULT 1 NOT NULL,
    fec_tx timestamp without time zone DEFAULT now() NOT NULL,
    login_tx character varying(30)
);


ALTER TABLE public.vot_candidatos_plancha OWNER TO dbx_fet;

--
-- TOC entry 1704 (class 1259 OID 37958)
-- Dependencies: 1705 6
-- Name: vot_candidatos_plancha_id_candidato_plancha_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE vot_candidatos_plancha_id_candidato_plancha_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vot_candidatos_plancha_id_candidato_plancha_seq OWNER TO dbx_fet;

--
-- TOC entry 2226 (class 0 OID 0)
-- Dependencies: 1704
-- Name: vot_candidatos_plancha_id_candidato_plancha_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE vot_candidatos_plancha_id_candidato_plancha_seq OWNED BY vot_candidatos_plancha.id_candidato_plancha;


--
-- TOC entry 2227 (class 0 OID 0)
-- Dependencies: 1704
-- Name: vot_candidatos_plancha_id_candidato_plancha_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('vot_candidatos_plancha_id_candidato_plancha_seq', 46, true);


--
-- TOC entry 1642 (class 1259 OID 34195)
-- Dependencies: 2016 6
-- Name: xcm_nuips; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_nuips (
    id_nuip_serial bigint NOT NULL,
    id_nuip bigint,
    digito_verif smallint,
    id_tipo_nuip integer,
    nom_nuip text,
    ape_nuip text,
    nom_contacto text,
    notas text,
    fec_nacimiento timestamp without time zone,
    nom_empresa text,
    id_sexo integer,
    id_titulo_nuip integer,
    login_tx character varying(30),
    fec_tx timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.xcm_nuips OWNER TO dbx_fet;

--
-- TOC entry 1643 (class 1259 OID 34202)
-- Dependencies: 1796 6
-- Name: vot_candidatos_v1; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW vot_candidatos_v1 AS
    SELECT c.id_candidato, c.id_votacion, c.id_nuip_candidato, c.path_img_candidato, c.orden, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip FROM vot_candidatos c, xcm_nuips n WHERE (c.id_nuip_candidato = n.id_nuip);


ALTER TABLE public.vot_candidatos_v1 OWNER TO dbx_fet;

--
-- TOC entry 2228 (class 0 OID 0)
-- Dependencies: 1643
-- Name: VIEW vot_candidatos_v1; Type: COMMENT; Schema: public; Owner: dbx_fet
--

COMMENT ON VIEW vot_candidatos_v1 IS 'v.20101221.1';


--
-- TOC entry 1644 (class 1259 OID 34206)
-- Dependencies: 1797 6
-- Name: vot_candidatos_v2; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW vot_candidatos_v2 AS
    SELECT c.id_candidato, c.id_votacion, c.id_nuip_candidato, c.path_img_candidato, c.orden, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip FROM vot_candidatos c, xcm_nuips n WHERE (c.id_nuip_candidato = n.id_nuip);


ALTER TABLE public.vot_candidatos_v2 OWNER TO dbx_fet;

--
-- TOC entry 1706 (class 1259 OID 37990)
-- Dependencies: 1810 6
-- Name: vot_candidatos_v3; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW vot_candidatos_v3 AS
    SELECT c.id_candidato_plancha, c.id_nuip_candidato, c.orden, c.tipo_candidato, c.id_plancha, CASE WHEN (c.tipo_candidato = 1) THEN 'Principal'::text ELSE 'Suplente'::text END AS maq_tipo_candidato, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip FROM vot_candidatos_plancha c, xcm_nuips n WHERE (c.id_nuip_candidato = n.id_nuip);


ALTER TABLE public.vot_candidatos_v3 OWNER TO dbx_fet;

--
-- TOC entry 2229 (class 0 OID 0)
-- Dependencies: 1706
-- Name: VIEW vot_candidatos_v3; Type: COMMENT; Schema: public; Owner: dbx_fet
--

COMMENT ON VIEW vot_candidatos_v3 IS 'v.20110316.1';


--
-- TOC entry 1707 (class 1259 OID 38002)
-- Dependencies: 1811 6
-- Name: vot_candidatos_v4; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW vot_candidatos_v4 AS
    SELECT c.id_candidato_plancha, c.id_plancha, c.id_nuip_candidato, c.tipo_candidato, c.orden, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip FROM vot_candidatos_plancha c, xcm_nuips n WHERE (c.id_nuip_candidato = n.id_nuip);


ALTER TABLE public.vot_candidatos_v4 OWNER TO dbx_fet;

--
-- TOC entry 2230 (class 0 OID 0)
-- Dependencies: 1707
-- Name: VIEW vot_candidatos_v4; Type: COMMENT; Schema: public; Owner: dbx_fet
--

COMMENT ON VIEW vot_candidatos_v4 IS 'v.20110317.1';


--
-- TOC entry 1645 (class 1259 OID 34210)
-- Dependencies: 2018 6
-- Name: vot_censo_electoral; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE vot_censo_electoral (
    id_censo_electoral bigint NOT NULL,
    id_nuip bigint NOT NULL,
    fec_tx timestamp without time zone DEFAULT now() NOT NULL,
    login_tx character varying(30)
);


ALTER TABLE public.vot_censo_electoral OWNER TO dbx_fet;

--
-- TOC entry 1646 (class 1259 OID 34214)
-- Dependencies: 1645 6
-- Name: vot_censo_electoral_id_censo_electoral_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE vot_censo_electoral_id_censo_electoral_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vot_censo_electoral_id_censo_electoral_seq OWNER TO dbx_fet;

--
-- TOC entry 2231 (class 0 OID 0)
-- Dependencies: 1646
-- Name: vot_censo_electoral_id_censo_electoral_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE vot_censo_electoral_id_censo_electoral_seq OWNED BY vot_censo_electoral.id_censo_electoral;


--
-- TOC entry 2232 (class 0 OID 0)
-- Dependencies: 1646
-- Name: vot_censo_electoral_id_censo_electoral_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('vot_censo_electoral_id_censo_electoral_seq', 23, true);


--
-- TOC entry 1647 (class 1259 OID 34216)
-- Dependencies: 1798 6
-- Name: vot_censo_electoral_v1; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW vot_censo_electoral_v1 AS
    SELECT (ce.fec_tx)::date AS fec_tx, to_char(((ce.fec_tx)::time without time zone)::interval, 'HH12:MI:SS am'::text) AS hor_tx, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, n.nom_empresa FROM vot_censo_electoral ce, xcm_nuips n WHERE (ce.id_nuip = n.id_nuip);


ALTER TABLE public.vot_censo_electoral_v1 OWNER TO dbx_fet;

--
-- TOC entry 1703 (class 1259 OID 37944)
-- Dependencies: 2057 6
-- Name: vot_planchas; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE vot_planchas (
    id_plancha bigint NOT NULL,
    nom_plancha character varying NOT NULL,
    id_votacion integer,
    login_tx character varying(30),
    fec_tx timestamp without time zone DEFAULT now() NOT NULL,
    desc_plancha text
);


ALTER TABLE public.vot_planchas OWNER TO dbx_fet;

--
-- TOC entry 2233 (class 0 OID 0)
-- Dependencies: 1703
-- Name: TABLE vot_planchas; Type: COMMENT; Schema: public; Owner: dbx_fet
--

COMMENT ON TABLE vot_planchas IS 'Definicion de planchas';


--
-- TOC entry 1702 (class 1259 OID 37942)
-- Dependencies: 6 1703
-- Name: vot_planchas_id_plancha_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE vot_planchas_id_plancha_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vot_planchas_id_plancha_seq OWNER TO dbx_fet;

--
-- TOC entry 2234 (class 0 OID 0)
-- Dependencies: 1702
-- Name: vot_planchas_id_plancha_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE vot_planchas_id_plancha_seq OWNED BY vot_planchas.id_plancha;


--
-- TOC entry 2235 (class 0 OID 0)
-- Dependencies: 1702
-- Name: vot_planchas_id_plancha_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('vot_planchas_id_plancha_seq', 28, true);


--
-- TOC entry 1648 (class 1259 OID 34220)
-- Dependencies: 2020 6
-- Name: vot_votaciones_disp; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE vot_votaciones_disp (
    id_votacion_disp bigint NOT NULL,
    id_votacion integer NOT NULL,
    id_nuip bigint NOT NULL,
    fec_tx timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.vot_votaciones_disp OWNER TO dbx_fet;

--
-- TOC entry 1649 (class 1259 OID 34224)
-- Dependencies: 6 1648
-- Name: vot_votaciones_disp_id_votacion_disp_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE vot_votaciones_disp_id_votacion_disp_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vot_votaciones_disp_id_votacion_disp_seq OWNER TO dbx_fet;

--
-- TOC entry 2236 (class 0 OID 0)
-- Dependencies: 1649
-- Name: vot_votaciones_disp_id_votacion_disp_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE vot_votaciones_disp_id_votacion_disp_seq OWNED BY vot_votaciones_disp.id_votacion_disp;


--
-- TOC entry 2237 (class 0 OID 0)
-- Dependencies: 1649
-- Name: vot_votaciones_disp_id_votacion_disp_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('vot_votaciones_disp_id_votacion_disp_seq', 25, true);


--
-- TOC entry 1650 (class 1259 OID 34226)
-- Dependencies: 1638 6
-- Name: vot_votaciones_id_votacion_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE vot_votaciones_id_votacion_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vot_votaciones_id_votacion_seq OWNER TO dbx_fet;

--
-- TOC entry 2238 (class 0 OID 0)
-- Dependencies: 1650
-- Name: vot_votaciones_id_votacion_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE vot_votaciones_id_votacion_seq OWNED BY vot_votaciones.id_votacion;


--
-- TOC entry 2239 (class 0 OID 0)
-- Dependencies: 1650
-- Name: vot_votaciones_id_votacion_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('vot_votaciones_id_votacion_seq', 8, true);


--
-- TOC entry 1651 (class 1259 OID 34228)
-- Dependencies: 2022 6
-- Name: vot_votos; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE vot_votos (
    id_voto bigint NOT NULL,
    id_votacion integer NOT NULL,
    id_nuip_candidato bigint NOT NULL,
    fec_voto timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.vot_votos OWNER TO dbx_fet;

--
-- TOC entry 1652 (class 1259 OID 34232)
-- Dependencies: 1651 6
-- Name: vot_votos_id_voto_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE vot_votos_id_voto_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vot_votos_id_voto_seq OWNER TO dbx_fet;

--
-- TOC entry 2240 (class 0 OID 0)
-- Dependencies: 1652
-- Name: vot_votos_id_voto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE vot_votos_id_voto_seq OWNED BY vot_votos.id_voto;


--
-- TOC entry 2241 (class 0 OID 0)
-- Dependencies: 1652
-- Name: vot_votos_id_voto_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('vot_votos_id_voto_seq', 14, true);


--
-- TOC entry 1709 (class 1259 OID 38008)
-- Dependencies: 2062 6
-- Name: vot_votos_planchas; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE vot_votos_planchas (
    id_voto_plancha bigint NOT NULL,
    id_votacion integer NOT NULL,
    id_plancha bigint NOT NULL,
    fec_voto timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.vot_votos_planchas OWNER TO dbx_fet;

--
-- TOC entry 1708 (class 1259 OID 38006)
-- Dependencies: 6 1709
-- Name: vot_votos_planchas_id_voto_plancha_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE vot_votos_planchas_id_voto_plancha_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vot_votos_planchas_id_voto_plancha_seq OWNER TO dbx_fet;

--
-- TOC entry 2242 (class 0 OID 0)
-- Dependencies: 1708
-- Name: vot_votos_planchas_id_voto_plancha_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE vot_votos_planchas_id_voto_plancha_seq OWNED BY vot_votos_planchas.id_voto_plancha;


--
-- TOC entry 2243 (class 0 OID 0)
-- Dependencies: 1708
-- Name: vot_votos_planchas_id_voto_plancha_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('vot_votos_planchas_id_voto_plancha_seq', 28, true);


--
-- TOC entry 1653 (class 1259 OID 34234)
-- Dependencies: 1799 6
-- Name: vot_votos_v1; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW vot_votos_v1 AS
    SELECT COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, v.id_nuip_candidato, count(*) AS nro_votos, v.id_votacion FROM vot_votos v, xcm_nuips n WHERE (v.id_nuip_candidato = n.id_nuip) GROUP BY v.id_votacion, v.id_nuip_candidato, n.nom_nuip, n.ape_nuip ORDER BY count(*) DESC;


ALTER TABLE public.vot_votos_v1 OWNER TO dbx_fet;

--
-- TOC entry 2244 (class 0 OID 0)
-- Dependencies: 1653
-- Name: VIEW vot_votos_v1; Type: COMMENT; Schema: public; Owner: dbx_fet
--

COMMENT ON VIEW vot_votos_v1 IS 'v.20101227.1';


--
-- TOC entry 1654 (class 1259 OID 34238)
-- Dependencies: 1641 6
-- Name: vota_candidatos_id_candidato_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE vota_candidatos_id_candidato_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vota_candidatos_id_candidato_seq OWNER TO dbx_fet;

--
-- TOC entry 2245 (class 0 OID 0)
-- Dependencies: 1654
-- Name: vota_candidatos_id_candidato_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE vota_candidatos_id_candidato_seq OWNED BY vot_candidatos.id_candidato;


--
-- TOC entry 2246 (class 0 OID 0)
-- Dependencies: 1654
-- Name: vota_candidatos_id_candidato_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('vota_candidatos_id_candidato_seq', 2, true);


--
-- TOC entry 1655 (class 1259 OID 34240)
-- Dependencies: 2024 6
-- Name: xcm_campos_db; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_campos_db (
    nom_esquema character varying NOT NULL,
    nom_tabla character varying NOT NULL,
    nom_columna character varying NOT NULL,
    nom_campo_es character varying,
    desc_campo_es character varying,
    nom_campo_en character varying,
    desc_campo_en character varying,
    nom_fx_valida_js character varying,
    is_nullable boolean DEFAULT false NOT NULL
);


ALTER TABLE public.xcm_campos_db OWNER TO dbx_fet;

--
-- TOC entry 1656 (class 1259 OID 34247)
-- Dependencies: 2025 6
-- Name: xcm_db_departamentos; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_db_departamentos (
    id_depto bigint NOT NULL,
    id_pais bigint NOT NULL,
    cod_interno character varying(30),
    is_activo boolean DEFAULT true NOT NULL,
    orden_db integer,
    nom_depto_es character varying(30) NOT NULL,
    abr_depto_es character varying(8),
    nom_depto_en character varying(30),
    abr_depto_en character varying(8),
    nom_depto_de character varying(30),
    abr_depto_de character varying(8),
    nom_depto_fr character varying(30),
    abr_depto_fr character varying(8)
);


ALTER TABLE public.xcm_db_departamentos OWNER TO dbx_fet;

--
-- TOC entry 2247 (class 0 OID 0)
-- Dependencies: 1656
-- Name: TABLE xcm_db_departamentos; Type: COMMENT; Schema: public; Owner: dbx_fet
--

COMMENT ON TABLE xcm_db_departamentos IS 'Departamentos o Estado en Caso de Otros Paises.';


--
-- TOC entry 1657 (class 1259 OID 34251)
-- Dependencies: 1656 6
-- Name: xcm_db_departamentos_id_depto_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_db_departamentos_id_depto_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_departamentos_id_depto_seq OWNER TO dbx_fet;

--
-- TOC entry 2248 (class 0 OID 0)
-- Dependencies: 1657
-- Name: xcm_db_departamentos_id_depto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_db_departamentos_id_depto_seq OWNED BY xcm_db_departamentos.id_depto;


--
-- TOC entry 2249 (class 0 OID 0)
-- Dependencies: 1657
-- Name: xcm_db_departamentos_id_depto_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_db_departamentos_id_depto_seq', 1, false);


--
-- TOC entry 1658 (class 1259 OID 34253)
-- Dependencies: 2027 6
-- Name: xcm_db_municipios; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_db_municipios (
    id_municipio bigint NOT NULL,
    id_depto bigint NOT NULL,
    is_activo boolean DEFAULT true NOT NULL,
    is_capital_pais boolean,
    is_capital_depto boolean,
    orden_db integer,
    cod_interno character varying(30),
    nom_municipio_es character varying(30) NOT NULL,
    abr_municipio_es character varying(8),
    abr_municipio_fr character varying(8),
    nom_municipio_fr character varying(30),
    abr_municipio_de character varying(8),
    nom_municipio_de character varying(30),
    abr_municipio_en character varying(8),
    nom_municipio_en character varying(30)
);


ALTER TABLE public.xcm_db_municipios OWNER TO dbx_fet;

--
-- TOC entry 1659 (class 1259 OID 34257)
-- Dependencies: 6 1658
-- Name: xcm_db_municipios_id_municipio_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_db_municipios_id_municipio_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_municipios_id_municipio_seq OWNER TO dbx_fet;

--
-- TOC entry 2251 (class 0 OID 0)
-- Dependencies: 1659
-- Name: xcm_db_municipios_id_municipio_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_db_municipios_id_municipio_seq OWNED BY xcm_db_municipios.id_municipio;


--
-- TOC entry 2252 (class 0 OID 0)
-- Dependencies: 1659
-- Name: xcm_db_municipios_id_municipio_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_db_municipios_id_municipio_seq', 1, false);


--
-- TOC entry 1660 (class 1259 OID 34259)
-- Dependencies: 2029 6
-- Name: xcm_db_paises; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_db_paises (
    id_pais bigint NOT NULL,
    orden_db integer,
    nom_pais_es character varying NOT NULL,
    abr_pais_es character varying,
    nom_pais_en character varying,
    abr_pais_en character varying,
    nom_pais_de character varying,
    abr_pais_de character varying,
    nom_pais_fr character varying,
    abr_pais_fr character(1),
    is_activo boolean DEFAULT true NOT NULL,
    cod_interno character varying
);


ALTER TABLE public.xcm_db_paises OWNER TO dbx_fet;

--
-- TOC entry 1661 (class 1259 OID 34266)
-- Dependencies: 6 1660
-- Name: xcm_db_paises_id_pais_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_db_paises_id_pais_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_paises_id_pais_seq OWNER TO dbx_fet;

--
-- TOC entry 2254 (class 0 OID 0)
-- Dependencies: 1661
-- Name: xcm_db_paises_id_pais_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_db_paises_id_pais_seq OWNED BY xcm_db_paises.id_pais;


--
-- TOC entry 2255 (class 0 OID 0)
-- Dependencies: 1661
-- Name: xcm_db_paises_id_pais_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_db_paises_id_pais_seq', 1, false);


--
-- TOC entry 1662 (class 1259 OID 34268)
-- Dependencies: 6
-- Name: xcm_db_sexos; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_db_sexos (
    id_sexo integer NOT NULL,
    orden_db integer,
    nom_sexo_es character varying,
    abr_sexo_es character varying,
    nom_sexo_en character varying,
    abr_sexo_en character varying,
    nom_sexo_de character varying,
    abr_sexo_de character varying,
    nom_sexo_fr character varying,
    abr_sexo_fr character varying,
    is_activo boolean,
    cod_interno character varying
);


ALTER TABLE public.xcm_db_sexos OWNER TO dbx_fet;

--
-- TOC entry 1663 (class 1259 OID 34274)
-- Dependencies: 1662 6
-- Name: xcm_db_sexos_id_sexo_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_db_sexos_id_sexo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_sexos_id_sexo_seq OWNER TO dbx_fet;

--
-- TOC entry 2257 (class 0 OID 0)
-- Dependencies: 1663
-- Name: xcm_db_sexos_id_sexo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_db_sexos_id_sexo_seq OWNED BY xcm_db_sexos.id_sexo;


--
-- TOC entry 2258 (class 0 OID 0)
-- Dependencies: 1663
-- Name: xcm_db_sexos_id_sexo_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_db_sexos_id_sexo_seq', 1, false);


--
-- TOC entry 1664 (class 1259 OID 34276)
-- Dependencies: 2032 6
-- Name: xcm_db_tipos_dir; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_db_tipos_dir (
    id_tipo_dir integer NOT NULL,
    orden_db integer,
    nom_tipo_dir_es character varying,
    abr_tipo_dir_es character varying,
    nom_tipo_dir_en character varying,
    abr_tipo_dir_en character varying,
    nom_tipo_dir_de character varying,
    abr_tipo_dir_de character varying,
    nom_tipo_dir_fr character varying,
    abr_tipo_dir_fr character varying,
    is_activo boolean DEFAULT true NOT NULL,
    cod_interno character varying
);


ALTER TABLE public.xcm_db_tipos_dir OWNER TO dbx_fet;

--
-- TOC entry 1665 (class 1259 OID 34283)
-- Dependencies: 1664 6
-- Name: xcm_db_tipos_dir_id_tipo_dir_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_db_tipos_dir_id_tipo_dir_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_tipos_dir_id_tipo_dir_seq OWNER TO dbx_fet;

--
-- TOC entry 2260 (class 0 OID 0)
-- Dependencies: 1665
-- Name: xcm_db_tipos_dir_id_tipo_dir_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_db_tipos_dir_id_tipo_dir_seq OWNED BY xcm_db_tipos_dir.id_tipo_dir;


--
-- TOC entry 2261 (class 0 OID 0)
-- Dependencies: 1665
-- Name: xcm_db_tipos_dir_id_tipo_dir_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_db_tipos_dir_id_tipo_dir_seq', 1, false);


--
-- TOC entry 1666 (class 1259 OID 34285)
-- Dependencies: 2034 6
-- Name: xcm_db_tipos_nuips; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_db_tipos_nuips (
    id_tipo_nuip integer NOT NULL,
    orden_db integer,
    nom_tipo_nuip_es character varying NOT NULL,
    abr_tipo_nuip_es character varying,
    nom_tipo_nuip_en character varying,
    abr_tipo_nuip_en character varying,
    nom_tipo_nuip_de character varying,
    abr_tipo_nuip_de character varying,
    nom_tipo_nuip_fr character varying,
    abr_tipo_nuip_fr character varying,
    is_activo boolean DEFAULT true NOT NULL,
    cod_interno character varying
);


ALTER TABLE public.xcm_db_tipos_nuips OWNER TO dbx_fet;

--
-- TOC entry 1667 (class 1259 OID 34292)
-- Dependencies: 1666 6
-- Name: xcm_db_tipos_nuips_id_tipo_nuip_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_db_tipos_nuips_id_tipo_nuip_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_tipos_nuips_id_tipo_nuip_seq OWNER TO dbx_fet;

--
-- TOC entry 2263 (class 0 OID 0)
-- Dependencies: 1667
-- Name: xcm_db_tipos_nuips_id_tipo_nuip_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_db_tipos_nuips_id_tipo_nuip_seq OWNED BY xcm_db_tipos_nuips.id_tipo_nuip;


--
-- TOC entry 2264 (class 0 OID 0)
-- Dependencies: 1667
-- Name: xcm_db_tipos_nuips_id_tipo_nuip_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_db_tipos_nuips_id_tipo_nuip_seq', 1, false);


--
-- TOC entry 1668 (class 1259 OID 34294)
-- Dependencies: 6
-- Name: xcm_db_tipos_tel; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_db_tipos_tel (
    id_tipo_tel integer NOT NULL,
    orden_db integer,
    nom_tipo_tel_es character varying,
    abr_tipo_tel_es character varying,
    nom_tipo_tel_en character varying,
    abr_tipo_tel_en character varying,
    nom_tipo_tel_de character varying,
    abr_tipo_tel_de character varying,
    nom_tipo_tel_fr character varying,
    abr_tipo_tel_fr character varying,
    is_activo boolean,
    cod_interno character varying
);


ALTER TABLE public.xcm_db_tipos_tel OWNER TO dbx_fet;

--
-- TOC entry 1669 (class 1259 OID 34300)
-- Dependencies: 6 1668
-- Name: xcm_db_tipos_tel_id_tipo_tel_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_db_tipos_tel_id_tipo_tel_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_tipos_tel_id_tipo_tel_seq OWNER TO dbx_fet;

--
-- TOC entry 2266 (class 0 OID 0)
-- Dependencies: 1669
-- Name: xcm_db_tipos_tel_id_tipo_tel_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_db_tipos_tel_id_tipo_tel_seq OWNED BY xcm_db_tipos_tel.id_tipo_tel;


--
-- TOC entry 2267 (class 0 OID 0)
-- Dependencies: 1669
-- Name: xcm_db_tipos_tel_id_tipo_tel_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_db_tipos_tel_id_tipo_tel_seq', 1, false);


--
-- TOC entry 1670 (class 1259 OID 34302)
-- Dependencies: 6
-- Name: xcm_db_titulos_nuips; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_db_titulos_nuips (
    id_titulo_nuip integer NOT NULL,
    orden_db integer,
    nom_titulo_nuip_es character varying,
    abr_titulo_nuip_es character varying,
    nom_titulo_nuip_en character varying,
    abr_titulo_nuip_en character varying,
    nom_titulo_nuip_de character varying,
    abr_titulo_nuipo_de character varying,
    nom_titulo_nuip_fr character varying,
    abr_titulo_nuip_fr character varying,
    is_activo boolean,
    cod_interno character varying
);


ALTER TABLE public.xcm_db_titulos_nuips OWNER TO dbx_fet;

--
-- TOC entry 1671 (class 1259 OID 34308)
-- Dependencies: 1670 6
-- Name: xcm_db_titulos_nuips_id_titulo_nuip_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_db_titulos_nuips_id_titulo_nuip_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_titulos_nuips_id_titulo_nuip_seq OWNER TO dbx_fet;

--
-- TOC entry 2269 (class 0 OID 0)
-- Dependencies: 1671
-- Name: xcm_db_titulos_nuips_id_titulo_nuip_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_db_titulos_nuips_id_titulo_nuip_seq OWNED BY xcm_db_titulos_nuips.id_titulo_nuip;


--
-- TOC entry 2270 (class 0 OID 0)
-- Dependencies: 1671
-- Name: xcm_db_titulos_nuips_id_titulo_nuip_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_db_titulos_nuips_id_titulo_nuip_seq', 1, false);


--
-- TOC entry 1672 (class 1259 OID 34310)
-- Dependencies: 6
-- Name: xcm_grupos; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_grupos (
    id_grupo bigint NOT NULL,
    id_nuip_serial bigint,
    nom_grupo character varying,
    desc_grupo character varying
);


ALTER TABLE public.xcm_grupos OWNER TO dbx_fet;

--
-- TOC entry 1673 (class 1259 OID 34316)
-- Dependencies: 6 1672
-- Name: xcm_grupos_id_grupo_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_grupos_id_grupo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_grupos_id_grupo_seq OWNER TO dbx_fet;

--
-- TOC entry 2272 (class 0 OID 0)
-- Dependencies: 1673
-- Name: xcm_grupos_id_grupo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_grupos_id_grupo_seq OWNED BY xcm_grupos.id_grupo;


--
-- TOC entry 2273 (class 0 OID 0)
-- Dependencies: 1673
-- Name: xcm_grupos_id_grupo_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_grupos_id_grupo_seq', 1, true);


--
-- TOC entry 1674 (class 1259 OID 34318)
-- Dependencies: 2039 2040 6
-- Name: xcm_grupos_permisos; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_grupos_permisos (
    id_grupo_permiso bigint NOT NULL,
    id_grupo bigint NOT NULL,
    id_permiso character varying NOT NULL,
    fec_tx timestamp without time zone DEFAULT '2008-09-24 08:40:40.471'::timestamp without time zone NOT NULL,
    login_admin character varying(30) DEFAULT "current_user"()
);


ALTER TABLE public.xcm_grupos_permisos OWNER TO dbx_fet;

--
-- TOC entry 1675 (class 1259 OID 34326)
-- Dependencies: 6 1674
-- Name: xcm_grupos_permisos_id_grupo_permiso_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_grupos_permisos_id_grupo_permiso_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_grupos_permisos_id_grupo_permiso_seq OWNER TO dbx_fet;

--
-- TOC entry 2275 (class 0 OID 0)
-- Dependencies: 1675
-- Name: xcm_grupos_permisos_id_grupo_permiso_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_grupos_permisos_id_grupo_permiso_seq OWNED BY xcm_grupos_permisos.id_grupo_permiso;


--
-- TOC entry 2276 (class 0 OID 0)
-- Dependencies: 1675
-- Name: xcm_grupos_permisos_id_grupo_permiso_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_grupos_permisos_id_grupo_permiso_seq', 1, false);


--
-- TOC entry 1676 (class 1259 OID 34328)
-- Dependencies: 1800 6
-- Name: xcm_grupos_v1; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW xcm_grupos_v1 AS
    SELECT g.id_grupo, g.nom_grupo, g.desc_grupo, g.id_nuip_serial, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip FROM (xcm_grupos g LEFT JOIN xcm_nuips n ON ((g.id_nuip_serial = n.id_nuip_serial)));


ALTER TABLE public.xcm_grupos_v1 OWNER TO dbx_fet;

--
-- TOC entry 1677 (class 1259 OID 34332)
-- Dependencies: 1801 6
-- Name: xcm_municipios_deptos_paises_v1; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW xcm_municipios_deptos_paises_v1 AS
    SELECT db_m.id_municipio, db_m.nom_municipio_es, db_d.nom_depto_es, db_p.nom_pais_es FROM xcm_db_municipios db_m, xcm_db_departamentos db_d, xcm_db_paises db_p WHERE ((db_m.id_depto = db_d.id_depto) AND (db_d.id_pais = db_p.id_pais));


ALTER TABLE public.xcm_municipios_deptos_paises_v1 OWNER TO dbx_fet;

--
-- TOC entry 1678 (class 1259 OID 34336)
-- Dependencies: 2042 6
-- Name: xcm_niveles_usuario; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_niveles_usuario (
    id_nivel_usuario smallint DEFAULT (0)::smallint NOT NULL,
    nom_nivel_usuario character varying NOT NULL
);


ALTER TABLE public.xcm_niveles_usuario OWNER TO dbx_fet;

--
-- TOC entry 1679 (class 1259 OID 34343)
-- Dependencies: 6
-- Name: xcm_nuips_dirs; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_nuips_dirs (
    id_nuip_dir bigint NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_tipo_dir integer,
    dir text NOT NULL,
    id_municipio bigint
);


ALTER TABLE public.xcm_nuips_dirs OWNER TO dbx_fet;

--
-- TOC entry 1680 (class 1259 OID 34349)
-- Dependencies: 1679 6
-- Name: xcm_nuips_dirs_id_nuip_dir_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_nuips_dirs_id_nuip_dir_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_nuips_dirs_id_nuip_dir_seq OWNER TO dbx_fet;

--
-- TOC entry 2278 (class 0 OID 0)
-- Dependencies: 1680
-- Name: xcm_nuips_dirs_id_nuip_dir_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_nuips_dirs_id_nuip_dir_seq OWNED BY xcm_nuips_dirs.id_nuip_dir;


--
-- TOC entry 2279 (class 0 OID 0)
-- Dependencies: 1680
-- Name: xcm_nuips_dirs_id_nuip_dir_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_nuips_dirs_id_nuip_dir_seq', 1, true);


--
-- TOC entry 1681 (class 1259 OID 34351)
-- Dependencies: 1802 6
-- Name: xcm_nuips_dirs_v1; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW xcm_nuips_dirs_v1 AS
    SELECT n.id_nuip_serial, n.id_nuip, n.nom_nuip, n.ape_nuip, nt.dir, nt.id_nuip_dir, nt.id_municipio, dtt.id_tipo_dir, dtt.nom_tipo_dir_es, dtt.abr_tipo_dir_es, mun.nom_municipio_es FROM (((xcm_nuips_dirs nt LEFT JOIN xcm_nuips n ON ((nt.id_nuip_serial = n.id_nuip_serial))) LEFT JOIN xcm_db_municipios mun ON ((nt.id_municipio = mun.id_municipio))) LEFT JOIN xcm_db_tipos_dir dtt ON ((nt.id_tipo_dir = dtt.id_tipo_dir)));


ALTER TABLE public.xcm_nuips_dirs_v1 OWNER TO dbx_fet;

--
-- TOC entry 1682 (class 1259 OID 34356)
-- Dependencies: 6
-- Name: xcm_nuips_emails; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_nuips_emails (
    id_nuip_email bigint NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_tipo_dir integer,
    email character varying NOT NULL
);


ALTER TABLE public.xcm_nuips_emails OWNER TO dbx_fet;

--
-- TOC entry 1683 (class 1259 OID 34362)
-- Dependencies: 1682 6
-- Name: xcm_nuips_emails_id_nuip_email_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_nuips_emails_id_nuip_email_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_nuips_emails_id_nuip_email_seq OWNER TO dbx_fet;

--
-- TOC entry 2281 (class 0 OID 0)
-- Dependencies: 1683
-- Name: xcm_nuips_emails_id_nuip_email_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_nuips_emails_id_nuip_email_seq OWNED BY xcm_nuips_emails.id_nuip_email;


--
-- TOC entry 2282 (class 0 OID 0)
-- Dependencies: 1683
-- Name: xcm_nuips_emails_id_nuip_email_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_nuips_emails_id_nuip_email_seq', 5, true);


--
-- TOC entry 1684 (class 1259 OID 34364)
-- Dependencies: 1803 6
-- Name: xcm_nuips_emails_v1; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW xcm_nuips_emails_v1 AS
    SELECT n.id_nuip_serial, n.id_nuip, n.nom_nuip, n.ape_nuip, nt.email, nt.id_nuip_email, dtt.id_tipo_dir, dtt.nom_tipo_dir_es, dtt.abr_tipo_dir_es FROM ((xcm_nuips_emails nt LEFT JOIN xcm_nuips n ON ((nt.id_nuip_serial = n.id_nuip_serial))) LEFT JOIN xcm_db_tipos_dir dtt ON ((nt.id_tipo_dir = dtt.id_tipo_dir)));


ALTER TABLE public.xcm_nuips_emails_v1 OWNER TO dbx_fet;

--
-- TOC entry 1685 (class 1259 OID 34369)
-- Dependencies: 6
-- Name: xcm_nuips_grupos; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_nuips_grupos (
    id_nuip_grupo bigint NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_grupo bigint NOT NULL
);


ALTER TABLE public.xcm_nuips_grupos OWNER TO dbx_fet;

--
-- TOC entry 1686 (class 1259 OID 34372)
-- Dependencies: 6 1685
-- Name: xcm_nuips_grupos_id_nuip_grupo_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_nuips_grupos_id_nuip_grupo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_nuips_grupos_id_nuip_grupo_seq OWNER TO dbx_fet;

--
-- TOC entry 2284 (class 0 OID 0)
-- Dependencies: 1686
-- Name: xcm_nuips_grupos_id_nuip_grupo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_nuips_grupos_id_nuip_grupo_seq OWNED BY xcm_nuips_grupos.id_nuip_grupo;


--
-- TOC entry 2285 (class 0 OID 0)
-- Dependencies: 1686
-- Name: xcm_nuips_grupos_id_nuip_grupo_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_nuips_grupos_id_nuip_grupo_seq', 4143, true);


--
-- TOC entry 1687 (class 1259 OID 34374)
-- Dependencies: 1804 6
-- Name: xcm_nuips_grupos_v1; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW xcm_nuips_grupos_v1 AS
    SELECT COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, g.nom_grupo AS maq_nom_grupo, ng.id_grupo, n.id_nuip, n.digito_verif, tn.abr_tipo_nuip_es, n.nom_nuip, n.ape_nuip, (n.fec_nacimiento)::date AS fec_nacimiento, s.nom_sexo_es, ttn.nom_titulo_nuip_es, n.nom_empresa, n.nom_contacto, n.notas, n.id_nuip_serial, n.id_tipo_nuip, n.id_sexo, n.id_titulo_nuip FROM (((((xcm_nuips n LEFT JOIN xcm_db_tipos_nuips tn ON ((n.id_tipo_nuip = tn.id_tipo_nuip))) LEFT JOIN xcm_db_sexos s ON ((n.id_sexo = s.id_sexo))) LEFT JOIN xcm_db_titulos_nuips ttn ON ((n.id_titulo_nuip = ttn.id_titulo_nuip))) LEFT JOIN xcm_nuips_grupos ng ON ((n.id_nuip_serial = ng.id_nuip_serial))) LEFT JOIN xcm_grupos g ON ((ng.id_grupo = g.id_grupo)));


ALTER TABLE public.xcm_nuips_grupos_v1 OWNER TO dbx_fet;

--
-- TOC entry 1688 (class 1259 OID 34379)
-- Dependencies: 1642 6
-- Name: xcm_nuips_id_nuip_serial_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_nuips_id_nuip_serial_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_nuips_id_nuip_serial_seq OWNER TO dbx_fet;

--
-- TOC entry 2287 (class 0 OID 0)
-- Dependencies: 1688
-- Name: xcm_nuips_id_nuip_serial_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_nuips_id_nuip_serial_seq OWNED BY xcm_nuips.id_nuip_serial;


--
-- TOC entry 2288 (class 0 OID 0)
-- Dependencies: 1688
-- Name: xcm_nuips_id_nuip_serial_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_nuips_id_nuip_serial_seq', 581, true);


--
-- TOC entry 1689 (class 1259 OID 34381)
-- Dependencies: 6
-- Name: xcm_nuips_tels; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_nuips_tels (
    id_nuip_tel bigint NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_tipo_tel integer NOT NULL,
    tel text NOT NULL
);


ALTER TABLE public.xcm_nuips_tels OWNER TO dbx_fet;

--
-- TOC entry 1690 (class 1259 OID 34387)
-- Dependencies: 1689 6
-- Name: xcm_nuips_tels_id_nuip_tel_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_nuips_tels_id_nuip_tel_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_nuips_tels_id_nuip_tel_seq OWNER TO dbx_fet;

--
-- TOC entry 2290 (class 0 OID 0)
-- Dependencies: 1690
-- Name: xcm_nuips_tels_id_nuip_tel_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_nuips_tels_id_nuip_tel_seq OWNED BY xcm_nuips_tels.id_nuip_tel;


--
-- TOC entry 2291 (class 0 OID 0)
-- Dependencies: 1690
-- Name: xcm_nuips_tels_id_nuip_tel_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_nuips_tels_id_nuip_tel_seq', 1, true);


--
-- TOC entry 1691 (class 1259 OID 34389)
-- Dependencies: 1805 6
-- Name: xcm_nuips_tels_v1; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW xcm_nuips_tels_v1 AS
    SELECT n.id_nuip_serial, n.id_nuip, n.nom_nuip, n.ape_nuip, nt.id_nuip_tel, nt.tel, dtt.id_tipo_tel, dtt.nom_tipo_tel_es, dtt.abr_tipo_tel_es FROM ((xcm_nuips_tels nt LEFT JOIN xcm_nuips n ON ((nt.id_nuip_serial = n.id_nuip_serial))) LEFT JOIN xcm_db_tipos_tel dtt ON ((nt.id_tipo_tel = dtt.id_tipo_tel)));


ALTER TABLE public.xcm_nuips_tels_v1 OWNER TO dbx_fet;

--
-- TOC entry 1692 (class 1259 OID 34394)
-- Dependencies: 1806 6
-- Name: xcm_nuips_v1; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW xcm_nuips_v1 AS
    SELECT COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, n.id_nuip, n.nom_nuip, n.ape_nuip, n.fec_nacimiento, s.nom_sexo_es, ttn.nom_titulo_nuip_es, n.nom_empresa, n.nom_contacto, n.notas, n.id_nuip_serial, n.id_tipo_nuip, n.id_sexo, n.id_titulo_nuip FROM (((xcm_nuips n LEFT JOIN xcm_db_tipos_nuips tn ON ((n.id_tipo_nuip = tn.id_tipo_nuip))) LEFT JOIN xcm_db_sexos s ON ((n.id_sexo = s.id_sexo))) LEFT JOIN xcm_db_titulos_nuips ttn ON ((n.id_titulo_nuip = ttn.id_titulo_nuip)));


ALTER TABLE public.xcm_nuips_v1 OWNER TO dbx_fet;

--
-- TOC entry 1693 (class 1259 OID 34399)
-- Dependencies: 2047 6
-- Name: xcm_permisos; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_permisos (
    id_permiso character varying NOT NULL,
    id_padre character varying,
    nom_permiso character varying NOT NULL,
    desc_permiso text,
    nro_nivel smallint,
    is_folder boolean DEFAULT false NOT NULL,
    onchange character varying
);


ALTER TABLE public.xcm_permisos OWNER TO dbx_fet;

--
-- TOC entry 1694 (class 1259 OID 34406)
-- Dependencies: 2048 2049 2050 2051 2052 6
-- Name: xcm_usuarios; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_usuarios (
    login character varying(30) NOT NULL,
    passwd character varying NOT NULL,
    id_nivel_usuario integer DEFAULT 1 NOT NULL,
    id_nuip_serial bigint NOT NULL,
    fec_creacion timestamp without time zone DEFAULT '2009-01-01 00:00:00'::timestamp without time zone NOT NULL,
    is_activo boolean DEFAULT true NOT NULL,
    cant_sesiones_max smallint DEFAULT (1)::smallint NOT NULL,
    cant_sesiones smallint DEFAULT (0)::smallint NOT NULL
);


ALTER TABLE public.xcm_usuarios OWNER TO dbx_fet;

--
-- TOC entry 1695 (class 1259 OID 34417)
-- Dependencies: 6
-- Name: xcm_usuarios_grupos; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_usuarios_grupos (
    id_usuario_grupo bigint NOT NULL,
    login character varying(30) NOT NULL,
    id_grupo bigint NOT NULL
);


ALTER TABLE public.xcm_usuarios_grupos OWNER TO dbx_fet;

--
-- TOC entry 1696 (class 1259 OID 34420)
-- Dependencies: 6 1695
-- Name: xcm_usuarios_grupos_id_usuario_grupo_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_usuarios_grupos_id_usuario_grupo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_usuarios_grupos_id_usuario_grupo_seq OWNER TO dbx_fet;

--
-- TOC entry 2293 (class 0 OID 0)
-- Dependencies: 1696
-- Name: xcm_usuarios_grupos_id_usuario_grupo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_usuarios_grupos_id_usuario_grupo_seq OWNED BY xcm_usuarios_grupos.id_usuario_grupo;


--
-- TOC entry 2294 (class 0 OID 0)
-- Dependencies: 1696
-- Name: xcm_usuarios_grupos_id_usuario_grupo_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_usuarios_grupos_id_usuario_grupo_seq', 6, true);


--
-- TOC entry 1697 (class 1259 OID 34422)
-- Dependencies: 1807 6
-- Name: xcm_usuarios_grupos_nuips_v1; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW xcm_usuarios_grupos_nuips_v1 AS
    SELECT DISTINCT u.login, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, n.id_nuip, n.id_nuip_serial, COALESCE(ug.id_grupo, ng.id_grupo) AS id_grupo, u.id_nivel_usuario FROM (xcm_usuarios u LEFT JOIN xcm_usuarios_grupos ug ON (((ug.login)::text = (u.login)::text))), xcm_nuips n, xcm_nuips_grupos ng WHERE ((u.id_nuip_serial = n.id_nuip_serial) AND (n.id_nuip_serial = ng.id_nuip_serial)) ORDER BY u.login, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)), COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip), n.id_nuip, n.id_nuip_serial, COALESCE(ug.id_grupo, ng.id_grupo), u.id_nivel_usuario;


ALTER TABLE public.xcm_usuarios_grupos_nuips_v1 OWNER TO dbx_fet;

--
-- TOC entry 1698 (class 1259 OID 34427)
-- Dependencies: 1808 6
-- Name: xcm_usuarios_grupos_v1; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW xcm_usuarios_grupos_v1 AS
    SELECT ug.id_usuario_grupo, ug.login, g.nom_grupo, g.id_grupo FROM xcm_usuarios_grupos ug, xcm_grupos g WHERE (ug.id_grupo = g.id_grupo);


ALTER TABLE public.xcm_usuarios_grupos_v1 OWNER TO dbx_fet;

--
-- TOC entry 1699 (class 1259 OID 34431)
-- Dependencies: 2054 6
-- Name: xcm_usuarios_permisos; Type: TABLE; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE TABLE xcm_usuarios_permisos (
    id_usuario_permiso bigint NOT NULL,
    login character varying(30) NOT NULL,
    id_permiso character varying NOT NULL,
    fec_tx timestamp without time zone DEFAULT (now())::timestamp without time zone NOT NULL,
    login_admin character varying(30) NOT NULL
);


ALTER TABLE public.xcm_usuarios_permisos OWNER TO dbx_fet;

--
-- TOC entry 1700 (class 1259 OID 34438)
-- Dependencies: 6 1699
-- Name: xcm_usuarios_permisos_id_usuario_permiso_seq; Type: SEQUENCE; Schema: public; Owner: dbx_fet
--

CREATE SEQUENCE xcm_usuarios_permisos_id_usuario_permiso_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_usuarios_permisos_id_usuario_permiso_seq OWNER TO dbx_fet;

--
-- TOC entry 2296 (class 0 OID 0)
-- Dependencies: 1700
-- Name: xcm_usuarios_permisos_id_usuario_permiso_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbx_fet
--

ALTER SEQUENCE xcm_usuarios_permisos_id_usuario_permiso_seq OWNED BY xcm_usuarios_permisos.id_usuario_permiso;


--
-- TOC entry 2297 (class 0 OID 0)
-- Dependencies: 1700
-- Name: xcm_usuarios_permisos_id_usuario_permiso_seq; Type: SEQUENCE SET; Schema: public; Owner: dbx_fet
--

SELECT pg_catalog.setval('xcm_usuarios_permisos_id_usuario_permiso_seq', 41, true);


--
-- TOC entry 1701 (class 1259 OID 34440)
-- Dependencies: 1809 6
-- Name: xcm_usuarios_v1; Type: VIEW; Schema: public; Owner: dbx_fet
--

CREATE VIEW xcm_usuarios_v1 AS
    SELECT u.login, u.passwd, u.id_nivel_usuario, u.id_nuip_serial, u.fec_creacion, u.is_activo, u.cant_sesiones_max, u.cant_sesiones, n.id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip FROM (xcm_usuarios u LEFT JOIN xcm_nuips n ON ((u.id_nuip_serial = n.id_nuip_serial)));


ALTER TABLE public.xcm_usuarios_v1 OWNER TO dbx_fet;

--
-- TOC entry 2015 (class 2604 OID 34444)
-- Dependencies: 1654 1641
-- Name: id_candidato; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE vot_candidatos ALTER COLUMN id_candidato SET DEFAULT nextval('vota_candidatos_id_candidato_seq'::regclass);


--
-- TOC entry 2058 (class 2604 OID 37963)
-- Dependencies: 1704 1705 1705
-- Name: id_candidato_plancha; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE vot_candidatos_plancha ALTER COLUMN id_candidato_plancha SET DEFAULT nextval('vot_candidatos_plancha_id_candidato_plancha_seq'::regclass);


--
-- TOC entry 2019 (class 2604 OID 34445)
-- Dependencies: 1646 1645
-- Name: id_censo_electoral; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE vot_censo_electoral ALTER COLUMN id_censo_electoral SET DEFAULT nextval('vot_censo_electoral_id_censo_electoral_seq'::regclass);


--
-- TOC entry 2056 (class 2604 OID 37947)
-- Dependencies: 1702 1703 1703
-- Name: id_plancha; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE vot_planchas ALTER COLUMN id_plancha SET DEFAULT nextval('vot_planchas_id_plancha_seq'::regclass);


--
-- TOC entry 2010 (class 2604 OID 34446)
-- Dependencies: 1650 1638
-- Name: id_votacion; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE vot_votaciones ALTER COLUMN id_votacion SET DEFAULT nextval('vot_votaciones_id_votacion_seq'::regclass);


--
-- TOC entry 2021 (class 2604 OID 34447)
-- Dependencies: 1649 1648
-- Name: id_votacion_disp; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE vot_votaciones_disp ALTER COLUMN id_votacion_disp SET DEFAULT nextval('vot_votaciones_disp_id_votacion_disp_seq'::regclass);


--
-- TOC entry 2023 (class 2604 OID 34448)
-- Dependencies: 1652 1651
-- Name: id_voto; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE vot_votos ALTER COLUMN id_voto SET DEFAULT nextval('vot_votos_id_voto_seq'::regclass);


--
-- TOC entry 2061 (class 2604 OID 38011)
-- Dependencies: 1708 1709 1709
-- Name: id_voto_plancha; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE vot_votos_planchas ALTER COLUMN id_voto_plancha SET DEFAULT nextval('vot_votos_planchas_id_voto_plancha_seq'::regclass);


--
-- TOC entry 2026 (class 2604 OID 34449)
-- Dependencies: 1657 1656
-- Name: id_depto; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_db_departamentos ALTER COLUMN id_depto SET DEFAULT nextval('xcm_db_departamentos_id_depto_seq'::regclass);


--
-- TOC entry 2028 (class 2604 OID 34450)
-- Dependencies: 1659 1658
-- Name: id_municipio; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_db_municipios ALTER COLUMN id_municipio SET DEFAULT nextval('xcm_db_municipios_id_municipio_seq'::regclass);


--
-- TOC entry 2030 (class 2604 OID 34451)
-- Dependencies: 1661 1660
-- Name: id_pais; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_db_paises ALTER COLUMN id_pais SET DEFAULT nextval('xcm_db_paises_id_pais_seq'::regclass);


--
-- TOC entry 2031 (class 2604 OID 34452)
-- Dependencies: 1663 1662
-- Name: id_sexo; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_db_sexos ALTER COLUMN id_sexo SET DEFAULT nextval('xcm_db_sexos_id_sexo_seq'::regclass);


--
-- TOC entry 2033 (class 2604 OID 34453)
-- Dependencies: 1665 1664
-- Name: id_tipo_dir; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_db_tipos_dir ALTER COLUMN id_tipo_dir SET DEFAULT nextval('xcm_db_tipos_dir_id_tipo_dir_seq'::regclass);


--
-- TOC entry 2035 (class 2604 OID 34454)
-- Dependencies: 1667 1666
-- Name: id_tipo_nuip; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_db_tipos_nuips ALTER COLUMN id_tipo_nuip SET DEFAULT nextval('xcm_db_tipos_nuips_id_tipo_nuip_seq'::regclass);


--
-- TOC entry 2036 (class 2604 OID 34455)
-- Dependencies: 1669 1668
-- Name: id_tipo_tel; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_db_tipos_tel ALTER COLUMN id_tipo_tel SET DEFAULT nextval('xcm_db_tipos_tel_id_tipo_tel_seq'::regclass);


--
-- TOC entry 2037 (class 2604 OID 34456)
-- Dependencies: 1671 1670
-- Name: id_titulo_nuip; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_db_titulos_nuips ALTER COLUMN id_titulo_nuip SET DEFAULT nextval('xcm_db_titulos_nuips_id_titulo_nuip_seq'::regclass);


--
-- TOC entry 2038 (class 2604 OID 34457)
-- Dependencies: 1673 1672
-- Name: id_grupo; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_grupos ALTER COLUMN id_grupo SET DEFAULT nextval('xcm_grupos_id_grupo_seq'::regclass);


--
-- TOC entry 2041 (class 2604 OID 34458)
-- Dependencies: 1675 1674
-- Name: id_grupo_permiso; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_grupos_permisos ALTER COLUMN id_grupo_permiso SET DEFAULT nextval('xcm_grupos_permisos_id_grupo_permiso_seq'::regclass);


--
-- TOC entry 2017 (class 2604 OID 34459)
-- Dependencies: 1688 1642
-- Name: id_nuip_serial; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_nuips ALTER COLUMN id_nuip_serial SET DEFAULT nextval('xcm_nuips_id_nuip_serial_seq'::regclass);


--
-- TOC entry 2043 (class 2604 OID 34460)
-- Dependencies: 1680 1679
-- Name: id_nuip_dir; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_nuips_dirs ALTER COLUMN id_nuip_dir SET DEFAULT nextval('xcm_nuips_dirs_id_nuip_dir_seq'::regclass);


--
-- TOC entry 2044 (class 2604 OID 34461)
-- Dependencies: 1683 1682
-- Name: id_nuip_email; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_nuips_emails ALTER COLUMN id_nuip_email SET DEFAULT nextval('xcm_nuips_emails_id_nuip_email_seq'::regclass);


--
-- TOC entry 2045 (class 2604 OID 34462)
-- Dependencies: 1686 1685
-- Name: id_nuip_grupo; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_nuips_grupos ALTER COLUMN id_nuip_grupo SET DEFAULT nextval('xcm_nuips_grupos_id_nuip_grupo_seq'::regclass);


--
-- TOC entry 2046 (class 2604 OID 34463)
-- Dependencies: 1690 1689
-- Name: id_nuip_tel; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_nuips_tels ALTER COLUMN id_nuip_tel SET DEFAULT nextval('xcm_nuips_tels_id_nuip_tel_seq'::regclass);


--
-- TOC entry 2053 (class 2604 OID 34464)
-- Dependencies: 1696 1695
-- Name: id_usuario_grupo; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_usuarios_grupos ALTER COLUMN id_usuario_grupo SET DEFAULT nextval('xcm_usuarios_grupos_id_usuario_grupo_seq'::regclass);


--
-- TOC entry 2055 (class 2604 OID 34465)
-- Dependencies: 1700 1699
-- Name: id_usuario_permiso; Type: DEFAULT; Schema: public; Owner: dbx_fet
--

ALTER TABLE xcm_usuarios_permisos ALTER COLUMN id_usuario_permiso SET DEFAULT nextval('xcm_usuarios_permisos_id_usuario_permiso_seq'::regclass);


--
-- TOC entry 2188 (class 0 OID 34180)
-- Dependencies: 1640
-- Data for Name: tmp_nuips; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--



--
-- TOC entry 2189 (class 0 OID 34187)
-- Dependencies: 1641
-- Data for Name: vot_candidatos; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--



--
-- TOC entry 2215 (class 0 OID 37960)
-- Dependencies: 1705
-- Data for Name: vot_candidatos_plancha; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (36, 22, 8704121, 2, 2, '2011-03-22 14:47:58.238809', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (31, 22, 41616658, 1, 1, '2011-03-22 14:46:28.344021', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (30, 21, 41425786, 10, 2, '2011-03-22 14:45:55.238365', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (25, 21, 19274038, 9, 1, '2011-03-22 14:44:54.97742', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (21, 21, 19306781, 1, 1, '2011-03-22 14:43:52.177031', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (26, 21, 19101314, 2, 2, '2011-03-22 14:45:12.177228', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (27, 21, 39707178, 4, 2, '2011-03-22 14:45:24.473448', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (22, 21, 43610032, 3, 1, '2011-03-22 14:44:09.26577', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (29, 21, 51766056, 8, 2, '2011-03-22 14:45:40.637356', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (46, 23, 19275648, 6, 2, '2011-03-22 14:52:11.188238', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (43, 23, 52260202, 5, 1, '2011-03-22 14:51:39.417421', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (40, 22, 79295077, 10, 2, '2011-03-22 14:48:37.774849', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (45, 23, 79881246, 4, 2, '2011-03-22 14:52:03.979285', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (44, 23, 79244729, 2, 2, '2011-03-22 14:51:49.665501', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (42, 23, 79416100, 3, 1, '2011-03-22 14:51:30.764733', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (35, 22, 17173455, 9, 1, '2011-03-22 14:47:44.657535', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (41, 23, 79145249, 1, 1, '2011-03-22 14:51:21.448722', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (39, 22, 51697980, 8, 2, '2011-03-22 14:48:29.608404', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (24, 21, 8697397, 7, 1, '2011-03-22 14:44:44.576832', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (28, 21, 35462539, 6, 2, '2011-03-22 14:45:32.597291', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (38, 22, 79285494, 6, 2, '2011-03-22 14:48:19.114893', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (34, 22, 19257991, 7, 1, '2011-03-22 14:47:33.194787', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (23, 21, 79755282, 5, 1, '2011-03-22 14:44:26.003647', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (33, 22, 79303522, 5, 1, '2011-03-22 14:47:22.809125', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (37, 22, 79456584, 4, 2, '2011-03-22 14:48:05.208118', 'dbxdba');
INSERT INTO vot_candidatos_plancha (id_candidato_plancha, id_plancha, id_nuip_candidato, orden, tipo_candidato, fec_tx, login_tx) VALUES (32, 22, 51802909, 3, 1, '2011-03-22 14:47:13.189599', 'dbxdba');


--
-- TOC entry 2191 (class 0 OID 34210)
-- Dependencies: 1645
-- Data for Name: vot_censo_electoral; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--



--
-- TOC entry 2214 (class 0 OID 37944)
-- Dependencies: 1703
-- Data for Name: vot_planchas; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO vot_planchas (id_plancha, nom_plancha, id_votacion, login_tx, fec_tx, desc_plancha) VALUES (22, 'PLANCHA 2', 7, 'dbxdba', '2011-03-22 14:46:08.899724', NULL);
INSERT INTO vot_planchas (id_plancha, nom_plancha, id_votacion, login_tx, fec_tx, desc_plancha) VALUES (23, 'PLANCHA UNICA', 6, 'dbxdba', '2011-03-22 14:51:08.777474', NULL);
INSERT INTO vot_planchas (id_plancha, nom_plancha, id_votacion, login_tx, fec_tx, desc_plancha) VALUES (0, 'VOTO EN BLANCO', NULL, 'dbxdba', '2011-03-22 15:01:38.091415', NULL);
INSERT INTO vot_planchas (id_plancha, nom_plancha, id_votacion, login_tx, fec_tx, desc_plancha) VALUES (21, 'PLANCHA 1', 7, 'dbxdba', '2011-03-23 17:33:41.393433', NULL);
INSERT INTO vot_planchas (id_plancha, nom_plancha, id_votacion, login_tx, fec_tx, desc_plancha) VALUES (25, '1 - SANDHER AUDITING – JOSE MIGUEL SANDOVAL', 8, 'admin', '2011-03-24 09:07:30.59496', '$ 1’716.800 (60 HORAS MENSUALES) 35 años de experiencia en: Cooperativa Texas - Fondo de Empleados Tadeístas y Fondeloitte entre otras.');
INSERT INTO vot_planchas (id_plancha, nom_plancha, id_votacion, login_tx, fec_tx, desc_plancha) VALUES (28, '4 - FUNSERVICOOP', 8, 'admin', '2011-03-24 09:10:03.066882', '$ 1’067.200 (45 HORAS MENSUALES) 11 años de experiencia en: F.E. Granforndo – F.E. Club Militar – F.E. Abbott entre otros.');
INSERT INTO vot_planchas (id_plancha, nom_plancha, id_votacion, login_tx, fec_tx, desc_plancha) VALUES (27, '3 - DIANA MARIA NARANJO', 8, 'admin', '2011-03-24 09:08:47.392909', '$ 1.500.000 (60 HORAS MENSUALES) 10 años de experiencia en: F.E. Cablecentro – Cable Bello television - F.E. Sanford entre otros');
INSERT INTO vot_planchas (id_plancha, nom_plancha, id_votacion, login_tx, fec_tx, desc_plancha) VALUES (26, '2 - REVISAR AUDITORES LTDA', 8, 'admin', '2011-03-24 09:08:10.964904', '$ 974.000 (46 HORAS MENSUALES) 10 años de experiencia en: F. E. Caracol – F.E Ingeominas – F.E. Telmex entre otros');


--
-- TOC entry 2187 (class 0 OID 34164)
-- Dependencies: 1638
-- Data for Name: vot_votaciones; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO vot_votaciones (id_votacion, nom_votacion, desc_votacion, fec_ini, fec_fin, login_tx, fec_tx, cant_opciones, is_voto_blanco, orden_db, is_salida_sin_votar, is_plancha) VALUES (7, 'JUNTA DIRECTIVA 2011', NULL, '2011-03-22 00:00:00', '2011-03-31 00:00:00', 'dbxdba', '2011-03-23 17:28:15.458133', 1, true, 1, true, true);
INSERT INTO vot_votaciones (id_votacion, nom_votacion, desc_votacion, fec_ini, fec_fin, login_tx, fec_tx, cant_opciones, is_voto_blanco, orden_db, is_salida_sin_votar, is_plancha) VALUES (6, 'COMITE DE CONTROL SOCIAL 2011', NULL, '2011-03-22 00:00:00', '2011-03-31 00:00:00', 'dbxdba', '2011-03-23 17:56:27.586911', 1, true, 2, true, true);
INSERT INTO vot_votaciones (id_votacion, nom_votacion, desc_votacion, fec_ini, fec_fin, login_tx, fec_tx, cant_opciones, is_voto_blanco, orden_db, is_salida_sin_votar, is_plancha) VALUES (8, 'REVISORIA FISCAL 2011', NULL, '2011-03-22 00:00:00', '2011-03-31 00:00:00', 'dbxdba', '2011-03-23 17:56:35.685094', 1, true, 0, true, true);


--
-- TOC entry 2192 (class 0 OID 34220)
-- Dependencies: 1648
-- Data for Name: vot_votaciones_disp; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--



--
-- TOC entry 2193 (class 0 OID 34228)
-- Dependencies: 1651
-- Data for Name: vot_votos; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--



--
-- TOC entry 2216 (class 0 OID 38008)
-- Dependencies: 1709
-- Data for Name: vot_votos_planchas; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--



--
-- TOC entry 2194 (class 0 OID 34240)
-- Dependencies: 1655
-- Data for Name: xcm_campos_db; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_campos_db (nom_esquema, nom_tabla, nom_columna, nom_campo_es, desc_campo_es, nom_campo_en, desc_campo_en, nom_fx_valida_js, is_nullable) VALUES ('public', 'vot_censo_electoral_v1', 'maq_id_nuip', 'Nuip', 'Numero de Identificacion', NULL, NULL, NULL, false);
INSERT INTO xcm_campos_db (nom_esquema, nom_tabla, nom_columna, nom_campo_es, desc_campo_es, nom_campo_en, desc_campo_en, nom_fx_valida_js, is_nullable) VALUES ('public', 'vot_censo_electoral_v1', 'maq_nom_nuip', 'Nombre(s)', 'Nombres y Apellidos del Asociado', NULL, NULL, NULL, false);
INSERT INTO xcm_campos_db (nom_esquema, nom_tabla, nom_columna, nom_campo_es, desc_campo_es, nom_campo_en, desc_campo_en, nom_fx_valida_js, is_nullable) VALUES ('public', 'vot_censo_electoral_v1', 'fec_tx', 'Fecha de Ingreso', 'Fecha en la que ingreso el asociado', NULL, NULL, NULL, false);
INSERT INTO xcm_campos_db (nom_esquema, nom_tabla, nom_columna, nom_campo_es, desc_campo_es, nom_campo_en, desc_campo_en, nom_fx_valida_js, is_nullable) VALUES ('public', 'vot_censo_electoral_v1', 'hor_tx', 'Hora de ingreso', 'Hora en la que ingreso el asociado', NULL, NULL, NULL, false);
INSERT INTO xcm_campos_db (nom_esquema, nom_tabla, nom_columna, nom_campo_es, desc_campo_es, nom_campo_en, desc_campo_en, nom_fx_valida_js, is_nullable) VALUES ('public', 'vot_censo_electoral_v1', 'nom_empresa', NULL, NULL, NULL, NULL, NULL, false);


--
-- TOC entry 2195 (class 0 OID 34247)
-- Dependencies: 1656
-- Data for Name: xcm_db_departamentos; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (1, 49, NULL, true, NULL, 'Antioquia', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (2, 49, NULL, true, NULL, 'Atlantico', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (3, 49, NULL, true, NULL, 'Bogotá, D.C.', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (4, 49, NULL, true, NULL, 'Bolivar', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (5, 49, NULL, true, NULL, 'Boyaca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (6, 49, NULL, true, NULL, 'Caldas', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (7, 49, NULL, true, NULL, 'Caqueta', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (8, 49, NULL, true, NULL, 'Cauca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (9, 49, NULL, true, NULL, 'Cesar', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (10, 49, NULL, true, NULL, 'Cordoba', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (11, 49, NULL, true, NULL, 'Cundinamarca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (12, 49, NULL, true, NULL, 'Choco', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (13, 49, NULL, true, NULL, 'Huila', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (14, 49, NULL, true, NULL, 'La Guajira', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (15, 49, NULL, true, NULL, 'Magdalena', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (16, 49, NULL, true, NULL, 'Meta', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (17, 49, NULL, true, NULL, 'Nariño', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (18, 49, NULL, true, NULL, 'Norte de Santander', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (19, 49, NULL, true, NULL, 'Quindio', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (20, 49, NULL, true, NULL, 'Risaralda', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (21, 49, NULL, true, NULL, 'Santander', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (22, 49, NULL, true, NULL, 'Sucre', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (23, 49, NULL, true, NULL, 'Tolima', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (24, 49, NULL, true, NULL, 'Valle del Cauca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (25, 49, NULL, true, NULL, 'Arauca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (26, 49, NULL, true, NULL, 'Casanare', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (27, 49, NULL, true, NULL, 'Putumayo', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (28, 49, NULL, true, NULL, 'Archipielago de San Andres', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (29, 49, NULL, true, NULL, 'Amazonas', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (30, 49, NULL, true, NULL, 'Guainía', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (31, 49, NULL, true, NULL, 'Guaviare', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (32, 49, NULL, true, NULL, 'Vaupés', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_interno, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (33, 49, NULL, true, NULL, 'Vichada', NULL, NULL, NULL, NULL, NULL, NULL, NULL);


--
-- TOC entry 2196 (class 0 OID 34253)
-- Dependencies: 1658
-- Data for Name: xcm_db_municipios; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1, 1, true, NULL, NULL, NULL, NULL, 'ABEJORRAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (2, 1, true, NULL, NULL, NULL, NULL, 'ABRIAQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (3, 1, true, NULL, NULL, NULL, NULL, 'ALEJANDRIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (4, 1, true, NULL, NULL, NULL, NULL, 'AMAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (5, 1, true, NULL, NULL, NULL, NULL, 'AMALFI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (6, 1, true, NULL, NULL, NULL, NULL, 'ANDES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (7, 1, true, NULL, NULL, NULL, NULL, 'ANGELOPOLIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (8, 1, true, NULL, NULL, NULL, NULL, 'ANGOSTURA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (9, 1, true, NULL, NULL, NULL, NULL, 'ANORI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (10, 1, true, NULL, NULL, NULL, NULL, 'SANTAFE DE ANTIOQUIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (11, 1, true, NULL, NULL, NULL, NULL, 'ANZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (12, 1, true, NULL, NULL, NULL, NULL, 'APARTADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (13, 1, true, NULL, NULL, NULL, NULL, 'ARBOLETES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (14, 1, true, NULL, NULL, NULL, NULL, 'ARGELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (15, 1, true, NULL, NULL, NULL, NULL, 'ARMENIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (16, 1, true, NULL, NULL, NULL, NULL, 'BARBOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (17, 1, true, NULL, NULL, NULL, NULL, 'BELMIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (18, 1, true, NULL, NULL, NULL, NULL, 'BELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (19, 1, true, NULL, NULL, NULL, NULL, 'BETANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (20, 1, true, NULL, NULL, NULL, NULL, 'BETULIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (21, 1, true, NULL, NULL, NULL, NULL, 'CIUDAD BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (22, 1, true, NULL, NULL, NULL, NULL, 'BRICEÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (23, 1, true, NULL, NULL, NULL, NULL, 'BURITICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (24, 1, true, NULL, NULL, NULL, NULL, 'CACERES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (25, 1, true, NULL, NULL, NULL, NULL, 'CAICEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (26, 1, true, NULL, NULL, NULL, NULL, 'CALDAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (27, 1, true, NULL, NULL, NULL, NULL, 'CAMPAMENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (28, 1, true, NULL, NULL, NULL, NULL, 'CAÑASGORDAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (29, 1, true, NULL, NULL, NULL, NULL, 'CARACOLI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (30, 1, true, NULL, NULL, NULL, NULL, 'CARAMANTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (31, 1, true, NULL, NULL, NULL, NULL, 'CAREPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (32, 1, true, NULL, NULL, NULL, NULL, 'EL CARMEN DE VIBORAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (33, 1, true, NULL, NULL, NULL, NULL, 'CAROLINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (34, 1, true, NULL, NULL, NULL, NULL, 'CAUCASIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (35, 1, true, NULL, NULL, NULL, NULL, 'CHIGORODO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (36, 1, true, NULL, NULL, NULL, NULL, 'CISNEROS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (37, 1, true, NULL, NULL, NULL, NULL, 'COCORNA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (38, 1, true, NULL, NULL, NULL, NULL, 'CONCEPCION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (39, 1, true, NULL, NULL, NULL, NULL, 'CONCORDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (40, 1, true, NULL, NULL, NULL, NULL, 'COPACABANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (41, 1, true, NULL, NULL, NULL, NULL, 'DABEIBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (42, 1, true, NULL, NULL, NULL, NULL, 'DON MATIAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (43, 1, true, NULL, NULL, NULL, NULL, 'EBEJICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (44, 1, true, NULL, NULL, NULL, NULL, 'EL BAGRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (45, 1, true, NULL, NULL, NULL, NULL, 'ENTRERRIOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (46, 1, true, NULL, NULL, NULL, NULL, 'ENVIGADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (47, 1, true, NULL, NULL, NULL, NULL, 'FREDONIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (48, 1, true, NULL, NULL, NULL, NULL, 'FRONTINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (49, 1, true, NULL, NULL, NULL, NULL, 'GIRALDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (50, 1, true, NULL, NULL, NULL, NULL, 'GIRARDOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (51, 1, true, NULL, NULL, NULL, NULL, 'GOMEZ PLATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (52, 1, true, NULL, NULL, NULL, NULL, 'GRANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (53, 1, true, NULL, NULL, NULL, NULL, 'GUADALUPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (54, 1, true, NULL, NULL, NULL, NULL, 'GUARNE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (55, 1, true, NULL, NULL, NULL, NULL, 'GUATAPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (56, 1, true, NULL, NULL, NULL, NULL, 'HELICONIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (57, 1, true, NULL, NULL, NULL, NULL, 'HISPANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (58, 1, true, NULL, NULL, NULL, NULL, 'ITAGUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (59, 1, true, NULL, NULL, NULL, NULL, 'ITUANGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (60, 1, true, NULL, NULL, NULL, NULL, 'JARDIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (61, 1, true, NULL, NULL, NULL, NULL, 'JERICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (62, 1, true, NULL, NULL, NULL, NULL, 'LA CEJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (63, 1, true, NULL, NULL, NULL, NULL, 'LA ESTRELLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (64, 1, true, NULL, NULL, NULL, NULL, 'LA PINTADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (65, 1, true, NULL, NULL, NULL, NULL, 'LA UNION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (66, 1, true, NULL, NULL, NULL, NULL, 'LIBORINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (67, 1, true, NULL, NULL, NULL, NULL, 'MACEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (68, 1, true, NULL, NULL, NULL, NULL, 'MARINILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (69, 1, true, NULL, NULL, NULL, NULL, 'MONTEBELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (70, 1, true, NULL, NULL, NULL, NULL, 'MURINDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (71, 1, true, NULL, NULL, NULL, NULL, 'MUTATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (72, 1, true, NULL, NULL, NULL, NULL, 'NARIÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (73, 1, true, NULL, NULL, NULL, NULL, 'NECOCLI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (74, 1, true, NULL, NULL, NULL, NULL, 'NECHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (75, 1, true, NULL, NULL, NULL, NULL, 'OLAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (76, 1, true, NULL, NULL, NULL, NULL, 'PEÑOL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (77, 1, true, NULL, NULL, NULL, NULL, 'PEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (78, 1, true, NULL, NULL, NULL, NULL, 'PUEBLORRICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (79, 1, true, NULL, NULL, NULL, NULL, 'PUERTO BERRIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (80, 1, true, NULL, NULL, NULL, NULL, 'PUERTO NARE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (81, 1, true, NULL, NULL, NULL, NULL, 'PUERTO TRIUNFO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (82, 1, true, NULL, NULL, NULL, NULL, 'REMEDIOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (83, 1, true, NULL, NULL, NULL, NULL, 'RETIRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (84, 1, true, NULL, NULL, NULL, NULL, 'RIONEGRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (85, 1, true, NULL, NULL, NULL, NULL, 'SABANALARGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (86, 1, true, NULL, NULL, NULL, NULL, 'SABANETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (87, 1, true, NULL, NULL, NULL, NULL, 'SALGAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (88, 1, true, NULL, NULL, NULL, NULL, 'SAN ANDRES DE CUERQUIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (89, 1, true, NULL, NULL, NULL, NULL, 'SAN CARLOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (90, 1, true, NULL, NULL, NULL, NULL, 'SAN FRANCISCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (91, 1, true, NULL, NULL, NULL, NULL, 'SAN JERONIMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (92, 1, true, NULL, NULL, NULL, NULL, 'SAN JOSE DE LA MONTAÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (93, 1, true, NULL, NULL, NULL, NULL, 'SAN JUAN DE URABA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (94, 1, true, NULL, NULL, NULL, NULL, 'SAN LUIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (95, 1, true, NULL, NULL, NULL, NULL, 'SAN PEDRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (96, 1, true, NULL, NULL, NULL, NULL, 'SAN PEDRO DE URABA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (97, 1, true, NULL, NULL, NULL, NULL, 'SAN RAFAEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (98, 1, true, NULL, NULL, NULL, NULL, 'SAN ROQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (99, 1, true, NULL, NULL, NULL, NULL, 'SAN VICENTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (100, 1, true, NULL, NULL, NULL, NULL, 'SANTA BARBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (101, 1, true, NULL, NULL, NULL, NULL, 'SANTA ROSA DE OSOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (102, 1, true, NULL, NULL, NULL, NULL, 'SANTO DOMINGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (103, 1, true, NULL, NULL, NULL, NULL, 'EL SANTUARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (104, 1, true, NULL, NULL, NULL, NULL, 'SEGOVIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (105, 1, true, NULL, NULL, NULL, NULL, 'SONSON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (106, 1, true, NULL, NULL, NULL, NULL, 'SOPETRAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (107, 1, true, NULL, NULL, NULL, NULL, 'TAMESIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (108, 1, true, NULL, NULL, NULL, NULL, 'TARAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (109, 1, true, NULL, NULL, NULL, NULL, 'TARSO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (110, 1, true, NULL, NULL, NULL, NULL, 'TITIRIBI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (111, 1, true, NULL, NULL, NULL, NULL, 'TOLEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (112, 1, true, NULL, NULL, NULL, NULL, 'TURBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (113, 1, true, NULL, NULL, NULL, NULL, 'URAMITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (114, 1, true, NULL, NULL, NULL, NULL, 'URRAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (115, 1, true, NULL, NULL, NULL, NULL, 'VALDIVIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (116, 1, true, NULL, NULL, NULL, NULL, 'VALPARAISO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (117, 1, true, NULL, NULL, NULL, NULL, 'VEGACHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (118, 1, true, NULL, NULL, NULL, NULL, 'VENECIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (119, 1, true, NULL, NULL, NULL, NULL, 'VIGIA DEL FUERTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (120, 1, true, NULL, NULL, NULL, NULL, 'YALI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (121, 1, true, NULL, NULL, NULL, NULL, 'YARUMAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (122, 1, true, NULL, NULL, NULL, NULL, 'YOLOMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (123, 1, true, NULL, NULL, NULL, NULL, 'YONDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (124, 1, true, NULL, NULL, NULL, NULL, 'ZARAGOZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (125, 2, true, NULL, NULL, NULL, NULL, 'BARRANQUILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (126, 2, true, NULL, NULL, NULL, NULL, 'BARANOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (127, 2, true, NULL, NULL, NULL, NULL, 'CAMPO DE LA CRUZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (128, 2, true, NULL, NULL, NULL, NULL, 'CANDELARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (129, 2, true, NULL, NULL, NULL, NULL, 'GALAPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (130, 2, true, NULL, NULL, NULL, NULL, 'JUAN DE ACOSTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (131, 2, true, NULL, NULL, NULL, NULL, 'LURUACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (132, 2, true, NULL, NULL, NULL, NULL, 'MALAMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (133, 2, true, NULL, NULL, NULL, NULL, 'MANATI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (134, 2, true, NULL, NULL, NULL, NULL, 'PALMAR DE VARELA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (135, 2, true, NULL, NULL, NULL, NULL, 'PIOJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (136, 2, true, NULL, NULL, NULL, NULL, 'POLONUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (137, 2, true, NULL, NULL, NULL, NULL, 'PONEDERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (138, 2, true, NULL, NULL, NULL, NULL, 'PUERTO COLOMBIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (139, 2, true, NULL, NULL, NULL, NULL, 'REPELON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (140, 2, true, NULL, NULL, NULL, NULL, 'SABANAGRANDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (141, 2, true, NULL, NULL, NULL, NULL, 'SABANALARGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (142, 2, true, NULL, NULL, NULL, NULL, 'SANTA LUCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (143, 2, true, NULL, NULL, NULL, NULL, 'SANTO TOMAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (144, 2, true, NULL, NULL, NULL, NULL, 'SOLEDAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (145, 2, true, NULL, NULL, NULL, NULL, 'SUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (146, 2, true, NULL, NULL, NULL, NULL, 'TUBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (147, 2, true, NULL, NULL, NULL, NULL, 'USIACURI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (149, 4, true, NULL, NULL, NULL, NULL, 'CARTAGENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (150, 4, true, NULL, NULL, NULL, NULL, 'ACHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (151, 4, true, NULL, NULL, NULL, NULL, 'ALTOS DEL ROSARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (152, 4, true, NULL, NULL, NULL, NULL, 'ARENAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (153, 4, true, NULL, NULL, NULL, NULL, 'ARJONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (154, 4, true, NULL, NULL, NULL, NULL, 'ARROYOHONDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (155, 4, true, NULL, NULL, NULL, NULL, 'BARRANCO DE LOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (156, 4, true, NULL, NULL, NULL, NULL, 'CALAMAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (157, 4, true, NULL, NULL, NULL, NULL, 'CANTAGALLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (158, 4, true, NULL, NULL, NULL, NULL, 'CICUCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (159, 4, true, NULL, NULL, NULL, NULL, 'CORDOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (160, 4, true, NULL, NULL, NULL, NULL, 'CLEMENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (161, 4, true, NULL, NULL, NULL, NULL, 'EL CARMEN DE BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (162, 4, true, NULL, NULL, NULL, NULL, 'EL GUAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (163, 4, true, NULL, NULL, NULL, NULL, 'EL PEÑON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (164, 4, true, NULL, NULL, NULL, NULL, 'HATILLO DE LOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (165, 4, true, NULL, NULL, NULL, NULL, 'MAGANGUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (166, 4, true, NULL, NULL, NULL, NULL, 'MAHATES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (167, 4, true, NULL, NULL, NULL, NULL, 'MARGARITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (168, 4, true, NULL, NULL, NULL, NULL, 'MARIA LA BAJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (169, 4, true, NULL, NULL, NULL, NULL, 'MONTECRISTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (170, 4, true, NULL, NULL, NULL, NULL, 'MOMPOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (171, 4, true, NULL, NULL, NULL, NULL, 'MORALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (172, 4, true, NULL, NULL, NULL, NULL, 'PINILLOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (173, 4, true, NULL, NULL, NULL, NULL, 'REGIDOR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (174, 4, true, NULL, NULL, NULL, NULL, 'RIO VIEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (175, 4, true, NULL, NULL, NULL, NULL, 'SAN CRISTOBAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (176, 4, true, NULL, NULL, NULL, NULL, 'SAN ESTANISLAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (177, 4, true, NULL, NULL, NULL, NULL, 'SAN FERNANDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (178, 4, true, NULL, NULL, NULL, NULL, 'SAN JACINTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (179, 4, true, NULL, NULL, NULL, NULL, 'SAN JACINTO DEL CAUCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (180, 4, true, NULL, NULL, NULL, NULL, 'SAN JUAN NEPOMUCENO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (181, 4, true, NULL, NULL, NULL, NULL, 'SAN MARTIN DE LOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (182, 4, true, NULL, NULL, NULL, NULL, 'SAN PABLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (183, 4, true, NULL, NULL, NULL, NULL, 'SANTA CATALINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (184, 4, true, NULL, NULL, NULL, NULL, 'SANTA ROSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (185, 4, true, NULL, NULL, NULL, NULL, 'SANTA ROSA DEL SUR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (186, 4, true, NULL, NULL, NULL, NULL, 'SIMITI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (187, 4, true, NULL, NULL, NULL, NULL, 'SOPLAVIENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (188, 4, true, NULL, NULL, NULL, NULL, 'TALAIGUA NUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (189, 4, true, NULL, NULL, NULL, NULL, 'TIQUISIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (190, 4, true, NULL, NULL, NULL, NULL, 'TURBACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (191, 4, true, NULL, NULL, NULL, NULL, 'TURBANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (192, 4, true, NULL, NULL, NULL, NULL, 'VILLANUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (193, 4, true, NULL, NULL, NULL, NULL, 'ZAMBRANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (194, 5, true, NULL, NULL, NULL, NULL, 'TUNJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (195, 5, true, NULL, NULL, NULL, NULL, 'ALMEIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (196, 5, true, NULL, NULL, NULL, NULL, 'AQUITANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (197, 5, true, NULL, NULL, NULL, NULL, 'ARCABUCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (198, 5, true, NULL, NULL, NULL, NULL, 'BELEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (199, 5, true, NULL, NULL, NULL, NULL, 'BERBEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (200, 5, true, NULL, NULL, NULL, NULL, 'BETEITIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (201, 5, true, NULL, NULL, NULL, NULL, 'BOAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (202, 5, true, NULL, NULL, NULL, NULL, 'BOYACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (203, 5, true, NULL, NULL, NULL, NULL, 'BRICEÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (204, 5, true, NULL, NULL, NULL, NULL, 'BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (205, 5, true, NULL, NULL, NULL, NULL, 'BUSBANZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (206, 5, true, NULL, NULL, NULL, NULL, 'CALDAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (207, 5, true, NULL, NULL, NULL, NULL, 'CAMPOHERMOSO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (208, 5, true, NULL, NULL, NULL, NULL, 'CERINZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (209, 5, true, NULL, NULL, NULL, NULL, 'CHINAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (210, 5, true, NULL, NULL, NULL, NULL, 'CHIQUINQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (211, 5, true, NULL, NULL, NULL, NULL, 'CHISCAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (212, 5, true, NULL, NULL, NULL, NULL, 'CHITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (213, 5, true, NULL, NULL, NULL, NULL, 'CHITARAQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (214, 5, true, NULL, NULL, NULL, NULL, 'CHIVATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (215, 5, true, NULL, NULL, NULL, NULL, 'CIENEGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (216, 5, true, NULL, NULL, NULL, NULL, 'COMBITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (217, 5, true, NULL, NULL, NULL, NULL, 'COPER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (218, 5, true, NULL, NULL, NULL, NULL, 'CORRALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (219, 5, true, NULL, NULL, NULL, NULL, 'COVARACHIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (220, 5, true, NULL, NULL, NULL, NULL, 'CUBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (221, 5, true, NULL, NULL, NULL, NULL, 'CUCAITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (222, 5, true, NULL, NULL, NULL, NULL, 'CUITIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (223, 5, true, NULL, NULL, NULL, NULL, 'CHIQUIZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (224, 5, true, NULL, NULL, NULL, NULL, 'CHIVOR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (225, 5, true, NULL, NULL, NULL, NULL, 'DUITAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (226, 5, true, NULL, NULL, NULL, NULL, 'EL COCUY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (227, 5, true, NULL, NULL, NULL, NULL, 'EL ESPINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (228, 5, true, NULL, NULL, NULL, NULL, 'FIRAVITOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (229, 5, true, NULL, NULL, NULL, NULL, 'FLORESTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (230, 5, true, NULL, NULL, NULL, NULL, 'GACHANTIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (231, 5, true, NULL, NULL, NULL, NULL, 'GAMEZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (232, 5, true, NULL, NULL, NULL, NULL, 'GARAGOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (233, 5, true, NULL, NULL, NULL, NULL, 'GUACAMAYAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (234, 5, true, NULL, NULL, NULL, NULL, 'GUATEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (235, 5, true, NULL, NULL, NULL, NULL, 'GUAYATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (236, 5, true, NULL, NULL, NULL, NULL, 'GsICAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (237, 5, true, NULL, NULL, NULL, NULL, 'IZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (238, 5, true, NULL, NULL, NULL, NULL, 'JENESANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (239, 5, true, NULL, NULL, NULL, NULL, 'JERICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (240, 5, true, NULL, NULL, NULL, NULL, 'LABRANZAGRANDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (241, 5, true, NULL, NULL, NULL, NULL, 'LA CAPILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (242, 5, true, NULL, NULL, NULL, NULL, 'LA VICTORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (243, 5, true, NULL, NULL, NULL, NULL, 'LA UVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (244, 5, true, NULL, NULL, NULL, NULL, 'VILLA DE LEYVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (245, 5, true, NULL, NULL, NULL, NULL, 'MACANAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (246, 5, true, NULL, NULL, NULL, NULL, 'MARIPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (247, 5, true, NULL, NULL, NULL, NULL, 'MIRAFLORES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (248, 5, true, NULL, NULL, NULL, NULL, 'MONGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (249, 5, true, NULL, NULL, NULL, NULL, 'MONGUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (250, 5, true, NULL, NULL, NULL, NULL, 'MONIQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (251, 5, true, NULL, NULL, NULL, NULL, 'MOTAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (252, 5, true, NULL, NULL, NULL, NULL, 'MUZO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (253, 5, true, NULL, NULL, NULL, NULL, 'NOBSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (254, 5, true, NULL, NULL, NULL, NULL, 'NUEVO COLON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (255, 5, true, NULL, NULL, NULL, NULL, 'OICATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (256, 5, true, NULL, NULL, NULL, NULL, 'OTANCHE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (257, 5, true, NULL, NULL, NULL, NULL, 'PACHAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (258, 5, true, NULL, NULL, NULL, NULL, 'PAEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (259, 5, true, NULL, NULL, NULL, NULL, 'PAIPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (260, 5, true, NULL, NULL, NULL, NULL, 'PAJARITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (261, 5, true, NULL, NULL, NULL, NULL, 'PANQUEBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (262, 5, true, NULL, NULL, NULL, NULL, 'PAUNA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (263, 5, true, NULL, NULL, NULL, NULL, 'PAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (264, 5, true, NULL, NULL, NULL, NULL, 'PAZ DE RIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (265, 5, true, NULL, NULL, NULL, NULL, 'PESCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (266, 5, true, NULL, NULL, NULL, NULL, 'PISBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (267, 5, true, NULL, NULL, NULL, NULL, 'PUERTO BOYACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (268, 5, true, NULL, NULL, NULL, NULL, 'QUIPAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (269, 5, true, NULL, NULL, NULL, NULL, 'RAMIRIQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (270, 5, true, NULL, NULL, NULL, NULL, 'RAQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (271, 5, true, NULL, NULL, NULL, NULL, 'RONDON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (272, 5, true, NULL, NULL, NULL, NULL, 'SABOYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (273, 5, true, NULL, NULL, NULL, NULL, 'SACHICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (274, 5, true, NULL, NULL, NULL, NULL, 'SAMACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (275, 5, true, NULL, NULL, NULL, NULL, 'SAN EDUARDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (276, 5, true, NULL, NULL, NULL, NULL, 'SAN JOSE DE PARE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (277, 5, true, NULL, NULL, NULL, NULL, 'SAN LUIS DE GACENO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (278, 5, true, NULL, NULL, NULL, NULL, 'SAN MATEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (279, 5, true, NULL, NULL, NULL, NULL, 'SAN MIGUEL DE SEMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (280, 5, true, NULL, NULL, NULL, NULL, 'SAN PABLO DE BORBUR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (281, 5, true, NULL, NULL, NULL, NULL, 'SANTANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (282, 5, true, NULL, NULL, NULL, NULL, 'SANTA MARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (283, 5, true, NULL, NULL, NULL, NULL, 'SANTA ROSA DE VITERBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (284, 5, true, NULL, NULL, NULL, NULL, 'SANTA SOFIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (285, 5, true, NULL, NULL, NULL, NULL, 'SATIVANORTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (286, 5, true, NULL, NULL, NULL, NULL, 'SATIVASUR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (287, 5, true, NULL, NULL, NULL, NULL, 'SIACHOQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (288, 5, true, NULL, NULL, NULL, NULL, 'SOATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (289, 5, true, NULL, NULL, NULL, NULL, 'SOCOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (290, 5, true, NULL, NULL, NULL, NULL, 'SOCHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (291, 5, true, NULL, NULL, NULL, NULL, 'SOGAMOSO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (292, 5, true, NULL, NULL, NULL, NULL, 'SOMONDOCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (293, 5, true, NULL, NULL, NULL, NULL, 'SORA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (294, 5, true, NULL, NULL, NULL, NULL, 'SOTAQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (295, 5, true, NULL, NULL, NULL, NULL, 'SORACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (296, 5, true, NULL, NULL, NULL, NULL, 'SUSACON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (297, 5, true, NULL, NULL, NULL, NULL, 'SUTAMARCHAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (298, 5, true, NULL, NULL, NULL, NULL, 'SUTATENZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (299, 5, true, NULL, NULL, NULL, NULL, 'TASCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (300, 5, true, NULL, NULL, NULL, NULL, 'TENZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (301, 5, true, NULL, NULL, NULL, NULL, 'TIBANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (302, 5, true, NULL, NULL, NULL, NULL, 'TIBASOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (303, 5, true, NULL, NULL, NULL, NULL, 'TINJACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (304, 5, true, NULL, NULL, NULL, NULL, 'TIPACOQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (305, 5, true, NULL, NULL, NULL, NULL, 'TOCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (306, 5, true, NULL, NULL, NULL, NULL, 'TOGsI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (307, 5, true, NULL, NULL, NULL, NULL, 'TOPAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (308, 5, true, NULL, NULL, NULL, NULL, 'TOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (309, 5, true, NULL, NULL, NULL, NULL, 'TUNUNGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (310, 5, true, NULL, NULL, NULL, NULL, 'TURMEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (311, 5, true, NULL, NULL, NULL, NULL, 'TUTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (312, 5, true, NULL, NULL, NULL, NULL, 'TUTAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (313, 5, true, NULL, NULL, NULL, NULL, 'UMBITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (314, 5, true, NULL, NULL, NULL, NULL, 'VENTAQUEMADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (315, 5, true, NULL, NULL, NULL, NULL, 'VIRACACHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (316, 5, true, NULL, NULL, NULL, NULL, 'ZETAQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (317, 6, true, NULL, NULL, NULL, NULL, 'MANIZALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (318, 6, true, NULL, NULL, NULL, NULL, 'AGUADAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (319, 6, true, NULL, NULL, NULL, NULL, 'ANSERMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (320, 6, true, NULL, NULL, NULL, NULL, 'ARANZAZU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (321, 6, true, NULL, NULL, NULL, NULL, 'BELALCAZAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (322, 6, true, NULL, NULL, NULL, NULL, 'CHINCHINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (323, 6, true, NULL, NULL, NULL, NULL, 'FILADELFIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (324, 6, true, NULL, NULL, NULL, NULL, 'LA DORADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (325, 6, true, NULL, NULL, NULL, NULL, 'LA MERCED', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (326, 6, true, NULL, NULL, NULL, NULL, 'MANZANARES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (327, 6, true, NULL, NULL, NULL, NULL, 'MARMATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (328, 6, true, NULL, NULL, NULL, NULL, 'MARQUETALIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (329, 6, true, NULL, NULL, NULL, NULL, 'MARULANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (330, 6, true, NULL, NULL, NULL, NULL, 'NEIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (331, 6, true, NULL, NULL, NULL, NULL, 'NORCASIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (332, 6, true, NULL, NULL, NULL, NULL, 'PACORA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (333, 6, true, NULL, NULL, NULL, NULL, 'PALESTINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (334, 6, true, NULL, NULL, NULL, NULL, 'PENSILVANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (335, 6, true, NULL, NULL, NULL, NULL, 'RIOSUCIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (336, 6, true, NULL, NULL, NULL, NULL, 'RISARALDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (337, 6, true, NULL, NULL, NULL, NULL, 'SALAMINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (338, 6, true, NULL, NULL, NULL, NULL, 'SAMANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (339, 6, true, NULL, NULL, NULL, NULL, 'SAN JOSE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (340, 6, true, NULL, NULL, NULL, NULL, 'SUPIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (341, 6, true, NULL, NULL, NULL, NULL, 'VICTORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (342, 6, true, NULL, NULL, NULL, NULL, 'VILLAMARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (343, 6, true, NULL, NULL, NULL, NULL, 'VITERBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (344, 7, true, NULL, NULL, NULL, NULL, 'FLORENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (345, 7, true, NULL, NULL, NULL, NULL, 'ALBANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (346, 7, true, NULL, NULL, NULL, NULL, 'BELEN DE LOS ANDAQUIES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (347, 7, true, NULL, NULL, NULL, NULL, 'CARTAGENA DEL CHAIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (348, 7, true, NULL, NULL, NULL, NULL, 'CURILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (349, 7, true, NULL, NULL, NULL, NULL, 'EL DONCELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (350, 7, true, NULL, NULL, NULL, NULL, 'EL PAUJIL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (351, 7, true, NULL, NULL, NULL, NULL, 'LA MONTAÑITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (352, 7, true, NULL, NULL, NULL, NULL, 'MILAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (353, 7, true, NULL, NULL, NULL, NULL, 'MORELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (354, 7, true, NULL, NULL, NULL, NULL, 'PUERTO RICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (355, 7, true, NULL, NULL, NULL, NULL, 'SAN JOSE DEL FRAGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (356, 7, true, NULL, NULL, NULL, NULL, 'SAN VICENTE DEL CAGUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (357, 7, true, NULL, NULL, NULL, NULL, 'SOLANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (358, 7, true, NULL, NULL, NULL, NULL, 'SOLITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (359, 7, true, NULL, NULL, NULL, NULL, 'VALPARAISO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (360, 8, true, NULL, NULL, NULL, NULL, 'POPAYAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (361, 8, true, NULL, NULL, NULL, NULL, 'ALMAGUER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (362, 8, true, NULL, NULL, NULL, NULL, 'ARGELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (363, 8, true, NULL, NULL, NULL, NULL, 'BALBOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (364, 8, true, NULL, NULL, NULL, NULL, 'BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (365, 8, true, NULL, NULL, NULL, NULL, 'BUENOS AIRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (366, 8, true, NULL, NULL, NULL, NULL, 'CAJIBIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (367, 8, true, NULL, NULL, NULL, NULL, 'CALDONO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (368, 8, true, NULL, NULL, NULL, NULL, 'CALOTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (369, 8, true, NULL, NULL, NULL, NULL, 'CORINTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (370, 8, true, NULL, NULL, NULL, NULL, 'EL TAMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (371, 8, true, NULL, NULL, NULL, NULL, 'FLORENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (372, 8, true, NULL, NULL, NULL, NULL, 'GUAPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (373, 8, true, NULL, NULL, NULL, NULL, 'INZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (374, 8, true, NULL, NULL, NULL, NULL, 'JAMBALO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (375, 8, true, NULL, NULL, NULL, NULL, 'LA SIERRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (376, 8, true, NULL, NULL, NULL, NULL, 'LA VEGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (377, 8, true, NULL, NULL, NULL, NULL, 'LOPEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (378, 8, true, NULL, NULL, NULL, NULL, 'MERCADERES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (379, 8, true, NULL, NULL, NULL, NULL, 'MIRANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (380, 8, true, NULL, NULL, NULL, NULL, 'MORALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (381, 8, true, NULL, NULL, NULL, NULL, 'PADILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (382, 8, true, NULL, NULL, NULL, NULL, 'PAEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (383, 8, true, NULL, NULL, NULL, NULL, 'PATIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (384, 8, true, NULL, NULL, NULL, NULL, 'PIAMONTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (385, 8, true, NULL, NULL, NULL, NULL, 'PIENDAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (386, 8, true, NULL, NULL, NULL, NULL, 'PUERTO TEJADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (387, 8, true, NULL, NULL, NULL, NULL, 'PURACE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (388, 8, true, NULL, NULL, NULL, NULL, 'ROSAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (389, 8, true, NULL, NULL, NULL, NULL, 'SAN SEBASTIAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (390, 8, true, NULL, NULL, NULL, NULL, 'SANTANDER DE QUILICHAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (391, 8, true, NULL, NULL, NULL, NULL, 'SANTA ROSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (392, 8, true, NULL, NULL, NULL, NULL, 'SILVIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (393, 8, true, NULL, NULL, NULL, NULL, 'SOTARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (394, 8, true, NULL, NULL, NULL, NULL, 'SUAREZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (395, 8, true, NULL, NULL, NULL, NULL, 'SUCRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (396, 8, true, NULL, NULL, NULL, NULL, 'TIMBIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (397, 8, true, NULL, NULL, NULL, NULL, 'TIMBIQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (398, 8, true, NULL, NULL, NULL, NULL, 'TORIBIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (399, 8, true, NULL, NULL, NULL, NULL, 'TOTORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (400, 8, true, NULL, NULL, NULL, NULL, 'VILLA RICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (401, 9, true, NULL, NULL, NULL, NULL, 'VALLEDUPAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (402, 9, true, NULL, NULL, NULL, NULL, 'AGUACHICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (403, 9, true, NULL, NULL, NULL, NULL, 'AGUSTIN CODAZZI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (404, 9, true, NULL, NULL, NULL, NULL, 'ASTREA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (405, 9, true, NULL, NULL, NULL, NULL, 'BECERRIL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (406, 9, true, NULL, NULL, NULL, NULL, 'BOSCONIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (407, 9, true, NULL, NULL, NULL, NULL, 'CHIMICHAGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (408, 9, true, NULL, NULL, NULL, NULL, 'CHIRIGUANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (409, 9, true, NULL, NULL, NULL, NULL, 'CURUMANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (410, 9, true, NULL, NULL, NULL, NULL, 'EL COPEY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (411, 9, true, NULL, NULL, NULL, NULL, 'EL PASO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (412, 9, true, NULL, NULL, NULL, NULL, 'GAMARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (413, 9, true, NULL, NULL, NULL, NULL, 'GONZALEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (414, 9, true, NULL, NULL, NULL, NULL, 'LA GLORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (415, 9, true, NULL, NULL, NULL, NULL, 'LA JAGUA DE IBIRICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (416, 9, true, NULL, NULL, NULL, NULL, 'MANAURE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (417, 9, true, NULL, NULL, NULL, NULL, 'PAILITAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (418, 9, true, NULL, NULL, NULL, NULL, 'PELAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (419, 9, true, NULL, NULL, NULL, NULL, 'PUEBLO BELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (420, 9, true, NULL, NULL, NULL, NULL, 'RIO DE ORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (421, 9, true, NULL, NULL, NULL, NULL, 'LA PAZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (422, 9, true, NULL, NULL, NULL, NULL, 'SAN ALBERTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (423, 9, true, NULL, NULL, NULL, NULL, 'SAN DIEGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (424, 9, true, NULL, NULL, NULL, NULL, 'SAN MARTIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (425, 9, true, NULL, NULL, NULL, NULL, 'TAMALAMEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (426, 10, true, NULL, NULL, NULL, NULL, 'MONTERIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (427, 10, true, NULL, NULL, NULL, NULL, 'AYAPEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (428, 10, true, NULL, NULL, NULL, NULL, 'BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (429, 10, true, NULL, NULL, NULL, NULL, 'CANALETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (430, 10, true, NULL, NULL, NULL, NULL, 'CERETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (431, 10, true, NULL, NULL, NULL, NULL, 'CHIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (432, 10, true, NULL, NULL, NULL, NULL, 'CHINU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (433, 10, true, NULL, NULL, NULL, NULL, 'CIENAGA DE ORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (434, 10, true, NULL, NULL, NULL, NULL, 'COTORRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (435, 10, true, NULL, NULL, NULL, NULL, 'LA APARTADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (436, 10, true, NULL, NULL, NULL, NULL, 'LORICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (437, 10, true, NULL, NULL, NULL, NULL, 'LOS CORDOBAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (438, 10, true, NULL, NULL, NULL, NULL, 'MOMIL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (439, 10, true, NULL, NULL, NULL, NULL, 'MONTELIBANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (440, 10, true, NULL, NULL, NULL, NULL, 'MOÑITOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (441, 10, true, NULL, NULL, NULL, NULL, 'PLANETA RICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (442, 10, true, NULL, NULL, NULL, NULL, 'PUEBLO NUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (443, 10, true, NULL, NULL, NULL, NULL, 'PUERTO ESCONDIDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (444, 10, true, NULL, NULL, NULL, NULL, 'PUERTO LIBERTADOR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (445, 10, true, NULL, NULL, NULL, NULL, 'PURISIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (446, 10, true, NULL, NULL, NULL, NULL, 'SAHAGUN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (447, 10, true, NULL, NULL, NULL, NULL, 'SAN ANDRES SOTAVENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (448, 10, true, NULL, NULL, NULL, NULL, 'SAN ANTERO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (449, 10, true, NULL, NULL, NULL, NULL, 'SAN BERNARDO DEL VIENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (450, 10, true, NULL, NULL, NULL, NULL, 'SAN CARLOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (451, 10, true, NULL, NULL, NULL, NULL, 'SAN PELAYO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (452, 10, true, NULL, NULL, NULL, NULL, 'TIERRALTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (453, 10, true, NULL, NULL, NULL, NULL, 'VALENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (454, 11, true, NULL, NULL, NULL, NULL, 'AGUA DE DIOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (455, 11, true, NULL, NULL, NULL, NULL, 'ALBAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (456, 11, true, NULL, NULL, NULL, NULL, 'ANAPOIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (457, 11, true, NULL, NULL, NULL, NULL, 'ANOLAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (458, 11, true, NULL, NULL, NULL, NULL, 'ARBELAEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (459, 11, true, NULL, NULL, NULL, NULL, 'BELTRAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (460, 11, true, NULL, NULL, NULL, NULL, 'BITUIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (461, 11, true, NULL, NULL, NULL, NULL, 'BOJACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (462, 11, true, NULL, NULL, NULL, NULL, 'CABRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (463, 11, true, NULL, NULL, NULL, NULL, 'CACHIPAY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (464, 11, true, NULL, NULL, NULL, NULL, 'CAJICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (465, 11, true, NULL, NULL, NULL, NULL, 'CAPARRAPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (466, 11, true, NULL, NULL, NULL, NULL, 'CAQUEZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (467, 11, true, NULL, NULL, NULL, NULL, 'CARMEN DE CARUPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (468, 11, true, NULL, NULL, NULL, NULL, 'CHAGUANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (469, 11, true, NULL, NULL, NULL, NULL, 'CHIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (470, 11, true, NULL, NULL, NULL, NULL, 'CHIPAQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (471, 11, true, NULL, NULL, NULL, NULL, 'CHOACHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (472, 11, true, NULL, NULL, NULL, NULL, 'CHOCONTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (473, 11, true, NULL, NULL, NULL, NULL, 'COGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (474, 11, true, NULL, NULL, NULL, NULL, 'COTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (475, 11, true, NULL, NULL, NULL, NULL, 'CUCUNUBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (476, 11, true, NULL, NULL, NULL, NULL, 'EL COLEGIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (477, 11, true, NULL, NULL, NULL, NULL, 'EL PEÑON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (478, 11, true, NULL, NULL, NULL, NULL, 'EL ROSAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (479, 11, true, NULL, NULL, NULL, NULL, 'FACATATIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (480, 11, true, NULL, NULL, NULL, NULL, 'FOMEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (481, 11, true, NULL, NULL, NULL, NULL, 'FOSCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (482, 11, true, NULL, NULL, NULL, NULL, 'FUNZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (483, 11, true, NULL, NULL, NULL, NULL, 'FUQUENE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (484, 11, true, NULL, NULL, NULL, NULL, 'FUSAGASUGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (485, 11, true, NULL, NULL, NULL, NULL, 'GACHALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (486, 11, true, NULL, NULL, NULL, NULL, 'GACHANCIPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (487, 11, true, NULL, NULL, NULL, NULL, 'GACHETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (488, 11, true, NULL, NULL, NULL, NULL, 'GAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (489, 11, true, NULL, NULL, NULL, NULL, 'GIRARDOT', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (490, 11, true, NULL, NULL, NULL, NULL, 'GRANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (491, 11, true, NULL, NULL, NULL, NULL, 'GUACHETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (492, 11, true, NULL, NULL, NULL, NULL, 'GUADUAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (493, 11, true, NULL, NULL, NULL, NULL, 'GUASCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (494, 11, true, NULL, NULL, NULL, NULL, 'GUATAQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (495, 11, true, NULL, NULL, NULL, NULL, 'GUATAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (496, 11, true, NULL, NULL, NULL, NULL, 'GUAYABAL DE SIQUIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (497, 11, true, NULL, NULL, NULL, NULL, 'GUAYABETAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (498, 11, true, NULL, NULL, NULL, NULL, 'GUTIERREZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (499, 11, true, NULL, NULL, NULL, NULL, 'JERUSALEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (500, 11, true, NULL, NULL, NULL, NULL, 'JUNIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (501, 11, true, NULL, NULL, NULL, NULL, 'LA CALERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (502, 11, true, NULL, NULL, NULL, NULL, 'LA MESA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (503, 11, true, NULL, NULL, NULL, NULL, 'LA PALMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (504, 11, true, NULL, NULL, NULL, NULL, 'LA PEÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (505, 11, true, NULL, NULL, NULL, NULL, 'LA VEGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (506, 11, true, NULL, NULL, NULL, NULL, 'LENGUAZAQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (507, 11, true, NULL, NULL, NULL, NULL, 'MACHETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (508, 11, true, NULL, NULL, NULL, NULL, 'MADRID', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (509, 11, true, NULL, NULL, NULL, NULL, 'MANTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (510, 11, true, NULL, NULL, NULL, NULL, 'MEDINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (511, 11, true, NULL, NULL, NULL, NULL, 'MOSQUERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (512, 11, true, NULL, NULL, NULL, NULL, 'NARIÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (513, 11, true, NULL, NULL, NULL, NULL, 'NEMOCON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (514, 11, true, NULL, NULL, NULL, NULL, 'NILO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (515, 11, true, NULL, NULL, NULL, NULL, 'NIMAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (516, 11, true, NULL, NULL, NULL, NULL, 'NOCAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (517, 11, true, NULL, NULL, NULL, NULL, 'VENECIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (518, 11, true, NULL, NULL, NULL, NULL, 'PACHO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (519, 11, true, NULL, NULL, NULL, NULL, 'PAIME', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (520, 11, true, NULL, NULL, NULL, NULL, 'PANDI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (521, 11, true, NULL, NULL, NULL, NULL, 'PARATEBUENO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (522, 11, true, NULL, NULL, NULL, NULL, 'PASCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (523, 11, true, NULL, NULL, NULL, NULL, 'PUERTO SALGAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (524, 11, true, NULL, NULL, NULL, NULL, 'PULI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (525, 11, true, NULL, NULL, NULL, NULL, 'QUEBRADANEGRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (526, 11, true, NULL, NULL, NULL, NULL, 'QUETAME', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (527, 11, true, NULL, NULL, NULL, NULL, 'QUIPILE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (528, 11, true, NULL, NULL, NULL, NULL, 'APULO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (529, 11, true, NULL, NULL, NULL, NULL, 'RICAURTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (530, 11, true, NULL, NULL, NULL, NULL, 'SAN ANTONIO DEL TEQUENDAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (531, 11, true, NULL, NULL, NULL, NULL, 'SAN BERNARDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (532, 11, true, NULL, NULL, NULL, NULL, 'SAN CAYETANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (533, 11, true, NULL, NULL, NULL, NULL, 'SAN FRANCISCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (534, 11, true, NULL, NULL, NULL, NULL, 'SAN JUAN DE RIO SECO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (535, 11, true, NULL, NULL, NULL, NULL, 'SASAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (536, 11, true, NULL, NULL, NULL, NULL, 'SESQUILE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (537, 11, true, NULL, NULL, NULL, NULL, 'SIBATE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (538, 11, true, NULL, NULL, NULL, NULL, 'SILVANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (539, 11, true, NULL, NULL, NULL, NULL, 'SIMIJACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (540, 11, true, NULL, NULL, NULL, NULL, 'SOACHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (541, 11, true, NULL, NULL, NULL, NULL, 'SOPO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (542, 11, true, NULL, NULL, NULL, NULL, 'SUBACHOQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (543, 11, true, NULL, NULL, NULL, NULL, 'SUESCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (544, 11, true, NULL, NULL, NULL, NULL, 'SUPATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (545, 11, true, NULL, NULL, NULL, NULL, 'SUSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (546, 11, true, NULL, NULL, NULL, NULL, 'SUTATAUSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (547, 11, true, NULL, NULL, NULL, NULL, 'TABIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (548, 11, true, NULL, NULL, NULL, NULL, 'TAUSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (549, 11, true, NULL, NULL, NULL, NULL, 'TENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (550, 11, true, NULL, NULL, NULL, NULL, 'TENJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (551, 11, true, NULL, NULL, NULL, NULL, 'TIBACUY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (552, 11, true, NULL, NULL, NULL, NULL, 'TIBIRITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (553, 11, true, NULL, NULL, NULL, NULL, 'TOCAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (554, 11, true, NULL, NULL, NULL, NULL, 'TOCANCIPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (555, 11, true, NULL, NULL, NULL, NULL, 'TOPAIPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (556, 11, true, NULL, NULL, NULL, NULL, 'UBALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (557, 11, true, NULL, NULL, NULL, NULL, 'UBAQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (558, 11, true, NULL, NULL, NULL, NULL, 'VILLA DE SAN DIEGO DE UBATE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (559, 11, true, NULL, NULL, NULL, NULL, 'UNE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (560, 11, true, NULL, NULL, NULL, NULL, 'UTICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (561, 11, true, NULL, NULL, NULL, NULL, 'VERGARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (562, 11, true, NULL, NULL, NULL, NULL, 'VIANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (563, 11, true, NULL, NULL, NULL, NULL, 'VILLAGOMEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (564, 11, true, NULL, NULL, NULL, NULL, 'VILLAPINZON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (565, 11, true, NULL, NULL, NULL, NULL, 'VILLETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (566, 11, true, NULL, NULL, NULL, NULL, 'VIOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (567, 11, true, NULL, NULL, NULL, NULL, 'YACOPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (568, 11, true, NULL, NULL, NULL, NULL, 'ZIPACON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (569, 11, true, NULL, NULL, NULL, NULL, 'ZIPAQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (570, 12, true, NULL, NULL, NULL, NULL, 'QUIBDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (571, 12, true, NULL, NULL, NULL, NULL, 'ACANDI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (572, 12, true, NULL, NULL, NULL, NULL, 'ALTO BAUDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (573, 12, true, NULL, NULL, NULL, NULL, 'ATRATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (574, 12, true, NULL, NULL, NULL, NULL, 'BAGADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (575, 12, true, NULL, NULL, NULL, NULL, 'BAHIA SOLANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (576, 12, true, NULL, NULL, NULL, NULL, 'BAJO BAUDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (577, 12, true, NULL, NULL, NULL, NULL, 'BELEN DE BAJIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (578, 12, true, NULL, NULL, NULL, NULL, 'BOJAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (579, 12, true, NULL, NULL, NULL, NULL, 'EL CANTON DEL SAN PABLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (580, 12, true, NULL, NULL, NULL, NULL, 'CARMEN DEL DARIEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (581, 12, true, NULL, NULL, NULL, NULL, 'CERTEGUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (582, 12, true, NULL, NULL, NULL, NULL, 'CONDOTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (583, 12, true, NULL, NULL, NULL, NULL, 'EL CARMEN DE ATRATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (584, 12, true, NULL, NULL, NULL, NULL, 'EL LITORAL DEL SAN JUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (585, 12, true, NULL, NULL, NULL, NULL, 'ISTMINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (586, 12, true, NULL, NULL, NULL, NULL, 'JURADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (587, 12, true, NULL, NULL, NULL, NULL, 'LLORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (588, 12, true, NULL, NULL, NULL, NULL, 'MEDIO ATRATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (589, 12, true, NULL, NULL, NULL, NULL, 'MEDIO BAUDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (590, 12, true, NULL, NULL, NULL, NULL, 'MEDIO SAN JUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (591, 12, true, NULL, NULL, NULL, NULL, 'NOVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (592, 12, true, NULL, NULL, NULL, NULL, 'NUQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (593, 12, true, NULL, NULL, NULL, NULL, 'RIO IRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (594, 12, true, NULL, NULL, NULL, NULL, 'RIO QUITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (595, 12, true, NULL, NULL, NULL, NULL, 'RIOSUCIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (596, 12, true, NULL, NULL, NULL, NULL, 'SAN JOSE DEL PALMAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (597, 12, true, NULL, NULL, NULL, NULL, 'SIPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (598, 12, true, NULL, NULL, NULL, NULL, 'TADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (599, 12, true, NULL, NULL, NULL, NULL, 'UNGUIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (600, 12, true, NULL, NULL, NULL, NULL, 'UNION PANAMERICANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (601, 13, true, NULL, NULL, NULL, NULL, 'NEIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (602, 13, true, NULL, NULL, NULL, NULL, 'ACEVEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (603, 13, true, NULL, NULL, NULL, NULL, 'AGRADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (604, 13, true, NULL, NULL, NULL, NULL, 'AIPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (605, 13, true, NULL, NULL, NULL, NULL, 'ALGECIRAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (606, 13, true, NULL, NULL, NULL, NULL, 'ALTAMIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (607, 13, true, NULL, NULL, NULL, NULL, 'BARAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (608, 13, true, NULL, NULL, NULL, NULL, 'CAMPOALEGRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (609, 13, true, NULL, NULL, NULL, NULL, 'COLOMBIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (610, 13, true, NULL, NULL, NULL, NULL, 'ELIAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (611, 13, true, NULL, NULL, NULL, NULL, 'GARZON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (612, 13, true, NULL, NULL, NULL, NULL, 'GIGANTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (613, 13, true, NULL, NULL, NULL, NULL, 'GUADALUPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (614, 13, true, NULL, NULL, NULL, NULL, 'HOBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (615, 13, true, NULL, NULL, NULL, NULL, 'IQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (616, 13, true, NULL, NULL, NULL, NULL, 'ISNOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (617, 13, true, NULL, NULL, NULL, NULL, 'LA ARGENTINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (618, 13, true, NULL, NULL, NULL, NULL, 'LA PLATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (619, 13, true, NULL, NULL, NULL, NULL, 'NATAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (620, 13, true, NULL, NULL, NULL, NULL, 'OPORAPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (621, 13, true, NULL, NULL, NULL, NULL, 'PAICOL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (622, 13, true, NULL, NULL, NULL, NULL, 'PALERMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (623, 13, true, NULL, NULL, NULL, NULL, 'PALESTINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (624, 13, true, NULL, NULL, NULL, NULL, 'PITAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (625, 13, true, NULL, NULL, NULL, NULL, 'PITALITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (626, 13, true, NULL, NULL, NULL, NULL, 'RIVERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (627, 13, true, NULL, NULL, NULL, NULL, 'SALADOBLANCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (628, 13, true, NULL, NULL, NULL, NULL, 'SAN AGUSTIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (629, 13, true, NULL, NULL, NULL, NULL, 'SANTA MARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (630, 13, true, NULL, NULL, NULL, NULL, 'SUAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (631, 13, true, NULL, NULL, NULL, NULL, 'TARQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (632, 13, true, NULL, NULL, NULL, NULL, 'TESALIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (633, 13, true, NULL, NULL, NULL, NULL, 'TELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (634, 13, true, NULL, NULL, NULL, NULL, 'TERUEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (635, 13, true, NULL, NULL, NULL, NULL, 'TIMANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (636, 13, true, NULL, NULL, NULL, NULL, 'VILLAVIEJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (637, 13, true, NULL, NULL, NULL, NULL, 'YAGUARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (638, 14, true, NULL, NULL, NULL, NULL, 'RIOHACHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (639, 14, true, NULL, NULL, NULL, NULL, 'ALBANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (640, 14, true, NULL, NULL, NULL, NULL, 'BARRANCAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (641, 14, true, NULL, NULL, NULL, NULL, 'DIBULLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (642, 14, true, NULL, NULL, NULL, NULL, 'DISTRACCION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (643, 14, true, NULL, NULL, NULL, NULL, 'EL MOLINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (644, 14, true, NULL, NULL, NULL, NULL, 'FONSECA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (645, 14, true, NULL, NULL, NULL, NULL, 'HATONUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (646, 14, true, NULL, NULL, NULL, NULL, 'LA JAGUA DEL PILAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (647, 14, true, NULL, NULL, NULL, NULL, 'MAICAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (648, 14, true, NULL, NULL, NULL, NULL, 'MANAURE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (649, 14, true, NULL, NULL, NULL, NULL, 'SAN JUAN DEL CESAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (650, 14, true, NULL, NULL, NULL, NULL, 'URIBIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (651, 14, true, NULL, NULL, NULL, NULL, 'URUMITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (652, 14, true, NULL, NULL, NULL, NULL, 'VILLANUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (653, 15, true, NULL, NULL, NULL, NULL, 'SANTA MARTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (654, 15, true, NULL, NULL, NULL, NULL, 'ALGARROBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (655, 15, true, NULL, NULL, NULL, NULL, 'ARACATACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (656, 15, true, NULL, NULL, NULL, NULL, 'ARIGUANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (657, 15, true, NULL, NULL, NULL, NULL, 'CERRO SAN ANTONIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (658, 15, true, NULL, NULL, NULL, NULL, 'CHIBOLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (659, 15, true, NULL, NULL, NULL, NULL, 'CIENAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (660, 15, true, NULL, NULL, NULL, NULL, 'CONCORDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (661, 15, true, NULL, NULL, NULL, NULL, 'EL BANCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (662, 15, true, NULL, NULL, NULL, NULL, 'EL PIÑON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (663, 15, true, NULL, NULL, NULL, NULL, 'EL RETEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (664, 15, true, NULL, NULL, NULL, NULL, 'FUNDACION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (665, 15, true, NULL, NULL, NULL, NULL, 'GUAMAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (666, 15, true, NULL, NULL, NULL, NULL, 'NUEVA GRANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (667, 15, true, NULL, NULL, NULL, NULL, 'PEDRAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (668, 15, true, NULL, NULL, NULL, NULL, 'PIJIÑO DEL CARMEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (669, 15, true, NULL, NULL, NULL, NULL, 'PIVIJAY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (670, 15, true, NULL, NULL, NULL, NULL, 'PLATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (671, 15, true, NULL, NULL, NULL, NULL, 'PUEBLOVIEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (672, 15, true, NULL, NULL, NULL, NULL, 'REMOLINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (673, 15, true, NULL, NULL, NULL, NULL, 'SABANAS DE SAN ANGEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (674, 15, true, NULL, NULL, NULL, NULL, 'SALAMINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (675, 15, true, NULL, NULL, NULL, NULL, 'SAN SEBASTIAN DE BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (676, 15, true, NULL, NULL, NULL, NULL, 'SAN ZENON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (677, 15, true, NULL, NULL, NULL, NULL, 'SANTA ANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (678, 15, true, NULL, NULL, NULL, NULL, 'SANTA BARBARA DE PINTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (679, 15, true, NULL, NULL, NULL, NULL, 'SITIONUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (680, 15, true, NULL, NULL, NULL, NULL, 'TENERIFE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (681, 15, true, NULL, NULL, NULL, NULL, 'ZAPAYAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (682, 15, true, NULL, NULL, NULL, NULL, 'ZONA BANANERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (683, 16, true, NULL, NULL, NULL, NULL, 'VILLAVICENCIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (684, 16, true, NULL, NULL, NULL, NULL, 'ACACIAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (685, 16, true, NULL, NULL, NULL, NULL, 'BARRANCA DE UPIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (686, 16, true, NULL, NULL, NULL, NULL, 'CABUYARO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (687, 16, true, NULL, NULL, NULL, NULL, 'CASTILLA LA NUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (688, 16, true, NULL, NULL, NULL, NULL, 'CUBARRAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (689, 16, true, NULL, NULL, NULL, NULL, 'CUMARAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (690, 16, true, NULL, NULL, NULL, NULL, 'EL CALVARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (691, 16, true, NULL, NULL, NULL, NULL, 'EL CASTILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (692, 16, true, NULL, NULL, NULL, NULL, 'EL DORADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (693, 16, true, NULL, NULL, NULL, NULL, 'FUENTE DE ORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (694, 16, true, NULL, NULL, NULL, NULL, 'GRANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (695, 16, true, NULL, NULL, NULL, NULL, 'GUAMAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (696, 16, true, NULL, NULL, NULL, NULL, 'MAPIRIPAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (697, 16, true, NULL, NULL, NULL, NULL, 'MESETAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (698, 16, true, NULL, NULL, NULL, NULL, 'LA MACARENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (699, 16, true, NULL, NULL, NULL, NULL, 'URIBE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (700, 16, true, NULL, NULL, NULL, NULL, 'LEJANIAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (701, 16, true, NULL, NULL, NULL, NULL, 'PUERTO CONCORDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (702, 16, true, NULL, NULL, NULL, NULL, 'PUERTO GAITAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (703, 16, true, NULL, NULL, NULL, NULL, 'PUERTO LOPEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (704, 16, true, NULL, NULL, NULL, NULL, 'PUERTO LLERAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (705, 16, true, NULL, NULL, NULL, NULL, 'PUERTO RICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (706, 16, true, NULL, NULL, NULL, NULL, 'RESTREPO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (707, 16, true, NULL, NULL, NULL, NULL, 'SAN CARLOS DE GUAROA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (708, 16, true, NULL, NULL, NULL, NULL, 'SAN JUAN DE ARAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (709, 16, true, NULL, NULL, NULL, NULL, 'SAN JUANITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (710, 16, true, NULL, NULL, NULL, NULL, 'SAN MARTIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (711, 16, true, NULL, NULL, NULL, NULL, 'VISTAHERMOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (712, 17, true, NULL, NULL, NULL, NULL, 'PASTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (713, 17, true, NULL, NULL, NULL, NULL, 'ALBAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (714, 17, true, NULL, NULL, NULL, NULL, 'ALDANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (715, 17, true, NULL, NULL, NULL, NULL, 'ANCUYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (716, 17, true, NULL, NULL, NULL, NULL, 'ARBOLEDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (717, 17, true, NULL, NULL, NULL, NULL, 'BARBACOAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (718, 17, true, NULL, NULL, NULL, NULL, 'BELEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (719, 17, true, NULL, NULL, NULL, NULL, 'BUESACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (720, 17, true, NULL, NULL, NULL, NULL, 'COLON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (721, 17, true, NULL, NULL, NULL, NULL, 'CONSACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (722, 17, true, NULL, NULL, NULL, NULL, 'CONTADERO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (723, 17, true, NULL, NULL, NULL, NULL, 'CORDOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (724, 17, true, NULL, NULL, NULL, NULL, 'CUASPUD', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (725, 17, true, NULL, NULL, NULL, NULL, 'CUMBAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (726, 17, true, NULL, NULL, NULL, NULL, 'CUMBITARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (727, 17, true, NULL, NULL, NULL, NULL, 'CHACHAGsI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (728, 17, true, NULL, NULL, NULL, NULL, 'EL CHARCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (729, 17, true, NULL, NULL, NULL, NULL, 'EL PEÑOL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (730, 17, true, NULL, NULL, NULL, NULL, 'EL ROSARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (731, 17, true, NULL, NULL, NULL, NULL, 'EL TABLON DE GOMEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (732, 17, true, NULL, NULL, NULL, NULL, 'EL TAMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (733, 17, true, NULL, NULL, NULL, NULL, 'FUNES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (734, 17, true, NULL, NULL, NULL, NULL, 'GUACHUCAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (735, 17, true, NULL, NULL, NULL, NULL, 'GUAITARILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (736, 17, true, NULL, NULL, NULL, NULL, 'GUALMATAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (737, 17, true, NULL, NULL, NULL, NULL, 'ILES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (738, 17, true, NULL, NULL, NULL, NULL, 'IMUES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (739, 17, true, NULL, NULL, NULL, NULL, 'IPIALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (740, 17, true, NULL, NULL, NULL, NULL, 'LA CRUZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (741, 17, true, NULL, NULL, NULL, NULL, 'LA FLORIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (742, 17, true, NULL, NULL, NULL, NULL, 'LA LLANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (743, 17, true, NULL, NULL, NULL, NULL, 'LA TOLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (744, 17, true, NULL, NULL, NULL, NULL, 'LA UNION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (745, 17, true, NULL, NULL, NULL, NULL, 'LEIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (746, 17, true, NULL, NULL, NULL, NULL, 'LINARES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (747, 17, true, NULL, NULL, NULL, NULL, 'LOS ANDES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (748, 17, true, NULL, NULL, NULL, NULL, 'MAGsI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (749, 17, true, NULL, NULL, NULL, NULL, 'MALLAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (750, 17, true, NULL, NULL, NULL, NULL, 'MOSQUERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (751, 17, true, NULL, NULL, NULL, NULL, 'NARIÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (752, 17, true, NULL, NULL, NULL, NULL, 'OLAYA HERRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (753, 17, true, NULL, NULL, NULL, NULL, 'OSPINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (754, 17, true, NULL, NULL, NULL, NULL, 'FRANCISCO PIZARRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (755, 17, true, NULL, NULL, NULL, NULL, 'POLICARPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (756, 17, true, NULL, NULL, NULL, NULL, 'POTOSI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (757, 17, true, NULL, NULL, NULL, NULL, 'PROVIDENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (758, 17, true, NULL, NULL, NULL, NULL, 'PUERRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (759, 17, true, NULL, NULL, NULL, NULL, 'PUPIALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (760, 17, true, NULL, NULL, NULL, NULL, 'RICAURTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (761, 17, true, NULL, NULL, NULL, NULL, 'ROBERTO PAYAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (762, 17, true, NULL, NULL, NULL, NULL, 'SAMANIEGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (763, 17, true, NULL, NULL, NULL, NULL, 'SANDONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (764, 17, true, NULL, NULL, NULL, NULL, 'SAN BERNARDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (765, 17, true, NULL, NULL, NULL, NULL, 'SAN LORENZO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (766, 17, true, NULL, NULL, NULL, NULL, 'SAN PABLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (767, 17, true, NULL, NULL, NULL, NULL, 'SAN PEDRO DE CARTAGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (768, 17, true, NULL, NULL, NULL, NULL, 'SANTA BARBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (769, 17, true, NULL, NULL, NULL, NULL, 'SANTACRUZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (770, 17, true, NULL, NULL, NULL, NULL, 'SAPUYES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (771, 17, true, NULL, NULL, NULL, NULL, 'TAMINANGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (772, 17, true, NULL, NULL, NULL, NULL, 'TANGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (773, 17, true, NULL, NULL, NULL, NULL, 'SAN ANDRES DE TUMACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (774, 17, true, NULL, NULL, NULL, NULL, 'TUQUERRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (775, 17, true, NULL, NULL, NULL, NULL, 'YACUANQUER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (776, 18, true, NULL, NULL, NULL, NULL, 'CUCUTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (777, 18, true, NULL, NULL, NULL, NULL, 'ABREGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (778, 18, true, NULL, NULL, NULL, NULL, 'ARBOLEDAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (779, 18, true, NULL, NULL, NULL, NULL, 'BOCHALEMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (780, 18, true, NULL, NULL, NULL, NULL, 'BUCARASICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (781, 18, true, NULL, NULL, NULL, NULL, 'CACOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (782, 18, true, NULL, NULL, NULL, NULL, 'CACHIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (783, 18, true, NULL, NULL, NULL, NULL, 'CHINACOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (784, 18, true, NULL, NULL, NULL, NULL, 'CHITAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (785, 18, true, NULL, NULL, NULL, NULL, 'CONVENCION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (786, 18, true, NULL, NULL, NULL, NULL, 'CUCUTILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (787, 18, true, NULL, NULL, NULL, NULL, 'DURANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (788, 18, true, NULL, NULL, NULL, NULL, 'EL CARMEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (789, 18, true, NULL, NULL, NULL, NULL, 'EL TARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (790, 18, true, NULL, NULL, NULL, NULL, 'EL ZULIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (791, 18, true, NULL, NULL, NULL, NULL, 'GRAMALOTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (792, 18, true, NULL, NULL, NULL, NULL, 'HACARI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (793, 18, true, NULL, NULL, NULL, NULL, 'HERRAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (794, 18, true, NULL, NULL, NULL, NULL, 'LABATECA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (795, 18, true, NULL, NULL, NULL, NULL, 'LA ESPERANZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (796, 18, true, NULL, NULL, NULL, NULL, 'LA PLAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (797, 18, true, NULL, NULL, NULL, NULL, 'LOS PATIOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (798, 18, true, NULL, NULL, NULL, NULL, 'LOURDES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (799, 18, true, NULL, NULL, NULL, NULL, 'MUTISCUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (800, 18, true, NULL, NULL, NULL, NULL, 'OCAÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (801, 18, true, NULL, NULL, NULL, NULL, 'PAMPLONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (802, 18, true, NULL, NULL, NULL, NULL, 'PAMPLONITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (803, 18, true, NULL, NULL, NULL, NULL, 'PUERTO SANTANDER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (804, 18, true, NULL, NULL, NULL, NULL, 'RAGONVALIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (805, 18, true, NULL, NULL, NULL, NULL, 'SALAZAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (806, 18, true, NULL, NULL, NULL, NULL, 'SAN CALIXTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (807, 18, true, NULL, NULL, NULL, NULL, 'SAN CAYETANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (808, 18, true, NULL, NULL, NULL, NULL, 'SANTIAGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (809, 18, true, NULL, NULL, NULL, NULL, 'SARDINATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (810, 18, true, NULL, NULL, NULL, NULL, 'SILOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (811, 18, true, NULL, NULL, NULL, NULL, 'TEORAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (812, 18, true, NULL, NULL, NULL, NULL, 'TIBU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (813, 18, true, NULL, NULL, NULL, NULL, 'TOLEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (814, 18, true, NULL, NULL, NULL, NULL, 'VILLA CARO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (815, 18, true, NULL, NULL, NULL, NULL, 'VILLA DEL ROSARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (816, 19, true, NULL, NULL, NULL, NULL, 'ARMENIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (817, 19, true, NULL, NULL, NULL, NULL, 'BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (818, 19, true, NULL, NULL, NULL, NULL, 'CALARCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (819, 19, true, NULL, NULL, NULL, NULL, 'CIRCASIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (820, 19, true, NULL, NULL, NULL, NULL, 'CORDOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (821, 19, true, NULL, NULL, NULL, NULL, 'FILANDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (822, 19, true, NULL, NULL, NULL, NULL, 'GENOVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (823, 19, true, NULL, NULL, NULL, NULL, 'LA TEBAIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (824, 19, true, NULL, NULL, NULL, NULL, 'MONTENEGRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (825, 19, true, NULL, NULL, NULL, NULL, 'PIJAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (826, 19, true, NULL, NULL, NULL, NULL, 'QUIMBAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (827, 19, true, NULL, NULL, NULL, NULL, 'SALENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (828, 20, true, NULL, NULL, NULL, NULL, 'PEREIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (829, 20, true, NULL, NULL, NULL, NULL, 'APIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (830, 20, true, NULL, NULL, NULL, NULL, 'BALBOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (831, 20, true, NULL, NULL, NULL, NULL, 'BELEN DE UMBRIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (832, 20, true, NULL, NULL, NULL, NULL, 'DOSQUEBRADAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (833, 20, true, NULL, NULL, NULL, NULL, 'GUATICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (834, 20, true, NULL, NULL, NULL, NULL, 'LA CELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (835, 20, true, NULL, NULL, NULL, NULL, 'LA VIRGINIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (836, 20, true, NULL, NULL, NULL, NULL, 'MARSELLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (837, 20, true, NULL, NULL, NULL, NULL, 'MISTRATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (838, 20, true, NULL, NULL, NULL, NULL, 'PUEBLO RICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (839, 20, true, NULL, NULL, NULL, NULL, 'QUINCHIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (840, 20, true, NULL, NULL, NULL, NULL, 'SANTA ROSA DE CABAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (841, 20, true, NULL, NULL, NULL, NULL, 'SANTUARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (842, 21, true, NULL, NULL, NULL, NULL, 'BUCARAMANGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (843, 21, true, NULL, NULL, NULL, NULL, 'AGUADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (844, 21, true, NULL, NULL, NULL, NULL, 'ALBANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (845, 21, true, NULL, NULL, NULL, NULL, 'ARATOCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (846, 21, true, NULL, NULL, NULL, NULL, 'BARBOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (847, 21, true, NULL, NULL, NULL, NULL, 'BARICHARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (848, 21, true, NULL, NULL, NULL, NULL, 'BARRANCABERMEJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (849, 21, true, NULL, NULL, NULL, NULL, 'BETULIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (850, 21, true, NULL, NULL, NULL, NULL, 'BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (851, 21, true, NULL, NULL, NULL, NULL, 'CABRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (852, 21, true, NULL, NULL, NULL, NULL, 'CALIFORNIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (853, 21, true, NULL, NULL, NULL, NULL, 'CAPITANEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (854, 21, true, NULL, NULL, NULL, NULL, 'CARCASI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (855, 21, true, NULL, NULL, NULL, NULL, 'CEPITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (856, 21, true, NULL, NULL, NULL, NULL, 'CERRITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (857, 21, true, NULL, NULL, NULL, NULL, 'CHARALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (858, 21, true, NULL, NULL, NULL, NULL, 'CHARTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (859, 21, true, NULL, NULL, NULL, NULL, 'CHIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (860, 21, true, NULL, NULL, NULL, NULL, 'CHIPATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (861, 21, true, NULL, NULL, NULL, NULL, 'CIMITARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (862, 21, true, NULL, NULL, NULL, NULL, 'CONCEPCION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (863, 21, true, NULL, NULL, NULL, NULL, 'CONFINES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (864, 21, true, NULL, NULL, NULL, NULL, 'CONTRATACION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (865, 21, true, NULL, NULL, NULL, NULL, 'COROMORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (866, 21, true, NULL, NULL, NULL, NULL, 'CURITI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (867, 21, true, NULL, NULL, NULL, NULL, 'EL CARMEN DE CHUCURI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (868, 21, true, NULL, NULL, NULL, NULL, 'EL GUACAMAYO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (869, 21, true, NULL, NULL, NULL, NULL, 'EL PEÑON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (870, 21, true, NULL, NULL, NULL, NULL, 'EL PLAYON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (871, 21, true, NULL, NULL, NULL, NULL, 'ENCINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (872, 21, true, NULL, NULL, NULL, NULL, 'ENCISO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (873, 21, true, NULL, NULL, NULL, NULL, 'FLORIAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (874, 21, true, NULL, NULL, NULL, NULL, 'FLORIDABLANCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (875, 21, true, NULL, NULL, NULL, NULL, 'GALAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (876, 21, true, NULL, NULL, NULL, NULL, 'GAMBITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (877, 21, true, NULL, NULL, NULL, NULL, 'GIRON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (878, 21, true, NULL, NULL, NULL, NULL, 'GUACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (879, 21, true, NULL, NULL, NULL, NULL, 'GUADALUPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (880, 21, true, NULL, NULL, NULL, NULL, 'GUAPOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (881, 21, true, NULL, NULL, NULL, NULL, 'GUAVATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (882, 21, true, NULL, NULL, NULL, NULL, 'GsEPSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (883, 21, true, NULL, NULL, NULL, NULL, 'HATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (884, 21, true, NULL, NULL, NULL, NULL, 'JESUS MARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (885, 21, true, NULL, NULL, NULL, NULL, 'JORDAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (886, 21, true, NULL, NULL, NULL, NULL, 'LA BELLEZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (887, 21, true, NULL, NULL, NULL, NULL, 'LANDAZURI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (888, 21, true, NULL, NULL, NULL, NULL, 'LA PAZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (889, 21, true, NULL, NULL, NULL, NULL, 'LEBRIJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (890, 21, true, NULL, NULL, NULL, NULL, 'LOS SANTOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (891, 21, true, NULL, NULL, NULL, NULL, 'MACARAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (892, 21, true, NULL, NULL, NULL, NULL, 'MALAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (893, 21, true, NULL, NULL, NULL, NULL, 'MATANZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (894, 21, true, NULL, NULL, NULL, NULL, 'MOGOTES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (895, 21, true, NULL, NULL, NULL, NULL, 'MOLAGAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (896, 21, true, NULL, NULL, NULL, NULL, 'OCAMONTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (897, 21, true, NULL, NULL, NULL, NULL, 'OIBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (898, 21, true, NULL, NULL, NULL, NULL, 'ONZAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (899, 21, true, NULL, NULL, NULL, NULL, 'PALMAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (900, 21, true, NULL, NULL, NULL, NULL, 'PALMAS DEL SOCORRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (901, 21, true, NULL, NULL, NULL, NULL, 'PARAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (902, 21, true, NULL, NULL, NULL, NULL, 'PIEDECUESTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (903, 21, true, NULL, NULL, NULL, NULL, 'PINCHOTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (904, 21, true, NULL, NULL, NULL, NULL, 'PUENTE NACIONAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (905, 21, true, NULL, NULL, NULL, NULL, 'PUERTO PARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (906, 21, true, NULL, NULL, NULL, NULL, 'PUERTO WILCHES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (907, 21, true, NULL, NULL, NULL, NULL, 'RIONEGRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (908, 21, true, NULL, NULL, NULL, NULL, 'SABANA DE TORRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (909, 21, true, NULL, NULL, NULL, NULL, 'SAN ANDRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (910, 21, true, NULL, NULL, NULL, NULL, 'SAN BENITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (911, 21, true, NULL, NULL, NULL, NULL, 'SAN GIL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (912, 21, true, NULL, NULL, NULL, NULL, 'SAN JOAQUIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (913, 21, true, NULL, NULL, NULL, NULL, 'SAN JOSE DE MIRANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (914, 21, true, NULL, NULL, NULL, NULL, 'SAN MIGUEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (915, 21, true, NULL, NULL, NULL, NULL, 'SAN VICENTE DE CHUCURI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (916, 21, true, NULL, NULL, NULL, NULL, 'SANTA BARBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (917, 21, true, NULL, NULL, NULL, NULL, 'SANTA HELENA DEL OPON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (918, 21, true, NULL, NULL, NULL, NULL, 'SIMACOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (919, 21, true, NULL, NULL, NULL, NULL, 'SOCORRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (920, 21, true, NULL, NULL, NULL, NULL, 'SUAITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (921, 21, true, NULL, NULL, NULL, NULL, 'SUCRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (922, 21, true, NULL, NULL, NULL, NULL, 'SURATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (923, 21, true, NULL, NULL, NULL, NULL, 'TONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (924, 21, true, NULL, NULL, NULL, NULL, 'VALLE DE SAN JOSE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (925, 21, true, NULL, NULL, NULL, NULL, 'VELEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (926, 21, true, NULL, NULL, NULL, NULL, 'VETAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (927, 21, true, NULL, NULL, NULL, NULL, 'VILLANUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (928, 21, true, NULL, NULL, NULL, NULL, 'ZAPATOCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (929, 22, true, NULL, NULL, NULL, NULL, 'SINCELEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (930, 22, true, NULL, NULL, NULL, NULL, 'BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (931, 22, true, NULL, NULL, NULL, NULL, 'CAIMITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (932, 22, true, NULL, NULL, NULL, NULL, 'COLOSO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (933, 22, true, NULL, NULL, NULL, NULL, 'COROZAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (934, 22, true, NULL, NULL, NULL, NULL, 'COVEÑAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (935, 22, true, NULL, NULL, NULL, NULL, 'CHALAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (936, 22, true, NULL, NULL, NULL, NULL, 'EL ROBLE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (937, 22, true, NULL, NULL, NULL, NULL, 'GALERAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (938, 22, true, NULL, NULL, NULL, NULL, 'GUARANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (939, 22, true, NULL, NULL, NULL, NULL, 'LA UNION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (940, 22, true, NULL, NULL, NULL, NULL, 'LOS PALMITOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (941, 22, true, NULL, NULL, NULL, NULL, 'MAJAGUAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (942, 22, true, NULL, NULL, NULL, NULL, 'MORROA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (943, 22, true, NULL, NULL, NULL, NULL, 'OVEJAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (944, 22, true, NULL, NULL, NULL, NULL, 'PALMITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (945, 22, true, NULL, NULL, NULL, NULL, 'SAMPUES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (946, 22, true, NULL, NULL, NULL, NULL, 'SAN BENITO ABAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (947, 22, true, NULL, NULL, NULL, NULL, 'SAN JUAN DE BETULIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (948, 22, true, NULL, NULL, NULL, NULL, 'SAN MARCOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (949, 22, true, NULL, NULL, NULL, NULL, 'SAN ONOFRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (950, 22, true, NULL, NULL, NULL, NULL, 'SAN PEDRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (951, 22, true, NULL, NULL, NULL, NULL, 'SAN LUIS DE SINCE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (952, 22, true, NULL, NULL, NULL, NULL, 'SUCRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (953, 22, true, NULL, NULL, NULL, NULL, 'SANTIAGO DE TOLU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (954, 22, true, NULL, NULL, NULL, NULL, 'TOLU VIEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (955, 23, true, NULL, NULL, NULL, NULL, 'IBAGUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (956, 23, true, NULL, NULL, NULL, NULL, 'ALPUJARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (957, 23, true, NULL, NULL, NULL, NULL, 'ALVARADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (958, 23, true, NULL, NULL, NULL, NULL, 'AMBALEMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (959, 23, true, NULL, NULL, NULL, NULL, 'ANZOATEGUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (960, 23, true, NULL, NULL, NULL, NULL, 'ARMERO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (961, 23, true, NULL, NULL, NULL, NULL, 'ATACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (962, 23, true, NULL, NULL, NULL, NULL, 'CAJAMARCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (963, 23, true, NULL, NULL, NULL, NULL, 'CARMEN DE APICALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (964, 23, true, NULL, NULL, NULL, NULL, 'CASABIANCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (965, 23, true, NULL, NULL, NULL, NULL, 'CHAPARRAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (966, 23, true, NULL, NULL, NULL, NULL, 'COELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (967, 23, true, NULL, NULL, NULL, NULL, 'COYAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (968, 23, true, NULL, NULL, NULL, NULL, 'CUNDAY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (969, 23, true, NULL, NULL, NULL, NULL, 'DOLORES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (970, 23, true, NULL, NULL, NULL, NULL, 'ESPINAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (971, 23, true, NULL, NULL, NULL, NULL, 'FALAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (972, 23, true, NULL, NULL, NULL, NULL, 'FLANDES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (973, 23, true, NULL, NULL, NULL, NULL, 'FRESNO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (974, 23, true, NULL, NULL, NULL, NULL, 'GUAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (975, 23, true, NULL, NULL, NULL, NULL, 'HERVEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (976, 23, true, NULL, NULL, NULL, NULL, 'HONDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (977, 23, true, NULL, NULL, NULL, NULL, 'ICONONZO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (978, 23, true, NULL, NULL, NULL, NULL, 'LERIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (979, 23, true, NULL, NULL, NULL, NULL, 'LIBANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (980, 23, true, NULL, NULL, NULL, NULL, 'MARIQUITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (981, 23, true, NULL, NULL, NULL, NULL, 'MELGAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (982, 23, true, NULL, NULL, NULL, NULL, 'MURILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (983, 23, true, NULL, NULL, NULL, NULL, 'NATAGAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (984, 23, true, NULL, NULL, NULL, NULL, 'ORTEGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (985, 23, true, NULL, NULL, NULL, NULL, 'PALOCABILDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (986, 23, true, NULL, NULL, NULL, NULL, 'PIEDRAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (987, 23, true, NULL, NULL, NULL, NULL, 'PLANADAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (988, 23, true, NULL, NULL, NULL, NULL, 'PRADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (989, 23, true, NULL, NULL, NULL, NULL, 'PURIFICACION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (990, 23, true, NULL, NULL, NULL, NULL, 'RIOBLANCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (991, 23, true, NULL, NULL, NULL, NULL, 'RONCESVALLES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (992, 23, true, NULL, NULL, NULL, NULL, 'ROVIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (993, 23, true, NULL, NULL, NULL, NULL, 'SALDAÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (994, 23, true, NULL, NULL, NULL, NULL, 'SAN ANTONIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (995, 23, true, NULL, NULL, NULL, NULL, 'SAN LUIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (996, 23, true, NULL, NULL, NULL, NULL, 'SANTA ISABEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (997, 23, true, NULL, NULL, NULL, NULL, 'SUAREZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (998, 23, true, NULL, NULL, NULL, NULL, 'VALLE DE SAN JUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (999, 23, true, NULL, NULL, NULL, NULL, 'VENADILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1000, 23, true, NULL, NULL, NULL, NULL, 'VILLAHERMOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1001, 23, true, NULL, NULL, NULL, NULL, 'VILLARRICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1002, 24, true, NULL, NULL, NULL, NULL, 'CALI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1003, 24, true, NULL, NULL, NULL, NULL, 'ALCALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1004, 24, true, NULL, NULL, NULL, NULL, 'ANDALUCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1005, 24, true, NULL, NULL, NULL, NULL, 'ANSERMANUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1006, 24, true, NULL, NULL, NULL, NULL, 'ARGELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1007, 24, true, NULL, NULL, NULL, NULL, 'BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1008, 24, true, NULL, NULL, NULL, NULL, 'BUENAVENTURA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1009, 24, true, NULL, NULL, NULL, NULL, 'GUADALAJARA DE BUGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1010, 24, true, NULL, NULL, NULL, NULL, 'BUGALAGRANDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1011, 24, true, NULL, NULL, NULL, NULL, 'CAICEDONIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1012, 24, true, NULL, NULL, NULL, NULL, 'CALIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1013, 24, true, NULL, NULL, NULL, NULL, 'CANDELARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1014, 24, true, NULL, NULL, NULL, NULL, 'CARTAGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1015, 24, true, NULL, NULL, NULL, NULL, 'DAGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1016, 24, true, NULL, NULL, NULL, NULL, 'EL AGUILA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1017, 24, true, NULL, NULL, NULL, NULL, 'EL CAIRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1018, 24, true, NULL, NULL, NULL, NULL, 'EL CERRITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1019, 24, true, NULL, NULL, NULL, NULL, 'EL DOVIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1020, 24, true, NULL, NULL, NULL, NULL, 'FLORIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1021, 24, true, NULL, NULL, NULL, NULL, 'GINEBRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1022, 24, true, NULL, NULL, NULL, NULL, 'GUACARI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1023, 24, true, NULL, NULL, NULL, NULL, 'JAMUNDI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1024, 24, true, NULL, NULL, NULL, NULL, 'LA CUMBRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1025, 24, true, NULL, NULL, NULL, NULL, 'LA UNION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1026, 24, true, NULL, NULL, NULL, NULL, 'LA VICTORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1027, 24, true, NULL, NULL, NULL, NULL, 'OBANDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1028, 24, true, NULL, NULL, NULL, NULL, 'PALMIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1029, 24, true, NULL, NULL, NULL, NULL, 'PRADERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1030, 24, true, NULL, NULL, NULL, NULL, 'RESTREPO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1031, 24, true, NULL, NULL, NULL, NULL, 'RIOFRIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1032, 24, true, NULL, NULL, NULL, NULL, 'ROLDANILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1033, 24, true, NULL, NULL, NULL, NULL, 'SAN PEDRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1034, 24, true, NULL, NULL, NULL, NULL, 'SEVILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1035, 24, true, NULL, NULL, NULL, NULL, 'TORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1036, 24, true, NULL, NULL, NULL, NULL, 'TRUJILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1037, 24, true, NULL, NULL, NULL, NULL, 'TULUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1038, 24, true, NULL, NULL, NULL, NULL, 'ULLOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1039, 24, true, NULL, NULL, NULL, NULL, 'VERSALLES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1040, 24, true, NULL, NULL, NULL, NULL, 'VIJES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1041, 24, true, NULL, NULL, NULL, NULL, 'YOTOCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1042, 24, true, NULL, NULL, NULL, NULL, 'YUMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1043, 24, true, NULL, NULL, NULL, NULL, 'ZARZAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1044, 25, true, NULL, NULL, NULL, NULL, 'ARAUCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1045, 25, true, NULL, NULL, NULL, NULL, 'ARAUQUITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1046, 25, true, NULL, NULL, NULL, NULL, 'CRAVO NORTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1047, 25, true, NULL, NULL, NULL, NULL, 'FORTUL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1048, 25, true, NULL, NULL, NULL, NULL, 'PUERTO RONDON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1049, 25, true, NULL, NULL, NULL, NULL, 'SARAVENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1050, 25, true, NULL, NULL, NULL, NULL, 'TAME', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1051, 26, true, NULL, NULL, NULL, NULL, 'YOPAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1052, 26, true, NULL, NULL, NULL, NULL, 'AGUAZUL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1053, 26, true, NULL, NULL, NULL, NULL, 'CHAMEZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1054, 26, true, NULL, NULL, NULL, NULL, 'HATO COROZAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1055, 26, true, NULL, NULL, NULL, NULL, 'LA SALINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1056, 26, true, NULL, NULL, NULL, NULL, 'MANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1057, 26, true, NULL, NULL, NULL, NULL, 'MONTERREY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1058, 26, true, NULL, NULL, NULL, NULL, 'NUNCHIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1059, 26, true, NULL, NULL, NULL, NULL, 'OROCUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1060, 26, true, NULL, NULL, NULL, NULL, 'PAZ DE ARIPORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1061, 26, true, NULL, NULL, NULL, NULL, 'PORE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1062, 26, true, NULL, NULL, NULL, NULL, 'RECETOR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1063, 26, true, NULL, NULL, NULL, NULL, 'SABANALARGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1064, 26, true, NULL, NULL, NULL, NULL, 'SACAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1065, 26, true, NULL, NULL, NULL, NULL, 'SAN LUIS DE PALENQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1066, 26, true, NULL, NULL, NULL, NULL, 'TAMARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1067, 26, true, NULL, NULL, NULL, NULL, 'TAURAMENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1068, 26, true, NULL, NULL, NULL, NULL, 'TRINIDAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1069, 26, true, NULL, NULL, NULL, NULL, 'VILLANUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1070, 27, true, NULL, NULL, NULL, NULL, 'MOCOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1071, 27, true, NULL, NULL, NULL, NULL, 'COLON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1072, 27, true, NULL, NULL, NULL, NULL, 'ORITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1073, 27, true, NULL, NULL, NULL, NULL, 'PUERTO ASIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1074, 27, true, NULL, NULL, NULL, NULL, 'PUERTO CAICEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1075, 27, true, NULL, NULL, NULL, NULL, 'PUERTO GUZMAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1076, 27, true, NULL, NULL, NULL, NULL, 'LEGUIZAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1077, 27, true, NULL, NULL, NULL, NULL, 'SIBUNDOY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1078, 27, true, NULL, NULL, NULL, NULL, 'SAN FRANCISCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1079, 27, true, NULL, NULL, NULL, NULL, 'SAN MIGUEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1080, 27, true, NULL, NULL, NULL, NULL, 'SANTIAGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1081, 27, true, NULL, NULL, NULL, NULL, 'VALLE DEL GUAMUEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1082, 27, true, NULL, NULL, NULL, NULL, 'VILLAGARZON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1083, 28, true, NULL, NULL, NULL, NULL, 'SAN ANDRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1084, 28, true, NULL, NULL, NULL, NULL, 'PROVIDENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1085, 29, true, NULL, NULL, NULL, NULL, 'LETICIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1086, 29, true, NULL, NULL, NULL, NULL, 'EL ENCANTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1087, 29, true, NULL, NULL, NULL, NULL, 'LA CHORRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1088, 29, true, NULL, NULL, NULL, NULL, 'LA PEDRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1089, 29, true, NULL, NULL, NULL, NULL, 'LA VICTORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1090, 29, true, NULL, NULL, NULL, NULL, 'MIRITI - PARANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1091, 29, true, NULL, NULL, NULL, NULL, 'PUERTO ALEGRIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1092, 29, true, NULL, NULL, NULL, NULL, 'PUERTO ARICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1093, 29, true, NULL, NULL, NULL, NULL, 'PUERTO NARIÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1094, 29, true, NULL, NULL, NULL, NULL, 'PUERTO SANTANDER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1095, 29, true, NULL, NULL, NULL, NULL, 'TARAPACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1096, 30, true, NULL, NULL, NULL, NULL, 'INIRIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1097, 30, true, NULL, NULL, NULL, NULL, 'BARRANCO MINAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1098, 30, true, NULL, NULL, NULL, NULL, 'MAPIRIPANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1099, 30, true, NULL, NULL, NULL, NULL, 'SAN FELIPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1100, 30, true, NULL, NULL, NULL, NULL, 'PUERTO COLOMBIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1101, 30, true, NULL, NULL, NULL, NULL, 'LA GUADALUPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1102, 30, true, NULL, NULL, NULL, NULL, 'CACAHUAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1103, 30, true, NULL, NULL, NULL, NULL, 'PANA PANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1104, 30, true, NULL, NULL, NULL, NULL, 'MORICHAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1105, 31, true, NULL, NULL, NULL, NULL, 'SAN JOSE DEL GUAVIARE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1106, 31, true, NULL, NULL, NULL, NULL, 'CALAMAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1107, 31, true, NULL, NULL, NULL, NULL, 'EL RETORNO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1108, 31, true, NULL, NULL, NULL, NULL, 'MIRAFLORES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1109, 32, true, NULL, NULL, NULL, NULL, 'MITU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1110, 32, true, NULL, NULL, NULL, NULL, 'CARURU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1111, 32, true, NULL, NULL, NULL, NULL, 'PACOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1112, 32, true, NULL, NULL, NULL, NULL, 'TARAIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1113, 32, true, NULL, NULL, NULL, NULL, 'PAPUNAUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1114, 32, true, NULL, NULL, NULL, NULL, 'YAVARATE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1115, 33, true, NULL, NULL, NULL, NULL, 'PUERTO CARREÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1116, 33, true, NULL, NULL, NULL, NULL, 'LA PRIMAVERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1117, 33, true, NULL, NULL, NULL, NULL, 'SANTA ROSALIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1118, 33, true, NULL, NULL, NULL, NULL, 'CUMARIBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_interno, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (148, 3, true, true, true, NULL, NULL, 'BOGOTA, D.C.', NULL, NULL, NULL, NULL, NULL, NULL, NULL);


--
-- TOC entry 2197 (class 0 OID 34259)
-- Dependencies: 1660
-- Data for Name: xcm_db_paises; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (1, 1, 'Afghanistan', 'AF', 'Afghanistan', 'AF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (2, 2, 'Albania', 'AL', 'Albania', 'AL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (3, 3, 'Algeria', 'DZ', 'Algeria', 'DZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (4, 4, 'American Samoa', 'AS', 'American Samoa', 'AS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (5, 5, 'Andorra', 'AD', 'Andorra', 'AD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (6, 6, 'Angola', 'AO', 'Angola', 'AO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (7, 7, 'Anguilla', 'AI', 'Anguilla', 'AI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (8, 8, 'Antigua & Barbuda', 'AG', 'Antigua & Barbuda', 'AG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (9, 9, 'Argentina', 'AR', 'Argentina', 'AR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (10, 10, 'Armenia', 'AM', 'Armenia', 'AM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (11, 11, 'Aruba', 'AW', 'Aruba', 'AW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (12, 12, 'Australia', 'AU', 'Australia', 'AU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (13, 13, 'Austria', 'AT', 'Austria', 'AT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (14, 14, 'Azerbaijan', 'AZ', 'Azerbaijan', 'AZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (15, 15, 'Azores', 'AP', 'Azores', 'AP', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (16, 16, 'Bahamas', 'BS', 'Bahamas', 'BS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (17, 17, 'Bahrain', 'BH', 'Bahrain', 'BH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (18, 18, 'Bangladesh', 'BD', 'Bangladesh', 'BD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (19, 19, 'Barbados', 'BB', 'Barbados', 'BB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (20, 20, 'Belarus', 'BY', 'Belarus', 'BY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (21, 21, 'Belgium', 'BE', 'Belgium', 'BE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (22, 22, 'Belize', 'BZ', 'Belize', 'BZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (23, 23, 'Benin', 'BJ', 'Benin', 'BJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (24, 24, 'Bermuda', 'BM', 'Bermuda', 'BM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (25, 25, 'Bhutan', 'BT', 'Bhutan', 'BT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (26, 26, 'Bolivia', 'BO', 'Bolivia', 'BO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (27, 27, 'Bonaire', 'BL', 'Bonaire', 'BL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (28, 28, 'Bosnia & Herzegovina', 'BA', 'Bosnia & Herzegovina', 'BA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (29, 29, 'Botswana', 'BW', 'Botswana', 'BW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (30, 30, 'Brazil', 'BR', 'Brazil', 'BR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (31, 31, 'British Indian Ocean Ter', 'IO', 'British Indian Ocean Ter', 'IO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (32, 32, 'Brunei', 'BN', 'Brunei', 'BN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (33, 33, 'Bulgaria', 'BG', 'Bulgaria', 'BG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (34, 34, 'Burkina Faso', 'BF', 'Burkina Faso', 'BF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (35, 35, 'Burundi', 'BI', 'Burundi', 'BI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (36, 36, 'Cambodia', 'KH', 'Cambodia', 'KH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (37, 37, 'Cameroon', 'CM', 'Cameroon', 'CM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (38, 38, 'Canada', 'CA', 'Canada', 'CA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (39, 39, 'Canary Islands', 'IC', 'Canary Islands', 'IC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (40, 40, 'Cape Verde', 'CV', 'Cape Verde', 'CV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (41, 41, 'Cayman Islands', 'KY', 'Cayman Islands', 'KY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (42, 42, 'Central African Republic', 'CF', 'Central African Republic', 'CF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (43, 43, 'Chad', 'TD', 'Chad', 'TD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (44, 44, 'Channel Islands', 'JI', 'Channel Islands', 'JI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (45, 45, 'Chile', 'CL', 'Chile', 'CL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (46, 46, 'China', 'CN', 'China', 'CN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (47, 47, 'Christmas Island', 'CX', 'Christmas Island', 'CX', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (48, 48, 'Cocos Island', 'CC', 'Cocos Island', 'CC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (50, 50, 'Comoros', 'KM', 'Comoros', 'KM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (51, 51, 'Congo', 'CG', 'Congo', 'CG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (52, 52, 'Congo Democratic Republic', 'CD', 'Congo Democratic Republic', 'CD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (53, 53, 'Cook Islands', 'CK', 'Cook Islands', 'CK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (54, 54, 'Costa Rica', 'CR', 'Costa Rica', 'CR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (55, 55, 'Cote D Ivoire', 'CI', 'Cote D Ivoire', 'CI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (56, 56, 'Croatia', 'HR', 'Croatia', 'HR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (57, 57, 'Cuba', 'CU', 'Cuba', 'CU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (58, 58, 'Curacao', 'CB', 'Curacao', 'CB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (59, 59, 'Cyprus', 'CY', 'Cyprus', 'CY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (60, 60, 'Czech Republic', 'CZ', 'Czech Republic', 'CZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (61, 61, 'Denmark', 'DK', 'Denmark', 'DK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (62, 62, 'Djibouti', 'DJ', 'Djibouti', 'DJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (63, 63, 'Dominica', 'DM', 'Dominica', 'DM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (64, 64, 'Dominican Republic', 'DO', 'Dominican Republic', 'DO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (65, 65, 'East Timor', 'TL', 'East Timor', 'TL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (66, 66, 'Ecuador', 'EC', 'Ecuador', 'EC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (67, 67, 'Egypt', 'EG', 'Egypt', 'EG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (68, 68, 'El Salvador', 'SV', 'El Salvador', 'SV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (69, 69, 'Equatorial Guinea', 'GQ', 'Equatorial Guinea', 'GQ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (70, 70, 'Eritrea', 'ER', 'Eritrea', 'ER', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (71, 71, 'Estonia', 'EE', 'Estonia', 'EE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (72, 72, 'Ethiopia', 'ET', 'Ethiopia', 'ET', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (73, 73, 'Falkland Islands', 'FK', 'Falkland Islands', 'FK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (74, 74, 'Faroe Islands', 'FO', 'Faroe Islands', 'FO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (75, 75, 'Fiji', 'FJ', 'Fiji', 'FJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (76, 76, 'Finland', 'FI', 'Finland', 'FI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (77, 77, 'France', 'FR', 'France', 'FR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (78, 78, 'French Guiana', 'GF', 'French Guiana', 'GF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (79, 79, 'French Polynesia', 'PF', 'French Polynesia', 'PF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (80, 80, 'French Southern Ter', 'TF', 'French Southern Ter', 'TF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (81, 81, 'Gabon', 'GA', 'Gabon', 'GA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (82, 82, 'Gambia', 'GM', 'Gambia', 'GM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (83, 83, 'Georgia', 'GE', 'Georgia', 'GE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (84, 84, 'Germany', 'DE', 'Germany', 'DE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (85, 85, 'Ghana', 'GH', 'Ghana', 'GH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (86, 86, 'Gibraltar', 'GI', 'Gibraltar', 'GI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (87, 87, 'Great Britain', 'GB', 'Great Britain', 'GB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (88, 88, 'Greece', 'GR', 'Greece', 'GR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (89, 89, 'Greenland', 'GL', 'Greenland', 'GL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (90, 90, 'Grenada', 'GD', 'Grenada', 'GD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (91, 91, 'Guadeloupe', 'GP', 'Guadeloupe', 'GP', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (92, 92, 'Guam', 'GU', 'Guam', 'GU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (93, 93, 'Guatemala', 'GT', 'Guatemala', 'GT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (94, 94, 'Guinea', 'GN', 'Guinea', 'GN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (95, 95, 'Guinea Bissau', 'GW', 'Guinea Bissau', 'GW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (96, 96, 'Guyana', 'GY', 'Guyana', 'GY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (97, 97, 'Haiti', 'HT', 'Haiti', 'HT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (98, 98, 'Hawaii', 'HW', 'Hawaii', 'HW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (99, 99, 'Honduras', 'HN', 'Honduras', 'HN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (100, 100, 'Hong Kong', 'HK', 'Hong Kong', 'HK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (101, 101, 'Hungary', 'HU', 'Hungary', 'HU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (102, 102, 'Iceland', 'IS', 'Iceland', 'IS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (103, 103, 'India', 'IN', 'India', 'IN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (104, 104, 'Indonesia', 'ID', 'Indonesia', 'ID', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (105, 105, 'Iran', 'IR', 'Iran', 'IR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (106, 106, 'Iraq', 'IQ', 'Iraq', 'IQ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (107, 107, 'Ireland', 'IE', 'Ireland', 'IE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (108, 108, 'Isle of Man', 'IM', 'Isle of Man', 'IM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (109, 109, 'Israel', 'IL', 'Israel', 'IL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (110, 110, 'Italy', 'IT', 'Italy', 'IT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (111, 111, 'Jamaica', 'JM', 'Jamaica', 'JM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (112, 112, 'Japan', 'JP', 'Japan', 'JP', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (113, 113, 'Jordan', 'JO', 'Jordan', 'JO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (114, 114, 'Kazakhstan', 'KZ', 'Kazakhstan', 'KZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (115, 115, 'Kenya', 'KE', 'Kenya', 'KE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (116, 116, 'Kiribati', 'KI', 'Kiribati', 'KI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (117, 117, 'Korea North', 'NK', 'Korea North', 'NK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (118, 118, 'Korea South', 'KS', 'Korea South', 'KS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (119, 119, 'Kuwait', 'KW', 'Kuwait', 'KW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (120, 120, 'Kyrgyzstan', 'KG', 'Kyrgyzstan', 'KG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (121, 121, 'Laos', 'LA', 'Laos', 'LA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (122, 122, 'Latvia', 'LV', 'Latvia', 'LV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (123, 123, 'Lebanon', 'LB', 'Lebanon', 'LB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (124, 124, 'Lesotho', 'LS', 'Lesotho', 'LS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (125, 125, 'Liberia', 'LR', 'Liberia', 'LR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (126, 126, 'Libya', 'LY', 'Libya', 'LY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (127, 127, 'Liechtenstein', 'LI', 'Liechtenstein', 'LI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (128, 128, 'Lithuania', 'LT', 'Lithuania', 'LT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (129, 129, 'Luxembourg', 'LU', 'Luxembourg', 'LU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (130, 130, 'Macau', 'MO', 'Macau', 'MO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (131, 131, 'Macedonia', 'MK', 'Macedonia', 'MK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (132, 132, 'Madagascar', 'MG', 'Madagascar', 'MG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (133, 133, 'Malawi', 'MW', 'Malawi', 'MW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (134, 134, 'Malaysia', 'MY', 'Malaysia', 'MY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (135, 135, 'Maldives', 'MV', 'Maldives', 'MV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (136, 136, 'Mali', 'ML', 'Mali', 'ML', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (137, 137, 'Malta', 'MT', 'Malta', 'MT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (138, 138, 'Marshall Islands', 'MH', 'Marshall Islands', 'MH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (139, 139, 'Martinique', 'MQ', 'Martinique', 'MQ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (140, 140, 'Mauritania', 'MR', 'Mauritania', 'MR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (141, 141, 'Mauritius', 'MU', 'Mauritius', 'MU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (142, 142, 'Mayotte', 'YT', 'Mayotte', 'YT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (143, 143, 'Mexico', 'MX', 'Mexico', 'MX', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (144, 144, 'Micronesia', 'FM', 'Micronesia', 'FM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (145, 145, 'Midway Islands', 'MI', 'Midway Islands', 'MI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (146, 146, 'Moldova', 'MD', 'Moldova', 'MD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (147, 147, 'Monaco', 'MC', 'Monaco', 'MC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (148, 148, 'Mongolia', 'MN', 'Mongolia', 'MN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (149, 149, 'Montserrat', 'MS', 'Montserrat', 'MS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (150, 150, 'Morocco', 'MA', 'Morocco', 'MA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (151, 151, 'Mozambique', 'MZ', 'Mozambique', 'MZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (152, 152, 'Myanmar', 'MM', 'Myanmar', 'MM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (153, 153, 'Nambia', 'NA', 'Nambia', 'NA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (154, 154, 'Nauru', 'NR', 'Nauru', 'NR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (155, 155, 'Nepal', 'NP', 'Nepal', 'NP', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (156, 156, 'Netherland Antilles', 'AN', 'Netherland Antilles', 'AN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (157, 157, 'Netherlands', 'NL', 'Netherlands', 'NL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (158, 158, 'New Caledonia', 'NC', 'New Caledonia', 'NC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (159, 159, 'New Zealand', 'NZ', 'New Zealand', 'NZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (160, 160, 'Nicaragua', 'NI', 'Nicaragua', 'NI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (161, 161, 'Niger', 'NE', 'Niger', 'NE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (162, 162, 'Nigeria', 'NG', 'Nigeria', 'NG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (163, 163, 'Niue', 'NU', 'Niue', 'NU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (164, 164, 'Norfolk Island', 'NF', 'Norfolk Island', 'NF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (165, 165, 'Norway', 'NO', 'Norway', 'NO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (166, 166, 'Oman', 'OM', 'Oman', 'OM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (167, 167, 'Pakistan', 'PK', 'Pakistan', 'PK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (168, 168, 'Palau Island', 'PW', 'Palau Island', 'PW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (169, 169, 'Palestine', 'PS', 'Palestine', 'PS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (170, 170, 'Panama', 'PA', 'Panama', 'PA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (171, 171, 'Papua New Guinea', 'PG', 'Papua New Guinea', 'PG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (172, 172, 'Paraguay', 'PY', 'Paraguay', 'PY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (173, 173, 'Peru', 'PE', 'Peru', 'PE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (174, 174, 'Philippines', 'PH', 'Philippines', 'PH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (175, 175, 'Pitcairn Island', 'PN', 'Pitcairn Island', 'PN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (176, 176, 'Poland', 'PL', 'Poland', 'PL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (177, 177, 'Portugal', 'PT', 'Portugal', 'PT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (178, 178, 'Puerto Rico', 'PR', 'Puerto Rico', 'PR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (179, 179, 'Qatar', 'QA', 'Qatar', 'QA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (180, 180, 'Reunion', 'RE', 'Reunion', 'RE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (181, 181, 'Romania', 'RO', 'Romania', 'RO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (182, 182, 'Russia', 'RU', 'Russia', 'RU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (183, 183, 'Rwanda', 'RW', 'Rwanda', 'RW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (184, 184, 'Samoa', 'WS', 'Samoa', 'WS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (185, 185, 'San Marino', 'SM', 'San Marino', 'SM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (186, 186, 'Sao Tome & Principe', 'ST', 'Sao Tome & Principe', 'ST', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (187, 187, 'Saudi Arabia', 'SA', 'Saudi Arabia', 'SA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (188, 188, 'Senegal', 'SN', 'Senegal', 'SN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (189, 189, 'Serbia & Montenegro', 'CS', 'Serbia & Montenegro', 'CS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (190, 190, 'Seychelles', 'SC', 'Seychelles', 'SC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (191, 191, 'Sierra Leone', 'SL', 'Sierra Leone', 'SL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (192, 192, 'Singapore', 'SG', 'Singapore', 'SG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (193, 193, 'Slovakia', 'SK', 'Slovakia', 'SK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (194, 194, 'Slovenia', 'SI', 'Slovenia', 'SI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (195, 195, 'Solomon Islands', 'SB', 'Solomon Islands', 'SB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (196, 196, 'Somalia', 'SO', 'Somalia', 'SO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (197, 197, 'South Africa', 'ZA', 'South Africa', 'ZA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (198, 198, 'Spain', 'ES', 'Spain', 'ES', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (199, 199, 'Sri Lanka', 'LK', 'Sri Lanka', 'LK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (200, 200, 'St Helena', 'SH', 'St Helena', 'SH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (201, 201, 'St Kitts-Nevis', 'KN', 'St Kitts-Nevis', 'KN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (202, 202, 'St Lucia', 'LC', 'St Lucia', 'LC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (203, 203, 'St Maarten', 'MB', 'St Maarten', 'MB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (204, 204, 'St Pierre & Miquelon', 'PM', 'St Pierre & Miquelon', 'PM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (205, 205, 'St Vincent & Grenadines', 'VC', 'St Vincent & Grenadines', 'VC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (206, 206, 'Sudan', 'SD', 'Sudan', 'SD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (207, 207, 'Suriname', 'SR', 'Suriname', 'SR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (208, 208, 'Svalbard', 'SJ', 'Svalbard', 'SJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (209, 209, 'Swaziland', 'SZ', 'Swaziland', 'SZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (210, 210, 'Sweden', 'SE', 'Sweden', 'SE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (211, 211, 'Switzerland', 'CH', 'Switzerland', 'CH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (212, 212, 'Syria', 'SY', 'Syria', 'SY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (213, 213, 'Tahiti', 'TA', 'Tahiti', 'TA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (214, 214, 'Taiwan', 'TW', 'Taiwan', 'TW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (215, 215, 'Tajikistan', 'TJ', 'Tajikistan', 'TJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (216, 216, 'Tanzania', 'TZ', 'Tanzania', 'TZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (217, 217, 'Thailand', 'TH', 'Thailand', 'TH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (218, 218, 'Togo', 'TG', 'Togo', 'TG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (219, 219, 'Tokelau', 'TK', 'Tokelau', 'TK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (220, 220, 'Tonga', 'TO', 'Tonga', 'TO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (221, 221, 'Trinidad & Tobago', 'TT', 'Trinidad & Tobago', 'TT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (222, 222, 'Tunisia', 'TN', 'Tunisia', 'TN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (223, 223, 'Turkey', 'TR', 'Turkey', 'TR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (224, 224, 'Turkmenistan', 'TM', 'Turkmenistan', 'TM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (225, 225, 'Turks & Caicos Is', 'TC', 'Turks & Caicos Is', 'TC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (226, 226, 'Tuvalu', 'TV', 'Tuvalu', 'TV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (227, 227, 'Uganda', 'UG', 'Uganda', 'UG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (228, 228, 'Ukraine', 'UA', 'Ukraine', 'UA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (229, 229, 'United Arab Emirates', 'AE', 'United Arab Emirates', 'AE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (230, 230, 'United States of America', 'US', 'United States of America', 'US', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (231, 231, 'Uruguay', 'UY', 'Uruguay', 'UY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (232, 232, 'Uzbekistan', 'UZ', 'Uzbekistan', 'UZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (233, 233, 'Vanuatu', 'VU', 'Vanuatu', 'VU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (234, 234, 'Vatican City State', 'VS', 'Vatican City State', 'VS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (235, 235, 'Venezuela', 'VE', 'Venezuela', 'VE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (236, 236, 'Vietnam', 'VN', 'Vietnam', 'VN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (237, 237, 'Virgin Islands (Brit)', 'VG', 'Virgin Islands (Brit)', 'VG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (238, 238, 'Virgin Islands (USA)', 'VI', 'Virgin Islands (USA)', 'VI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (239, 239, 'Wake Island', 'WK', 'Wake Island', 'WK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (240, 240, 'Wallis & Futana Is', 'WF', 'Wallis & Futana Is', 'WF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (241, 241, 'Western Sahara', 'EH', 'Western Sahara', 'EH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (242, 242, 'Yemen', 'YE', 'Yemen', 'YE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (243, 243, 'Zambia', 'ZM', 'Zambia', 'ZM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (244, 244, 'Zimbabwe', 'ZW', 'Zimbabwe', 'ZW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_interno) VALUES (49, 49, 'Colombia', 'CO', 'Columbia', 'CO', NULL, NULL, NULL, NULL, true, NULL);


--
-- TOC entry 2198 (class 0 OID 34268)
-- Dependencies: 1662
-- Data for Name: xcm_db_sexos; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_db_sexos (id_sexo, orden_db, nom_sexo_es, abr_sexo_es, nom_sexo_en, abr_sexo_en, nom_sexo_de, abr_sexo_de, nom_sexo_fr, abr_sexo_fr, is_activo, cod_interno) VALUES (1, 1, 'Masculino', 'M', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_sexos (id_sexo, orden_db, nom_sexo_es, abr_sexo_es, nom_sexo_en, abr_sexo_en, nom_sexo_de, abr_sexo_de, nom_sexo_fr, abr_sexo_fr, is_activo, cod_interno) VALUES (2, 2, 'Femenino', 'F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


--
-- TOC entry 2199 (class 0 OID 34276)
-- Dependencies: 1664
-- Data for Name: xcm_db_tipos_dir; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_db_tipos_dir (id_tipo_dir, orden_db, nom_tipo_dir_es, abr_tipo_dir_es, nom_tipo_dir_en, abr_tipo_dir_en, nom_tipo_dir_de, abr_tipo_dir_de, nom_tipo_dir_fr, abr_tipo_dir_fr, is_activo, cod_interno) VALUES (1, 1, 'Personal', 'P', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_dir (id_tipo_dir, orden_db, nom_tipo_dir_es, abr_tipo_dir_es, nom_tipo_dir_en, abr_tipo_dir_en, nom_tipo_dir_de, abr_tipo_dir_de, nom_tipo_dir_fr, abr_tipo_dir_fr, is_activo, cod_interno) VALUES (2, 2, 'Oficina', 'O', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);


--
-- TOC entry 2200 (class 0 OID 34285)
-- Dependencies: 1666
-- Data for Name: xcm_db_tipos_nuips; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_db_tipos_nuips (id_tipo_nuip, orden_db, nom_tipo_nuip_es, abr_tipo_nuip_es, nom_tipo_nuip_en, abr_tipo_nuip_en, nom_tipo_nuip_de, abr_tipo_nuip_de, nom_tipo_nuip_fr, abr_tipo_nuip_fr, is_activo, cod_interno) VALUES (1, 1, 'Cédula de Ciudadania', 'C.C.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_nuips (id_tipo_nuip, orden_db, nom_tipo_nuip_es, abr_tipo_nuip_es, nom_tipo_nuip_en, abr_tipo_nuip_en, nom_tipo_nuip_de, abr_tipo_nuip_de, nom_tipo_nuip_fr, abr_tipo_nuip_fr, is_activo, cod_interno) VALUES (2, 2, 'Tarjeta de Identidad', 'T.I.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_nuips (id_tipo_nuip, orden_db, nom_tipo_nuip_es, abr_tipo_nuip_es, nom_tipo_nuip_en, abr_tipo_nuip_en, nom_tipo_nuip_de, abr_tipo_nuip_de, nom_tipo_nuip_fr, abr_tipo_nuip_fr, is_activo, cod_interno) VALUES (3, 3, 'Pasaporte', 'Pas.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_nuips (id_tipo_nuip, orden_db, nom_tipo_nuip_es, abr_tipo_nuip_es, nom_tipo_nuip_en, abr_tipo_nuip_en, nom_tipo_nuip_de, abr_tipo_nuip_de, nom_tipo_nuip_fr, abr_tipo_nuip_fr, is_activo, cod_interno) VALUES (4, 4, 'Cédula de Extranjeria', 'C.E.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_nuips (id_tipo_nuip, orden_db, nom_tipo_nuip_es, abr_tipo_nuip_es, nom_tipo_nuip_en, abr_tipo_nuip_en, nom_tipo_nuip_de, abr_tipo_nuip_de, nom_tipo_nuip_fr, abr_tipo_nuip_fr, is_activo, cod_interno) VALUES (5, 5, 'Registro Civil', 'R.C.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_nuips (id_tipo_nuip, orden_db, nom_tipo_nuip_es, abr_tipo_nuip_es, nom_tipo_nuip_en, abr_tipo_nuip_en, nom_tipo_nuip_de, abr_tipo_nuip_de, nom_tipo_nuip_fr, abr_tipo_nuip_fr, is_activo, cod_interno) VALUES (6, 6, 'Libreta Militar', 'L.M.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_nuips (id_tipo_nuip, orden_db, nom_tipo_nuip_es, abr_tipo_nuip_es, nom_tipo_nuip_en, abr_tipo_nuip_en, nom_tipo_nuip_de, abr_tipo_nuip_de, nom_tipo_nuip_fr, abr_tipo_nuip_fr, is_activo, cod_interno) VALUES (7, 7, 'NIT', 'Nit.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);


--
-- TOC entry 2201 (class 0 OID 34294)
-- Dependencies: 1668
-- Data for Name: xcm_db_tipos_tel; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_db_tipos_tel (id_tipo_tel, orden_db, nom_tipo_tel_es, abr_tipo_tel_es, nom_tipo_tel_en, abr_tipo_tel_en, nom_tipo_tel_de, abr_tipo_tel_de, nom_tipo_tel_fr, abr_tipo_tel_fr, is_activo, cod_interno) VALUES (1, 1, 'Personal', 'Per', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_tipos_tel (id_tipo_tel, orden_db, nom_tipo_tel_es, abr_tipo_tel_es, nom_tipo_tel_en, abr_tipo_tel_en, nom_tipo_tel_de, abr_tipo_tel_de, nom_tipo_tel_fr, abr_tipo_tel_fr, is_activo, cod_interno) VALUES (2, 2, 'Trabajo', 'Tra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_tipos_tel (id_tipo_tel, orden_db, nom_tipo_tel_es, abr_tipo_tel_es, nom_tipo_tel_en, abr_tipo_tel_en, nom_tipo_tel_de, abr_tipo_tel_de, nom_tipo_tel_fr, abr_tipo_tel_fr, is_activo, cod_interno) VALUES (3, 3, 'Celular', 'Cel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_tipos_tel (id_tipo_tel, orden_db, nom_tipo_tel_es, abr_tipo_tel_es, nom_tipo_tel_en, abr_tipo_tel_en, nom_tipo_tel_de, abr_tipo_tel_de, nom_tipo_tel_fr, abr_tipo_tel_fr, is_activo, cod_interno) VALUES (4, 4, 'Fax', 'Fax', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_tipos_tel (id_tipo_tel, orden_db, nom_tipo_tel_es, abr_tipo_tel_es, nom_tipo_tel_en, abr_tipo_tel_en, nom_tipo_tel_de, abr_tipo_tel_de, nom_tipo_tel_fr, abr_tipo_tel_fr, is_activo, cod_interno) VALUES (5, 5, 'Avantel', 'Avt', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


--
-- TOC entry 2202 (class 0 OID 34302)
-- Dependencies: 1670
-- Data for Name: xcm_db_titulos_nuips; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_db_titulos_nuips (id_titulo_nuip, orden_db, nom_titulo_nuip_es, abr_titulo_nuip_es, nom_titulo_nuip_en, abr_titulo_nuip_en, nom_titulo_nuip_de, abr_titulo_nuipo_de, nom_titulo_nuip_fr, abr_titulo_nuip_fr, is_activo, cod_interno) VALUES (1, 1, 'Señor', 'Sr.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_titulos_nuips (id_titulo_nuip, orden_db, nom_titulo_nuip_es, abr_titulo_nuip_es, nom_titulo_nuip_en, abr_titulo_nuip_en, nom_titulo_nuip_de, abr_titulo_nuipo_de, nom_titulo_nuip_fr, abr_titulo_nuip_fr, is_activo, cod_interno) VALUES (2, 2, 'Señorita', 'Srta.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_titulos_nuips (id_titulo_nuip, orden_db, nom_titulo_nuip_es, abr_titulo_nuip_es, nom_titulo_nuip_en, abr_titulo_nuip_en, nom_titulo_nuip_de, abr_titulo_nuipo_de, nom_titulo_nuip_fr, abr_titulo_nuip_fr, is_activo, cod_interno) VALUES (3, 3, 'Señora', 'Sra.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_titulos_nuips (id_titulo_nuip, orden_db, nom_titulo_nuip_es, abr_titulo_nuip_es, nom_titulo_nuip_en, abr_titulo_nuip_en, nom_titulo_nuip_de, abr_titulo_nuipo_de, nom_titulo_nuip_fr, abr_titulo_nuip_fr, is_activo, cod_interno) VALUES (4, 4, 'Ingeniero', 'Ing.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_titulos_nuips (id_titulo_nuip, orden_db, nom_titulo_nuip_es, abr_titulo_nuip_es, nom_titulo_nuip_en, abr_titulo_nuip_en, nom_titulo_nuip_de, abr_titulo_nuipo_de, nom_titulo_nuip_fr, abr_titulo_nuip_fr, is_activo, cod_interno) VALUES (5, 5, 'Doctor', 'Dr.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);


--
-- TOC entry 2203 (class 0 OID 34310)
-- Dependencies: 1672
-- Data for Name: xcm_grupos; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_grupos (id_grupo, id_nuip_serial, nom_grupo, desc_grupo) VALUES (0, 0, 'netDBX', 'Digital Business DBX Ltda.');
INSERT INTO xcm_grupos (id_grupo, id_nuip_serial, nom_grupo, desc_grupo) VALUES (1, 0, 'FET', 'Fondo de Empleados Tadeístas');


--
-- TOC entry 2204 (class 0 OID 34318)
-- Dependencies: 1674
-- Data for Name: xcm_grupos_permisos; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_grupos_permisos (id_grupo_permiso, id_grupo, id_permiso, fec_tx, login_admin) VALUES (1, 0, '000000000', '2008-09-24 08:40:40.471', 'dbxdba');
INSERT INTO xcm_grupos_permisos (id_grupo_permiso, id_grupo, id_permiso, fec_tx, login_admin) VALUES (2, 0, '000000009', '2008-09-24 08:40:40.471', 'dbxdba');
INSERT INTO xcm_grupos_permisos (id_grupo_permiso, id_grupo, id_permiso, fec_tx, login_admin) VALUES (3, 0, '000000006', '2008-09-24 08:40:40.471', 'dbxdba');
INSERT INTO xcm_grupos_permisos (id_grupo_permiso, id_grupo, id_permiso, fec_tx, login_admin) VALUES (4, 0, '000000001', '2008-09-24 08:40:40.471', 'dbxdba');
INSERT INTO xcm_grupos_permisos (id_grupo_permiso, id_grupo, id_permiso, fec_tx, login_admin) VALUES (5, 0, '000000002', '2008-09-24 08:40:40.471', 'dbxdba');
INSERT INTO xcm_grupos_permisos (id_grupo_permiso, id_grupo, id_permiso, fec_tx, login_admin) VALUES (6, 0, '000000003', '2008-09-24 08:40:40.471', 'dbxdba');
INSERT INTO xcm_grupos_permisos (id_grupo_permiso, id_grupo, id_permiso, fec_tx, login_admin) VALUES (7, 0, '000001', '2008-09-24 08:40:40.471', 'dbxdba');
INSERT INTO xcm_grupos_permisos (id_grupo_permiso, id_grupo, id_permiso, fec_tx, login_admin) VALUES (8, 0, '000000', '2008-09-24 08:40:40.471', 'dbxdba');


--
-- TOC entry 2205 (class 0 OID 34336)
-- Dependencies: 1678
-- Data for Name: xcm_niveles_usuario; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_niveles_usuario (id_nivel_usuario, nom_nivel_usuario) VALUES (0, 'Usuario DBX');
INSERT INTO xcm_niveles_usuario (id_nivel_usuario, nom_nivel_usuario) VALUES (1, 'Usuario Propietario');
INSERT INTO xcm_niveles_usuario (id_nivel_usuario, nom_nivel_usuario) VALUES (2, 'Usuario Cliente');


--
-- TOC entry 2190 (class 0 OID 34195)
-- Dependencies: 1642
-- Data for Name: xcm_nuips; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (1, 800037133, 3, 7, 'Fondo de Empleados Tadeístas', NULL, 'Adriana Peña', NULL, NULL, NULL, NULL, 5, 'dbxdba', '2010-11-22 19:23:50.058782');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (0, 900084341, NULL, 7, 'Digital Business DBX Ltda.', NULL, NULL, NULL, NULL, NULL, NULL, 5, 'dbxdba', '2011-03-23 17:25:19.775647');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (9, 0, NULL, NULL, 'VOTO EN BLANCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2011-03-22 12:09:02.937171');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (11, 41469421, NULL, NULL, 'AARON VALERA MARIA HELENA', '', NULL, NULL, '1947-11-27 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (12, 41715866, NULL, NULL, 'ACEVEDO DE GOMEZ GLORIA', '', NULL, NULL, '1988-10-19 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (13, 51911513, NULL, NULL, 'ACOSTA BAQUERO PATRICIA', '', NULL, NULL, '1949-06-30 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (14, 41449470, NULL, NULL, 'ACOSTA CASTIBLANCO GLORIA MARIA', '', NULL, NULL, '1950-01-24 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (15, 80425738, NULL, NULL, 'ACOSTA MARQUEZ CAMILO ANDRES', '', NULL, NULL, '1956-03-27 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (16, 7320514, NULL, NULL, 'ACUÑA MACANA CARLOS ANDRES', '', NULL, NULL, '1971-07-12 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (17, 20878598, NULL, NULL, 'AGUILAR CHACON ANA SOFIA', '', NULL, NULL, '1936-04-06 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (18, 52976491, NULL, NULL, 'AGUIRRE PALACIOS DAYANA CATHERINE', '', NULL, NULL, '1963-02-23 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (19, 17074782, NULL, NULL, 'AGUIRRE SAENZ LIBARDO', '', NULL, NULL, '1964-11-25 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (20, 11448086, NULL, NULL, 'AHUMADA CASTIBLANCO JORGE ALEXANDER', '', NULL, NULL, '1967-07-14 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (21, 79878587, NULL, NULL, 'ALBA ALBA PEDRO ANTONIO', '', NULL, NULL, '1986-09-10 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (22, 79598482, NULL, NULL, 'ALBERTO RUBIO LUIS CARLOS', '', NULL, NULL, '1938-01-04 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (23, 1026261733, NULL, NULL, 'ALDANA TABARES ANGELICA MARIA', '', NULL, NULL, '1957-09-24 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (24, 1079388514, NULL, NULL, 'ALMARIO FAJARDO KARLA FERNANDA', '', NULL, NULL, '1929-10-06 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (25, 19415314, NULL, NULL, 'ALMEIDA CASTRO MIGUEL ANGEL', '', NULL, NULL, '1934-10-31 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (26, 35459778, NULL, NULL, 'ALVARADO CHACON ELVIRA MARIA', '', NULL, NULL, '1934-11-15 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (27, 19434551, NULL, NULL, 'ALVARADO GOMEZ HECTOR A', '', NULL, NULL, '1953-10-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (28, 49759058, NULL, NULL, 'ALVARADO MAESTRE JANNYS ESTHER', '', NULL, NULL, '1928-10-09 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (29, 39783914, NULL, NULL, 'ALVAREZ REVELO LILIANA', '', NULL, NULL, '1947-04-06 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (30, 79654905, NULL, NULL, 'ALVAREZ ROMERO FERNANDO ALBERTO', '', NULL, NULL, '1969-02-22 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (31, 79655902, NULL, NULL, 'ALVAREZ VACA PEDRO JOSE', '', NULL, NULL, '1960-06-16 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (32, 79649173, NULL, NULL, 'ALVAREZ VASQUEZ ARTURO DE JESUS', '', NULL, NULL, '1961-06-06 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (33, 19182082, NULL, NULL, 'ALZAMORA CORREA EDGAR IVAN', '', NULL, NULL, '1969-02-13 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (34, 51650871, NULL, NULL, 'AMARILLO ARIAS GLADYS', '', NULL, NULL, '1931-08-05 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (35, 53002143, NULL, NULL, 'AMOROCHO PAIPA MARILUZ', '', NULL, NULL, '1929-01-25 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (36, 8697397, NULL, NULL, 'ANGEL PRIETO MAURICIO ARTURO', '', NULL, NULL, '1933-05-07 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (37, 79505992, NULL, NULL, 'ANGULO VALENZUELA CAMILO ANDRES', '', NULL, NULL, '1933-04-08 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (38, 39759234, NULL, NULL, 'ANTOLINEZ VILLAMIZAR OLGA LUCIA', '', NULL, NULL, '1950-06-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (163, 51638755, NULL, NULL, 'FAJARDO VALENCIA GLORIA CONSUELO', '', NULL, NULL, '1947-04-25 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (39, 52128825, NULL, NULL, 'APONTE ACEVEDO MARIA DEL CARMEN', '', NULL, NULL, '1960-02-08 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (40, 79303522, NULL, NULL, 'APONTE ROMERO JUAN CARLOS', '', NULL, NULL, '1948-07-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (41, 79939195, NULL, NULL, 'ARAMBULA CORREA JORGE ANDRES', '', NULL, NULL, '1962-02-20 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (42, 17188724, NULL, NULL, 'ARANGUREN ARANGUREN REGULO', '', NULL, NULL, '1965-11-09 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (43, 17093301, NULL, NULL, 'ARAOZ FRASER RAMIREZ SANTIAGO', '', NULL, NULL, '1960-10-13 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (44, 52411371, NULL, NULL, 'ARCE LINDA EMILSE', '', NULL, NULL, '1929-10-19 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (45, 75071857, NULL, NULL, 'ARCE LOPEZ RICARDO', '', NULL, NULL, '1964-07-17 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (46, 1032427508, NULL, NULL, 'ARCHILA SANTAMARIA SINDY CAROLINA', '', NULL, NULL, '1928-12-26 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (47, 52417074, NULL, NULL, 'ARDILA CHAPARRO YENNY', '', NULL, NULL, '1933-10-27 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (48, 53103061, NULL, NULL, 'ARDILA CORZO LUISA FERNANDA', '', NULL, NULL, '1962-08-06 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (49, 20964955, NULL, NULL, 'ARENAS GINNA LICET', '', NULL, NULL, '1969-01-16 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (50, 35518882, NULL, NULL, 'ARIAS ACOSTA LUZ ELEONORA', '', NULL, NULL, '1978-11-29 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (51, 79153443, NULL, NULL, 'ARIAS BUSTAMANTE JORGE ENRIQUE', '', NULL, NULL, '1932-03-19 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (52, 41616658, NULL, NULL, 'AVELLANEDA AGUILAR JUDITH AMANDA', '', NULL, NULL, '1979-02-18 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (53, 52795136, NULL, NULL, 'BALLEN SERRANO MARIA ANGELICA', '', NULL, NULL, '1979-10-08 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (54, 51807678, NULL, NULL, 'BARBOSA ALONSO ESPERANZA', '', NULL, NULL, '1922-07-21 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (55, 20389631, NULL, NULL, 'BARBOSA DE TRUJILLO MARIA PATRICIA', '', NULL, NULL, '1947-10-14 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (56, 52080776, NULL, NULL, 'BARRAGAN MORENO SANDRA PATRICIA', '', NULL, NULL, '1947-02-25 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (57, 52880108, NULL, NULL, 'BARRERA HOYOS ALEXANDRA', '', NULL, NULL, '1947-12-05 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (58, 79834607, NULL, NULL, 'BARRETO CARVAJAL OSCAR MAURICIO', '', NULL, NULL, '1947-12-06 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (59, 1013585815, NULL, NULL, 'BARRETO CORTES JAIRO ALONSO', '', NULL, NULL, '1950-12-18 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (60, 53139855, NULL, NULL, 'BARRETO QUINTERO MARTHA LORENA', '', NULL, NULL, '1951-01-24 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (61, 79687994, NULL, NULL, 'BARRIOS RUBIO ANDRES', '', NULL, NULL, '1951-08-02 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (62, 51763155, NULL, NULL, 'BASTIDAS SALAZAR DIANA', '', NULL, NULL, '1950-04-18 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (63, 21562864, NULL, NULL, 'BATEMAN GAMBOA EVA JULIANA', '', NULL, NULL, '1950-04-11 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (64, 10171034, NULL, NULL, 'BAUTISTA DUBAN A', '', NULL, NULL, '1952-12-14 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (65, 52053124, NULL, NULL, 'BECERRA USEDA SARA', '', NULL, NULL, '1952-07-24 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (66, 80378261, NULL, NULL, 'BEJARANO CLEYDER EDIXON', '', NULL, NULL, '1954-10-10 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (67, 20500158, NULL, NULL, 'BELLO AVILA CLAUDIA CAROLINA', '', NULL, NULL, '1956-02-14 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (68, 41377635, NULL, NULL, 'BELTRAN DE FORERO MIRYAM', '', NULL, NULL, '1920-05-27 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (69, 52969995, NULL, NULL, 'BELTRAN ZAMBRANO YEIMY JOHANNA', '', NULL, NULL, '1957-07-23 00:00:00', 'MANSAROVAR  ENERGY ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (70, 51988175, NULL, NULL, 'BENAVIDES CALDERON GILMA AMANDA', '', NULL, NULL, '1954-08-06 00:00:00', 'MANSAROVAR  ENERGY ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (71, 79783037, NULL, NULL, 'BENAVIDES GUIOVANNY FERNAND', '', NULL, NULL, '1957-10-26 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (72, 51737514, NULL, NULL, 'BENAVIDES MAYORCA MARIETTA', '', NULL, NULL, '1974-11-29 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (73, 51572206, NULL, NULL, 'BERMUDEZ LLANOS LUZ MARY', '', NULL, NULL, '1984-12-17 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (74, 51917235, NULL, NULL, 'BERNAL DIAZ MARTHA LILIANA', '', NULL, NULL, '1948-09-26 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (75, 53006312, NULL, NULL, 'BERNAL SANCHEZ MARIA DEL CARMEN', '', NULL, NULL, '1945-11-19 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (76, 79687569, NULL, NULL, 'BERRIO RIVERO JUAN PABLO', '', NULL, NULL, '1932-11-08 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (77, 93360964, NULL, NULL, 'BOCANEGRA URIBE ALDEMAR', '', NULL, NULL, '1952-01-25 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (78, 1032394507, NULL, NULL, 'BOHORQUEZ FARIETA EDGAR HERNAN', '', NULL, NULL, '1933-05-18 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (79, 36181865, NULL, NULL, 'BONILLA BENITEZ MAGDALENA LUCIA', '', NULL, NULL, '1950-05-10 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (80, 79244729, NULL, NULL, 'BONILLA URIBE JOSE DE JESUS', '', NULL, NULL, '1960-12-24 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (81, 52707241, NULL, NULL, 'BOTELLO JARAMILLO SANDRA LILIANA', '', NULL, NULL, '1928-11-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (82, 52386111, NULL, NULL, 'BUITRAGO LEGUIZAMON NANCY EDITH', '', NULL, NULL, '1939-10-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (83, 52190997, NULL, NULL, 'BUITRAGO MARTINEZ LILIANA', '', NULL, NULL, '1929-12-21 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (84, 41441382, NULL, NULL, 'BUSTOS CARDOSO ELVIA', '', NULL, NULL, '1966-07-05 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (85, 52707165, NULL, NULL, 'BUSTOS MONTES DIANA MILENA', '', NULL, NULL, '1956-03-19 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (86, 79794466, NULL, NULL, 'CADENA SANCHEZ ARIEL OSWALDO', '', NULL, NULL, '1932-05-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (87, 91473496, NULL, NULL, 'CALA VITERY FAVIO ERNESTO', '', NULL, NULL, '1966-12-03 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (88, 77034445, NULL, NULL, 'CALDERON AARON ADALFRE', '', NULL, NULL, '1979-06-16 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (89, 43610032, NULL, NULL, 'CALDERON CARMONA GLORIA PATRICIA', '', NULL, NULL, '1956-08-04 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (90, 66904729, NULL, NULL, 'CALVO VILLADA AIDA PATRICIA', '', NULL, NULL, '1932-12-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (91, 80141447, NULL, NULL, 'CAMACHO ACOSTA EDWIN ALEXIS', '', NULL, NULL, '1956-04-03 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (92, 52045468, NULL, NULL, 'CAMACHO CAMPOS LUCIA', '', NULL, NULL, '1932-05-13 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (93, 52823229, NULL, NULL, 'CAMPOS ROSARIO ANA MARIA', '', NULL, NULL, '1960-11-04 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (94, 10283129, NULL, NULL, 'CANO PLATA CARLOS ALBERTO', '', NULL, NULL, '1961-08-29 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (95, 41593722, NULL, NULL, 'CANOSA DE BARRERO AMPARO', '', NULL, NULL, '1965-01-26 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (96, 1032370843, NULL, NULL, 'CANTOR JUAN SEBASTIAN', '', NULL, NULL, '1962-10-02 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (97, 10301026, NULL, NULL, 'CARDENAS CAICEDO JUAN PABLO', '', NULL, NULL, '1966-11-04 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (98, 1032392992, NULL, NULL, 'CARDENAS GARCIA INGRID YINETH', '', NULL, NULL, '1970-05-14 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (99, 79653522, NULL, NULL, 'CARDENAS LOPEZ DAVID FRANCISCO', '', NULL, NULL, '1933-06-04 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (349, 39758934, NULL, NULL, 'NINO MELO SONIA', '', NULL, NULL, '1946-03-31 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (100, 79354006, NULL, NULL, 'CARDENAS MENDOZA GUSTAVO ENRIQUE', '', NULL, NULL, '1971-04-27 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (101, 23562138, NULL, NULL, 'CARDENAS MORA SANDRA MILENA', '', NULL, NULL, '1934-10-30 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (102, 13804861, NULL, NULL, 'CARDONA RAMIREZ JORGE', '', NULL, NULL, '1929-07-20 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (103, 28715356, NULL, NULL, 'CARDOSO RAMIREZ MAGDALENA', '', NULL, NULL, '1930-07-17 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (104, 7144719, NULL, NULL, 'CARRANZA GRANADOS JAIME RAFAEL', '', NULL, NULL, '1922-09-29 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (105, 80183285, NULL, NULL, 'CARRION SANCHEZ RAFAEL LIBARDO', '', NULL, NULL, '1940-06-13 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (106, 1030541051, NULL, NULL, 'CARVAJAL ROBLES LEYDY CATERINE', '', NULL, NULL, '1940-10-12 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (107, 19272471, NULL, NULL, 'CASALLAS PARRA CARLOS JULIO', '', NULL, NULL, '1936-12-18 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (108, 1032421197, NULL, NULL, 'CASTAÑEDA VARGAS ALVARO ALEXANDER', '', NULL, NULL, '1939-03-13 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (109, 52158555, NULL, NULL, 'CASTAÑO MOLANO ALEXANDRA', '', NULL, NULL, '1939-08-19 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (110, 41630737, NULL, NULL, 'CASTRELLON RUIZ FABIOLA', '', NULL, NULL, '1940-09-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (111, 53081497, NULL, NULL, 'CASTRO SANTOS NATALIA ALEXANDRA', '', NULL, NULL, '1939-05-04 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (112, 19275648, NULL, NULL, 'CELIS CALDERON LUIS CARLOS', '', NULL, NULL, '1940-11-22 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (113, 1013596620, NULL, NULL, 'CHACON CAMACHO PAOLA GISELLE', '', NULL, NULL, '1940-10-26 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (114, 85454691, NULL, NULL, 'CHARRIS SIERRA CARLOS ALBERTO', '', NULL, NULL, '1940-08-08 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (115, 51716808, NULL, NULL, 'CHAVES GUERRERO AIDEE PATRICIA', '', NULL, NULL, '1930-10-13 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (116, 80220168, NULL, NULL, 'CHICA CEPEDA CARLOS FERNANDO', '', NULL, NULL, '1935-09-26 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (117, 20321663, NULL, NULL, 'CIFUENTES DE GOMEZ CLARA', '', NULL, NULL, '1939-10-02 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (118, 39707178, NULL, NULL, 'CIFUENTES RODRIGUEZ NANCY', '', NULL, NULL, '1941-02-06 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (119, 17088347, NULL, NULL, 'COHEN ROSALES LIBARDO ANTONIO', '', NULL, NULL, '1927-01-03 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (120, 79145249, NULL, NULL, 'COLMENARES MELGAREJO HENRY', '', NULL, NULL, '1941-03-03 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (121, 1032412611, NULL, NULL, 'COMBITA ARIAS YENNY MARCELA', '', NULL, NULL, '1941-05-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (122, 39571825, NULL, NULL, 'CONDE RODRIGUEZ YIYOLA E', '', NULL, NULL, '1941-08-16 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (123, 79398773, NULL, NULL, 'CONTENTO RUBIO MANUEL RICARDO', '', NULL, NULL, '1941-06-12 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (124, 52982530, NULL, NULL, 'CONTRERAS RIOS DORIS MARCELA', '', NULL, NULL, '1942-03-01 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (125, 60440577, NULL, NULL, 'CORONEL JAIMES LAURA CONSTANZA', '', NULL, NULL, '1942-06-14 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (126, 79155076, NULL, NULL, 'CORRAL CUARTAS ALVARO JULIAN FRA', '', NULL, NULL, '1939-08-01 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (127, 53065814, NULL, NULL, 'CORREDOR GARCIA MARIA DEL PILAR', '', NULL, NULL, '1941-07-12 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (128, 41722016, NULL, NULL, 'CORTES CHIVATA GLORIA STELLA', '', NULL, NULL, '1940-04-07 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (129, 19328290, NULL, NULL, 'CORTES CONTENTO CARLOS ABELARDO', '', NULL, NULL, '1942-09-18 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (130, 2876282, NULL, NULL, 'CORTES LOMBANA ABDON', '', NULL, NULL, '1943-09-09 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (131, 41426266, NULL, NULL, 'CORTES ROA ESPERANZA', '', NULL, NULL, '1943-02-25 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (132, 52263816, NULL, NULL, 'CORTES SALGADO MARTHA ISABEL', '', NULL, NULL, '1942-11-04 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (133, 79757863, NULL, NULL, 'COY AVILA LUIS RODOLFO', '', NULL, NULL, '1943-11-03 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (134, 51896145, NULL, NULL, 'CRIOLLO ROLDAN ALCIRA', '', NULL, NULL, '1943-10-03 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (135, 22675754, NULL, NULL, 'CRUZ SOTO SORAYA', '', NULL, NULL, '1944-07-17 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (136, 52260202, NULL, NULL, 'CUBIDES DIEZ LUZ ALEXANDRA', '', NULL, NULL, '1943-08-06 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (137, 1010193807, NULL, NULL, 'CUELLAR GUERRERO DIANA KATERINE', '', NULL, NULL, '1943-01-20 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (138, 57435806, NULL, NULL, 'CUELLO DAZA LAMIA PIEDAD', '', NULL, NULL, '1945-02-25 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (139, 51996724, NULL, NULL, 'CUERVO GARZON IDANIRA', '', NULL, NULL, '1945-12-08 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (140, 19366641, NULL, NULL, 'CUERVO SUAREZ GUILLERMO', '', NULL, NULL, '1944-09-04 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (141, 41719019, NULL, NULL, 'DE GREIFF PIRAJAN CLAUDIA', '', NULL, NULL, '1945-10-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (142, 79334476, NULL, NULL, 'DELGADO RINCON ROBERTO', '', NULL, NULL, '1947-02-27 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (143, 79790178, NULL, NULL, 'DIAZ ALVAREZ GUILLERMO', '', NULL, NULL, '1946-11-05 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (144, 41653871, NULL, NULL, 'DIAZ DIAZ MYRIAM ESTELA', '', NULL, NULL, '1947-03-13 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (145, 52958717, NULL, NULL, 'DIAZ GUEVARA DIANA CRISTINA', '', NULL, NULL, '1923-12-05 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (146, 20492975, NULL, NULL, 'DIAZ MORA MARIA CRISTINA', '', NULL, NULL, '1946-04-19 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (147, 422328, NULL, NULL, 'DIAZ TOLEDO FRANCISCO JAVIER', '', NULL, NULL, '1946-11-17 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (148, 28890970, NULL, NULL, 'DUBOIS RUIZ MARIA BETHEL', '', NULL, NULL, '1947-08-24 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (149, 35495732, NULL, NULL, 'DUQUE BERNAL TERESITA DEL N JE', '', NULL, NULL, '1947-12-30 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (150, 3229027, NULL, NULL, 'DUQUE RUEDA LUIS FELIPE', '', NULL, NULL, '1947-07-20 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (151, 35462539, NULL, NULL, 'DURAN ARIAS MARIA MERCEDES', '', NULL, NULL, '1961-10-05 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (152, 52519990, NULL, NULL, 'DURAN GIL SANDRA', '', NULL, NULL, '1962-06-19 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (153, 79791876, NULL, NULL, 'DURAN IBATA OSCAR MAURICIO', '', NULL, NULL, '1945-01-21 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (154, 51564030, NULL, NULL, 'ECHEVERRY DIAZ MAGDABELLY', '', NULL, NULL, '1946-06-09 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (155, 19393369, NULL, NULL, 'ENCINALES ARANGO RUBEN DARIO', '', NULL, NULL, '1953-12-18 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (156, 80112655, NULL, NULL, 'ESCOBAR RODRIGUEZ JOHN HERNANDO', '', NULL, NULL, '1955-03-11 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (157, 79366481, NULL, NULL, 'ESCOBAR VELASQUEZ HUGO', '', NULL, NULL, '1954-10-17 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (158, 51816348, NULL, NULL, 'ESPITIA CASTILLO MARGARITA RUTH', '', NULL, NULL, '1958-10-01 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (159, 79487415, NULL, NULL, 'ESPITIA LOPEZ HERNANDO', '', NULL, NULL, '1929-02-18 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (160, 35355538, NULL, NULL, 'ESTUPIÑAN PINZON YENNY VIVIANA', '', NULL, NULL, '1981-12-17 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (161, 20800513, NULL, NULL, 'FAJARDO PASCAGAZA CONSUELO', '', NULL, NULL, '1970-07-23 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (162, 46660922, NULL, NULL, 'FAJARDO PLAZAS ELBA NUR', '', NULL, NULL, '1976-02-15 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (164, 79848568, NULL, NULL, 'FERNANDEZ CASTRO SAMUEL ANDRES', '', NULL, NULL, '1954-11-01 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (165, 41664903, NULL, NULL, 'FERNANDEZ PARADA GLADYS', '', NULL, NULL, '1953-01-28 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (166, 80121347, NULL, NULL, 'FIGUEROA CAMELO JHON ALEXANDER', '', NULL, NULL, '1970-08-03 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (167, 53083296, NULL, NULL, 'FLOREZ LEMA SANDRA CATALINA', '', NULL, NULL, '1957-02-21 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (168, 52230869, NULL, NULL, 'FONSECA BASTIDAS JHOANA LUCY', '', NULL, NULL, '1968-10-26 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (169, 51919337, NULL, NULL, 'FONSECA BURGOS NUBIA LUZ', '', NULL, NULL, '1948-06-13 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (170, 20137067, NULL, NULL, 'FONSECA DE DAZA AZUCENA', '', NULL, NULL, '1948-07-20 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (171, 19243557, NULL, NULL, 'FORERO CRUZ RUBEN GUILLERMO', '', NULL, NULL, '1948-08-10 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (172, 79602447, NULL, NULL, 'FORERO LLOREDA ANDRES SANTIAGO', '', NULL, NULL, '1948-12-16 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (173, 41699615, NULL, NULL, 'FORERO MANTILLA MARTHA', '', NULL, NULL, '1948-03-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (174, 41610178, NULL, NULL, 'FORERO MARIN CONSTANZA', '', NULL, NULL, '1949-01-05 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (175, 55169740, NULL, NULL, 'FORERO RIVERA SANDRA LILIANA', '', NULL, NULL, '1948-03-13 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (176, 19362429, NULL, NULL, 'FORERO RODRIGUEZ MARIO ADOLFO', '', NULL, NULL, '1949-09-10 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (177, 79864617, NULL, NULL, 'FRANCO MEDINA MISAEL RICARDO', '', NULL, NULL, '1948-01-11 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (178, 52106237, NULL, NULL, 'FUENTES QUINTERO LUZ STELLA', '', NULL, NULL, '1949-08-27 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (179, 57434906, NULL, NULL, 'FUENTES ROJAS DAREIDIS MARINA', '', NULL, NULL, '1950-02-08 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (180, 17039843, NULL, NULL, 'FULA TORRES JOSE MANUEL', '', NULL, NULL, '1950-05-03 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (181, 52538881, NULL, NULL, 'GAITAN GUEVARA GEORGINA', '', NULL, NULL, '1949-11-04 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (182, 19476197, NULL, NULL, 'GALAN BARRERA DIEGO RICARDO', '', NULL, NULL, '1950-06-05 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (183, 28822670, NULL, NULL, 'GALEANO DE RINCON GRACIELA', '', NULL, NULL, '1952-10-03 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (184, 17580474, NULL, NULL, 'GAONA PEREZ NACOR ARMANDO', '', NULL, NULL, '1951-03-01 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (185, 17198664, NULL, NULL, 'GAONA RIVAS LUIS ENRIQUE', '', NULL, NULL, '1951-04-06 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (186, 12125049, NULL, NULL, 'GARCES CALDERON CARLOS EDUARDO', '', NULL, NULL, '1951-01-22 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (187, 79245606, NULL, NULL, 'GARCIA ALDANA HUMBERTO', '', NULL, NULL, '1951-01-09 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (188, 52156048, NULL, NULL, 'GARCIA GAITAN SILVIA LILIANA', '', NULL, NULL, '1950-07-29 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (189, 79811188, NULL, NULL, 'GARCIA MERCHAN EDWIN', '', NULL, NULL, '1951-06-09 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (190, 79153786, NULL, NULL, 'GARCIA NINO LUIS EDUARDO', '', NULL, NULL, '1951-06-24 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (191, 51723220, NULL, NULL, 'GARCIA PRIETO BLANCA LUCIA', '', NULL, NULL, '1951-08-03 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (192, 1023877420, NULL, NULL, 'GARCIA RATIVA JOSE LUIS', '', NULL, NULL, '1951-04-10 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (193, 79944522, NULL, NULL, 'GARCIA ROLDAN DANIEL', '', NULL, NULL, '1951-07-28 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (194, 80541613, NULL, NULL, 'GARNICA VELASQUEZ JORGE LUIS', '', NULL, NULL, '1951-05-02 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (195, 80158942, NULL, NULL, 'GIL CASTAÑEDA RODRIGO', '', NULL, NULL, '1950-09-16 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (196, 51596085, NULL, NULL, 'GIL DE LOPEZ LUZ VILMA', '', NULL, NULL, '1951-12-17 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (197, 37844115, NULL, NULL, 'GIL FONTECHA NATALIA', '', NULL, NULL, '1952-02-11 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (198, 52742220, NULL, NULL, 'GIL VARGAS DEYRA JOHANA', '', NULL, NULL, '1952-03-05 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (199, 51563334, NULL, NULL, 'GIRALDO MUÑOZ GLORIA EDELMIRA', '', NULL, NULL, '1951-10-19 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (200, 24757172, NULL, NULL, 'GIRALDO TORO LETICIA', '', NULL, NULL, '1950-08-30 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (201, 1019018030, NULL, NULL, 'GIRALDO YEPES YEIMY PAOLA', '', NULL, NULL, '1952-05-27 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (202, 79556041, NULL, NULL, 'GOMEZ CARRILLO NELSON FERNANDO', '', NULL, NULL, '1951-06-21 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (203, 52857532, NULL, NULL, 'GOMEZ CASTRO MAGDA PATRICIA', '', NULL, NULL, '1952-07-19 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (204, 36166077, NULL, NULL, 'GOMEZ COLLAZOS LUZ MYRIAM', '', NULL, NULL, '1952-01-27 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (205, 51957373, NULL, NULL, 'GOMEZ DUARTE CARMEN ELISA', '', NULL, NULL, '1952-09-27 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (206, 79295077, NULL, NULL, 'GOMEZ FIGUEREDO ALBERTO', '', NULL, NULL, '1952-04-27 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (207, 80038432, NULL, NULL, 'GOMEZ LEON ANDRES', '', NULL, NULL, '1951-04-24 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (208, 1076646368, NULL, NULL, 'GOMEZ LOPEZ HENRY MAURICIO', '', NULL, NULL, '1952-09-17 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (209, 79970430, NULL, NULL, 'GOMEZ MELO OMAR FERNANDO', '', NULL, NULL, '1950-08-26 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (210, 42097627, NULL, NULL, 'GOMEZ RINCON MONICA', '', NULL, NULL, '1952-08-02 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (211, 51882733, NULL, NULL, 'GOMEZ SANCHEZ ADRIANA', '', NULL, NULL, '1953-03-11 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (212, 51921967, NULL, NULL, 'GOMEZ SUAREZ AIDA MERCEDES', '', NULL, NULL, '1953-03-10 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (213, 19066342, NULL, NULL, 'GONZALEZ ANDRADE EMIR JOSE', '', NULL, NULL, '1953-03-17 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (214, 52707709, NULL, NULL, 'GONZALEZ MARTINEZ PILAR MARCELA', '', NULL, NULL, '1952-07-30 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (215, 53082427, NULL, NULL, 'GONZALEZ MORENO LIZ KATHERINE', '', NULL, NULL, '1953-11-26 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (216, 39651537, NULL, NULL, 'GONZALEZ PAEZ ALICIA', '', NULL, NULL, '1952-03-02 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (217, 80068060, NULL, NULL, 'GONZALEZ RODRIGUEZ LEONARDO', '', NULL, NULL, '1953-11-08 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (218, 79599981, NULL, NULL, 'GONZALEZ TAMARA LEANDRO', '', NULL, NULL, '1954-04-21 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (219, 79355284, NULL, NULL, 'GORDILLO SICHACA LUIS ADAN', '', NULL, NULL, '1954-09-26 00:00:00', 'MANSAROVAR  ENERGY ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (220, 19456458, NULL, NULL, 'GORDO CHIA FREDY', '', NULL, NULL, '1953-03-19 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (221, 79894202, NULL, NULL, 'GRANADOS LOPERA CARLOS ANDRES', '', NULL, NULL, '1957-12-25 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (222, 52088597, NULL, NULL, 'GRIJALBA BENDECK LYDA MARCELA', '', NULL, NULL, '1954-06-16 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (223, 41690246, NULL, NULL, 'GUTIERREZ CUEVAS LUZ DALIA', '', NULL, NULL, '1954-08-19 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (224, 19167058, NULL, NULL, 'GUTIERREZ GUTIERREZ DANIEL H', '', NULL, NULL, '1955-05-02 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (350, 51560138, NULL, NULL, 'NINO MORENO NIDYA ALICIA', '', NULL, NULL, '1950-06-13 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (225, 51576224, NULL, NULL, 'GUTIERREZ PEREZ MARIA DEL ROSARIO', '', NULL, NULL, '1956-06-07 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (226, 51990026, NULL, NULL, 'GUTIERREZ SANCHEZ SANDRA', '', NULL, NULL, '1955-04-26 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (227, 32668073, NULL, NULL, 'GUZMAN SANDRA VICTORIA', '', NULL, NULL, '1955-02-08 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (228, 52221727, NULL, NULL, 'GUZMAN TOBAR MARTHA ADRIANA', '', NULL, NULL, '1956-04-04 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (229, 52120767, NULL, NULL, 'HENAO CASTRO OLGA LUCIA', '', NULL, NULL, '1954-11-15 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (230, 1010170467, NULL, NULL, 'HEREDIA CORDOBA YURI ANDREA', '', NULL, NULL, '1956-04-25 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (231, 85453258, NULL, NULL, 'HERNANDEZ BELTRAN ROGELIO RAFAEL', '', NULL, NULL, '1954-01-30 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (232, 19068706, NULL, NULL, 'HERNANDEZ BERMUDEZ EDUARDO', '', NULL, NULL, '1957-10-26 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (233, 79158365, NULL, NULL, 'HERNANDEZ FERNANDEZ JAVIER ADOLFO', '', NULL, NULL, '1956-11-17 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (234, 80130460, NULL, NULL, 'HERNANDEZ FONSECA CARLOS JAVIER', '', NULL, NULL, '1955-11-14 00:00:00', 'MANSAROVAR  ENERGY ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (235, 52147679, NULL, NULL, 'HERNANDEZ GARZON YAMILE', '', NULL, NULL, '1958-01-10 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (236, 1015999784, NULL, NULL, 'HERNANDEZ MENESSES ROXANA', '', NULL, NULL, '1958-06-20 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (237, 7544844, NULL, NULL, 'HERRERA ARIAS FRANCISCO EDUARDO', '', NULL, NULL, '1956-01-15 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (238, 79542160, NULL, NULL, 'HOYOS GOMEZ MAURICIO ANTONIO', '', NULL, NULL, '1954-07-08 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (239, 1010178139, NULL, NULL, 'HUERTAS AMAYA KARLA VANESSA', '', NULL, NULL, '1958-04-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (240, 51977756, NULL, NULL, 'HURTADO BUSTO SANDRA LILIANA', '', NULL, NULL, '1958-10-12 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (241, 19209344, NULL, NULL, 'HURTADO TOBIAS', '', NULL, NULL, '1953-01-14 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (242, 80858439, NULL, NULL, 'IBAÑEZ CASTAÑO EDWIN FABIAN', '', NULL, NULL, '1958-09-27 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (243, 19059380, NULL, NULL, 'INSUASTY CHAMORRO SEGUNDO', '', NULL, NULL, '1956-04-09 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (244, 79684640, NULL, NULL, 'INSUASTY DELGADO PABLO ANDRES', '', NULL, NULL, '1954-08-15 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (245, 79602771, NULL, NULL, 'JAIMES CARLOS ALBERTO', '', NULL, NULL, '1958-12-02 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (246, 41351042, NULL, NULL, 'JAIMES DE RUIZ LUISA ADELIA', '', NULL, NULL, '1955-09-24 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (247, 80421515, NULL, NULL, 'JARAMILLO CRUZ PEDRO JAVIER', '', NULL, NULL, '1958-10-14 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (248, 20551120, NULL, NULL, 'JAUREGUI ROMERO GUIOMAR AMINTA', '', NULL, NULL, '1958-06-29 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (249, 41773881, NULL, NULL, 'JIMENEZ FUQUENE SANDRA LUCENA', '', NULL, NULL, '1959-06-23 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (250, 41734370, NULL, NULL, 'JIMENEZ LUGO GLORIA', '', NULL, NULL, '1956-06-24 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (251, 79881246, NULL, NULL, 'JIMENEZ MONTERO FRANCISCO JAVIER', '', NULL, NULL, '1958-03-15 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (252, 51858800, NULL, NULL, 'LAGUNA AREVALO DIANA JEANETH', '', NULL, NULL, '1959-11-16 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (253, 51642304, NULL, NULL, 'LAITON POVEDA LUCIA', '', NULL, NULL, '1959-09-26 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (254, 79456584, NULL, NULL, 'LEGUIZAMON IZQUIERDO MAURICIO', '', NULL, NULL, '1960-03-01 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (255, 35524112, NULL, NULL, 'LEMUS SANCHEZ GLORIA CONSUELO', '', NULL, NULL, '1959-05-18 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (256, 80175595, NULL, NULL, 'LEON NEVA JAIME ALEJANDRO', '', NULL, NULL, '1960-06-08 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (257, 17041827, NULL, NULL, 'LEON PEÑA EDILBERTO', '', NULL, NULL, '1956-10-05 00:00:00', 'MANSAROVAR  ENERGY ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (258, 79416100, NULL, NULL, 'LEON VARGAS LUER', '', NULL, NULL, '1956-04-24 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (259, 79695767, NULL, NULL, 'LINARES CUBIDES DANNY GIGIANO', '', NULL, NULL, '1960-03-02 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (260, 19203523, NULL, NULL, 'LIZCANO CARREÑO CARLOS ALBERTO', '', NULL, NULL, '1959-04-10 00:00:00', 'MANSAROVAR  ENERGY ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (261, 19257991, NULL, NULL, 'LIZCANO GIL JUAN  ORLANDO', '', NULL, NULL, '1957-04-01 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (262, 51629434, NULL, NULL, 'LLANES PAREDES LUZ MARLENE', '', NULL, NULL, '1959-08-28 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (263, 51584619, NULL, NULL, 'LLORENTE SARDI ALICIA', '', NULL, NULL, '1960-07-17 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (264, 79294440, NULL, NULL, 'LONDOÑO LONDOÑO ANDRES MARTIN', '', NULL, NULL, '1959-03-12 00:00:00', 'MANSAROVAR  ENERGY ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (265, 19146584, NULL, NULL, 'LOPEZ ARANGO FRANCISCO', '', NULL, NULL, '1960-09-08 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (266, 1014199527, NULL, NULL, 'LOPEZ CASTELLANOS JHON WALTER', '', NULL, NULL, '1959-08-23 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (267, 41610102, NULL, NULL, 'LOPEZ ESTEPA LUZ FABIOLA', '', NULL, NULL, '1961-05-02 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (268, 1032409194, NULL, NULL, 'LOPEZ GOMEZ CHRISTIAN DAVID', '', NULL, NULL, '1961-04-25 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (269, 79642459, NULL, NULL, 'LOPEZ PEÑUELA HECTOR LEONARDO', '', NULL, NULL, '1961-01-08 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (270, 80258977, NULL, NULL, 'LOPEZ RIVERA EDWIN', '', NULL, NULL, '1960-08-31 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (271, 51736211, NULL, NULL, 'LOZANO AYALA MARCELA ISABEL', '', NULL, NULL, '1961-10-21 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (272, 52053164, NULL, NULL, 'LOZANO BARRERO ADRIANA MARCELA', '', NULL, NULL, '1961-10-27 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (273, 80003575, NULL, NULL, 'LOZANO BUITRAGO MICHAEL', '', NULL, NULL, '1962-01-26 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (274, 20191654, NULL, NULL, 'LOZANO DE REY ESTER', '', NULL, NULL, '1960-08-01 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (275, 51699984, NULL, NULL, 'LOZANO LATORRE DEYANIRA', '', NULL, NULL, '1956-03-12 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (276, 79474942, NULL, NULL, 'LOZANO PALMA AFRANIO', '', NULL, NULL, '1962-10-08 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (277, 19418950, NULL, NULL, 'LOZANO URIBE FABIO', '', NULL, NULL, '1962-06-17 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (278, 80371508, NULL, NULL, 'LUGO JORGE ALCIDES', '', NULL, NULL, '1961-01-05 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (279, 41798450, NULL, NULL, 'LUNA CORTES GILMA JANETH', '', NULL, NULL, '1961-05-08 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (280, 30714547, NULL, NULL, 'MACIAS LOPEZ ANA OMAIRA', '', NULL, NULL, '1962-08-05 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (281, 19482030, NULL, NULL, 'MALAGON GUTIERREZ RICARDO', '', NULL, NULL, '1961-09-17 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (282, 80394767, NULL, NULL, 'MALPICA JAIMES JOSE AGUSTIN', '', NULL, NULL, '1962-10-07 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (283, 74339145, NULL, NULL, 'MANCIPE MANCIPE PABLO ENRIQUE', '', NULL, NULL, '1962-10-13 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (284, 43834431, NULL, NULL, 'MANRIQUE CORREA GLORIA CATALINA', '', NULL, NULL, '1962-12-11 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (285, 51863980, NULL, NULL, 'MANRIQUE HERRERA GLORIA STELLA', '', NULL, NULL, '1957-10-24 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (286, 39755344, NULL, NULL, 'MANTILLA BOTERO MARIA VALENTINA', '', NULL, NULL, '1959-09-11 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (287, 51913449, NULL, NULL, 'MARIN BERNATE JACQUELINE', '', NULL, NULL, '1935-05-03 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (288, 75065810, NULL, NULL, 'MARIN CIFUENTES CARLOS IVAN', '', NULL, NULL, '1929-07-07 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (289, 10285674, NULL, NULL, 'MARIN IDARRAGA DIEGO ARMANDO', '', NULL, NULL, '1934-06-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (290, 80853909, NULL, NULL, 'MARTINEZ DEYBY', '', NULL, NULL, '1931-07-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (291, 1013596299, NULL, NULL, 'MARTINEZ HEREDIA MARIA FERNANDA', '', NULL, NULL, '1931-10-05 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (292, 80225195, NULL, NULL, 'MARTINEZ HERNANDEZ NEILS ANTONINO', '', NULL, NULL, '1932-12-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (293, 79412679, NULL, NULL, 'MARTINEZ PELAEZ CARLOS', '', NULL, NULL, '1929-12-10 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (294, 79698530, NULL, NULL, 'MARTINEZ PEREZ JESUS ANTONIO', '', NULL, NULL, '1929-05-13 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (295, 52710722, NULL, NULL, 'MARTINEZ PRIETO LUZ ANGELA', '', NULL, NULL, '1926-12-06 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (296, 51772817, NULL, NULL, 'MARTINEZ VARON LUZ GUADALUPE', '', NULL, NULL, '1935-12-31 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (297, 19201714, NULL, NULL, 'MASTRODOMENICO BRID HUGO', '', NULL, NULL, '1933-04-10 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (298, 51789119, NULL, NULL, 'MATA HERNANDEZ ELVIA LEONOR', '', NULL, NULL, '1921-10-16 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (299, 41499834, NULL, NULL, 'MATALLANA TRIVIÑO MIRALBA', '', NULL, NULL, '1938-02-12 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (300, 1023862380, NULL, NULL, 'MATIZ SALAMANCA DESY BIBIANA', '', NULL, NULL, '1928-09-28 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (301, 51852408, NULL, NULL, 'MEDINA SALAZAR NIEVES ADRIANA', '', NULL, NULL, '1936-04-25 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (302, 53065327, NULL, NULL, 'MEDINA VANEGAS LEYDY YOHANA', '', NULL, NULL, '1933-12-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (303, 41661097, NULL, NULL, 'MEJIA NARANJO VICTORIA EUGENIA', '', NULL, NULL, '1933-01-27 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (304, 19184382, NULL, NULL, 'MELO CASTIBLANCO JAIME', '', NULL, NULL, '1934-10-28 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (305, 1032402641, NULL, NULL, 'MELO PACHON MIGUEL ANGEL', '', NULL, NULL, '1927-12-21 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (306, 6744407, NULL, NULL, 'MELO VARGAS NESTOR RODRIGO', '', NULL, NULL, '1930-06-29 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (307, 51897962, NULL, NULL, 'MENA RODRIGUEZ VICTORIA EUGENIA', '', NULL, NULL, '1929-03-26 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (308, 41602797, NULL, NULL, 'MILLAN PARRA LUZ STELLA', '', NULL, NULL, '1933-06-18 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (309, 41739890, NULL, NULL, 'MIRANDA DE TOVAR BLANCA ELVI', '', NULL, NULL, '1939-09-09 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (310, 79300989, NULL, NULL, 'MIRANDA GUEVARA FRANCISCO', '', NULL, NULL, '1927-05-28 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (311, 79443243, NULL, NULL, 'MOLANO IBAGUE VICTOR MANUEL', '', NULL, NULL, '1933-04-18 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (312, 1032403077, NULL, NULL, 'MOLANO XIOMARA ALEJANDRA', '', NULL, NULL, '1927-11-17 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (313, 39712345, NULL, NULL, 'MOLINA BERNAL MARY LIDIA', '', NULL, NULL, '1933-10-29 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (314, 41616585, NULL, NULL, 'MONCADA CAMACHO MARIA CONSUELO', '', NULL, NULL, '1927-10-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (315, 51679107, NULL, NULL, 'MONDRAGON GONZALEZ CLARA INES', '', NULL, NULL, '1936-04-19 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (316, 52450656, NULL, NULL, 'MONROY ZULMA JOHANNA', '', NULL, NULL, '1934-03-11 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (317, 79797300, NULL, NULL, 'MONTAÑO BELLO ALFREDO', '', NULL, NULL, '1934-10-17 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (318, 20897013, NULL, NULL, 'MONTEALEGRE CHARRY LAURA', '', NULL, NULL, '1939-12-12 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (319, 13484430, NULL, NULL, 'MORA GRANADOS FREDDY ORLANDO', '', NULL, NULL, '1941-01-15 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (320, 3002522, NULL, NULL, 'MORA JIMENEZ EUDORO', '', NULL, NULL, '1941-01-25 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (321, 80394115, NULL, NULL, 'MORA JIMENEZ IVAN', '', NULL, NULL, '1929-07-24 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (322, 19387904, NULL, NULL, 'MORA MORALES JOSE ALFONSO', '', NULL, NULL, '1937-04-30 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (323, 79625610, NULL, NULL, 'MORA PABON RICARDO', '', NULL, NULL, '1941-07-22 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (324, 19373329, NULL, NULL, 'MORA PARRA LEON JAIRO', '', NULL, NULL, '1942-02-07 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (325, 80262653, NULL, NULL, 'MORA TORRES ALVARO', '', NULL, NULL, '1936-10-03 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (326, 17072365, NULL, NULL, 'MORALES BUITRAGO LUIS IGNACIO', '', NULL, NULL, '1925-05-07 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (327, 19229837, NULL, NULL, 'MORALES FORERO IVAN ANTONIO', '', NULL, NULL, '1930-02-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (328, 41734332, NULL, NULL, 'MORALES PEREZ MARTHA LUCIA', '', NULL, NULL, '1932-01-15 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (329, 79610792, NULL, NULL, 'MORENO ESCARRAGA OSCAR MAURICIO', '', NULL, NULL, '1961-12-04 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (330, 51842331, NULL, NULL, 'MORENO HURTADO SANDRA PATRICIA', '', NULL, NULL, '1939-07-01 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (331, 51974421, NULL, NULL, 'MORENO LATORRE ANA CECILIA', '', NULL, NULL, '1939-02-09 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (332, 79914519, NULL, NULL, 'MORENO NIAMPIRA ALVARO OSMANI', '', NULL, NULL, '1955-04-14 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (333, 1010165362, NULL, NULL, 'MORENO PEDRAZA JENNY ALEXANDRA', '', NULL, NULL, '1972-03-05 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (334, 41710114, NULL, NULL, 'MOSQUERA RAMIREZ MARIA CRISTINA', '', NULL, NULL, '1953-09-27 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (335, 52969742, NULL, NULL, 'MOYA CARVAJAL MARTHA ISABEL', '', NULL, NULL, '1955-01-04 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (336, 1030526402, NULL, NULL, 'MOYA QUITIAN SANLY YOHANA', '', NULL, NULL, '1935-04-21 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (337, 17150620, NULL, NULL, 'MUNEVAR ROZO MIGUEL ENRIQUE', '', NULL, NULL, '1932-03-15 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (338, 79957309, NULL, NULL, 'MUNOZ JOHN JAVIER', '', NULL, NULL, '1931-02-06 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (339, 79352624, NULL, NULL, 'MUNOZ VARGAS JOSE GONZALO', '', NULL, NULL, '1932-05-24 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (340, 1022963918, NULL, NULL, 'MUÑOZ RUIZ ERIKA', '', NULL, NULL, '1934-06-22 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (341, 80726656, NULL, NULL, 'MUÑOZ WILLIAM', '', NULL, NULL, '1928-11-01 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (342, 1070947248, NULL, NULL, 'MURCIA CRUZ MARIA TERESA', '', NULL, NULL, '1926-08-03 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (343, 11428716, NULL, NULL, 'MURILLO BUSTOS ANDRES RICARDO', '', NULL, NULL, '1954-05-01 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (344, 11425514, NULL, NULL, 'MURILLO BUSTOS GABRIEL', '', NULL, NULL, '1937-10-21 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (345, 52537189, NULL, NULL, 'MURILLO ROMERO SHIRLEY ANDREA', '', NULL, NULL, '1932-06-27 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (346, 36547585, NULL, NULL, 'NAVARRO PEREZ NELIDA MERCEDES', '', NULL, NULL, '1930-09-17 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (347, 1026269711, NULL, NULL, 'NIETO VALBUENA NATALY', '', NULL, NULL, '1928-07-17 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (348, 51627922, NULL, NULL, 'NINO GONZALEZ RUTH', '', NULL, NULL, '1936-05-24 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (351, 52309028, NULL, NULL, 'NIÑO GONZALEZ NORMA ALEJANDRA', '', NULL, NULL, '1940-08-30 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (352, 17148937, NULL, NULL, 'NIÑO SALAMANCA EULOGIO', '', NULL, NULL, '1934-06-25 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (353, 79938591, NULL, NULL, 'NOVOA MONTOYA ANDRES RICARDO', '', NULL, NULL, '1929-06-24 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (354, 25034787, NULL, NULL, 'OBANDO BETANCURT GLORIA AMPARO', '', NULL, NULL, '1936-12-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (355, 52180294, NULL, NULL, 'OCAMPO RIVERA CLAUDIA PATRICIA', '', NULL, NULL, '1937-12-14 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (356, 51802909, NULL, NULL, 'OCAMPO RODRIGUEZ MARIA VICTORIA', '', NULL, NULL, '1930-05-28 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (357, 51582627, NULL, NULL, 'OCAMPO VELEZ DIANA', '', NULL, NULL, '1928-10-12 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (358, 35466857, NULL, NULL, 'OCAÑA GOMEZ ADELINA', '', NULL, NULL, '1934-07-24 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (359, 19245635, NULL, NULL, 'OCAÑA GOMEZ JULIO CESAR', '', NULL, NULL, '1942-03-07 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (360, 51601883, NULL, NULL, 'OCHOA SERRANO ANGELA CRISTINA', '', NULL, NULL, '1943-02-13 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (361, 79230405, NULL, NULL, 'OLAYA GUERRERO JESUS EDUARDO', '', NULL, NULL, '1947-08-31 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (362, 8404081, NULL, NULL, 'ORTEGON RODRIGUEZ LUIS AUGUSTO', '', NULL, NULL, '1947-11-06 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (363, 51974214, NULL, NULL, 'ORTIZ CUELLAR LUZ PERLA', '', NULL, NULL, '1946-08-08 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (364, 77155031, NULL, NULL, 'ORTIZ ESPAÑA WILSON JAIR', '', NULL, NULL, '1943-08-25 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (365, 52801406, NULL, NULL, 'ORTIZ GAONA OLGA JANNETH', '', NULL, NULL, '1952-04-05 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (366, 79277836, NULL, NULL, 'OSPINA CARRASQUILLA JUAN MANUEL', '', NULL, NULL, '1954-09-29 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (367, 79270160, NULL, NULL, 'OTALORA COTRINA LEONARDO', '', NULL, NULL, '1955-12-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (368, 14214397, NULL, NULL, 'OTALORA SALCEDO JOSE A', '', NULL, NULL, '1959-10-02 00:00:00', 'MANSAROVAR  ENERGY ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (369, 19190872, NULL, NULL, 'OVIEDO PEÑA JORGE HUMBERTO', '', NULL, NULL, '1947-10-26 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (370, 79791409, NULL, NULL, 'PABON PINTO CARLOS FRANCISCO', '', NULL, NULL, '1939-09-18 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (371, 27805429, NULL, NULL, 'PACHECO MOLINA OMAIRA', '', NULL, NULL, '1952-03-30 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (372, 72192796, NULL, NULL, 'PACHON MANTILLA CARLOS ERNESTO', '', NULL, NULL, '1927-12-04 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (373, 1013595623, NULL, NULL, 'PADILLA GOMEZ LILLY MARICEL', '', NULL, NULL, '1935-09-17 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (374, 1014206310, NULL, NULL, 'PAEZ CORREAL INGRID CAMILA', '', NULL, NULL, '1948-08-14 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (375, 37319773, NULL, NULL, 'PAEZ QUINTERO DORIS CECILIA', '', NULL, NULL, '1947-03-13 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (376, 79794153, NULL, NULL, 'PAEZ VANEGAS CAMILO', '', NULL, NULL, '1973-11-26 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (377, 1032396323, NULL, NULL, 'PALMA GARCIA SANDY CONSTANZA', '', NULL, NULL, '1944-01-31 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (378, 52471359, NULL, NULL, 'PARDO CALDERON GINA PAOLA', '', NULL, NULL, '1932-01-06 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (379, 53098957, NULL, NULL, 'PARDO MONZO PAOLA ANDREA', '', NULL, NULL, '1932-01-03 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (380, 79417213, NULL, NULL, 'PARGA HERRERA HUMBERTO', '', NULL, NULL, '1931-01-14 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (381, 41710009, NULL, NULL, 'PARRA ZAPATA LUZ ALBA', '', NULL, NULL, '1935-07-22 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (382, 79328499, NULL, NULL, 'PATIÑO BARRETO EDGAR', '', NULL, NULL, '1937-03-26 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (383, 39776379, NULL, NULL, 'PAVA GALINDO DIANA PATRICIA', '', NULL, NULL, '1950-12-14 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (384, 14325072, NULL, NULL, 'PEDRAZA CALDERON FABIAN', '', NULL, NULL, '1931-11-11 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (385, 79895695, NULL, NULL, 'PEDRAZA MELO JOSE ARTURO', '', NULL, NULL, '1927-03-01 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (386, 52322840, NULL, NULL, 'PEDROZA RAMOS ROCIO', '', NULL, NULL, '1930-03-13 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (387, 28545262, NULL, NULL, 'PENAGOS ARENAS SOL MARIA', '', NULL, NULL, '1941-02-08 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (388, 51919682, NULL, NULL, 'PEREZ GIL ALEX RUBIELA', '', NULL, NULL, '1942-11-21 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (389, 79141423, NULL, NULL, 'PEREZ RUIZ MARIO ERNESTO', '', NULL, NULL, '1958-05-16 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (390, 51914908, NULL, NULL, 'PEREZ SABOGAL ALEXANDRA VICTORI', '', NULL, NULL, '1938-04-07 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (391, 74337051, NULL, NULL, 'PEREZ VERDUGO JOSE LUIS', '', NULL, NULL, '1943-08-08 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (392, 52205652, NULL, NULL, 'PINTO CARRANZA ANDREA', '', NULL, NULL, '1939-07-21 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (393, 35458334, NULL, NULL, 'PINTO ROZO MYRIAM', '', NULL, NULL, '1933-05-13 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (394, 41799373, NULL, NULL, 'PINZON GONZALEZ GLADYS', '', NULL, NULL, '1926-08-11 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (395, 79719136, NULL, NULL, 'PINZON ORTIZ JOSE DAVID', '', NULL, NULL, '1930-08-07 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (396, 79904851, NULL, NULL, 'PINZON SOLARTE DANIEL ENRIQUE', '', NULL, NULL, '1943-05-22 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (397, 39736620, NULL, NULL, 'PINZON ZUÑIGA NIDIA BEATRIZ', '', NULL, NULL, '1931-06-04 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (398, 23623002, NULL, NULL, 'PIÑEROS CASTRO NUBIA YINETH', '', NULL, NULL, '1930-08-29 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (399, 51735870, NULL, NULL, 'PIRABAN MUÑOZ YANETH', '', NULL, NULL, '1937-05-19 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (400, 52223831, NULL, NULL, 'PIZARRO NOVOA VALERIA', '', NULL, NULL, '1935-04-10 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (401, 51790313, NULL, NULL, 'PLAZAS SALAMANCA ADRIANA', '', NULL, NULL, '1923-12-08 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (402, 52284545, NULL, NULL, 'POLANIA ALFONSO JUDY MILENA', '', NULL, NULL, '1926-02-24 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (403, 19404373, NULL, NULL, 'POLANIA QUICENO ALVARO', '', NULL, NULL, '1936-05-24 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (404, 52869746, NULL, NULL, 'POMBO BETANCOUR PAULA ANDREA', '', NULL, NULL, '1934-04-14 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (405, 3316505, NULL, NULL, 'POSADA CANO ENRIQUE', '', NULL, NULL, '1953-02-21 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (406, 52346701, NULL, NULL, 'POSADA PELAEZ CAMILA', '', NULL, NULL, '1960-12-12 00:00:00', 'MANSAROVAR  ENERGY ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (407, 51619022, NULL, NULL, 'PRIETO MARTINEZ ANA PATRICIA', '', NULL, NULL, '1929-06-01 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (408, 41592584, NULL, NULL, 'PRIETO PEÑUELA MARIA TERESA', '', NULL, NULL, '1936-09-13 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (409, 79688089, NULL, NULL, 'PRIETO RODRIGUEZ GERMAN ALFONSO', '', NULL, NULL, '1936-10-08 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (410, 17093295, NULL, NULL, 'PRIETO SUAREZ CARLOS', '', NULL, NULL, '1936-10-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (411, 41687527, NULL, NULL, 'PULECIO DE SARMIENTO GLORIA', '', NULL, NULL, '1930-01-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (412, 80102129, NULL, NULL, 'PULECIO PULGARIN JAIRO MAURICIO', '', NULL, NULL, '1936-11-05 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (413, 52441812, NULL, NULL, 'QUEVEDO LADINO OLGA YANETH', '', NULL, NULL, '1937-02-22 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (414, 79387399, NULL, NULL, 'QUINTERO DENNYS ARNOLDO', '', NULL, NULL, '1962-04-12 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (415, 17342119, NULL, NULL, 'QUIÑONES GUTIERREZ JUAN MANUEL', '', NULL, NULL, '1932-09-28 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (416, 52022288, NULL, NULL, 'QUIROGA OTALORA YORLEY', '', NULL, NULL, '1935-10-10 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (417, 74328741, NULL, NULL, 'QUITIAN FANYER FERNANDO', '', NULL, NULL, '1936-09-15 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (418, 1014234691, NULL, NULL, 'RAMIEZ LEON NIYIRETH NATALIA', '', NULL, NULL, '1939-12-07 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (419, 79760169, NULL, NULL, 'RAMIREZ FIGUEROA CARLOS ALBERTO', '', NULL, NULL, '1939-07-08 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (420, 17065810, NULL, NULL, 'RAMIREZ GIRALDO IGNACIO', '', NULL, NULL, '1930-10-04 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (421, 41739402, NULL, NULL, 'RAMIREZ PULIDO LUCIA', '', NULL, NULL, '1938-03-12 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (422, 41448165, NULL, NULL, 'RAMIREZ ROA LEONILDE', '', NULL, NULL, '1928-02-29 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (423, 35196404, NULL, NULL, 'RAMIREZ SIERRA SANDRA MILENA', '', NULL, NULL, '1940-12-07 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (424, 85433855, NULL, NULL, 'RANGEL VILLEGAS MISAEL', '', NULL, NULL, '1926-11-09 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (425, 41425786, NULL, NULL, 'REINA DE HERNANDEZ OLGA', '', NULL, NULL, '1939-12-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (426, 19101314, NULL, NULL, 'REY CARRASCO IVAN', '', NULL, NULL, '1938-01-11 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (427, 63281430, NULL, NULL, 'REY RAMIREZ LAURA E', '', NULL, NULL, '1939-08-12 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (428, 19105006, NULL, NULL, 'REYES BOLIVAR JOSE GABRIEL', '', NULL, NULL, '1966-03-15 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (429, 41561021, NULL, NULL, 'REYES DE REYES BERTHA', '', NULL, NULL, '1975-09-14 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (430, 52263285, NULL, NULL, 'REYES SARMIENTO CLAUDIA ANGELICA', '', NULL, NULL, '1959-02-16 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (431, 3135050, NULL, NULL, 'RIAÑO LOMBANA JESUS ANTONIO', '', NULL, NULL, '1925-11-12 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (432, 79840685, NULL, NULL, 'RIAÑO UBATE JOHN FREDDY', '', NULL, NULL, '1956-11-08 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (433, 80250326, NULL, NULL, 'RIASCOS OCHOA JAVIER', '', NULL, NULL, '1953-07-08 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (434, 41314972, NULL, NULL, 'RINCON DE SANCHEZ SILVIA', '', NULL, NULL, '1957-12-23 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (435, 1030571505, NULL, NULL, 'RINCON HERNANDEZ MARTHA ESPERANZA', '', NULL, NULL, '1981-04-22 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (436, 51933243, NULL, NULL, 'RINCON RUEDA HILDA MARIA', '', NULL, NULL, '1963-05-23 00:00:00', 'COOPETEXAS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (437, 79576513, NULL, NULL, 'RIVERA AYA ELIASIB NAHER', '', NULL, NULL, '1969-06-01 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (438, 79219497, NULL, NULL, 'RIVERA RINCON JOHN FERNANDO', '', NULL, NULL, '1958-07-08 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (439, 51641511, NULL, NULL, 'RIVERA VARGAS MARIA AUDREY', '', NULL, NULL, '1951-03-15 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (440, 19257990, NULL, NULL, 'RIVEROS CARRASQUILLA HUGO RENE', '', NULL, NULL, '1954-03-02 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (441, 52156119, NULL, NULL, 'ROCHA GARCIA ANA LILIANA', '', NULL, NULL, '1942-03-14 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (442, 1032359182, NULL, NULL, 'RODRIGUEZ ALBINO OLGA LUCILA', '', NULL, NULL, '1964-03-05 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (443, 19282941, NULL, NULL, 'RODRIGUEZ ARAUJO MIGUEL A.', '', NULL, NULL, '1964-08-29 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (444, 77177704, NULL, NULL, 'RODRIGUEZ ARENAS ROBESPIERRE', '', NULL, NULL, '1966-01-26 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (445, 14010382, NULL, NULL, 'RODRIGUEZ BERNAL FREDY OSWALDO', '', NULL, NULL, '1975-03-04 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (446, 53114721, NULL, NULL, 'RODRIGUEZ CASTILLO ANA MARCELA', '', NULL, NULL, '1977-01-20 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (447, 51572279, NULL, NULL, 'RODRIGUEZ DE GUTIERREZ MARIA ZOILA', '', NULL, NULL, '1960-04-30 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (448, 19306781, NULL, NULL, 'RODRIGUEZ GERMAN DARIO', '', NULL, NULL, '1932-05-01 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (449, 285997, NULL, NULL, 'RODRIGUEZ GOMEZ CARLOS ARTURO', '', NULL, NULL, '1951-12-31 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (450, 1031120635, NULL, NULL, 'RODRIGUEZ HERNANDEZ JOHANA MILENA', '', NULL, NULL, '1935-07-17 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (451, 52775066, NULL, NULL, 'RODRIGUEZ JIMENEZ RUTH BIBIANA', '', NULL, NULL, '1961-07-29 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (452, 52531031, NULL, NULL, 'RODRIGUEZ LUZ MARINA', '', NULL, NULL, '1960-08-22 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (453, 79751280, NULL, NULL, 'RODRIGUEZ MARTINEZ GUILLERMO ANDRES', '', NULL, NULL, '1963-02-12 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (454, 52031874, NULL, NULL, 'RODRIGUEZ PARRA LIDA ZORAIDA', '', NULL, NULL, '1962-07-12 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (455, 52344293, NULL, NULL, 'RODRIGUEZ PARRA NANCY', '', NULL, NULL, '1959-05-11 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (456, 51658109, NULL, NULL, 'RODRIGUEZ PIEDRAHITA LIGIA INES', '', NULL, NULL, '1961-12-26 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (457, 79755282, NULL, NULL, 'RODRIGUEZ QUIROGA NESTOR ARTURO', '', NULL, NULL, '1963-10-08 00:00:00', 'MANSAROVAR  ENERGY ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (458, 79448748, NULL, NULL, 'RODRIGUEZ SOTO ABEL EDUARDO', '', NULL, NULL, '1966-02-11 00:00:00', 'MANSAROVAR  ENERGY ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (459, 52254821, NULL, NULL, 'RODRIGUEZ YEPES DIANA CRISTINA', '', NULL, NULL, '1935-03-03 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (460, 80047927, NULL, NULL, 'RODRIGUEZ ZARATE JOHN ALEXANDER', '', NULL, NULL, '1952-10-17 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (461, 1013603762, NULL, NULL, 'ROJAS GARCIA MANUEL FERNANDO', '', NULL, NULL, '1962-05-17 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (462, 51826083, NULL, NULL, 'ROLON DOMINGUEZ BEATRIZ HELENA', '', NULL, NULL, '1950-12-05 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (463, 1018408186, NULL, NULL, 'ROMERO CASTRO DIEGO ALEJANDRO', '', NULL, NULL, '1958-12-14 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (464, 79285494, NULL, NULL, 'ROMERO GUTIERREZ CAMILO', '', NULL, NULL, '1947-07-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (465, 79899668, NULL, NULL, 'ROMERO MANCIPE CARLOS ANDRES', '', NULL, NULL, '1955-05-12 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (466, 79590107, NULL, NULL, 'ROMERO MOSCOSO ALBERTO CARLOS', '', NULL, NULL, '1957-10-06 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (467, 79492315, NULL, NULL, 'ROMERO OCHOA JULIAN EDUARDO', '', NULL, NULL, '1929-11-20 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (468, 41520589, NULL, NULL, 'ROMERO PINTO MARIA JOSEFA', '', NULL, NULL, '1979-07-19 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (469, 1030542557, NULL, NULL, 'ROZO ALARCON JENNIFFER', '', NULL, NULL, '1940-06-30 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (470, 51716334, NULL, NULL, 'ROZO TORRES GLADYS', '', NULL, NULL, '1955-07-26 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (471, 79640410, NULL, NULL, 'RUBIANO PINILLA ELKIN', '', NULL, NULL, '1945-11-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (472, 41780945, NULL, NULL, 'RUBIO ALFONSO LUZ MERY', '', NULL, NULL, '1948-10-01 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (473, 19299776, NULL, NULL, 'RUEDA ESCALLON GUILLERMO', '', NULL, NULL, '1962-07-03 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (474, 41540747, NULL, NULL, 'RUGELES CHACON LAURA', '', NULL, NULL, '1975-05-24 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (475, 35469227, NULL, NULL, 'RUGELES SANTOS MARIA YOLANDA', '', NULL, NULL, '1952-11-14 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (476, 19291389, NULL, NULL, 'RUIZ DORARTE EDGAR JOSE', '', NULL, NULL, '1970-05-09 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (477, 52167768, NULL, NULL, 'RUIZ GUERRERO JENNETH', '', NULL, NULL, '1977-12-22 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (478, 80245020, NULL, NULL, 'RUIZ RUIZ ALEJANDRO', '', NULL, NULL, '1977-12-22 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (479, 53028479, NULL, NULL, 'SABOGAL PEDRAZA ANGELA YOHANNA', '', NULL, NULL, '1964-07-09 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (480, 20576930, NULL, NULL, 'SACANTIVA MALAGON LUZ YANET', '', NULL, NULL, '1965-10-17 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (481, 52455256, NULL, NULL, 'SACHICA MORENO CAROLINA', '', NULL, NULL, '1965-12-18 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (482, 6756771, NULL, NULL, 'SALAMANCA CRUZ JOSE ELIECER', '', NULL, NULL, '1968-08-30 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (483, 79468715, NULL, NULL, 'SALAMANCA RAMIREZ OSCAR ALONSO', '', NULL, NULL, '1967-08-02 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (484, 52728955, NULL, NULL, 'SALAZAR CUBILLOS CLEMENTINA', '', NULL, NULL, '1968-09-10 00:00:00', 'COOPETEXAS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (485, 41720210, NULL, NULL, 'SALAZAR HOLGUIN ROSA MARIA', '', NULL, NULL, '1970-04-07 00:00:00', 'COOPETEXAS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (486, 80426104, NULL, NULL, 'SALCEDO FIDALGO DIEGO', '', NULL, NULL, '1969-09-16 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (487, 17055409, NULL, NULL, 'SALDARRIAGA ROA ALBERTO', '', NULL, NULL, '1984-10-21 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (488, 1032396665, NULL, NULL, 'SALINAS MONROY LEIDY JOHANA', '', NULL, NULL, '1969-08-16 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (489, 52882614, NULL, NULL, 'SALVADOR RODRIGUEZ NATALIA', '', NULL, NULL, '1971-07-22 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (490, 19339213, NULL, NULL, 'SANABRIA MARTINEZ CARLOS ABEL', '', NULL, NULL, '1979-05-06 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (491, 52817468, NULL, NULL, 'SANCHEZ CASAS JENNIFER CONSTANZ', '', NULL, NULL, '1984-03-14 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (492, 1018409632, NULL, NULL, 'SANCHEZ FAJARDO SANDRA MILENA', '', NULL, NULL, '1950-02-11 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (493, 11426680, NULL, NULL, 'SANCHEZ GAITAN CARLOS URBANO', '', NULL, NULL, '1943-05-25 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (494, 80259469, NULL, NULL, 'SANCHEZ GARZON SERGIO ANDRES', '', NULL, NULL, '1943-12-10 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (495, 19121470, NULL, NULL, 'SANCHEZ LOPEZ HORACIO', '', NULL, NULL, '1944-02-21 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (496, 80019123, NULL, NULL, 'SANCHEZ PUERTA DIEGO FERNANDO', '', NULL, NULL, '1944-03-19 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (497, 79395627, NULL, NULL, 'SANCHEZ RIAÑO VLADIMIR', '', NULL, NULL, '1945-06-13 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (498, 36667487, NULL, NULL, 'SANCHEZ RIOS OLGA INES', '', NULL, NULL, '1946-04-09 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (499, 53106955, NULL, NULL, 'SANCHEZ SOLORZANO DIANA CAROLINA', '', NULL, NULL, '1942-09-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (500, 73132970, NULL, NULL, 'SANJUAN MUÑOZ ADOLFO MARIA', '', NULL, NULL, '1946-03-31 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (501, 30239781, NULL, NULL, 'SANTAFE MUÑOZ ANGIE MARIBETH', '', NULL, NULL, '1947-04-03 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (502, 13841947, NULL, NULL, 'SANTAMARIA ARIZA MARIO', '', NULL, NULL, '1945-08-28 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (503, 51978582, NULL, NULL, 'SANTAMARIA VANEGAS JOHANNA', '', NULL, NULL, '1937-10-15 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (504, 19399378, NULL, NULL, 'SANTANA CEDIEL MANUEL E', '', NULL, NULL, '1947-12-26 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (505, 80003483, NULL, NULL, 'SANTOS LAVERDE CESAR LEONARDO', '', NULL, NULL, '1948-05-01 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (506, 17139962, NULL, NULL, 'SASTOQUE JOHNSON JUAN', '', NULL, NULL, '1946-07-15 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (507, 51565244, NULL, NULL, 'SCHUTZ DE CANO VERA HELENA', '', NULL, NULL, '1948-12-19 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (508, 19068341, NULL, NULL, 'SEPULVEDA GONZALEZ LUIS FRANCISCO', '', NULL, NULL, '1948-07-22 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (509, 65797140, NULL, NULL, 'SERRANO DUBOIS MABEL', '', NULL, NULL, '1951-01-05 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (510, 41477779, NULL, NULL, 'SERRATO MAHECHA GLORIA JANETH', '', NULL, NULL, '1951-02-26 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (511, 79464030, NULL, NULL, 'SIERRA BERNAL CESAR ALONSO', '', NULL, NULL, '1951-12-24 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (512, 1030595503, NULL, NULL, 'SIERRA PALACIOS JUAN SEBASTIAN', '', NULL, NULL, '1951-09-26 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (513, 41425179, NULL, NULL, 'SIERRA WILSON YARME LUZ', '', NULL, NULL, '1952-09-04 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (514, 41375442, NULL, NULL, 'SILVA DIAZ GLORIA AMANDA', '', NULL, NULL, '1952-03-05 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (515, 35321085, NULL, NULL, 'SILVA FARFAN LUZ ALCIRA', '', NULL, NULL, '1953-07-19 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (516, 79788735, NULL, NULL, 'SOSA RUIZ DIEGO HERNANDO', '', NULL, NULL, '1954-04-25 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (517, 79523717, NULL, NULL, 'SUAREZ GRANJA HEBERT H.', '', NULL, NULL, '1953-03-20 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (518, 79562501, NULL, NULL, 'SUAREZ HURTADO CARLOS FERNANDO', '', NULL, NULL, '1952-07-12 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (519, 13721628, NULL, NULL, 'SUAREZ LOPEZ CARLOS ALBERTO', '', NULL, NULL, '1952-05-12 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (520, 52828644, NULL, NULL, 'SUAREZ QUINTERO SANDRA LILIANA', '', NULL, NULL, '1959-10-06 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (521, 52908692, NULL, NULL, 'TANGUA VASQUEZ NURY', '', NULL, NULL, '1955-12-07 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (522, 1032372229, NULL, NULL, 'TAO SIMBAQUEVA ADRIANA CAROLINA', '', NULL, NULL, '1955-10-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (523, 1033688844, NULL, NULL, 'TELLEZ SUAREZ MAYRA LILIANA', '', NULL, NULL, '1954-09-19 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (524, 52355303, NULL, NULL, 'TIQUE ALVARADO MAYERLINE', '', NULL, NULL, '1957-08-30 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (525, 52306409, NULL, NULL, 'TIRADO SANTOS MAYERLY', '', NULL, NULL, '1954-07-06 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (526, 52040123, NULL, NULL, 'TOBON BOTERO ADRIANA PATRICIA', '', NULL, NULL, '1955-06-08 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (527, 52738810, NULL, NULL, 'TORRES HERNANDEZ ELIZABETH', '', NULL, NULL, '1954-12-15 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (528, 52718448, NULL, NULL, 'TORRES MEDINA LIANA HASBLEIDY', '', NULL, NULL, '1957-11-16 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (529, 19492585, NULL, NULL, 'TORRES MORENO HERNANDO', '', NULL, NULL, '1959-02-23 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (530, 91284875, NULL, NULL, 'TORRES QUIROGA EDWIN SILVESTRE', '', NULL, NULL, '1957-01-14 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (531, 79104926, NULL, NULL, 'TORRES REINA DANILO', '', NULL, NULL, '1959-01-12 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (532, 52074112, NULL, NULL, 'TORRES RINCON MONICA MARIA', '', NULL, NULL, '1960-01-03 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (533, 51815550, NULL, NULL, 'TORRES RODRIGUEZ BLANCA E', '', NULL, NULL, '1960-04-06 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (534, 79732016, NULL, NULL, 'TORRES SANABRIA CAMILO', '', NULL, NULL, '1958-03-03 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (535, 53911039, NULL, NULL, 'TORRES SIERRA SANDRA MILENA', '', NULL, NULL, '1928-02-16 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (536, 1023862175, NULL, NULL, 'TORRES TAO PABLO DANIEL', '', NULL, NULL, '1930-12-14 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (537, 19240687, NULL, NULL, 'TOVAR CARDONA RAMON', '', NULL, NULL, '1928-11-19 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (538, 21068762, NULL, NULL, 'TOVAR MEJIA MARIA  VICTORIA H', '', NULL, NULL, '1929-08-01 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (539, 52867220, NULL, NULL, 'URIBE BARESCH ALEXANDRA', '', NULL, NULL, '1925-02-12 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (540, 12529961, NULL, NULL, 'VALENCIA ABDALA HERNANDO ENRIQUE', '', NULL, NULL, '1931-11-24 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (541, 30354764, NULL, NULL, 'VALENCIA ACEVEDO GLORIA INDIRA', '', NULL, NULL, '1925-03-15 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (542, 9730790, NULL, NULL, 'VALENCIA MORENO MAURICIO ANDRES', '', NULL, NULL, '1931-05-14 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (543, 52051182, NULL, NULL, 'VALERO PACHECO IVONNE CONSTANZA', '', NULL, NULL, '1931-04-09 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (544, 52795441, NULL, NULL, 'VANEGAS CONDE NANCY PAOLA', '', NULL, NULL, '1929-09-13 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (545, 39555682, NULL, NULL, 'VANEGAS GARCIA LEONOR', '', NULL, NULL, '1925-07-04 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (546, 42137220, NULL, NULL, 'VARELA LIMA LUZ ADRIANA', '', NULL, NULL, '1925-02-26 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (547, 52826397, NULL, NULL, 'VARGAS CALVO AMPARO', '', NULL, NULL, '1924-04-06 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (548, 51896366, NULL, NULL, 'VARGAS CORREA ROCIO ESPERANZA', '', NULL, NULL, '1931-11-24 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (549, 79435900, NULL, NULL, 'VARGAS CORTES JAIRO HUMBERTO', '', NULL, NULL, '1934-08-07 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (550, 52028319, NULL, NULL, 'VARGAS GLORIA YANETH', '', NULL, NULL, '1937-10-02 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (551, 19274038, NULL, NULL, 'VARGAS RODRIGUEZ FELIX ALBERTO', '', NULL, NULL, '1930-02-17 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (552, 52282859, NULL, NULL, 'VARGAS RUEDA JANETH ALEXANDRA', '', NULL, NULL, '1935-04-16 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (553, 80406151, NULL, NULL, 'VASQUEZ MIRANDA LEONARDO', '', NULL, NULL, '1938-02-09 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (554, 52412027, NULL, NULL, 'VELANDIA MOYANO ADRIANA', '', NULL, NULL, '1938-01-23 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (555, 51697980, NULL, NULL, 'VELANDIA RODRIGUEZ LUZ NIDIA', '', NULL, NULL, '1965-02-19 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (556, 51643318, NULL, NULL, 'VELANDIA YEPES GLADYS', '', NULL, NULL, '1954-05-26 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (557, 79842325, NULL, NULL, 'VELASCO PARDO FREDY JOHANY', '', NULL, NULL, '1938-07-01 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (558, 17174201, NULL, NULL, 'VELASCO ROJAS ALFONSO', '', NULL, NULL, '1952-06-12 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (559, 53030605, NULL, NULL, 'VELASQUEZ CARDONA VIVIANA', '', NULL, NULL, '1924-12-14 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (560, 79567934, NULL, NULL, 'VELASQUEZ GOMEZ OSCAR MAURICIO', '', NULL, NULL, '1925-10-03 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (561, 24802665, NULL, NULL, 'VELEZ OSORIO LESBIA', '', NULL, NULL, '1941-01-14 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (562, 52275504, NULL, NULL, 'VENEGAS CALLE STELLA DEL PILAR', '', NULL, NULL, '1928-08-10 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (563, 17173455, NULL, NULL, 'VENGOECHEA OLAYA GERMAN', '', NULL, NULL, '1943-09-05 00:00:00', 'PAGOS POR VENTANILLA', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (564, 51853185, NULL, NULL, 'VERA PARRA MYRIAM MARLENY', '', NULL, NULL, '1959-08-20 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (565, 41627657, NULL, NULL, 'VERGARA GALVIS MARIA CRISTINA', '', NULL, NULL, '1963-01-17 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (566, 37797386, NULL, NULL, 'VERNAZA DE LOPEZ ISABEL', '', NULL, NULL, '1962-05-24 00:00:00', 'MANSAROVAR  ENERGY ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (567, 20314590, NULL, NULL, 'VIDAL DE BRUGGEMAN CONSUELO', '', NULL, NULL, '1959-09-09 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (568, 65702849, NULL, NULL, 'VILLA BARRERO CLAUDIA MARCELA', '', NULL, NULL, '1963-02-27 00:00:00', 'ISS PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (569, 51724055, NULL, NULL, 'VILLALOBOS FERNANDEZ JACQUELIN', '', NULL, NULL, '1960-06-26 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (570, 17006441, NULL, NULL, 'VILLAMIL PERILLA HUGO', '', NULL, NULL, '1917-09-21 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (571, 19216886, NULL, NULL, 'VILLARRAGA CARDOSO HERNAN', '', NULL, NULL, '1929-10-14 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (572, 17184366, NULL, NULL, 'VILLARREAL MORALES JAIME', '', NULL, NULL, '1957-09-29 00:00:00', 'TEXACO ROL DIARIO', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (573, 8704121, NULL, NULL, 'VILORIA MOLINARES MARVIN', '', NULL, NULL, '1946-07-25 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (574, 1032393422, NULL, NULL, 'WILCHES CONTRERAS ERICK ALEJANDRO', '', NULL, NULL, '1944-06-07 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (575, 79908898, NULL, NULL, 'YANQUEN ARIAS WILSON EDUARDO', '', NULL, NULL, '1959-11-22 00:00:00', 'COOPETEXAS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (576, 79120413, NULL, NULL, 'ZABALA YANGUMA JOSE FRANCISCO', '', NULL, NULL, '1960-04-01 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (577, 80263844, NULL, NULL, 'ZAMORA ROJAS RODRIGO ALBERTO', '', NULL, NULL, '1954-05-05 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (578, 80228149, NULL, NULL, 'ZARATE ANGARITA WILSON ENRIQUE', '', NULL, NULL, '1957-01-09 00:00:00', 'MANSAROVAR  ENERGY ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (579, 19493307, NULL, NULL, 'ZARATE GARCIA JUAN FRANCISCO', '', NULL, NULL, '1961-04-13 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (580, 283266, NULL, NULL, 'ZEVALLOS PEÑA FEDERICO MANUEL', '', NULL, NULL, '1962-02-11 00:00:00', 'PENSIONADOS', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx) VALUES (581, 51766056, NULL, NULL, 'ZULUAGA MOGOLLON MARTHA', '', NULL, NULL, '1962-09-06 00:00:00', 'TEXACO ROL MENSUAL', 2, NULL, 'dbxdba', '2011-03-22 14:38:48.329477');


--
-- TOC entry 2206 (class 0 OID 34343)
-- Dependencies: 1679
-- Data for Name: xcm_nuips_dirs; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--



--
-- TOC entry 2207 (class 0 OID 34356)
-- Dependencies: 1682
-- Data for Name: xcm_nuips_emails; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--



--
-- TOC entry 2208 (class 0 OID 34369)
-- Dependencies: 1685
-- Data for Name: xcm_nuips_grupos; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4143, 0, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3572, 11, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3573, 12, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3574, 13, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3575, 14, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3576, 15, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3577, 16, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3578, 17, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3579, 18, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3580, 19, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3581, 20, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3582, 21, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3583, 22, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3584, 23, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3585, 24, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3586, 25, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3587, 26, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3588, 27, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3589, 28, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3590, 29, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3591, 30, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3592, 31, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3593, 32, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3594, 33, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3595, 34, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3596, 35, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3597, 36, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3598, 37, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3599, 38, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3600, 163, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3601, 39, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3602, 40, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3603, 41, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3604, 42, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3605, 43, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3606, 44, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3607, 45, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3608, 46, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3609, 47, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3610, 48, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3611, 49, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3612, 50, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3613, 51, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3614, 52, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3615, 53, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3616, 54, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3617, 55, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3618, 56, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3619, 57, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3620, 58, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3621, 59, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3622, 60, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3623, 61, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3624, 62, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3625, 63, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3626, 64, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3627, 65, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3628, 66, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3629, 67, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3630, 68, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3631, 69, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3632, 70, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3633, 71, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3634, 72, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3635, 73, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3636, 74, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3637, 75, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3638, 76, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3639, 77, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3640, 78, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3641, 79, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3642, 80, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3643, 81, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3644, 82, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3645, 83, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3646, 84, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3647, 85, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3648, 86, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3649, 87, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3650, 88, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3651, 89, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3652, 90, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3653, 91, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3654, 92, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3655, 93, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3656, 94, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3657, 95, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3658, 96, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3659, 97, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3660, 98, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3661, 99, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3662, 349, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3663, 100, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3664, 101, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3665, 102, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3666, 103, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3667, 104, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3668, 105, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3669, 106, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3670, 107, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3671, 108, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3672, 109, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3673, 110, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3674, 111, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3675, 112, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3676, 113, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3677, 114, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3678, 115, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3679, 116, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3680, 117, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3681, 118, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3682, 119, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3683, 120, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3684, 121, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3685, 122, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3686, 123, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3687, 124, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3688, 125, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3689, 126, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3690, 127, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3691, 128, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3692, 129, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3693, 130, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3694, 131, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3695, 132, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3696, 133, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3697, 134, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3698, 135, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3699, 136, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3700, 137, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3701, 138, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3702, 139, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3703, 140, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3704, 141, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3705, 142, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3706, 143, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3707, 144, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3708, 145, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3709, 146, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3710, 147, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3711, 148, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3712, 149, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3713, 150, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3714, 151, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3715, 152, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3716, 153, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3717, 154, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3718, 155, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3719, 156, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3720, 157, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3721, 158, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3722, 159, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3723, 160, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3724, 161, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3725, 162, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3726, 164, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3727, 165, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3728, 166, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3729, 167, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3730, 168, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3731, 169, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3732, 170, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3733, 171, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3734, 172, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3735, 173, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3736, 174, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3737, 175, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3738, 176, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3739, 177, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3740, 178, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3741, 179, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3742, 180, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3743, 181, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3744, 182, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3745, 183, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3746, 184, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3747, 185, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3748, 186, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3749, 187, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3750, 188, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3751, 189, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3752, 190, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3753, 191, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3754, 192, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3755, 193, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3756, 194, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3757, 195, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3758, 196, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3759, 197, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3760, 198, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3761, 199, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3762, 200, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3763, 201, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3764, 202, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3765, 203, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3766, 204, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3767, 205, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3768, 206, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3769, 207, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3770, 208, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3771, 209, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3772, 210, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3773, 211, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3774, 212, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3775, 213, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3776, 214, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3777, 215, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3778, 216, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3779, 217, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3780, 218, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3781, 219, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3782, 220, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3783, 221, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3784, 222, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3785, 223, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3786, 224, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3787, 350, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3788, 225, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3789, 226, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3790, 227, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3791, 228, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3792, 229, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3793, 230, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3794, 231, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3795, 232, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3796, 233, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3797, 234, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3798, 235, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3799, 236, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3800, 237, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3801, 238, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3802, 239, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3803, 240, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3804, 241, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3805, 242, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3806, 243, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3807, 244, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3808, 245, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3809, 246, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3810, 247, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3811, 248, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3812, 249, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3813, 250, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3814, 251, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3815, 252, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3816, 253, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3817, 254, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3818, 255, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3819, 256, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3820, 257, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3821, 258, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3822, 259, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3823, 260, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3824, 261, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3825, 262, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3826, 263, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3827, 264, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3828, 265, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3829, 266, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3830, 267, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3831, 268, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3832, 269, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3833, 270, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3834, 271, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3835, 272, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3836, 273, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3837, 274, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3838, 275, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3839, 276, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3840, 277, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3841, 278, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3842, 279, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3843, 280, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3844, 281, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3845, 282, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3846, 283, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3847, 284, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3848, 285, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3849, 286, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3850, 287, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3851, 288, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3852, 289, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3853, 290, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3854, 291, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3855, 292, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3856, 293, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3857, 294, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3858, 295, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3859, 296, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3860, 297, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3861, 298, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3862, 299, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3863, 300, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3864, 301, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3865, 302, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3866, 303, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3867, 304, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3868, 305, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3869, 306, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3870, 307, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3871, 308, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3872, 309, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3873, 310, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3874, 311, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3875, 312, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3876, 313, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3877, 314, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3878, 315, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3879, 316, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3880, 317, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3881, 318, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3882, 319, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3883, 320, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3884, 321, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3885, 322, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3886, 323, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3887, 324, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3888, 325, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3889, 326, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3890, 327, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3891, 328, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3892, 329, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3893, 330, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3894, 331, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3895, 332, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3896, 333, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3897, 334, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3898, 335, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3899, 336, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3900, 337, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3901, 338, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3902, 339, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3903, 340, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3904, 341, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3905, 342, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3906, 343, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3907, 344, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3908, 345, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3909, 346, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3910, 347, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3911, 348, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3912, 351, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3913, 352, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3914, 353, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3915, 354, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3916, 355, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3917, 356, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3918, 357, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3919, 358, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3920, 359, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3921, 360, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3922, 361, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3923, 362, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3924, 363, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3925, 364, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3926, 365, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3927, 366, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3928, 367, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3929, 368, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3930, 369, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3931, 370, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3932, 371, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3933, 372, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3934, 373, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3935, 374, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3936, 375, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3937, 376, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3938, 377, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3939, 378, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3940, 379, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3941, 380, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3942, 381, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3943, 382, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3944, 383, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3945, 384, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3946, 385, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3947, 386, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3948, 387, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3949, 388, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3950, 389, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3951, 390, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3952, 391, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3953, 392, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3954, 393, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3955, 394, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3956, 395, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3957, 396, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3958, 397, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3959, 398, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3960, 399, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3961, 400, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3962, 401, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3963, 402, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3964, 403, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3965, 404, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3966, 405, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3967, 406, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3968, 407, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3969, 408, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3970, 409, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3971, 410, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3972, 411, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3973, 412, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3974, 413, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3975, 414, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3976, 415, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3977, 416, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3978, 417, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3979, 418, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3980, 419, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3981, 420, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3982, 421, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3983, 422, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3984, 423, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3985, 424, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3986, 425, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3987, 426, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3988, 427, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3989, 428, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3990, 429, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3991, 430, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3992, 431, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3993, 432, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3994, 433, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3995, 434, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3996, 435, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3997, 436, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3998, 437, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (3999, 438, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4000, 439, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4001, 440, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4002, 441, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4003, 442, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4004, 443, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4005, 444, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4006, 445, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4007, 446, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4008, 447, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4009, 448, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4010, 449, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4011, 450, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4012, 451, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4013, 452, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4014, 453, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4015, 454, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4016, 455, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4017, 456, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4018, 457, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4019, 458, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4020, 459, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4021, 460, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4022, 461, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4023, 462, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4024, 463, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4025, 464, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4026, 465, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4027, 466, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4028, 467, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4029, 468, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4030, 469, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4031, 470, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4032, 471, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4033, 472, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4034, 473, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4035, 474, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4036, 475, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4037, 476, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4038, 477, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4039, 478, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4040, 479, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4041, 480, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4042, 481, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4043, 482, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4044, 483, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4045, 484, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4046, 485, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4047, 486, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4048, 487, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4049, 488, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4050, 489, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4051, 490, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4052, 491, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4053, 492, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4054, 493, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4055, 494, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4056, 495, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4057, 496, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4058, 497, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4059, 498, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4060, 499, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4061, 500, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4062, 501, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4063, 502, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4064, 503, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4065, 504, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4066, 505, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4067, 506, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4068, 507, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4069, 508, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4070, 509, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4071, 510, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4072, 511, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4073, 512, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4074, 513, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4075, 514, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4076, 515, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4077, 516, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4078, 517, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4079, 518, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4080, 519, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4081, 520, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4082, 521, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4083, 522, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4084, 523, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4085, 524, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4086, 525, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4087, 526, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4088, 527, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4089, 528, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4090, 529, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4091, 530, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4092, 531, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4093, 532, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4094, 533, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4095, 534, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4096, 535, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4097, 536, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4098, 537, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4099, 538, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4100, 539, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4101, 540, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4102, 541, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4103, 542, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4104, 543, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4105, 544, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4106, 545, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4107, 546, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4108, 547, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4109, 548, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4110, 549, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4111, 550, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4112, 551, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4113, 552, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4114, 553, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4115, 554, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4116, 555, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4117, 556, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4118, 557, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4119, 558, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4120, 559, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4121, 560, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4122, 561, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4123, 562, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4124, 563, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4125, 564, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4126, 565, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4127, 566, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4128, 567, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4129, 568, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4130, 569, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4131, 570, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4132, 571, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4133, 572, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4134, 573, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4135, 574, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4136, 575, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4137, 576, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4138, 577, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4139, 578, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4140, 579, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4141, 580, 1);
INSERT INTO xcm_nuips_grupos (id_nuip_grupo, id_nuip_serial, id_grupo) VALUES (4142, 581, 1);


--
-- TOC entry 2209 (class 0 OID 34381)
-- Dependencies: 1689
-- Data for Name: xcm_nuips_tels; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--



--
-- TOC entry 2210 (class 0 OID 34399)
-- Dependencies: 1693
-- Data for Name: xcm_permisos; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000', NULL, 'Sistemas AXYS-DBX', NULL, 1, true, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000', '000', 'Sistema de Seguridad', NULL, 2, true, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000000', '000000', 'Acceso al Sistema de Seguridad', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000001', '000000', 'Creación de N.U.I.P.s', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000002', '000000', 'Creación de Usuarios', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000003', '000000', 'Modificar Permisos de Usuarios', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000004', '000000', 'Creación de Grupos', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000005', '000000', 'Modificación de Permisos de Grupo', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000006', '000000', 'Cambio de Contraseña', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000007', '000000', 'Asignar Usuarios a Grupos', 'Permite asignar Usuarios creados en el sistema a uno o varios Grupos Empresariales', 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000009', '000000', 'Asignar Permisos a Usuarios', 'Permite asignar Permisos creados en el sistema a cada uno de los Usuarios', 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000010', '000000', 'Asignar Permisos a Grupos', 'Permite asignar Permisos creados en el sistema a uno de los Grupos Empresariales', 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000001', '000', 'Acceso Sistema', NULL, 2, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000002', '000', 'Sistema de Pedidos', NULL, 2, true, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000002000', '000002', 'Acceso al Modulo de Pedidos', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000002001', '000002', 'Registro de Proveedores', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000002002', '000002', 'Registro de Productos y Categorización', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000002003', '000002', 'Ingreso de Precio', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000002004', '000002', 'Ingreso de Proyectos', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000003', '000', 'Votaciones', NULL, 2, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000003001', '000003', 'Carga Masiva', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000003002', '000003', 'Creación de Votaciones', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000003003', '000003', 'Creación de Candidatos', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000003004', '000003', 'App. de Votos', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000003000', '000003', 'Acceso al modulo de Votaciones', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000003005', '000003', 'Resultado de Votaciones', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000003006', '000003', 'Registro Manual de Asociados', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000003007', '000003', 'Limpiar Censo Elctoral', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000003008', '000003', 'Información del Censo Electoral', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000003009', '000003', 'Duplicar Votación', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000003010', '000003', 'Asignación de Planchas a Votación', NULL, 3, false, NULL);


--
-- TOC entry 2211 (class 0 OID 34406)
-- Dependencies: 1694
-- Data for Name: xcm_usuarios; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_usuarios (login, passwd, id_nivel_usuario, id_nuip_serial, fec_creacion, is_activo, cant_sesiones_max, cant_sesiones) VALUES ('dbxdba', '358b45870d2c2e8b8bccb5b8eca6dbc6', 0, 0, '2009-01-01 00:00:00', true, 0, 0);
INSERT INTO xcm_usuarios (login, passwd, id_nivel_usuario, id_nuip_serial, fec_creacion, is_activo, cant_sesiones_max, cant_sesiones) VALUES ('admin', '827ccb0eea8a706c4c34a16891f84e7b', 1, 0, '2009-01-01 00:00:00', true, 0, 0);


--
-- TOC entry 2212 (class 0 OID 34417)
-- Dependencies: 1695
-- Data for Name: xcm_usuarios_grupos; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_usuarios_grupos (id_usuario_grupo, login, id_grupo) VALUES (1, 'dbxdba', 0);
INSERT INTO xcm_usuarios_grupos (id_usuario_grupo, login, id_grupo) VALUES (2, 'admin', 1);
INSERT INTO xcm_usuarios_grupos (id_usuario_grupo, login, id_grupo) VALUES (3, 'dbxdba', 1);


--
-- TOC entry 2213 (class 0 OID 34431)
-- Dependencies: 1699
-- Data for Name: xcm_usuarios_permisos; Type: TABLE DATA; Schema: public; Owner: dbx_fet
--

INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (1, 'admin', '000000', '2009-01-01 00:00:00', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (2, 'admin', '000000000', '2009-01-01 00:00:00', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (3, 'admin', '000000009', '2009-01-01 00:00:00', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (4, 'admin', '000000006', '2009-01-01 00:00:00', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (5, 'admin', '000000001', '2009-01-01 00:00:00', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (6, 'admin', '000000002', '2009-01-01 00:00:00', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (7, 'admin', '000000003', '2009-01-01 00:00:00', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (8, 'admin', '000001', '2009-01-01 00:00:00', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (34, 'admin', '000003005', '2010-12-27 11:54:31.032571', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (35, 'admin', '000003006', '2011-01-13 10:46:13.673735', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (36, 'admin', '000003007', '2011-01-13 10:46:27.533339', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (37, 'admin', '000003008', '2011-01-13 10:46:40.878306', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (38, 'admin', '000003009', '2011-01-13 10:51:29.800688', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (9, 'admin', '000003', '2010-11-11 22:51:58.333067', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (10, 'admin', '000003001', '2010-11-11 22:52:23.995214', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (29, 'admin', '000003002', '2010-12-23 09:03:59.585821', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (31, 'admin', '000003003', '2010-12-23 09:04:22.962084', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (32, 'admin', '000003004', '2010-12-23 09:04:34.098557', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (33, 'admin', '000003000', '2010-12-23 09:05:47.011647', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (41, 'admin', '000003010', '2011-03-22 14:22:06.396477', 'dbxdba');


--
-- TOC entry 2109 (class 2606 OID 34467)
-- Dependencies: 1672 1672
-- Name: ak_cunom_grupo_xcm_grup; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_grupos
    ADD CONSTRAINT ak_cunom_grupo_xcm_grup UNIQUE (nom_grupo);


--
-- TOC entry 2139 (class 2606 OID 34469)
-- Dependencies: 1699 1699 1699
-- Name: ak_login_permiso_xcm_usua; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT ak_login_permiso_xcm_usua UNIQUE (login, id_permiso);


--
-- TOC entry 2117 (class 2606 OID 34471)
-- Dependencies: 1678 1678
-- Name: ak_nivel_xcm_nive; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_niveles_usuario
    ADD CONSTRAINT ak_nivel_xcm_nive UNIQUE (nom_nivel_usuario);


--
-- TOC entry 2130 (class 2606 OID 34473)
-- Dependencies: 1693 1693
-- Name: ak_nom_permiso_xcm_perm; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_permisos
    ADD CONSTRAINT ak_nom_permiso_xcm_perm UNIQUE (nom_permiso);


--
-- TOC entry 2074 (class 2606 OID 34475)
-- Dependencies: 1642 1642 1642
-- Name: ak_nuip_dig_verifica__xcm_nuip; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT ak_nuip_dig_verifica__xcm_nuip UNIQUE (id_nuip, digito_verif);


--
-- TOC entry 2113 (class 2606 OID 34477)
-- Dependencies: 1674 1674 1674
-- Name: cu_id_permiso_id_grupo; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT cu_id_permiso_id_grupo UNIQUE (id_grupo, id_permiso);


--
-- TOC entry 2089 (class 2606 OID 34479)
-- Dependencies: 1655 1655 1655 1655
-- Name: pk_xcm_campos_db; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_campos_db
    ADD CONSTRAINT pk_xcm_campos_db PRIMARY KEY (nom_esquema, nom_tabla, nom_columna);


--
-- TOC entry 2092 (class 2606 OID 34481)
-- Dependencies: 1656 1656
-- Name: pk_xcm_db_departamentos; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_db_departamentos
    ADD CONSTRAINT pk_xcm_db_departamentos PRIMARY KEY (id_depto);


--
-- TOC entry 2094 (class 2606 OID 34483)
-- Dependencies: 1658 1658
-- Name: pk_xcm_db_municipios; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_db_municipios
    ADD CONSTRAINT pk_xcm_db_municipios PRIMARY KEY (id_municipio);


--
-- TOC entry 2097 (class 2606 OID 34485)
-- Dependencies: 1660 1660
-- Name: pk_xcm_db_paises; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_db_paises
    ADD CONSTRAINT pk_xcm_db_paises PRIMARY KEY (id_pais);


--
-- TOC entry 2099 (class 2606 OID 34487)
-- Dependencies: 1662 1662
-- Name: pk_xcm_db_sexos; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_db_sexos
    ADD CONSTRAINT pk_xcm_db_sexos PRIMARY KEY (id_sexo);


--
-- TOC entry 2103 (class 2606 OID 34489)
-- Dependencies: 1666 1666
-- Name: pk_xcm_db_tipos_nuips; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_db_tipos_nuips
    ADD CONSTRAINT pk_xcm_db_tipos_nuips PRIMARY KEY (id_tipo_nuip);


--
-- TOC entry 2105 (class 2606 OID 34491)
-- Dependencies: 1668 1668
-- Name: pk_xcm_db_tipos_tel; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_db_tipos_tel
    ADD CONSTRAINT pk_xcm_db_tipos_tel PRIMARY KEY (id_tipo_tel);


--
-- TOC entry 2107 (class 2606 OID 34493)
-- Dependencies: 1670 1670
-- Name: pk_xcm_db_titulos_nuips; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_db_titulos_nuips
    ADD CONSTRAINT pk_xcm_db_titulos_nuips PRIMARY KEY (id_titulo_nuip);


--
-- TOC entry 2111 (class 2606 OID 34495)
-- Dependencies: 1672 1672
-- Name: pk_xcm_grupos; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_grupos
    ADD CONSTRAINT pk_xcm_grupos PRIMARY KEY (id_grupo);


--
-- TOC entry 2115 (class 2606 OID 34497)
-- Dependencies: 1674 1674
-- Name: pk_xcm_grupos_permisos; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT pk_xcm_grupos_permisos PRIMARY KEY (id_grupo_permiso);


--
-- TOC entry 2119 (class 2606 OID 34499)
-- Dependencies: 1678 1678
-- Name: pk_xcm_niveles_usuario; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_niveles_usuario
    ADD CONSTRAINT pk_xcm_niveles_usuario PRIMARY KEY (id_nivel_usuario);


--
-- TOC entry 2077 (class 2606 OID 34501)
-- Dependencies: 1642 1642
-- Name: pk_xcm_nuips; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT pk_xcm_nuips PRIMARY KEY (id_nuip_serial);


--
-- TOC entry 2121 (class 2606 OID 34503)
-- Dependencies: 1679 1679
-- Name: pk_xcm_nuips_dirs; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT pk_xcm_nuips_dirs PRIMARY KEY (id_nuip_dir);


--
-- TOC entry 2123 (class 2606 OID 34505)
-- Dependencies: 1682 1682
-- Name: pk_xcm_nuips_emails; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_nuips_emails
    ADD CONSTRAINT pk_xcm_nuips_emails PRIMARY KEY (id_nuip_email);


--
-- TOC entry 2126 (class 2606 OID 34507)
-- Dependencies: 1685 1685
-- Name: pk_xcm_nuips_grupos; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_nuips_grupos
    ADD CONSTRAINT pk_xcm_nuips_grupos PRIMARY KEY (id_nuip_grupo);


--
-- TOC entry 2128 (class 2606 OID 34509)
-- Dependencies: 1689 1689
-- Name: pk_xcm_nuips_tels; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_nuips_tels
    ADD CONSTRAINT pk_xcm_nuips_tels PRIMARY KEY (id_nuip_tel);


--
-- TOC entry 2132 (class 2606 OID 34511)
-- Dependencies: 1693 1693
-- Name: pk_xcm_permisos; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_permisos
    ADD CONSTRAINT pk_xcm_permisos PRIMARY KEY (id_permiso);


--
-- TOC entry 2101 (class 2606 OID 34513)
-- Dependencies: 1664 1664
-- Name: pk_xcm_tipos_dir; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_db_tipos_dir
    ADD CONSTRAINT pk_xcm_tipos_dir PRIMARY KEY (id_tipo_dir);


--
-- TOC entry 2135 (class 2606 OID 34515)
-- Dependencies: 1694 1694
-- Name: pk_xcm_usuarios; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_usuarios
    ADD CONSTRAINT pk_xcm_usuarios PRIMARY KEY (login);


--
-- TOC entry 2137 (class 2606 OID 34517)
-- Dependencies: 1695 1695
-- Name: pk_xcm_usuarios_grupos; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_usuarios_grupos
    ADD CONSTRAINT pk_xcm_usuarios_grupos PRIMARY KEY (id_usuario_grupo);


--
-- TOC entry 2141 (class 2606 OID 34519)
-- Dependencies: 1699 1699
-- Name: pk_xcm_usuarios_permisos; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT pk_xcm_usuarios_permisos PRIMARY KEY (id_usuario_permiso);


--
-- TOC entry 2070 (class 2606 OID 34521)
-- Dependencies: 1641 1641 1641
-- Name: vot_candidatos_id_votacion_key; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY vot_candidatos
    ADD CONSTRAINT vot_candidatos_id_votacion_key UNIQUE (id_votacion, id_nuip_candidato);


--
-- TOC entry 2147 (class 2606 OID 37999)
-- Dependencies: 1705 1705 1705
-- Name: vot_candidatos_plancha_id_plancha_key; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY vot_candidatos_plancha
    ADD CONSTRAINT vot_candidatos_plancha_id_plancha_key UNIQUE (id_plancha, id_nuip_candidato);


--
-- TOC entry 2149 (class 2606 OID 37967)
-- Dependencies: 1705 1705
-- Name: vot_candidatos_plancha_pkey; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY vot_candidatos_plancha
    ADD CONSTRAINT vot_candidatos_plancha_pkey PRIMARY KEY (id_candidato_plancha);


--
-- TOC entry 2081 (class 2606 OID 34523)
-- Dependencies: 1645 1645
-- Name: vot_censo_electoral_id_nuip_key; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY vot_censo_electoral
    ADD CONSTRAINT vot_censo_electoral_id_nuip_key UNIQUE (id_nuip);


--
-- TOC entry 2083 (class 2606 OID 34525)
-- Dependencies: 1645 1645
-- Name: vot_censo_electoral_pkey; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY vot_censo_electoral
    ADD CONSTRAINT vot_censo_electoral_pkey PRIMARY KEY (id_censo_electoral);


--
-- TOC entry 2143 (class 2606 OID 38001)
-- Dependencies: 1703 1703 1703
-- Name: vot_planchas_nom_plancha_key; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY vot_planchas
    ADD CONSTRAINT vot_planchas_nom_plancha_key UNIQUE (nom_plancha, id_votacion);


--
-- TOC entry 2145 (class 2606 OID 37952)
-- Dependencies: 1703 1703
-- Name: vot_planchas_pkey; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY vot_planchas
    ADD CONSTRAINT vot_planchas_pkey PRIMARY KEY (id_plancha);


--
-- TOC entry 2085 (class 2606 OID 34527)
-- Dependencies: 1648 1648
-- Name: vot_votaciones_disp_pkey; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY vot_votaciones_disp
    ADD CONSTRAINT vot_votaciones_disp_pkey PRIMARY KEY (id_votacion_disp);


--
-- TOC entry 2064 (class 2606 OID 34529)
-- Dependencies: 1638 1638
-- Name: vot_votaciones_nom_votacion_key; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY vot_votaciones
    ADD CONSTRAINT vot_votaciones_nom_votacion_key UNIQUE (nom_votacion);


--
-- TOC entry 2066 (class 2606 OID 34531)
-- Dependencies: 1638 1638
-- Name: vot_votaciones_pkey; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY vot_votaciones
    ADD CONSTRAINT vot_votaciones_pkey PRIMARY KEY (id_votacion);


--
-- TOC entry 2087 (class 2606 OID 34533)
-- Dependencies: 1651 1651
-- Name: vot_votos_pkey; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY vot_votos
    ADD CONSTRAINT vot_votos_pkey PRIMARY KEY (id_voto);


--
-- TOC entry 2151 (class 2606 OID 38014)
-- Dependencies: 1709 1709
-- Name: vot_votos_planchas_pkey; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY vot_votos_planchas
    ADD CONSTRAINT vot_votos_planchas_pkey PRIMARY KEY (id_voto_plancha);


--
-- TOC entry 2072 (class 2606 OID 34535)
-- Dependencies: 1641 1641
-- Name: vota_candidatos_pkey; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY vot_candidatos
    ADD CONSTRAINT vota_candidatos_pkey PRIMARY KEY (id_candidato);


--
-- TOC entry 2079 (class 2606 OID 34537)
-- Dependencies: 1642 1642
-- Name: xcm_nuips_id_nuip_key; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT xcm_nuips_id_nuip_key UNIQUE (id_nuip);


--
-- TOC entry 2068 (class 2606 OID 34539)
-- Dependencies: 1640 1640
-- Name: xtmp_nuips_id_nuip_key; Type: CONSTRAINT; Schema: public; Owner: dbx_fet; Tablespace:
--

ALTER TABLE ONLY tmp_nuips
    ADD CONSTRAINT xtmp_nuips_id_nuip_key UNIQUE (id_nuip);


--
-- TOC entry 2133 (class 1259 OID 34540)
-- Dependencies: 1694
-- Name: cu_login; Type: INDEX; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE UNIQUE INDEX cu_login ON xcm_usuarios USING btree (login);


--
-- TOC entry 2095 (class 1259 OID 34541)
-- Dependencies: 1660
-- Name: idx_nom_pais_es; Type: INDEX; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE INDEX idx_nom_pais_es ON xcm_db_paises USING btree (nom_pais_es);


--
-- TOC entry 2075 (class 1259 OID 34542)
-- Dependencies: 1642 1642
-- Name: idx_nombres_apellidos; Type: INDEX; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE INDEX idx_nombres_apellidos ON xcm_nuips USING btree (nom_nuip, ape_nuip);


--
-- TOC entry 2124 (class 1259 OID 34543)
-- Dependencies: 1685 1685
-- Name: idx_nuips_grupos_id_grupo; Type: INDEX; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE INDEX idx_nuips_grupos_id_grupo ON xcm_nuips_grupos USING btree (id_nuip_serial, id_grupo);


--
-- TOC entry 2090 (class 1259 OID 34544)
-- Dependencies: 1656
-- Name: ix_rpais; Type: INDEX; Schema: public; Owner: dbx_fet; Tablespace:
--

CREATE INDEX ix_rpais ON xcm_db_departamentos USING btree (id_pais);


--
-- TOC entry 2171 (class 2606 OID 34545)
-- Dependencies: 2076 1642 1685
-- Name: fk___nuips_gru_nuips; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_nuips_grupos
    ADD CONSTRAINT fk___nuips_gru_nuips FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2161 (class 2606 OID 34550)
-- Dependencies: 1660 2096 1656
-- Name: fk__db_deptos_db_paises; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_db_departamentos
    ADD CONSTRAINT fk__db_deptos_db_paises FOREIGN KEY (id_pais) REFERENCES xcm_db_paises(id_pais) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2162 (class 2606 OID 34555)
-- Dependencies: 1658 1656 2091
-- Name: fk__db_munici_db_depar; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_db_municipios
    ADD CONSTRAINT fk__db_munici_db_depar FOREIGN KEY (id_depto) REFERENCES xcm_db_departamentos(id_depto) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2175 (class 2606 OID 34560)
-- Dependencies: 1693 1693 2131
-- Name: fk__id_permiso_id_padre; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_permisos
    ADD CONSTRAINT fk__id_permiso_id_padre FOREIGN KEY (id_padre) REFERENCES xcm_permisos(id_permiso) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2172 (class 2606 OID 34565)
-- Dependencies: 1685 2110 1672
-- Name: fk__nuips_nuips_grupos; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_nuips_grupos
    ADD CONSTRAINT fk__nuips_nuips_grupos FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2164 (class 2606 OID 34570)
-- Dependencies: 2110 1674 1672
-- Name: fk__permisos_grupos_grupos; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT fk__permisos_grupos_grupos FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2178 (class 2606 OID 34575)
-- Dependencies: 1694 1695 2134
-- Name: fk__usuarios_grupos__usuarios; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_usuarios_grupos
    ADD CONSTRAINT fk__usuarios_grupos__usuarios FOREIGN KEY (login) REFERENCES xcm_usuarios(login) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2176 (class 2606 OID 34580)
-- Dependencies: 1694 2118 1678
-- Name: fk__usuarios_niveles_usuario; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_usuarios
    ADD CONSTRAINT fk__usuarios_niveles_usuario FOREIGN KEY (id_nivel_usuario) REFERENCES xcm_niveles_usuario(id_nivel_usuario) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2177 (class 2606 OID 34585)
-- Dependencies: 2076 1694 1642
-- Name: fk__usuarios_nuips; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_usuarios
    ADD CONSTRAINT fk__usuarios_nuips FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2179 (class 2606 OID 34590)
-- Dependencies: 2110 1672 1695
-- Name: fk__usuarios_usuarios__grupos; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_usuarios_grupos
    ADD CONSTRAINT fk__usuarios_usuarios__grupos FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2154 (class 2606 OID 34595)
-- Dependencies: 2098 1662 1642
-- Name: fk_db_sexos_1; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT fk_db_sexos_1 FOREIGN KEY (id_sexo) REFERENCES xcm_db_sexos(id_sexo) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2155 (class 2606 OID 34600)
-- Dependencies: 2102 1642 1666
-- Name: fk_db_tipos_nuip_1; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT fk_db_tipos_nuip_1 FOREIGN KEY (id_tipo_nuip) REFERENCES xcm_db_tipos_nuips(id_tipo_nuip) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2156 (class 2606 OID 34605)
-- Dependencies: 1642 2106 1670
-- Name: fk_titulos_nuip_1; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT fk_titulos_nuip_1 FOREIGN KEY (id_titulo_nuip) REFERENCES xcm_db_titulos_nuips(id_titulo_nuip) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2180 (class 2606 OID 34610)
-- Dependencies: 1699 1693 2131
-- Name: fk_usuarios__permisos_permiso; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT fk_usuarios__permisos_permiso FOREIGN KEY (id_permiso) REFERENCES xcm_permisos(id_permiso) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2181 (class 2606 OID 34615)
-- Dependencies: 1699 1694 2134
-- Name: fk_usuarios_permisos__usuarios; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT fk_usuarios_permisos__usuarios FOREIGN KEY (login) REFERENCES xcm_usuarios(login) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2163 (class 2606 OID 34620)
-- Dependencies: 1672 1642 2076
-- Name: fk_xcm_grup_grupos_nu_xcm_nuip; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_grupos
    ADD CONSTRAINT fk_xcm_grup_grupos_nu_xcm_nuip FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2165 (class 2606 OID 34625)
-- Dependencies: 1674 1693 2131
-- Name: fk_xcm_grup_gruposper_xcm_perm; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT fk_xcm_grup_gruposper_xcm_perm FOREIGN KEY (id_permiso) REFERENCES xcm_permisos(id_permiso) ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- TOC entry 2169 (class 2606 OID 34630)
-- Dependencies: 1682 1664 2100
-- Name: fk_xcm_nuip_email_nuip_tipos; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_nuips_emails
    ADD CONSTRAINT fk_xcm_nuip_email_nuip_tipos FOREIGN KEY (id_tipo_dir) REFERENCES xcm_db_tipos_dir(id_tipo_dir) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2166 (class 2606 OID 34635)
-- Dependencies: 1679 1664 2100
-- Name: fk_xcm_nuip_nuipsdirs_xcm_nuip; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT fk_xcm_nuip_nuipsdirs_xcm_nuip FOREIGN KEY (id_tipo_dir) REFERENCES xcm_db_tipos_dir(id_tipo_dir) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2173 (class 2606 OID 34640)
-- Dependencies: 1689 1668 2104
-- Name: fk_xcm_nuip_nuipstels_xcm_db_t; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_nuips_tels
    ADD CONSTRAINT fk_xcm_nuip_nuipstels_xcm_db_t FOREIGN KEY (id_tipo_tel) REFERENCES xcm_db_tipos_tel(id_tipo_tel) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2167 (class 2606 OID 34645)
-- Dependencies: 1679 1642 2076
-- Name: fk_xcm_nuips_dirs; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT fk_xcm_nuips_dirs FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2170 (class 2606 OID 34650)
-- Dependencies: 1682 1642 2076
-- Name: fk_xcm_nuips_emails_nuip; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_nuips_emails
    ADD CONSTRAINT fk_xcm_nuips_emails_nuip FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2174 (class 2606 OID 34655)
-- Dependencies: 1689 1642 2076
-- Name: fk_xcm_nuips_tels_nuip; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_nuips_tels
    ADD CONSTRAINT fk_xcm_nuips_tels_nuip FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2184 (class 2606 OID 37973)
-- Dependencies: 2078 1642 1705
-- Name: vot_candidatos_plancha_id_nuip_candidato_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY vot_candidatos_plancha
    ADD CONSTRAINT vot_candidatos_plancha_id_nuip_candidato_fkey FOREIGN KEY (id_nuip_candidato) REFERENCES xcm_nuips(id_nuip) ON UPDATE CASCADE;


--
-- TOC entry 2183 (class 2606 OID 37968)
-- Dependencies: 1703 1705 2144
-- Name: vot_candidatos_plancha_id_plancha_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY vot_candidatos_plancha
    ADD CONSTRAINT vot_candidatos_plancha_id_plancha_fkey FOREIGN KEY (id_plancha) REFERENCES vot_planchas(id_plancha) ON UPDATE CASCADE;


--
-- TOC entry 2182 (class 2606 OID 37953)
-- Dependencies: 1703 2065 1638
-- Name: vot_planchas_id_votacion_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY vot_planchas
    ADD CONSTRAINT vot_planchas_id_votacion_fkey FOREIGN KEY (id_votacion) REFERENCES vot_votaciones(id_votacion) ON UPDATE CASCADE;


--
-- TOC entry 2157 (class 2606 OID 34660)
-- Dependencies: 1648 1642 2078
-- Name: vot_votaciones_disp_id_nuip_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY vot_votaciones_disp
    ADD CONSTRAINT vot_votaciones_disp_id_nuip_fkey FOREIGN KEY (id_nuip) REFERENCES xcm_nuips(id_nuip);


--
-- TOC entry 2158 (class 2606 OID 34665)
-- Dependencies: 1648 1638 2065
-- Name: vot_votaciones_disp_id_votacion_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY vot_votaciones_disp
    ADD CONSTRAINT vot_votaciones_disp_id_votacion_fkey FOREIGN KEY (id_votacion) REFERENCES vot_votaciones(id_votacion);


--
-- TOC entry 2159 (class 2606 OID 34670)
-- Dependencies: 1651 1642 2078
-- Name: vot_votos_id_nuip_candidato_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY vot_votos
    ADD CONSTRAINT vot_votos_id_nuip_candidato_fkey FOREIGN KEY (id_nuip_candidato) REFERENCES xcm_nuips(id_nuip) ON UPDATE CASCADE;


--
-- TOC entry 2160 (class 2606 OID 34675)
-- Dependencies: 2065 1651 1638
-- Name: vot_votos_id_votacion_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY vot_votos
    ADD CONSTRAINT vot_votos_id_votacion_fkey FOREIGN KEY (id_votacion) REFERENCES vot_votaciones(id_votacion);


--
-- TOC entry 2186 (class 2606 OID 38020)
-- Dependencies: 1703 1709 2144
-- Name: vot_votos_planchas_id_plancha_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY vot_votos_planchas
    ADD CONSTRAINT vot_votos_planchas_id_plancha_fkey FOREIGN KEY (id_plancha) REFERENCES vot_planchas(id_plancha) ON UPDATE CASCADE;


--
-- TOC entry 2185 (class 2606 OID 38015)
-- Dependencies: 2065 1709 1638
-- Name: vot_votos_planchas_id_votacion_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY vot_votos_planchas
    ADD CONSTRAINT vot_votos_planchas_id_votacion_fkey FOREIGN KEY (id_votacion) REFERENCES vot_votaciones(id_votacion) ON UPDATE CASCADE;


--
-- TOC entry 2152 (class 2606 OID 34680)
-- Dependencies: 1642 1641 2078
-- Name: vota_candidatos_id_nuip_candidato_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY vot_candidatos
    ADD CONSTRAINT vota_candidatos_id_nuip_candidato_fkey FOREIGN KEY (id_nuip_candidato) REFERENCES xcm_nuips(id_nuip);


--
-- TOC entry 2153 (class 2606 OID 34685)
-- Dependencies: 1638 1641 2065
-- Name: vota_candidatos_id_votacion_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY vot_candidatos
    ADD CONSTRAINT vota_candidatos_id_votacion_fkey FOREIGN KEY (id_votacion) REFERENCES vot_votaciones(id_votacion);


--
-- TOC entry 2168 (class 2606 OID 34690)
-- Dependencies: 1658 1679 2093
-- Name: xcm_nuips_dirs_id_municipio_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbx_fet
--

ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT xcm_nuips_dirs_id_municipio_fkey FOREIGN KEY (id_municipio) REFERENCES xcm_db_municipios(id_municipio) ON UPDATE CASCADE;

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;

REVOKE ALL ON SEQUENCE xcm_db_departamentos_id_depto_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_departamentos_id_depto_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_db_departamentos_id_depto_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_db_municipios_id_municipio_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_municipios_id_municipio_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_db_municipios_id_municipio_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_db_paises_id_pais_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_paises_id_pais_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_db_paises_id_pais_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_db_sexos_id_sexo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_sexos_id_sexo_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_db_sexos_id_sexo_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_db_tipos_dir_id_tipo_dir_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_tipos_dir_id_tipo_dir_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_db_tipos_dir_id_tipo_dir_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_db_tipos_nuips_id_tipo_nuip_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_tipos_nuips_id_tipo_nuip_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_db_tipos_nuips_id_tipo_nuip_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_db_tipos_tel_id_tipo_tel_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_tipos_tel_id_tipo_tel_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_db_tipos_tel_id_tipo_tel_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_db_titulos_nuips_id_titulo_nuip_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_titulos_nuips_id_titulo_nuip_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_db_titulos_nuips_id_titulo_nuip_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_grupos_id_grupo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_grupos_id_grupo_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_grupos_id_grupo_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_grupos_permisos_id_grupo_permiso_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_grupos_permisos_id_grupo_permiso_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_grupos_permisos_id_grupo_permiso_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_nuips_dirs_id_nuip_dir_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_dirs_id_nuip_dir_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_nuips_dirs_id_nuip_dir_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_nuips_emails_id_nuip_email_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_emails_id_nuip_email_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_nuips_emails_id_nuip_email_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_nuips_grupos_id_nuip_grupo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_grupos_id_nuip_grupo_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_nuips_grupos_id_nuip_grupo_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_nuips_id_nuip_serial_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_id_nuip_serial_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_nuips_id_nuip_serial_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_nuips_tels_id_nuip_tel_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_tels_id_nuip_tel_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_nuips_tels_id_nuip_tel_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_usuarios_grupos_id_usuario_grupo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_usuarios_grupos_id_usuario_grupo_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_usuarios_grupos_id_usuario_grupo_seq TO dbx_fet;

REVOKE ALL ON SEQUENCE xcm_usuarios_permisos_id_usuario_permiso_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_usuarios_permisos_id_usuario_permiso_seq FROM dbx_fet;
GRANT ALL ON SEQUENCE xcm_usuarios_permisos_id_usuario_permiso_seq TO dbx_fet;

GRANT EXECUTE ON FUNCTION graba_usuario(integer, integer, character varying, character varying, character varying, character varying) TO dbx_fet;
GRANT EXECUTE ON FUNCTION vot_resultados_fx(integer) TO dbx_fet;
GRANT EXECUTE ON FUNCTION vot_resultados_planchas_fx(integer) TO dbx_fet;
GRANT EXECUTE ON FUNCTION vot_votaciones_pendientes_fx(bigint) TO dbx_fet;
GRANT ALL ON TABLE conteo TO dbx_fet;
GRANT ALL ON TABLE vot_candidatos_plancha_id_candidato_plancha_seq TO dbx_fet;
GRANT ALL ON TABLE vot_censo_electoral_id_censo_electoral_seq TO dbx_fet;
GRANT ALL ON TABLE vot_planchas_id_plancha_seq TO dbx_fet;
GRANT ALL ON TABLE vot_votaciones_disp_id_votacion_disp_seq TO dbx_fet;
GRANT ALL ON TABLE vot_votaciones_id_votacion_seq TO dbx_fet;
GRANT ALL ON TABLE vot_votos_id_voto_seq TO dbx_fet;
GRANT ALL ON TABLE vot_votos_planchas_id_voto_plancha_seq TO dbx_fet;
GRANT ALL ON TABLE vota_candidatos_id_candidato_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_db_departamentos_id_depto_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_db_municipios_id_municipio_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_db_paises_id_pais_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_db_sexos_id_sexo_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_db_tipos_dir_id_tipo_dir_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_db_tipos_nuips_id_tipo_nuip_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_db_tipos_tel_id_tipo_tel_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_db_titulos_nuips_id_titulo_nuip_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_grupos_id_grupo_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_grupos_permisos_id_grupo_permiso_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_dirs_id_nuip_dir_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_emails_id_nuip_email_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_grupos_id_nuip_grupo_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_id_nuip_serial_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_tels_id_nuip_tel_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_usuarios_grupos_id_usuario_grupo_seq TO dbx_fet;
GRANT ALL ON TABLE xcm_usuarios_permisos_id_usuario_permiso_seq TO dbx_fet;
GRANT ALL ON TABLE tmp_nuips TO dbx_fet;
GRANT ALL ON TABLE vot_candidatos TO dbx_fet;
GRANT ALL ON TABLE vot_candidatos_plancha TO dbx_fet;
GRANT ALL ON TABLE vot_censo_electoral TO dbx_fet;
GRANT ALL ON TABLE vot_planchas TO dbx_fet;
GRANT ALL ON TABLE vot_votaciones TO dbx_fet;
GRANT ALL ON TABLE vot_votaciones_disp TO dbx_fet;
GRANT ALL ON TABLE vot_votos TO dbx_fet;
GRANT ALL ON TABLE vot_votos_planchas TO dbx_fet;
GRANT ALL ON TABLE xcm_campos_db TO dbx_fet;
GRANT ALL ON TABLE xcm_db_departamentos TO dbx_fet;
GRANT ALL ON TABLE xcm_db_municipios TO dbx_fet;
GRANT ALL ON TABLE xcm_db_paises TO dbx_fet;
GRANT ALL ON TABLE xcm_db_sexos TO dbx_fet;
GRANT ALL ON TABLE xcm_db_tipos_dir TO dbx_fet;
GRANT ALL ON TABLE xcm_db_tipos_nuips TO dbx_fet;
GRANT ALL ON TABLE xcm_db_tipos_tel TO dbx_fet;
GRANT ALL ON TABLE xcm_db_titulos_nuips TO dbx_fet;
GRANT ALL ON TABLE xcm_grupos TO dbx_fet;
GRANT ALL ON TABLE xcm_grupos_permisos TO dbx_fet;
GRANT ALL ON TABLE xcm_niveles_usuario TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_dirs TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_emails TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_grupos TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_tels TO dbx_fet;
GRANT ALL ON TABLE xcm_permisos TO dbx_fet;
GRANT ALL ON TABLE xcm_usuarios TO dbx_fet;
GRANT ALL ON TABLE xcm_usuarios_grupos TO dbx_fet;
GRANT ALL ON TABLE xcm_usuarios_permisos TO dbx_fet;
GRANT ALL ON TABLE vot_candidatos_v1 TO dbx_fet;
GRANT ALL ON TABLE vot_candidatos_v2 TO dbx_fet;
GRANT ALL ON TABLE vot_candidatos_v3 TO dbx_fet;
GRANT ALL ON TABLE vot_candidatos_v4 TO dbx_fet;
GRANT ALL ON TABLE vot_censo_electoral_v1 TO dbx_fet;
GRANT ALL ON TABLE vot_votos_v1 TO dbx_fet;
GRANT ALL ON TABLE xcm_grupos_v1 TO dbx_fet;
GRANT ALL ON TABLE xcm_municipios_deptos_paises_v1 TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_dirs_v1 TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_emails_v1 TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_grupos_v1 TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_tels_v1 TO dbx_fet;
GRANT ALL ON TABLE xcm_nuips_v1 TO dbx_fet;
GRANT ALL ON TABLE xcm_usuarios_grupos_nuips_v1 TO dbx_fet;
GRANT ALL ON TABLE xcm_usuarios_grupos_v1 TO dbx_fet;
GRANT ALL ON TABLE xcm_usuarios_v1 TO dbx_fet;

