
CREATE OR REPLACE FUNCTION vot_resultados_planchas_fx(p_id_votacion integer)
  RETURNS SETOF vot_resultado2 AS
$BODY$DECLARE
r vot_resultado2;
v_cant_votos integer;
v_contador integer;
BEGIN
	SELECT COUNT(*) INTO v_cant_votos
	 FROM  vot_votos_planchas
	 WHERE id_votacion = $1;
	v_contador := 1;

	IF (v_cant_votos > 0) THEN
		FOR r IN SELECT (p.nom_plancha) AS maq_nom_nuip, p.id_plancha as id_nuip_candidato, count(*) AS nro_votos, round(count(*)/v_cant_votos::numeric*100,2)::Integer AS pct_votos, v.id_votacion
			  FROM  vot_votos_planchas v, vot_planchas p
			  WHERE v.id_plancha = p.id_plancha
			    AND v.id_votacion = $1
			  GROUP BY v.id_votacion, p.id_plancha, p.nom_plancha
			  ORDER BY count(*) DESC
		LOOP
			r.conteo := v_contador;
			v_contador := v_contador + 1;
			RETURN NEXT r;
		END LOOP;
		RETURN;
	ELSE
		RAISE EXCEPTION 'No se han registrado votos.';
	END IF;
END$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION vot_resultados_planchas_fx(integer) OWNER TO dbxdba;


CREATE TABLE vot_votos_planchas
(
  id_voto_plancha bigserial NOT NULL,
  id_votacion integer NOT NULL,
  id_plancha bigint NOT NULL,
  fec_voto timestamp without time zone NOT NULL DEFAULT now(),
  CONSTRAINT vot_votos_planchas_pkey PRIMARY KEY (id_voto_plancha),
  CONSTRAINT vot_votos_planchas_id_plancha_fkey FOREIGN KEY (id_plancha)
      REFERENCES vot_planchas (id_plancha) MATCH SIMPLE
      ON UPDATE CASCADE ON DELETE NO ACTION,
  CONSTRAINT vot_votos_planchas_id_votacion_fkey FOREIGN KEY (id_votacion)
      REFERENCES vot_votaciones (id_votacion) MATCH SIMPLE
      ON UPDATE CASCADE ON DELETE NO ACTION
);

CREATE OR REPLACE VIEW vot_candidatos_v4 AS
 SELECT c.id_candidato_plancha
	, c.id_plancha
	, c.id_nuip_candidato
	, c.tipo_candidato
	, c.orden
	, COALESCE((n.nom_nuip || ' '::text) || n.ape_nuip, n.nom_nuip, n.ape_nuip) AS maq_nom_nuip
   FROM vot_candidatos_plancha c, xcm_nuips n
  WHERE c.id_nuip_candidato = n.id_nuip;
COMMENT ON VIEW vot_candidatos_v4 IS 'v.20110317.1';


CREATE OR REPLACE VIEW vot_candidatos_v3 AS
 SELECT c.id_candidato_plancha
	, c.id_nuip_candidato
	, c.orden
	, c.tipo_candidato
	, c.id_plancha
	, CASE WHEN c.tipo_candidato=1 THEN 'Principal' ELSE 'Suplente' END AS maq_tipo_candidato
	, COALESCE((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || n.digito_verif::text, to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip
	, COALESCE((n.nom_nuip || ' '::text) || n.ape_nuip, n.nom_nuip, n.ape_nuip) AS maq_nom_nuip
   FROM vot_candidatos_plancha c, xcm_nuips n
  WHERE c.id_nuip_candidato = n.id_nuip;

COMMENT ON VIEW vot_candidatos_v3 IS 'v.20110316.1';

CREATE TABLE vot_candidatos_plancha
(
  id_candidato_plancha bigserial NOT NULL,
  id_plancha bigint NOT NULL,
  id_nuip_candidato bigint NOT NULL,
  orden integer,
  tipo_candidato integer NOT NULL DEFAULT 1,
  login_tx character varying(30),
  fec_tx timestamp without time zone NOT NULL DEFAULT now(),
  CONSTRAINT vot_candidatos_plancha_pkey PRIMARY KEY (id_candidato_plancha),
  CONSTRAINT vot_candidatos_plancha_id_nuip_candidato_fkey FOREIGN KEY (id_nuip_candidato)
      REFERENCES xcm_nuips (id_nuip) MATCH SIMPLE
      ON UPDATE CASCADE ON DELETE NO ACTION,
  CONSTRAINT vot_candidatos_plancha_id_plancha_fkey FOREIGN KEY (id_plancha)
      REFERENCES vot_planchas (id_plancha) MATCH SIMPLE
      ON UPDATE CASCADE ON DELETE NO ACTION,
  CONSTRAINT vot_candidatos_plancha_id_plancha_key UNIQUE (id_plancha, id_nuip_candidato)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE vot_candidatos_plancha OWNER TO dbxdba;


CREATE TABLE vot_planchas
(
  id_plancha bigserial NOT NULL,
  nom_plancha character varying NOT NULL,
  id_votacion integer NOT NULL,
  login_tx character varying(30),
  fec_tx timestamp without time zone NOT NULL DEFAULT now(),
  CONSTRAINT vot_planchas_pkey PRIMARY KEY (id_plancha),
  CONSTRAINT vot_planchas_id_votacion_fkey FOREIGN KEY (id_votacion)
      REFERENCES vot_votaciones (id_votacion) MATCH SIMPLE
      ON UPDATE CASCADE ON DELETE NO ACTION,
  CONSTRAINT vot_planchas_nom_plancha_key UNIQUE (nom_plancha, id_votacion)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE vot_planchas OWNER TO dbxdba;
COMMENT ON TABLE vot_planchas IS 'Definicion de planchas';
