<?php
//====================================================================================================
//===================================    FUNCIONES DE SEGURIDAD    ===================================
//====================================================================================================
global $db;

function transaccion($estado) {
	global $db;
	if($estado == "COMMIT") {
		$estado = "COMMIT;";
	}
	else {
		$estado = "ROLLBACK;";
	}
	$resultado = $db->Execute($estado);
}

function dataUsuario($login="", $remoto=FALSE) {
   global $cnf;
   global $db;
   global $esqDB;
   $resp = array();

   if(conectar_db7() === false) {
      echo "Error de Conexion";
   }
   if($remoto == true) { $login = $_SESSION['login']; }

   $ssql = sql_xcm_usuarios("data_usuario");

   if($db) {
   	$result = $db->Execute($ssql, array($login) );
   }
   else { $result = false; }

   if ( !($result === false) AND ( $result->RecordCount() >= 1 ) ) {
   	array_push($resp, $result->fields[6], $result->fields[7] );
   }

   return $resp;
}
// 20140106 - OJO xButil - Cambiar el orden de los parámetros, dejar $i de primero
function conectar_db7($remoto = true, $login = "", $passwd = "", $i=0) {
	global $db;
	global $cnf;
	//$cnf["usuarios_db"] = true;
	if ($cnf["usuarios_db"] and isset($cnf['login'])) {
		$cnf["dbuser"][$i] = $cnf['login'];  // Nombre de Usuario de DB
 		$cnf["dbpass"][$i] = $cnf['passwd']; // Contraseña del usuario de DB
	}
	if ( ($remoto === true) AND ($login == "") ) {
        if (!array_key_exists('login', $_SESSION)) { $login = ""; } else { $login = $_SESSION['login']; }
        if (array_key_exists('passwd', $_SESSION)) { $passwd = $_SESSION["passwd"]; } else { $passwd = ""; }
	}
	if($cnf["usuarios_db"] === true) {
        $dsn = $cnf["db"][$i].'://'.$login.':'.$passwd.'@'.$cnf["dbhost"][$i].':'.$cnf["dbport"][$i].'/'.$cnf["dbname"][$i];
	}
	else {
        $dsn = $cnf["db"][$i].'://'.$cnf["dbuser"][$i].':'.$cnf["dbpass"][$i].'@'.$cnf["dbhost"][$i].':'.$cnf["dbport"][$i].'/'.$cnf["dbname"][$i];
	}
	$db = ADONewConnection($dsn);
	//$db->debug = true;

	//if (!($db->Connect( $cnf["dbhost"], $cnf["dbuser"], $cnf["dbpass"] ) ) )
	if (!($db) ) return false;
	// else return true; // Retornaba true
	else return $i; // Ahora retorna el INDICE $i de la DB Activa
}

function verificar_permiso_login($login, $pasabordo, $permiso) {
	global $cnf;

	global $db;

	global $esqDB;
	$row = false;
	$respuesta = Array();
	$error = "";
	$cad_login = "false";

	if(conectar_db7() === false) {
		echo "Error de Conexion";
	}

	$ssql = sql_xcm_usuariospermisos('verifica');
	$result = $db->Execute($ssql, array($permiso, $login) );
	$cadena = "false";

	while(!$result->EOF) {
		$row = $result->fields[0];
		$result->MoveNext();
	}

	if (($row == 1) OR ($login == "dbxdba")) {
		$cadena = "true";
	}
	else {
		$error = "El usuario ({$login}) no tiene permiso para editar";
	}

	$ssql = sql_xcm_usuarios('verifica_login_sin_nivel');

	if($db) {
		$result = $db->Execute($db->Prepare($ssql), array($login, $pasabordo) );
	}
	else {
		$result = false;
	}

	if ( !($result === false) AND ( $result->RecordCount() >= 1 ) ) {
		if(($result->fields[4] == "f") OR ($result->fields[4] == "false") OR ($result->fields[4] == false))	{
			$error="Usuario ({$login}) Inactivo";
		}
		else {
			$cad_login = "true";
		}
	}
	else {
		$error = "login o Pasabordo Incorrecto";
	}

	$respuesta['error'] = $error;
	$respuesta['permiso'] = $cadena;
	$respuesta['login'] = $cad_login;

	return $respuesta;
}

//===============================
// Function verificar_permiso
//===============================
function verificar_permiso7($login, $permiso, $remoto=false, $log=false) {
   global $cnf;
   global $db;
   global $esqDB;
   if(conectar_db7() === false) {
      echo "Error de Conexion";
   }

   if($remoto == true) { $login = $_SESSION['login']; }

   $ssql = sql_xcm_usuariospermisos('verifica');

   $result = $db->Execute($ssql, array($permiso, $login) );
   $cadena = "false";
// EG - 26 03 2007 agregue que el usuario dbxdba no se le verifique permisos
   while(!$result->EOF) {
      $row = $result->fields[0];
      $result->MoveNext();
   }

   if (($row == 1) OR ($login == "dbxdba")) {
      if (!$remoto) return true;
      else return "true";
   }
   else {
      $estado = '0'; // OJO Verificar si el valor BOOLEAN para los parametros del los string de SQL se deben enviar con comillas o con valor TRUE or FALSE

      $ssql = sql_xcm_usuariospermisos('datos_permiso');

       //$result = $db->Execute($ssql, array($permiso,$estado));
       $result = $db->Execute(repare_ADOdbSQL($ssql, array($permiso)));

                  // echo ''.$result->sql.'';

      if($result === false) {
         $error = "ERROR: La sintaxis de la cadena SQL no es adecuada.<br /><br />".$db->ErrorNo()." - ".$db->ErrorMsg();
         echo dialog(array($error,"ERROR",""));
      }
      else if(is_string($result)){
         $error = "ERROR: La sintaxis de la cadena SQL no es adecuada.<br /><br />".$db->ErrorNo()." - ".$db->ErrorMsg();
         echo dialog(array($error,"ERROR",""));
      }
      else {
      	$row = array(); // Se redefine la variable para evitar un error en su contenido
      	while(!$result->EOF) {
      		$row['nom_permiso'] = $result->fields[0];
      		$row['desc_permiso'] = $result->fields[1];
      		// echo "|".$row['nom_permiso']."|";

      		if($row['nom_permiso'] == "") {
      			unset($row);
      		}
      		$result->MoveNext();
      	}
      }

      // $error = "ERROR: El usuario se encuentra creado en el sistema, pero no se le han asignado permisos.<br /><br />".$db->ErrorNo()." - ".$db->ErrorMsg();
      // echo dialog(array($error,"ERROR",""));

      if(!array_key_exists('nom_permiso', $row)) {
      	$nom_perm = NULL;
      }
      else { $nom_perm = $row['nom_permiso'];
      }

      if (is_null($nom_perm)) {
      	if (!$remoto) {
      		$cadena = "<div style=\"color: Red; text-align: center;\">PERMISO NO DEFINIDO</div><br>Posible Causa: <br>Falta actualizar el listado de Permisos.<br>Por favor comun&iacute;quese con el Administrador del Sistema.<br><a href='javascript:window.history.back();'>Haga click aqu&iacute; para regresar</a> o <a href=\"javascript:window.location.replace('../includes/ax.salida_segura.php');\">aqu&iacute; para salir del sistema</a>";
      	}
      	else { $cadena = "false";
      	}
      }
      else {
      	if (trim($row['desc_permiso']) == '') {
      		if (!$remoto) {
      			$cadena = "<div style=\"color: Red; text-align: center;\">PERMISO DENEGADO</div><br> No tiene permiso para:<br><span style=\"font-weight: bolder;\">".$row['nom_permiso']."</span><br><br>Si desea obtener este permiso, comun&iacute;quese con el Administrador del Sistema.<br><a href='javascript:window.history.back();'>Haga click aqu&iacute; para regresar</a> o <a href=\"javascript:window.location.replace('../includes/ax.salida_segura.php');\">aqu&iacute; para salir del sistema</a>";
      		}
      		else { $cadena = "false";
      		}
      	}
      	else {
      		if (!$remoto) {
      			$cadena = "<div style=\"color: Red; text-align: center;\">PERMISO DENEGADO</div><br> No tiene permiso para:<br><span style=\"font-weight: bolder;\">".$row['nom_permiso']."</span><br><br>Si desea obtener este permiso, comun&iacute;quese con el Administrador del Sistema.<br><a href='javascript:window.history.back();'>Haga click aqu&iacute; para regresar</a> o <a href=\"javascript:window.location.replace('../includes/ax.salida_segura.php');\">aqu&iacute; para salir del sistema</a>";
      		}
      		else { $cadena = "false";
      		}
      	}
      }

      if ((!$remoto) && ($cadena != "false" )) {
      	echo dialog(array($cadena,"ERROR",""));
      	if($log) {
      		session_unset();
      		session_destroy();
      	}
      	exit;
      }
      else return $cadena;
   }
}

//===============================
// Function LOGIN
//===============================
function login7($login, $passwd, $remoto=false, $nivel_usuario=false, $ws=false, $pass_oracle='') {
	global $cnf;
	global $m_;
	global $db;
	global $esqDB;
	$cant_ses = 0;

	$ipRemota = $_SERVER['REMOTE_ADDR'];
	$cnf["nivel_usuario"] = 2;

	if ( ($remoto == true) AND ($login == "") ) {
		$login  = $_SESSION["login"];
		$passwd = $_SESSION["passwd"];
	}

	$con = conectar_db7($remoto,$login,$passwd);
	if($con === false) {
		if($ws === true) {
			return Array(false, "Error de conexión a la Base de Datos", "001");
		}
		else {
			echo "Error de conexión a la Base de Datos";
		}
	}

	//===============================
	// Interfaz LINIX - INICIO
	//require_once("{$_SERVER["DOCUMENT_ROOT"]}{$cnf["axys_path"]}/libs/adodb5/adodb.inc.php");
	$ssql = "";
	if (isset($cnf["linix_users"]) and $cnf["linix_users"] === true) {
		$db1 = NewADOConnection("oci8");

		if (is_numeric($login)) {
			$ora_login = $db1->Connect("//{$cnf["linix_dbhost"]}:{$cnf["linix_dbport"]}/{$cnf["linix_db"]}", $cnf["linix_dbuser"], $cnf["linix_dbpass"]); //OJO pass es el password que tiene el usuario HR
		}
		else {
			$pass_oracle = substr($pass_oracle,9);
			$ora_login = $db1->Connect("//{$cnf["linix_dbhost"]}:{$cnf["linix_dbport"]}/{$cnf["linix_db"]}", $login, $pass_oracle); //OJO pass es el password que tiene el usuario HR
		}
		$db1->SetFetchMode(ADODB_FETCH_ASSOC); // 20160803 - xButil - Optimizó la carga de 758KB/35s a 472KB/32s

		if ($ora_login){
			$data["conexionDBOracle"] = "1";
		}
		else {
			if($ws === true) {
				return Array(false, "Error de conexion a ORACLE", "001");
			}
			else {
				echo "Error de conexion a ORACLE";
			}
		}
		if (is_numeric($login)) { // Asociado ingresa con DOC_ID
			$sql = "SELECT 'SELECT * FROM xcm_registra_usuario_eventos_feval('''||NNASOCIA||''','''','''||AANUMNIT||''',MD5('''||pk_we_general.fu_decifrar(O_CLAVE, aanumnit)||'''),''dbxdba'');' AS query FROM AP484TCLAVECLI, ap014mcliente WHERE AP484TCLAVECLI.k_idterc = ap014mcliente.k_idterc AND aanumnit='{$login}'";
		}
		else { // Usuario LINIX ingresa con login ORACLE
			$sql = "SELECT 'SELECT * FROM xcm_registra_usuario_eventos_feval('''||N_USUARI||''','''','''||K_USUARI||''',MD5(''{$pass_oracle}''),''dbxdba'');' AS query FROM AD078MUSUARIO WHERE i_activo='Y' AND K_USUARI='{$login}'";
		}
		$resultado = $db1->Execute($sql);
		$data = $resultado->GetArray();
		$query_axys = $db->Execute($data[0]["QUERY"]);
	}
	// Interfaz LINIX - FIN
	//===============================

	if($cnf["usuarios_db"] === true) {
		$passwd = md5($passwd);
	}

	if ($nivel_usuario) {
		$ssql = "SELECT (login), id_nivel_usuario, cant_sesiones_max, cant_sesiones, is_activo, id_nuip_serial, id_nuip, dias_pasabordo, maq_nom_nuip
	         	FROM  xcm_usuarios_v1
	         	WHERE login  = ? AND passwd = ? ; ";
	}
	else {
		$ssql = "SELECT (login), 2 AS id_nivel_usuario, cant_sesiones_max, cant_sesiones, is_activo, id_nuip_serial, id_nuip, dias_pasabordo, maq_nom_nuip
	         	FROM  xcm_usuarios_v1
	         	WHERE login  = ? AND passwd = ? ; ";
	}

	if($db) {
		//$db->debug=true;
		$result = $db->Execute($db->Prepare($ssql), array($login, $passwd) );
		//var_dump($ssql);
		//var_dump($db->ErrorMsg());
	}
	else {
		$result = false;
	}

	if ( !($result === false) AND ( $result->RecordCount() >= 1 ) ) {
		$cnf["nivel_usuario"] = ( ($result->fields[1] == 0) OR ($result->fields[1] == 1) OR ($result->fields[1] == 2) )? $result->fields[1] :2;

		// Datos Adicionales del usuario - v.140923.1
		$cnf["login"]  = $login;
		$cnf["id_nuip_serial_usuario"] = isset($result->fields[5])?$result->fields[5]:"";
		$cnf["id_nuip_usuario"] = isset($result->fields[6])?$result->fields[6]:"";
		$cnf["dias_passwd"] = isset($result->fields[7])?$result->fields[7]:"";
		$cnf["nom_usuario"] = isset($result->fields[8])?$result->fields[8]:"";

		$cnf["cambia_passwd"] = isset($result->fields[8])?$result->fields[8]:"0"; /* OJO - Revisar uso de esta variable */

		// EG 31/12/2008 - Usu Activo
		if(($result->fields[4] == "f") OR ($result->fields[4] == "false") OR ($result->fields[4] == false) OR ($result->fields[4] <= 0)) {
			if (!$remoto) {
				echo dialog(array($m_['usuario_inactivo'],"INFO","",true));
			}
         else if($ws === true) {
            //return Array(false, "Usuario inactivo.<br/>Por favor comuniquese con el administrador del sistema.", "004", $db->ErrorMsg() );
            return Array(false, "Usuario inactivo", "004", $db->ErrorMsg() );
         }
			exit;
		}

		// EG 15/04/2008 - Num Sesiones
		if( isset($cnf["xesion"]) AND $cnf["xesion"]==true ) {
			$cant_ses = $result->fields[3];
			$cant_ses_max = $result->fields[2];
		}
		else {
			$cant_ses = 0;
			$cant_ses_max = 1;
		}

		if( !isset( $_SESSION["cnf"]['EnSistema'] ) AND ( isset($cnf["xesion"]) AND $cnf["xesion"]===true ) ) {
			if($result->fields[3] >= $result->fields[2]) {
				if (!$remoto) {
					echo dialog(array($m_['err_max_sess'],"INFO","",true));
					$result = $db->Execute( sql_xcm_sesiones(), array($login) );
					$cadena = "<table border='0'>";
					$cadena .= "<tr align='center'><td><b>Acci&oacute;n</b></td><td><b>Usuario</b></td><td><b>Fecha de Ingreso</b></td><td><b>IP</b></td></tr>";
					while(!$result->EOF) {
						$cadena .= "\n<tr><td><a href='".$cnf["lib_path"]."/xSesion.php?sid=".$cnf["nom_session"]."&id=".$result->fields[3]."' target='pisc1'>Cerrar&nbsp;Sesion</a></td>";
                  $cadena .= "<td>".$result->fields[0]."</td><td>".$result->fields[1] ."</td><td>".$result->fields[2] ."</td></tr>";
                  $result->MoveNext();
               }
               $cadena .= "</table><iframe id='pisc1' name='pisc1' style='display:none; width:0px'></iframe>";
               echo dialog(array($cadena,"INFO", "", true));
//					session_unset();
//             session_destroy();
            }
         	exit;
         }
      }

      if ($nivel_usuario) {
			$id_grupos = "";
			$nom_grupos = "";

         // 20130401 - Trae los IDs y los NOMBREs de los grupos a los que el usuario pertenece
			$ssql1 = repare_ADOdbSQL("SELECT id_grupo, nom_grupo
		           							FROM xcm_usuarios_grupos_v1
		  		   							WHERE login  = ?
		  		   							ORDER BY nom_grupo; ", array($login), false );
			$result = $db->Execute($ssql1);

			$sdataGr = $result->GetRows();
			$result->MoveFirst();
			while(!$result->EOF) {
				if($id_grupos !== "") {
				  $id_grupos = "{$id_grupos},";
				}
				if($nom_grupos !== "") {
				 $nom_grupos = "{$nom_grupos},";
				}
				$id_grupos .= trim($result->fields[0]);
				$nom_grupos .= trim($result->fields[1]);
				$result->MoveNext();
			}

			if($result->RecordCount() === 1) {
				// Carga la Configuración ($cnf) x Grupo
				fgrupo_activo($id_grupos, $nom_grupos);
			}

			if(trim($id_grupos) == "") {
				if (!$remoto)
                                {
                                  echo dialog(array($m_['err_grupos'] ,"ERROR","",true));
                                                session_unset();
                                                session_destroy();
                                }
                                return Array(false, "El usuario no tiene Grupo Corporativo asignado", "003");
                                exit();
                        }

                        $cnf["grupos_usuario"] = $id_grupos;
                        $_SESSION["cnf"]["grupos_usuario"] = $cnf["grupos_usuario"];
                        $cnf["id_grupos_usuario"] = $id_grupos;
                        $_SESSION["cnf"]["id_grupos_usuario"] = $cnf["id_grupos_usuario"];
                        $cnf["nom_grupos_usuario"] = $nom_grupos;
                        $_SESSION["cnf"]["nom_grupos_usuario"] = $cnf["nom_grupos_usuario"];
                        $cnf["grupos_usuario_data"] = json_encode($sdataGr);
                        $_SESSION["cnf"]["grupos_usuario_data"] = $cnf["grupos_usuario_data"];

						/* 2012-01-17   Bloque movido a ax.basico.sr.php function fgrupo_activo */
                        if( !isset( $_SESSION["cnf"]['EnSistema'] ) AND ( isset($cnf["xesion"]) AND $cnf["xesion"]==true ) )
                        {
                           $cnf['EnSistema'] = true;
                           $_SESSION["cnf"]['EnSistema'] = true;

                                if($cant_ses >= $cant_ses_max)
                                {
                                        $result = $db->Execute(sql_xcm_usuarios('actualiza_sesiones'), array( $cant_ses_max, $login, $passwd ) );
                                        $semilla = $cant_ses_max;
                                }
                                else
                                {
                                        $result = $db->Execute(sql_xcm_usuarios('actualiza_sesiones'), array( ($cant_ses + 1), $login, $passwd ) );
                                        $semilla = $cant_ses + 1;
                                }

                                $result = $db->Execute(sql_xcm_sesiones('guarda_login_semilla'), array( $login, $ipRemota, $semilla ) );

                                $result = $db->Execute(sql_xcm_sesiones('retorna_id_sesion'), array( $login, $ipRemota, $semilla ) );
                                while(!($result === false) AND !$result->EOF)
                                {
                                   $cnf['id_sess'] = $result->fields[0];
                                   $result->MoveNext();
                                }

                        }
                }

                $_SESSION["ultimoacceso"] =  date("Y-n-j H:i:s");

                xapito_Acceso7($ipRemota, $login, 'I');


				if ( function_exists('dataLogin') ) {
					dataLogin($login);
				}
				if (!$remoto) {
					return true;
				}
				else if($ws === true) {
					return Array(true, "Acceso concedido");
				}
				else {
					return 'true';
				}
        }
        else
        {
                if (!$remoto) {
						echo dialog(array($m_['err_login'],"ERROR","", true));
						xapito_Acceso7($ipRemota, $login, 'F');
						exit;
						return false;
                }
                else if($ws === true) {
                        return Array(false, "Acceso denegado", "002", $db->ErrorMsg() );
                }
                else {
                	return 'false';
                }

   }

}
////////////////////////////////////////////////////////////////////////
/// EG - 2008/04/15
function cierre_sesion7()
{
        global $cnf;
        global $db;
        global $esqDB;

        $ipRemota = $_SERVER['REMOTE_ADDR'];
        $login = $_SESSION['login'];

        if($cnf["xesion"] === true)
        {
                $id_sess = isset($cnf['id_sess'])?$cnf['id_sess']:"";
                conectar_db7();

                if($login == false AND $id_sess != "")
                {
                        $ssql = "SELECT login, semilla FROM " .$esqDB['xcomun']['sesiones']. " WHERE id_sesion= ?";
                        $result = $db->Execute( $ssql, array($id_sess) );
                        while(!$result->EOF)
                        {
                                $login = $result->fields[0];
                                $result->MoveNext();
                        }
                }
                else
                {
                        xapito_Acceso7($ipRemota, $login, 'E');
                }

                if($login != false )
                {
                        $ssql = "UPDATE ".$esqDB['xcomun']['usuarios']. " SET cant_sesiones=(cant_sesiones - 1)
                                  WHERE login= ?";
                        $result = $db->Execute($ssql, array( $login ) );
                }

                $ssql = "UPDATE ".$esqDB['xcomun']['usuarios']. " SET cant_sesiones = 0
                          WHERE cant_sesiones < 0";
                $result = $db->Execute($ssql);

                $ssql = "UPDATE ".$esqDB['xcomun']['usuarios']. " SET cant_sesiones = cant_sesiones_max
                          WHERE cant_sesiones > cant_sesiones_max";
                $result = $db->Execute($ssql);

                if($id_sess != "")
                {
                        $ssql = "DELETE FROM ".$esqDB['xcomun']['sesiones']. " WHERE id_sesion= ?";
                        $result =$db->Execute( $ssql, array($id_sess) );
                }
        }

        xapito_Acceso7($ipRemota, $login, 'O');

        if(isset($_SESSION))
        {
                $_SESSION = array();
                session_unset();
                session_destroy();
        }
}
////////////////////////  FUNCIONES XAPITO
/// EG - 2008/03/12
////////////////////////////////////////////////////////////////////////
function xapito_Acceso7($ipRemota, $login, $evento)
{
        global $cnf;
        global $db;
        global $esqDB;

        if (isset($cnf["xapito"]) AND $cnf["xapito"]===true)
        {
                conectar_db7();
                $ssql= "INSERT INTO ".$esqDB['xapito']['acceso']." (ip, login, nom_evento) VALUES (?, ?, ?)";
               if($db) { $result= $db->Execute( $ssql, array($ipRemota, $login, $evento) ); } else { $result= false; }
        }
}
//////////////////////////////////////////////////////////////////////////////////////////////////// Funcion de reparacion para SQL
function repare_ADOdbSQL($sql,$inputarr=false, $reservado=false) {
        // Si reservado en TRUE entonces a las palabras reservadas no les pondra comillas

                /*if ($this->fnExecute) {
                        $fn = $this->fnExecute;
                        $ret = $fn($this,$sql,$inputarr);
                        if (isset($ret)) return $ret;
                }*/
                // Limpiando el sql
                $sql = strtr($sql, "\r\n\t","   ");
                if ($inputarr) {
                        if (!is_array($inputarr)) $inputarr = array($inputarr);

                        $element0 = reset($inputarr);
                        # is_object check because oci8 descriptors can be passed in
                        $array_2d = is_array($element0) && !is_object(reset($element0));
                        //remove extra memory copy of input -mikefedyk
                        unset($element0);

                        if (!is_array($sql)){
                                $sqlarr = explode('?',$sql);
                                $nparams = sizeof($sqlarr)-1;
                                if (!$array_2d) $inputarr = array($inputarr);
                                foreach($inputarr as $arr) {
                                        $sql = ''; $i = 0;
                                        //Use each() instead of foreach to reduce memory usage -mikefedyk
                                        while(list(, $v) = each($arr)) {
                                                $sql .= $sqlarr[$i];
                                                // from Ron Baldwin <ron.baldwin#sourceprose.com>
                                                // Only quote string types
                                                $typ = gettype($v);
                                                if ($typ == 'string')
                                                {
                                                        if($reservado == true)
                                                        {
                                                                if(trim($v) == "ALL" )
                                                                {
                                                                        $sql .= "$v";//$this->qstr($v);
                                                                }
                                                                else
                                                                {
                                                                        $sql .= "$v";//$this->qstr($v);
                                                                }
                                                        }
                                                        else
                                                        {
                                                                $sql .= "'$v'";//$this->qstr($v);
                                                        }
                                                }
                                                else if ($typ == 'double')
                                                        $sql .= str_replace(',','.',$v); // locales fix so 1.1 does not get converted to 1,1
                                                else if ($typ == 'boolean')
                                                        $sql .= $v ? $this->true : $this->false;
                                                else if ($typ == 'object') {
                                                        if (method_exists($v, '__toString')) $sql .= $this->qstr($v->__toString());
                                                        else $sql .= "'".(string)$v."'";//$this->qstr((string) $v);
                                                } else if ($v === null)
                                                        $sql .= 'NULL';
                                                else
                                                        $sql .= $v;
                                                $i += 1;

                                                if ($i == $nparams) break;
                                        } // while
                                        if (isset($sqlarr[$i])) {
                                                $sql .= $sqlarr[$i];
                                                //if ($i+1 != sizeof($sqlarr)) $this->outp_throw( "Input Array does not match ?: ".htmlspecialchars($sql),'Execute');
                                        } else if ($i != sizeof($sqlarr)){
                                                //$this->outp_throw( "Input array does not match ?: ".htmlspecialchars($sql),'Execute');
                                        }
                                        //$ret = $this->_Execute($sql);
                                        //if (!$ret) return $ret;
                                        return $sql;
                                }
                        } /*else {
                                if ($array_2d) {
                                        if (is_string($sql))
                                                $stmt = $this->Prepare($sql);
                                        else
                                                $stmt = $sql;

                                        foreach($inputarr as $arr) {
                                                $ret = $this->_Execute($stmt,$arr);
                                                if (!$ret) return $ret;
                                        }
                                } else {
                                        $ret = $this->_Execute($sql,$inputarr);
                                }
                        }*/
                }
                else {
                        //$ret = $this->_Execute($sql,false);
                }

                return $sql;//ret;
        }

function buscaProhibidos($txt, $adicional = false, $nocomas = false, $caracteres='TODOS') {
	$nivel_error = 	error_reporting();
	error_reporting(0);

	$PROHIBE = Array();
	array_push($PROHIBE, "SELECT");
	array_push($PROHIBE, "UPDATE");
	array_push($PROHIBE, "INSERT");
	array_push($PROHIBE, "DELETE");
	array_push($PROHIBE, "FROM");
	array_push($PROHIBE, "pg_tables");
	array_push($PROHIBE, "pg_namespace");
	array_push($PROHIBE, "pg_class");

	if($adicional === true) {
		array_push($PROHIBE, "WHERE");
		array_push($PROHIBE,  "'");
		array_push($PROHIBE, html_entity_decode('&#039;'));
		array_push($PROHIBE, html_entity_decode('&#034;'));
		array_push($PROHIBE, '"');
		array_push($PROHIBE, html_entity_decode('&#096;'));
		array_push($PROHIBE, '`');
		array_push($PROHIBE, 'chr(');
	}

	if($nocomas === true) {
		array_push($PROHIBE, ',');  // Validar que no existan coma
		array_push($PROHIBE, ';');  // Validar que no existan punto y coma
	}

	if($caracteres == 'NUMEROS') {
		$permitidos = "0123456789-";
	}
	else {
		$permitidos = "abcdefghijklmnñopqrstuvwxyzABCDEFGHIJKLMNÑOPQRSTUVWXYZ0123456789"
				. "-_,.()* "
				. "áéíóúÁÉÍÓÚüÜ" ;
	}

	$resultado = true;
	$txt2 = html_entity_decode($txt);
	$txt3 = htmlentities($txt, ENT_QUOTES, "UTF-8");

	for ($i=0; $i<strlen($txt); $i++){
		if (strpos($permitidos, substr($txt,$i,1))===false){
//echo substr($txt,$i,1);
//echo " - {$txt} -  {$i}";
			$resultado =  false;
			break;
		}
	}


    if ($resultado === true) {

    for($n=0; $n < count($PROHIBE); $n++) {
		if( ( stripos($txt, "{$PROHIBE[$n]}") === FALSE )
		AND ( stripos($txt, "{$PROHIBE[$n]} ") === FALSE )
		AND ( stripos($txt, "{$PROHIBE[$n]}(") === FALSE ) ) {
        			// No encontrado pal mas espacio
        			// No encontrado pal mas parentesis
        		}
        		else {
        			$resultado = false;
        			$n += count($PROHIBE);
					break;
        		}

		if( ( stripos($txt2, "{$PROHIBE[$n]}") === FALSE )
		AND ( stripos($txt2, "{$PROHIBE[$n]} ") === FALSE )
		AND ( stripos($txt2, "{$PROHIBE[$n]}(") === FALSE ) ) {
			// No encontrado pal mas espacio
			// No encontrado pal mas parentesis
		}
		else {
			$resultado = false;
			$n += count($PROHIBE);
			break;
		}

		if( ( stripos($txt3, "{$PROHIBE[$n]}") === FALSE )
		AND ( stripos($txt3, "{$PROHIBE[$n]} ") === FALSE )
		AND ( stripos($txt3, "{$PROHIBE[$n]}(") === FALSE ) ) {
			// No encontrado pal mas espacio
			// No encontrado pal mas parentesis
		}
		else {
			$resultado = false;
			$n += count($PROHIBE);
			break;
        	}

	} // FOR
    } // IF Resultado


	error_reporting($nivel_error);
	return $resultado;
}

function construyeSQL($campoBUS, $sBUS, $sBUS2, $campos, $pk, $tabla, $sFiltro, $nLIMIT, $pagACT, $nOFFSET, $orden, $TipoOrd, $bConsulta, $titulos, $SQL="", $dbi=0 ) {
        	/*	var P1 = ArraytoString(this.campoBUS, separador_col);
        	 var P2 = this.sBUS;
        	var P3 = this.sBUS2;
        	var P4 = this.campos;
        	var P5 = this.pk;
        	var P6 = this.tabla;
        	var P7 = this.sFiltro;
        	var P8 = this.nLIMIT;
        	var P9 = this.pagACT;
        	var P10 = this.nOFFSET;
        	var P11 = this.orden;
        	var P12 = this.TipoOrd;
        	var P13 = false;
        	var P14 = this.titulos;
        	*/
        	global $cnf;
        	$cadSQL_ = "";

/*        	if( !buscaProhibidos($campoBUS)
        			OR !buscaProhibidos($sBUS)
        			OR !buscaProhibidos($sBUS2)
        			OR !buscaProhibidos($campos)
        			OR !buscaProhibidos($pk)
        			OR !buscaProhibidos($tabla)
        			OR !buscaProhibidos($sFiltro)
        			OR !buscaProhibidos($nLIMIT)
        			OR !buscaProhibidos($pagACT)
        			OR !buscaProhibidos($nOFFSET)
        			OR !buscaProhibidos($orden)
        			OR !buscaProhibidos($TipoOrd)
        			OR !buscaProhibidos($bConsulta)
        			OR !buscaProhibidos($titulos) ) {
        		return "ERROR SQL"; // ERROR -- SQL injection
        	}
*/
        	$SQL = filtrarSQL($sFiltro);

        	//var_dump($sFiltro, $SQL);

	$campoBUS = explode(",", $campoBUS );

        	$orden_ = "";
        	$where_ = "";
        	$wPart2_ = "";
        	$buscado_ = "";

        	$sSQL = "";
	if(count($campoBUS) > 0 ) {$iCampoBuscar_ = true; } else { $iCampoBuscar_ = false; }
        	// construyendo el SELECT

        	// EG 2009-01-26
        	if($TipoOrd == "A") {$TipoOrd = "ASC";}
        	else if($TipoOrd == "D") {$TipoOrd = "DESC";}
			else if($TipoOrd == "ASC") {$TipoOrd = "ASC";}
			else if($TipoOrd == "DESC") {$TipoOrd = "DESC";}
        	else {$TipoOrd = "ASC";}

        	if (strlen(trim($SQLmanual)) > 0) {
        		$sSQL = trim($SQLmanual);
        	}
        	else
        	{
        		if($bConsulta == true)
        		{
        			if(trim($pk) != "")
        			{
        				$sSQL = "SELECT " . trim($campos) . "," . trim($pk) . " FROM " . trim($tabla) ;
        			}
        			else
        				$sSQL = "SELECT " . trim($campos) . " FROM " . trim($tabla);
        		}
        		else
        		{
        			$sSQL = "SELECT * FROM " . trim($tabla);
        		}
        	}

        	if(($bConsulta == "CBbd"))
        	{
        		$sSQL = "SELECT " . trim($campos) . " FROM " . trim($tabla);
        		if(trim($pk) != "") {
        			$sSQL = "SELECT " . trim($campos) . "," . trim($pk) . " FROM " . trim($tabla);
        		}

        		if(trim($titulos) != "") {
        			$sSQL = "SELECT " . trim($campos) . "," . trim($pk) . " FROM " . trim($tabla);
        		}

        		if((trim(this.pk) != "") && (trim($titulos) != "")) {
        			$sSQL = "SELECT " . trim($campos) . "," . trim($titulos) . "," . trim($pk) . " FROM " . trim($tabla);
        		}
        	}

        	//construye LIMIT OFFSET
        	$nOFFSET = ($nLIMIT * $pagACT) - $nLIMIT;
        	if($nOFFSET < 0 ) { $nOFFSET = 0; }
        	//construye ORDER BY
        	if ($orden == "")
        		$orden_ = "";
        	else
        		$orden_ = " ORDER BY " . $orden . " " . $TipoOrd;

        	//construyendo el WHERE
        	$where_ = trim($SQL);

	if (( strlen($where_) > 0) OR ( count($campoBUS) > 0)) {
        $wPart2_ = "";
        $buscado_ = "" . trim($sBUS);
		if($iCampoBuscar_ == true) {
			if ( strlen($buscado_) > 0 AND count($campoBUS) > 0 ) {
        		for($m=0; $m < count($campoBUS); $m++) {
//echo( $sBUS2 .'---');
        					if($wPart2_ != "" ) { $wPart2_ .= " OR "; }
        					if($sBUS2 == "%")
        					{
        						// PARTIMOS LA CADENA BUSCADA y enlazamos cada palabra con una OR
        						$aT_ = explode( ' ', $buscado_);
								for($n = 0; $n < count($aT_); $n++)
        						{
									// 20130410 - OLD
									//$wPart2_ .= "UPPER(" . $campoBUS[$m] . "::TEXT) LIKE UPPER('" . $sBUS2 . $aT_[$n] . $sBUS2 . "')" ;
									$wPart2_ .= "(" . $campoBUS[$m] . "::TEXT) ILIKE ('" . $sBUS2 . $aT_[$n] . $sBUS2 . "')" ;
        							if( $n<(count($aT_) - 1) )
        							{
        							$wPart2_ .= " OR ";
        							}
        						}
        					}
        					else
        					{
								//$wPart2_ .= "UPPER(" . $campoBUS[$m] . "::TEXT) LIKE UPPER('" . $buscado_ . "')" ;
								$wPart2_ .= "(" . $campoBUS[$m] . "::TEXT) ILIKE ('%" . $buscado_ . "%')" ;
        					}
        				}
        				$wPart2_ = "( " . $wPart2_ . " )";
        			}
        		}
        		else
        		{
        		$wPart2_ = "";
        	}

        	if(strlen($where_) > 0) {
        		if(strlen($wPart2_) > 0) {
        			$where_ .= " AND " . $wPart2_;
        		} else {
        			$where_ .= "";
        		}
        	}
        	else {
        		if(strlen($wPart2_) > 0) {
        			$where_ = $wPart2_;
        		} else {
        			$where_ = "";
        		}
        	}
        }
        else {
        	$where_ = "";
        }
        if (trim($where_) != "") {
        	if ( strpos($sSQL, "WHERE") === false ) {
        		$where_ = " WHERE " . $where_;
        	} else {
        		$where_ = " AND " . $where_;
        }
    } //END construyendo el WHERE

        			if($bConsulta == true)
        			{
        			$cadSQL_ = $sSQL . " " . $where_ . " " . $orden_;
        			if( $nLIMIT > 0 )
        			{
        			switch ( strtoupper($cnf["db"][$dbi]) )
        			{
        			case "POSTGRES":
        			$cadSQL_ .= " LIMIT " . $nLIMIT . " OFFSET " . $nOFFSET;
        			break;

        			case "MYSQL":
        			$cadSQL_ .= " LIMIT " . $nOFFSET . ", " . $nLIMIT;
        			break;
        			}
        			}
        			}
        					else
        					{
        						$cadSQL_ = $sSQL . " " . $where_;
        			}

return $cadSQL_;
}

function filtrarSQL($sFiltro) { // Filtra
        					// fSQL( "(,id_via,=,formatNumero);(AND,id_via,>=,);(,id_via,id_via,)" );
        					$cTxt = $sFiltro;
        						$aTxt = explode(';', trim($cTxt));
        						$aArr = Array();

        						$tam = 0; // Tamaño de la cadena 0
        								$cad = "";
        						$aT = null;
        						$conector = "";
        						$objeto = "";
        						$oT = false;
        						$oT2 = false;
        						$operador = "";
        						$n = 0;
        						$m = 0;

        						for($n=0; $n < count($aTxt); $n++)
        						{
        						// Limpia Espacios
        						$aTxt[$n] = trim($aTxt[$n]);

        						// Limpia Corchetes
        						$tam = strlen($aTxt[$n]);
        						if( ( substr($aTxt[$n], 0,1) == '(') && (substr($aTxt[$n], $tam-1, 1) == ')' ) ) {
        						$aTxt[$n] = substr($aTxt[$n], 1,$tam-2);
        						}

        						$aArr[$n]= explode(',', $aTxt[$n]) ;
        						}
        						// contar los argumentos, cada argumento sera un array de 4 o mayor
        						/*
        						 conector booleanos - sale de un array
        						id del campo
        						operandos booleanos - sale de un array - si no esta en la lista busquelo como id de campo
        						funcion JS para maquillar el valor antes de enviarlo
        						*/
        						$operadores = array();
        						$conectores = array();

        						$conectores[0] = "OR";
        						$conectores[1] = "AND";

        						$operadores[0] = ">";
        						$operadores[1] = "<";
        						$operadores[2] = ">=";
        						$operadores[3] = "=";
        						$operadores[4] = "!=";
        						$operadores[5] = "<=";
        						$operadores[6] = "LIKE";
        						$operadores[7] = "IN";
        						$operadores[8] = "IS";
        						$operadores[9] = "ISNULL";
        						$operadores[10] = "ISNOTNULL";
        						$operadores[11] = "PARENTESISABRIR";
        						$operadores[12] = "PARENTESISCERRAR";

        						//  verificando que todos los parametros sean array de tamano 4
        						/*
        						for($n=0; $n<aArr.length; n++)
        						{
        						if((typeof(aArr[n]) != "object") || (aArr[n].length != 4))
        						{
        						if( trim(cTxt) != "" )
        						{
        						msg_error("LDBJS\nTodos los parametros deben ser ARRAY de tamano 4\n" + aArr);
        						}
        						return(false);
        						}
        						}
        						*/

        						for($n=0; $n < count($aArr); $n++)
        						{
        						$aT = $aArr[$n];
        						$conector = "";
        						$objeto = "";
        						$oT = false;
        						$oT2 = false;
        						$operador = "";
        						$valor = "";
        						for($m=0; $m<count($conectores); $m++) { if($conectores[$m] == $aT[0]) {$conector = $conectores[$m]; } }
        						$valor = $aT[3];

        						for($m=0; $m<count($operadores); $m++) { if(trim($operadores[$m]) == trim($aT[2])) {$operador = $operadores[$m]; } }
        						if($n == 0) {$conector = "";} else {$conector = " " . $conector;}

        							// no se encontro el operador puede ser un Between
								if($operador == "") {
        								// Recibe un array de 5 parametros
        								if(count($aT) == 5) {
        							$operador = " BETWEEN '" . $valor . "' AND '" . $aT[4] . "'";
        							$cad .= $conector . " " .  $aT[1] . $operador;
        							}
        							else
        							{ return(false); }
        							}
        							else
        							{
        							if($operador == "ISNULL")
        							{
        									$cad .= $conector . " " . $aT[1] . " IS NULL ";
        							}
        							else if($operador == "ISNOTNULL")
        							{
        								$cad .= $conector . " " . $aT[1] . " IS NOT NULL ";
        							}
        									else if($operador == "IS")
        									{
        									$cad .= $conector . " " . $aT[1] . " " . $operador . " " . $aT[3];
        									}
        									else if($operador == "IN")
        									{
        									$oT2VAL_ = "";
        									for($b=3; $b < count($aT); $b++ ) {
        									if ($b > 3) { $oT2VAL_ .= ", "; }
								$oT2VAL_ .= trim($aT[$b]);
        									}
        									$cad .= $conector . " " .  $aT[1] . " " . $operador . " " . "(" . $oT2VAL_ . ")";
        									}
        											else if($operador == "PARENTESISABRIR")
        												{
        												$cad .= " ( ";
        												}
        												else if($operador == "PARENTESISCERRAR")
        												{
        													$cad .= " ) ";
        												}
        												else
        												{
        												if ($valor != "")
        												{
        												$oT2VAL_ = trim($valor);

        												if(strtoupper($oT2VAL_) == "TRUE")
        												{
        												$cad .= $conector . " " . $aT[1] . " " . $operador . " " . "TRUE";
        												}
        												else if(strtoupper($oT2VAL_) == "FALSE")
        						{
        												$cad .= $conector . " " .  $aT[1] . " " . $operador . " " . "FALSE";
        												}
									else if( gettype(_oT2VAL) == "string" )
									{
							$cad .= $conector . " " .  $aT[1] . " " . $operador . " " . "'". $oT2VAL_ . "'";
        						}
        					}
        				}
        			}
        		}

        		return $cad;
        	}

function ax_gen_limit_grid($modulo, $tabla, $pagenum=0, $pagesize=10, $nropaginas=0, $cuentaReg, $where) {
	// $modulo = $esquema
	//echo "$modulo, $tabla, $pagenum, $pagesize, $nropaginas, $cuentaReg, $where\n\n";
	/* 14-01-16 Esta validacion adicional al default en la definicion se hizo para evitar el bug de enviar la consulta inicial sin LIMIT */
	if(gettype($pagenum) == "NULL") { $pagenum = 0; }
	if(gettype($pagesize) == "NULL") { $pagesize = 10; }
	if(gettype($nropaginas) == "NULL") { $nropaginas= 0; }

	global $cnf;
	global $db;

	$pager_grid = array();

	$conn  = conectar_db7(true, "", "", 0);

	// Actualiza el conteo en la ultima pagina //
	if($pagenum >= ($nropaginas-1)) { $cuentaReg = "ACTUALIZA"; }

	if( $where != "" ) {
		// conteo real por filtros $where
// 20140930 - xButil - Se remueven las siguientes líneas por error
//		if(isset($cnf['dbschema']) AND $cnf['dbschema'] === true) {
//			$table_name = "{$modulo}.{$tabla}";
//		}
//		else {
//			$table_name = "{$modulo}_{$tabla}";
//		}
		if (trim($modulo) != "") {
			$table_name = "{$modulo}.{$tabla}";
		}
		else {
			$table_name = "{$tabla}";
		}

		$accion_sql = "contar";
		$ssql = repare_ADOdbSQL(
			"SELECT COUNT(*) AS cant_registros FROM {$table_name} ?"
			, Array( "{$where}" )
			, true
		);
		$resultado = $db->Execute($ssql);

		if ($resultado == false) {
			// $db->ErrorNo()    $db->ErrorMsg()
			$pager_grid["error"] = "No se pudo {$err_txt} los registros de {$modulo} {$tabla}, {$db->ErrorMsg()}";
			$pager_grid["aborto_proc"] = true;
			$pager_grid['sql'] = $ssql;
		}
		else {
			$data = $resultado->GetRows();
			$pager_grid["cantReg"] = $data[0]['cant_registros'];
			$pager_grid["aborto_proc"] = false;
		}

//		if(!isset($pagenum)) { $pagenum = 0; }
	}
	else { //if(!isset($pagenum) OR ($pagenum >= ($nropaginas-1)))

		$accion_sql = "contar";
		$ssql = repare_ADOdbSQL("SELECT nro_registros FROM xcm_cant_registros('?', '?', '?'); "
			//sql_tial_util('cuenta_registros')
			, Array( $modulo, $tabla, $cuentaReg )
			, true
		);
		$resultado = $db->Execute($ssql);

		if ($resultado == false) {
			// $db->ErrorNo()    $db->ErrorMsg()
			$pager_grid["error"] = "No se pudo {$err_txt} los registros de {$modulo} {$tabla}, {$db->ErrorMsg()}";
			$pager_grid["aborto_proc"] = true;
			$pager_grid['sql'] = $ssql;
		}
		else {
			$data = $resultado->GetRows();
//			$pagenum = 0;
			$pager_grid["cantReg"] = $data[0]['nro_registros'];
			$pager_grid["aborto_proc"] = false;
		}
	}

	if($pager_grid["aborto_proc"] == false) {
		if ($pagesize > 0){
			$corrimientopaginas = $pagenum*$pagesize;
			$pager_grid["limit"] = " LIMIT {$pagesize} OFFSET {$corrimientopaginas} ";
		}
	}
	return $pager_grid;
}

function ax_gen_order_grid($ordencampo = "", $ordentipo = "", $nom_campos = array(), $nom_camposAS = array()) {
	$order_grid = "";
	if(trim($ordencampo) != "") {
		// Ordenar por columna //
		// Se necesita este switch por que se uso AS en la consulta, se requieren los nombres de los campos //
		// switch($ordencampo) {
		// 	case 'id': { $ordencampo = 'cons_centro_correo'; } break;
		// 	case 'reloj': { $ordencampo = 'cons_reloj'; } break;
		// 	case 'dest': { $ordencampo = 'maq_nom_dest'; } break;
		// 	case 'ciudad': { $ordencampo = 'nom_ciudad_dest'; } break;
		// }
		if(strtolower($ordentipo) == 'asc') { $ordentipo = "ASC"; } else { $ordentipo = "DESC"; }
		$order_grid .= " ORDER BY {$ordencampo} {$ordentipo} ";
	}
	return $order_grid;
}

function ax_gen_where_grid($filtros, $where = "", $nom_campos = array(), $nom_camposAS = array()) {
	$where_grid = "";

	$filterscount = count($filtros);
	if( $filterscount > 0) {
		if (trim($where) != "") {
			$where = " WHERE {$where} AND ( ";
		}
		else {
			$where = " WHERE ( ";
		}

		$tmpdatafield = "";
		$tmpfilteroperator = "";
		for ($i=0; $i < $filterscount; $i++) {
				// get the filter's value.
				$filtervalue = $filtros[$i][3];
				// get the filter's condition.
				$filtercondition = $filtros[$i][2];
				// get the filter's column.
				$filterdatafield = $filtros[$i][1];

				// Se debe programar si tiene campos AS en el query
				// switch($filterdatafield) {
				// 	case 'id': { $filterdatafield = 'cons_centro_correo'; } break;
				// 	case 'reloj': { $filterdatafield = 'cons_reloj'; } break;
				// 	case 'dest': { $filterdatafield = 'maq_nom_dest'; } break;
				// 	case 'ciudad': { $filterdatafield = 'nom_ciudad_dest'; } break;
				// }

				// get the filter's operator.
				$filteroperator = $filtros[$i][0];

				if ($tmpdatafield == "")
				{
					$tmpdatafield = $filterdatafield;
				}
				else if ($tmpdatafield <> $filterdatafield)
				{
					$where .= ")AND(";
				}
				else if ($tmpdatafield == $filterdatafield)
				{
					if ($tmpfilteroperator == 0)
					{
						$where .= " AND ";
					}
					else $where .= " OR ";
				}

				// build the "WHERE" clause depending on the filter's condition, value and datafield.
	        	switch($filtercondition)
				{
					case "NOT_EMPTY":
					case "NOT_NULL":
						$where .= " " . $filterdatafield . " IS NOT NULL";
						break;
					case "EMPTY":
					case "NULL":
						$where .= " " . $filterdatafield . " IS NULL";
						break;
					case "CONTAINS_CASE_SENSITIVE":
						$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
						break;
					case "CONTAINS":
						$where .= " " . $filterdatafield . " ILIKE '%" . $filtervalue ."%'";
						break;
					case "DOES_NOT_CONTAIN_CASE_SENSITIVE":
						$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
						break;
					case "DOES_NOT_CONTAIN":
						$where .= " " . $filterdatafield . " NOT ILIKE '%" . $filtervalue ."%'";
						break;
					case "EQUAL_CASE_SENSITIVE":
						$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
						break;
					case "EQUAL":
						$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
						break;
					case "NOT_EQUAL_CASE_SENSITIVE":
						$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
						break;
					case "NOT_EQUAL":
						$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
						break;
					case "GREATER_THAN":
						$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
						break;
					case "LESS_THAN":
						$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
						break;
					case "GREATER_THAN_OR_EQUAL":
						$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
						break;
					case "LESS_THAN_OR_EQUAL":
						$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
						break;
					case "STARTS_WITH_CASE_SENSITIVE":
						$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
						break;
					case "STARTS_WITH":
						$where .= " " . $filterdatafield . " ILIKE '" . $filtervalue ."%'";
						break;
					case "ENDS_WITH_CASE_SENSITIVE":
						$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
						break;
					case "ENDS_WITH":
						$where .= " " . $filterdatafield . " ILIKE '%" . $filtervalue ."'";
						break;
				}

				if ($i == $filterscount - 1)
				{
					$where .= ")";
				}

				$tmpfilteroperator = $filteroperator;
				$tmpdatafield = $filterdatafield;
			}

		$where_grid .= " {$where} ";
	}
	else {
		if (trim($where) != "") {
			$where_grid.= " WHERE ( {$where} ) ";
		}
	}

	return $where_grid;
}

function axDataGrid($axdata) {

	//pagenum, $pagesize=0, $nropaginas=0, $ordencampo, $ordentipo, $filtros, $cuentaReg ='CONSULTA'
	// Parámetros de la funcion
	// $axdata["esquema"]	=
	//	$axData["tabla"]    	= "xcm_usuarios_v1"; //Nombre de la tabla, vista o función que retorna registros
	//	$axData["columnas"] 	= "*";
	//	$axData["condicion"]	= "";
	// o (Excluyente)
	// $axdata["sql"] 		= Query SQL NOTA: No debe tener las instrucciones ORDER, ni LIMIT, sin (;) punto y coma al final
	//								Ej.: "SELECT * FROM nom_tabla"

	$filtros = array();
	for($n=0; $n<$_POST['filterscount']; $n++) {
		$opera 		= $_POST["filteroperator{$n}"];
		$campo 		= $_POST["filterdatafield{$n}"];
		$condicion	= $_POST["filtercondition{$n}"];
		$valor 		= $_POST["filtervalue{$n}"];
		array_push($filtros, [ $opera, $campo, $condicion, $valor ] );
	}

	$pagenum 	= $_POST['pagenum'];
 	$pagesize	= $_POST['pagesize'];
 	$nropaginas	= $_POST['nro_paginas'];
 	$ordencampo	= $_POST['sortdatafield'];
 	$ordentipo	= $_POST['sortorder'];
 	$cuentaReg 	= isset($_POST['cuenta'])?$_POST['cuenta']:'CONSULTA';

 	global $cnf;
	global $db;
	$aborto_proc = false;
	$sdata = array(); // array de retorno
	$data = array();	// array de datos de la DB
	$sql0 = "";
	$cantReg = -1;
	$login = "'{$_SESSION['login']}'";
	$grupo = "'{$cnf['grupo_activo']}'";

	if (isset($cnf['dbschema']) AND $cnf['dbschema'] === true) {
		if (isset($axdata["esquema"])) {
			$table_name = "{$axdata["esquema"]}.{$axdata["tabla"]}";
			$modulo = $axdata["esquema"];
			$tabla  = $axdata["tabla"];
		}
		else if (strpos($axdata["tabla"], ".") !== false) {
			$table_name = $axdata["tabla"];
			$modulo = substr($axdata["tabla"], 0, strpos($axdata["tabla"], "."));
			$tabla  = substr($axdata["tabla"], strpos($axdata["tabla"], ".")+1);
		}
		else {
			$table_name = $axdata["tabla"];
			$modulo = "";
			$tabla  = $axdata["tabla"];
		}
	}
	else {
		$table_name = $axdata["tabla"];
		$modulo = "";
		$tabla  = $axdata["tabla"];
	}

	$_where = ax_gen_where_grid($filtros, $axdata["condicion"]);
	$_order = ax_gen_order_grid($ordencampo, $ordentipo);
	//$_pager = ax_gen_limit_grid("xcm", "usuarios_v1", $pagenum, $pagesize, $nropaginas, $cuentaReg, $_where);
	//$_pager = ax_gen_limit_grid("public", "xcm_usuarios_v1", $pagenum, $pagesize, $nropaginas, $cuentaReg, $_where);
	$_pager = ax_gen_limit_grid($modulo, $tabla, $pagenum, $pagesize, $nropaginas, $cuentaReg, $_where);

	$aborto_proc = $_pager["aborto_proc"];
	$cantReg     = $_pager["cantReg"];
	$error       = $_pager["error"];
	$ssql        = $_pager["sql"];
	$_limit      = $_pager["limit"];

	$sql0 = $_where.$_order.$_limit;

	// Conectar con la DB
	$conn  = conectar_db7(true, "", "", 0);

	// Ejecutar Query
	$accion = "consultar";

	if (!isset($axdata['sql'])) {
		$axdata['sql'] = "SELECT {$axdata["columnas"]} FROM {$table_name}";
	}

	$ssql = repare_ADOdbSQL("{$axdata['sql']} ?;"
									, array( $sql0 )
									, true
									);
	$resultado = $db->Execute($ssql);

	// Validar el resultado de la conexión
	if ($resultado == false) {
		// $db->ErrorNo()    $db->ErrorMsg()
		$error = "No se logró {$err_txt} los datos del sistema, {$db->ErrorMsg()}";
		$aborto_proc = true;
		$sqlE = $ssql;

		$sdata['error'] = $error;
		$sdata['sql'] = $sqlE;
	}
	else {
		$data = $resultado->GetRows();
	}

	// Finalización del Proceso
	if($aborto_proc == true) {
		$sdata['error'] = $error;
	} else {
		//$sdata['datos'] = Array( $data );
		$sdata['datos'] = $data;
		$sdata['cantReg']= $cantReg;
	}
	if($cnf["axys_debug"]) { $sdata['sql'] = $ssql; }

	$sdata['success'] = !$aborto_proc;
	$salida = array();
	$salida['data'] = $sdata;
	$sdata = json_encode($salida);
	header("Content-Type: application/json; charset=utf-8");
	header("Content-Size: " . strlen($sdata));
	echo($sdata);

}

// Parámetros de la funcion
// $axdata["esquema"]	=
//	$axData["tabla"]    	= "xcm_usuarios_v1"; //Nombre de la tabla, vista o función que retorna registros
//	$axData["columnas"] 	= "*";
//	$axData["condicion"]	= "";
// o (Excluyente)
// $axdata["sql"] 		= Query SQL NOTA: Puede contener las instrucciones ORDER, LIMIT, sin (;) punto y coma al final
//								Ej.: "SELECT * FROM nom_tabla ORDER BY nom_campo"
function axData($axdata) {
	//=== Bloque inicial INI
	global $cnf;
	global $db;
	$aborto_proc = false;
	$sdata = array();
	$error = "";
	$accion = "";
	$login_tx = "'{$cnf['login']}'";
	$grupo_activo = "'{$cnf['grupo_activo']}'";
	//=== Bloque inicial FIN

	if (isset($cnf['dbschema']) AND $cnf['dbschema'] === true) {
		if (isset($axdata["esquema"])) {
			$table_name = "{$axdata["esquema"]}.{$axdata["tabla"]}";
			$modulo = $axdata["esquema"];
			$tabla  = $axdata["tabla"];
		}
		else if (strpos($axdata["tabla"], ".") !== false) {
			$table_name = $axdata["tabla"];
			$modulo = substr($axdata["tabla"], 0, strpos($axdata["tabla"], "."));
			$tabla  = substr($axdata["tabla"], strpos($axdata["tabla"], ".")+1);
		}
		else {
			$table_name = $axdata["tabla"];
			$modulo = "";
			$tabla  = $axdata["tabla"];
		}
	}
	else {
		$table_name = $axdata["tabla"];
		$modulo = "";
		$tabla  = $axdata["tabla"];
	}

	// Conectar con la DB
	$conn  = conectar_db7(true, "", "", 0);
	// Ejecutar Query
	$condicion = "";
	$orden = "";
	if (!isset($axdata['sql'])) {
		$axdata['sql'] = "SELECT {$axdata["columnas"]} FROM {$table_name}";
		if ( trim($axdata["condicion"]) != '' ) {
			$condicion = "WHERE {$axdata["condicion"]}";
		}
		if (isset($axdata['orden']) and trim($axdata['orden']) != "") {
			$orden = "ORDER BY {$axdata["orden"]}";
		}
	}
	$sql = repare_ADOdbSQL("{$axdata['sql']} ? ?;"
									, array( $condicion, $orden )
									, true
									);
	$resultado = $db->Execute($sql);

	// Validar el resultado de la conexión
	if ($resultado == false) {
		$error = "No se logró consultar los datos del sistema";
		$aborto_proc = true;
	}
	else {
		$data = $resultado->GetRows();
}
	//=== Bloque final INI
	$sdata['datos'] = $data;
	$sdata['success'] = !$aborto_proc;
	if($error != "") {
		$sdata['error'] = $error;
	}
	if($cnf["axys_debug"]) {
		$sdata['sql'] = $sql;
		$sdata['error_sql_nro'] = $db->ErrorNo();
		$sdata['error_sql_txt'] = $db->ErrorMsg();
	}
	$sdata = json_encode(($sdata));
	header("Content-Type: application/json; charset=utf-8");
	header("Content-Size: " . strlen($sdata));
	echo($sdata);
	//=== Bloque final FIN
}

function axPostSQL($P) {
	//////////////////////////////////////////////////////////////////////////////
	// 1. Coloca NULL si el valor viene vacío para las bases de datos
	// 2. Ayuda para generar codigo de las variables de las funciones
	// 3. Si la variable recibida es array JS devuelve array PHP
	//	4. $_T ==> Almacena el tipo de dato de las variables
	//////////////////////////////////////////////////////////////////////////////
	global $cnf;
	if (is_null($P)) {
		$P = $_POST;
	}
	foreach($P as $nom_var => $val) {
		$_T["{$nom_var}"] = gettype($val);
		// Asegura el valor entre comillas
		if (is_numeric($val) or (gettype($val) == 'array')) {
			$_P["{$nom_var}"] = "'{$val}'"; //$val; 20141221 - Es mejor colocar todos los valores entre comillas para SQL
		}
		elseif (trim($val) == '' ) {
			$_P["{$nom_var}"] = "NULL";
		}
		else {
			$_P["{$nom_var}"] = "'{$val}'";
		}
		//$p .= "\$_POST['{$nom_var}'],";
		//$v .= "\${$nom_var},";
		//$r .= "{$nom_var} = {$val} <br/>";
	}
	$_P["ax_login_tx"] = isset($cnf['login'])?"'{$cnf['login']}'":"NULL";
	$_P["ax_grupo_activo"] = isset($cnf['grupo_activo'])?"'{$cnf['grupo_activo']}'":"NULL";
	// OJO - Revisar para activar Seguridad SQL
	/*if( !buscaProhibidos($esquema)
		or !buscaProhibidos($tabla)
		or !buscaProhibidos($columna) ) {

		$error= "SQL Invalido, posible Injection, solicitud cancelada.";
		$aborto_proc = true;
	}
	*/

	//echo $p."<br/>";
	//echo $v."<br/>";
	//echo $r."<br/>";
	return $_P;
}


?>
