<?php
global $cnf;
global $esqDB;

if( !is_array($esqDB) ) { $esqDB = array(); }

if (!array_key_exists('xcomun', $esqDB)) { $esqDB['xcomun'] = array(); }
if (!array_key_exists('xapito', $esqDB)) { $esqDB['xapito'] = array(); }
if (!array_key_exists('catalogos', $esqDB)) { $esqDB['catalogos'] = array(); }

if(isset($cnf['dbschema']) AND $cnf['dbschema'] === true) {
	$xap = "xapito.";
	$xcm = "xcomun.";
} else {
	$xap = "public.xap_";
	$xcm = "public.xcm_";
}

if( !isset($_SESSION) ) {
	$esqDB['login'] = $cnf["login"];
	$esqDB['grupo'] = "";
} else {
	if( isset($_SESSION['login']) ) {
		$esqDB['login'] = "'{$_SESSION['login']}'";
		if (!array_key_exists('grupo_activo', $_SESSION['cnf'])) { $esqDB['grupo'] = isset($cnf['grupo_activo'])?"{$cnf['grupo_activo']}":""; }
		else { $esqDB['grupo'] = "{$_SESSION['cnf']['grupo_activo']}"; }
	}
}

$esqDB['xapito']['acceso'] 				= "{$xap}acceso";

$esqDB['xcomun']['nuips'] 					= "{$xcm}nuips";
$esqDB['xcomun']['cnf_grupos_axys'] 	= "{$xcm}cnf_grupos_axys";
$esqDB['xcomun']['grupos'] 				= "{$xcm}grupos";
$esqDB['xcomun']['grupos_v1'] 			= "{$xcm}grupos_v1";
$esqDB['xcomun']['xcm_grupos_guardar'] = "{$xcm}grupos_guardar";

$esqDB['xcomun']['niveles_usuario'] 	= "{$xcm}niveles_usuario";
$esqDB['xcomun']['permisos'] 				= "{$xcm}permisos";
$esqDB['xcomun']['sesiones'] 				= "{$xcm}sesiones";
$esqDB['xcomun']['usuarios'] 				= "{$xcm}usuarios";
$esqDB['xcomun']['usuarios_grupos'] 	= "{$xcm}usuarios_grupos";
$esqDB['xcomun']['usuarios_grupos_v1'] = "{$xcm}usuarios_grupos_v1";
$esqDB['xcomun']['usuarios_permisos'] 	= "{$xcm}usuarios_permisos";
$esqDB['xcomun']['campos_db'] 			= "{$xcm}campos_db";
$esqDB['xcomun']['documentos_nv'] 		= "documentos_nv"; //"{$xcm}documentos_nv";
$esqDB['xcomun']['documentos'] 			= "{$xcm}documentos";
$esqDB['xcomun']['grupos_permisos'] 	= "{$xcm}grupos_permisos";

$esqDB['xcomun']['nuips_emails'] 		= "{$xcm}nuips_emails_v1";
$esqDB['xcomun']['usuarios_v1'] 			= "{$xcm}usuarios_v1";


$esqDB['xcomun']['campos_db'] 			= "{$xcm}campos_db";
$esqDB['xcomun']['campos_db_v1'] 		= "{$xcm}campos_db_v1";
$esqDB['xcomun']['addexporta'] 			= "{$xcm}addexporta";
$esqDB['xcomun']['removeexporta'] 		= "{$xcm}removeexporta";
$esqDB['xcomun']['upexporta'] 			= "{$xcm}upexporta";
$esqDB['xcomun']['downexporta'] 			= "{$xcm}downexporta";

$esqDB['xcomun']['adiciona_xcm_nuip'] 		= "adiciona_xcm_nuip";
$esqDB['xcomun']['xcm_usuarios_grupos']   = "{$xcm}usuarios_grupos";

//var_dump($esqDB);

function sql_cons_documentos($fun) {
 global $esqDB;
   switch($fun) {
      case '4': {
         return "SELECT number, string FROM {$esqDB['xcomun']['documentos_nv']}(?, ?, ?, ?); ";
      }
      break;
      case '5': {
         return "SELECT number, string, date FROM {$esqDB['xcomun']['documentos_nv']}(?, ?, ?, {$esqDB['grupo']}, ?); ";
      }
      break;
      case 'alterar': {
         return "UPDATE {$esqDB['xcomun']['documentos']} SET cons_doc=? WHERE id_doc=?; ";
      }
      break;
      case 'version': {
         return "v.110614.1";
      }
      break;
   }
}

function sql_xcm_usuarios($fun) {
	global $esqDB;
	switch($fun) {
		case 'verifica_login_con_nivel': {
		//, dm_cambia_passwd
	 	return "SELECT (login), id_nivel_usuario, cant_sesiones_max, cant_sesiones, is_activo, id_nuip_serial, id_nuip, dias_pasabordo, maq_nom_nuip
	         	FROM  {$esqDB['xcomun']['usuarios_v1']}
	         	WHERE login  = ? AND passwd = ? ; ";
	 	}
	 	break;
   	case 'verifica_login_sin_nivel': {
		//, dm_cambia_passwd
		return "SELECT (login), 2 AS id_nivel_usuario, cant_sesiones_max, cant_sesiones, is_activo, id_nuip_serial, id_nuip, dias_pasabordo, maq_nom_nuip
	         	FROM  {$esqDB['xcomun']['usuarios_v1']}
	         	WHERE login  = ? AND passwd = ? ; ";
		}
		break;
		case 'actualiza_sesiones': {
	 	return "UPDATE {$esqDB['xcomun']['usuarios']} SET cant_sesiones = ?
					WHERE login  = ?
					  AND passwd = ? ; ";
		}
		break;
		case 'inserta_usuario': {
		return "SELECT graba_xcm_usuario AS bresultado FROM graba_xcm_usuario(?::BIGINT, ?:: character varying, ?:: character varying, {$esqDB['login']}:: character varying); ";
		}
		break;
		//case 'actualiza_pasabordo': {
		//return "SELECT graba_xcm_usuario_pasabordo AS bresultado FROM graba_xcm_usuario_pasabordo(?, ?, ?); ";
		//}
		//break;
		case 'data_usuario': {
		return "SELECT id_nivel_usuario, id_nuip_serial, fec_creacion, is_activo, cant_sesiones_max, cant_sesiones, id_nuip, maq_nom_nuip
  					FROM xcm_usuarios_v1 WHERE login = ?; ";
		} break;
		case 'usuarios_v1': {
	    	return "SELECT *"
	    				. " FROM {$esqDB['xcomun']['usuarios_v1']} "
						. " ?; ";
		} break;

		case 'version': {return "130328.1";}
  }
}

function sql_xcm_sesiones($fun = 'default') {
	global $esqDB;
	switch($fun)
	{
		case 'default':
		{
		  return "SELECT login, fec_ingreso, ip, id_sesion
		  				FROM {$esqDB['xcomun']['sesiones']}
		  				WHERE login= ? ; ";
		}
		break;

		case 'guarda_login_semilla':
		{
		  return 'INSERT INTO public.xcm_sesiones ( "login", ip, semilla ) VALUES (?, ?, ?);';
		}
		break;

		case 'retorna_id_sesion':
		{
		  return "SELECT id_sesion
		  				FROM {$esqDB['xcomun']['sesiones']}
		  				WHERE login = ? AND ip = ? AND semilla = ? ; ";
		}
		break;

	}
}

function sql_xcm_usuariospermisos($fun = 'default') {
	global $esqDB;
	switch($fun)
	{
		case 'verifica':
		{
		  return "SELECT count(*) "
             ." FROM {$esqDB['xcomun']['usuarios_permisos']} "
             ." WHERE id_permiso = ? AND login = ?; ";
		}
		break;
		case 'datos_permiso':
			{
				return "SELECT nom_permiso, desc_permiso "
                    ." FROM {$esqDB['xcomun']['permisos']} "
                    ." WHERE id_permiso = ?; ";
		}
		break;
		case 'version': {
			return "v.121212.1";
		}
		break;
	}
}

function sql_xcm_grupos_permisos($fun = 'default') {
	global $esqDB;
	switch($fun)
	{
		case 'consulta':
		{
		  return "SELECT * "
             ." FROM {$esqDB['xcomun']['grupos_permisos']} "
             ." WHERE id_grupo = ?; ";
		}
		break;

/*		case 'consulta_arbol':
		{
		  return "SELECT p.id_permiso, id_padre, nom_permiso, CASE when id_grupo_permiso IS NOT NULL THEN true END AS is_permitido "
					." FROM  {$esqDB['xcomun']['permisos']} p "
					." 	LEFT JOIN {$esqDB['xcomun']['grupos_permisos']} gp ON p.id_permiso = gp.id_permiso AND gp.id_grupo = ? "
					." ORDER BY id_permiso;";

		}
		break;
*/
		case 'version': {
			return "v.20131227.1";
		}
		break;
	}
}

function sql_xcm_usuariosgrupos($fun = 'default') {
	global $esqDB;
	switch($fun)
	{
		case 'default':
		{
		  return "SELECT id_grupo, nom_grupo
		           FROM {$esqDB['xcomun']['usuarios_grupos_v1']}
		  		   WHERE login  = ?
		  		   ORDER BY nom_grupo; ";
		} break;
		case 'insertar_grupo': {
			return "SELECT v_resp "
					. " FROM {$esqDB['xcomun']['xcm_usuarios_grupos']}("
					. "?:: character varying, ?:: bigint, ?:: boolean"
					."); ";
		} break;
		case 'version': {
			return "130417.1";
		} break;
	}
}

function sql_xcm_grupos($fun = 'default') {
	global $esqDB;
	esqDB_login(); // $esqDB['login'] $esqDB['id_grupo_activo']
	switch($fun)
	{
		case 'default': {
		  return "SELECT nom_grupo
		               FROM {$esqDB['xcomun']['grupos']}
		               WHERE id_grupo IN (?)
		               ORDER BY nom_grupo; ";
		} break;
		case 'listado_sel': {
    		return "SELECT id_grupo, nom_grupo FROM {$esqDB['xcomun']['grupos']} "
			." ORDER BY nom_grupo; ";
		} break;
//		case 'guardar': {
//			return "SELECT vidgrupo"
//					." FROM {$esqDB['xcomun']['xcm_grupos_guardar']}(?::BIGINT, ?::CHARACTER VARYING, ?::BIGINT, ?::CHARACTER VARYING, ?::INTEGER)"	;
//	   } break;
//		case 'borrar': {
//			return "SELECT vidgrupo"
//					." FROM {$esqDB['xcomun']['xcm_grupos_guardar']}(?::BIGINT, ?::CHARACTER VARYING, ?::BIGINT, ?::CHARACTER VARYING, -1::INTEGER)"	;
//	   } break;
	   case 'carga_datos_1': {
	    	return "SELECT id_grupo, id_nuip_serial, nom_grupo, desc_grupo "
	    				. " FROM {$esqDB['xcomun']['grupos']} "
	    				. " WHERE nom_grupo = ?";
		} break;
		case 'grupos_v1': {
	    	return "SELECT *"
	    				. " FROM {$esqDB['xcomun']['grupos_v1']} "
						. " ?; ";
		} break;
		case 'version': { return "20131231.1"; } break;
	}
}

function sql_xcm_cnf_grupos($fun = 'default') {
	global $esqDB;
	switch($fun)
	{
		case 'borrar': {
		  return "DELETE FROM {$esqDB['xcomun']['cnf_grupos_axys']}
                 WHERE id_grupo = (?); ";
		}
		break;
		case 'guardar': {
		  return "INSERT INTO {$esqDB['xcomun']['cnf_grupos_axys']} (nom_cnf_axys, id_grupo, login_tx, vr_cnf_axys)
		  				VALUES (?,?,?,?); ";
		}
		break;
		case 'default': {
		  return "SELECT nom_cnf_axys, vr_cnf_axys
		  		   FROM {$esqDB['xcomun']['cnf_grupos_axys']}
                   WHERE id_grupo IN (?); ";
		}
		break;
	}
}

function sql_xcm_nuips($fun = 'version') {
	global $esqDB;
	switch($fun) {
		 case 'listado_sel_nombre': {
			return "SELECT id_nuip_serial, nom_nuip FROM xcm_nuips "
			." ORDER BY nom_nuip; ";
		} break;

		case 'lst_nuips': {
			return "SELECT id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, id_tipo_doc "
			." FROM xcm_nuips WHERE ? ?;";
		} break;

		case 'Sel_emails': {
			return "SELECT id_nuip_serial, id_nuip, nom_nuip, ape_nuip, email, id_nuip_email"
			. ", id_tipo_dir, nom_tipo_dir_es, abr_tipo_dir_es "
			. " FROM {$esqDB['xcomun']['nuips_emails']} WHERE id_nuip_serial = ?; ";
		} break;
		case 'adiciona_edita_nuip_basico': {
			/* PARAMETROS
			INOUT v_id_nuip_serial bigint
			, IN vid_tipo_doc integer
			, IN vid_tipo_nuip integer
			, IN vdigito_verif integer
			, IN vid_nuip character varying
			, IN vrazon_social character varying
			, IN vnom_contacto character varying
			, IN vnom_nuip character varying
			, IN vape_nuip character varying
			, IN vnotas text
			, IN vfec_nace timestamp without time zone
			, IN vid_sexo integer
			, IN vid_titulo_nuip integer
			, IN vlogin character varying
			*/
			return "SELECT v_id_nuip_serial "
							. " FROM {$esqDB['xcomun']['adiciona_xcm_nuip']}("
							. "?:: bigint, ?:: integer, ?:: integer, ?::integer"
							. ", ?:: character varying, ?:: character varying, NULL:: character varying"
							. ", ?:: character varying, ?:: character varying, NULL:: text, NULL:: timestamp without time zone, NULL:: integer, NULL:: integer, {$esqDB['login']}:: character varying "
							."); ";
				} break;
		case 'version': {
			return "v.130417.1";
		}
		break;
	}
}

function sql_xcm_campos_db($fun = 'default') {
	global $esqDB;
	switch($fun)
	{
		case 'add exportar': {
			return "SELECT v_res"
					." FROM {$esqDB['xcomun']['addexporta']}(?, ?, ?); ";
		} break;
		case 'remove exportar': {
			return "SELECT v_res"
					." FROM {$esqDB['xcomun']['removeexporta']}(?, ?, ?); ";
		} break;
		case 'down exportar': {
			return "SELECT v_res"
					." FROM {$esqDB['xcomun']['downexporta']}(?, ?, ?); ";
		} break;
		case 'up exportar': {
			return "SELECT v_res"
					." FROM {$esqDB['xcomun']['upexporta']}(?, ?, ?); ";
		} break;

		case 'default': {
		  	return "SELECT nom_campo, nom_esquema, nom_tabla, nom_columna, nom_campo_es, nom_fx_valida_js, desc_campo_es, desc_campo_en, is_nullable, nom_campo_en, orden, is_exporta"
		  		." FROM {$esqDB['xcomun']['campos_db_v1']} "
		  		." WHERE nom_esquema = (?) AND nom_tabla = (?); ";
		} break;
		case 'version': {
		  	return "v.130221.1";
		} break;
	}
}

///////////////////////////////////////////  Agregamos las funciones de SQL x Modulo
if( file_exists($_SERVER["DOCUMENT_ROOT"].$cnf["axys_path"].'/config/db/ax.sql_catalogos.db.php') ) {

	include_once($_SERVER["DOCUMENT_ROOT"].$cnf["axys_path"].'/config/db/ax.sql_catalogos.db.php');

}
// Funcion para recargar el login y el grupo en el esqDB
function esqDB_login() {
	global $cnf;
	global $esqDB;

	if($esqDB['login'] == "" OR $esqDB['id_grupo_activo'] == "") {
		if( !isset($_SESSION) ) {
			$esqDB['login'] = "''";
			$esqDB['id_grupo_activo'] = "";
		} else {
			$esqDB['login'] = "'{$_SESSION['login']}'";

			if (!array_key_exists('id_grupo_activo', $_SESSION['cnf'])) { $esqDB['id_grupo_activo'] = isset($cnf['id_grupo_activo'])?"{$cnf['id_grupo_activo']}":""; }
			else { $esqDB['id_grupo_activo'] = "{$_SESSION['cnf']['id_grupo_activo']}"; }
		}
	}

}
?>
