--
-- PostgreSQL database dump
--

-- Started on 2013-01-17 10:55:10 COT

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- TOC entry 2244 (class 1262 OID 420823)
-- Dependencies: 2243
-- Name: tial1301; Type: COMMENT; Schema: -; Owner: dbxdba
--

COMMENT ON DATABASE tial1301 IS 'v.130117.1';


--
-- TOC entry 687 (class 2612 OID 47146)
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: dbxdba
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO dbxdba;

SET search_path = public, pg_catalog;

--
-- TOC entry 221 (class 1255 OID 175557)
-- Dependencies: 687 3
-- Name: adiciona_xcm_nuip(bigint, integer, integer, integer, bigint, character varying, character varying, character varying, character varying, text, timestamp without time zone, integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION adiciona_xcm_nuip(INOUT v_id_nuip_serial bigint, vid_tipo_doc integer, vid_tipo_nuip integer, vdigito_verif integer, vid_nuip bigint, vrazon_social character varying, vnom_contacto character varying, vnom_nuip character varying, vape_nuip character varying, vnotas text, vfec_nace timestamp without time zone, vid_sexo integer, vid_titulo_nuip integer, vlogin character varying) RETURNS bigint
    LANGUAGE plpgsql
    AS $$DECLARE
 vins bigint;
BEGIN

	IF v_id_nuip_serial IS null THEN

		INSERT INTO xcm_nuips(
            id_nuip, digito_verif, id_tipo_nuip, nom_nuip,
            ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo,
            id_titulo_nuip, login_tx, fec_tx, id_tipo_doc)
    	VALUES (vid_nuip, vdigito_verif, vid_tipo_nuip, vnom_nuip,
            vape_nuip, vnom_contacto, vnotas, vfec_nace, vrazon_social, vid_sexo,
            vid_titulo_nuip, vlogin, NOW(), vid_tipo_doc) RETURNING id_nuip_serial INTO vins;
       v_id_nuip_serial := vins;
    ELSE
		UPDATE xcm_nuips
		   SET id_nuip_serial=v_id_nuip_serial, id_nuip=vid_nuip, digito_verif=vdigito_verif, id_tipo_nuip=vid_tipo_nuip,
		       nom_nuip=vnom_nuip, ape_nuip=vape_nuip, nom_contacto=vnom_contacto, notas=vnotas, fec_nacimiento=vfec_nace,
		       nom_empresa=vrazon_social, id_sexo=vid_sexo, id_titulo_nuip=vid_titulo_nuip, login_tx=vlogin, fec_tx=NOW(),
		       id_tipo_doc=vid_tipo_doc
		 WHERE id_nuip_serial = v_id_nuip_serial;
    END IF;
--RAISE NOTICE 'Ins: %', v_id_nuip_serial;
END;$$;


ALTER FUNCTION public.adiciona_xcm_nuip(INOUT v_id_nuip_serial bigint, vid_tipo_doc integer, vid_tipo_nuip integer, vdigito_verif integer, vid_nuip bigint, vrazon_social character varying, vnom_contacto character varying, vnom_nuip character varying, vape_nuip character varying, vnotas text, vfec_nace timestamp without time zone, vid_sexo integer, vid_titulo_nuip integer, vlogin character varying) OWNER TO dbxdba;

--
-- TOC entry 2247 (class 0 OID 0)
-- Dependencies: 221
-- Name: FUNCTION adiciona_xcm_nuip(INOUT v_id_nuip_serial bigint, vid_tipo_doc integer, vid_tipo_nuip integer, vdigito_verif integer, vid_nuip bigint, vrazon_social character varying, vnom_contacto character varying, vnom_nuip character varying, vape_nuip character varying, vnotas text, vfec_nace timestamp without time zone, vid_sexo integer, vid_titulo_nuip integer, vlogin character varying); Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON FUNCTION adiciona_xcm_nuip(INOUT v_id_nuip_serial bigint, vid_tipo_doc integer, vid_tipo_nuip integer, vdigito_verif integer, vid_nuip bigint, vrazon_social character varying, vnom_contacto character varying, vnom_nuip character varying, vape_nuip character varying, vnotas text, vfec_nace timestamp without time zone, vid_sexo integer, vid_titulo_nuip integer, vlogin character varying) IS 'Grabacion de Nuip
v.120914.1';


--
-- TOC entry 229 (class 1255 OID 175560)
-- Dependencies: 687 3
-- Name: adiciona_xcm_nuip_direccion(bigint, bigint, integer, text, bigint, bigint); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION adiciona_xcm_nuip_direccion(INOUT v_id_nuip_dir bigint, vid_nuip_serial bigint, vid_tipo_dir integer, vdir text, vid_municipio bigint, vid_zona_mun bigint) RETURNS bigint
    LANGUAGE plpgsql
    AS $$DECLARE
BEGIN

	IF v_id_nuip_dir IS null THEN

		INSERT INTO xcm_nuips_dirs(
            id_nuip_serial, id_tipo_dir, dir, id_municipio,
            fec_tx, id_zona_mun)
    	VALUES (vid_nuip_serial, vid_tipo_dir, vdir, vid_municipio,
            NOW(), vid_zona_mun) RETURNING id_nuip_dir INTO v_id_nuip_dir;

    ELSE

    	UPDATE xcm_nuips_dirs
   		SET id_nuip_serial=vid_nuip_serial, id_tipo_dir=vid_tipo_dir, dir=vdir, id_municipio=vid_municipio,
       		fec_tx=NOW(), id_zona_mun=vid_zona_mun
 		WHERE id_nuip_dir = v_id_nuip_dir;

	END IF;

END;$$;


ALTER FUNCTION public.adiciona_xcm_nuip_direccion(INOUT v_id_nuip_dir bigint, vid_nuip_serial bigint, vid_tipo_dir integer, vdir text, vid_municipio bigint, vid_zona_mun bigint) OWNER TO dbxdba;

--
-- TOC entry 2248 (class 0 OID 0)
-- Dependencies: 229
-- Name: FUNCTION adiciona_xcm_nuip_direccion(INOUT v_id_nuip_dir bigint, vid_nuip_serial bigint, vid_tipo_dir integer, vdir text, vid_municipio bigint, vid_zona_mun bigint); Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON FUNCTION adiciona_xcm_nuip_direccion(INOUT v_id_nuip_dir bigint, vid_nuip_serial bigint, vid_tipo_dir integer, vdir text, vid_municipio bigint, vid_zona_mun bigint) IS 'Grabacion de Direccion Nuip
v.120914.1';


--
-- TOC entry 230 (class 1255 OID 175559)
-- Dependencies: 3 687
-- Name: adiciona_xcm_nuip_telefono(bigint, bigint, integer, text); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION adiciona_xcm_nuip_telefono(INOUT v_id_nuip_tel bigint, vid_nuip_serial bigint, vid_tipo_tel integer, vtel text) RETURNS bigint
    LANGUAGE plpgsql
    AS $$DECLARE
BEGIN

	IF v_id_nuip_tel IS null THEN

		INSERT INTO xcm_nuips_tels(
            id_nuip_serial, id_tipo_tel, tel, fec_tx)
		VALUES (vid_nuip_serial, vid_tipo_tel, vtel, NOW()) RETURNING id_nuip_tel INTO v_id_nuip_tel;

    ELSE

    	UPDATE xcm_nuips_tels
  		 SET id_nuip_serial=vid_nuip_serial, id_tipo_tel=vid_tipo_tel, tel=vtel, fec_tx=NOW()
 		 WHERE id_nuip_tel = v_id_nuip_tel;

	END IF;

END;$$;


ALTER FUNCTION public.adiciona_xcm_nuip_telefono(INOUT v_id_nuip_tel bigint, vid_nuip_serial bigint, vid_tipo_tel integer, vtel text) OWNER TO dbxdba;

--
-- TOC entry 2249 (class 0 OID 0)
-- Dependencies: 230
-- Name: FUNCTION adiciona_xcm_nuip_telefono(INOUT v_id_nuip_tel bigint, vid_nuip_serial bigint, vid_tipo_tel integer, vtel text); Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON FUNCTION adiciona_xcm_nuip_telefono(INOUT v_id_nuip_tel bigint, vid_nuip_serial bigint, vid_tipo_tel integer, vtel text) IS 'Grabacion de Telefono Nuip
v.120914.1';


--
-- TOC entry 227 (class 1255 OID 175662)
-- Dependencies: 687 3
-- Name: busca_cnf_axys(character varying, bigint, character varying); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION busca_cnf_axys(INOUT v_nom_cnf_axys character varying, INOUT v_id_grupo bigint, INOUT v_login character varying, OUT v_vr_cnf_axys character varying) RETURNS SETOF record
    LANGUAGE plpgsql
    AS $$DECLARE
 vSQLw character varying;
 vCadSQL character varying;
BEGIN
vSQLw := '';

	IF(v_nom_cnf_axys IS NOT NULL) THEN
		vSQLw := vSQLw || 'nom_cnf_axys = ''' || v_nom_cnf_axys || '''';
	END IF;

	IF(v_id_grupo IS NOT NULL) THEN
		IF(vSQLw = '') THEN
			vSQLw := vSQLw || 'id_grupo = ''' || v_id_grupo || '''';
		ELSE
			vSQLw := vSQLw || ' AND id_grupo = ''' || v_id_grupo || '''';
		END IF;
	END IF;

	IF(v_login IS NOT NULL) THEN
		IF(vSQLw = '') THEN
			vSQLw := vSQLw || 'login = ''' || v_login || '''';
		ELSE
			vSQLw := vSQLw || ' AND login = ''' || v_login || '''';
		END IF;
	END IF;

		IF(vSQLw = '') THEN
			vCadSQL := 'SELECT nom_cnf_axys AS v_nom_cnf_axys, id_grupo AS v_id_grupo, login AS v_login, vr_cnf_axys AS v_vr_cnf_axys FROM xcm_cnf_grupos_axys; ';
		ELSE
			vCadSQL := 'SELECT nom_cnf_axys AS v_nom_cnf_axys, id_grupo AS v_id_grupo, login AS v_login, vr_cnf_axys AS v_vr_cnf_axys FROM xcm_cnf_grupos_axys WHERE ' || vSQLw;
		END IF;

	RETURN QUERY EXECUTE vCadSQL;

END;$$;


ALTER FUNCTION public.busca_cnf_axys(INOUT v_nom_cnf_axys character varying, INOUT v_id_grupo bigint, INOUT v_login character varying, OUT v_vr_cnf_axys character varying) OWNER TO dbxdba;

--
-- TOC entry 2250 (class 0 OID 0)
-- Dependencies: 227
-- Name: FUNCTION busca_cnf_axys(INOUT v_nom_cnf_axys character varying, INOUT v_id_grupo bigint, INOUT v_login character varying, OUT v_vr_cnf_axys character varying); Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON FUNCTION busca_cnf_axys(INOUT v_nom_cnf_axys character varying, INOUT v_id_grupo bigint, INOUT v_login character varying, OUT v_vr_cnf_axys character varying) IS 'Busca en xcm_cnf_grupos_axys, una variable nom_cnf_axys, para un id_grupo o login especifico
v.120917.1';


--
-- TOC entry 228 (class 1255 OID 167401)
-- Dependencies: 687 3
-- Name: graba_cnt_factura_m(bigint, date, bigint, bigint, character varying, character varying, character varying, character varying, bigint, character varying, character varying, bigint, text); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION graba_cnt_factura_m(v1 bigint, v2 date, v3 bigint, v4 bigint, v5 character varying, v6 character varying, v7 character varying, v8 character varying, v9 bigint, v10 character varying, INOUT v_pref_factura character varying, INOUT v_nro_factura bigint, v11 text) RETURNS record
    LANGUAGE plpgsql
    AS $_$DECLARE
 vRC record;
BEGIN

-- $id_sucrusal, $fec_factura, $id_nuip_serial, $id_nuip, $nom_nuip, $ape_nuip, $direccion, $telefono, $id_forma_pago, $login
--  nro_factura bigint NOT NULL,
--  pref_factura character varying NOT NULL,
--  id_est_factura bigint DEFAULT 1,
--  id_centro_costo bigint NOT NULL,
--  v1  id_sucursal bigint NOT NULL,
--  id_resol_factura bigint,
--  v2  fec_factura timestamp without time zone NOT NULL DEFAULT now(),
--  v3  id_nuip_serial bigint NOT NULL,
--  v9  id_forma_pago bigint NOT NULL,
--  razon_social character varying,
--  v5  nom_cliente character varying NOT NULL,
--  v6  ape_cliente character varying,
--  v4  nit_cliente bigint NOT NULL,
--  v7  dir_cliente character varying,
--  v8  tel_cliente character varying,
--  email_cliente character varying,
--  v10  login character varying(30) NOT NULL,
--  fec_tx timestamp without time zone NOT NULL DEFAULT now(),
--  v11 notas


-- buscamos generamos el consecutivo para la sucursal
-- Insertamos el Maestro de la factura
-- Actualizamos los detalles del usuario que no tengan asignado prefijo y nro de factura
-- Retornamos el prefijo y el nro de factura generado

IF(v_pref_factura ISNULL AND v_nro_factura ISNULL ) THEN

	 SELECT vpref, vnro, vid_resol_factura INTO vRC FROM genera_consecutivo_cnt_factura(v1);

	INSERT INTO cnt_facturas_m(
		    nro_factura, pref_factura, id_est_factura, id_centro_costo, id_sucursal,
		    id_resol_factura, fec_factura, id_nuip_serial, id_forma_pago,
		    razon_social, nom_cliente, ape_cliente, nit_cliente, dir_cliente,
		    tel_cliente, email_cliente, login, fec_tx, notas)
	    VALUES (vRC.vnro, vRC.vpref, 1, null, v1,
		    vRC.vid_resol_factura, v2, v3, v9,
		    null, v5, v6, v4, v7,
		    v8, null, v10, NOW(), v11);

	UPDATE cnt_facturas_d
	   SET pref_factura=vRC.vpref, nro_factura=vRC.vnro, fec_tx=NOW()
	WHERE login=v10 AND pref_factura IS NULL AND nro_factura IS NULL;

ELSE
 UPDATE cnt_facturas_m
   SET id_centro_costo=null,
       fec_factura=v2, id_nuip_serial=v3,
       id_forma_pago=v9, razon_social=null, nom_cliente=v5, ape_cliente=v6,
       nit_cliente=v4, dir_cliente=v7, tel_cliente=v8, email_cliente=null,
       login=v10, fec_tx=NOW(), notas=v11
 WHERE nro_factura=v_nro_factura AND pref_factura=v_pref_factura
 RETURNING pref_factura AS vpref, nro_factura AS vnro, id_resol_factura AS vid_resol_factura INTO vRC;

END IF;

v_pref_factura := vRC.vpref;
v_nro_factura := vRC.vnro;

end;$_$;


ALTER FUNCTION public.graba_cnt_factura_m(v1 bigint, v2 date, v3 bigint, v4 bigint, v5 character varying, v6 character varying, v7 character varying, v8 character varying, v9 bigint, v10 character varying, INOUT v_pref_factura character varying, INOUT v_nro_factura bigint, v11 text) OWNER TO dbxdba;

--
-- TOC entry 2251 (class 0 OID 0)
-- Dependencies: 228
-- Name: FUNCTION graba_cnt_factura_m(v1 bigint, v2 date, v3 bigint, v4 bigint, v5 character varying, v6 character varying, v7 character varying, v8 character varying, v9 bigint, v10 character varying, INOUT v_pref_factura character varying, INOUT v_nro_factura bigint, v11 text); Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON FUNCTION graba_cnt_factura_m(v1 bigint, v2 date, v3 bigint, v4 bigint, v5 character varying, v6 character varying, v7 character varying, v8 character varying, v9 bigint, v10 character varying, INOUT v_pref_factura character varying, INOUT v_nro_factura bigint, v11 text) IS 'Guardado del Maestro de Factura
v.120913.1';


--
-- TOC entry 231 (class 1255 OID 54479)
-- Dependencies: 687 3
-- Name: graba_xcm_usuario(bigint, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION graba_xcm_usuario(vidns bigint, vusuario character varying, vpasabordo character varying, vlogin character varying) RETURNS boolean
    LANGUAGE plpgsql
    AS $$DECLARE
 vaux BOOLEAN;
 vcont INT;
BEGIN
   vaux := FALSE;
   vcont := 0;

 IF vusuario IS NULL THEN
	RAISE EXCEPTION 'Falta Usuario';
	return FALSE;
 ELSEIF vpasabordo IS NULL THEN
	RAISE EXCEPTION 'Falta Pasabordo';
	return FALSE;
 ELSEIF vlogin IS NULL THEN
	RAISE EXCEPTION 'Falta login';
	return FALSE;
 ELSE
	SELECT COUNT(login) INTO vcont FROM xcm_usuarios WHERE login = vusuario AND id_nuip_serial = vidns;
	IF vcont > 0 THEN
		UPDATE xcm_usuarios
			SET "login"=vusuario, passwd=vpasabordo, id_nuip_serial=vidns, fec_tx=NOW()
		WHERE login = vusuario AND id_nuip_serial = vidns;
	ELSE
		SELECT COUNT(login) INTO vcont FROM xcm_usuarios WHERE login = vusuario;
		IF vcont > 0 THEN
			RAISE EXCEPTION 'El login esta en uso';
			RETURN FALSE;
		END IF;
		INSERT INTO xcm_usuarios(
			"login", passwd, id_nuip_serial, fec_creacion)
		VALUES (vusuario, vpasabordo, vidns, NOW());
	END IF;

	vaux := TRUE;
 END IF;
RETURN vaux;
END;$$;


ALTER FUNCTION public.graba_xcm_usuario(vidns bigint, vusuario character varying, vpasabordo character varying, vlogin character varying) OWNER TO dbxdba;

--
-- TOC entry 2252 (class 0 OID 0)
-- Dependencies: 231
-- Name: FUNCTION graba_xcm_usuario(vidns bigint, vusuario character varying, vpasabordo character varying, vlogin character varying); Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON FUNCTION graba_xcm_usuario(vidns bigint, vusuario character varying, vpasabordo character varying, vlogin character varying) IS 'v.121212.1';


--
-- TOC entry 232 (class 1255 OID 54517)
-- Dependencies: 687 3
-- Name: graba_xcm_usuario_pasabordo(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION graba_xcm_usuario_pasabordo(vlogin character varying, vpasabordoa character varying, vpasabordon character varying) RETURNS boolean
    LANGUAGE plpgsql
    AS $$DECLARE
 vaux BOOLEAN;
 vcont INT;
BEGIN
   vaux := FALSE;
   vcont := 0;

 IF vlogin IS NULL THEN
	RAISE EXCEPTION 'Falta Usuario';
	return FALSE;
 ELSEIF vpasabordoA IS NULL THEN
	RAISE EXCEPTION 'Falta Pasabordo actual';
	return FALSE;
 ELSEIF vpasabordoN IS NULL THEN
	RAISE EXCEPTION 'Falta Pasabordo nuevo';
	return FALSE;
 ELSE
	SELECT COUNT(login) INTO vcont FROM xcm_usuarios WHERE login = vlogin AND passwd = vpasabordoA;
-- xHacer dm_cambia_passwd debe quedar fija a 1 pasabordo Temporal
	IF vcont > 0 THEN
		UPDATE xcm_usuarios
			SET "login"=vlogin, passwd=vpasabordoN, fec_tx=NOW()
		WHERE login = vlogin AND passwd = vpasabordoA;
	ELSE
		RAISE EXCEPTION 'El Pasabordo Actual no es correcto.';
		RETURN FALSE;
	END IF;

	vaux := TRUE;
 END IF;
RETURN vaux;
END;$$;


ALTER FUNCTION public.graba_xcm_usuario_pasabordo(vlogin character varying, vpasabordoa character varying, vpasabordon character varying) OWNER TO dbxdba;

--
-- TOC entry 2253 (class 0 OID 0)
-- Dependencies: 232
-- Name: FUNCTION graba_xcm_usuario_pasabordo(vlogin character varying, vpasabordoa character varying, vpasabordon character varying); Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON FUNCTION graba_xcm_usuario_pasabordo(vlogin character varying, vpasabordoa character varying, vpasabordon character varying) IS 'v.121212.1';


--
-- TOC entry 225 (class 1255 OID 420714)
-- Dependencies: 3 687
-- Name: xcm_addexporta(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION xcm_addexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean) RETURNS boolean
    LANGUAGE plpgsql
    AS $$DECLARE
 tPos INTEGER;
BEGIN
	-- Seleccionamos el mayor valor de orden de la tabla campos_db
SELECT coalesce(MAX(orden)+1, 1) INTO tPos
  FROM xcm_campos_db
  WHERE is_exporta = true AND nom_esquema = vesquema ANd nom_tabla = vtabla;

-- RAISE NOTICE '% ', tPos;

-- Actualizamos campo.tabla.esquema
UPDATE xcm_campos_db
   SET orden=tPos, is_exporta=TRUE
 WHERE nom_esquema=vesquema AND nom_tabla=vtabla AND nom_columna=vcampo;


v_res := true;
--RAISE NOTICE 'Ins: %', vesquema;
END;$$;


ALTER FUNCTION public.xcm_addexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean) OWNER TO dbxdba;

--
-- TOC entry 2254 (class 0 OID 0)
-- Dependencies: 225
-- Name: FUNCTION xcm_addexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean); Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON FUNCTION xcm_addexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean) IS 'Adiciona al listado apra Exportar CSV
v.121217.1';


--
-- TOC entry 222 (class 1255 OID 420715)
-- Dependencies: 687 3
-- Name: xcm_downexporta(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION xcm_downexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean) RETURNS boolean
    LANGUAGE plpgsql
    AS $$DECLARE
  vorden_actual INTEGER;
  vmax INTEGER;
BEGIN

SELECT orden INTO vorden_actual
 FROM  xcm_campos_db
 WHERE nom_esquema=vesquema
   AND nom_tabla=vtabla
   AND nom_columna=vcampo;

SELECT max(orden) INTO vmax
 FROM  xcm_campos_db
 WHERE nom_esquema=vesquema
   AND nom_tabla=vtabla;

IF vorden_actual < vmax THEN

-- Actualizamos orden.tabla.esquema
UPDATE xcm_campos_db
   SET orden = orden-1
 WHERE nom_esquema=vesquema
   AND nom_tabla=vtabla
   AND orden=vorden_actual+1;

-- Actualizamos campo.tabla.esquema
UPDATE xcm_campos_db
   SET orden=vorden_actual+1
 WHERE nom_esquema=vesquema AND nom_tabla=vtabla AND nom_columna=vcampo;

END IF;

v_res := true;
--RAISE NOTICE 'Ins: %', vesquema;
END;$$;


ALTER FUNCTION public.xcm_downexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean) OWNER TO dbxdba;

--
-- TOC entry 2255 (class 0 OID 0)
-- Dependencies: 222
-- Name: FUNCTION xcm_downexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean); Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON FUNCTION xcm_downexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean) IS 'Mueve para arriba del listado para Exportar CSV
v.121217.1';


--
-- TOC entry 226 (class 1255 OID 420713)
-- Dependencies: 687 3
-- Name: xcm_fix_campos_db(character varying); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION xcm_fix_campos_db(character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$DECLARE
  v_nom_esquema ALIAS FOR $1;
  v_return      INTEGER;
  v_row         RECORD;
  v_aux         INTEGER;
BEGIN
  v_return := 0;
  FOR v_row IN
    SELECT a.table_schema, a.table_name, a.column_name,
           CASE WHEN a.udt_name LIKE 'int%'     THEN 'esEntero'
                      WHEN a.udt_name LIKE 'float%'   THEN 'esNumero'
                      --WHEN a.udt_name LIKE 'timesta%' THEN 'esFecha'
                      ELSE 'noValidar'
                 END::varchar AS nom_fx_valida_js,
                 CASE WHEN a.is_nullable::TEXT = 'YES'::TEXT THEN 'true'::BOOL
                ELSE 'false'::BOOL
           END AS is_nullable
     FROM  information_schema.columns a, information_schema.tables b
     WHERE a.table_catalog =  b.table_catalog
       AND a.table_schema  =  b.table_schema
       AND a.table_name    =  b.table_name
       AND (LOWER(b.table_type)    =  'base table'
            OR LOWER(b.table_type) =  'view')
       AND LOWER(a.table_schema)   =  LOWER(v_nom_esquema)
       --AND LOWER(a.table_name)     <> 'campos_db'
  LOOP
    SELECT COUNT(*) INTO v_aux
     FROM  xcm_campos_db
     WHERE nom_esquema||'.'||nom_tabla||'.'||nom_columna = v_row.table_schema||'.'||v_row.table_name||'.'||v_row.column_name;
    IF (v_aux > 0) THEN
      UPDATE xcm_campos_db
       SET   nom_fx_valida_js = v_row.nom_fx_valida_js,
             is_nullable      = v_row.is_nullable
       WHERE nom_esquema||'.'||nom_tabla||'.'||nom_columna = v_row.table_schema||'.'||v_row.table_name||'.'||v_row.column_name;
      v_return := v_return + 1;
    ELSE
      INSERT INTO xcm_campos_db (nom_esquema        , nom_tabla       , nom_columna      , nom_fx_valida_js      , is_nullable      )
                  VALUES          (v_row.table_schema, v_row.table_name, v_row.column_name, v_row.nom_fx_valida_js, v_row.is_nullable);
      v_return := v_return + 1;
    END IF;
  END LOOP;
  --====================================================
  --   Faltan borrar los registros de tablas viejas
  --====================================================
  RETURN v_return;
END;
$_$;


ALTER FUNCTION public.xcm_fix_campos_db(character varying) OWNER TO dbxdba;

--
-- TOC entry 223 (class 1255 OID 420716)
-- Dependencies: 687 3
-- Name: xcm_removeexporta(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION xcm_removeexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean) RETURNS boolean
    LANGUAGE plpgsql
    AS $$DECLARE
  vorden_actual INTEGER;
BEGIN

SELECT orden INTO vorden_actual
 FROM  xcm_campos_db
 WHERE nom_esquema=vesquema
   AND nom_tabla=vtabla
   AND nom_columna=vcampo;

-- Actualizamos orden.tabla.esquema
UPDATE xcm_campos_db
   SET orden = orden-1
 WHERE orden > vorden_actual
   AND nom_esquema=vesquema
   AND nom_tabla=vtabla;

-- Actualizamos campo.tabla.esquema
UPDATE xcm_campos_db
   SET orden=0, is_exporta=FALSE
 WHERE nom_esquema=vesquema AND nom_tabla=vtabla AND nom_columna=vcampo;

v_res := true;
--RAISE NOTICE 'Ins: %', vesquema;
END;$$;


ALTER FUNCTION public.xcm_removeexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean) OWNER TO dbxdba;

--
-- TOC entry 2256 (class 0 OID 0)
-- Dependencies: 223
-- Name: FUNCTION xcm_removeexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean); Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON FUNCTION xcm_removeexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean) IS 'Remueve del listado para Exportar CSV
v.121217.1';


--
-- TOC entry 224 (class 1255 OID 420717)
-- Dependencies: 3 687
-- Name: xcm_upexporta(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: dbxdba
--

CREATE FUNCTION xcm_upexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean) RETURNS boolean
    LANGUAGE plpgsql
    AS $$DECLARE
  vorden_actual INTEGER;
BEGIN

SELECT orden INTO vorden_actual
 FROM  xcm_campos_db
 WHERE nom_esquema=vesquema
   AND nom_tabla=vtabla
   AND nom_columna=vcampo;

IF vorden_actual > 1 THEN

-- Actualizamos orden.tabla.esquema
UPDATE xcm_campos_db
   SET orden = orden+1
 WHERE nom_esquema=vesquema
   AND nom_tabla=vtabla
   AND orden=vorden_actual-1;

-- Actualizamos campo.tabla.esquema
UPDATE xcm_campos_db
   SET orden=vorden_actual-1
 WHERE nom_esquema=vesquema AND nom_tabla=vtabla AND nom_columna=vcampo;

END IF;

v_res := true;
--RAISE NOTICE 'Ins: %', vesquema;
END;$$;


ALTER FUNCTION public.xcm_upexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean) OWNER TO dbxdba;

--
-- TOC entry 2257 (class 0 OID 0)
-- Dependencies: 224
-- Name: FUNCTION xcm_upexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean); Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON FUNCTION xcm_upexporta(vesquema character varying, vtabla character varying, vcampo character varying, OUT v_res boolean) IS 'Mueve para arriba del listado para Exportar CSV
v.121217.1';


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 144 (class 1259 OID 47195)
-- Dependencies: 2031 2032 2033 3
-- Name: xcm_campos_db; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_campos_db (
    nom_esquema character varying NOT NULL,
    nom_tabla character varying NOT NULL,
    nom_columna character varying NOT NULL,
    nom_campo_es character varying,
    desc_campo_es character varying,
    nom_campo_en character varying,
    desc_campo_en character varying,
    nom_fx_valida_js character varying,
    is_nullable boolean DEFAULT false NOT NULL,
    orden integer DEFAULT 0 NOT NULL,
    is_exporta boolean DEFAULT false NOT NULL
);


ALTER TABLE public.xcm_campos_db OWNER TO dbxdba;

--
-- TOC entry 208 (class 1259 OID 420708)
-- Dependencies: 1839 3
-- Name: xcm_campos_db_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_campos_db_v1 AS
    SELECT COALESCE(xcm_campos_db.nom_campo_es, xcm_campos_db.nom_columna) AS nom_campo, xcm_campos_db.nom_esquema, xcm_campos_db.nom_tabla, xcm_campos_db.nom_columna, xcm_campos_db.nom_campo_es, xcm_campos_db.nom_fx_valida_js, xcm_campos_db.desc_campo_es, xcm_campos_db.desc_campo_en, xcm_campos_db.is_nullable, xcm_campos_db.nom_campo_en, xcm_campos_db.orden, xcm_campos_db.is_exporta FROM xcm_campos_db;


ALTER TABLE public.xcm_campos_db_v1 OWNER TO dbxdba;

--
-- TOC entry 203 (class 1259 OID 175582)
-- Dependencies: 2087 2088 3
-- Name: xcm_cnf_axys; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_cnf_axys (
    id_cnf_axys integer NOT NULL,
    nom_cnf_axys character varying NOT NULL,
    desc_cnf_axys character varying,
    tipo_cnf_axys character varying DEFAULT 'TEXTO'::character varying,
    login character varying(30) NOT NULL,
    fec_tx timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.xcm_cnf_axys OWNER TO dbxdba;

--
-- TOC entry 2259 (class 0 OID 0)
-- Dependencies: 203
-- Name: TABLE xcm_cnf_axys; Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON TABLE xcm_cnf_axys IS 'Configuracion de AXYS
v.120917.1';


--
-- TOC entry 202 (class 1259 OID 175580)
-- Dependencies: 203 3
-- Name: xcm_cnf_axys_id_cnf_axys_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_cnf_axys_id_cnf_axys_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_cnf_axys_id_cnf_axys_seq OWNER TO dbxdba;

--
-- TOC entry 2260 (class 0 OID 0)
-- Dependencies: 202
-- Name: xcm_cnf_axys_id_cnf_axys_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbxdba
--

ALTER SEQUENCE xcm_cnf_axys_id_cnf_axys_seq OWNED BY xcm_cnf_axys.id_cnf_axys;


--
-- TOC entry 2261 (class 0 OID 0)
-- Dependencies: 202
-- Name: xcm_cnf_axys_id_cnf_axys_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_cnf_axys_id_cnf_axys_seq', 6, true);


SET default_with_oids = true;

--
-- TOC entry 205 (class 1259 OID 175616)
-- Dependencies: 2090 3
-- Name: xcm_cnf_grupos_axys; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_cnf_grupos_axys (
    id_cnf_grupo_axys bigint NOT NULL,
    nom_cnf_axys character varying NOT NULL,
    id_grupo bigint,
    login character varying(30),
    vr_cnf_axys character varying NOT NULL,
    fec_tx timestamp without time zone DEFAULT now() NOT NULL,
    login_tx character varying(30) NOT NULL
);


ALTER TABLE public.xcm_cnf_grupos_axys OWNER TO dbxdba;

--
-- TOC entry 2262 (class 0 OID 0)
-- Dependencies: 205
-- Name: TABLE xcm_cnf_grupos_axys; Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON TABLE xcm_cnf_grupos_axys IS 'Guarda la configuracion especifica para un grupo o un usuario especifico
v.120917.1';


--
-- TOC entry 204 (class 1259 OID 175614)
-- Dependencies: 205 3
-- Name: xcm_cnf_grupos_axys_id_cnf_grupo_axys_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_cnf_grupos_axys_id_cnf_grupo_axys_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_cnf_grupos_axys_id_cnf_grupo_axys_seq OWNER TO dbxdba;

--
-- TOC entry 2263 (class 0 OID 0)
-- Dependencies: 204
-- Name: xcm_cnf_grupos_axys_id_cnf_grupo_axys_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbxdba
--

ALTER SEQUENCE xcm_cnf_grupos_axys_id_cnf_grupo_axys_seq OWNED BY xcm_cnf_grupos_axys.id_cnf_grupo_axys;


--
-- TOC entry 2264 (class 0 OID 0)
-- Dependencies: 204
-- Name: xcm_cnf_grupos_axys_id_cnf_grupo_axys_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_cnf_grupos_axys_id_cnf_grupo_axys_seq', 5, true);


--
-- TOC entry 145 (class 1259 OID 47202)
-- Dependencies: 3
-- Name: xcm_db_departamentos_id_depto_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_departamentos_id_depto_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_departamentos_id_depto_seq OWNER TO dbxdba;

--
-- TOC entry 2265 (class 0 OID 0)
-- Dependencies: 145
-- Name: xcm_db_departamentos_id_depto_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_db_departamentos_id_depto_seq', 57, true);


SET default_with_oids = false;

--
-- TOC entry 146 (class 1259 OID 47204)
-- Dependencies: 2034 2035 3
-- Name: xcm_db_departamentos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_departamentos (
    id_depto bigint DEFAULT nextval('xcm_db_departamentos_id_depto_seq'::regclass) NOT NULL,
    id_pais bigint NOT NULL,
    cod_dane character varying(30),
    is_activo boolean DEFAULT true NOT NULL,
    orden_db integer,
    nom_depto_es character varying(30) NOT NULL,
    abr_depto_es character varying(8),
    nom_depto_en character varying(30),
    abr_depto_en character varying(8),
    nom_depto_de character varying(30),
    abr_depto_de character varying(8),
    nom_depto_fr character varying(30),
    abr_depto_fr character varying(8)
);


ALTER TABLE public.xcm_db_departamentos OWNER TO dbxdba;

--
-- TOC entry 2267 (class 0 OID 0)
-- Dependencies: 146
-- Name: TABLE xcm_db_departamentos; Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON TABLE xcm_db_departamentos IS 'Departamentos o Estado en Caso de Otros Paises.';


--
-- TOC entry 147 (class 1259 OID 47209)
-- Dependencies: 3
-- Name: xcm_db_municipios_id_municipio_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_municipios_id_municipio_seq
    START WITH 1118
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_municipios_id_municipio_seq OWNER TO dbxdba;

--
-- TOC entry 2269 (class 0 OID 0)
-- Dependencies: 147
-- Name: xcm_db_municipios_id_municipio_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_db_municipios_id_municipio_seq', 1344, true);


--
-- TOC entry 148 (class 1259 OID 47211)
-- Dependencies: 2036 2037 3
-- Name: xcm_db_municipios; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_municipios (
    id_municipio bigint DEFAULT nextval('xcm_db_municipios_id_municipio_seq'::regclass) NOT NULL,
    id_depto bigint NOT NULL,
    is_activo boolean DEFAULT true NOT NULL,
    is_capital_pais boolean,
    is_capital_depto boolean,
    orden_db integer,
    cod_dane character varying(30),
    nom_municipio_es character varying(30) NOT NULL,
    abr_municipio_es character varying(8),
    abr_municipio_fr character varying(8),
    nom_municipio_fr character varying(30),
    abr_municipio_de character varying(8),
    nom_municipio_de character varying(30),
    abr_municipio_en character varying(8),
    nom_municipio_en character varying(30)
);


ALTER TABLE public.xcm_db_municipios OWNER TO dbxdba;

--
-- TOC entry 149 (class 1259 OID 47216)
-- Dependencies: 3
-- Name: xcm_db_paises_id_pais_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_paises_id_pais_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_paises_id_pais_seq OWNER TO dbxdba;

--
-- TOC entry 2272 (class 0 OID 0)
-- Dependencies: 149
-- Name: xcm_db_paises_id_pais_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_db_paises_id_pais_seq', 244, true);


--
-- TOC entry 150 (class 1259 OID 47218)
-- Dependencies: 2038 2039 3
-- Name: xcm_db_paises; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_paises (
    id_pais bigint DEFAULT nextval('xcm_db_paises_id_pais_seq'::regclass) NOT NULL,
    orden_db integer,
    nom_pais_es character varying NOT NULL,
    abr_pais_es character varying,
    nom_pais_en character varying,
    abr_pais_en character varying,
    nom_pais_de character varying,
    abr_pais_de character varying,
    nom_pais_fr character varying,
    abr_pais_fr character(1),
    is_activo boolean DEFAULT true NOT NULL,
    cod_dane character varying
);


ALTER TABLE public.xcm_db_paises OWNER TO dbxdba;

--
-- TOC entry 151 (class 1259 OID 47226)
-- Dependencies: 3
-- Name: xcm_db_sexos_id_sexo_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_sexos_id_sexo_seq
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_sexos_id_sexo_seq OWNER TO dbxdba;

--
-- TOC entry 2275 (class 0 OID 0)
-- Dependencies: 151
-- Name: xcm_db_sexos_id_sexo_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_db_sexos_id_sexo_seq', 2, false);


--
-- TOC entry 152 (class 1259 OID 47228)
-- Dependencies: 2040 3
-- Name: xcm_db_sexos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_sexos (
    id_sexo integer DEFAULT nextval('xcm_db_sexos_id_sexo_seq'::regclass) NOT NULL,
    orden_db integer,
    nom_sexo_es character varying,
    abr_sexo_es character varying,
    nom_sexo_en character varying,
    abr_sexo_en character varying,
    nom_sexo_de character varying,
    abr_sexo_de character varying,
    nom_sexo_fr character varying,
    abr_sexo_fr character varying,
    is_activo boolean,
    cod_interno character varying
);


ALTER TABLE public.xcm_db_sexos OWNER TO dbxdba;

--
-- TOC entry 153 (class 1259 OID 47235)
-- Dependencies: 3
-- Name: xcm_tipos_dir_id_tipo_dir_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_tipos_dir_id_tipo_dir_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_tipos_dir_id_tipo_dir_seq OWNER TO dbxdba;

--
-- TOC entry 2278 (class 0 OID 0)
-- Dependencies: 153
-- Name: xcm_tipos_dir_id_tipo_dir_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_tipos_dir_id_tipo_dir_seq', 2, true);


--
-- TOC entry 154 (class 1259 OID 47237)
-- Dependencies: 2041 2042 3
-- Name: xcm_db_tipos_dir; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_tipos_dir (
    id_tipo_dir integer DEFAULT nextval('xcm_tipos_dir_id_tipo_dir_seq'::regclass) NOT NULL,
    orden_db integer,
    nom_tipo_dir_es character varying,
    abr_tipo_dir_es character varying,
    nom_tipo_dir_en character varying,
    abr_tipo_dir_en character varying,
    nom_tipo_dir_de character varying,
    abr_tipo_dir_de character varying,
    nom_tipo_dir_fr character varying,
    abr_tipo_dir_fr character varying,
    is_activo boolean DEFAULT true NOT NULL,
    cod_interno character varying
);


ALTER TABLE public.xcm_db_tipos_dir OWNER TO dbxdba;

--
-- TOC entry 199 (class 1259 OID 157930)
-- Dependencies: 2082 3
-- Name: xcm_db_tipos_docs; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_tipos_docs (
    id_tipo_doc integer NOT NULL,
    orden_db integer,
    nom_tipo_doc character varying NOT NULL,
    abr_tipo_doc character varying,
    is_activo boolean DEFAULT true NOT NULL,
    cod_dian character varying
);


ALTER TABLE public.xcm_db_tipos_docs OWNER TO dbxdba;

--
-- TOC entry 198 (class 1259 OID 157928)
-- Dependencies: 3 199
-- Name: xcm_db_tipos_docs_id_tipo_doc_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_tipos_docs_id_tipo_doc_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_tipos_docs_id_tipo_doc_seq OWNER TO dbxdba;

--
-- TOC entry 2282 (class 0 OID 0)
-- Dependencies: 198
-- Name: xcm_db_tipos_docs_id_tipo_doc_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbxdba
--

ALTER SEQUENCE xcm_db_tipos_docs_id_tipo_doc_seq OWNED BY xcm_db_tipos_docs.id_tipo_doc;


--
-- TOC entry 2283 (class 0 OID 0)
-- Dependencies: 198
-- Name: xcm_db_tipos_docs_id_tipo_doc_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_db_tipos_docs_id_tipo_doc_seq', 11, true);


--
-- TOC entry 155 (class 1259 OID 47245)
-- Dependencies: 3
-- Name: xcm_db_tipos_nuips_id_tipo_nuip_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_tipos_nuips_id_tipo_nuip_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_tipos_nuips_id_tipo_nuip_seq OWNER TO dbxdba;

--
-- TOC entry 2284 (class 0 OID 0)
-- Dependencies: 155
-- Name: xcm_db_tipos_nuips_id_tipo_nuip_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_db_tipos_nuips_id_tipo_nuip_seq', 7, true);


--
-- TOC entry 156 (class 1259 OID 47247)
-- Dependencies: 2043 2044 3
-- Name: xcm_db_tipos_nuips; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_tipos_nuips (
    id_tipo_nuip integer DEFAULT nextval('xcm_db_tipos_nuips_id_tipo_nuip_seq'::regclass) NOT NULL,
    orden_db integer,
    nom_tipo_nuip_es character varying NOT NULL,
    abr_tipo_nuip_es character varying,
    is_activo boolean DEFAULT true NOT NULL,
    cod_interno character varying
);


ALTER TABLE public.xcm_db_tipos_nuips OWNER TO dbxdba;

--
-- TOC entry 157 (class 1259 OID 47255)
-- Dependencies: 3
-- Name: xcm_db_tipos_tel_id_tipo_tel_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_tipos_tel_id_tipo_tel_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_tipos_tel_id_tipo_tel_seq OWNER TO dbxdba;

--
-- TOC entry 2287 (class 0 OID 0)
-- Dependencies: 157
-- Name: xcm_db_tipos_tel_id_tipo_tel_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_db_tipos_tel_id_tipo_tel_seq', 5, true);


--
-- TOC entry 158 (class 1259 OID 47257)
-- Dependencies: 2045 3
-- Name: xcm_db_tipos_tel; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_tipos_tel (
    id_tipo_tel integer DEFAULT nextval('xcm_db_tipos_tel_id_tipo_tel_seq'::regclass) NOT NULL,
    orden_db integer,
    nom_tipo_tel_es character varying,
    abr_tipo_tel_es character varying,
    nom_tipo_tel_en character varying,
    abr_tipo_tel_en character varying,
    nom_tipo_tel_de character varying,
    abr_tipo_tel_de character varying,
    nom_tipo_tel_fr character varying,
    abr_tipo_tel_fr character varying,
    is_activo boolean,
    cod_interno character varying
);


ALTER TABLE public.xcm_db_tipos_tel OWNER TO dbxdba;

--
-- TOC entry 159 (class 1259 OID 47264)
-- Dependencies: 3
-- Name: xcm_db_titulos_nuips_id_titulo_nuip_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_titulos_nuips_id_titulo_nuip_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_titulos_nuips_id_titulo_nuip_seq OWNER TO dbxdba;

--
-- TOC entry 2290 (class 0 OID 0)
-- Dependencies: 159
-- Name: xcm_db_titulos_nuips_id_titulo_nuip_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_db_titulos_nuips_id_titulo_nuip_seq', 5, true);


--
-- TOC entry 160 (class 1259 OID 47266)
-- Dependencies: 2046 3
-- Name: xcm_db_titulos_nuips; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_titulos_nuips (
    id_titulo_nuip integer DEFAULT nextval('xcm_db_titulos_nuips_id_titulo_nuip_seq'::regclass) NOT NULL,
    orden_db integer,
    nom_titulo_nuip_es character varying,
    abr_titulo_nuip_es character varying,
    nom_titulo_nuip_en character varying,
    abr_titulo_nuip_en character varying,
    nom_titulo_nuip_de character varying,
    abr_titulo_nuipo_de character varying,
    nom_titulo_nuip_fr character varying,
    abr_titulo_nuip_fr character varying,
    is_activo boolean,
    cod_interno character varying
);


ALTER TABLE public.xcm_db_titulos_nuips OWNER TO dbxdba;

--
-- TOC entry 186 (class 1259 OID 54277)
-- Dependencies: 2079 2080 3
-- Name: xcm_db_zonas_municipios; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_db_zonas_municipios (
    id_zona_mun integer NOT NULL,
    id_municipio bigint NOT NULL,
    nom_zona_mun character varying(250) NOT NULL,
    desc_zona_mun text,
    cod_interno character varying(12),
    is_activo boolean DEFAULT true NOT NULL,
    orden_db integer DEFAULT 0
);


ALTER TABLE public.xcm_db_zonas_municipios OWNER TO dbxdba;

--
-- TOC entry 2293 (class 0 OID 0)
-- Dependencies: 186
-- Name: TABLE xcm_db_zonas_municipios; Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON TABLE xcm_db_zonas_municipios IS 'Util para sectorizar clientes, vendedores, etc.';


--
-- TOC entry 187 (class 1259 OID 54285)
-- Dependencies: 186 3
-- Name: xcm_db_zonas_municipios_id_zona_mun_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_db_zonas_municipios_id_zona_mun_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_db_zonas_municipios_id_zona_mun_seq OWNER TO dbxdba;

--
-- TOC entry 2294 (class 0 OID 0)
-- Dependencies: 187
-- Name: xcm_db_zonas_municipios_id_zona_mun_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbxdba
--

ALTER SEQUENCE xcm_db_zonas_municipios_id_zona_mun_seq OWNED BY xcm_db_zonas_municipios.id_zona_mun;


--
-- TOC entry 2295 (class 0 OID 0)
-- Dependencies: 187
-- Name: xcm_db_zonas_municipios_id_zona_mun_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_db_zonas_municipios_id_zona_mun_seq', 1, false);


--
-- TOC entry 201 (class 1259 OID 167181)
-- Dependencies: 2084 2085 3
-- Name: xcm_documentos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_documentos (
    id_doc bigint NOT NULL,
    nom_schema character varying(254) NOT NULL,
    nom_tabla character varying(254) NOT NULL,
    nom_campo character varying(254) NOT NULL,
    nom_doc character varying NOT NULL,
    cons_doc bigint DEFAULT 1 NOT NULL,
    fec_ultimo_doc timestamp without time zone DEFAULT now() NOT NULL,
    id_grupo bigint NOT NULL
);


ALTER TABLE public.xcm_documentos OWNER TO dbxdba;

--
-- TOC entry 2296 (class 0 OID 0)
-- Dependencies: 201
-- Name: TABLE xcm_documentos; Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON TABLE xcm_documentos IS 'Administrador de Consecutivos y de Estados para todos los documentos del sistema';


--
-- TOC entry 200 (class 1259 OID 167179)
-- Dependencies: 3 201
-- Name: xcm_documentos_id_doc_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_documentos_id_doc_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_documentos_id_doc_seq OWNER TO dbxdba;

--
-- TOC entry 2297 (class 0 OID 0)
-- Dependencies: 200
-- Name: xcm_documentos_id_doc_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbxdba
--

ALTER SEQUENCE xcm_documentos_id_doc_seq OWNED BY xcm_documentos.id_doc;


--
-- TOC entry 2298 (class 0 OID 0)
-- Dependencies: 200
-- Name: xcm_documentos_id_doc_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_documentos_id_doc_seq', 7, true);


--
-- TOC entry 161 (class 1259 OID 47273)
-- Dependencies: 3
-- Name: xcm_grupos_id_grupo_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_grupos_id_grupo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_grupos_id_grupo_seq OWNER TO dbxdba;

--
-- TOC entry 2299 (class 0 OID 0)
-- Dependencies: 161
-- Name: xcm_grupos_id_grupo_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_grupos_id_grupo_seq', 3, true);


--
-- TOC entry 162 (class 1259 OID 47275)
-- Dependencies: 2047 3
-- Name: xcm_grupos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_grupos (
    id_grupo bigint DEFAULT nextval('xcm_grupos_id_grupo_seq'::regclass) NOT NULL,
    id_nuip_serial bigint,
    nom_grupo character varying,
    desc_grupo character varying
);


ALTER TABLE public.xcm_grupos OWNER TO dbxdba;

--
-- TOC entry 163 (class 1259 OID 47282)
-- Dependencies: 3
-- Name: xcm_grupos_permisos_id_grupo_permiso_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_grupos_permisos_id_grupo_permiso_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_grupos_permisos_id_grupo_permiso_seq OWNER TO dbxdba;

--
-- TOC entry 2302 (class 0 OID 0)
-- Dependencies: 163
-- Name: xcm_grupos_permisos_id_grupo_permiso_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_grupos_permisos_id_grupo_permiso_seq', 9, true);


--
-- TOC entry 164 (class 1259 OID 47284)
-- Dependencies: 2048 2049 2050 3
-- Name: xcm_grupos_permisos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_grupos_permisos (
    id_grupo_permiso bigint DEFAULT nextval('xcm_grupos_permisos_id_grupo_permiso_seq'::regclass) NOT NULL,
    id_grupo bigint NOT NULL,
    id_permiso character varying NOT NULL,
    fec_tx timestamp without time zone DEFAULT '2008-09-24 08:40:40.471'::timestamp without time zone NOT NULL,
    login_admin character varying(30) DEFAULT "current_user"()
);


ALTER TABLE public.xcm_grupos_permisos OWNER TO dbxdba;

--
-- TOC entry 165 (class 1259 OID 47293)
-- Dependencies: 3
-- Name: xcm_nuips_id_nuip_serial_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_nuips_id_nuip_serial_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_nuips_id_nuip_serial_seq OWNER TO dbxdba;

--
-- TOC entry 2305 (class 0 OID 0)
-- Dependencies: 165
-- Name: xcm_nuips_id_nuip_serial_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_nuips_id_nuip_serial_seq', 10, true);


--
-- TOC entry 166 (class 1259 OID 47295)
-- Dependencies: 2051 2052 3
-- Name: xcm_nuips; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_nuips (
    id_nuip_serial bigint DEFAULT nextval('xcm_nuips_id_nuip_serial_seq'::regclass) NOT NULL,
    id_nuip bigint,
    digito_verif smallint,
    id_tipo_nuip integer,
    nom_nuip text,
    ape_nuip text,
    nom_contacto text,
    notas text,
    fec_nacimiento timestamp without time zone,
    nom_empresa text,
    id_sexo integer,
    id_titulo_nuip integer,
    login_tx character varying(30),
    fec_tx timestamp without time zone DEFAULT now() NOT NULL,
    id_tipo_doc integer
);


ALTER TABLE public.xcm_nuips OWNER TO dbxdba;

--
-- TOC entry 196 (class 1259 OID 54411)
-- Dependencies: 1835 3
-- Name: xcm_grupos_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_grupos_v1 AS
    SELECT g.id_grupo, g.nom_grupo, g.desc_grupo, g.id_nuip_serial, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip FROM (xcm_grupos g LEFT JOIN xcm_nuips n ON ((g.id_nuip_serial = n.id_nuip_serial)));


ALTER TABLE public.xcm_grupos_v1 OWNER TO dbxdba;

--
-- TOC entry 197 (class 1259 OID 54415)
-- Dependencies: 1836 3
-- Name: xcm_municipios_deptos_paises_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_municipios_deptos_paises_v1 AS
    SELECT db_m.id_municipio, db_m.nom_municipio_es, db_d.nom_depto_es, db_p.nom_pais_es FROM xcm_db_municipios db_m, xcm_db_departamentos db_d, xcm_db_paises db_p WHERE ((db_m.id_depto = db_d.id_depto) AND (db_d.id_pais = db_p.id_pais));


ALTER TABLE public.xcm_municipios_deptos_paises_v1 OWNER TO dbxdba;

--
-- TOC entry 167 (class 1259 OID 47310)
-- Dependencies: 2053 3
-- Name: xcm_niveles_usuario; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_niveles_usuario (
    id_nivel_usuario smallint DEFAULT (0)::smallint NOT NULL,
    nom_nivel_usuario character varying NOT NULL
);


ALTER TABLE public.xcm_niveles_usuario OWNER TO dbxdba;

--
-- TOC entry 168 (class 1259 OID 47317)
-- Dependencies: 3
-- Name: xcm_nuips_dirs_id_nuip_dir_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_nuips_dirs_id_nuip_dir_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_nuips_dirs_id_nuip_dir_seq OWNER TO dbxdba;

--
-- TOC entry 2311 (class 0 OID 0)
-- Dependencies: 168
-- Name: xcm_nuips_dirs_id_nuip_dir_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_nuips_dirs_id_nuip_dir_seq', 29456, true);


--
-- TOC entry 169 (class 1259 OID 47319)
-- Dependencies: 2054 2055 3
-- Name: xcm_nuips_dirs; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_nuips_dirs (
    id_nuip_dir bigint DEFAULT nextval('xcm_nuips_dirs_id_nuip_dir_seq'::regclass) NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_tipo_dir integer,
    dir text,
    id_municipio bigint,
    fec_tx timestamp without time zone DEFAULT now() NOT NULL,
    id_zona_mun bigint
);


ALTER TABLE public.xcm_nuips_dirs OWNER TO dbxdba;

--
-- TOC entry 188 (class 1259 OID 54287)
-- Dependencies: 1827 3
-- Name: xcm_nuips_dirs_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_nuips_dirs_v1 AS
    SELECT n.id_nuip_serial, n.id_nuip, n.nom_nuip, n.ape_nuip, nt.dir, nt.id_nuip_dir, nt.id_municipio, dtt.id_tipo_dir, dtt.nom_tipo_dir_es, dtt.abr_tipo_dir_es, mun.nom_municipio_es, zm.id_zona_mun, zm.nom_zona_mun, zm.desc_zona_mun, zm.cod_interno FROM ((((xcm_nuips_dirs nt LEFT JOIN xcm_nuips n ON ((nt.id_nuip_serial = n.id_nuip_serial))) LEFT JOIN xcm_db_municipios mun ON ((nt.id_municipio = mun.id_municipio))) LEFT JOIN xcm_db_tipos_dir dtt ON ((nt.id_tipo_dir = dtt.id_tipo_dir))) LEFT JOIN xcm_db_zonas_municipios zm ON ((nt.id_zona_mun = zm.id_zona_mun)));


ALTER TABLE public.xcm_nuips_dirs_v1 OWNER TO dbxdba;

--
-- TOC entry 170 (class 1259 OID 47331)
-- Dependencies: 3
-- Name: xcm_nuips_emails_id_nuip_email_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_nuips_emails_id_nuip_email_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_nuips_emails_id_nuip_email_seq OWNER TO dbxdba;

--
-- TOC entry 2314 (class 0 OID 0)
-- Dependencies: 170
-- Name: xcm_nuips_emails_id_nuip_email_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_nuips_emails_id_nuip_email_seq', 9, true);


--
-- TOC entry 171 (class 1259 OID 47333)
-- Dependencies: 2056 2057 3
-- Name: xcm_nuips_emails; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_nuips_emails (
    id_nuip_email bigint DEFAULT nextval('xcm_nuips_emails_id_nuip_email_seq'::regclass) NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_tipo_dir integer,
    email character varying NOT NULL,
    fec_tx timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.xcm_nuips_emails OWNER TO dbxdba;

--
-- TOC entry 189 (class 1259 OID 54292)
-- Dependencies: 1828 3
-- Name: xcm_nuips_emails_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_nuips_emails_v1 AS
    SELECT n.id_nuip_serial, n.id_nuip, n.nom_nuip, n.ape_nuip, nt.email, nt.id_nuip_email, dtt.id_tipo_dir, dtt.nom_tipo_dir_es, dtt.abr_tipo_dir_es FROM ((xcm_nuips_emails nt LEFT JOIN xcm_nuips n ON ((nt.id_nuip_serial = n.id_nuip_serial))) LEFT JOIN xcm_db_tipos_dir dtt ON ((nt.id_tipo_dir = dtt.id_tipo_dir)));


ALTER TABLE public.xcm_nuips_emails_v1 OWNER TO dbxdba;

--
-- TOC entry 172 (class 1259 OID 47345)
-- Dependencies: 3
-- Name: xcm_nuips_grupos_id_nuip_grupo_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_nuips_grupos_id_nuip_grupo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_nuips_grupos_id_nuip_grupo_seq OWNER TO dbxdba;

--
-- TOC entry 2318 (class 0 OID 0)
-- Dependencies: 172
-- Name: xcm_nuips_grupos_id_nuip_grupo_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_nuips_grupos_id_nuip_grupo_seq', 30, true);


--
-- TOC entry 173 (class 1259 OID 47347)
-- Dependencies: 2058 3
-- Name: xcm_nuips_grupos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_nuips_grupos (
    id_nuip_grupo integer DEFAULT nextval('xcm_nuips_grupos_id_nuip_grupo_seq'::regclass) NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_grupo bigint NOT NULL
);


ALTER TABLE public.xcm_nuips_grupos OWNER TO dbxdba;

--
-- TOC entry 190 (class 1259 OID 54297)
-- Dependencies: 1829 3
-- Name: xcm_nuips_grupos_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_nuips_grupos_v1 AS
    SELECT COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, g.nom_grupo AS maq_nom_grupo, ng.id_grupo, n.id_nuip, n.digito_verif, tn.abr_tipo_nuip_es, n.nom_nuip, n.ape_nuip, (n.fec_nacimiento)::date AS fec_nacimiento, s.nom_sexo_es, ttn.nom_titulo_nuip_es, n.nom_empresa, n.nom_contacto, n.notas, n.id_nuip_serial, n.id_tipo_nuip, n.id_sexo, n.id_titulo_nuip FROM (((((xcm_nuips n LEFT JOIN xcm_db_tipos_nuips tn ON ((n.id_tipo_nuip = tn.id_tipo_nuip))) LEFT JOIN xcm_db_sexos s ON ((n.id_sexo = s.id_sexo))) LEFT JOIN xcm_db_titulos_nuips ttn ON ((n.id_titulo_nuip = ttn.id_titulo_nuip))) LEFT JOIN xcm_nuips_grupos ng ON ((n.id_nuip_serial = ng.id_nuip_serial))) LEFT JOIN xcm_grupos g ON ((ng.id_grupo = g.id_grupo)));


ALTER TABLE public.xcm_nuips_grupos_v1 OWNER TO dbxdba;

--
-- TOC entry 185 (class 1259 OID 52598)
-- Dependencies: 2076 2077 3
-- Name: xcm_nuips_perfiles; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_nuips_perfiles (
    id_nuip_perfil bigint NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_perfil integer NOT NULL,
    id_grupo bigint NOT NULL,
    fec_tx timestamp without time zone DEFAULT now() NOT NULL,
    login_tx character varying DEFAULT 30
);


ALTER TABLE public.xcm_nuips_perfiles OWNER TO dbxdba;

--
-- TOC entry 2322 (class 0 OID 0)
-- Dependencies: 185
-- Name: TABLE xcm_nuips_perfiles; Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON TABLE xcm_nuips_perfiles IS 'v.110623.1';


--
-- TOC entry 184 (class 1259 OID 52596)
-- Dependencies: 185 3
-- Name: xcm_nuips_perfiles_id_nuip_perfil_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_nuips_perfiles_id_nuip_perfil_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_nuips_perfiles_id_nuip_perfil_seq OWNER TO dbxdba;

--
-- TOC entry 2323 (class 0 OID 0)
-- Dependencies: 184
-- Name: xcm_nuips_perfiles_id_nuip_perfil_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbxdba
--

ALTER SEQUENCE xcm_nuips_perfiles_id_nuip_perfil_seq OWNED BY xcm_nuips_perfiles.id_nuip_perfil;


--
-- TOC entry 2324 (class 0 OID 0)
-- Dependencies: 184
-- Name: xcm_nuips_perfiles_id_nuip_perfil_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_nuips_perfiles_id_nuip_perfil_seq', 12, true);


--
-- TOC entry 183 (class 1259 OID 52585)
-- Dependencies: 2072 2074 3
-- Name: xcm_perfiles; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_perfiles (
    id_perfil integer NOT NULL,
    nom_perfil character varying NOT NULL,
    orden_db integer DEFAULT 1 NOT NULL,
    is_activo boolean DEFAULT true NOT NULL
);


ALTER TABLE public.xcm_perfiles OWNER TO dbxdba;

--
-- TOC entry 206 (class 1259 OID 183912)
-- Dependencies: 1837 3
-- Name: xcm_nuips_perfiles_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_nuips_perfiles_v1 AS
    SELECT COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, n.id_nuip, n.digito_verif, n.nom_nuip, n.ape_nuip, n.fec_nacimiento, n.notas, s.nom_sexo_es, ttn.nom_titulo_nuip_es, n.nom_empresa, n.nom_contacto, n.id_nuip_serial, n.id_tipo_nuip, n.id_sexo, n.id_titulo_nuip, np.id_perfil, np.id_grupo, p.nom_perfil, g.nom_grupo, np.id_nuip_perfil, td.id_tipo_doc, td.nom_tipo_doc AS nom_tipo_doc_es FROM (((((((xcm_nuips n LEFT JOIN xcm_nuips_perfiles np ON ((n.id_nuip_serial = np.id_nuip_serial))) LEFT JOIN xcm_perfiles p ON ((np.id_perfil = p.id_perfil))) LEFT JOIN xcm_grupos g ON ((np.id_grupo = g.id_grupo))) LEFT JOIN xcm_db_tipos_nuips tn ON ((n.id_tipo_nuip = tn.id_tipo_nuip))) LEFT JOIN xcm_db_sexos s ON ((n.id_sexo = s.id_sexo))) LEFT JOIN xcm_db_titulos_nuips ttn ON ((n.id_titulo_nuip = ttn.id_titulo_nuip))) LEFT JOIN xcm_db_tipos_docs td ON ((n.id_tipo_doc = td.id_tipo_doc)));


ALTER TABLE public.xcm_nuips_perfiles_v1 OWNER TO dbxdba;

--
-- TOC entry 2325 (class 0 OID 0)
-- Dependencies: 206
-- Name: VIEW xcm_nuips_perfiles_v1; Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON VIEW xcm_nuips_perfiles_v1 IS 'v. 120808.1';


--
-- TOC entry 174 (class 1259 OID 47356)
-- Dependencies: 3
-- Name: xcm_nuips_tels_id_nuip_tel_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_nuips_tels_id_nuip_tel_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_nuips_tels_id_nuip_tel_seq OWNER TO dbxdba;

--
-- TOC entry 2326 (class 0 OID 0)
-- Dependencies: 174
-- Name: xcm_nuips_tels_id_nuip_tel_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_nuips_tels_id_nuip_tel_seq', 29456, true);


--
-- TOC entry 175 (class 1259 OID 47358)
-- Dependencies: 2059 2060 3
-- Name: xcm_nuips_tels; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_nuips_tels (
    id_nuip_tel bigint DEFAULT nextval('xcm_nuips_tels_id_nuip_tel_seq'::regclass) NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_tipo_tel integer NOT NULL,
    tel text NOT NULL,
    fec_tx timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.xcm_nuips_tels OWNER TO dbxdba;

--
-- TOC entry 191 (class 1259 OID 54307)
-- Dependencies: 1830 3
-- Name: xcm_nuips_tels_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_nuips_tels_v1 AS
    SELECT n.id_nuip_serial, n.id_nuip, n.nom_nuip, n.ape_nuip, nt.id_nuip_tel, nt.tel, dtt.id_tipo_tel, dtt.nom_tipo_tel_es, dtt.abr_tipo_tel_es FROM ((xcm_nuips_tels nt LEFT JOIN xcm_nuips n ON ((nt.id_nuip_serial = n.id_nuip_serial))) LEFT JOIN xcm_db_tipos_tel dtt ON ((nt.id_tipo_tel = dtt.id_tipo_tel)));


ALTER TABLE public.xcm_nuips_tels_v1 OWNER TO dbxdba;

--
-- TOC entry 192 (class 1259 OID 54312)
-- Dependencies: 1831 3
-- Name: xcm_nuips_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_nuips_v1 AS
    SELECT COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, n.id_nuip, n.nom_nuip, n.ape_nuip, n.fec_nacimiento, s.nom_sexo_es, ttn.nom_titulo_nuip_es, n.nom_empresa, n.nom_contacto, n.notas, n.id_nuip_serial, n.id_tipo_nuip, n.id_sexo, n.id_titulo_nuip FROM (((xcm_nuips n LEFT JOIN xcm_db_tipos_nuips tn ON ((n.id_tipo_nuip = tn.id_tipo_nuip))) LEFT JOIN xcm_db_sexos s ON ((n.id_sexo = s.id_sexo))) LEFT JOIN xcm_db_titulos_nuips ttn ON ((n.id_titulo_nuip = ttn.id_titulo_nuip)));


ALTER TABLE public.xcm_nuips_v1 OWNER TO dbxdba;

--
-- TOC entry 2330 (class 0 OID 0)
-- Dependencies: 192
-- Name: VIEW xcm_nuips_v1; Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON VIEW xcm_nuips_v1 IS 'Datos basicos';


--
-- TOC entry 182 (class 1259 OID 52583)
-- Dependencies: 3 183
-- Name: xcm_perfiles_id_perfil_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_perfiles_id_perfil_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_perfiles_id_perfil_seq OWNER TO dbxdba;

--
-- TOC entry 2332 (class 0 OID 0)
-- Dependencies: 182
-- Name: xcm_perfiles_id_perfil_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: dbxdba
--

ALTER SEQUENCE xcm_perfiles_id_perfil_seq OWNED BY xcm_perfiles.id_perfil;


--
-- TOC entry 2333 (class 0 OID 0)
-- Dependencies: 182
-- Name: xcm_perfiles_id_perfil_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_perfiles_id_perfil_seq', 3, true);


--
-- TOC entry 176 (class 1259 OID 47375)
-- Dependencies: 2061 3
-- Name: xcm_permisos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_permisos (
    id_permiso character varying NOT NULL,
    id_padre character varying,
    nom_permiso character varying NOT NULL,
    desc_permiso text,
    nro_nivel smallint,
    is_folder boolean DEFAULT false NOT NULL,
    onchange character varying
);


ALTER TABLE public.xcm_permisos OWNER TO dbxdba;

--
-- TOC entry 177 (class 1259 OID 47382)
-- Dependencies: 2062 2063 2064 2065 2066 2067 2068 3
-- Name: xcm_usuarios; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_usuarios (
    login character varying(30) NOT NULL,
    passwd character varying NOT NULL,
    id_nivel_usuario integer DEFAULT 2 NOT NULL,
    id_nuip_serial bigint NOT NULL,
    fec_creacion timestamp without time zone DEFAULT now() NOT NULL,
    is_activo boolean DEFAULT true NOT NULL,
    cant_sesiones_max smallint DEFAULT (1)::smallint NOT NULL,
    cant_sesiones smallint DEFAULT (0)::smallint NOT NULL,
    --dm_cambia_passwd integer DEFAULT 1 NOT NULL,
    fec_tx timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.xcm_usuarios OWNER TO dbxdba;

--
-- TOC entry 178 (class 1259 OID 47393)
-- Dependencies: 3
-- Name: xcm_usuarios_grupos_id_usuario_grupo_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_usuarios_grupos_id_usuario_grupo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_usuarios_grupos_id_usuario_grupo_seq OWNER TO dbxdba;

--
-- TOC entry 2336 (class 0 OID 0)
-- Dependencies: 178
-- Name: xcm_usuarios_grupos_id_usuario_grupo_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_usuarios_grupos_id_usuario_grupo_seq', 28, true);


--
-- TOC entry 179 (class 1259 OID 47395)
-- Dependencies: 2069 3
-- Name: xcm_usuarios_grupos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_usuarios_grupos (
    id_usuario_grupo bigint DEFAULT nextval('xcm_usuarios_grupos_id_usuario_grupo_seq'::regclass) NOT NULL,
    login character varying(30) NOT NULL,
    id_grupo bigint NOT NULL
);


ALTER TABLE public.xcm_usuarios_grupos OWNER TO dbxdba;

--
-- TOC entry 193 (class 1259 OID 54317)
-- Dependencies: 1832 3
-- Name: xcm_usuarios_grupos_nuips_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_usuarios_grupos_nuips_v1 AS
    SELECT DISTINCT u.login, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, n.id_nuip, n.id_nuip_serial, COALESCE(ug.id_grupo, ng.id_grupo) AS id_grupo, u.id_nivel_usuario FROM (xcm_usuarios u LEFT JOIN xcm_usuarios_grupos ug ON (((ug.login)::text = (u.login)::text))), xcm_nuips n, xcm_nuips_grupos ng WHERE ((u.id_nuip_serial = n.id_nuip_serial) AND (n.id_nuip_serial = ng.id_nuip_serial)) ORDER BY u.login, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)), COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip), n.id_nuip, n.id_nuip_serial, COALESCE(ug.id_grupo, ng.id_grupo), u.id_nivel_usuario;


ALTER TABLE public.xcm_usuarios_grupos_nuips_v1 OWNER TO dbxdba;

--
-- TOC entry 194 (class 1259 OID 54322)
-- Dependencies: 1833 3
-- Name: xcm_usuarios_grupos_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_usuarios_grupos_v1 AS
    SELECT ug.id_usuario_grupo, ug.login, g.nom_grupo, g.id_grupo FROM xcm_usuarios_grupos ug, xcm_grupos g WHERE (ug.id_grupo = g.id_grupo);


ALTER TABLE public.xcm_usuarios_grupos_v1 OWNER TO dbxdba;

--
-- TOC entry 180 (class 1259 OID 47408)
-- Dependencies: 3
-- Name: xcm_usuarios_permisos_id_usuario_permiso_seq; Type: SEQUENCE; Schema: public; Owner: dbxdba
--

CREATE SEQUENCE xcm_usuarios_permisos_id_usuario_permiso_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xcm_usuarios_permisos_id_usuario_permiso_seq OWNER TO dbxdba;

--
-- TOC entry 2341 (class 0 OID 0)
-- Dependencies: 180
-- Name: xcm_usuarios_permisos_id_usuario_permiso_seq; Type: SEQUENCE SET; Schema: public; Owner: dbxdba
--

SELECT pg_catalog.setval('xcm_usuarios_permisos_id_usuario_permiso_seq', 529, true);


--
-- TOC entry 181 (class 1259 OID 47410)
-- Dependencies: 2070 2071 3
-- Name: xcm_usuarios_permisos; Type: TABLE; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE TABLE xcm_usuarios_permisos (
    id_usuario_permiso bigint DEFAULT nextval('xcm_usuarios_permisos_id_usuario_permiso_seq'::regclass) NOT NULL,
    login character varying(30) NOT NULL,
    id_permiso character varying NOT NULL,
    fec_tx timestamp without time zone DEFAULT '2009-01-01 00:00:00'::timestamp without time zone NOT NULL,
    login_admin character varying(30) NOT NULL
);


ALTER TABLE public.xcm_usuarios_permisos OWNER TO dbxdba;

--
-- TOC entry 207 (class 1259 OID 412490)
-- Dependencies: 1838 3
-- Name: xcm_usuarios_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

--u.dm_cambia_passwd,
CREATE VIEW xcm_usuarios_v1 AS
    SELECT u.login, u.passwd, u.id_nivel_usuario, u.id_nuip_serial, u.fec_creacion, u.is_activo, u.cant_sesiones_max, u.cant_sesiones, n.id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, ((now())::date - (u.fec_tx)::date) AS dias_pasabordo, u.fec_tx FROM (xcm_usuarios u LEFT JOIN xcm_nuips n ON ((u.id_nuip_serial = n.id_nuip_serial)));


ALTER TABLE public.xcm_usuarios_v1 OWNER TO dbxdba;

--
-- TOC entry 2344 (class 0 OID 0)
-- Dependencies: 207
-- Name: VIEW xcm_usuarios_v1; Type: COMMENT; Schema: public; Owner: dbxdba
--

COMMENT ON VIEW xcm_usuarios_v1 IS 'xcm_usuarios, xcm_nuips
v.121212.1';


--
-- TOC entry 195 (class 1259 OID 54330)
-- Dependencies: 1834 3
-- Name: xcm_zonas_municipios_v1; Type: VIEW; Schema: public; Owner: dbxdba
--

CREATE VIEW xcm_zonas_municipios_v1 AS
    SELECT z.id_zona_mun, z.id_municipio, z.nom_zona_mun, z.desc_zona_mun, z.cod_interno, z.is_activo, z.orden_db, m.nom_municipio_es FROM xcm_db_zonas_municipios z, xcm_db_municipios m WHERE (z.id_municipio = m.id_municipio);


ALTER TABLE public.xcm_zonas_municipios_v1 OWNER TO dbxdba;

--
-- TOC entry 2086 (class 2604 OID 175585)
-- Dependencies: 203 202 203
-- Name: id_cnf_axys; Type: DEFAULT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_cnf_axys ALTER COLUMN id_cnf_axys SET DEFAULT nextval('xcm_cnf_axys_id_cnf_axys_seq'::regclass);


--
-- TOC entry 2089 (class 2604 OID 175619)
-- Dependencies: 205 204 205
-- Name: id_cnf_grupo_axys; Type: DEFAULT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_cnf_grupos_axys ALTER COLUMN id_cnf_grupo_axys SET DEFAULT nextval('xcm_cnf_grupos_axys_id_cnf_grupo_axys_seq'::regclass);


--
-- TOC entry 2081 (class 2604 OID 157933)
-- Dependencies: 198 199 199
-- Name: id_tipo_doc; Type: DEFAULT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_db_tipos_docs ALTER COLUMN id_tipo_doc SET DEFAULT nextval('xcm_db_tipos_docs_id_tipo_doc_seq'::regclass);


--
-- TOC entry 2078 (class 2604 OID 54337)
-- Dependencies: 187 186
-- Name: id_zona_mun; Type: DEFAULT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_db_zonas_municipios ALTER COLUMN id_zona_mun SET DEFAULT nextval('xcm_db_zonas_municipios_id_zona_mun_seq'::regclass);


--
-- TOC entry 2083 (class 2604 OID 167184)
-- Dependencies: 200 201 201
-- Name: id_doc; Type: DEFAULT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_documentos ALTER COLUMN id_doc SET DEFAULT nextval('xcm_documentos_id_doc_seq'::regclass);


--
-- TOC entry 2075 (class 2604 OID 52601)
-- Dependencies: 184 185 185
-- Name: id_nuip_perfil; Type: DEFAULT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips_perfiles ALTER COLUMN id_nuip_perfil SET DEFAULT nextval('xcm_nuips_perfiles_id_nuip_perfil_seq'::regclass);


--
-- TOC entry 2073 (class 2604 OID 52588)
-- Dependencies: 182 183 183
-- Name: id_perfil; Type: DEFAULT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_perfiles ALTER COLUMN id_perfil SET DEFAULT nextval('xcm_perfiles_id_perfil_seq'::regclass);


--
-- TOC entry 2213 (class 0 OID 47195)
-- Dependencies: 144
-- Data for Name: xcm_campos_db; Type: TABLE DATA; Schema: public; Owner: dbxdba
--



--
-- TOC entry 2239 (class 0 OID 175582)
-- Dependencies: 203
-- Data for Name: xcm_cnf_axys; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_cnf_axys (id_cnf_axys, nom_cnf_axys, desc_cnf_axys, tipo_cnf_axys, login, fec_tx) VALUES (4, 'max_afiliaciones', NULL, 'TEXT', 'dbxdba', '2012-10-22 12:41:52.179852');
INSERT INTO xcm_cnf_axys (id_cnf_axys, nom_cnf_axys, desc_cnf_axys, tipo_cnf_axys, login, fec_tx) VALUES (5, 'formatos_impresion', NULL, 'TEXT', 'dbxdba', '2012-10-22 13:27:34.933022');
INSERT INTO xcm_cnf_axys (id_cnf_axys, nom_cnf_axys, desc_cnf_axys, tipo_cnf_axys, login, fec_tx) VALUES (6, 'dias_cambia_passwd', 'Numero de Dias para obligar al cambio de Pasabordo', 'TEXT', 'dbxdba', '2012-12-05 15:24:30.91697');


--
-- TOC entry 2240 (class 0 OID 175616)
-- Dependencies: 205
-- Data for Name: xcm_cnf_grupos_axys; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_cnf_grupos_axys (id_cnf_grupo_axys, nom_cnf_axys, id_grupo, login, vr_cnf_axys, fec_tx, login_tx) VALUES (4, 'formatos_impresion', 1, NULL, 'estrella', '2012-10-22 13:27:55.603212', 'dbxdba');
INSERT INTO xcm_cnf_grupos_axys (id_cnf_grupo_axys, nom_cnf_axys, id_grupo, login, vr_cnf_axys, fec_tx, login_tx) VALUES (3, 'max_afiliaciones', 1, NULL, '20000', '2012-10-22 12:43:30.249714', 'dbxdba');
INSERT INTO xcm_cnf_grupos_axys (id_cnf_grupo_axys, nom_cnf_axys, id_grupo, login, vr_cnf_axys, fec_tx, login_tx) VALUES (5, 'dias_cambia_passwd', 1, NULL, '360', '2012-12-05 15:25:14.381042', 'dbxdba');


--
-- TOC entry 2214 (class 0 OID 47204)
-- Dependencies: 146
-- Data for Name: xcm_db_departamentos; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (1, 49, NULL, true, NULL, 'Antioquia', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (2, 49, NULL, true, NULL, 'Atlantico', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (3, 49, NULL, true, NULL, 'Bogotá, D.C.', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (4, 49, NULL, true, NULL, 'Bolivar', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (5, 49, NULL, true, NULL, 'Boyaca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (6, 49, NULL, true, NULL, 'Caldas', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (7, 49, NULL, true, NULL, 'Caqueta', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (8, 49, NULL, true, NULL, 'Cauca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (9, 49, NULL, true, NULL, 'Cesar', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (10, 49, NULL, true, NULL, 'Cordoba', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (11, 49, NULL, true, NULL, 'Cundinamarca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (12, 49, NULL, true, NULL, 'Choco', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (13, 49, NULL, true, NULL, 'Huila', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (14, 49, NULL, true, NULL, 'La Guajira', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (15, 49, NULL, true, NULL, 'Magdalena', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (16, 49, NULL, true, NULL, 'Meta', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (17, 49, NULL, true, NULL, 'Nariño', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (18, 49, NULL, true, NULL, 'Norte de Santander', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (19, 49, NULL, true, NULL, 'Quindio', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (20, 49, NULL, true, NULL, 'Risaralda', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (21, 49, NULL, true, NULL, 'Santander', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (22, 49, NULL, true, NULL, 'Sucre', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (23, 49, NULL, true, NULL, 'Tolima', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (24, 49, NULL, true, NULL, 'Valle del Cauca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (25, 49, NULL, true, NULL, 'Arauca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (26, 49, NULL, true, NULL, 'Casanare', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (27, 49, NULL, true, NULL, 'Putumayo', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (28, 49, NULL, true, NULL, 'Archipielago de San Andres', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (29, 49, NULL, true, NULL, 'Amazonas', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (30, 49, NULL, true, NULL, 'Guainía', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (31, 49, NULL, true, NULL, 'Guaviare', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (32, 49, NULL, true, NULL, 'Vaupés', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (33, 49, NULL, true, NULL, 'Vichada', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (34, 66, NULL, true, NULL, 'Azuay', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (35, 66, NULL, true, NULL, 'Bolívar', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (36, 66, NULL, true, NULL, 'Cañar', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (37, 66, NULL, true, NULL, 'Carchi', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (38, 66, NULL, true, NULL, 'Chimborazo', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (39, 66, NULL, true, NULL, 'Cotopaxi', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (40, 66, NULL, true, NULL, 'Imbabura', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (41, 66, NULL, true, NULL, 'Loja', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (42, 66, NULL, true, NULL, 'Pichincha', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (43, 66, NULL, true, NULL, 'Tungurahua', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (44, 66, NULL, true, NULL, 'Santo Domingo de los Tsachilas', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (45, 66, NULL, true, NULL, 'Esmeraldas', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (46, 66, NULL, true, NULL, 'Guayas', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (47, 66, NULL, true, NULL, 'El Oro', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (48, 66, NULL, true, NULL, 'Los Ríos', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (49, 66, NULL, true, NULL, 'Manabí', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (50, 66, NULL, true, NULL, 'Santa Elena', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (51, 66, NULL, true, NULL, 'Morona Santiago', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (52, 66, NULL, true, NULL, 'Napo', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (53, 66, NULL, true, NULL, 'Orellana', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (54, 66, NULL, true, NULL, 'Pastaza', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (55, 66, NULL, true, NULL, 'Sucumbíos', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (56, 66, NULL, true, NULL, 'Zamora Chinchipe', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos (id_depto, id_pais, cod_dane, is_activo, orden_db, nom_depto_es, abr_depto_es, nom_depto_en, abr_depto_en, nom_depto_de, abr_depto_de, nom_depto_fr, abr_depto_fr) VALUES (57, 66, NULL, true, NULL, 'Galápagos', NULL, NULL, NULL, NULL, NULL, NULL, NULL);


--
-- TOC entry 2215 (class 0 OID 47211)
-- Dependencies: 148
-- Data for Name: xcm_db_municipios; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1, 1, true, NULL, NULL, NULL, NULL, 'ABEJORRAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (2, 1, true, NULL, NULL, NULL, NULL, 'ABRIAQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (3, 1, true, NULL, NULL, NULL, NULL, 'ALEJANDRIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (4, 1, true, NULL, NULL, NULL, NULL, 'AMAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (5, 1, true, NULL, NULL, NULL, NULL, 'AMALFI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (6, 1, true, NULL, NULL, NULL, NULL, 'ANDES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (7, 1, true, NULL, NULL, NULL, NULL, 'ANGELOPOLIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (8, 1, true, NULL, NULL, NULL, NULL, 'ANGOSTURA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (9, 1, true, NULL, NULL, NULL, NULL, 'ANORI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (10, 1, true, NULL, NULL, NULL, NULL, 'SANTAFE DE ANTIOQUIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (11, 1, true, NULL, NULL, NULL, NULL, 'ANZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (12, 1, true, NULL, NULL, NULL, NULL, 'APARTADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (13, 1, true, NULL, NULL, NULL, NULL, 'ARBOLETES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (14, 1, true, NULL, NULL, NULL, NULL, 'ARGELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (15, 1, true, NULL, NULL, NULL, NULL, 'ARMENIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (16, 1, true, NULL, NULL, NULL, NULL, 'BARBOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (17, 1, true, NULL, NULL, NULL, NULL, 'BELMIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (18, 1, true, NULL, NULL, NULL, NULL, 'BELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (19, 1, true, NULL, NULL, NULL, NULL, 'BETANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (20, 1, true, NULL, NULL, NULL, NULL, 'BETULIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (21, 1, true, NULL, NULL, NULL, NULL, 'CIUDAD BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (22, 1, true, NULL, NULL, NULL, NULL, 'BRICEÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (23, 1, true, NULL, NULL, NULL, NULL, 'BURITICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (24, 1, true, NULL, NULL, NULL, NULL, 'CACERES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (25, 1, true, NULL, NULL, NULL, NULL, 'CAICEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (26, 1, true, NULL, NULL, NULL, NULL, 'CALDAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (27, 1, true, NULL, NULL, NULL, NULL, 'CAMPAMENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (28, 1, true, NULL, NULL, NULL, NULL, 'CAÑASGORDAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (29, 1, true, NULL, NULL, NULL, NULL, 'CARACOLI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (30, 1, true, NULL, NULL, NULL, NULL, 'CARAMANTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (31, 1, true, NULL, NULL, NULL, NULL, 'CAREPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (32, 1, true, NULL, NULL, NULL, NULL, 'EL CARMEN DE VIBORAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (33, 1, true, NULL, NULL, NULL, NULL, 'CAROLINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (34, 1, true, NULL, NULL, NULL, NULL, 'CAUCASIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (35, 1, true, NULL, NULL, NULL, NULL, 'CHIGORODO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (36, 1, true, NULL, NULL, NULL, NULL, 'CISNEROS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (37, 1, true, NULL, NULL, NULL, NULL, 'COCORNA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (38, 1, true, NULL, NULL, NULL, NULL, 'CONCEPCION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (39, 1, true, NULL, NULL, NULL, NULL, 'CONCORDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (40, 1, true, NULL, NULL, NULL, NULL, 'COPACABANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (41, 1, true, NULL, NULL, NULL, NULL, 'DABEIBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (42, 1, true, NULL, NULL, NULL, NULL, 'DON MATIAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (43, 1, true, NULL, NULL, NULL, NULL, 'EBEJICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (44, 1, true, NULL, NULL, NULL, NULL, 'EL BAGRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (45, 1, true, NULL, NULL, NULL, NULL, 'ENTRERRIOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (46, 1, true, NULL, NULL, NULL, NULL, 'ENVIGADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (47, 1, true, NULL, NULL, NULL, NULL, 'FREDONIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (48, 1, true, NULL, NULL, NULL, NULL, 'FRONTINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (49, 1, true, NULL, NULL, NULL, NULL, 'GIRALDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (50, 1, true, NULL, NULL, NULL, NULL, 'GIRARDOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (51, 1, true, NULL, NULL, NULL, NULL, 'GOMEZ PLATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (52, 1, true, NULL, NULL, NULL, NULL, 'GRANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (53, 1, true, NULL, NULL, NULL, NULL, 'GUADALUPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (54, 1, true, NULL, NULL, NULL, NULL, 'GUARNE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (55, 1, true, NULL, NULL, NULL, NULL, 'GUATAPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (56, 1, true, NULL, NULL, NULL, NULL, 'HELICONIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (57, 1, true, NULL, NULL, NULL, NULL, 'HISPANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (58, 1, true, NULL, NULL, NULL, NULL, 'ITAGUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (59, 1, true, NULL, NULL, NULL, NULL, 'ITUANGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (60, 1, true, NULL, NULL, NULL, NULL, 'JARDIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (61, 1, true, NULL, NULL, NULL, NULL, 'JERICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (62, 1, true, NULL, NULL, NULL, NULL, 'LA CEJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (63, 1, true, NULL, NULL, NULL, NULL, 'LA ESTRELLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (64, 1, true, NULL, NULL, NULL, NULL, 'LA PINTADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (65, 1, true, NULL, NULL, NULL, NULL, 'LA UNION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (66, 1, true, NULL, NULL, NULL, NULL, 'LIBORINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (67, 1, true, NULL, NULL, NULL, NULL, 'MACEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (68, 1, true, NULL, NULL, NULL, NULL, 'MARINILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (69, 1, true, NULL, NULL, NULL, NULL, 'MONTEBELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (70, 1, true, NULL, NULL, NULL, NULL, 'MURINDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (71, 1, true, NULL, NULL, NULL, NULL, 'MUTATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (72, 1, true, NULL, NULL, NULL, NULL, 'NARIÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (73, 1, true, NULL, NULL, NULL, NULL, 'NECOCLI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (74, 1, true, NULL, NULL, NULL, NULL, 'NECHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (75, 1, true, NULL, NULL, NULL, NULL, 'OLAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (76, 1, true, NULL, NULL, NULL, NULL, 'PEÑOL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (77, 1, true, NULL, NULL, NULL, NULL, 'PEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (78, 1, true, NULL, NULL, NULL, NULL, 'PUEBLORRICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (79, 1, true, NULL, NULL, NULL, NULL, 'PUERTO BERRIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (80, 1, true, NULL, NULL, NULL, NULL, 'PUERTO NARE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (81, 1, true, NULL, NULL, NULL, NULL, 'PUERTO TRIUNFO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (82, 1, true, NULL, NULL, NULL, NULL, 'REMEDIOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (83, 1, true, NULL, NULL, NULL, NULL, 'RETIRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (84, 1, true, NULL, NULL, NULL, NULL, 'RIONEGRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (85, 1, true, NULL, NULL, NULL, NULL, 'SABANALARGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (86, 1, true, NULL, NULL, NULL, NULL, 'SABANETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (87, 1, true, NULL, NULL, NULL, NULL, 'SALGAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (88, 1, true, NULL, NULL, NULL, NULL, 'SAN ANDRES DE CUERQUIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (89, 1, true, NULL, NULL, NULL, NULL, 'SAN CARLOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (90, 1, true, NULL, NULL, NULL, NULL, 'SAN FRANCISCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (91, 1, true, NULL, NULL, NULL, NULL, 'SAN JERONIMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (92, 1, true, NULL, NULL, NULL, NULL, 'SAN JOSE DE LA MONTAÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (93, 1, true, NULL, NULL, NULL, NULL, 'SAN JUAN DE URABA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (94, 1, true, NULL, NULL, NULL, NULL, 'SAN LUIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (95, 1, true, NULL, NULL, NULL, NULL, 'SAN PEDRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (96, 1, true, NULL, NULL, NULL, NULL, 'SAN PEDRO DE URABA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (97, 1, true, NULL, NULL, NULL, NULL, 'SAN RAFAEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (98, 1, true, NULL, NULL, NULL, NULL, 'SAN ROQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (99, 1, true, NULL, NULL, NULL, NULL, 'SAN VICENTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (100, 1, true, NULL, NULL, NULL, NULL, 'SANTA BARBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (101, 1, true, NULL, NULL, NULL, NULL, 'SANTA ROSA DE OSOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (102, 1, true, NULL, NULL, NULL, NULL, 'SANTO DOMINGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (103, 1, true, NULL, NULL, NULL, NULL, 'EL SANTUARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (104, 1, true, NULL, NULL, NULL, NULL, 'SEGOVIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (105, 1, true, NULL, NULL, NULL, NULL, 'SONSON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (106, 1, true, NULL, NULL, NULL, NULL, 'SOPETRAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (107, 1, true, NULL, NULL, NULL, NULL, 'TAMESIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (108, 1, true, NULL, NULL, NULL, NULL, 'TARAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (109, 1, true, NULL, NULL, NULL, NULL, 'TARSO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (110, 1, true, NULL, NULL, NULL, NULL, 'TITIRIBI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (111, 1, true, NULL, NULL, NULL, NULL, 'TOLEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (112, 1, true, NULL, NULL, NULL, NULL, 'TURBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (113, 1, true, NULL, NULL, NULL, NULL, 'URAMITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (114, 1, true, NULL, NULL, NULL, NULL, 'URRAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (115, 1, true, NULL, NULL, NULL, NULL, 'VALDIVIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (116, 1, true, NULL, NULL, NULL, NULL, 'VALPARAISO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (117, 1, true, NULL, NULL, NULL, NULL, 'VEGACHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (118, 1, true, NULL, NULL, NULL, NULL, 'VENECIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (119, 1, true, NULL, NULL, NULL, NULL, 'VIGIA DEL FUERTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (120, 1, true, NULL, NULL, NULL, NULL, 'YALI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (121, 1, true, NULL, NULL, NULL, NULL, 'YARUMAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (122, 1, true, NULL, NULL, NULL, NULL, 'YOLOMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (123, 1, true, NULL, NULL, NULL, NULL, 'YONDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (124, 1, true, NULL, NULL, NULL, NULL, 'ZARAGOZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (125, 2, true, NULL, NULL, NULL, NULL, 'BARRANQUILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (126, 2, true, NULL, NULL, NULL, NULL, 'BARANOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (127, 2, true, NULL, NULL, NULL, NULL, 'CAMPO DE LA CRUZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (128, 2, true, NULL, NULL, NULL, NULL, 'CANDELARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (129, 2, true, NULL, NULL, NULL, NULL, 'GALAPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (130, 2, true, NULL, NULL, NULL, NULL, 'JUAN DE ACOSTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (131, 2, true, NULL, NULL, NULL, NULL, 'LURUACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (132, 2, true, NULL, NULL, NULL, NULL, 'MALAMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (133, 2, true, NULL, NULL, NULL, NULL, 'MANATI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (134, 2, true, NULL, NULL, NULL, NULL, 'PALMAR DE VARELA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (135, 2, true, NULL, NULL, NULL, NULL, 'PIOJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (136, 2, true, NULL, NULL, NULL, NULL, 'POLONUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (137, 2, true, NULL, NULL, NULL, NULL, 'PONEDERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (138, 2, true, NULL, NULL, NULL, NULL, 'PUERTO COLOMBIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (139, 2, true, NULL, NULL, NULL, NULL, 'REPELON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (140, 2, true, NULL, NULL, NULL, NULL, 'SABANAGRANDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (141, 2, true, NULL, NULL, NULL, NULL, 'SABANALARGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (142, 2, true, NULL, NULL, NULL, NULL, 'SANTA LUCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (143, 2, true, NULL, NULL, NULL, NULL, 'SANTO TOMAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (144, 2, true, NULL, NULL, NULL, NULL, 'SOLEDAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (145, 2, true, NULL, NULL, NULL, NULL, 'SUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (146, 2, true, NULL, NULL, NULL, NULL, 'TUBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (147, 2, true, NULL, NULL, NULL, NULL, 'USIACURI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (149, 4, true, NULL, NULL, NULL, NULL, 'CARTAGENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (150, 4, true, NULL, NULL, NULL, NULL, 'ACHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (151, 4, true, NULL, NULL, NULL, NULL, 'ALTOS DEL ROSARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (152, 4, true, NULL, NULL, NULL, NULL, 'ARENAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (153, 4, true, NULL, NULL, NULL, NULL, 'ARJONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (154, 4, true, NULL, NULL, NULL, NULL, 'ARROYOHONDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (155, 4, true, NULL, NULL, NULL, NULL, 'BARRANCO DE LOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (156, 4, true, NULL, NULL, NULL, NULL, 'CALAMAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (157, 4, true, NULL, NULL, NULL, NULL, 'CANTAGALLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (158, 4, true, NULL, NULL, NULL, NULL, 'CICUCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (159, 4, true, NULL, NULL, NULL, NULL, 'CORDOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (160, 4, true, NULL, NULL, NULL, NULL, 'CLEMENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (161, 4, true, NULL, NULL, NULL, NULL, 'EL CARMEN DE BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (162, 4, true, NULL, NULL, NULL, NULL, 'EL GUAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (163, 4, true, NULL, NULL, NULL, NULL, 'EL PEÑON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (164, 4, true, NULL, NULL, NULL, NULL, 'HATILLO DE LOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (165, 4, true, NULL, NULL, NULL, NULL, 'MAGANGUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (166, 4, true, NULL, NULL, NULL, NULL, 'MAHATES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (167, 4, true, NULL, NULL, NULL, NULL, 'MARGARITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (168, 4, true, NULL, NULL, NULL, NULL, 'MARIA LA BAJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (169, 4, true, NULL, NULL, NULL, NULL, 'MONTECRISTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (170, 4, true, NULL, NULL, NULL, NULL, 'MOMPOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (171, 4, true, NULL, NULL, NULL, NULL, 'MORALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (172, 4, true, NULL, NULL, NULL, NULL, 'PINILLOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (173, 4, true, NULL, NULL, NULL, NULL, 'REGIDOR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (174, 4, true, NULL, NULL, NULL, NULL, 'RIO VIEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (175, 4, true, NULL, NULL, NULL, NULL, 'SAN CRISTOBAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (176, 4, true, NULL, NULL, NULL, NULL, 'SAN ESTANISLAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (177, 4, true, NULL, NULL, NULL, NULL, 'SAN FERNANDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (178, 4, true, NULL, NULL, NULL, NULL, 'SAN JACINTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (179, 4, true, NULL, NULL, NULL, NULL, 'SAN JACINTO DEL CAUCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (180, 4, true, NULL, NULL, NULL, NULL, 'SAN JUAN NEPOMUCENO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (181, 4, true, NULL, NULL, NULL, NULL, 'SAN MARTIN DE LOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (182, 4, true, NULL, NULL, NULL, NULL, 'SAN PABLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (183, 4, true, NULL, NULL, NULL, NULL, 'SANTA CATALINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (184, 4, true, NULL, NULL, NULL, NULL, 'SANTA ROSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (185, 4, true, NULL, NULL, NULL, NULL, 'SANTA ROSA DEL SUR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (186, 4, true, NULL, NULL, NULL, NULL, 'SIMITI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (187, 4, true, NULL, NULL, NULL, NULL, 'SOPLAVIENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (188, 4, true, NULL, NULL, NULL, NULL, 'TALAIGUA NUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (189, 4, true, NULL, NULL, NULL, NULL, 'TIQUISIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (190, 4, true, NULL, NULL, NULL, NULL, 'TURBACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (191, 4, true, NULL, NULL, NULL, NULL, 'TURBANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (192, 4, true, NULL, NULL, NULL, NULL, 'VILLANUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (193, 4, true, NULL, NULL, NULL, NULL, 'ZAMBRANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (194, 5, true, NULL, NULL, NULL, NULL, 'TUNJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (195, 5, true, NULL, NULL, NULL, NULL, 'ALMEIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (196, 5, true, NULL, NULL, NULL, NULL, 'AQUITANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (197, 5, true, NULL, NULL, NULL, NULL, 'ARCABUCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (198, 5, true, NULL, NULL, NULL, NULL, 'BELEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (199, 5, true, NULL, NULL, NULL, NULL, 'BERBEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (200, 5, true, NULL, NULL, NULL, NULL, 'BETEITIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (201, 5, true, NULL, NULL, NULL, NULL, 'BOAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (202, 5, true, NULL, NULL, NULL, NULL, 'BOYACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (203, 5, true, NULL, NULL, NULL, NULL, 'BRICEÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (204, 5, true, NULL, NULL, NULL, NULL, 'BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (205, 5, true, NULL, NULL, NULL, NULL, 'BUSBANZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (206, 5, true, NULL, NULL, NULL, NULL, 'CALDAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (207, 5, true, NULL, NULL, NULL, NULL, 'CAMPOHERMOSO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (208, 5, true, NULL, NULL, NULL, NULL, 'CERINZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (209, 5, true, NULL, NULL, NULL, NULL, 'CHINAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (210, 5, true, NULL, NULL, NULL, NULL, 'CHIQUINQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (211, 5, true, NULL, NULL, NULL, NULL, 'CHISCAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (212, 5, true, NULL, NULL, NULL, NULL, 'CHITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (213, 5, true, NULL, NULL, NULL, NULL, 'CHITARAQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (214, 5, true, NULL, NULL, NULL, NULL, 'CHIVATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (215, 5, true, NULL, NULL, NULL, NULL, 'CIENEGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (216, 5, true, NULL, NULL, NULL, NULL, 'COMBITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (217, 5, true, NULL, NULL, NULL, NULL, 'COPER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (218, 5, true, NULL, NULL, NULL, NULL, 'CORRALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (219, 5, true, NULL, NULL, NULL, NULL, 'COVARACHIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (220, 5, true, NULL, NULL, NULL, NULL, 'CUBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (221, 5, true, NULL, NULL, NULL, NULL, 'CUCAITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (222, 5, true, NULL, NULL, NULL, NULL, 'CUITIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (223, 5, true, NULL, NULL, NULL, NULL, 'CHIQUIZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (224, 5, true, NULL, NULL, NULL, NULL, 'CHIVOR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (225, 5, true, NULL, NULL, NULL, NULL, 'DUITAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (226, 5, true, NULL, NULL, NULL, NULL, 'EL COCUY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (227, 5, true, NULL, NULL, NULL, NULL, 'EL ESPINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (228, 5, true, NULL, NULL, NULL, NULL, 'FIRAVITOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (229, 5, true, NULL, NULL, NULL, NULL, 'FLORESTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (230, 5, true, NULL, NULL, NULL, NULL, 'GACHANTIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (231, 5, true, NULL, NULL, NULL, NULL, 'GAMEZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (232, 5, true, NULL, NULL, NULL, NULL, 'GARAGOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (233, 5, true, NULL, NULL, NULL, NULL, 'GUACAMAYAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (234, 5, true, NULL, NULL, NULL, NULL, 'GUATEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (235, 5, true, NULL, NULL, NULL, NULL, 'GUAYATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (236, 5, true, NULL, NULL, NULL, NULL, 'GsICAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (237, 5, true, NULL, NULL, NULL, NULL, 'IZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (238, 5, true, NULL, NULL, NULL, NULL, 'JENESANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (239, 5, true, NULL, NULL, NULL, NULL, 'JERICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (240, 5, true, NULL, NULL, NULL, NULL, 'LABRANZAGRANDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (241, 5, true, NULL, NULL, NULL, NULL, 'LA CAPILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (242, 5, true, NULL, NULL, NULL, NULL, 'LA VICTORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (243, 5, true, NULL, NULL, NULL, NULL, 'LA UVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (244, 5, true, NULL, NULL, NULL, NULL, 'VILLA DE LEYVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (245, 5, true, NULL, NULL, NULL, NULL, 'MACANAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (246, 5, true, NULL, NULL, NULL, NULL, 'MARIPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (247, 5, true, NULL, NULL, NULL, NULL, 'MIRAFLORES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (248, 5, true, NULL, NULL, NULL, NULL, 'MONGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (249, 5, true, NULL, NULL, NULL, NULL, 'MONGUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (250, 5, true, NULL, NULL, NULL, NULL, 'MONIQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (251, 5, true, NULL, NULL, NULL, NULL, 'MOTAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (252, 5, true, NULL, NULL, NULL, NULL, 'MUZO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (253, 5, true, NULL, NULL, NULL, NULL, 'NOBSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (254, 5, true, NULL, NULL, NULL, NULL, 'NUEVO COLON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (255, 5, true, NULL, NULL, NULL, NULL, 'OICATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (256, 5, true, NULL, NULL, NULL, NULL, 'OTANCHE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (257, 5, true, NULL, NULL, NULL, NULL, 'PACHAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (258, 5, true, NULL, NULL, NULL, NULL, 'PAEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (259, 5, true, NULL, NULL, NULL, NULL, 'PAIPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (260, 5, true, NULL, NULL, NULL, NULL, 'PAJARITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (261, 5, true, NULL, NULL, NULL, NULL, 'PANQUEBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (262, 5, true, NULL, NULL, NULL, NULL, 'PAUNA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (263, 5, true, NULL, NULL, NULL, NULL, 'PAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (264, 5, true, NULL, NULL, NULL, NULL, 'PAZ DE RIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (265, 5, true, NULL, NULL, NULL, NULL, 'PESCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (266, 5, true, NULL, NULL, NULL, NULL, 'PISBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (267, 5, true, NULL, NULL, NULL, NULL, 'PUERTO BOYACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (268, 5, true, NULL, NULL, NULL, NULL, 'QUIPAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (269, 5, true, NULL, NULL, NULL, NULL, 'RAMIRIQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (270, 5, true, NULL, NULL, NULL, NULL, 'RAQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (271, 5, true, NULL, NULL, NULL, NULL, 'RONDON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (272, 5, true, NULL, NULL, NULL, NULL, 'SABOYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (273, 5, true, NULL, NULL, NULL, NULL, 'SACHICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (274, 5, true, NULL, NULL, NULL, NULL, 'SAMACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (275, 5, true, NULL, NULL, NULL, NULL, 'SAN EDUARDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (276, 5, true, NULL, NULL, NULL, NULL, 'SAN JOSE DE PARE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (277, 5, true, NULL, NULL, NULL, NULL, 'SAN LUIS DE GACENO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (278, 5, true, NULL, NULL, NULL, NULL, 'SAN MATEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (279, 5, true, NULL, NULL, NULL, NULL, 'SAN MIGUEL DE SEMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (280, 5, true, NULL, NULL, NULL, NULL, 'SAN PABLO DE BORBUR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (281, 5, true, NULL, NULL, NULL, NULL, 'SANTANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (282, 5, true, NULL, NULL, NULL, NULL, 'SANTA MARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (283, 5, true, NULL, NULL, NULL, NULL, 'SANTA ROSA DE VITERBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (284, 5, true, NULL, NULL, NULL, NULL, 'SANTA SOFIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (285, 5, true, NULL, NULL, NULL, NULL, 'SATIVANORTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (286, 5, true, NULL, NULL, NULL, NULL, 'SATIVASUR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (287, 5, true, NULL, NULL, NULL, NULL, 'SIACHOQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (288, 5, true, NULL, NULL, NULL, NULL, 'SOATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (289, 5, true, NULL, NULL, NULL, NULL, 'SOCOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (290, 5, true, NULL, NULL, NULL, NULL, 'SOCHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (291, 5, true, NULL, NULL, NULL, NULL, 'SOGAMOSO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (292, 5, true, NULL, NULL, NULL, NULL, 'SOMONDOCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (293, 5, true, NULL, NULL, NULL, NULL, 'SORA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (294, 5, true, NULL, NULL, NULL, NULL, 'SOTAQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (295, 5, true, NULL, NULL, NULL, NULL, 'SORACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (296, 5, true, NULL, NULL, NULL, NULL, 'SUSACON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (297, 5, true, NULL, NULL, NULL, NULL, 'SUTAMARCHAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (298, 5, true, NULL, NULL, NULL, NULL, 'SUTATENZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (299, 5, true, NULL, NULL, NULL, NULL, 'TASCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (300, 5, true, NULL, NULL, NULL, NULL, 'TENZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (301, 5, true, NULL, NULL, NULL, NULL, 'TIBANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (302, 5, true, NULL, NULL, NULL, NULL, 'TIBASOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (303, 5, true, NULL, NULL, NULL, NULL, 'TINJACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (304, 5, true, NULL, NULL, NULL, NULL, 'TIPACOQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (305, 5, true, NULL, NULL, NULL, NULL, 'TOCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (306, 5, true, NULL, NULL, NULL, NULL, 'TOGsI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (307, 5, true, NULL, NULL, NULL, NULL, 'TOPAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (308, 5, true, NULL, NULL, NULL, NULL, 'TOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (309, 5, true, NULL, NULL, NULL, NULL, 'TUNUNGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (310, 5, true, NULL, NULL, NULL, NULL, 'TURMEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (311, 5, true, NULL, NULL, NULL, NULL, 'TUTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (312, 5, true, NULL, NULL, NULL, NULL, 'TUTAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (313, 5, true, NULL, NULL, NULL, NULL, 'UMBITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (314, 5, true, NULL, NULL, NULL, NULL, 'VENTAQUEMADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (315, 5, true, NULL, NULL, NULL, NULL, 'VIRACACHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (316, 5, true, NULL, NULL, NULL, NULL, 'ZETAQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (317, 6, true, NULL, NULL, NULL, NULL, 'MANIZALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (318, 6, true, NULL, NULL, NULL, NULL, 'AGUADAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (319, 6, true, NULL, NULL, NULL, NULL, 'ANSERMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (320, 6, true, NULL, NULL, NULL, NULL, 'ARANZAZU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (321, 6, true, NULL, NULL, NULL, NULL, 'BELALCAZAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (322, 6, true, NULL, NULL, NULL, NULL, 'CHINCHINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (323, 6, true, NULL, NULL, NULL, NULL, 'FILADELFIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (324, 6, true, NULL, NULL, NULL, NULL, 'LA DORADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (325, 6, true, NULL, NULL, NULL, NULL, 'LA MERCED', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (326, 6, true, NULL, NULL, NULL, NULL, 'MANZANARES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (327, 6, true, NULL, NULL, NULL, NULL, 'MARMATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (328, 6, true, NULL, NULL, NULL, NULL, 'MARQUETALIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (329, 6, true, NULL, NULL, NULL, NULL, 'MARULANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (330, 6, true, NULL, NULL, NULL, NULL, 'NEIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (331, 6, true, NULL, NULL, NULL, NULL, 'NORCASIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (332, 6, true, NULL, NULL, NULL, NULL, 'PACORA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (333, 6, true, NULL, NULL, NULL, NULL, 'PALESTINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (334, 6, true, NULL, NULL, NULL, NULL, 'PENSILVANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (335, 6, true, NULL, NULL, NULL, NULL, 'RIOSUCIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (336, 6, true, NULL, NULL, NULL, NULL, 'RISARALDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (337, 6, true, NULL, NULL, NULL, NULL, 'SALAMINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (338, 6, true, NULL, NULL, NULL, NULL, 'SAMANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (339, 6, true, NULL, NULL, NULL, NULL, 'SAN JOSE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (340, 6, true, NULL, NULL, NULL, NULL, 'SUPIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (341, 6, true, NULL, NULL, NULL, NULL, 'VICTORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (342, 6, true, NULL, NULL, NULL, NULL, 'VILLAMARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (343, 6, true, NULL, NULL, NULL, NULL, 'VITERBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (344, 7, true, NULL, NULL, NULL, NULL, 'FLORENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (345, 7, true, NULL, NULL, NULL, NULL, 'ALBANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (346, 7, true, NULL, NULL, NULL, NULL, 'BELEN DE LOS ANDAQUIES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (347, 7, true, NULL, NULL, NULL, NULL, 'CARTAGENA DEL CHAIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (348, 7, true, NULL, NULL, NULL, NULL, 'CURILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (349, 7, true, NULL, NULL, NULL, NULL, 'EL DONCELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (350, 7, true, NULL, NULL, NULL, NULL, 'EL PAUJIL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (351, 7, true, NULL, NULL, NULL, NULL, 'LA MONTAÑITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (352, 7, true, NULL, NULL, NULL, NULL, 'MILAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (353, 7, true, NULL, NULL, NULL, NULL, 'MORELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (354, 7, true, NULL, NULL, NULL, NULL, 'PUERTO RICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (355, 7, true, NULL, NULL, NULL, NULL, 'SAN JOSE DEL FRAGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (356, 7, true, NULL, NULL, NULL, NULL, 'SAN VICENTE DEL CAGUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (357, 7, true, NULL, NULL, NULL, NULL, 'SOLANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (358, 7, true, NULL, NULL, NULL, NULL, 'SOLITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (359, 7, true, NULL, NULL, NULL, NULL, 'VALPARAISO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (360, 8, true, NULL, NULL, NULL, NULL, 'POPAYAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (361, 8, true, NULL, NULL, NULL, NULL, 'ALMAGUER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (362, 8, true, NULL, NULL, NULL, NULL, 'ARGELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (363, 8, true, NULL, NULL, NULL, NULL, 'BALBOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (364, 8, true, NULL, NULL, NULL, NULL, 'BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (365, 8, true, NULL, NULL, NULL, NULL, 'BUENOS AIRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (366, 8, true, NULL, NULL, NULL, NULL, 'CAJIBIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (367, 8, true, NULL, NULL, NULL, NULL, 'CALDONO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (368, 8, true, NULL, NULL, NULL, NULL, 'CALOTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (369, 8, true, NULL, NULL, NULL, NULL, 'CORINTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (370, 8, true, NULL, NULL, NULL, NULL, 'EL TAMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (371, 8, true, NULL, NULL, NULL, NULL, 'FLORENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (372, 8, true, NULL, NULL, NULL, NULL, 'GUAPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (373, 8, true, NULL, NULL, NULL, NULL, 'INZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (374, 8, true, NULL, NULL, NULL, NULL, 'JAMBALO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (375, 8, true, NULL, NULL, NULL, NULL, 'LA SIERRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (376, 8, true, NULL, NULL, NULL, NULL, 'LA VEGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (377, 8, true, NULL, NULL, NULL, NULL, 'LOPEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (378, 8, true, NULL, NULL, NULL, NULL, 'MERCADERES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (379, 8, true, NULL, NULL, NULL, NULL, 'MIRANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (380, 8, true, NULL, NULL, NULL, NULL, 'MORALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (381, 8, true, NULL, NULL, NULL, NULL, 'PADILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (382, 8, true, NULL, NULL, NULL, NULL, 'PAEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (383, 8, true, NULL, NULL, NULL, NULL, 'PATIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (384, 8, true, NULL, NULL, NULL, NULL, 'PIAMONTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (385, 8, true, NULL, NULL, NULL, NULL, 'PIENDAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (386, 8, true, NULL, NULL, NULL, NULL, 'PUERTO TEJADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (387, 8, true, NULL, NULL, NULL, NULL, 'PURACE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (388, 8, true, NULL, NULL, NULL, NULL, 'ROSAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (389, 8, true, NULL, NULL, NULL, NULL, 'SAN SEBASTIAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (390, 8, true, NULL, NULL, NULL, NULL, 'SANTANDER DE QUILICHAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (391, 8, true, NULL, NULL, NULL, NULL, 'SANTA ROSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (392, 8, true, NULL, NULL, NULL, NULL, 'SILVIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (393, 8, true, NULL, NULL, NULL, NULL, 'SOTARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (394, 8, true, NULL, NULL, NULL, NULL, 'SUAREZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (395, 8, true, NULL, NULL, NULL, NULL, 'SUCRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (396, 8, true, NULL, NULL, NULL, NULL, 'TIMBIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (397, 8, true, NULL, NULL, NULL, NULL, 'TIMBIQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (398, 8, true, NULL, NULL, NULL, NULL, 'TORIBIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (399, 8, true, NULL, NULL, NULL, NULL, 'TOTORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (400, 8, true, NULL, NULL, NULL, NULL, 'VILLA RICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (401, 9, true, NULL, NULL, NULL, NULL, 'VALLEDUPAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (402, 9, true, NULL, NULL, NULL, NULL, 'AGUACHICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (403, 9, true, NULL, NULL, NULL, NULL, 'AGUSTIN CODAZZI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (404, 9, true, NULL, NULL, NULL, NULL, 'ASTREA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (405, 9, true, NULL, NULL, NULL, NULL, 'BECERRIL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (406, 9, true, NULL, NULL, NULL, NULL, 'BOSCONIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (407, 9, true, NULL, NULL, NULL, NULL, 'CHIMICHAGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (408, 9, true, NULL, NULL, NULL, NULL, 'CHIRIGUANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (409, 9, true, NULL, NULL, NULL, NULL, 'CURUMANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (410, 9, true, NULL, NULL, NULL, NULL, 'EL COPEY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (411, 9, true, NULL, NULL, NULL, NULL, 'EL PASO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (412, 9, true, NULL, NULL, NULL, NULL, 'GAMARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (413, 9, true, NULL, NULL, NULL, NULL, 'GONZALEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (414, 9, true, NULL, NULL, NULL, NULL, 'LA GLORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (415, 9, true, NULL, NULL, NULL, NULL, 'LA JAGUA DE IBIRICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (416, 9, true, NULL, NULL, NULL, NULL, 'MANAURE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (417, 9, true, NULL, NULL, NULL, NULL, 'PAILITAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (418, 9, true, NULL, NULL, NULL, NULL, 'PELAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (419, 9, true, NULL, NULL, NULL, NULL, 'PUEBLO BELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (420, 9, true, NULL, NULL, NULL, NULL, 'RIO DE ORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (421, 9, true, NULL, NULL, NULL, NULL, 'LA PAZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (422, 9, true, NULL, NULL, NULL, NULL, 'SAN ALBERTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (423, 9, true, NULL, NULL, NULL, NULL, 'SAN DIEGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (424, 9, true, NULL, NULL, NULL, NULL, 'SAN MARTIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (425, 9, true, NULL, NULL, NULL, NULL, 'TAMALAMEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (426, 10, true, NULL, NULL, NULL, NULL, 'MONTERIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (427, 10, true, NULL, NULL, NULL, NULL, 'AYAPEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (428, 10, true, NULL, NULL, NULL, NULL, 'BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (429, 10, true, NULL, NULL, NULL, NULL, 'CANALETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (430, 10, true, NULL, NULL, NULL, NULL, 'CERETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (431, 10, true, NULL, NULL, NULL, NULL, 'CHIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (432, 10, true, NULL, NULL, NULL, NULL, 'CHINU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (433, 10, true, NULL, NULL, NULL, NULL, 'CIENAGA DE ORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (434, 10, true, NULL, NULL, NULL, NULL, 'COTORRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (435, 10, true, NULL, NULL, NULL, NULL, 'LA APARTADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (436, 10, true, NULL, NULL, NULL, NULL, 'LORICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (437, 10, true, NULL, NULL, NULL, NULL, 'LOS CORDOBAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (438, 10, true, NULL, NULL, NULL, NULL, 'MOMIL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (439, 10, true, NULL, NULL, NULL, NULL, 'MONTELIBANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (440, 10, true, NULL, NULL, NULL, NULL, 'MOÑITOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (441, 10, true, NULL, NULL, NULL, NULL, 'PLANETA RICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (442, 10, true, NULL, NULL, NULL, NULL, 'PUEBLO NUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (443, 10, true, NULL, NULL, NULL, NULL, 'PUERTO ESCONDIDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (444, 10, true, NULL, NULL, NULL, NULL, 'PUERTO LIBERTADOR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (445, 10, true, NULL, NULL, NULL, NULL, 'PURISIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (446, 10, true, NULL, NULL, NULL, NULL, 'SAHAGUN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (447, 10, true, NULL, NULL, NULL, NULL, 'SAN ANDRES SOTAVENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (448, 10, true, NULL, NULL, NULL, NULL, 'SAN ANTERO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (449, 10, true, NULL, NULL, NULL, NULL, 'SAN BERNARDO DEL VIENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (450, 10, true, NULL, NULL, NULL, NULL, 'SAN CARLOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (451, 10, true, NULL, NULL, NULL, NULL, 'SAN PELAYO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (452, 10, true, NULL, NULL, NULL, NULL, 'TIERRALTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (453, 10, true, NULL, NULL, NULL, NULL, 'VALENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (454, 11, true, NULL, NULL, NULL, NULL, 'AGUA DE DIOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (455, 11, true, NULL, NULL, NULL, NULL, 'ALBAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (456, 11, true, NULL, NULL, NULL, NULL, 'ANAPOIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (457, 11, true, NULL, NULL, NULL, NULL, 'ANOLAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (458, 11, true, NULL, NULL, NULL, NULL, 'ARBELAEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (459, 11, true, NULL, NULL, NULL, NULL, 'BELTRAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (460, 11, true, NULL, NULL, NULL, NULL, 'BITUIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (461, 11, true, NULL, NULL, NULL, NULL, 'BOJACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (462, 11, true, NULL, NULL, NULL, NULL, 'CABRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (463, 11, true, NULL, NULL, NULL, NULL, 'CACHIPAY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (464, 11, true, NULL, NULL, NULL, NULL, 'CAJICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (465, 11, true, NULL, NULL, NULL, NULL, 'CAPARRAPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (466, 11, true, NULL, NULL, NULL, NULL, 'CAQUEZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (467, 11, true, NULL, NULL, NULL, NULL, 'CARMEN DE CARUPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (468, 11, true, NULL, NULL, NULL, NULL, 'CHAGUANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (469, 11, true, NULL, NULL, NULL, NULL, 'CHIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (470, 11, true, NULL, NULL, NULL, NULL, 'CHIPAQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (471, 11, true, NULL, NULL, NULL, NULL, 'CHOACHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (472, 11, true, NULL, NULL, NULL, NULL, 'CHOCONTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (473, 11, true, NULL, NULL, NULL, NULL, 'COGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (474, 11, true, NULL, NULL, NULL, NULL, 'COTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (475, 11, true, NULL, NULL, NULL, NULL, 'CUCUNUBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (476, 11, true, NULL, NULL, NULL, NULL, 'EL COLEGIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (477, 11, true, NULL, NULL, NULL, NULL, 'EL PEÑON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (478, 11, true, NULL, NULL, NULL, NULL, 'EL ROSAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (479, 11, true, NULL, NULL, NULL, NULL, 'FACATATIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (480, 11, true, NULL, NULL, NULL, NULL, 'FOMEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (481, 11, true, NULL, NULL, NULL, NULL, 'FOSCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (482, 11, true, NULL, NULL, NULL, NULL, 'FUNZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (483, 11, true, NULL, NULL, NULL, NULL, 'FUQUENE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (484, 11, true, NULL, NULL, NULL, NULL, 'FUSAGASUGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (485, 11, true, NULL, NULL, NULL, NULL, 'GACHALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (486, 11, true, NULL, NULL, NULL, NULL, 'GACHANCIPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (487, 11, true, NULL, NULL, NULL, NULL, 'GACHETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (488, 11, true, NULL, NULL, NULL, NULL, 'GAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (489, 11, true, NULL, NULL, NULL, NULL, 'GIRARDOT', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (490, 11, true, NULL, NULL, NULL, NULL, 'GRANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (491, 11, true, NULL, NULL, NULL, NULL, 'GUACHETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (492, 11, true, NULL, NULL, NULL, NULL, 'GUADUAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (493, 11, true, NULL, NULL, NULL, NULL, 'GUASCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (494, 11, true, NULL, NULL, NULL, NULL, 'GUATAQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (495, 11, true, NULL, NULL, NULL, NULL, 'GUATAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (496, 11, true, NULL, NULL, NULL, NULL, 'GUAYABAL DE SIQUIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (497, 11, true, NULL, NULL, NULL, NULL, 'GUAYABETAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (498, 11, true, NULL, NULL, NULL, NULL, 'GUTIERREZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (499, 11, true, NULL, NULL, NULL, NULL, 'JERUSALEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (500, 11, true, NULL, NULL, NULL, NULL, 'JUNIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (501, 11, true, NULL, NULL, NULL, NULL, 'LA CALERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (502, 11, true, NULL, NULL, NULL, NULL, 'LA MESA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (503, 11, true, NULL, NULL, NULL, NULL, 'LA PALMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (504, 11, true, NULL, NULL, NULL, NULL, 'LA PEÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (505, 11, true, NULL, NULL, NULL, NULL, 'LA VEGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (506, 11, true, NULL, NULL, NULL, NULL, 'LENGUAZAQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (507, 11, true, NULL, NULL, NULL, NULL, 'MACHETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (508, 11, true, NULL, NULL, NULL, NULL, 'MADRID', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (509, 11, true, NULL, NULL, NULL, NULL, 'MANTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (510, 11, true, NULL, NULL, NULL, NULL, 'MEDINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (511, 11, true, NULL, NULL, NULL, NULL, 'MOSQUERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (512, 11, true, NULL, NULL, NULL, NULL, 'NARIÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (513, 11, true, NULL, NULL, NULL, NULL, 'NEMOCON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (514, 11, true, NULL, NULL, NULL, NULL, 'NILO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (515, 11, true, NULL, NULL, NULL, NULL, 'NIMAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (516, 11, true, NULL, NULL, NULL, NULL, 'NOCAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (517, 11, true, NULL, NULL, NULL, NULL, 'VENECIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (518, 11, true, NULL, NULL, NULL, NULL, 'PACHO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (519, 11, true, NULL, NULL, NULL, NULL, 'PAIME', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (520, 11, true, NULL, NULL, NULL, NULL, 'PANDI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (521, 11, true, NULL, NULL, NULL, NULL, 'PARATEBUENO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (522, 11, true, NULL, NULL, NULL, NULL, 'PASCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (523, 11, true, NULL, NULL, NULL, NULL, 'PUERTO SALGAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (524, 11, true, NULL, NULL, NULL, NULL, 'PULI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (525, 11, true, NULL, NULL, NULL, NULL, 'QUEBRADANEGRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (526, 11, true, NULL, NULL, NULL, NULL, 'QUETAME', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (527, 11, true, NULL, NULL, NULL, NULL, 'QUIPILE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (528, 11, true, NULL, NULL, NULL, NULL, 'APULO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (529, 11, true, NULL, NULL, NULL, NULL, 'RICAURTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (530, 11, true, NULL, NULL, NULL, NULL, 'SAN ANTONIO DEL TEQUENDAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (531, 11, true, NULL, NULL, NULL, NULL, 'SAN BERNARDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (532, 11, true, NULL, NULL, NULL, NULL, 'SAN CAYETANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (533, 11, true, NULL, NULL, NULL, NULL, 'SAN FRANCISCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (534, 11, true, NULL, NULL, NULL, NULL, 'SAN JUAN DE RIO SECO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (535, 11, true, NULL, NULL, NULL, NULL, 'SASAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (536, 11, true, NULL, NULL, NULL, NULL, 'SESQUILE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (537, 11, true, NULL, NULL, NULL, NULL, 'SIBATE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (538, 11, true, NULL, NULL, NULL, NULL, 'SILVANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (539, 11, true, NULL, NULL, NULL, NULL, 'SIMIJACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (540, 11, true, NULL, NULL, NULL, NULL, 'SOACHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (541, 11, true, NULL, NULL, NULL, NULL, 'SOPO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (542, 11, true, NULL, NULL, NULL, NULL, 'SUBACHOQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (543, 11, true, NULL, NULL, NULL, NULL, 'SUESCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (544, 11, true, NULL, NULL, NULL, NULL, 'SUPATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (545, 11, true, NULL, NULL, NULL, NULL, 'SUSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (546, 11, true, NULL, NULL, NULL, NULL, 'SUTATAUSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (547, 11, true, NULL, NULL, NULL, NULL, 'TABIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (548, 11, true, NULL, NULL, NULL, NULL, 'TAUSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (549, 11, true, NULL, NULL, NULL, NULL, 'TENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (550, 11, true, NULL, NULL, NULL, NULL, 'TENJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (551, 11, true, NULL, NULL, NULL, NULL, 'TIBACUY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (552, 11, true, NULL, NULL, NULL, NULL, 'TIBIRITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (553, 11, true, NULL, NULL, NULL, NULL, 'TOCAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (554, 11, true, NULL, NULL, NULL, NULL, 'TOCANCIPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (555, 11, true, NULL, NULL, NULL, NULL, 'TOPAIPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (556, 11, true, NULL, NULL, NULL, NULL, 'UBALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (557, 11, true, NULL, NULL, NULL, NULL, 'UBAQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (558, 11, true, NULL, NULL, NULL, NULL, 'VILLA DE SAN DIEGO DE UBATE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (559, 11, true, NULL, NULL, NULL, NULL, 'UNE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (560, 11, true, NULL, NULL, NULL, NULL, 'UTICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (561, 11, true, NULL, NULL, NULL, NULL, 'VERGARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (562, 11, true, NULL, NULL, NULL, NULL, 'VIANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (563, 11, true, NULL, NULL, NULL, NULL, 'VILLAGOMEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (564, 11, true, NULL, NULL, NULL, NULL, 'VILLAPINZON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (565, 11, true, NULL, NULL, NULL, NULL, 'VILLETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (566, 11, true, NULL, NULL, NULL, NULL, 'VIOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (567, 11, true, NULL, NULL, NULL, NULL, 'YACOPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (568, 11, true, NULL, NULL, NULL, NULL, 'ZIPACON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (569, 11, true, NULL, NULL, NULL, NULL, 'ZIPAQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (570, 12, true, NULL, NULL, NULL, NULL, 'QUIBDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (571, 12, true, NULL, NULL, NULL, NULL, 'ACANDI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (572, 12, true, NULL, NULL, NULL, NULL, 'ALTO BAUDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (573, 12, true, NULL, NULL, NULL, NULL, 'ATRATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (574, 12, true, NULL, NULL, NULL, NULL, 'BAGADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (575, 12, true, NULL, NULL, NULL, NULL, 'BAHIA SOLANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (576, 12, true, NULL, NULL, NULL, NULL, 'BAJO BAUDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (577, 12, true, NULL, NULL, NULL, NULL, 'BELEN DE BAJIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (578, 12, true, NULL, NULL, NULL, NULL, 'BOJAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (579, 12, true, NULL, NULL, NULL, NULL, 'EL CANTON DEL SAN PABLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (580, 12, true, NULL, NULL, NULL, NULL, 'CARMEN DEL DARIEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (581, 12, true, NULL, NULL, NULL, NULL, 'CERTEGUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (582, 12, true, NULL, NULL, NULL, NULL, 'CONDOTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (583, 12, true, NULL, NULL, NULL, NULL, 'EL CARMEN DE ATRATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (584, 12, true, NULL, NULL, NULL, NULL, 'EL LITORAL DEL SAN JUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (585, 12, true, NULL, NULL, NULL, NULL, 'ISTMINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (586, 12, true, NULL, NULL, NULL, NULL, 'JURADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (587, 12, true, NULL, NULL, NULL, NULL, 'LLORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (588, 12, true, NULL, NULL, NULL, NULL, 'MEDIO ATRATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (589, 12, true, NULL, NULL, NULL, NULL, 'MEDIO BAUDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (590, 12, true, NULL, NULL, NULL, NULL, 'MEDIO SAN JUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (591, 12, true, NULL, NULL, NULL, NULL, 'NOVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (592, 12, true, NULL, NULL, NULL, NULL, 'NUQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (593, 12, true, NULL, NULL, NULL, NULL, 'RIO IRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (594, 12, true, NULL, NULL, NULL, NULL, 'RIO QUITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (595, 12, true, NULL, NULL, NULL, NULL, 'RIOSUCIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (596, 12, true, NULL, NULL, NULL, NULL, 'SAN JOSE DEL PALMAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (597, 12, true, NULL, NULL, NULL, NULL, 'SIPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (598, 12, true, NULL, NULL, NULL, NULL, 'TADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (599, 12, true, NULL, NULL, NULL, NULL, 'UNGUIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (600, 12, true, NULL, NULL, NULL, NULL, 'UNION PANAMERICANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (601, 13, true, NULL, NULL, NULL, NULL, 'NEIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (602, 13, true, NULL, NULL, NULL, NULL, 'ACEVEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (603, 13, true, NULL, NULL, NULL, NULL, 'AGRADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (604, 13, true, NULL, NULL, NULL, NULL, 'AIPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (605, 13, true, NULL, NULL, NULL, NULL, 'ALGECIRAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (606, 13, true, NULL, NULL, NULL, NULL, 'ALTAMIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (607, 13, true, NULL, NULL, NULL, NULL, 'BARAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (608, 13, true, NULL, NULL, NULL, NULL, 'CAMPOALEGRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (609, 13, true, NULL, NULL, NULL, NULL, 'COLOMBIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (610, 13, true, NULL, NULL, NULL, NULL, 'ELIAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (611, 13, true, NULL, NULL, NULL, NULL, 'GARZON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (612, 13, true, NULL, NULL, NULL, NULL, 'GIGANTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (613, 13, true, NULL, NULL, NULL, NULL, 'GUADALUPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (614, 13, true, NULL, NULL, NULL, NULL, 'HOBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (615, 13, true, NULL, NULL, NULL, NULL, 'IQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (616, 13, true, NULL, NULL, NULL, NULL, 'ISNOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (617, 13, true, NULL, NULL, NULL, NULL, 'LA ARGENTINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (618, 13, true, NULL, NULL, NULL, NULL, 'LA PLATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (619, 13, true, NULL, NULL, NULL, NULL, 'NATAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (620, 13, true, NULL, NULL, NULL, NULL, 'OPORAPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (621, 13, true, NULL, NULL, NULL, NULL, 'PAICOL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (622, 13, true, NULL, NULL, NULL, NULL, 'PALERMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (623, 13, true, NULL, NULL, NULL, NULL, 'PALESTINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (624, 13, true, NULL, NULL, NULL, NULL, 'PITAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (625, 13, true, NULL, NULL, NULL, NULL, 'PITALITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (626, 13, true, NULL, NULL, NULL, NULL, 'RIVERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (627, 13, true, NULL, NULL, NULL, NULL, 'SALADOBLANCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (628, 13, true, NULL, NULL, NULL, NULL, 'SAN AGUSTIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (629, 13, true, NULL, NULL, NULL, NULL, 'SANTA MARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (630, 13, true, NULL, NULL, NULL, NULL, 'SUAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (631, 13, true, NULL, NULL, NULL, NULL, 'TARQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (632, 13, true, NULL, NULL, NULL, NULL, 'TESALIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (633, 13, true, NULL, NULL, NULL, NULL, 'TELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (634, 13, true, NULL, NULL, NULL, NULL, 'TERUEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (635, 13, true, NULL, NULL, NULL, NULL, 'TIMANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (636, 13, true, NULL, NULL, NULL, NULL, 'VILLAVIEJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (637, 13, true, NULL, NULL, NULL, NULL, 'YAGUARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (638, 14, true, NULL, NULL, NULL, NULL, 'RIOHACHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (639, 14, true, NULL, NULL, NULL, NULL, 'ALBANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (640, 14, true, NULL, NULL, NULL, NULL, 'BARRANCAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (641, 14, true, NULL, NULL, NULL, NULL, 'DIBULLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (642, 14, true, NULL, NULL, NULL, NULL, 'DISTRACCION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (643, 14, true, NULL, NULL, NULL, NULL, 'EL MOLINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (644, 14, true, NULL, NULL, NULL, NULL, 'FONSECA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (645, 14, true, NULL, NULL, NULL, NULL, 'HATONUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (646, 14, true, NULL, NULL, NULL, NULL, 'LA JAGUA DEL PILAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (647, 14, true, NULL, NULL, NULL, NULL, 'MAICAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (648, 14, true, NULL, NULL, NULL, NULL, 'MANAURE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (649, 14, true, NULL, NULL, NULL, NULL, 'SAN JUAN DEL CESAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (650, 14, true, NULL, NULL, NULL, NULL, 'URIBIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (651, 14, true, NULL, NULL, NULL, NULL, 'URUMITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (652, 14, true, NULL, NULL, NULL, NULL, 'VILLANUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (653, 15, true, NULL, NULL, NULL, NULL, 'SANTA MARTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (654, 15, true, NULL, NULL, NULL, NULL, 'ALGARROBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (655, 15, true, NULL, NULL, NULL, NULL, 'ARACATACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (656, 15, true, NULL, NULL, NULL, NULL, 'ARIGUANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (657, 15, true, NULL, NULL, NULL, NULL, 'CERRO SAN ANTONIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (658, 15, true, NULL, NULL, NULL, NULL, 'CHIBOLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (659, 15, true, NULL, NULL, NULL, NULL, 'CIENAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (660, 15, true, NULL, NULL, NULL, NULL, 'CONCORDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (661, 15, true, NULL, NULL, NULL, NULL, 'EL BANCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (662, 15, true, NULL, NULL, NULL, NULL, 'EL PIÑON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (663, 15, true, NULL, NULL, NULL, NULL, 'EL RETEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (664, 15, true, NULL, NULL, NULL, NULL, 'FUNDACION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (665, 15, true, NULL, NULL, NULL, NULL, 'GUAMAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (666, 15, true, NULL, NULL, NULL, NULL, 'NUEVA GRANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (667, 15, true, NULL, NULL, NULL, NULL, 'PEDRAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (668, 15, true, NULL, NULL, NULL, NULL, 'PIJIÑO DEL CARMEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (669, 15, true, NULL, NULL, NULL, NULL, 'PIVIJAY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (670, 15, true, NULL, NULL, NULL, NULL, 'PLATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (671, 15, true, NULL, NULL, NULL, NULL, 'PUEBLOVIEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (672, 15, true, NULL, NULL, NULL, NULL, 'REMOLINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (673, 15, true, NULL, NULL, NULL, NULL, 'SABANAS DE SAN ANGEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (674, 15, true, NULL, NULL, NULL, NULL, 'SALAMINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (675, 15, true, NULL, NULL, NULL, NULL, 'SAN SEBASTIAN DE BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (676, 15, true, NULL, NULL, NULL, NULL, 'SAN ZENON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (677, 15, true, NULL, NULL, NULL, NULL, 'SANTA ANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (678, 15, true, NULL, NULL, NULL, NULL, 'SANTA BARBARA DE PINTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (679, 15, true, NULL, NULL, NULL, NULL, 'SITIONUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (680, 15, true, NULL, NULL, NULL, NULL, 'TENERIFE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (681, 15, true, NULL, NULL, NULL, NULL, 'ZAPAYAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (682, 15, true, NULL, NULL, NULL, NULL, 'ZONA BANANERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (683, 16, true, NULL, NULL, NULL, NULL, 'VILLAVICENCIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (684, 16, true, NULL, NULL, NULL, NULL, 'ACACIAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (685, 16, true, NULL, NULL, NULL, NULL, 'BARRANCA DE UPIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (686, 16, true, NULL, NULL, NULL, NULL, 'CABUYARO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (687, 16, true, NULL, NULL, NULL, NULL, 'CASTILLA LA NUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (688, 16, true, NULL, NULL, NULL, NULL, 'CUBARRAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (689, 16, true, NULL, NULL, NULL, NULL, 'CUMARAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (690, 16, true, NULL, NULL, NULL, NULL, 'EL CALVARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (691, 16, true, NULL, NULL, NULL, NULL, 'EL CASTILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (692, 16, true, NULL, NULL, NULL, NULL, 'EL DORADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (693, 16, true, NULL, NULL, NULL, NULL, 'FUENTE DE ORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (694, 16, true, NULL, NULL, NULL, NULL, 'GRANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (695, 16, true, NULL, NULL, NULL, NULL, 'GUAMAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (696, 16, true, NULL, NULL, NULL, NULL, 'MAPIRIPAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (697, 16, true, NULL, NULL, NULL, NULL, 'MESETAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (698, 16, true, NULL, NULL, NULL, NULL, 'LA MACARENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (699, 16, true, NULL, NULL, NULL, NULL, 'URIBE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (700, 16, true, NULL, NULL, NULL, NULL, 'LEJANIAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (701, 16, true, NULL, NULL, NULL, NULL, 'PUERTO CONCORDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (702, 16, true, NULL, NULL, NULL, NULL, 'PUERTO GAITAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (703, 16, true, NULL, NULL, NULL, NULL, 'PUERTO LOPEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (704, 16, true, NULL, NULL, NULL, NULL, 'PUERTO LLERAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (705, 16, true, NULL, NULL, NULL, NULL, 'PUERTO RICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (706, 16, true, NULL, NULL, NULL, NULL, 'RESTREPO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (707, 16, true, NULL, NULL, NULL, NULL, 'SAN CARLOS DE GUAROA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (708, 16, true, NULL, NULL, NULL, NULL, 'SAN JUAN DE ARAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (709, 16, true, NULL, NULL, NULL, NULL, 'SAN JUANITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (710, 16, true, NULL, NULL, NULL, NULL, 'SAN MARTIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (711, 16, true, NULL, NULL, NULL, NULL, 'VISTAHERMOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (712, 17, true, NULL, NULL, NULL, NULL, 'PASTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (713, 17, true, NULL, NULL, NULL, NULL, 'ALBAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (714, 17, true, NULL, NULL, NULL, NULL, 'ALDANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (715, 17, true, NULL, NULL, NULL, NULL, 'ANCUYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (716, 17, true, NULL, NULL, NULL, NULL, 'ARBOLEDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (717, 17, true, NULL, NULL, NULL, NULL, 'BARBACOAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (718, 17, true, NULL, NULL, NULL, NULL, 'BELEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (719, 17, true, NULL, NULL, NULL, NULL, 'BUESACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (720, 17, true, NULL, NULL, NULL, NULL, 'COLON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (721, 17, true, NULL, NULL, NULL, NULL, 'CONSACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (722, 17, true, NULL, NULL, NULL, NULL, 'CONTADERO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (723, 17, true, NULL, NULL, NULL, NULL, 'CORDOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (724, 17, true, NULL, NULL, NULL, NULL, 'CUASPUD', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (725, 17, true, NULL, NULL, NULL, NULL, 'CUMBAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (726, 17, true, NULL, NULL, NULL, NULL, 'CUMBITARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (727, 17, true, NULL, NULL, NULL, NULL, 'CHACHAGsI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (728, 17, true, NULL, NULL, NULL, NULL, 'EL CHARCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (729, 17, true, NULL, NULL, NULL, NULL, 'EL PEÑOL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (730, 17, true, NULL, NULL, NULL, NULL, 'EL ROSARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (731, 17, true, NULL, NULL, NULL, NULL, 'EL TABLON DE GOMEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (732, 17, true, NULL, NULL, NULL, NULL, 'EL TAMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (733, 17, true, NULL, NULL, NULL, NULL, 'FUNES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (734, 17, true, NULL, NULL, NULL, NULL, 'GUACHUCAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (735, 17, true, NULL, NULL, NULL, NULL, 'GUAITARILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (736, 17, true, NULL, NULL, NULL, NULL, 'GUALMATAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (737, 17, true, NULL, NULL, NULL, NULL, 'ILES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (738, 17, true, NULL, NULL, NULL, NULL, 'IMUES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (739, 17, true, NULL, NULL, NULL, NULL, 'IPIALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (740, 17, true, NULL, NULL, NULL, NULL, 'LA CRUZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (741, 17, true, NULL, NULL, NULL, NULL, 'LA FLORIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (742, 17, true, NULL, NULL, NULL, NULL, 'LA LLANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (743, 17, true, NULL, NULL, NULL, NULL, 'LA TOLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (744, 17, true, NULL, NULL, NULL, NULL, 'LA UNION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (745, 17, true, NULL, NULL, NULL, NULL, 'LEIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (746, 17, true, NULL, NULL, NULL, NULL, 'LINARES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (747, 17, true, NULL, NULL, NULL, NULL, 'LOS ANDES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (748, 17, true, NULL, NULL, NULL, NULL, 'MAGsI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (749, 17, true, NULL, NULL, NULL, NULL, 'MALLAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (750, 17, true, NULL, NULL, NULL, NULL, 'MOSQUERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (751, 17, true, NULL, NULL, NULL, NULL, 'NARIÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (752, 17, true, NULL, NULL, NULL, NULL, 'OLAYA HERRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (753, 17, true, NULL, NULL, NULL, NULL, 'OSPINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (754, 17, true, NULL, NULL, NULL, NULL, 'FRANCISCO PIZARRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (755, 17, true, NULL, NULL, NULL, NULL, 'POLICARPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (756, 17, true, NULL, NULL, NULL, NULL, 'POTOSI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (757, 17, true, NULL, NULL, NULL, NULL, 'PROVIDENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (758, 17, true, NULL, NULL, NULL, NULL, 'PUERRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (759, 17, true, NULL, NULL, NULL, NULL, 'PUPIALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (760, 17, true, NULL, NULL, NULL, NULL, 'RICAURTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (761, 17, true, NULL, NULL, NULL, NULL, 'ROBERTO PAYAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (762, 17, true, NULL, NULL, NULL, NULL, 'SAMANIEGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (763, 17, true, NULL, NULL, NULL, NULL, 'SANDONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (764, 17, true, NULL, NULL, NULL, NULL, 'SAN BERNARDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (765, 17, true, NULL, NULL, NULL, NULL, 'SAN LORENZO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (766, 17, true, NULL, NULL, NULL, NULL, 'SAN PABLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (767, 17, true, NULL, NULL, NULL, NULL, 'SAN PEDRO DE CARTAGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (768, 17, true, NULL, NULL, NULL, NULL, 'SANTA BARBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (769, 17, true, NULL, NULL, NULL, NULL, 'SANTACRUZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (770, 17, true, NULL, NULL, NULL, NULL, 'SAPUYES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (771, 17, true, NULL, NULL, NULL, NULL, 'TAMINANGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (772, 17, true, NULL, NULL, NULL, NULL, 'TANGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (773, 17, true, NULL, NULL, NULL, NULL, 'SAN ANDRES DE TUMACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (774, 17, true, NULL, NULL, NULL, NULL, 'TUQUERRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (775, 17, true, NULL, NULL, NULL, NULL, 'YACUANQUER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (776, 18, true, NULL, NULL, NULL, NULL, 'CUCUTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (777, 18, true, NULL, NULL, NULL, NULL, 'ABREGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (778, 18, true, NULL, NULL, NULL, NULL, 'ARBOLEDAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (779, 18, true, NULL, NULL, NULL, NULL, 'BOCHALEMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (780, 18, true, NULL, NULL, NULL, NULL, 'BUCARASICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (781, 18, true, NULL, NULL, NULL, NULL, 'CACOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (782, 18, true, NULL, NULL, NULL, NULL, 'CACHIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (783, 18, true, NULL, NULL, NULL, NULL, 'CHINACOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (784, 18, true, NULL, NULL, NULL, NULL, 'CHITAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (785, 18, true, NULL, NULL, NULL, NULL, 'CONVENCION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (786, 18, true, NULL, NULL, NULL, NULL, 'CUCUTILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (787, 18, true, NULL, NULL, NULL, NULL, 'DURANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (788, 18, true, NULL, NULL, NULL, NULL, 'EL CARMEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (789, 18, true, NULL, NULL, NULL, NULL, 'EL TARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (790, 18, true, NULL, NULL, NULL, NULL, 'EL ZULIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (791, 18, true, NULL, NULL, NULL, NULL, 'GRAMALOTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (792, 18, true, NULL, NULL, NULL, NULL, 'HACARI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (793, 18, true, NULL, NULL, NULL, NULL, 'HERRAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (794, 18, true, NULL, NULL, NULL, NULL, 'LABATECA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (795, 18, true, NULL, NULL, NULL, NULL, 'LA ESPERANZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (796, 18, true, NULL, NULL, NULL, NULL, 'LA PLAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (797, 18, true, NULL, NULL, NULL, NULL, 'LOS PATIOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (798, 18, true, NULL, NULL, NULL, NULL, 'LOURDES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (799, 18, true, NULL, NULL, NULL, NULL, 'MUTISCUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (800, 18, true, NULL, NULL, NULL, NULL, 'OCAÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (801, 18, true, NULL, NULL, NULL, NULL, 'PAMPLONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (802, 18, true, NULL, NULL, NULL, NULL, 'PAMPLONITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (803, 18, true, NULL, NULL, NULL, NULL, 'PUERTO SANTANDER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (804, 18, true, NULL, NULL, NULL, NULL, 'RAGONVALIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (805, 18, true, NULL, NULL, NULL, NULL, 'SALAZAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (806, 18, true, NULL, NULL, NULL, NULL, 'SAN CALIXTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (807, 18, true, NULL, NULL, NULL, NULL, 'SAN CAYETANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (808, 18, true, NULL, NULL, NULL, NULL, 'SANTIAGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (809, 18, true, NULL, NULL, NULL, NULL, 'SARDINATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (810, 18, true, NULL, NULL, NULL, NULL, 'SILOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (811, 18, true, NULL, NULL, NULL, NULL, 'TEORAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (812, 18, true, NULL, NULL, NULL, NULL, 'TIBU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (813, 18, true, NULL, NULL, NULL, NULL, 'TOLEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (814, 18, true, NULL, NULL, NULL, NULL, 'VILLA CARO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (815, 18, true, NULL, NULL, NULL, NULL, 'VILLA DEL ROSARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (816, 19, true, NULL, NULL, NULL, NULL, 'ARMENIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (817, 19, true, NULL, NULL, NULL, NULL, 'BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (818, 19, true, NULL, NULL, NULL, NULL, 'CALARCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (819, 19, true, NULL, NULL, NULL, NULL, 'CIRCASIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (820, 19, true, NULL, NULL, NULL, NULL, 'CORDOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (821, 19, true, NULL, NULL, NULL, NULL, 'FILANDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (822, 19, true, NULL, NULL, NULL, NULL, 'GENOVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (823, 19, true, NULL, NULL, NULL, NULL, 'LA TEBAIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (824, 19, true, NULL, NULL, NULL, NULL, 'MONTENEGRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (825, 19, true, NULL, NULL, NULL, NULL, 'PIJAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (826, 19, true, NULL, NULL, NULL, NULL, 'QUIMBAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (827, 19, true, NULL, NULL, NULL, NULL, 'SALENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (828, 20, true, NULL, NULL, NULL, NULL, 'PEREIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (829, 20, true, NULL, NULL, NULL, NULL, 'APIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (830, 20, true, NULL, NULL, NULL, NULL, 'BALBOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (831, 20, true, NULL, NULL, NULL, NULL, 'BELEN DE UMBRIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (832, 20, true, NULL, NULL, NULL, NULL, 'DOSQUEBRADAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (833, 20, true, NULL, NULL, NULL, NULL, 'GUATICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (834, 20, true, NULL, NULL, NULL, NULL, 'LA CELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (835, 20, true, NULL, NULL, NULL, NULL, 'LA VIRGINIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (836, 20, true, NULL, NULL, NULL, NULL, 'MARSELLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (837, 20, true, NULL, NULL, NULL, NULL, 'MISTRATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (838, 20, true, NULL, NULL, NULL, NULL, 'PUEBLO RICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (839, 20, true, NULL, NULL, NULL, NULL, 'QUINCHIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (840, 20, true, NULL, NULL, NULL, NULL, 'SANTA ROSA DE CABAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (841, 20, true, NULL, NULL, NULL, NULL, 'SANTUARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (842, 21, true, NULL, NULL, NULL, NULL, 'BUCARAMANGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (843, 21, true, NULL, NULL, NULL, NULL, 'AGUADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (844, 21, true, NULL, NULL, NULL, NULL, 'ALBANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (845, 21, true, NULL, NULL, NULL, NULL, 'ARATOCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (846, 21, true, NULL, NULL, NULL, NULL, 'BARBOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (847, 21, true, NULL, NULL, NULL, NULL, 'BARICHARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (848, 21, true, NULL, NULL, NULL, NULL, 'BARRANCABERMEJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (849, 21, true, NULL, NULL, NULL, NULL, 'BETULIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (850, 21, true, NULL, NULL, NULL, NULL, 'BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (851, 21, true, NULL, NULL, NULL, NULL, 'CABRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (852, 21, true, NULL, NULL, NULL, NULL, 'CALIFORNIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (853, 21, true, NULL, NULL, NULL, NULL, 'CAPITANEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (854, 21, true, NULL, NULL, NULL, NULL, 'CARCASI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (855, 21, true, NULL, NULL, NULL, NULL, 'CEPITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (856, 21, true, NULL, NULL, NULL, NULL, 'CERRITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (857, 21, true, NULL, NULL, NULL, NULL, 'CHARALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (858, 21, true, NULL, NULL, NULL, NULL, 'CHARTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (859, 21, true, NULL, NULL, NULL, NULL, 'CHIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (860, 21, true, NULL, NULL, NULL, NULL, 'CHIPATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (861, 21, true, NULL, NULL, NULL, NULL, 'CIMITARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (862, 21, true, NULL, NULL, NULL, NULL, 'CONCEPCION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (863, 21, true, NULL, NULL, NULL, NULL, 'CONFINES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (864, 21, true, NULL, NULL, NULL, NULL, 'CONTRATACION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (865, 21, true, NULL, NULL, NULL, NULL, 'COROMORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (866, 21, true, NULL, NULL, NULL, NULL, 'CURITI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (867, 21, true, NULL, NULL, NULL, NULL, 'EL CARMEN DE CHUCURI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (868, 21, true, NULL, NULL, NULL, NULL, 'EL GUACAMAYO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (869, 21, true, NULL, NULL, NULL, NULL, 'EL PEÑON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (870, 21, true, NULL, NULL, NULL, NULL, 'EL PLAYON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (871, 21, true, NULL, NULL, NULL, NULL, 'ENCINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (872, 21, true, NULL, NULL, NULL, NULL, 'ENCISO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (873, 21, true, NULL, NULL, NULL, NULL, 'FLORIAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (874, 21, true, NULL, NULL, NULL, NULL, 'FLORIDABLANCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (875, 21, true, NULL, NULL, NULL, NULL, 'GALAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (876, 21, true, NULL, NULL, NULL, NULL, 'GAMBITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (877, 21, true, NULL, NULL, NULL, NULL, 'GIRON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (878, 21, true, NULL, NULL, NULL, NULL, 'GUACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (879, 21, true, NULL, NULL, NULL, NULL, 'GUADALUPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (880, 21, true, NULL, NULL, NULL, NULL, 'GUAPOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (881, 21, true, NULL, NULL, NULL, NULL, 'GUAVATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (882, 21, true, NULL, NULL, NULL, NULL, 'GsEPSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (883, 21, true, NULL, NULL, NULL, NULL, 'HATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (884, 21, true, NULL, NULL, NULL, NULL, 'JESUS MARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (885, 21, true, NULL, NULL, NULL, NULL, 'JORDAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (886, 21, true, NULL, NULL, NULL, NULL, 'LA BELLEZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (887, 21, true, NULL, NULL, NULL, NULL, 'LANDAZURI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (888, 21, true, NULL, NULL, NULL, NULL, 'LA PAZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (889, 21, true, NULL, NULL, NULL, NULL, 'LEBRIJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (890, 21, true, NULL, NULL, NULL, NULL, 'LOS SANTOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (891, 21, true, NULL, NULL, NULL, NULL, 'MACARAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (892, 21, true, NULL, NULL, NULL, NULL, 'MALAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (893, 21, true, NULL, NULL, NULL, NULL, 'MATANZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (894, 21, true, NULL, NULL, NULL, NULL, 'MOGOTES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (895, 21, true, NULL, NULL, NULL, NULL, 'MOLAGAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (896, 21, true, NULL, NULL, NULL, NULL, 'OCAMONTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (897, 21, true, NULL, NULL, NULL, NULL, 'OIBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (898, 21, true, NULL, NULL, NULL, NULL, 'ONZAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (899, 21, true, NULL, NULL, NULL, NULL, 'PALMAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (900, 21, true, NULL, NULL, NULL, NULL, 'PALMAS DEL SOCORRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (901, 21, true, NULL, NULL, NULL, NULL, 'PARAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (902, 21, true, NULL, NULL, NULL, NULL, 'PIEDECUESTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (903, 21, true, NULL, NULL, NULL, NULL, 'PINCHOTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (904, 21, true, NULL, NULL, NULL, NULL, 'PUENTE NACIONAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (905, 21, true, NULL, NULL, NULL, NULL, 'PUERTO PARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (906, 21, true, NULL, NULL, NULL, NULL, 'PUERTO WILCHES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (907, 21, true, NULL, NULL, NULL, NULL, 'RIONEGRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (908, 21, true, NULL, NULL, NULL, NULL, 'SABANA DE TORRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (909, 21, true, NULL, NULL, NULL, NULL, 'SAN ANDRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (910, 21, true, NULL, NULL, NULL, NULL, 'SAN BENITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (911, 21, true, NULL, NULL, NULL, NULL, 'SAN GIL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (912, 21, true, NULL, NULL, NULL, NULL, 'SAN JOAQUIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (913, 21, true, NULL, NULL, NULL, NULL, 'SAN JOSE DE MIRANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (914, 21, true, NULL, NULL, NULL, NULL, 'SAN MIGUEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (915, 21, true, NULL, NULL, NULL, NULL, 'SAN VICENTE DE CHUCURI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (916, 21, true, NULL, NULL, NULL, NULL, 'SANTA BARBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (917, 21, true, NULL, NULL, NULL, NULL, 'SANTA HELENA DEL OPON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (918, 21, true, NULL, NULL, NULL, NULL, 'SIMACOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (919, 21, true, NULL, NULL, NULL, NULL, 'SOCORRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (920, 21, true, NULL, NULL, NULL, NULL, 'SUAITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (921, 21, true, NULL, NULL, NULL, NULL, 'SUCRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (922, 21, true, NULL, NULL, NULL, NULL, 'SURATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (923, 21, true, NULL, NULL, NULL, NULL, 'TONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (924, 21, true, NULL, NULL, NULL, NULL, 'VALLE DE SAN JOSE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (925, 21, true, NULL, NULL, NULL, NULL, 'VELEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (926, 21, true, NULL, NULL, NULL, NULL, 'VETAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (927, 21, true, NULL, NULL, NULL, NULL, 'VILLANUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (928, 21, true, NULL, NULL, NULL, NULL, 'ZAPATOCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (929, 22, true, NULL, NULL, NULL, NULL, 'SINCELEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (930, 22, true, NULL, NULL, NULL, NULL, 'BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (931, 22, true, NULL, NULL, NULL, NULL, 'CAIMITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (932, 22, true, NULL, NULL, NULL, NULL, 'COLOSO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (933, 22, true, NULL, NULL, NULL, NULL, 'COROZAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (934, 22, true, NULL, NULL, NULL, NULL, 'COVEÑAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (935, 22, true, NULL, NULL, NULL, NULL, 'CHALAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (936, 22, true, NULL, NULL, NULL, NULL, 'EL ROBLE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (937, 22, true, NULL, NULL, NULL, NULL, 'GALERAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (938, 22, true, NULL, NULL, NULL, NULL, 'GUARANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (939, 22, true, NULL, NULL, NULL, NULL, 'LA UNION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (940, 22, true, NULL, NULL, NULL, NULL, 'LOS PALMITOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (941, 22, true, NULL, NULL, NULL, NULL, 'MAJAGUAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (942, 22, true, NULL, NULL, NULL, NULL, 'MORROA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (943, 22, true, NULL, NULL, NULL, NULL, 'OVEJAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (944, 22, true, NULL, NULL, NULL, NULL, 'PALMITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (945, 22, true, NULL, NULL, NULL, NULL, 'SAMPUES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (946, 22, true, NULL, NULL, NULL, NULL, 'SAN BENITO ABAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (947, 22, true, NULL, NULL, NULL, NULL, 'SAN JUAN DE BETULIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (948, 22, true, NULL, NULL, NULL, NULL, 'SAN MARCOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (949, 22, true, NULL, NULL, NULL, NULL, 'SAN ONOFRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (950, 22, true, NULL, NULL, NULL, NULL, 'SAN PEDRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (951, 22, true, NULL, NULL, NULL, NULL, 'SAN LUIS DE SINCE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (952, 22, true, NULL, NULL, NULL, NULL, 'SUCRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (953, 22, true, NULL, NULL, NULL, NULL, 'SANTIAGO DE TOLU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (954, 22, true, NULL, NULL, NULL, NULL, 'TOLU VIEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (955, 23, true, NULL, NULL, NULL, NULL, 'IBAGUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (956, 23, true, NULL, NULL, NULL, NULL, 'ALPUJARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (957, 23, true, NULL, NULL, NULL, NULL, 'ALVARADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (958, 23, true, NULL, NULL, NULL, NULL, 'AMBALEMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (959, 23, true, NULL, NULL, NULL, NULL, 'ANZOATEGUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (960, 23, true, NULL, NULL, NULL, NULL, 'ARMERO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (961, 23, true, NULL, NULL, NULL, NULL, 'ATACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (962, 23, true, NULL, NULL, NULL, NULL, 'CAJAMARCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (963, 23, true, NULL, NULL, NULL, NULL, 'CARMEN DE APICALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (964, 23, true, NULL, NULL, NULL, NULL, 'CASABIANCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (965, 23, true, NULL, NULL, NULL, NULL, 'CHAPARRAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (966, 23, true, NULL, NULL, NULL, NULL, 'COELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (967, 23, true, NULL, NULL, NULL, NULL, 'COYAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (968, 23, true, NULL, NULL, NULL, NULL, 'CUNDAY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (969, 23, true, NULL, NULL, NULL, NULL, 'DOLORES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (970, 23, true, NULL, NULL, NULL, NULL, 'ESPINAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (971, 23, true, NULL, NULL, NULL, NULL, 'FALAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (972, 23, true, NULL, NULL, NULL, NULL, 'FLANDES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (973, 23, true, NULL, NULL, NULL, NULL, 'FRESNO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (974, 23, true, NULL, NULL, NULL, NULL, 'GUAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (975, 23, true, NULL, NULL, NULL, NULL, 'HERVEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (976, 23, true, NULL, NULL, NULL, NULL, 'HONDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (977, 23, true, NULL, NULL, NULL, NULL, 'ICONONZO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (978, 23, true, NULL, NULL, NULL, NULL, 'LERIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (979, 23, true, NULL, NULL, NULL, NULL, 'LIBANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (980, 23, true, NULL, NULL, NULL, NULL, 'MARIQUITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (981, 23, true, NULL, NULL, NULL, NULL, 'MELGAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (982, 23, true, NULL, NULL, NULL, NULL, 'MURILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (983, 23, true, NULL, NULL, NULL, NULL, 'NATAGAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (984, 23, true, NULL, NULL, NULL, NULL, 'ORTEGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (985, 23, true, NULL, NULL, NULL, NULL, 'PALOCABILDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (986, 23, true, NULL, NULL, NULL, NULL, 'PIEDRAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (987, 23, true, NULL, NULL, NULL, NULL, 'PLANADAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (988, 23, true, NULL, NULL, NULL, NULL, 'PRADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (989, 23, true, NULL, NULL, NULL, NULL, 'PURIFICACION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (990, 23, true, NULL, NULL, NULL, NULL, 'RIOBLANCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (991, 23, true, NULL, NULL, NULL, NULL, 'RONCESVALLES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (992, 23, true, NULL, NULL, NULL, NULL, 'ROVIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (993, 23, true, NULL, NULL, NULL, NULL, 'SALDAÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (994, 23, true, NULL, NULL, NULL, NULL, 'SAN ANTONIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (995, 23, true, NULL, NULL, NULL, NULL, 'SAN LUIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (996, 23, true, NULL, NULL, NULL, NULL, 'SANTA ISABEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (997, 23, true, NULL, NULL, NULL, NULL, 'SUAREZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (998, 23, true, NULL, NULL, NULL, NULL, 'VALLE DE SAN JUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (999, 23, true, NULL, NULL, NULL, NULL, 'VENADILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1000, 23, true, NULL, NULL, NULL, NULL, 'VILLAHERMOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1001, 23, true, NULL, NULL, NULL, NULL, 'VILLARRICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1002, 24, true, NULL, NULL, NULL, NULL, 'CALI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1003, 24, true, NULL, NULL, NULL, NULL, 'ALCALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1004, 24, true, NULL, NULL, NULL, NULL, 'ANDALUCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1005, 24, true, NULL, NULL, NULL, NULL, 'ANSERMANUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1006, 24, true, NULL, NULL, NULL, NULL, 'ARGELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1007, 24, true, NULL, NULL, NULL, NULL, 'BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1008, 24, true, NULL, NULL, NULL, NULL, 'BUENAVENTURA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1009, 24, true, NULL, NULL, NULL, NULL, 'GUADALAJARA DE BUGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1010, 24, true, NULL, NULL, NULL, NULL, 'BUGALAGRANDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1011, 24, true, NULL, NULL, NULL, NULL, 'CAICEDONIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1012, 24, true, NULL, NULL, NULL, NULL, 'CALIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1013, 24, true, NULL, NULL, NULL, NULL, 'CANDELARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1014, 24, true, NULL, NULL, NULL, NULL, 'CARTAGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1015, 24, true, NULL, NULL, NULL, NULL, 'DAGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1016, 24, true, NULL, NULL, NULL, NULL, 'EL AGUILA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1017, 24, true, NULL, NULL, NULL, NULL, 'EL CAIRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1018, 24, true, NULL, NULL, NULL, NULL, 'EL CERRITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1019, 24, true, NULL, NULL, NULL, NULL, 'EL DOVIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1020, 24, true, NULL, NULL, NULL, NULL, 'FLORIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1021, 24, true, NULL, NULL, NULL, NULL, 'GINEBRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1022, 24, true, NULL, NULL, NULL, NULL, 'GUACARI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1023, 24, true, NULL, NULL, NULL, NULL, 'JAMUNDI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1024, 24, true, NULL, NULL, NULL, NULL, 'LA CUMBRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1025, 24, true, NULL, NULL, NULL, NULL, 'LA UNION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1026, 24, true, NULL, NULL, NULL, NULL, 'LA VICTORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1027, 24, true, NULL, NULL, NULL, NULL, 'OBANDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1028, 24, true, NULL, NULL, NULL, NULL, 'PALMIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1029, 24, true, NULL, NULL, NULL, NULL, 'PRADERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1030, 24, true, NULL, NULL, NULL, NULL, 'RESTREPO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1031, 24, true, NULL, NULL, NULL, NULL, 'RIOFRIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1032, 24, true, NULL, NULL, NULL, NULL, 'ROLDANILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1033, 24, true, NULL, NULL, NULL, NULL, 'SAN PEDRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1034, 24, true, NULL, NULL, NULL, NULL, 'SEVILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1035, 24, true, NULL, NULL, NULL, NULL, 'TORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1036, 24, true, NULL, NULL, NULL, NULL, 'TRUJILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1037, 24, true, NULL, NULL, NULL, NULL, 'TULUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1038, 24, true, NULL, NULL, NULL, NULL, 'ULLOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1039, 24, true, NULL, NULL, NULL, NULL, 'VERSALLES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1040, 24, true, NULL, NULL, NULL, NULL, 'VIJES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1041, 24, true, NULL, NULL, NULL, NULL, 'YOTOCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1042, 24, true, NULL, NULL, NULL, NULL, 'YUMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1043, 24, true, NULL, NULL, NULL, NULL, 'ZARZAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1044, 25, true, NULL, NULL, NULL, NULL, 'ARAUCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1045, 25, true, NULL, NULL, NULL, NULL, 'ARAUQUITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1046, 25, true, NULL, NULL, NULL, NULL, 'CRAVO NORTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1047, 25, true, NULL, NULL, NULL, NULL, 'FORTUL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1048, 25, true, NULL, NULL, NULL, NULL, 'PUERTO RONDON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1049, 25, true, NULL, NULL, NULL, NULL, 'SARAVENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1050, 25, true, NULL, NULL, NULL, NULL, 'TAME', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1051, 26, true, NULL, NULL, NULL, NULL, 'YOPAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1052, 26, true, NULL, NULL, NULL, NULL, 'AGUAZUL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1053, 26, true, NULL, NULL, NULL, NULL, 'CHAMEZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1054, 26, true, NULL, NULL, NULL, NULL, 'HATO COROZAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1055, 26, true, NULL, NULL, NULL, NULL, 'LA SALINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1056, 26, true, NULL, NULL, NULL, NULL, 'MANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1057, 26, true, NULL, NULL, NULL, NULL, 'MONTERREY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1058, 26, true, NULL, NULL, NULL, NULL, 'NUNCHIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1059, 26, true, NULL, NULL, NULL, NULL, 'OROCUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1060, 26, true, NULL, NULL, NULL, NULL, 'PAZ DE ARIPORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1061, 26, true, NULL, NULL, NULL, NULL, 'PORE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1062, 26, true, NULL, NULL, NULL, NULL, 'RECETOR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1063, 26, true, NULL, NULL, NULL, NULL, 'SABANALARGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1064, 26, true, NULL, NULL, NULL, NULL, 'SACAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1065, 26, true, NULL, NULL, NULL, NULL, 'SAN LUIS DE PALENQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1066, 26, true, NULL, NULL, NULL, NULL, 'TAMARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1067, 26, true, NULL, NULL, NULL, NULL, 'TAURAMENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1068, 26, true, NULL, NULL, NULL, NULL, 'TRINIDAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1069, 26, true, NULL, NULL, NULL, NULL, 'VILLANUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1070, 27, true, NULL, NULL, NULL, NULL, 'MOCOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1071, 27, true, NULL, NULL, NULL, NULL, 'COLON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1072, 27, true, NULL, NULL, NULL, NULL, 'ORITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1073, 27, true, NULL, NULL, NULL, NULL, 'PUERTO ASIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1074, 27, true, NULL, NULL, NULL, NULL, 'PUERTO CAICEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1075, 27, true, NULL, NULL, NULL, NULL, 'PUERTO GUZMAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1076, 27, true, NULL, NULL, NULL, NULL, 'LEGUIZAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1077, 27, true, NULL, NULL, NULL, NULL, 'SIBUNDOY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1078, 27, true, NULL, NULL, NULL, NULL, 'SAN FRANCISCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1079, 27, true, NULL, NULL, NULL, NULL, 'SAN MIGUEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1080, 27, true, NULL, NULL, NULL, NULL, 'SANTIAGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1081, 27, true, NULL, NULL, NULL, NULL, 'VALLE DEL GUAMUEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1082, 27, true, NULL, NULL, NULL, NULL, 'VILLAGARZON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1083, 28, true, NULL, NULL, NULL, NULL, 'SAN ANDRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1084, 28, true, NULL, NULL, NULL, NULL, 'PROVIDENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1085, 29, true, NULL, NULL, NULL, NULL, 'LETICIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1086, 29, true, NULL, NULL, NULL, NULL, 'EL ENCANTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1087, 29, true, NULL, NULL, NULL, NULL, 'LA CHORRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1088, 29, true, NULL, NULL, NULL, NULL, 'LA PEDRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1089, 29, true, NULL, NULL, NULL, NULL, 'LA VICTORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1090, 29, true, NULL, NULL, NULL, NULL, 'MIRITI - PARANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1091, 29, true, NULL, NULL, NULL, NULL, 'PUERTO ALEGRIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1092, 29, true, NULL, NULL, NULL, NULL, 'PUERTO ARICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1093, 29, true, NULL, NULL, NULL, NULL, 'PUERTO NARIÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1094, 29, true, NULL, NULL, NULL, NULL, 'PUERTO SANTANDER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1095, 29, true, NULL, NULL, NULL, NULL, 'TARAPACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1096, 30, true, NULL, NULL, NULL, NULL, 'INIRIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1097, 30, true, NULL, NULL, NULL, NULL, 'BARRANCO MINAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1098, 30, true, NULL, NULL, NULL, NULL, 'MAPIRIPANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1099, 30, true, NULL, NULL, NULL, NULL, 'SAN FELIPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1213, 46, true, NULL, NULL, NULL, NULL, 'SANTA LUCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1100, 30, true, NULL, NULL, NULL, NULL, 'PUERTO COLOMBIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1101, 30, true, NULL, NULL, NULL, NULL, 'LA GUADALUPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1102, 30, true, NULL, NULL, NULL, NULL, 'CACAHUAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1103, 30, true, NULL, NULL, NULL, NULL, 'PANA PANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1104, 30, true, NULL, NULL, NULL, NULL, 'MORICHAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1105, 31, true, NULL, NULL, NULL, NULL, 'SAN JOSE DEL GUAVIARE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1106, 31, true, NULL, NULL, NULL, NULL, 'CALAMAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1107, 31, true, NULL, NULL, NULL, NULL, 'EL RETORNO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1108, 31, true, NULL, NULL, NULL, NULL, 'MIRAFLORES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1109, 32, true, NULL, NULL, NULL, NULL, 'MITU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1110, 32, true, NULL, NULL, NULL, NULL, 'CARURU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1111, 32, true, NULL, NULL, NULL, NULL, 'PACOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1112, 32, true, NULL, NULL, NULL, NULL, 'TARAIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1113, 32, true, NULL, NULL, NULL, NULL, 'PAPUNAUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1114, 32, true, NULL, NULL, NULL, NULL, 'YAVARATE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1115, 33, true, NULL, NULL, NULL, NULL, 'PUERTO CARREÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1116, 33, true, NULL, NULL, NULL, NULL, 'LA PRIMAVERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1117, 33, true, NULL, NULL, NULL, NULL, 'SANTA ROSALIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1118, 33, true, NULL, NULL, NULL, NULL, 'CUMARIBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (148, 3, true, true, true, NULL, NULL, 'BOGOTA, D.C.', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1119, 1, true, false, true, 1, NULL, 'MEDELLIN', 'MED', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1336, 56, true, true, NULL, NULL, NULL, 'ZAMORA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1337, 56, true, NULL, NULL, NULL, NULL, 'CHINCHIPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1120, 34, true, true, NULL, NULL, NULL, 'CUENCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1121, 34, true, NULL, NULL, NULL, NULL, 'CAMILO PONCE ENRIQUEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1338, 56, true, NULL, NULL, NULL, NULL, 'NANGARITZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1122, 34, true, NULL, NULL, NULL, NULL, 'CHORDELEG', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1123, 34, true, NULL, NULL, NULL, NULL, 'EL PAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1124, 34, true, NULL, NULL, NULL, NULL, 'GIRON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1125, 34, true, NULL, NULL, NULL, NULL, 'GUACHAPALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1126, 34, true, NULL, NULL, NULL, NULL, 'GUALACEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1127, 34, true, NULL, NULL, NULL, NULL, 'NABON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1128, 34, true, NULL, NULL, NULL, NULL, 'OÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1129, 34, true, NULL, NULL, NULL, NULL, 'PAUTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1130, 34, true, NULL, NULL, NULL, NULL, 'PUCARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1131, 34, true, NULL, NULL, NULL, NULL, 'SAN FERNANDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1132, 34, true, NULL, NULL, NULL, NULL, 'SANTA ISABEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1133, 34, true, NULL, NULL, NULL, NULL, 'SEVILLA DE ORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1134, 34, true, NULL, NULL, NULL, NULL, 'SIGSIG', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1135, 35, true, true, NULL, NULL, NULL, 'GUARANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1136, 35, true, NULL, NULL, NULL, NULL, 'CHIMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1339, 56, true, NULL, NULL, NULL, NULL, 'PALANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1340, 56, true, NULL, NULL, NULL, NULL, 'PAQUISHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1137, 35, true, NULL, NULL, NULL, NULL, 'ECHEANDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1138, 35, true, NULL, NULL, NULL, NULL, 'SAN MIGUEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1139, 35, true, NULL, NULL, NULL, NULL, 'CHILLANES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1140, 35, true, NULL, NULL, NULL, NULL, 'CALUMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1141, 35, true, NULL, NULL, NULL, NULL, 'LAS NAVES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1142, 36, true, true, NULL, NULL, NULL, 'AZOGUES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1143, 36, true, NULL, NULL, NULL, NULL, 'CAÑAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1144, 36, true, NULL, NULL, NULL, NULL, 'BIBLIAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1145, 36, true, NULL, NULL, NULL, NULL, 'LA TRONCAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1146, 36, true, NULL, NULL, NULL, NULL, 'EL TAMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1147, 36, true, NULL, NULL, NULL, NULL, 'DELEG', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1148, 36, true, NULL, NULL, NULL, NULL, 'SUSCAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1149, 37, true, true, NULL, NULL, NULL, 'TULCAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1150, 37, true, NULL, NULL, NULL, NULL, 'ESPEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1151, 37, true, NULL, NULL, NULL, NULL, 'MONTUFAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1341, 56, true, NULL, NULL, NULL, NULL, 'YACUAMBI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1152, 37, true, NULL, NULL, NULL, NULL, 'MIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1153, 37, true, NULL, NULL, NULL, NULL, 'BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1154, 37, true, NULL, NULL, NULL, NULL, 'SAN PEDRO DE HUACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1342, 56, true, NULL, NULL, NULL, NULL, 'YANTZAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1155, 38, true, true, NULL, NULL, NULL, 'RIOBAMBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1156, 38, true, NULL, NULL, NULL, NULL, 'ALAUSI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1157, 38, true, NULL, NULL, NULL, NULL, 'COLTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1158, 38, true, NULL, NULL, NULL, NULL, 'CHUNCHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1159, 38, true, NULL, NULL, NULL, NULL, 'GUAMOTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1160, 38, true, NULL, NULL, NULL, NULL, 'GUANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1161, 38, true, NULL, NULL, NULL, NULL, 'PENIPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1162, 38, true, NULL, NULL, NULL, NULL, 'PALLATANGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1163, 38, true, NULL, NULL, NULL, NULL, 'CHAMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1164, 38, true, NULL, NULL, NULL, NULL, 'CUMANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1165, 39, true, true, NULL, NULL, NULL, 'LATACUNGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1166, 39, true, NULL, NULL, NULL, NULL, 'LA MANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1167, 39, true, NULL, NULL, NULL, NULL, 'PANGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1168, 39, true, NULL, NULL, NULL, NULL, 'PUJILI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1169, 39, true, NULL, NULL, NULL, NULL, 'SALCEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1170, 39, true, NULL, NULL, NULL, NULL, 'SAQUISLI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1171, 39, true, NULL, NULL, NULL, NULL, 'SIGCHOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1172, 47, true, true, NULL, NULL, NULL, 'MACHALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1173, 47, true, NULL, NULL, NULL, NULL, 'ARENILLAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1174, 47, true, NULL, NULL, NULL, NULL, 'ATAHUALPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1175, 47, true, NULL, NULL, NULL, NULL, 'EL GUABO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1176, 47, true, NULL, NULL, NULL, NULL, 'HUAQUILLAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1177, 47, true, NULL, NULL, NULL, NULL, 'LA CONCORDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1178, 47, true, NULL, NULL, NULL, NULL, 'MARCABELI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1179, 47, true, NULL, NULL, NULL, NULL, 'PASAJE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1180, 47, true, NULL, NULL, NULL, NULL, 'PIÑAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1181, 47, true, NULL, NULL, NULL, NULL, 'PORTOVELO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1182, 47, true, NULL, NULL, NULL, NULL, 'RIOVERDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1343, 56, true, NULL, NULL, NULL, NULL, 'EL PANGUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1183, 47, true, NULL, NULL, NULL, NULL, 'SANTA ROSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1184, 47, true, NULL, NULL, NULL, NULL, 'ZARUMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1185, 47, true, NULL, NULL, NULL, NULL, 'BALSAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1186, 47, true, NULL, NULL, NULL, NULL, 'CHILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1187, 47, true, NULL, NULL, NULL, NULL, 'LAS LAJAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1188, 45, true, true, NULL, NULL, NULL, 'ESMERALDAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1189, 45, true, NULL, NULL, NULL, NULL, 'ELOY ALFRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1190, 45, true, NULL, NULL, NULL, NULL, 'MUISNE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1191, 45, true, NULL, NULL, NULL, NULL, 'QUININDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1192, 45, true, NULL, NULL, NULL, NULL, 'SAN LORENZO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1193, 45, true, NULL, NULL, NULL, NULL, 'ATACAMES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1194, 57, true, true, NULL, NULL, NULL, 'PUERTO BAQUERIZO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1195, 57, true, NULL, NULL, NULL, NULL, 'SAN CRISTOBAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1196, 57, true, NULL, NULL, NULL, NULL, 'ISABELA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1197, 57, true, NULL, NULL, NULL, NULL, 'SANTA CRUZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1198, 46, true, true, NULL, NULL, NULL, 'GUAYAQUIL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1199, 46, true, NULL, NULL, NULL, NULL, 'DAULE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1200, 46, true, NULL, NULL, NULL, NULL, 'DURAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1201, 46, true, NULL, NULL, NULL, NULL, 'YAGUACHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1202, 46, true, NULL, NULL, NULL, NULL, 'BALZAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1203, 46, true, NULL, NULL, NULL, NULL, 'MILAGRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1204, 46, true, NULL, NULL, NULL, NULL, 'NARANJAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1205, 46, true, NULL, NULL, NULL, NULL, 'SAMBORONDON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1206, 46, true, NULL, NULL, NULL, NULL, 'EL TRIUNFO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1207, 46, true, NULL, NULL, NULL, NULL, 'ISIDRO AYORA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1208, 46, true, NULL, NULL, NULL, NULL, 'NARANJITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1209, 46, true, NULL, NULL, NULL, NULL, 'EL EMPALME', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1210, 46, true, NULL, NULL, NULL, NULL, 'BAQUERIZO MORENO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1211, 46, true, NULL, NULL, NULL, NULL, 'PEDRO CARBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1212, 46, true, NULL, NULL, NULL, NULL, 'SALITRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1214, 46, true, NULL, NULL, NULL, NULL, 'PALESTINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1215, 46, true, NULL, NULL, NULL, NULL, 'BALAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1216, 46, true, NULL, NULL, NULL, NULL, 'COLIMES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1217, 46, true, NULL, NULL, NULL, NULL, 'PLAYAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1218, 46, true, NULL, NULL, NULL, NULL, 'SIMON BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1219, 46, true, NULL, NULL, NULL, NULL, 'CORONEL MARCELINO MARIDUEÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1220, 46, true, NULL, NULL, NULL, NULL, 'LOMAS DE SANGENTILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1221, 46, true, NULL, NULL, NULL, NULL, 'NOBOL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1222, 40, true, true, NULL, NULL, NULL, 'IBARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1223, 40, true, NULL, NULL, NULL, NULL, 'ANTONIO ANTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1224, 40, true, NULL, NULL, NULL, NULL, 'OTAVALO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1225, 40, true, NULL, NULL, NULL, NULL, 'COTACACHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1226, 40, true, NULL, NULL, NULL, NULL, 'PIMAMPIRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1227, 40, true, NULL, NULL, NULL, NULL, 'SAN MIGUEL DE URCUQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1228, 41, true, true, NULL, NULL, NULL, 'LOJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1229, 41, true, NULL, NULL, NULL, NULL, 'MACARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1230, 41, true, NULL, NULL, NULL, NULL, 'PALTAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1231, 41, true, NULL, NULL, NULL, NULL, 'PUYANGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1232, 41, true, NULL, NULL, NULL, NULL, 'SARAGURO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1233, 41, true, NULL, NULL, NULL, NULL, 'CELICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1234, 41, true, NULL, NULL, NULL, NULL, 'CATAMAYO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1235, 41, true, NULL, NULL, NULL, NULL, 'ESPINDOLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1236, 41, true, NULL, NULL, NULL, NULL, 'GOZANAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1237, 41, true, NULL, NULL, NULL, NULL, 'SOZORANGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1238, 41, true, NULL, NULL, NULL, NULL, 'ZAPOTILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1239, 41, true, NULL, NULL, NULL, NULL, 'CALVAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1240, 41, true, NULL, NULL, NULL, NULL, 'CHAGUARPAMBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1241, 41, true, NULL, NULL, NULL, NULL, 'OLMEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1242, 41, true, NULL, NULL, NULL, NULL, 'PINDAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1243, 41, true, NULL, NULL, NULL, NULL, 'QUILANGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1244, 48, true, true, NULL, NULL, NULL, 'BABAHOYO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1245, 48, true, NULL, NULL, NULL, NULL, 'BABA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1246, 48, true, NULL, NULL, NULL, NULL, 'BUENA FE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1247, 48, true, NULL, NULL, NULL, NULL, 'MONTALVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1248, 48, true, NULL, NULL, NULL, NULL, 'PUEBLOVIEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1249, 48, true, NULL, NULL, NULL, NULL, 'QUEVEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1250, 48, true, NULL, NULL, NULL, NULL, 'QUINSALOMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1251, 48, true, NULL, NULL, NULL, NULL, 'URDANETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1252, 48, true, NULL, NULL, NULL, NULL, 'VALENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1253, 48, true, NULL, NULL, NULL, NULL, 'MOCACHE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1254, 48, true, NULL, NULL, NULL, NULL, 'VENTANAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1255, 48, true, NULL, NULL, NULL, NULL, 'VINCES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1256, 48, true, NULL, NULL, NULL, NULL, 'PALENQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1257, 49, true, true, NULL, NULL, NULL, 'PORTOVIEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1258, 49, true, NULL, NULL, NULL, NULL, 'BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1259, 49, true, NULL, NULL, NULL, NULL, 'CHONE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1260, 49, true, NULL, NULL, NULL, NULL, 'EL CARMEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1261, 49, true, NULL, NULL, NULL, NULL, 'FLAVIO ALFARO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1262, 49, true, NULL, NULL, NULL, NULL, 'JAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1263, 49, true, NULL, NULL, NULL, NULL, 'JARAMIJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1264, 49, true, NULL, NULL, NULL, NULL, 'JUNIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1265, 49, true, NULL, NULL, NULL, NULL, 'JIPIJAPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1266, 49, true, NULL, NULL, NULL, NULL, 'MANTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1267, 49, true, NULL, NULL, NULL, NULL, 'MONTECRISTI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1268, 49, true, NULL, NULL, NULL, NULL, 'OLMEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1269, 49, true, NULL, NULL, NULL, NULL, 'PAJAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1270, 49, true, NULL, NULL, NULL, NULL, 'PEDERNALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1271, 49, true, NULL, NULL, NULL, NULL, 'PICHINCHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1272, 49, true, NULL, NULL, NULL, NULL, 'PUERTO LOPEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1273, 49, true, NULL, NULL, NULL, NULL, 'ROCAFUERTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1274, 49, true, NULL, NULL, NULL, NULL, 'SAN VICENTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1275, 49, true, NULL, NULL, NULL, NULL, 'SANTA ANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1276, 49, true, NULL, NULL, NULL, NULL, 'SUCRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1277, 49, true, NULL, NULL, NULL, NULL, 'TOSAGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1278, 49, true, NULL, NULL, NULL, NULL, '24 DE MAYO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1279, 51, true, true, NULL, NULL, NULL, 'MACAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1280, 51, true, NULL, NULL, NULL, NULL, 'MORONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1281, 51, true, NULL, NULL, NULL, NULL, 'GUALAQUIZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1282, 51, true, NULL, NULL, NULL, NULL, 'LIMON INDANZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1283, 51, true, NULL, NULL, NULL, NULL, 'LOGROÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1284, 51, true, NULL, NULL, NULL, NULL, 'PABLO SEXTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1285, 51, true, NULL, NULL, NULL, NULL, 'PALORA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1286, 51, true, NULL, NULL, NULL, NULL, 'SANTIAGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1287, 51, true, NULL, NULL, NULL, NULL, 'SUCUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1288, 51, true, NULL, NULL, NULL, NULL, 'HUAMBOYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1318, 44, true, true, NULL, NULL, NULL, 'SANTO DOMINGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1319, 55, true, true, NULL, NULL, NULL, 'NUEVA LOJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1289, 51, true, NULL, NULL, NULL, NULL, 'SAN JUAN BOSCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1290, 51, true, NULL, NULL, NULL, NULL, 'TAISHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1291, 51, true, NULL, NULL, NULL, NULL, 'TIWINTZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1292, 52, true, true, NULL, NULL, NULL, 'TENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1293, 52, true, NULL, NULL, NULL, NULL, 'ARCHIDONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1294, 52, true, NULL, NULL, NULL, NULL, 'CARLOS JULIO AROSEMENA TOLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1295, 52, true, NULL, NULL, NULL, NULL, 'EL CHACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1296, 52, true, NULL, NULL, NULL, NULL, 'QUIJOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1297, 53, true, true, NULL, NULL, NULL, 'FRANCISCO DE ORELLANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1298, 53, true, NULL, NULL, NULL, NULL, 'ORELLANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1299, 53, true, NULL, NULL, NULL, NULL, 'AGUARICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1300, 53, true, NULL, NULL, NULL, NULL, 'LA JOYA DE LOS SACHAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1301, 53, true, NULL, NULL, NULL, NULL, 'LORETO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1302, 54, true, true, NULL, NULL, NULL, 'PUYO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1303, 54, true, NULL, NULL, NULL, NULL, 'PASTAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1304, 54, true, NULL, NULL, NULL, NULL, 'ARAJUNO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1305, 54, true, NULL, NULL, NULL, NULL, 'MERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1306, 54, true, NULL, NULL, NULL, NULL, 'SANTA CLARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1307, 42, true, true, NULL, NULL, NULL, 'QUITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1308, 42, true, NULL, NULL, NULL, NULL, 'CAYAMBE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1309, 42, true, NULL, NULL, NULL, NULL, 'MEJIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1310, 42, true, NULL, NULL, NULL, NULL, 'PEDRO MONCAYO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1311, 42, true, NULL, NULL, NULL, NULL, 'PEDRO VICENTE MALDONADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1312, 42, true, NULL, NULL, NULL, NULL, 'PUERTO QUITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1313, 42, true, NULL, NULL, NULL, NULL, 'RUMIÑAHUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1314, 42, true, NULL, NULL, NULL, NULL, 'SAN MIGUEL DE LOS BANCOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1315, 50, true, true, NULL, NULL, NULL, 'SANTA ELENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1316, 50, true, NULL, NULL, NULL, NULL, 'LA LIBERTAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1317, 50, true, NULL, NULL, NULL, NULL, 'SALINAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1320, 55, true, NULL, NULL, NULL, NULL, 'LAGO AGRIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1321, 55, true, NULL, NULL, NULL, NULL, 'CUYABENO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1322, 55, true, NULL, NULL, NULL, NULL, 'GONZALO PIZARRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1323, 55, true, NULL, NULL, NULL, NULL, 'PUTUMAYO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1324, 55, true, NULL, NULL, NULL, NULL, 'SHUSHUFINDI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1325, 55, true, NULL, NULL, NULL, NULL, 'SUCUMBIOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1326, 55, true, NULL, NULL, NULL, NULL, 'CASCALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1327, 43, true, true, NULL, NULL, NULL, 'AMBATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1328, 43, true, NULL, NULL, NULL, NULL, 'BAÑOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1329, 43, true, NULL, NULL, NULL, NULL, 'CEVALLOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1330, 43, true, NULL, NULL, NULL, NULL, 'MOCHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1331, 43, true, NULL, NULL, NULL, NULL, 'PATATE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1332, 43, true, NULL, NULL, NULL, NULL, 'QUERO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1333, 43, true, NULL, NULL, NULL, NULL, 'SAN PEDRO DE PELILEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1334, 43, true, NULL, NULL, NULL, NULL, 'SANTIAGO DE PILLARO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1335, 43, true, NULL, NULL, NULL, NULL, 'TISALEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios (id_municipio, id_depto, is_activo, is_capital_pais, is_capital_depto, orden_db, cod_dane, nom_municipio_es, abr_municipio_es, abr_municipio_fr, nom_municipio_fr, abr_municipio_de, nom_municipio_de, abr_municipio_en, nom_municipio_en) VALUES (1344, 56, true, NULL, NULL, NULL, NULL, 'CENTINELA DEL CONDOR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);


--
-- TOC entry 2216 (class 0 OID 47218)
-- Dependencies: 150
-- Data for Name: xcm_db_paises; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (1, 1, 'Afghanistan', 'AF', 'Afghanistan', 'AF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (2, 2, 'Albania', 'AL', 'Albania', 'AL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (3, 3, 'Algeria', 'DZ', 'Algeria', 'DZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (4, 4, 'American Samoa', 'AS', 'American Samoa', 'AS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (5, 5, 'Andorra', 'AD', 'Andorra', 'AD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (6, 6, 'Angola', 'AO', 'Angola', 'AO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (7, 7, 'Anguilla', 'AI', 'Anguilla', 'AI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (8, 8, 'Antigua & Barbuda', 'AG', 'Antigua & Barbuda', 'AG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (9, 9, 'Argentina', 'AR', 'Argentina', 'AR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (10, 10, 'Armenia', 'AM', 'Armenia', 'AM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (11, 11, 'Aruba', 'AW', 'Aruba', 'AW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (12, 12, 'Australia', 'AU', 'Australia', 'AU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (13, 13, 'Austria', 'AT', 'Austria', 'AT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (14, 14, 'Azerbaijan', 'AZ', 'Azerbaijan', 'AZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (15, 15, 'Azores', 'AP', 'Azores', 'AP', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (16, 16, 'Bahamas', 'BS', 'Bahamas', 'BS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (17, 17, 'Bahrain', 'BH', 'Bahrain', 'BH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (18, 18, 'Bangladesh', 'BD', 'Bangladesh', 'BD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (19, 19, 'Barbados', 'BB', 'Barbados', 'BB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (20, 20, 'Belarus', 'BY', 'Belarus', 'BY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (21, 21, 'Belgium', 'BE', 'Belgium', 'BE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (22, 22, 'Belize', 'BZ', 'Belize', 'BZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (23, 23, 'Benin', 'BJ', 'Benin', 'BJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (24, 24, 'Bermuda', 'BM', 'Bermuda', 'BM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (25, 25, 'Bhutan', 'BT', 'Bhutan', 'BT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (26, 26, 'Bolivia', 'BO', 'Bolivia', 'BO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (27, 27, 'Bonaire', 'BL', 'Bonaire', 'BL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (28, 28, 'Bosnia & Herzegovina', 'BA', 'Bosnia & Herzegovina', 'BA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (29, 29, 'Botswana', 'BW', 'Botswana', 'BW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (30, 30, 'Brazil', 'BR', 'Brazil', 'BR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (31, 31, 'British Indian Ocean Ter', 'IO', 'British Indian Ocean Ter', 'IO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (32, 32, 'Brunei', 'BN', 'Brunei', 'BN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (33, 33, 'Bulgaria', 'BG', 'Bulgaria', 'BG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (34, 34, 'Burkina Faso', 'BF', 'Burkina Faso', 'BF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (35, 35, 'Burundi', 'BI', 'Burundi', 'BI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (36, 36, 'Cambodia', 'KH', 'Cambodia', 'KH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (37, 37, 'Cameroon', 'CM', 'Cameroon', 'CM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (38, 38, 'Canada', 'CA', 'Canada', 'CA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (39, 39, 'Canary Islands', 'IC', 'Canary Islands', 'IC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (40, 40, 'Cape Verde', 'CV', 'Cape Verde', 'CV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (41, 41, 'Cayman Islands', 'KY', 'Cayman Islands', 'KY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (42, 42, 'Central African Republic', 'CF', 'Central African Republic', 'CF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (43, 43, 'Chad', 'TD', 'Chad', 'TD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (44, 44, 'Channel Islands', 'JI', 'Channel Islands', 'JI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (45, 45, 'Chile', 'CL', 'Chile', 'CL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (46, 46, 'China', 'CN', 'China', 'CN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (47, 47, 'Christmas Island', 'CX', 'Christmas Island', 'CX', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (48, 48, 'Cocos Island', 'CC', 'Cocos Island', 'CC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (50, 50, 'Comoros', 'KM', 'Comoros', 'KM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (51, 51, 'Congo', 'CG', 'Congo', 'CG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (52, 52, 'Congo Democratic Republic', 'CD', 'Congo Democratic Republic', 'CD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (53, 53, 'Cook Islands', 'CK', 'Cook Islands', 'CK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (54, 54, 'Costa Rica', 'CR', 'Costa Rica', 'CR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (55, 55, 'Cote D Ivoire', 'CI', 'Cote D Ivoire', 'CI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (56, 56, 'Croatia', 'HR', 'Croatia', 'HR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (57, 57, 'Cuba', 'CU', 'Cuba', 'CU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (58, 58, 'Curacao', 'CB', 'Curacao', 'CB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (59, 59, 'Cyprus', 'CY', 'Cyprus', 'CY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (60, 60, 'Czech Republic', 'CZ', 'Czech Republic', 'CZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (61, 61, 'Denmark', 'DK', 'Denmark', 'DK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (62, 62, 'Djibouti', 'DJ', 'Djibouti', 'DJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (63, 63, 'Dominica', 'DM', 'Dominica', 'DM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (64, 64, 'Dominican Republic', 'DO', 'Dominican Republic', 'DO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (65, 65, 'East Timor', 'TL', 'East Timor', 'TL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (66, 66, 'Ecuador', 'EC', 'Ecuador', 'EC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (67, 67, 'Egypt', 'EG', 'Egypt', 'EG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (68, 68, 'El Salvador', 'SV', 'El Salvador', 'SV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (69, 69, 'Equatorial Guinea', 'GQ', 'Equatorial Guinea', 'GQ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (70, 70, 'Eritrea', 'ER', 'Eritrea', 'ER', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (71, 71, 'Estonia', 'EE', 'Estonia', 'EE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (72, 72, 'Ethiopia', 'ET', 'Ethiopia', 'ET', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (73, 73, 'Falkland Islands', 'FK', 'Falkland Islands', 'FK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (74, 74, 'Faroe Islands', 'FO', 'Faroe Islands', 'FO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (75, 75, 'Fiji', 'FJ', 'Fiji', 'FJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (76, 76, 'Finland', 'FI', 'Finland', 'FI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (77, 77, 'France', 'FR', 'France', 'FR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (78, 78, 'French Guiana', 'GF', 'French Guiana', 'GF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (79, 79, 'French Polynesia', 'PF', 'French Polynesia', 'PF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (80, 80, 'French Southern Ter', 'TF', 'French Southern Ter', 'TF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (81, 81, 'Gabon', 'GA', 'Gabon', 'GA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (82, 82, 'Gambia', 'GM', 'Gambia', 'GM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (83, 83, 'Georgia', 'GE', 'Georgia', 'GE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (84, 84, 'Germany', 'DE', 'Germany', 'DE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (85, 85, 'Ghana', 'GH', 'Ghana', 'GH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (86, 86, 'Gibraltar', 'GI', 'Gibraltar', 'GI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (87, 87, 'Great Britain', 'GB', 'Great Britain', 'GB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (88, 88, 'Greece', 'GR', 'Greece', 'GR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (89, 89, 'Greenland', 'GL', 'Greenland', 'GL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (90, 90, 'Grenada', 'GD', 'Grenada', 'GD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (91, 91, 'Guadeloupe', 'GP', 'Guadeloupe', 'GP', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (92, 92, 'Guam', 'GU', 'Guam', 'GU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (93, 93, 'Guatemala', 'GT', 'Guatemala', 'GT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (94, 94, 'Guinea', 'GN', 'Guinea', 'GN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (95, 95, 'Guinea Bissau', 'GW', 'Guinea Bissau', 'GW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (96, 96, 'Guyana', 'GY', 'Guyana', 'GY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (97, 97, 'Haiti', 'HT', 'Haiti', 'HT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (98, 98, 'Hawaii', 'HW', 'Hawaii', 'HW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (99, 99, 'Honduras', 'HN', 'Honduras', 'HN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (100, 100, 'Hong Kong', 'HK', 'Hong Kong', 'HK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (101, 101, 'Hungary', 'HU', 'Hungary', 'HU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (102, 102, 'Iceland', 'IS', 'Iceland', 'IS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (103, 103, 'India', 'IN', 'India', 'IN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (104, 104, 'Indonesia', 'ID', 'Indonesia', 'ID', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (105, 105, 'Iran', 'IR', 'Iran', 'IR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (106, 106, 'Iraq', 'IQ', 'Iraq', 'IQ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (107, 107, 'Ireland', 'IE', 'Ireland', 'IE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (108, 108, 'Isle of Man', 'IM', 'Isle of Man', 'IM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (109, 109, 'Israel', 'IL', 'Israel', 'IL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (110, 110, 'Italy', 'IT', 'Italy', 'IT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (111, 111, 'Jamaica', 'JM', 'Jamaica', 'JM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (112, 112, 'Japan', 'JP', 'Japan', 'JP', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (113, 113, 'Jordan', 'JO', 'Jordan', 'JO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (114, 114, 'Kazakhstan', 'KZ', 'Kazakhstan', 'KZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (115, 115, 'Kenya', 'KE', 'Kenya', 'KE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (116, 116, 'Kiribati', 'KI', 'Kiribati', 'KI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (117, 117, 'Korea North', 'NK', 'Korea North', 'NK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (118, 118, 'Korea South', 'KS', 'Korea South', 'KS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (119, 119, 'Kuwait', 'KW', 'Kuwait', 'KW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (120, 120, 'Kyrgyzstan', 'KG', 'Kyrgyzstan', 'KG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (121, 121, 'Laos', 'LA', 'Laos', 'LA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (122, 122, 'Latvia', 'LV', 'Latvia', 'LV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (123, 123, 'Lebanon', 'LB', 'Lebanon', 'LB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (124, 124, 'Lesotho', 'LS', 'Lesotho', 'LS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (125, 125, 'Liberia', 'LR', 'Liberia', 'LR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (126, 126, 'Libya', 'LY', 'Libya', 'LY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (127, 127, 'Liechtenstein', 'LI', 'Liechtenstein', 'LI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (128, 128, 'Lithuania', 'LT', 'Lithuania', 'LT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (129, 129, 'Luxembourg', 'LU', 'Luxembourg', 'LU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (130, 130, 'Macau', 'MO', 'Macau', 'MO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (131, 131, 'Macedonia', 'MK', 'Macedonia', 'MK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (132, 132, 'Madagascar', 'MG', 'Madagascar', 'MG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (133, 133, 'Malawi', 'MW', 'Malawi', 'MW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (134, 134, 'Malaysia', 'MY', 'Malaysia', 'MY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (135, 135, 'Maldives', 'MV', 'Maldives', 'MV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (136, 136, 'Mali', 'ML', 'Mali', 'ML', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (137, 137, 'Malta', 'MT', 'Malta', 'MT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (138, 138, 'Marshall Islands', 'MH', 'Marshall Islands', 'MH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (139, 139, 'Martinique', 'MQ', 'Martinique', 'MQ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (140, 140, 'Mauritania', 'MR', 'Mauritania', 'MR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (141, 141, 'Mauritius', 'MU', 'Mauritius', 'MU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (142, 142, 'Mayotte', 'YT', 'Mayotte', 'YT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (143, 143, 'Mexico', 'MX', 'Mexico', 'MX', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (144, 144, 'Micronesia', 'FM', 'Micronesia', 'FM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (145, 145, 'Midway Islands', 'MI', 'Midway Islands', 'MI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (146, 146, 'Moldova', 'MD', 'Moldova', 'MD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (147, 147, 'Monaco', 'MC', 'Monaco', 'MC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (148, 148, 'Mongolia', 'MN', 'Mongolia', 'MN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (149, 149, 'Montserrat', 'MS', 'Montserrat', 'MS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (150, 150, 'Morocco', 'MA', 'Morocco', 'MA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (151, 151, 'Mozambique', 'MZ', 'Mozambique', 'MZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (152, 152, 'Myanmar', 'MM', 'Myanmar', 'MM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (153, 153, 'Nambia', 'NA', 'Nambia', 'NA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (154, 154, 'Nauru', 'NR', 'Nauru', 'NR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (155, 155, 'Nepal', 'NP', 'Nepal', 'NP', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (156, 156, 'Netherland Antilles', 'AN', 'Netherland Antilles', 'AN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (157, 157, 'Netherlands', 'NL', 'Netherlands', 'NL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (158, 158, 'New Caledonia', 'NC', 'New Caledonia', 'NC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (159, 159, 'New Zealand', 'NZ', 'New Zealand', 'NZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (160, 160, 'Nicaragua', 'NI', 'Nicaragua', 'NI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (161, 161, 'Niger', 'NE', 'Niger', 'NE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (162, 162, 'Nigeria', 'NG', 'Nigeria', 'NG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (163, 163, 'Niue', 'NU', 'Niue', 'NU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (164, 164, 'Norfolk Island', 'NF', 'Norfolk Island', 'NF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (165, 165, 'Norway', 'NO', 'Norway', 'NO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (166, 166, 'Oman', 'OM', 'Oman', 'OM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (167, 167, 'Pakistan', 'PK', 'Pakistan', 'PK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (168, 168, 'Palau Island', 'PW', 'Palau Island', 'PW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (169, 169, 'Palestine', 'PS', 'Palestine', 'PS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (170, 170, 'Panama', 'PA', 'Panama', 'PA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (171, 171, 'Papua New Guinea', 'PG', 'Papua New Guinea', 'PG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (172, 172, 'Paraguay', 'PY', 'Paraguay', 'PY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (173, 173, 'Peru', 'PE', 'Peru', 'PE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (174, 174, 'Philippines', 'PH', 'Philippines', 'PH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (175, 175, 'Pitcairn Island', 'PN', 'Pitcairn Island', 'PN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (176, 176, 'Poland', 'PL', 'Poland', 'PL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (177, 177, 'Portugal', 'PT', 'Portugal', 'PT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (178, 178, 'Puerto Rico', 'PR', 'Puerto Rico', 'PR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (179, 179, 'Qatar', 'QA', 'Qatar', 'QA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (180, 180, 'Reunion', 'RE', 'Reunion', 'RE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (181, 181, 'Romania', 'RO', 'Romania', 'RO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (182, 182, 'Russia', 'RU', 'Russia', 'RU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (183, 183, 'Rwanda', 'RW', 'Rwanda', 'RW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (184, 184, 'Samoa', 'WS', 'Samoa', 'WS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (185, 185, 'San Marino', 'SM', 'San Marino', 'SM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (186, 186, 'Sao Tome & Principe', 'ST', 'Sao Tome & Principe', 'ST', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (187, 187, 'Saudi Arabia', 'SA', 'Saudi Arabia', 'SA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (188, 188, 'Senegal', 'SN', 'Senegal', 'SN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (189, 189, 'Serbia & Montenegro', 'CS', 'Serbia & Montenegro', 'CS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (190, 190, 'Seychelles', 'SC', 'Seychelles', 'SC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (191, 191, 'Sierra Leone', 'SL', 'Sierra Leone', 'SL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (192, 192, 'Singapore', 'SG', 'Singapore', 'SG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (193, 193, 'Slovakia', 'SK', 'Slovakia', 'SK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (194, 194, 'Slovenia', 'SI', 'Slovenia', 'SI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (195, 195, 'Solomon Islands', 'SB', 'Solomon Islands', 'SB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (196, 196, 'Somalia', 'SO', 'Somalia', 'SO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (197, 197, 'South Africa', 'ZA', 'South Africa', 'ZA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (198, 198, 'Spain', 'ES', 'Spain', 'ES', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (199, 199, 'Sri Lanka', 'LK', 'Sri Lanka', 'LK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (200, 200, 'St Helena', 'SH', 'St Helena', 'SH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (201, 201, 'St Kitts-Nevis', 'KN', 'St Kitts-Nevis', 'KN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (202, 202, 'St Lucia', 'LC', 'St Lucia', 'LC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (203, 203, 'St Maarten', 'MB', 'St Maarten', 'MB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (204, 204, 'St Pierre & Miquelon', 'PM', 'St Pierre & Miquelon', 'PM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (205, 205, 'St Vincent & Grenadines', 'VC', 'St Vincent & Grenadines', 'VC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (206, 206, 'Sudan', 'SD', 'Sudan', 'SD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (207, 207, 'Suriname', 'SR', 'Suriname', 'SR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (208, 208, 'Svalbard', 'SJ', 'Svalbard', 'SJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (209, 209, 'Swaziland', 'SZ', 'Swaziland', 'SZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (210, 210, 'Sweden', 'SE', 'Sweden', 'SE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (211, 211, 'Switzerland', 'CH', 'Switzerland', 'CH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (212, 212, 'Syria', 'SY', 'Syria', 'SY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (213, 213, 'Tahiti', 'TA', 'Tahiti', 'TA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (214, 214, 'Taiwan', 'TW', 'Taiwan', 'TW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (215, 215, 'Tajikistan', 'TJ', 'Tajikistan', 'TJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (216, 216, 'Tanzania', 'TZ', 'Tanzania', 'TZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (217, 217, 'Thailand', 'TH', 'Thailand', 'TH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (218, 218, 'Togo', 'TG', 'Togo', 'TG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (219, 219, 'Tokelau', 'TK', 'Tokelau', 'TK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (220, 220, 'Tonga', 'TO', 'Tonga', 'TO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (221, 221, 'Trinidad & Tobago', 'TT', 'Trinidad & Tobago', 'TT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (222, 222, 'Tunisia', 'TN', 'Tunisia', 'TN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (223, 223, 'Turkey', 'TR', 'Turkey', 'TR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (224, 224, 'Turkmenistan', 'TM', 'Turkmenistan', 'TM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (225, 225, 'Turks & Caicos Is', 'TC', 'Turks & Caicos Is', 'TC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (226, 226, 'Tuvalu', 'TV', 'Tuvalu', 'TV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (227, 227, 'Uganda', 'UG', 'Uganda', 'UG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (228, 228, 'Ukraine', 'UA', 'Ukraine', 'UA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (229, 229, 'United Arab Emirates', 'AE', 'United Arab Emirates', 'AE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (230, 230, 'United States of America', 'US', 'United States of America', 'US', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (231, 231, 'Uruguay', 'UY', 'Uruguay', 'UY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (232, 232, 'Uzbekistan', 'UZ', 'Uzbekistan', 'UZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (233, 233, 'Vanuatu', 'VU', 'Vanuatu', 'VU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (234, 234, 'Vatican City State', 'VS', 'Vatican City State', 'VS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (235, 235, 'Venezuela', 'VE', 'Venezuela', 'VE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (236, 236, 'Vietnam', 'VN', 'Vietnam', 'VN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (237, 237, 'Virgin Islands (Brit)', 'VG', 'Virgin Islands (Brit)', 'VG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (238, 238, 'Virgin Islands (USA)', 'VI', 'Virgin Islands (USA)', 'VI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (239, 239, 'Wake Island', 'WK', 'Wake Island', 'WK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (240, 240, 'Wallis & Futana Is', 'WF', 'Wallis & Futana Is', 'WF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (241, 241, 'Western Sahara', 'EH', 'Western Sahara', 'EH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (242, 242, 'Yemen', 'YE', 'Yemen', 'YE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (243, 243, 'Zambia', 'ZM', 'Zambia', 'ZM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (244, 244, 'Zimbabwe', 'ZW', 'Zimbabwe', 'ZW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises (id_pais, orden_db, nom_pais_es, abr_pais_es, nom_pais_en, abr_pais_en, nom_pais_de, abr_pais_de, nom_pais_fr, abr_pais_fr, is_activo, cod_dane) VALUES (49, 49, 'Colombia', 'CO', 'Columbia', 'CO', NULL, NULL, NULL, NULL, true, NULL);


--
-- TOC entry 2217 (class 0 OID 47228)
-- Dependencies: 152
-- Data for Name: xcm_db_sexos; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_db_sexos (id_sexo, orden_db, nom_sexo_es, abr_sexo_es, nom_sexo_en, abr_sexo_en, nom_sexo_de, abr_sexo_de, nom_sexo_fr, abr_sexo_fr, is_activo, cod_interno) VALUES (1, 1, 'Masculino', 'M', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_sexos (id_sexo, orden_db, nom_sexo_es, abr_sexo_es, nom_sexo_en, abr_sexo_en, nom_sexo_de, abr_sexo_de, nom_sexo_fr, abr_sexo_fr, is_activo, cod_interno) VALUES (2, 2, 'Femenino', 'F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


--
-- TOC entry 2218 (class 0 OID 47237)
-- Dependencies: 154
-- Data for Name: xcm_db_tipos_dir; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_db_tipos_dir (id_tipo_dir, orden_db, nom_tipo_dir_es, abr_tipo_dir_es, nom_tipo_dir_en, abr_tipo_dir_en, nom_tipo_dir_de, abr_tipo_dir_de, nom_tipo_dir_fr, abr_tipo_dir_fr, is_activo, cod_interno) VALUES (1, 1, 'Personal', 'P', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_dir (id_tipo_dir, orden_db, nom_tipo_dir_es, abr_tipo_dir_es, nom_tipo_dir_en, abr_tipo_dir_en, nom_tipo_dir_de, abr_tipo_dir_de, nom_tipo_dir_fr, abr_tipo_dir_fr, is_activo, cod_interno) VALUES (2, 2, 'Oficina', 'O', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);


--
-- TOC entry 2237 (class 0 OID 157930)
-- Dependencies: 199
-- Data for Name: xcm_db_tipos_docs; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_db_tipos_docs (id_tipo_doc, orden_db, nom_tipo_doc, abr_tipo_doc, is_activo, cod_dian) VALUES (1, 1, 'Cedula de Ciudadania', 'C.C.', true, '13');
INSERT INTO xcm_db_tipos_docs (id_tipo_doc, orden_db, nom_tipo_doc, abr_tipo_doc, is_activo, cod_dian) VALUES (3, 3, 'NIT', 'NIT', true, NULL);
INSERT INTO xcm_db_tipos_docs (id_tipo_doc, orden_db, nom_tipo_doc, abr_tipo_doc, is_activo, cod_dian) VALUES (2, 2, 'Tarjeta de Identidad', 'T.I.', true, '12');
INSERT INTO xcm_db_tipos_docs (id_tipo_doc, orden_db, nom_tipo_doc, abr_tipo_doc, is_activo, cod_dian) VALUES (6, 6, 'Cedula de Extranjeria', 'C.E.', true, '22');
INSERT INTO xcm_db_tipos_docs (id_tipo_doc, orden_db, nom_tipo_doc, abr_tipo_doc, is_activo, cod_dian) VALUES (5, 5, 'Registro Civil de Nacimiento', 'R.C.N.', true, '11');
INSERT INTO xcm_db_tipos_docs (id_tipo_doc, orden_db, nom_tipo_doc, abr_tipo_doc, is_activo, cod_dian) VALUES (7, 7, 'Pasaporte', 'PAS.', true, '41');
INSERT INTO xcm_db_tipos_docs (id_tipo_doc, orden_db, nom_tipo_doc, abr_tipo_doc, is_activo, cod_dian) VALUES (8, 8, 'Libreta Militar', 'L.M.', true, NULL);
INSERT INTO xcm_db_tipos_docs (id_tipo_doc, orden_db, nom_tipo_doc, abr_tipo_doc, is_activo, cod_dian) VALUES (9, 9, 'Certificado Registraduría sin identificación', 'CRsI', true, '14');
INSERT INTO xcm_db_tipos_docs (id_tipo_doc, orden_db, nom_tipo_doc, abr_tipo_doc, is_activo, cod_dian) VALUES (10, 10, 'Tarjeta de Extranjeria', 'T.E.', true, '21');
INSERT INTO xcm_db_tipos_docs (id_tipo_doc, orden_db, nom_tipo_doc, abr_tipo_doc, is_activo, cod_dian) VALUES (11, 11, 'Tipo de documento Desconocido', 'D.D.', true, '32');
INSERT INTO xcm_db_tipos_docs (id_tipo_doc, orden_db, nom_tipo_doc, abr_tipo_doc, is_activo, cod_dian) VALUES (12, 12, 'Documento de Identificación Extranjero', 'D.I.E.', true, '42');
INSERT INTO xcm_db_tipos_docs (id_tipo_doc, orden_db, nom_tipo_doc, abr_tipo_doc, is_activo, cod_dian) VALUES (13, 13, 'Carné Diplomático', 'C.D.', true, '46');
INSERT INTO xcm_db_tipos_docs (id_tipo_doc, orden_db, nom_tipo_doc, abr_tipo_doc, is_activo, cod_dian) VALUES (14, 14, 'Sin identificación del exterior o para uso definido por DIAN', 'no ID', false, '43');


--
-- TOC entry 2219 (class 0 OID 47247)
-- Dependencies: 156
-- Data for Name: xcm_db_tipos_nuips; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_db_tipos_nuips (id_tipo_nuip, orden_db, nom_tipo_nuip_es, abr_tipo_nuip_es, is_activo, cod_interno) VALUES (1, 1, 'Natural', 'Per. Nat.', true, NULL);
INSERT INTO xcm_db_tipos_nuips (id_tipo_nuip, orden_db, nom_tipo_nuip_es, abr_tipo_nuip_es, is_activo, cod_interno) VALUES (2, 2, 'Juridica (Empresa)', 'Per. Jur./Empresa', true, NULL);


--
-- TOC entry 2220 (class 0 OID 47257)
-- Dependencies: 158
-- Data for Name: xcm_db_tipos_tel; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_db_tipos_tel (id_tipo_tel, orden_db, nom_tipo_tel_es, abr_tipo_tel_es, nom_tipo_tel_en, abr_tipo_tel_en, nom_tipo_tel_de, abr_tipo_tel_de, nom_tipo_tel_fr, abr_tipo_tel_fr, is_activo, cod_interno) VALUES (1, 1, 'Personal', 'Per', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_tipos_tel (id_tipo_tel, orden_db, nom_tipo_tel_es, abr_tipo_tel_es, nom_tipo_tel_en, abr_tipo_tel_en, nom_tipo_tel_de, abr_tipo_tel_de, nom_tipo_tel_fr, abr_tipo_tel_fr, is_activo, cod_interno) VALUES (2, 2, 'Trabajo', 'Tra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_tipos_tel (id_tipo_tel, orden_db, nom_tipo_tel_es, abr_tipo_tel_es, nom_tipo_tel_en, abr_tipo_tel_en, nom_tipo_tel_de, abr_tipo_tel_de, nom_tipo_tel_fr, abr_tipo_tel_fr, is_activo, cod_interno) VALUES (3, 3, 'Celular', 'Cel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_tipos_tel (id_tipo_tel, orden_db, nom_tipo_tel_es, abr_tipo_tel_es, nom_tipo_tel_en, abr_tipo_tel_en, nom_tipo_tel_de, abr_tipo_tel_de, nom_tipo_tel_fr, abr_tipo_tel_fr, is_activo, cod_interno) VALUES (4, 4, 'Fax', 'Fax', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_tipos_tel (id_tipo_tel, orden_db, nom_tipo_tel_es, abr_tipo_tel_es, nom_tipo_tel_en, abr_tipo_tel_en, nom_tipo_tel_de, abr_tipo_tel_de, nom_tipo_tel_fr, abr_tipo_tel_fr, is_activo, cod_interno) VALUES (5, 5, 'Avantel', 'Avt', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


--
-- TOC entry 2221 (class 0 OID 47266)
-- Dependencies: 160
-- Data for Name: xcm_db_titulos_nuips; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_db_titulos_nuips (id_titulo_nuip, orden_db, nom_titulo_nuip_es, abr_titulo_nuip_es, nom_titulo_nuip_en, abr_titulo_nuip_en, nom_titulo_nuip_de, abr_titulo_nuipo_de, nom_titulo_nuip_fr, abr_titulo_nuip_fr, is_activo, cod_interno) VALUES (1, 1, 'Señor', 'Sr.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_titulos_nuips (id_titulo_nuip, orden_db, nom_titulo_nuip_es, abr_titulo_nuip_es, nom_titulo_nuip_en, abr_titulo_nuip_en, nom_titulo_nuip_de, abr_titulo_nuipo_de, nom_titulo_nuip_fr, abr_titulo_nuip_fr, is_activo, cod_interno) VALUES (2, 2, 'Señorita', 'Srta.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_titulos_nuips (id_titulo_nuip, orden_db, nom_titulo_nuip_es, abr_titulo_nuip_es, nom_titulo_nuip_en, abr_titulo_nuip_en, nom_titulo_nuip_de, abr_titulo_nuipo_de, nom_titulo_nuip_fr, abr_titulo_nuip_fr, is_activo, cod_interno) VALUES (3, 3, 'Señora', 'Sra.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_titulos_nuips (id_titulo_nuip, orden_db, nom_titulo_nuip_es, abr_titulo_nuip_es, nom_titulo_nuip_en, abr_titulo_nuip_en, nom_titulo_nuip_de, abr_titulo_nuipo_de, nom_titulo_nuip_fr, abr_titulo_nuip_fr, is_activo, cod_interno) VALUES (4, 4, 'Ingeniero', 'Ing.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_titulos_nuips (id_titulo_nuip, orden_db, nom_titulo_nuip_es, abr_titulo_nuip_es, nom_titulo_nuip_en, abr_titulo_nuip_en, nom_titulo_nuip_de, abr_titulo_nuipo_de, nom_titulo_nuip_fr, abr_titulo_nuip_fr, is_activo, cod_interno) VALUES (5, 5, 'Doctor', 'Dr.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);


--
-- TOC entry 2236 (class 0 OID 54277)
-- Dependencies: 186
-- Data for Name: xcm_db_zonas_municipios; Type: TABLE DATA; Schema: public; Owner: dbxdba
--



--
-- TOC entry 2238 (class 0 OID 167181)
-- Dependencies: 201
-- Data for Name: xcm_documentos; Type: TABLE DATA; Schema: public; Owner: dbxdba
--



--
-- TOC entry 2222 (class 0 OID 47275)
-- Dependencies: 162
-- Data for Name: xcm_grupos; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_grupos (id_grupo, id_nuip_serial, nom_grupo, desc_grupo) VALUES (1, 2, 'TIAL', NULL);


--
-- TOC entry 2223 (class 0 OID 47284)
-- Dependencies: 164
-- Data for Name: xcm_grupos_permisos; Type: TABLE DATA; Schema: public; Owner: dbxdba
--



--
-- TOC entry 2225 (class 0 OID 47310)
-- Dependencies: 167
-- Data for Name: xcm_niveles_usuario; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_niveles_usuario (id_nivel_usuario, nom_nivel_usuario) VALUES (0, 'Usuario DBX');
INSERT INTO xcm_niveles_usuario (id_nivel_usuario, nom_nivel_usuario) VALUES (1, 'Usuario Propietario');
INSERT INTO xcm_niveles_usuario (id_nivel_usuario, nom_nivel_usuario) VALUES (2, 'Usuario Cliente');


--
-- TOC entry 2224 (class 0 OID 47295)
-- Dependencies: 166
-- Data for Name: xcm_nuips; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx, id_tipo_doc) VALUES (2, 1, NULL, 2, 'TIAL', NULL, NULL, NULL, NULL, 'TIAL', NULL, NULL, 'dbxdba', '2012-10-23 15:25:14.440119', 3);
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx, id_tipo_doc) VALUES (1, 900084341, 1, 2, 'Digital', 'Business', NULL, NULL, NULL, 'Digital Business DBX Ltda.', NULL, NULL, 'dbxdba', '2012-10-22 12:33:47.275006', 3);


--
-- TOC entry 2226 (class 0 OID 47319)
-- Dependencies: 169
-- Data for Name: xcm_nuips_dirs; Type: TABLE DATA; Schema: public; Owner: dbxdba
--



--
-- TOC entry 2227 (class 0 OID 47333)
-- Dependencies: 171
-- Data for Name: xcm_nuips_emails; Type: TABLE DATA; Schema: public; Owner: dbxdba
--



--
-- TOC entry 2228 (class 0 OID 47347)
-- Dependencies: 173
-- Data for Name: xcm_nuips_grupos; Type: TABLE DATA; Schema: public; Owner: dbxdba
--



--
-- TOC entry 2235 (class 0 OID 52598)
-- Dependencies: 185
-- Data for Name: xcm_nuips_perfiles; Type: TABLE DATA; Schema: public; Owner: dbxdba
--



--
-- TOC entry 2229 (class 0 OID 47358)
-- Dependencies: 175
-- Data for Name: xcm_nuips_tels; Type: TABLE DATA; Schema: public; Owner: dbxdba
--



--
-- TOC entry 2234 (class 0 OID 52585)
-- Dependencies: 183
-- Data for Name: xcm_perfiles; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_perfiles (id_perfil, nom_perfil, orden_db, is_activo) VALUES (1, 'Proveedores', 1, true);
INSERT INTO xcm_perfiles (id_perfil, nom_perfil, orden_db, is_activo) VALUES (2, 'Clientes', 1, true);
INSERT INTO xcm_perfiles (id_perfil, nom_perfil, orden_db, is_activo) VALUES (3, 'Vendedores', 1, true);


--
-- TOC entry 2230 (class 0 OID 47375)
-- Dependencies: 176
-- Data for Name: xcm_permisos; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000', '0000', 'Sistema de Seguridad', NULL, 2, true, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000000', '000000', 'Acceso al Sistema de Seguridad', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000001', '000000', 'Creación de N.U.I.P.s', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000002', '000000', 'Creación de Usuarios', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000003', '000000', 'Modificar Permisos de Usuarios', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000004', '000000', 'Creación de Grupos', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000005', '000000', 'Modificación de Permisos de Grupo', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000006', '000000', 'Cambio de Contraseña', NULL, 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000007', '000000', 'Asignar Usuarios a Grupos', 'Permite asignar Usuarios creados en el sistema a uno o varios Grupos Empresariales', 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000009', '000000', 'Asignar Permisos a Usuarios', 'Permite asignar Permisos creados en el sistema a cada uno de los Usuarios', 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('000000010', '000000', 'Asignar Permisos a Grupos', 'Permite asignar Permisos creados en el sistema a uno de los Grupos Empresariales', 3, false, NULL);
INSERT INTO xcm_permisos (id_permiso, id_padre, nom_permiso, desc_permiso, nro_nivel, is_folder, onchange) VALUES ('0000', NULL, 'Sistemas AXYS-DBX', NULL, 1, true, NULL);


--
-- TOC entry 2231 (class 0 OID 47382)
-- Dependencies: 177
-- Data for Name: xcm_usuarios; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

--INSERT INTO xcm_usuarios (login, passwd, id_nivel_usuario, id_nuip_serial, fec_creacion, is_activo, cant_sesiones_max, cant_sesiones, dm_cambia_passwd, fec_tx) VALUES ('dbxdba', '358b45870d2c2e8b8bccb5b8eca6dbc6', 1, 1, '2012-10-22 12:34:11.059725', true, 1, 0, 0, '2012-12-05 15:16:52.422744');
--INSERT INTO xcm_usuarios (login, passwd, id_nivel_usuario, id_nuip_serial, fec_creacion, is_activo, cant_sesiones_max, cant_sesiones, dm_cambia_passwd, fec_tx) VALUES ('admin', 'f5faf322b52ac64e9d7d3e4ef6e94335', 2, 2, '2012-10-23 15:26:42.662626', true, 1, 0, 0, '2012-12-05 15:16:52.422744');
INSERT INTO xcm_usuarios (login, passwd, id_nivel_usuario, id_nuip_serial, fec_creacion, is_activo, cant_sesiones_max, cant_sesiones, fec_tx) VALUES ('dbxdba', '358b45870d2c2e8b8bccb5b8eca6dbc6', 1, 1, '2012-10-22 12:34:11.059725', true, 1, 0, '2012-12-05 15:16:52.422744');
INSERT INTO xcm_usuarios (login, passwd, id_nivel_usuario, id_nuip_serial, fec_creacion, is_activo, cant_sesiones_max, cant_sesiones, fec_tx) VALUES ('admin', 'f5faf322b52ac64e9d7d3e4ef6e94335', 2, 2, '2012-10-23 15:26:42.662626', true, 1, 0, '2012-12-05 15:16:52.422744');


--
-- TOC entry 2232 (class 0 OID 47395)
-- Dependencies: 179
-- Data for Name: xcm_usuarios_grupos; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_usuarios_grupos (id_usuario_grupo, login, id_grupo) VALUES (0, 'dbxdba', 1);
INSERT INTO xcm_usuarios_grupos (id_usuario_grupo, login, id_grupo) VALUES (1, 'admin', 1);


--
-- TOC entry 2233 (class 0 OID 47410)
-- Dependencies: 181
-- Data for Name: xcm_usuarios_permisos; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (10, 'dbxdba', '000000000', '2012-10-22 14:25:38.02791', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (11, 'dbxdba', '000000001', '2012-10-22 14:25:38.02791', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (12, 'dbxdba', '000000002', '2012-10-22 14:25:38.02791', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (13, 'dbxdba', '000000003', '2012-10-22 14:25:38.02791', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (14, 'dbxdba', '000000004', '2012-10-22 14:25:38.02791', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (15, 'dbxdba', '000000005', '2012-10-22 14:25:38.02791', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (16, 'dbxdba', '000000006', '2012-10-22 14:25:38.02791', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (17, 'dbxdba', '000000007', '2012-10-22 14:25:38.02791', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (18, 'dbxdba', '000000009', '2012-10-22 14:25:38.02791', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (19, 'dbxdba', '000000010', '2012-10-22 14:25:38.02791', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (35, 'admin', '000000000', '2012-10-23 15:30:01.612207', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (36, 'admin', '000000001', '2012-10-23 15:30:01.612207', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (37, 'admin', '000000002', '2012-10-23 15:30:01.612207', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (38, 'admin', '000000003', '2012-10-23 15:30:01.612207', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (39, 'admin', '000000004', '2012-10-23 15:30:01.612207', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (40, 'admin', '000000005', '2012-10-23 15:30:01.612207', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (41, 'admin', '000000006', '2012-10-23 15:30:01.612207', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (42, 'admin', '000000007', '2012-10-23 15:30:01.612207', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (43, 'admin', '000000009', '2012-10-23 15:30:01.612207', 'dbxdba');
INSERT INTO xcm_usuarios_permisos (id_usuario_permiso, login, id_permiso, fec_tx, login_admin) VALUES (44, 'admin', '000000010', '2012-10-23 15:30:01.612207', 'dbxdba');


--
-- TOC entry 2112 (class 2606 OID 47427)
-- Dependencies: 162 162
-- Name: ak_cunom_grupo_xcm_grup; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_grupos
    ADD CONSTRAINT ak_cunom_grupo_xcm_grup UNIQUE (nom_grupo);


--
-- TOC entry 2148 (class 2606 OID 47429)
-- Dependencies: 181 181 181
-- Name: ak_login_permiso_xcm_usua; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT ak_login_permiso_xcm_usua UNIQUE (login, id_permiso);


--
-- TOC entry 2124 (class 2606 OID 47431)
-- Dependencies: 167 167
-- Name: ak_nivel_xcm_nive; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_niveles_usuario
    ADD CONSTRAINT ak_nivel_xcm_nive UNIQUE (nom_nivel_usuario);


--
-- TOC entry 2137 (class 2606 OID 47433)
-- Dependencies: 176 176
-- Name: ak_nom_permiso_xcm_perm; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_permisos
    ADD CONSTRAINT ak_nom_permiso_xcm_perm UNIQUE (nom_permiso);


--
-- TOC entry 2166 (class 2606 OID 167193)
-- Dependencies: 201 201 201 201 201 201
-- Name: cu_documento; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_documentos
    ADD CONSTRAINT cu_documento UNIQUE (nom_schema, nom_tabla, nom_campo, id_grupo, nom_doc);


--
-- TOC entry 2117 (class 2606 OID 47441)
-- Dependencies: 164 164 164
-- Name: cu_id_permiso_id_grupo; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT cu_id_permiso_id_grupo UNIQUE (id_grupo, id_permiso);


--
-- TOC entry 2168 (class 2606 OID 167191)
-- Dependencies: 201 201
-- Name: pk_documentos; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_documentos
    ADD CONSTRAINT pk_documentos PRIMARY KEY (id_doc);


--
-- TOC entry 2092 (class 2606 OID 47451)
-- Dependencies: 144 144 144 144
-- Name: pk_xcm_campos_db; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_campos_db
    ADD CONSTRAINT pk_xcm_campos_db PRIMARY KEY (nom_esquema, nom_tabla, nom_columna);


--
-- TOC entry 2095 (class 2606 OID 47453)
-- Dependencies: 146 146
-- Name: pk_xcm_db_departamentos; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_db_departamentos
    ADD CONSTRAINT pk_xcm_db_departamentos PRIMARY KEY (id_depto);


--
-- TOC entry 2097 (class 2606 OID 47455)
-- Dependencies: 148 148
-- Name: pk_xcm_db_municipios; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_db_municipios
    ADD CONSTRAINT pk_xcm_db_municipios PRIMARY KEY (id_municipio);


--
-- TOC entry 2100 (class 2606 OID 47457)
-- Dependencies: 150 150
-- Name: pk_xcm_db_paises; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_db_paises
    ADD CONSTRAINT pk_xcm_db_paises PRIMARY KEY (id_pais);


--
-- TOC entry 2102 (class 2606 OID 47459)
-- Dependencies: 152 152
-- Name: pk_xcm_db_sexos; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_db_sexos
    ADD CONSTRAINT pk_xcm_db_sexos PRIMARY KEY (id_sexo);


--
-- TOC entry 2164 (class 2606 OID 157939)
-- Dependencies: 199 199
-- Name: pk_xcm_db_tipos_docs; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_db_tipos_docs
    ADD CONSTRAINT pk_xcm_db_tipos_docs PRIMARY KEY (id_tipo_doc);


--
-- TOC entry 2106 (class 2606 OID 47461)
-- Dependencies: 156 156
-- Name: pk_xcm_db_tipos_nuips; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_db_tipos_nuips
    ADD CONSTRAINT pk_xcm_db_tipos_nuips PRIMARY KEY (id_tipo_nuip);


--
-- TOC entry 2108 (class 2606 OID 47463)
-- Dependencies: 158 158
-- Name: pk_xcm_db_tipos_tel; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_db_tipos_tel
    ADD CONSTRAINT pk_xcm_db_tipos_tel PRIMARY KEY (id_tipo_tel);


--
-- TOC entry 2110 (class 2606 OID 47465)
-- Dependencies: 160 160
-- Name: pk_xcm_db_titulos_nuips; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_db_titulos_nuips
    ADD CONSTRAINT pk_xcm_db_titulos_nuips PRIMARY KEY (id_titulo_nuip);


--
-- TOC entry 2115 (class 2606 OID 47467)
-- Dependencies: 162 162
-- Name: pk_xcm_grupos; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_grupos
    ADD CONSTRAINT pk_xcm_grupos PRIMARY KEY (id_grupo);


--
-- TOC entry 2119 (class 2606 OID 47469)
-- Dependencies: 164 164
-- Name: pk_xcm_grupos_permisos; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT pk_xcm_grupos_permisos PRIMARY KEY (id_grupo_permiso);


--
-- TOC entry 2126 (class 2606 OID 47471)
-- Dependencies: 167 167
-- Name: pk_xcm_niveles_usuario; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_niveles_usuario
    ADD CONSTRAINT pk_xcm_niveles_usuario PRIMARY KEY (id_nivel_usuario);


--
-- TOC entry 2122 (class 2606 OID 47473)
-- Dependencies: 166 166
-- Name: pk_xcm_nuips; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT pk_xcm_nuips PRIMARY KEY (id_nuip_serial);


--
-- TOC entry 2128 (class 2606 OID 47475)
-- Dependencies: 169 169
-- Name: pk_xcm_nuips_dirs; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT pk_xcm_nuips_dirs PRIMARY KEY (id_nuip_dir);


--
-- TOC entry 2130 (class 2606 OID 47477)
-- Dependencies: 171 171
-- Name: pk_xcm_nuips_emails; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_nuips_emails
    ADD CONSTRAINT pk_xcm_nuips_emails PRIMARY KEY (id_nuip_email);


--
-- TOC entry 2133 (class 2606 OID 47479)
-- Dependencies: 173 173
-- Name: pk_xcm_nuips_grupos; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_nuips_grupos
    ADD CONSTRAINT pk_xcm_nuips_grupos PRIMARY KEY (id_nuip_grupo);


--
-- TOC entry 2135 (class 2606 OID 47481)
-- Dependencies: 175 175
-- Name: pk_xcm_nuips_tels; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_nuips_tels
    ADD CONSTRAINT pk_xcm_nuips_tels PRIMARY KEY (id_nuip_tel);


--
-- TOC entry 2139 (class 2606 OID 47483)
-- Dependencies: 176 176
-- Name: pk_xcm_permisos; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_permisos
    ADD CONSTRAINT pk_xcm_permisos PRIMARY KEY (id_permiso);


--
-- TOC entry 2104 (class 2606 OID 47485)
-- Dependencies: 154 154
-- Name: pk_xcm_tipos_dir; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_db_tipos_dir
    ADD CONSTRAINT pk_xcm_tipos_dir PRIMARY KEY (id_tipo_dir);


--
-- TOC entry 2142 (class 2606 OID 47487)
-- Dependencies: 177 177
-- Name: pk_xcm_usuarios; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_usuarios
    ADD CONSTRAINT pk_xcm_usuarios PRIMARY KEY (login);


--
-- TOC entry 2144 (class 2606 OID 47489)
-- Dependencies: 179 179
-- Name: pk_xcm_usuarios_grupos; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_usuarios_grupos
    ADD CONSTRAINT pk_xcm_usuarios_grupos PRIMARY KEY (id_usuario_grupo);


--
-- TOC entry 2150 (class 2606 OID 47491)
-- Dependencies: 181 181
-- Name: pk_xcm_usuarios_permisos; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT pk_xcm_usuarios_permisos PRIMARY KEY (id_usuario_permiso);


--
-- TOC entry 2170 (class 2606 OID 175629)
-- Dependencies: 203 203
-- Name: xcm_cnf_axys_nom_cnf_axys_key; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_cnf_axys
    ADD CONSTRAINT xcm_cnf_axys_nom_cnf_axys_key UNIQUE (nom_cnf_axys);


--
-- TOC entry 2172 (class 2606 OID 175592)
-- Dependencies: 203 203
-- Name: xcm_cnf_axys_pkey; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_cnf_axys
    ADD CONSTRAINT xcm_cnf_axys_pkey PRIMARY KEY (id_cnf_axys);


--
-- TOC entry 2174 (class 2606 OID 175656)
-- Dependencies: 205 205 205 205 205
-- Name: xcm_cnf_grupos_axys_nom_cnf_axys_key; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_cnf_grupos_axys
    ADD CONSTRAINT xcm_cnf_grupos_axys_nom_cnf_axys_key UNIQUE (nom_cnf_axys, vr_cnf_axys, id_grupo, login);


--
-- TOC entry 2176 (class 2606 OID 175625)
-- Dependencies: 205 205
-- Name: xcm_cnf_grupos_axys_pkey; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_cnf_grupos_axys
    ADD CONSTRAINT xcm_cnf_grupos_axys_pkey PRIMARY KEY (id_cnf_grupo_axys);


--
-- TOC entry 2160 (class 2606 OID 54351)
-- Dependencies: 186 186
-- Name: xcm_db_zonas_municipios_cod_interno_key; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_db_zonas_municipios
    ADD CONSTRAINT xcm_db_zonas_municipios_cod_interno_key UNIQUE (cod_interno);


--
-- TOC entry 2162 (class 2606 OID 54353)
-- Dependencies: 186 186
-- Name: xcm_db_zonas_municipios_pkey; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_db_zonas_municipios
    ADD CONSTRAINT xcm_db_zonas_municipios_pkey PRIMARY KEY (id_zona_mun);


--
-- TOC entry 2156 (class 2606 OID 52610)
-- Dependencies: 185 185 185 185
-- Name: xcm_nuips_perfiles_id_nuip_serial_key; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_nuips_perfiles
    ADD CONSTRAINT xcm_nuips_perfiles_id_nuip_serial_key UNIQUE (id_nuip_serial, id_perfil, id_grupo);


--
-- TOC entry 2158 (class 2606 OID 52608)
-- Dependencies: 185 185
-- Name: xcm_nuips_perfiles_pkey; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_nuips_perfiles
    ADD CONSTRAINT xcm_nuips_perfiles_pkey PRIMARY KEY (id_nuip_perfil);


--
-- TOC entry 2152 (class 2606 OID 52595)
-- Dependencies: 183 183
-- Name: xcm_perfiles_nom_perfil_key; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_perfiles
    ADD CONSTRAINT xcm_perfiles_nom_perfil_key UNIQUE (nom_perfil);


--
-- TOC entry 2154 (class 2606 OID 52593)
-- Dependencies: 183 183
-- Name: xcm_perfiles_pkey; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_perfiles
    ADD CONSTRAINT xcm_perfiles_pkey PRIMARY KEY (id_perfil);


--
-- TOC entry 2146 (class 2606 OID 54459)
-- Dependencies: 179 179 179
-- Name: xcm_usuarios_grupos_login_key; Type: CONSTRAINT; Schema: public; Owner: dbxdba; Tablespace:
--

ALTER TABLE ONLY xcm_usuarios_grupos
    ADD CONSTRAINT xcm_usuarios_grupos_login_key UNIQUE (login, id_grupo);


--
-- TOC entry 2140 (class 1259 OID 47492)
-- Dependencies: 177
-- Name: cu_login; Type: INDEX; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE UNIQUE INDEX cu_login ON xcm_usuarios USING btree (login);


--
-- TOC entry 2113 (class 1259 OID 47493)
-- Dependencies: 162
-- Name: idx_grupo; Type: INDEX; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE INDEX idx_grupo ON xcm_grupos USING btree (nom_grupo);


--
-- TOC entry 2098 (class 1259 OID 47494)
-- Dependencies: 150
-- Name: idx_nom_pais_es; Type: INDEX; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE INDEX idx_nom_pais_es ON xcm_db_paises USING btree (nom_pais_es);


--
-- TOC entry 2120 (class 1259 OID 47495)
-- Dependencies: 166 166
-- Name: idx_nombres_apellidos; Type: INDEX; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE INDEX idx_nombres_apellidos ON xcm_nuips USING btree (nom_nuip, ape_nuip);


--
-- TOC entry 2131 (class 1259 OID 53991)
-- Dependencies: 173 173
-- Name: idx_nuips_grupos_id_grupo; Type: INDEX; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE UNIQUE INDEX idx_nuips_grupos_id_grupo ON xcm_nuips_grupos USING btree (id_nuip_serial, id_grupo);


--
-- TOC entry 2093 (class 1259 OID 47497)
-- Dependencies: 146
-- Name: ix_rpais; Type: INDEX; Schema: public; Owner: dbxdba; Tablespace:
--

CREATE INDEX ix_rpais ON xcm_db_departamentos USING btree (id_pais);


--
-- TOC entry 2207 (class 2606 OID 167194)
-- Dependencies: 2114 162 201
-- Name: FK_id_grupo; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_documentos
    ADD CONSTRAINT "FK_id_grupo" FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE;


--
-- TOC entry 2192 (class 2606 OID 47503)
-- Dependencies: 173 2121 166
-- Name: fk___nuips_gru_nuips; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips_grupos
    ADD CONSTRAINT fk___nuips_gru_nuips FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2177 (class 2606 OID 47508)
-- Dependencies: 2099 150 146
-- Name: fk__db_deptos_db_paises; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_db_departamentos
    ADD CONSTRAINT fk__db_deptos_db_paises FOREIGN KEY (id_pais) REFERENCES xcm_db_paises(id_pais) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2178 (class 2606 OID 47513)
-- Dependencies: 2094 146 148
-- Name: fk__db_munici_db_depar; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_db_municipios
    ADD CONSTRAINT fk__db_munici_db_depar FOREIGN KEY (id_depto) REFERENCES xcm_db_departamentos(id_depto) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2196 (class 2606 OID 47518)
-- Dependencies: 176 2138 176
-- Name: fk__id_permiso_id_padre; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_permisos
    ADD CONSTRAINT fk__id_permiso_id_padre FOREIGN KEY (id_padre) REFERENCES xcm_permisos(id_permiso) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2193 (class 2606 OID 47523)
-- Dependencies: 2114 162 173
-- Name: fk__nuips_nuips_grupos; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips_grupos
    ADD CONSTRAINT fk__nuips_nuips_grupos FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2180 (class 2606 OID 47528)
-- Dependencies: 2114 164 162
-- Name: fk__permisos_grupos_grupos; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT fk__permisos_grupos_grupos FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2199 (class 2606 OID 47533)
-- Dependencies: 177 2141 179
-- Name: fk__usuarios_grupos__usuarios; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_usuarios_grupos
    ADD CONSTRAINT fk__usuarios_grupos__usuarios FOREIGN KEY (login) REFERENCES xcm_usuarios(login) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2197 (class 2606 OID 47538)
-- Dependencies: 167 177 2125
-- Name: fk__usuarios_niveles_usuario; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_usuarios
    ADD CONSTRAINT fk__usuarios_niveles_usuario FOREIGN KEY (id_nivel_usuario) REFERENCES xcm_niveles_usuario(id_nivel_usuario) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2198 (class 2606 OID 47543)
-- Dependencies: 166 2121 177
-- Name: fk__usuarios_nuips; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_usuarios
    ADD CONSTRAINT fk__usuarios_nuips FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2200 (class 2606 OID 47548)
-- Dependencies: 2114 179 162
-- Name: fk__usuarios_usuarios__grupos; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_usuarios_grupos
    ADD CONSTRAINT fk__usuarios_usuarios__grupos FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2182 (class 2606 OID 47553)
-- Dependencies: 152 166 2101
-- Name: fk_db_sexos_1; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT fk_db_sexos_1 FOREIGN KEY (id_sexo) REFERENCES xcm_db_sexos(id_sexo) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2183 (class 2606 OID 47558)
-- Dependencies: 2105 166 156
-- Name: fk_db_tipos_nuip_1; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT fk_db_tipos_nuip_1 FOREIGN KEY (id_tipo_nuip) REFERENCES xcm_db_tipos_nuips(id_tipo_nuip) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2184 (class 2606 OID 47573)
-- Dependencies: 160 166 2109
-- Name: fk_titulos_nuip_1; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT fk_titulos_nuip_1 FOREIGN KEY (id_titulo_nuip) REFERENCES xcm_db_titulos_nuips(id_titulo_nuip) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2201 (class 2606 OID 47578)
-- Dependencies: 2138 176 181
-- Name: fk_usuarios__permisos_permiso; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT fk_usuarios__permisos_permiso FOREIGN KEY (id_permiso) REFERENCES xcm_permisos(id_permiso) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2202 (class 2606 OID 47583)
-- Dependencies: 181 177 2141
-- Name: fk_usuarios_permisos__usuarios; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT fk_usuarios_permisos__usuarios FOREIGN KEY (login) REFERENCES xcm_usuarios(login) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2179 (class 2606 OID 47588)
-- Dependencies: 162 166 2121
-- Name: fk_xcm_grup_grupos_nu_xcm_nuip; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_grupos
    ADD CONSTRAINT fk_xcm_grup_grupos_nu_xcm_nuip FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2181 (class 2606 OID 47593)
-- Dependencies: 164 176 2138
-- Name: fk_xcm_grup_gruposper_xcm_perm; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT fk_xcm_grup_gruposper_xcm_perm FOREIGN KEY (id_permiso) REFERENCES xcm_permisos(id_permiso) ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- TOC entry 2190 (class 2606 OID 47598)
-- Dependencies: 171 154 2103
-- Name: fk_xcm_nuip_email_nuip_tipos; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips_emails
    ADD CONSTRAINT fk_xcm_nuip_email_nuip_tipos FOREIGN KEY (id_tipo_dir) REFERENCES xcm_db_tipos_dir(id_tipo_dir) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2187 (class 2606 OID 47603)
-- Dependencies: 2103 169 154
-- Name: fk_xcm_nuip_nuipsdirs_xcm_nuip; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT fk_xcm_nuip_nuipsdirs_xcm_nuip FOREIGN KEY (id_tipo_dir) REFERENCES xcm_db_tipos_dir(id_tipo_dir) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2194 (class 2606 OID 47608)
-- Dependencies: 175 158 2107
-- Name: fk_xcm_nuip_nuipstels_xcm_db_t; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips_tels
    ADD CONSTRAINT fk_xcm_nuip_nuipstels_xcm_db_t FOREIGN KEY (id_tipo_tel) REFERENCES xcm_db_tipos_tel(id_tipo_tel) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2188 (class 2606 OID 47613)
-- Dependencies: 166 169 2121
-- Name: fk_xcm_nuips_dirs; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT fk_xcm_nuips_dirs FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2191 (class 2606 OID 47618)
-- Dependencies: 2121 166 171
-- Name: fk_xcm_nuips_emails_nuip; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips_emails
    ADD CONSTRAINT fk_xcm_nuips_emails_nuip FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2195 (class 2606 OID 47623)
-- Dependencies: 2121 166 175
-- Name: fk_xcm_nuips_tels_nuip; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips_tels
    ADD CONSTRAINT fk_xcm_nuips_tels_nuip FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2208 (class 2606 OID 175595)
-- Dependencies: 177 2141 203
-- Name: xcm_cnf_axys_login_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_cnf_axys
    ADD CONSTRAINT xcm_cnf_axys_login_fkey FOREIGN KEY (login) REFERENCES xcm_usuarios(login) ON UPDATE CASCADE;


--
-- TOC entry 2211 (class 2606 OID 175650)
-- Dependencies: 2114 162 205
-- Name: xcm_cnf_grupos_axys_id_grupo_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_cnf_grupos_axys
    ADD CONSTRAINT xcm_cnf_grupos_axys_id_grupo_fkey FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE;


--
-- TOC entry 2209 (class 2606 OID 175640)
-- Dependencies: 205 177 2141
-- Name: xcm_cnf_grupos_axys_login_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_cnf_grupos_axys
    ADD CONSTRAINT xcm_cnf_grupos_axys_login_fkey FOREIGN KEY (login) REFERENCES xcm_usuarios(login) ON UPDATE CASCADE;


--
-- TOC entry 2210 (class 2606 OID 175645)
-- Dependencies: 205 2141 177
-- Name: xcm_cnf_grupos_axys_login_tx_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_cnf_grupos_axys
    ADD CONSTRAINT xcm_cnf_grupos_axys_login_tx_fkey FOREIGN KEY (login_tx) REFERENCES xcm_usuarios(login) ON UPDATE CASCADE;


--
-- TOC entry 2212 (class 2606 OID 184133)
-- Dependencies: 203 205 2169
-- Name: xcm_cnf_grupos_axys_nom_cnf_axys_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_cnf_grupos_axys
    ADD CONSTRAINT xcm_cnf_grupos_axys_nom_cnf_axys_fkey FOREIGN KEY (nom_cnf_axys) REFERENCES xcm_cnf_axys(nom_cnf_axys) ON UPDATE CASCADE;


--
-- TOC entry 2206 (class 2606 OID 54401)
-- Dependencies: 2096 148 186
-- Name: xcm_db_zonas_municipios_id_municipio_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_db_zonas_municipios
    ADD CONSTRAINT xcm_db_zonas_municipios_id_municipio_fkey FOREIGN KEY (id_municipio) REFERENCES xcm_db_municipios(id_municipio) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2189 (class 2606 OID 52743)
-- Dependencies: 169 2096 148
-- Name: xcm_nuips_dirs_id_municipio_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT xcm_nuips_dirs_id_municipio_fkey FOREIGN KEY (id_municipio) REFERENCES xcm_db_municipios(id_municipio) ON UPDATE CASCADE;


--
-- TOC entry 2186 (class 2606 OID 157945)
-- Dependencies: 2163 166 199
-- Name: xcm_nuips_id_tipo_doc_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT xcm_nuips_id_tipo_doc_fkey FOREIGN KEY (id_tipo_doc) REFERENCES xcm_db_tipos_docs(id_tipo_doc) ON UPDATE CASCADE;


--
-- TOC entry 2185 (class 2606 OID 52763)
-- Dependencies: 166 177 2141
-- Name: xcm_nuips_login_tx_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT xcm_nuips_login_tx_fkey FOREIGN KEY (login_tx) REFERENCES xcm_usuarios(login) ON UPDATE CASCADE;


--
-- TOC entry 2205 (class 2606 OID 52621)
-- Dependencies: 185 2114 162
-- Name: xcm_nuips_perfiles_id_grupo_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips_perfiles
    ADD CONSTRAINT xcm_nuips_perfiles_id_grupo_fkey FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE;


--
-- TOC entry 2203 (class 2606 OID 52611)
-- Dependencies: 166 185 2121
-- Name: xcm_nuips_perfiles_id_nuip_serial_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips_perfiles
    ADD CONSTRAINT xcm_nuips_perfiles_id_nuip_serial_fkey FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE;


--
-- TOC entry 2204 (class 2606 OID 52616)
-- Dependencies: 185 183 2153
-- Name: xcm_nuips_perfiles_id_perfil_fkey; Type: FK CONSTRAINT; Schema: public; Owner: dbxdba
--

ALTER TABLE ONLY xcm_nuips_perfiles
    ADD CONSTRAINT xcm_nuips_perfiles_id_perfil_fkey FOREIGN KEY (id_perfil) REFERENCES xcm_perfiles(id_perfil) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 2246 (class 0 OID 0)
-- Dependencies: 3
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- TOC entry 2258 (class 0 OID 0)
-- Dependencies: 144
-- Name: xcm_campos_db; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_campos_db FROM PUBLIC;
REVOKE ALL ON TABLE xcm_campos_db FROM dbxdba;
GRANT ALL ON TABLE xcm_campos_db TO dbxdba;


--
-- TOC entry 2266 (class 0 OID 0)
-- Dependencies: 145
-- Name: xcm_db_departamentos_id_depto_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_db_departamentos_id_depto_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_departamentos_id_depto_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_db_departamentos_id_depto_seq TO dbxdba;


--
-- TOC entry 2268 (class 0 OID 0)
-- Dependencies: 146
-- Name: xcm_db_departamentos; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_db_departamentos FROM PUBLIC;
REVOKE ALL ON TABLE xcm_db_departamentos FROM dbxdba;
GRANT ALL ON TABLE xcm_db_departamentos TO dbxdba;


--
-- TOC entry 2270 (class 0 OID 0)
-- Dependencies: 147
-- Name: xcm_db_municipios_id_municipio_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_db_municipios_id_municipio_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_municipios_id_municipio_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_db_municipios_id_municipio_seq TO dbxdba;


--
-- TOC entry 2271 (class 0 OID 0)
-- Dependencies: 148
-- Name: xcm_db_municipios; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_db_municipios FROM PUBLIC;
REVOKE ALL ON TABLE xcm_db_municipios FROM dbxdba;
GRANT ALL ON TABLE xcm_db_municipios TO dbxdba;


--
-- TOC entry 2273 (class 0 OID 0)
-- Dependencies: 149
-- Name: xcm_db_paises_id_pais_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_db_paises_id_pais_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_paises_id_pais_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_db_paises_id_pais_seq TO dbxdba;


--
-- TOC entry 2274 (class 0 OID 0)
-- Dependencies: 150
-- Name: xcm_db_paises; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_db_paises FROM PUBLIC;
REVOKE ALL ON TABLE xcm_db_paises FROM dbxdba;
GRANT ALL ON TABLE xcm_db_paises TO dbxdba;


--
-- TOC entry 2276 (class 0 OID 0)
-- Dependencies: 151
-- Name: xcm_db_sexos_id_sexo_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_db_sexos_id_sexo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_sexos_id_sexo_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_db_sexos_id_sexo_seq TO dbxdba;


--
-- TOC entry 2277 (class 0 OID 0)
-- Dependencies: 152
-- Name: xcm_db_sexos; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_db_sexos FROM PUBLIC;
REVOKE ALL ON TABLE xcm_db_sexos FROM dbxdba;
GRANT ALL ON TABLE xcm_db_sexos TO dbxdba;


--
-- TOC entry 2279 (class 0 OID 0)
-- Dependencies: 153
-- Name: xcm_tipos_dir_id_tipo_dir_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_tipos_dir_id_tipo_dir_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_tipos_dir_id_tipo_dir_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_tipos_dir_id_tipo_dir_seq TO dbxdba;


--
-- TOC entry 2280 (class 0 OID 0)
-- Dependencies: 154
-- Name: xcm_db_tipos_dir; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_db_tipos_dir FROM PUBLIC;
REVOKE ALL ON TABLE xcm_db_tipos_dir FROM dbxdba;
GRANT ALL ON TABLE xcm_db_tipos_dir TO dbxdba;


--
-- TOC entry 2281 (class 0 OID 0)
-- Dependencies: 199
-- Name: xcm_db_tipos_docs; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_db_tipos_docs FROM PUBLIC;
REVOKE ALL ON TABLE xcm_db_tipos_docs FROM dbxdba;
GRANT ALL ON TABLE xcm_db_tipos_docs TO dbxdba;


--
-- TOC entry 2285 (class 0 OID 0)
-- Dependencies: 155
-- Name: xcm_db_tipos_nuips_id_tipo_nuip_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_db_tipos_nuips_id_tipo_nuip_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_tipos_nuips_id_tipo_nuip_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_db_tipos_nuips_id_tipo_nuip_seq TO dbxdba;


--
-- TOC entry 2286 (class 0 OID 0)
-- Dependencies: 156
-- Name: xcm_db_tipos_nuips; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_db_tipos_nuips FROM PUBLIC;
REVOKE ALL ON TABLE xcm_db_tipos_nuips FROM dbxdba;
GRANT ALL ON TABLE xcm_db_tipos_nuips TO dbxdba;


--
-- TOC entry 2288 (class 0 OID 0)
-- Dependencies: 157
-- Name: xcm_db_tipos_tel_id_tipo_tel_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_db_tipos_tel_id_tipo_tel_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_tipos_tel_id_tipo_tel_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_db_tipos_tel_id_tipo_tel_seq TO dbxdba;


--
-- TOC entry 2289 (class 0 OID 0)
-- Dependencies: 158
-- Name: xcm_db_tipos_tel; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_db_tipos_tel FROM PUBLIC;
REVOKE ALL ON TABLE xcm_db_tipos_tel FROM dbxdba;
GRANT ALL ON TABLE xcm_db_tipos_tel TO dbxdba;


--
-- TOC entry 2291 (class 0 OID 0)
-- Dependencies: 159
-- Name: xcm_db_titulos_nuips_id_titulo_nuip_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_db_titulos_nuips_id_titulo_nuip_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_db_titulos_nuips_id_titulo_nuip_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_db_titulos_nuips_id_titulo_nuip_seq TO dbxdba;


--
-- TOC entry 2292 (class 0 OID 0)
-- Dependencies: 160
-- Name: xcm_db_titulos_nuips; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_db_titulos_nuips FROM PUBLIC;
REVOKE ALL ON TABLE xcm_db_titulos_nuips FROM dbxdba;
GRANT ALL ON TABLE xcm_db_titulos_nuips TO dbxdba;


--
-- TOC entry 2300 (class 0 OID 0)
-- Dependencies: 161
-- Name: xcm_grupos_id_grupo_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_grupos_id_grupo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_grupos_id_grupo_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_grupos_id_grupo_seq TO dbxdba;


--
-- TOC entry 2301 (class 0 OID 0)
-- Dependencies: 162
-- Name: xcm_grupos; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_grupos FROM PUBLIC;
REVOKE ALL ON TABLE xcm_grupos FROM dbxdba;
GRANT ALL ON TABLE xcm_grupos TO dbxdba;


--
-- TOC entry 2303 (class 0 OID 0)
-- Dependencies: 163
-- Name: xcm_grupos_permisos_id_grupo_permiso_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_grupos_permisos_id_grupo_permiso_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_grupos_permisos_id_grupo_permiso_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_grupos_permisos_id_grupo_permiso_seq TO dbxdba;


--
-- TOC entry 2304 (class 0 OID 0)
-- Dependencies: 164
-- Name: xcm_grupos_permisos; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_grupos_permisos FROM PUBLIC;
REVOKE ALL ON TABLE xcm_grupos_permisos FROM dbxdba;
GRANT ALL ON TABLE xcm_grupos_permisos TO dbxdba;


--
-- TOC entry 2306 (class 0 OID 0)
-- Dependencies: 165
-- Name: xcm_nuips_id_nuip_serial_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_nuips_id_nuip_serial_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_id_nuip_serial_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_nuips_id_nuip_serial_seq TO dbxdba;


--
-- TOC entry 2307 (class 0 OID 0)
-- Dependencies: 166
-- Name: xcm_nuips; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_nuips FROM PUBLIC;
REVOKE ALL ON TABLE xcm_nuips FROM dbxdba;
GRANT ALL ON TABLE xcm_nuips TO dbxdba;


--
-- TOC entry 2308 (class 0 OID 0)
-- Dependencies: 196
-- Name: xcm_grupos_v1; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_grupos_v1 FROM PUBLIC;
REVOKE ALL ON TABLE xcm_grupos_v1 FROM dbxdba;
GRANT ALL ON TABLE xcm_grupos_v1 TO dbxdba;


--
-- TOC entry 2309 (class 0 OID 0)
-- Dependencies: 197
-- Name: xcm_municipios_deptos_paises_v1; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_municipios_deptos_paises_v1 FROM PUBLIC;
REVOKE ALL ON TABLE xcm_municipios_deptos_paises_v1 FROM dbxdba;
GRANT ALL ON TABLE xcm_municipios_deptos_paises_v1 TO dbxdba;


--
-- TOC entry 2310 (class 0 OID 0)
-- Dependencies: 167
-- Name: xcm_niveles_usuario; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_niveles_usuario FROM PUBLIC;
REVOKE ALL ON TABLE xcm_niveles_usuario FROM dbxdba;
GRANT ALL ON TABLE xcm_niveles_usuario TO dbxdba;


--
-- TOC entry 2312 (class 0 OID 0)
-- Dependencies: 168
-- Name: xcm_nuips_dirs_id_nuip_dir_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_nuips_dirs_id_nuip_dir_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_dirs_id_nuip_dir_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_nuips_dirs_id_nuip_dir_seq TO dbxdba;


--
-- TOC entry 2313 (class 0 OID 0)
-- Dependencies: 169
-- Name: xcm_nuips_dirs; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_nuips_dirs FROM PUBLIC;
REVOKE ALL ON TABLE xcm_nuips_dirs FROM dbxdba;
GRANT ALL ON TABLE xcm_nuips_dirs TO dbxdba;


--
-- TOC entry 2315 (class 0 OID 0)
-- Dependencies: 170
-- Name: xcm_nuips_emails_id_nuip_email_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_nuips_emails_id_nuip_email_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_emails_id_nuip_email_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_nuips_emails_id_nuip_email_seq TO dbxdba;


--
-- TOC entry 2316 (class 0 OID 0)
-- Dependencies: 171
-- Name: xcm_nuips_emails; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_nuips_emails FROM PUBLIC;
REVOKE ALL ON TABLE xcm_nuips_emails FROM dbxdba;
GRANT ALL ON TABLE xcm_nuips_emails TO dbxdba;


--
-- TOC entry 2317 (class 0 OID 0)
-- Dependencies: 189
-- Name: xcm_nuips_emails_v1; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_nuips_emails_v1 FROM PUBLIC;
REVOKE ALL ON TABLE xcm_nuips_emails_v1 FROM dbxdba;
GRANT ALL ON TABLE xcm_nuips_emails_v1 TO dbxdba;


--
-- TOC entry 2319 (class 0 OID 0)
-- Dependencies: 172
-- Name: xcm_nuips_grupos_id_nuip_grupo_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_nuips_grupos_id_nuip_grupo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_grupos_id_nuip_grupo_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_nuips_grupos_id_nuip_grupo_seq TO dbxdba;


--
-- TOC entry 2320 (class 0 OID 0)
-- Dependencies: 173
-- Name: xcm_nuips_grupos; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_nuips_grupos FROM PUBLIC;
REVOKE ALL ON TABLE xcm_nuips_grupos FROM dbxdba;
GRANT ALL ON TABLE xcm_nuips_grupos TO dbxdba;


--
-- TOC entry 2321 (class 0 OID 0)
-- Dependencies: 190
-- Name: xcm_nuips_grupos_v1; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_nuips_grupos_v1 FROM PUBLIC;
REVOKE ALL ON TABLE xcm_nuips_grupos_v1 FROM dbxdba;
GRANT ALL ON TABLE xcm_nuips_grupos_v1 TO dbxdba;


--
-- TOC entry 2327 (class 0 OID 0)
-- Dependencies: 174
-- Name: xcm_nuips_tels_id_nuip_tel_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_nuips_tels_id_nuip_tel_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_nuips_tels_id_nuip_tel_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_nuips_tels_id_nuip_tel_seq TO dbxdba;


--
-- TOC entry 2328 (class 0 OID 0)
-- Dependencies: 175
-- Name: xcm_nuips_tels; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_nuips_tels FROM PUBLIC;
REVOKE ALL ON TABLE xcm_nuips_tels FROM dbxdba;
GRANT ALL ON TABLE xcm_nuips_tels TO dbxdba;


--
-- TOC entry 2329 (class 0 OID 0)
-- Dependencies: 191
-- Name: xcm_nuips_tels_v1; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_nuips_tels_v1 FROM PUBLIC;
REVOKE ALL ON TABLE xcm_nuips_tels_v1 FROM dbxdba;
GRANT ALL ON TABLE xcm_nuips_tels_v1 TO dbxdba;


--
-- TOC entry 2331 (class 0 OID 0)
-- Dependencies: 192
-- Name: xcm_nuips_v1; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_nuips_v1 FROM PUBLIC;
REVOKE ALL ON TABLE xcm_nuips_v1 FROM dbxdba;
GRANT ALL ON TABLE xcm_nuips_v1 TO dbxdba;


--
-- TOC entry 2334 (class 0 OID 0)
-- Dependencies: 176
-- Name: xcm_permisos; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_permisos FROM PUBLIC;
REVOKE ALL ON TABLE xcm_permisos FROM dbxdba;
GRANT ALL ON TABLE xcm_permisos TO dbxdba;


--
-- TOC entry 2335 (class 0 OID 0)
-- Dependencies: 177
-- Name: xcm_usuarios; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_usuarios FROM PUBLIC;
REVOKE ALL ON TABLE xcm_usuarios FROM dbxdba;
GRANT ALL ON TABLE xcm_usuarios TO dbxdba;


--
-- TOC entry 2337 (class 0 OID 0)
-- Dependencies: 178
-- Name: xcm_usuarios_grupos_id_usuario_grupo_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_usuarios_grupos_id_usuario_grupo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_usuarios_grupos_id_usuario_grupo_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_usuarios_grupos_id_usuario_grupo_seq TO dbxdba;


--
-- TOC entry 2338 (class 0 OID 0)
-- Dependencies: 179
-- Name: xcm_usuarios_grupos; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_usuarios_grupos FROM PUBLIC;
REVOKE ALL ON TABLE xcm_usuarios_grupos FROM dbxdba;
GRANT ALL ON TABLE xcm_usuarios_grupos TO dbxdba;


--
-- TOC entry 2339 (class 0 OID 0)
-- Dependencies: 193
-- Name: xcm_usuarios_grupos_nuips_v1; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_usuarios_grupos_nuips_v1 FROM PUBLIC;
REVOKE ALL ON TABLE xcm_usuarios_grupos_nuips_v1 FROM dbxdba;
GRANT ALL ON TABLE xcm_usuarios_grupos_nuips_v1 TO dbxdba;


--
-- TOC entry 2340 (class 0 OID 0)
-- Dependencies: 194
-- Name: xcm_usuarios_grupos_v1; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_usuarios_grupos_v1 FROM PUBLIC;
REVOKE ALL ON TABLE xcm_usuarios_grupos_v1 FROM dbxdba;
GRANT ALL ON TABLE xcm_usuarios_grupos_v1 TO dbxdba;


--
-- TOC entry 2342 (class 0 OID 0)
-- Dependencies: 180
-- Name: xcm_usuarios_permisos_id_usuario_permiso_seq; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON SEQUENCE xcm_usuarios_permisos_id_usuario_permiso_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE xcm_usuarios_permisos_id_usuario_permiso_seq FROM dbxdba;
GRANT ALL ON SEQUENCE xcm_usuarios_permisos_id_usuario_permiso_seq TO dbxdba;


--
-- TOC entry 2343 (class 0 OID 0)
-- Dependencies: 181
-- Name: xcm_usuarios_permisos; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_usuarios_permisos FROM PUBLIC;
REVOKE ALL ON TABLE xcm_usuarios_permisos FROM dbxdba;
GRANT ALL ON TABLE xcm_usuarios_permisos TO dbxdba;


--
-- TOC entry 2345 (class 0 OID 0)
-- Dependencies: 207
-- Name: xcm_usuarios_v1; Type: ACL; Schema: public; Owner: dbxdba
--

REVOKE ALL ON TABLE xcm_usuarios_v1 FROM PUBLIC;
REVOKE ALL ON TABLE xcm_usuarios_v1 FROM dbxdba;
GRANT ALL ON TABLE xcm_usuarios_v1 TO dbxdba;


-- Completed on 2013-01-17 10:55:10 COT

--
-- PostgreSQL database dump complete
--

