CREATE TABLE xcm_nuips (
    id_nuip_serial bigint NOT NULL,
    id_nuip bigint,
    digito_verif smallint,
    id_tipo_nuip integer,
    nom_nuip text,
    ape_nuip text,
    nom_contacto text,
    notas text,
    fec_nacimiento timestamp without time zone,
    nom_empresa text,
    id_sexo integer,
    id_titulo_nuip integer,
    login_tx character varying(30),
    fec_tx timestamp without time zone NOT NULL
);

CREATE TABLE xcm_db_municipios (
    id_municipio bigint NOT NULL,
    id_depto bigint NOT NULL,
    is_activo boolean DEFAULT true NOT NULL,
    is_capital_pais boolean,
    is_capital_depto boolean,
    orden_db integer,
    cod_interno character varying(30),
    nom_municipio_es character varying(30) NOT NULL,
    abr_municipio_es character varying(8),
    abr_municipio_fr character varying(8),
    nom_municipio_fr character varying(30),
    abr_municipio_de character varying(8),
    nom_municipio_de character varying(30),
    abr_municipio_en character varying(8),
    nom_municipio_en character varying(30)
);

CREATE TABLE xcm_db_sexos (
    id_sexo integer NOT NULL,
    orden_db integer,
    nom_sexo_es character varying,
    abr_sexo_es character varying,
    nom_sexo_en character varying,
    abr_sexo_en character varying,
    nom_sexo_de character varying,
    abr_sexo_de character varying,
    nom_sexo_fr character varying,
    abr_sexo_fr character varying,
    is_activo boolean,
    cod_interno character varying
);

CREATE TABLE xcm_db_tipos_nuips (
    id_tipo_nuip integer NOT NULL,
    orden_db integer,
    nom_tipo_nuip_es character varying NOT NULL,
    abr_tipo_nuip_es character varying,
    nom_tipo_nuip_en character varying,
    abr_tipo_nuip_en character varying,
    nom_tipo_nuip_de character varying,
    abr_tipo_nuip_de character varying,
    nom_tipo_nuip_fr character varying,
    abr_tipo_nuip_fr character varying,
    is_activo boolean DEFAULT true NOT NULL,
    cod_interno character varying
);

CREATE TABLE xcm_db_titulos_nuips (
    id_titulo_nuip integer NOT NULL,
    orden_db integer,
    nom_titulo_nuip_es character varying,
    abr_titulo_nuip_es character varying,
    nom_titulo_nuip_en character varying,
    abr_titulo_nuip_en character varying,
    nom_titulo_nuip_de character varying,
    abr_titulo_nuipo_de character varying,
    nom_titulo_nuip_fr character varying,
    abr_titulo_nuip_fr character varying,
    is_activo boolean,
    cod_interno character varying
);

CREATE TABLE xcm_grupos (
    id_grupo bigint NOT NULL,
    id_nuip_serial bigint,
    nom_grupo character varying,
    desc_grupo character varying
);

CREATE TABLE xcm_nuips_grupos (
    id_nuip_grupo bigint NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_grupo bigint NOT NULL
);

CREATE TABLE xcm_campos_db (
    nom_esquema character varying NOT NULL,
    nom_tabla character varying NOT NULL,
    nom_columna character varying NOT NULL,
    nom_campo_es character varying,
    desc_campo_es character varying,
    nom_campo_en character varying,
    desc_campo_en character varying,
    nom_fx_valida_js character varying,
    is_nullable boolean DEFAULT false NOT NULL
);

CREATE TABLE xcm_db_departamentos (
    id_depto bigint NOT NULL,
    id_pais bigint NOT NULL,
    cod_interno character varying(30),
    is_activo boolean DEFAULT true NOT NULL,
    orden_db integer,
    nom_depto_es character varying(30) NOT NULL,
    abr_depto_es character varying(8),
    nom_depto_en character varying(30),
    abr_depto_en character varying(8),
    nom_depto_de character varying(30),
    abr_depto_de character varying(8),
    nom_depto_fr character varying(30),
    abr_depto_fr character varying(8)
);

COMMENT ON TABLE xcm_db_departamentos IS 'Departamentos o Estado en Caso de Otros Paises.';

CREATE SEQUENCE xcm_db_departamentos_id_depto_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_db_departamentos_id_depto_seq', 1, false);

CREATE SEQUENCE xcm_db_municipios_id_municipio_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_db_municipios_id_municipio_seq', 1, false);

CREATE TABLE xcm_db_paises (
    id_pais bigint NOT NULL,
    orden_db integer,
    nom_pais_es character varying NOT NULL,
    abr_pais_es character varying,
    nom_pais_en character varying,
    abr_pais_en character varying,
    nom_pais_de character varying,
    abr_pais_de character varying,
    nom_pais_fr character varying,
    abr_pais_fr character(1),
    is_activo boolean DEFAULT true NOT NULL,
    cod_interno character varying
);

CREATE SEQUENCE xcm_db_paises_id_pais_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_db_paises_id_pais_seq', 1, false);

CREATE SEQUENCE xcm_db_sexos_id_sexo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_db_sexos_id_sexo_seq', 1, false);

CREATE TABLE xcm_db_tipos_dir (
    id_tipo_dir integer NOT NULL,
    orden_db integer,
    nom_tipo_dir_es character varying,
    abr_tipo_dir_es character varying,
    nom_tipo_dir_en character varying,
    abr_tipo_dir_en character varying,
    nom_tipo_dir_de character varying,
    abr_tipo_dir_de character varying,
    nom_tipo_dir_fr character varying,
    abr_tipo_dir_fr character varying,
    is_activo boolean DEFAULT true NOT NULL,
    cod_interno character varying
);

CREATE SEQUENCE xcm_db_tipos_dir_id_tipo_dir_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_db_tipos_dir_id_tipo_dir_seq', 1, false);

CREATE SEQUENCE xcm_db_tipos_nuips_id_tipo_nuip_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_db_tipos_nuips_id_tipo_nuip_seq', 1, false);

CREATE TABLE xcm_db_tipos_tel (
    id_tipo_tel integer NOT NULL,
    orden_db integer,
    nom_tipo_tel_es character varying,
    abr_tipo_tel_es character varying,
    nom_tipo_tel_en character varying,
    abr_tipo_tel_en character varying,
    nom_tipo_tel_de character varying,
    abr_tipo_tel_de character varying,
    nom_tipo_tel_fr character varying,
    abr_tipo_tel_fr character varying,
    is_activo boolean,
    cod_interno character varying
);

CREATE SEQUENCE xcm_db_tipos_tel_id_tipo_tel_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_db_tipos_tel_id_tipo_tel_seq', 1, false);

CREATE SEQUENCE xcm_db_titulos_nuips_id_titulo_nuip_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_db_titulos_nuips_id_titulo_nuip_seq', 1, false);

CREATE TABLE xcm_documentos (
    id_doc bigint NOT NULL,
    nom_schema character varying(254) NOT NULL,
    nom_tabla character varying(254) NOT NULL,
    nom_campo character varying(254) NOT NULL,
    nom_doc character varying(40) NOT NULL,
    cons_doc bigint DEFAULT 1 NOT NULL,
    fec_ultimo_doc timestamp without time zone DEFAULT now() NOT NULL,
    id_grupo bigint NOT NULL
);

COMMENT ON TABLE xcm_documentos IS 'Administrador de Consecutivos y de Estados para todos los documentos del sistema';

CREATE SEQUENCE xcm_documentos_id_doc_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_documentos_id_doc_seq', 4, true);

CREATE SEQUENCE xcm_grupos_id_grupo_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_grupos_id_grupo_seq', 1, true);

CREATE TABLE xcm_grupos_permisos (
    id_grupo_permiso bigint NOT NULL,
    id_grupo bigint NOT NULL,
    id_permiso character varying NOT NULL,
    fec_tx timestamp without time zone DEFAULT '2008-09-24 08:40:40.471'::timestamp without time zone NOT NULL,
    login_admin character varying(30) DEFAULT "current_user"()
);

CREATE SEQUENCE xcm_grupos_permisos_id_grupo_permiso_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_grupos_permisos_id_grupo_permiso_seq', 1, false);

CREATE VIEW xcm_grupos_v1 AS
    SELECT g.id_grupo, g.nom_grupo, g.desc_grupo, g.id_nuip_serial, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip FROM (xcm_grupos g LEFT JOIN xcm_nuips n ON ((g.id_nuip_serial = n.id_nuip_serial)));

CREATE VIEW xcm_municipios_deptos_paises_v1 AS
    SELECT db_m.id_municipio, db_m.nom_municipio_es, db_d.nom_depto_es, db_p.nom_pais_es FROM xcm_db_municipios db_m, xcm_db_departamentos db_d, xcm_db_paises db_p WHERE ((db_m.id_depto = db_d.id_depto) AND (db_d.id_pais = db_p.id_pais));

CREATE TABLE xcm_niveles_usuario (
    id_nivel_usuario smallint DEFAULT (0)::smallint NOT NULL,
    nom_nivel_usuario character varying NOT NULL
);

CREATE TABLE xcm_nuips_dirs (
    id_nuip_dir bigint NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_tipo_dir integer,
    dir text NOT NULL,
    id_municipio bigint
);

CREATE SEQUENCE xcm_nuips_dirs_id_nuip_dir_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_nuips_dirs_id_nuip_dir_seq', 24, true);

CREATE VIEW xcm_nuips_dirs_v1 AS
    SELECT n.id_nuip_serial, n.id_nuip, n.nom_nuip, n.ape_nuip, nt.dir, nt.id_nuip_dir, nt.id_municipio, dtt.id_tipo_dir, dtt.nom_tipo_dir_es, dtt.abr_tipo_dir_es, mun.nom_municipio_es FROM (((xcm_nuips_dirs nt LEFT JOIN xcm_nuips n ON ((nt.id_nuip_serial = n.id_nuip_serial))) LEFT JOIN xcm_db_municipios mun ON ((nt.id_municipio = mun.id_municipio))) LEFT JOIN xcm_db_tipos_dir dtt ON ((nt.id_tipo_dir = dtt.id_tipo_dir)));

CREATE TABLE xcm_nuips_emails (
    id_nuip_email bigint NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_tipo_dir integer,
    email character varying NOT NULL
);

CREATE SEQUENCE xcm_nuips_emails_id_nuip_email_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_nuips_emails_id_nuip_email_seq', 23, true);

CREATE VIEW xcm_nuips_emails_v1 AS
    SELECT n.id_nuip_serial, n.id_nuip, n.nom_nuip, n.ape_nuip, nt.email, nt.id_nuip_email, dtt.id_tipo_dir, dtt.nom_tipo_dir_es, dtt.abr_tipo_dir_es FROM ((xcm_nuips_emails nt LEFT JOIN xcm_nuips n ON ((nt.id_nuip_serial = n.id_nuip_serial))) LEFT JOIN xcm_db_tipos_dir dtt ON ((nt.id_tipo_dir = dtt.id_tipo_dir)));


CREATE SEQUENCE xcm_nuips_grupos_id_nuip_grupo_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_nuips_grupos_id_nuip_grupo_seq', 53, true);

CREATE VIEW xcm_nuips_grupos_v1 AS
    SELECT COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, g.nom_grupo AS maq_nom_grupo, ng.id_grupo, n.id_nuip, n.digito_verif, tn.abr_tipo_nuip_es, n.nom_nuip, n.ape_nuip, (n.fec_nacimiento)::date AS fec_nacimiento, s.nom_sexo_es, ttn.nom_titulo_nuip_es, n.nom_empresa, n.nom_contacto, n.notas, n.id_nuip_serial, n.id_tipo_nuip, n.id_sexo, n.id_titulo_nuip FROM (((((xcm_nuips n LEFT JOIN xcm_db_tipos_nuips tn ON ((n.id_tipo_nuip = tn.id_tipo_nuip))) LEFT JOIN xcm_db_sexos s ON ((n.id_sexo = s.id_sexo))) LEFT JOIN xcm_db_titulos_nuips ttn ON ((n.id_titulo_nuip = ttn.id_titulo_nuip))) LEFT JOIN xcm_nuips_grupos ng ON ((n.id_nuip_serial = ng.id_nuip_serial))) LEFT JOIN xcm_grupos g ON ((ng.id_grupo = g.id_grupo)));

CREATE SEQUENCE xcm_nuips_id_nuip_serial_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_nuips_id_nuip_serial_seq', 56, true);

CREATE TABLE xcm_nuips_tels (
    id_nuip_tel bigint NOT NULL,
    id_nuip_serial bigint NOT NULL,
    id_tipo_tel integer NOT NULL,
    tel text NOT NULL
);

CREATE SEQUENCE xcm_nuips_tels_id_nuip_tel_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_nuips_tels_id_nuip_tel_seq', 30, true);

CREATE VIEW xcm_nuips_tels_v1 AS
    SELECT n.id_nuip_serial, n.id_nuip, n.nom_nuip, n.ape_nuip, nt.id_nuip_tel, nt.tel, dtt.id_tipo_tel, dtt.nom_tipo_tel_es, dtt.abr_tipo_tel_es FROM ((xcm_nuips_tels nt LEFT JOIN xcm_nuips n ON ((nt.id_nuip_serial = n.id_nuip_serial))) LEFT JOIN xcm_db_tipos_tel dtt ON ((nt.id_tipo_tel = dtt.id_tipo_tel)));

CREATE VIEW xcm_nuips_v1 AS
    SELECT COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, n.id_nuip, n.nom_nuip, n.ape_nuip, n.fec_nacimiento, s.nom_sexo_es, ttn.nom_titulo_nuip_es, n.nom_empresa, n.nom_contacto, n.notas, n.id_nuip_serial, n.id_tipo_nuip, n.id_sexo, n.id_titulo_nuip FROM (((xcm_nuips n LEFT JOIN xcm_db_tipos_nuips tn ON ((n.id_tipo_nuip = tn.id_tipo_nuip))) LEFT JOIN xcm_db_sexos s ON ((n.id_sexo = s.id_sexo))) LEFT JOIN xcm_db_titulos_nuips ttn ON ((n.id_titulo_nuip = ttn.id_titulo_nuip)));

CREATE TABLE xcm_permisos (
    id_permiso character varying NOT NULL,
    id_padre character varying,
    nom_permiso character varying NOT NULL,
    desc_permiso text,
    nro_nivel smallint,
    is_folder boolean DEFAULT false NOT NULL,
    onchange character varying
);

CREATE TABLE xcm_usuarios (
    login character varying(30) NOT NULL,
    passwd character varying NOT NULL,
    id_nivel_usuario integer DEFAULT 1 NOT NULL,
    id_nuip_serial bigint NOT NULL,
    fec_creacion timestamp without time zone DEFAULT '2009-01-01 00:00:00'::timestamp without time zone NOT NULL,
    is_activo boolean DEFAULT true NOT NULL,
    cant_sesiones_max smallint DEFAULT (1)::smallint NOT NULL,
    cant_sesiones smallint DEFAULT (0)::smallint NOT NULL
);

CREATE TABLE xcm_usuarios_grupos (
    id_usuario_grupo bigint NOT NULL,
    login character varying(30) NOT NULL,
    id_grupo bigint NOT NULL
);

CREATE SEQUENCE xcm_usuarios_grupos_id_usuario_grupo_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_usuarios_grupos_id_usuario_grupo_seq', 25, true);

CREATE VIEW xcm_usuarios_grupos_nuips_v1 AS
    SELECT DISTINCT u.login, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)) AS maq_id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip, n.id_nuip, n.id_nuip_serial, COALESCE(ug.id_grupo, ng.id_grupo) AS id_grupo, u.id_nivel_usuario FROM (xcm_usuarios u LEFT JOIN xcm_usuarios_grupos ug ON (((ug.login)::text = (u.login)::text))), xcm_nuips n, xcm_nuips_grupos ng WHERE ((u.id_nuip_serial = n.id_nuip_serial) AND (n.id_nuip_serial = ng.id_nuip_serial)) ORDER BY u.login, COALESCE(((to_char(n.id_nuip, '999,999,999,999,999'::text) || '-'::text) || (n.digito_verif)::text), to_char(n.id_nuip, '999,999,999,999,999'::text)), COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip), n.id_nuip, n.id_nuip_serial, COALESCE(ug.id_grupo, ng.id_grupo), u.id_nivel_usuario;

CREATE VIEW xcm_usuarios_grupos_v1 AS
    SELECT ug.id_usuario_grupo, ug.login, g.nom_grupo, g.id_grupo FROM xcm_usuarios_grupos ug, xcm_grupos g WHERE (ug.id_grupo = g.id_grupo);

CREATE TABLE xcm_usuarios_permisos (
    id_usuario_permiso bigint NOT NULL,
    login character varying(30) NOT NULL,
    id_permiso character varying NOT NULL,
    fec_tx timestamp without time zone DEFAULT (now())::timestamp without time zone NOT NULL,
    login_admin character varying(30) NOT NULL
);

CREATE SEQUENCE xcm_usuarios_permisos_id_usuario_permiso_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

SELECT pg_catalog.setval('xcm_usuarios_permisos_id_usuario_permiso_seq', 243, true);

CREATE VIEW xcm_usuarios_v1 AS
    SELECT u.login, u.passwd, u.id_nivel_usuario, u.id_nuip_serial, u.fec_creacion, u.is_activo, u.cant_sesiones_max, u.cant_sesiones, n.id_nuip, COALESCE(((n.nom_nuip || ' '::text) || n.ape_nuip), n.nom_nuip, n.ape_nuip) AS maq_nom_nuip FROM (xcm_usuarios u LEFT JOIN xcm_nuips n ON ((u.id_nuip_serial = n.id_nuip_serial)));

ALTER TABLE xcm_db_departamentos ALTER COLUMN id_depto SET DEFAULT nextval('xcm_db_departamentos_id_depto_seq'::regclass);

ALTER TABLE xcm_db_municipios ALTER COLUMN id_municipio SET DEFAULT nextval('xcm_db_municipios_id_municipio_seq'::regclass);

ALTER TABLE xcm_db_paises ALTER COLUMN id_pais SET DEFAULT nextval('xcm_db_paises_id_pais_seq'::regclass);

ALTER TABLE xcm_db_sexos ALTER COLUMN id_sexo SET DEFAULT nextval('xcm_db_sexos_id_sexo_seq'::regclass);

ALTER TABLE xcm_db_tipos_dir ALTER COLUMN id_tipo_dir SET DEFAULT nextval('xcm_db_tipos_dir_id_tipo_dir_seq'::regclass);

ALTER TABLE xcm_db_tipos_nuips ALTER COLUMN id_tipo_nuip SET DEFAULT nextval('xcm_db_tipos_nuips_id_tipo_nuip_seq'::regclass);

ALTER TABLE xcm_db_tipos_tel ALTER COLUMN id_tipo_tel SET DEFAULT nextval('xcm_db_tipos_tel_id_tipo_tel_seq'::regclass);

ALTER TABLE xcm_db_titulos_nuips ALTER COLUMN id_titulo_nuip SET DEFAULT nextval('xcm_db_titulos_nuips_id_titulo_nuip_seq'::regclass);

ALTER TABLE xcm_documentos ALTER COLUMN id_doc SET DEFAULT nextval('xcm_documentos_id_doc_seq'::regclass);

ALTER TABLE xcm_grupos ALTER COLUMN id_grupo SET DEFAULT nextval('xcm_grupos_id_grupo_seq'::regclass);

ALTER TABLE xcm_grupos_permisos ALTER COLUMN id_grupo_permiso SET DEFAULT nextval('xcm_grupos_permisos_id_grupo_permiso_seq'::regclass);

ALTER TABLE xcm_nuips ALTER COLUMN id_nuip_serial SET DEFAULT nextval('xcm_nuips_id_nuip_serial_seq'::regclass);

ALTER TABLE xcm_nuips_dirs ALTER COLUMN id_nuip_dir SET DEFAULT nextval('xcm_nuips_dirs_id_nuip_dir_seq'::regclass);

ALTER TABLE xcm_nuips_emails ALTER COLUMN id_nuip_email SET DEFAULT nextval('xcm_nuips_emails_id_nuip_email_seq'::regclass);

ALTER TABLE xcm_nuips_grupos ALTER COLUMN id_nuip_grupo SET DEFAULT nextval('xcm_nuips_grupos_id_nuip_grupo_seq'::regclass);

ALTER TABLE xcm_nuips_tels ALTER COLUMN id_nuip_tel SET DEFAULT nextval('xcm_nuips_tels_id_nuip_tel_seq'::regclass);

ALTER TABLE xcm_usuarios_grupos ALTER COLUMN id_usuario_grupo SET DEFAULT nextval('xcm_usuarios_grupos_id_usuario_grupo_seq'::regclass);

ALTER TABLE xcm_usuarios_permisos ALTER COLUMN id_usuario_permiso SET DEFAULT nextval('xcm_usuarios_permisos_id_usuario_permiso_seq'::regclass);

INSERT INTO xcm_db_paises VALUES (1, 1, 'Afghanistan', 'AF', 'Afghanistan', 'AF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (2, 2, 'Albania', 'AL', 'Albania', 'AL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (3, 3, 'Algeria', 'DZ', 'Algeria', 'DZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (4, 4, 'American Samoa', 'AS', 'American Samoa', 'AS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (5, 5, 'Andorra', 'AD', 'Andorra', 'AD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (6, 6, 'Angola', 'AO', 'Angola', 'AO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (7, 7, 'Anguilla', 'AI', 'Anguilla', 'AI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (8, 8, 'Antigua & Barbuda', 'AG', 'Antigua & Barbuda', 'AG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (9, 9, 'Argentina', 'AR', 'Argentina', 'AR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (10, 10, 'Armenia', 'AM', 'Armenia', 'AM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (11, 11, 'Aruba', 'AW', 'Aruba', 'AW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (12, 12, 'Australia', 'AU', 'Australia', 'AU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (13, 13, 'Austria', 'AT', 'Austria', 'AT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (14, 14, 'Azerbaijan', 'AZ', 'Azerbaijan', 'AZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (15, 15, 'Azores', 'AP', 'Azores', 'AP', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (16, 16, 'Bahamas', 'BS', 'Bahamas', 'BS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (17, 17, 'Bahrain', 'BH', 'Bahrain', 'BH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (18, 18, 'Bangladesh', 'BD', 'Bangladesh', 'BD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (19, 19, 'Barbados', 'BB', 'Barbados', 'BB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (20, 20, 'Belarus', 'BY', 'Belarus', 'BY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (21, 21, 'Belgium', 'BE', 'Belgium', 'BE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (22, 22, 'Belize', 'BZ', 'Belize', 'BZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (23, 23, 'Benin', 'BJ', 'Benin', 'BJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (24, 24, 'Bermuda', 'BM', 'Bermuda', 'BM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (25, 25, 'Bhutan', 'BT', 'Bhutan', 'BT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (26, 26, 'Bolivia', 'BO', 'Bolivia', 'BO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (27, 27, 'Bonaire', 'BL', 'Bonaire', 'BL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (28, 28, 'Bosnia & Herzegovina', 'BA', 'Bosnia & Herzegovina', 'BA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (29, 29, 'Botswana', 'BW', 'Botswana', 'BW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (30, 30, 'Brazil', 'BR', 'Brazil', 'BR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (31, 31, 'British Indian Ocean Ter', 'IO', 'British Indian Ocean Ter', 'IO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (32, 32, 'Brunei', 'BN', 'Brunei', 'BN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (33, 33, 'Bulgaria', 'BG', 'Bulgaria', 'BG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (34, 34, 'Burkina Faso', 'BF', 'Burkina Faso', 'BF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (35, 35, 'Burundi', 'BI', 'Burundi', 'BI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (36, 36, 'Cambodia', 'KH', 'Cambodia', 'KH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (37, 37, 'Cameroon', 'CM', 'Cameroon', 'CM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (38, 38, 'Canada', 'CA', 'Canada', 'CA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (39, 39, 'Canary Islands', 'IC', 'Canary Islands', 'IC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (40, 40, 'Cape Verde', 'CV', 'Cape Verde', 'CV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (41, 41, 'Cayman Islands', 'KY', 'Cayman Islands', 'KY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (42, 42, 'Central African Republic', 'CF', 'Central African Republic', 'CF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (43, 43, 'Chad', 'TD', 'Chad', 'TD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (44, 44, 'Channel Islands', 'JI', 'Channel Islands', 'JI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (45, 45, 'Chile', 'CL', 'Chile', 'CL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (46, 46, 'China', 'CN', 'China', 'CN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (47, 47, 'Christmas Island', 'CX', 'Christmas Island', 'CX', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (48, 48, 'Cocos Island', 'CC', 'Cocos Island', 'CC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (50, 50, 'Comoros', 'KM', 'Comoros', 'KM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (51, 51, 'Congo', 'CG', 'Congo', 'CG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (52, 52, 'Congo Democratic Republic', 'CD', 'Congo Democratic Republic', 'CD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (53, 53, 'Cook Islands', 'CK', 'Cook Islands', 'CK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (54, 54, 'Costa Rica', 'CR', 'Costa Rica', 'CR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (55, 55, 'Cote D Ivoire', 'CI', 'Cote D Ivoire', 'CI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (56, 56, 'Croatia', 'HR', 'Croatia', 'HR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (57, 57, 'Cuba', 'CU', 'Cuba', 'CU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (58, 58, 'Curacao', 'CB', 'Curacao', 'CB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (59, 59, 'Cyprus', 'CY', 'Cyprus', 'CY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (60, 60, 'Czech Republic', 'CZ', 'Czech Republic', 'CZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (61, 61, 'Denmark', 'DK', 'Denmark', 'DK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (62, 62, 'Djibouti', 'DJ', 'Djibouti', 'DJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (63, 63, 'Dominica', 'DM', 'Dominica', 'DM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (64, 64, 'Dominican Republic', 'DO', 'Dominican Republic', 'DO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (65, 65, 'East Timor', 'TL', 'East Timor', 'TL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (66, 66, 'Ecuador', 'EC', 'Ecuador', 'EC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (67, 67, 'Egypt', 'EG', 'Egypt', 'EG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (68, 68, 'El Salvador', 'SV', 'El Salvador', 'SV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (69, 69, 'Equatorial Guinea', 'GQ', 'Equatorial Guinea', 'GQ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (70, 70, 'Eritrea', 'ER', 'Eritrea', 'ER', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (71, 71, 'Estonia', 'EE', 'Estonia', 'EE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (72, 72, 'Ethiopia', 'ET', 'Ethiopia', 'ET', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (73, 73, 'Falkland Islands', 'FK', 'Falkland Islands', 'FK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (74, 74, 'Faroe Islands', 'FO', 'Faroe Islands', 'FO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (75, 75, 'Fiji', 'FJ', 'Fiji', 'FJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (76, 76, 'Finland', 'FI', 'Finland', 'FI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (77, 77, 'France', 'FR', 'France', 'FR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (78, 78, 'French Guiana', 'GF', 'French Guiana', 'GF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (79, 79, 'French Polynesia', 'PF', 'French Polynesia', 'PF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (80, 80, 'French Southern Ter', 'TF', 'French Southern Ter', 'TF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (81, 81, 'Gabon', 'GA', 'Gabon', 'GA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (82, 82, 'Gambia', 'GM', 'Gambia', 'GM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (83, 83, 'Georgia', 'GE', 'Georgia', 'GE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (84, 84, 'Germany', 'DE', 'Germany', 'DE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (85, 85, 'Ghana', 'GH', 'Ghana', 'GH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (86, 86, 'Gibraltar', 'GI', 'Gibraltar', 'GI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (87, 87, 'Great Britain', 'GB', 'Great Britain', 'GB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (88, 88, 'Greece', 'GR', 'Greece', 'GR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (89, 89, 'Greenland', 'GL', 'Greenland', 'GL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (90, 90, 'Grenada', 'GD', 'Grenada', 'GD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (91, 91, 'Guadeloupe', 'GP', 'Guadeloupe', 'GP', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (92, 92, 'Guam', 'GU', 'Guam', 'GU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (93, 93, 'Guatemala', 'GT', 'Guatemala', 'GT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (94, 94, 'Guinea', 'GN', 'Guinea', 'GN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (95, 95, 'Guinea Bissau', 'GW', 'Guinea Bissau', 'GW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (96, 96, 'Guyana', 'GY', 'Guyana', 'GY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (97, 97, 'Haiti', 'HT', 'Haiti', 'HT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (98, 98, 'Hawaii', 'HW', 'Hawaii', 'HW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (99, 99, 'Honduras', 'HN', 'Honduras', 'HN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (100, 100, 'Hong Kong', 'HK', 'Hong Kong', 'HK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (101, 101, 'Hungary', 'HU', 'Hungary', 'HU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (102, 102, 'Iceland', 'IS', 'Iceland', 'IS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (103, 103, 'India', 'IN', 'India', 'IN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (104, 104, 'Indonesia', 'ID', 'Indonesia', 'ID', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (105, 105, 'Iran', 'IR', 'Iran', 'IR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (106, 106, 'Iraq', 'IQ', 'Iraq', 'IQ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (107, 107, 'Ireland', 'IE', 'Ireland', 'IE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (108, 108, 'Isle of Man', 'IM', 'Isle of Man', 'IM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (109, 109, 'Israel', 'IL', 'Israel', 'IL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (110, 110, 'Italy', 'IT', 'Italy', 'IT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (111, 111, 'Jamaica', 'JM', 'Jamaica', 'JM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (112, 112, 'Japan', 'JP', 'Japan', 'JP', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (113, 113, 'Jordan', 'JO', 'Jordan', 'JO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (114, 114, 'Kazakhstan', 'KZ', 'Kazakhstan', 'KZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (115, 115, 'Kenya', 'KE', 'Kenya', 'KE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (116, 116, 'Kiribati', 'KI', 'Kiribati', 'KI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (117, 117, 'Korea North', 'NK', 'Korea North', 'NK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (118, 118, 'Korea South', 'KS', 'Korea South', 'KS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (119, 119, 'Kuwait', 'KW', 'Kuwait', 'KW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (120, 120, 'Kyrgyzstan', 'KG', 'Kyrgyzstan', 'KG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (121, 121, 'Laos', 'LA', 'Laos', 'LA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (122, 122, 'Latvia', 'LV', 'Latvia', 'LV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (123, 123, 'Lebanon', 'LB', 'Lebanon', 'LB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (124, 124, 'Lesotho', 'LS', 'Lesotho', 'LS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (125, 125, 'Liberia', 'LR', 'Liberia', 'LR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (126, 126, 'Libya', 'LY', 'Libya', 'LY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (127, 127, 'Liechtenstein', 'LI', 'Liechtenstein', 'LI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (128, 128, 'Lithuania', 'LT', 'Lithuania', 'LT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (129, 129, 'Luxembourg', 'LU', 'Luxembourg', 'LU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (130, 130, 'Macau', 'MO', 'Macau', 'MO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (131, 131, 'Macedonia', 'MK', 'Macedonia', 'MK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (132, 132, 'Madagascar', 'MG', 'Madagascar', 'MG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (133, 133, 'Malawi', 'MW', 'Malawi', 'MW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (134, 134, 'Malaysia', 'MY', 'Malaysia', 'MY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (135, 135, 'Maldives', 'MV', 'Maldives', 'MV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (136, 136, 'Mali', 'ML', 'Mali', 'ML', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (137, 137, 'Malta', 'MT', 'Malta', 'MT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (138, 138, 'Marshall Islands', 'MH', 'Marshall Islands', 'MH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (139, 139, 'Martinique', 'MQ', 'Martinique', 'MQ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (140, 140, 'Mauritania', 'MR', 'Mauritania', 'MR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (141, 141, 'Mauritius', 'MU', 'Mauritius', 'MU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (142, 142, 'Mayotte', 'YT', 'Mayotte', 'YT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (143, 143, 'Mexico', 'MX', 'Mexico', 'MX', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (144, 144, 'Micronesia', 'FM', 'Micronesia', 'FM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (145, 145, 'Midway Islands', 'MI', 'Midway Islands', 'MI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (146, 146, 'Moldova', 'MD', 'Moldova', 'MD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (147, 147, 'Monaco', 'MC', 'Monaco', 'MC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (148, 148, 'Mongolia', 'MN', 'Mongolia', 'MN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (149, 149, 'Montserrat', 'MS', 'Montserrat', 'MS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (150, 150, 'Morocco', 'MA', 'Morocco', 'MA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (151, 151, 'Mozambique', 'MZ', 'Mozambique', 'MZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (152, 152, 'Myanmar', 'MM', 'Myanmar', 'MM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (153, 153, 'Nambia', 'NA', 'Nambia', 'NA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (154, 154, 'Nauru', 'NR', 'Nauru', 'NR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (155, 155, 'Nepal', 'NP', 'Nepal', 'NP', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (156, 156, 'Netherland Antilles', 'AN', 'Netherland Antilles', 'AN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (157, 157, 'Netherlands', 'NL', 'Netherlands', 'NL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (158, 158, 'New Caledonia', 'NC', 'New Caledonia', 'NC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (159, 159, 'New Zealand', 'NZ', 'New Zealand', 'NZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (160, 160, 'Nicaragua', 'NI', 'Nicaragua', 'NI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (161, 161, 'Niger', 'NE', 'Niger', 'NE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (162, 162, 'Nigeria', 'NG', 'Nigeria', 'NG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (163, 163, 'Niue', 'NU', 'Niue', 'NU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (164, 164, 'Norfolk Island', 'NF', 'Norfolk Island', 'NF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (165, 165, 'Norway', 'NO', 'Norway', 'NO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (166, 166, 'Oman', 'OM', 'Oman', 'OM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (167, 167, 'Pakistan', 'PK', 'Pakistan', 'PK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (168, 168, 'Palau Island', 'PW', 'Palau Island', 'PW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (169, 169, 'Palestine', 'PS', 'Palestine', 'PS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (170, 170, 'Panama', 'PA', 'Panama', 'PA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (171, 171, 'Papua New Guinea', 'PG', 'Papua New Guinea', 'PG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (172, 172, 'Paraguay', 'PY', 'Paraguay', 'PY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (173, 173, 'Peru', 'PE', 'Peru', 'PE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (174, 174, 'Philippines', 'PH', 'Philippines', 'PH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (175, 175, 'Pitcairn Island', 'PN', 'Pitcairn Island', 'PN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (176, 176, 'Poland', 'PL', 'Poland', 'PL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (177, 177, 'Portugal', 'PT', 'Portugal', 'PT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (178, 178, 'Puerto Rico', 'PR', 'Puerto Rico', 'PR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (179, 179, 'Qatar', 'QA', 'Qatar', 'QA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (180, 180, 'Reunion', 'RE', 'Reunion', 'RE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (181, 181, 'Romania', 'RO', 'Romania', 'RO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (182, 182, 'Russia', 'RU', 'Russia', 'RU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (183, 183, 'Rwanda', 'RW', 'Rwanda', 'RW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (184, 184, 'Samoa', 'WS', 'Samoa', 'WS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (185, 185, 'San Marino', 'SM', 'San Marino', 'SM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (186, 186, 'Sao Tome & Principe', 'ST', 'Sao Tome & Principe', 'ST', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (187, 187, 'Saudi Arabia', 'SA', 'Saudi Arabia', 'SA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (188, 188, 'Senegal', 'SN', 'Senegal', 'SN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (189, 189, 'Serbia & Montenegro', 'CS', 'Serbia & Montenegro', 'CS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (190, 190, 'Seychelles', 'SC', 'Seychelles', 'SC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (191, 191, 'Sierra Leone', 'SL', 'Sierra Leone', 'SL', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (192, 192, 'Singapore', 'SG', 'Singapore', 'SG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (193, 193, 'Slovakia', 'SK', 'Slovakia', 'SK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (194, 194, 'Slovenia', 'SI', 'Slovenia', 'SI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (195, 195, 'Solomon Islands', 'SB', 'Solomon Islands', 'SB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (196, 196, 'Somalia', 'SO', 'Somalia', 'SO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (197, 197, 'South Africa', 'ZA', 'South Africa', 'ZA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (198, 198, 'Spain', 'ES', 'Spain', 'ES', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (199, 199, 'Sri Lanka', 'LK', 'Sri Lanka', 'LK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (200, 200, 'St Helena', 'SH', 'St Helena', 'SH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (201, 201, 'St Kitts-Nevis', 'KN', 'St Kitts-Nevis', 'KN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (202, 202, 'St Lucia', 'LC', 'St Lucia', 'LC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (203, 203, 'St Maarten', 'MB', 'St Maarten', 'MB', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (204, 204, 'St Pierre & Miquelon', 'PM', 'St Pierre & Miquelon', 'PM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (205, 205, 'St Vincent & Grenadines', 'VC', 'St Vincent & Grenadines', 'VC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (206, 206, 'Sudan', 'SD', 'Sudan', 'SD', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (207, 207, 'Suriname', 'SR', 'Suriname', 'SR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (208, 208, 'Svalbard', 'SJ', 'Svalbard', 'SJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (209, 209, 'Swaziland', 'SZ', 'Swaziland', 'SZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (210, 210, 'Sweden', 'SE', 'Sweden', 'SE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (211, 211, 'Switzerland', 'CH', 'Switzerland', 'CH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (212, 212, 'Syria', 'SY', 'Syria', 'SY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (213, 213, 'Tahiti', 'TA', 'Tahiti', 'TA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (214, 214, 'Taiwan', 'TW', 'Taiwan', 'TW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (215, 215, 'Tajikistan', 'TJ', 'Tajikistan', 'TJ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (216, 216, 'Tanzania', 'TZ', 'Tanzania', 'TZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (217, 217, 'Thailand', 'TH', 'Thailand', 'TH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (218, 218, 'Togo', 'TG', 'Togo', 'TG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (219, 219, 'Tokelau', 'TK', 'Tokelau', 'TK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (220, 220, 'Tonga', 'TO', 'Tonga', 'TO', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (221, 221, 'Trinidad & Tobago', 'TT', 'Trinidad & Tobago', 'TT', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (222, 222, 'Tunisia', 'TN', 'Tunisia', 'TN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (223, 223, 'Turkey', 'TR', 'Turkey', 'TR', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (224, 224, 'Turkmenistan', 'TM', 'Turkmenistan', 'TM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (225, 225, 'Turks & Caicos Is', 'TC', 'Turks & Caicos Is', 'TC', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (226, 226, 'Tuvalu', 'TV', 'Tuvalu', 'TV', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (227, 227, 'Uganda', 'UG', 'Uganda', 'UG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (228, 228, 'Ukraine', 'UA', 'Ukraine', 'UA', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (229, 229, 'United Arab Emirates', 'AE', 'United Arab Emirates', 'AE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (230, 230, 'United States of America', 'US', 'United States of America', 'US', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (231, 231, 'Uruguay', 'UY', 'Uruguay', 'UY', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (232, 232, 'Uzbekistan', 'UZ', 'Uzbekistan', 'UZ', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (233, 233, 'Vanuatu', 'VU', 'Vanuatu', 'VU', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (234, 234, 'Vatican City State', 'VS', 'Vatican City State', 'VS', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (235, 235, 'Venezuela', 'VE', 'Venezuela', 'VE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (236, 236, 'Vietnam', 'VN', 'Vietnam', 'VN', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (237, 237, 'Virgin Islands (Brit)', 'VG', 'Virgin Islands (Brit)', 'VG', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (238, 238, 'Virgin Islands (USA)', 'VI', 'Virgin Islands (USA)', 'VI', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (239, 239, 'Wake Island', 'WK', 'Wake Island', 'WK', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (240, 240, 'Wallis & Futana Is', 'WF', 'Wallis & Futana Is', 'WF', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (241, 241, 'Western Sahara', 'EH', 'Western Sahara', 'EH', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (242, 242, 'Yemen', 'YE', 'Yemen', 'YE', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (243, 243, 'Zambia', 'ZM', 'Zambia', 'ZM', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (244, 244, 'Zimbabwe', 'ZW', 'Zimbabwe', 'ZW', NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_paises VALUES (49, 49, 'Colombia', 'CO', 'Columbia', 'CO', NULL, NULL, NULL, NULL, true, NULL);


INSERT INTO xcm_db_departamentos VALUES (1, 49, NULL, true, NULL, 'Antioquia', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (2, 49, NULL, true, NULL, 'Atlantico', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (3, 49, NULL, true, NULL, 'Bogotá, D.C.', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (4, 49, NULL, true, NULL, 'Bolivar', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (5, 49, NULL, true, NULL, 'Boyaca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (6, 49, NULL, true, NULL, 'Caldas', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (7, 49, NULL, true, NULL, 'Caqueta', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (8, 49, NULL, true, NULL, 'Cauca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (9, 49, NULL, true, NULL, 'Cesar', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (10, 49, NULL, true, NULL, 'Cordoba', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (11, 49, NULL, true, NULL, 'Cundinamarca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (12, 49, NULL, true, NULL, 'Choco', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (13, 49, NULL, true, NULL, 'Huila', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (14, 49, NULL, true, NULL, 'La Guajira', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (15, 49, NULL, true, NULL, 'Magdalena', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (16, 49, NULL, true, NULL, 'Meta', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (17, 49, NULL, true, NULL, 'Nariño', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (18, 49, NULL, true, NULL, 'Norte de Santander', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (19, 49, NULL, true, NULL, 'Quindio', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (20, 49, NULL, true, NULL, 'Risaralda', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (21, 49, NULL, true, NULL, 'Santander', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (22, 49, NULL, true, NULL, 'Sucre', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (23, 49, NULL, true, NULL, 'Tolima', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (24, 49, NULL, true, NULL, 'Valle del Cauca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (25, 49, NULL, true, NULL, 'Arauca', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (26, 49, NULL, true, NULL, 'Casanare', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (27, 49, NULL, true, NULL, 'Putumayo', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (28, 49, NULL, true, NULL, 'Archipielago de San Andres', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (29, 49, NULL, true, NULL, 'Amazonas', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (30, 49, NULL, true, NULL, 'Guainía', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (31, 49, NULL, true, NULL, 'Guaviare', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (32, 49, NULL, true, NULL, 'Vaupés', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_departamentos VALUES (33, 49, NULL, true, NULL, 'Vichada', NULL, NULL, NULL, NULL, NULL, NULL, NULL);


--
-- Data for Name: xcm_db_municipios; Type: TABLE DATA; Schema: public; Owner: dbxdba
--

INSERT INTO xcm_db_municipios VALUES (1, 1, true, NULL, NULL, NULL, NULL, 'ABEJORRAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (2, 1, true, NULL, NULL, NULL, NULL, 'ABRIAQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (3, 1, true, NULL, NULL, NULL, NULL, 'ALEJANDRIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (4, 1, true, NULL, NULL, NULL, NULL, 'AMAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (5, 1, true, NULL, NULL, NULL, NULL, 'AMALFI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (6, 1, true, NULL, NULL, NULL, NULL, 'ANDES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (7, 1, true, NULL, NULL, NULL, NULL, 'ANGELOPOLIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (8, 1, true, NULL, NULL, NULL, NULL, 'ANGOSTURA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (9, 1, true, NULL, NULL, NULL, NULL, 'ANORI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (10, 1, true, NULL, NULL, NULL, NULL, 'SANTAFE DE ANTIOQUIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (11, 1, true, NULL, NULL, NULL, NULL, 'ANZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (12, 1, true, NULL, NULL, NULL, NULL, 'APARTADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (13, 1, true, NULL, NULL, NULL, NULL, 'ARBOLETES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (14, 1, true, NULL, NULL, NULL, NULL, 'ARGELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (15, 1, true, NULL, NULL, NULL, NULL, 'ARMENIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (16, 1, true, NULL, NULL, NULL, NULL, 'BARBOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (17, 1, true, NULL, NULL, NULL, NULL, 'BELMIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (18, 1, true, NULL, NULL, NULL, NULL, 'BELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (19, 1, true, NULL, NULL, NULL, NULL, 'BETANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (20, 1, true, NULL, NULL, NULL, NULL, 'BETULIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (21, 1, true, NULL, NULL, NULL, NULL, 'CIUDAD BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (22, 1, true, NULL, NULL, NULL, NULL, 'BRICEÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (23, 1, true, NULL, NULL, NULL, NULL, 'BURITICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (24, 1, true, NULL, NULL, NULL, NULL, 'CACERES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (25, 1, true, NULL, NULL, NULL, NULL, 'CAICEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (26, 1, true, NULL, NULL, NULL, NULL, 'CALDAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (27, 1, true, NULL, NULL, NULL, NULL, 'CAMPAMENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (28, 1, true, NULL, NULL, NULL, NULL, 'CAÑASGORDAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (29, 1, true, NULL, NULL, NULL, NULL, 'CARACOLI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (30, 1, true, NULL, NULL, NULL, NULL, 'CARAMANTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (31, 1, true, NULL, NULL, NULL, NULL, 'CAREPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (32, 1, true, NULL, NULL, NULL, NULL, 'EL CARMEN DE VIBORAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (33, 1, true, NULL, NULL, NULL, NULL, 'CAROLINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (34, 1, true, NULL, NULL, NULL, NULL, 'CAUCASIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (35, 1, true, NULL, NULL, NULL, NULL, 'CHIGORODO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (36, 1, true, NULL, NULL, NULL, NULL, 'CISNEROS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (37, 1, true, NULL, NULL, NULL, NULL, 'COCORNA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (38, 1, true, NULL, NULL, NULL, NULL, 'CONCEPCION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (39, 1, true, NULL, NULL, NULL, NULL, 'CONCORDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (40, 1, true, NULL, NULL, NULL, NULL, 'COPACABANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (41, 1, true, NULL, NULL, NULL, NULL, 'DABEIBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (42, 1, true, NULL, NULL, NULL, NULL, 'DON MATIAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (43, 1, true, NULL, NULL, NULL, NULL, 'EBEJICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (44, 1, true, NULL, NULL, NULL, NULL, 'EL BAGRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (45, 1, true, NULL, NULL, NULL, NULL, 'ENTRERRIOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (46, 1, true, NULL, NULL, NULL, NULL, 'ENVIGADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (47, 1, true, NULL, NULL, NULL, NULL, 'FREDONIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (48, 1, true, NULL, NULL, NULL, NULL, 'FRONTINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (49, 1, true, NULL, NULL, NULL, NULL, 'GIRALDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (50, 1, true, NULL, NULL, NULL, NULL, 'GIRARDOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (51, 1, true, NULL, NULL, NULL, NULL, 'GOMEZ PLATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (52, 1, true, NULL, NULL, NULL, NULL, 'GRANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (53, 1, true, NULL, NULL, NULL, NULL, 'GUADALUPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (54, 1, true, NULL, NULL, NULL, NULL, 'GUARNE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (55, 1, true, NULL, NULL, NULL, NULL, 'GUATAPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (56, 1, true, NULL, NULL, NULL, NULL, 'HELICONIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (57, 1, true, NULL, NULL, NULL, NULL, 'HISPANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (58, 1, true, NULL, NULL, NULL, NULL, 'ITAGUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (59, 1, true, NULL, NULL, NULL, NULL, 'ITUANGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (60, 1, true, NULL, NULL, NULL, NULL, 'JARDIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (61, 1, true, NULL, NULL, NULL, NULL, 'JERICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (62, 1, true, NULL, NULL, NULL, NULL, 'LA CEJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (63, 1, true, NULL, NULL, NULL, NULL, 'LA ESTRELLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (64, 1, true, NULL, NULL, NULL, NULL, 'LA PINTADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (65, 1, true, NULL, NULL, NULL, NULL, 'LA UNION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (66, 1, true, NULL, NULL, NULL, NULL, 'LIBORINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (67, 1, true, NULL, NULL, NULL, NULL, 'MACEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (68, 1, true, NULL, NULL, NULL, NULL, 'MARINILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (69, 1, true, NULL, NULL, NULL, NULL, 'MONTEBELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (70, 1, true, NULL, NULL, NULL, NULL, 'MURINDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (71, 1, true, NULL, NULL, NULL, NULL, 'MUTATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (72, 1, true, NULL, NULL, NULL, NULL, 'NARIÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (73, 1, true, NULL, NULL, NULL, NULL, 'NECOCLI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (74, 1, true, NULL, NULL, NULL, NULL, 'NECHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (75, 1, true, NULL, NULL, NULL, NULL, 'OLAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (76, 1, true, NULL, NULL, NULL, NULL, 'PEÑOL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (77, 1, true, NULL, NULL, NULL, NULL, 'PEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (78, 1, true, NULL, NULL, NULL, NULL, 'PUEBLORRICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (79, 1, true, NULL, NULL, NULL, NULL, 'PUERTO BERRIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (80, 1, true, NULL, NULL, NULL, NULL, 'PUERTO NARE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (81, 1, true, NULL, NULL, NULL, NULL, 'PUERTO TRIUNFO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (82, 1, true, NULL, NULL, NULL, NULL, 'REMEDIOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (83, 1, true, NULL, NULL, NULL, NULL, 'RETIRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (84, 1, true, NULL, NULL, NULL, NULL, 'RIONEGRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (85, 1, true, NULL, NULL, NULL, NULL, 'SABANALARGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (86, 1, true, NULL, NULL, NULL, NULL, 'SABANETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (87, 1, true, NULL, NULL, NULL, NULL, 'SALGAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (88, 1, true, NULL, NULL, NULL, NULL, 'SAN ANDRES DE CUERQUIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (89, 1, true, NULL, NULL, NULL, NULL, 'SAN CARLOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (90, 1, true, NULL, NULL, NULL, NULL, 'SAN FRANCISCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (91, 1, true, NULL, NULL, NULL, NULL, 'SAN JERONIMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (92, 1, true, NULL, NULL, NULL, NULL, 'SAN JOSE DE LA MONTAÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (93, 1, true, NULL, NULL, NULL, NULL, 'SAN JUAN DE URABA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (94, 1, true, NULL, NULL, NULL, NULL, 'SAN LUIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (95, 1, true, NULL, NULL, NULL, NULL, 'SAN PEDRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (96, 1, true, NULL, NULL, NULL, NULL, 'SAN PEDRO DE URABA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (97, 1, true, NULL, NULL, NULL, NULL, 'SAN RAFAEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (98, 1, true, NULL, NULL, NULL, NULL, 'SAN ROQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (99, 1, true, NULL, NULL, NULL, NULL, 'SAN VICENTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (100, 1, true, NULL, NULL, NULL, NULL, 'SANTA BARBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (101, 1, true, NULL, NULL, NULL, NULL, 'SANTA ROSA DE OSOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (102, 1, true, NULL, NULL, NULL, NULL, 'SANTO DOMINGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (103, 1, true, NULL, NULL, NULL, NULL, 'EL SANTUARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (104, 1, true, NULL, NULL, NULL, NULL, 'SEGOVIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (105, 1, true, NULL, NULL, NULL, NULL, 'SONSON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (106, 1, true, NULL, NULL, NULL, NULL, 'SOPETRAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (107, 1, true, NULL, NULL, NULL, NULL, 'TAMESIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (108, 1, true, NULL, NULL, NULL, NULL, 'TARAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (109, 1, true, NULL, NULL, NULL, NULL, 'TARSO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (110, 1, true, NULL, NULL, NULL, NULL, 'TITIRIBI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (111, 1, true, NULL, NULL, NULL, NULL, 'TOLEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (112, 1, true, NULL, NULL, NULL, NULL, 'TURBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (113, 1, true, NULL, NULL, NULL, NULL, 'URAMITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (114, 1, true, NULL, NULL, NULL, NULL, 'URRAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (115, 1, true, NULL, NULL, NULL, NULL, 'VALDIVIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (116, 1, true, NULL, NULL, NULL, NULL, 'VALPARAISO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (117, 1, true, NULL, NULL, NULL, NULL, 'VEGACHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (118, 1, true, NULL, NULL, NULL, NULL, 'VENECIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (119, 1, true, NULL, NULL, NULL, NULL, 'VIGIA DEL FUERTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (120, 1, true, NULL, NULL, NULL, NULL, 'YALI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (121, 1, true, NULL, NULL, NULL, NULL, 'YARUMAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (122, 1, true, NULL, NULL, NULL, NULL, 'YOLOMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (123, 1, true, NULL, NULL, NULL, NULL, 'YONDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (124, 1, true, NULL, NULL, NULL, NULL, 'ZARAGOZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (125, 2, true, NULL, NULL, NULL, NULL, 'BARRANQUILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (126, 2, true, NULL, NULL, NULL, NULL, 'BARANOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (127, 2, true, NULL, NULL, NULL, NULL, 'CAMPO DE LA CRUZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (128, 2, true, NULL, NULL, NULL, NULL, 'CANDELARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (129, 2, true, NULL, NULL, NULL, NULL, 'GALAPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (130, 2, true, NULL, NULL, NULL, NULL, 'JUAN DE ACOSTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (131, 2, true, NULL, NULL, NULL, NULL, 'LURUACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (132, 2, true, NULL, NULL, NULL, NULL, 'MALAMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (133, 2, true, NULL, NULL, NULL, NULL, 'MANATI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (134, 2, true, NULL, NULL, NULL, NULL, 'PALMAR DE VARELA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (135, 2, true, NULL, NULL, NULL, NULL, 'PIOJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (136, 2, true, NULL, NULL, NULL, NULL, 'POLONUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (137, 2, true, NULL, NULL, NULL, NULL, 'PONEDERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (138, 2, true, NULL, NULL, NULL, NULL, 'PUERTO COLOMBIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (139, 2, true, NULL, NULL, NULL, NULL, 'REPELON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (140, 2, true, NULL, NULL, NULL, NULL, 'SABANAGRANDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (141, 2, true, NULL, NULL, NULL, NULL, 'SABANALARGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (142, 2, true, NULL, NULL, NULL, NULL, 'SANTA LUCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (143, 2, true, NULL, NULL, NULL, NULL, 'SANTO TOMAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (144, 2, true, NULL, NULL, NULL, NULL, 'SOLEDAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (145, 2, true, NULL, NULL, NULL, NULL, 'SUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (146, 2, true, NULL, NULL, NULL, NULL, 'TUBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (147, 2, true, NULL, NULL, NULL, NULL, 'USIACURI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (149, 4, true, NULL, NULL, NULL, NULL, 'CARTAGENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (150, 4, true, NULL, NULL, NULL, NULL, 'ACHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (151, 4, true, NULL, NULL, NULL, NULL, 'ALTOS DEL ROSARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (152, 4, true, NULL, NULL, NULL, NULL, 'ARENAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (153, 4, true, NULL, NULL, NULL, NULL, 'ARJONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (154, 4, true, NULL, NULL, NULL, NULL, 'ARROYOHONDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (155, 4, true, NULL, NULL, NULL, NULL, 'BARRANCO DE LOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (156, 4, true, NULL, NULL, NULL, NULL, 'CALAMAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (157, 4, true, NULL, NULL, NULL, NULL, 'CANTAGALLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (158, 4, true, NULL, NULL, NULL, NULL, 'CICUCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (159, 4, true, NULL, NULL, NULL, NULL, 'CORDOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (160, 4, true, NULL, NULL, NULL, NULL, 'CLEMENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (161, 4, true, NULL, NULL, NULL, NULL, 'EL CARMEN DE BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (162, 4, true, NULL, NULL, NULL, NULL, 'EL GUAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (163, 4, true, NULL, NULL, NULL, NULL, 'EL PEÑON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (164, 4, true, NULL, NULL, NULL, NULL, 'HATILLO DE LOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (165, 4, true, NULL, NULL, NULL, NULL, 'MAGANGUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (166, 4, true, NULL, NULL, NULL, NULL, 'MAHATES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (167, 4, true, NULL, NULL, NULL, NULL, 'MARGARITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (168, 4, true, NULL, NULL, NULL, NULL, 'MARIA LA BAJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (169, 4, true, NULL, NULL, NULL, NULL, 'MONTECRISTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (170, 4, true, NULL, NULL, NULL, NULL, 'MOMPOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (171, 4, true, NULL, NULL, NULL, NULL, 'MORALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (172, 4, true, NULL, NULL, NULL, NULL, 'PINILLOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (173, 4, true, NULL, NULL, NULL, NULL, 'REGIDOR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (174, 4, true, NULL, NULL, NULL, NULL, 'RIO VIEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (175, 4, true, NULL, NULL, NULL, NULL, 'SAN CRISTOBAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (176, 4, true, NULL, NULL, NULL, NULL, 'SAN ESTANISLAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (177, 4, true, NULL, NULL, NULL, NULL, 'SAN FERNANDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (178, 4, true, NULL, NULL, NULL, NULL, 'SAN JACINTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (179, 4, true, NULL, NULL, NULL, NULL, 'SAN JACINTO DEL CAUCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (180, 4, true, NULL, NULL, NULL, NULL, 'SAN JUAN NEPOMUCENO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (181, 4, true, NULL, NULL, NULL, NULL, 'SAN MARTIN DE LOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (182, 4, true, NULL, NULL, NULL, NULL, 'SAN PABLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (183, 4, true, NULL, NULL, NULL, NULL, 'SANTA CATALINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (184, 4, true, NULL, NULL, NULL, NULL, 'SANTA ROSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (185, 4, true, NULL, NULL, NULL, NULL, 'SANTA ROSA DEL SUR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (186, 4, true, NULL, NULL, NULL, NULL, 'SIMITI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (187, 4, true, NULL, NULL, NULL, NULL, 'SOPLAVIENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (188, 4, true, NULL, NULL, NULL, NULL, 'TALAIGUA NUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (189, 4, true, NULL, NULL, NULL, NULL, 'TIQUISIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (190, 4, true, NULL, NULL, NULL, NULL, 'TURBACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (191, 4, true, NULL, NULL, NULL, NULL, 'TURBANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (192, 4, true, NULL, NULL, NULL, NULL, 'VILLANUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (193, 4, true, NULL, NULL, NULL, NULL, 'ZAMBRANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (194, 5, true, NULL, NULL, NULL, NULL, 'TUNJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (195, 5, true, NULL, NULL, NULL, NULL, 'ALMEIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (196, 5, true, NULL, NULL, NULL, NULL, 'AQUITANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (197, 5, true, NULL, NULL, NULL, NULL, 'ARCABUCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (198, 5, true, NULL, NULL, NULL, NULL, 'BELEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (199, 5, true, NULL, NULL, NULL, NULL, 'BERBEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (200, 5, true, NULL, NULL, NULL, NULL, 'BETEITIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (201, 5, true, NULL, NULL, NULL, NULL, 'BOAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (202, 5, true, NULL, NULL, NULL, NULL, 'BOYACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (203, 5, true, NULL, NULL, NULL, NULL, 'BRICEÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (204, 5, true, NULL, NULL, NULL, NULL, 'BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (205, 5, true, NULL, NULL, NULL, NULL, 'BUSBANZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (206, 5, true, NULL, NULL, NULL, NULL, 'CALDAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (207, 5, true, NULL, NULL, NULL, NULL, 'CAMPOHERMOSO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (208, 5, true, NULL, NULL, NULL, NULL, 'CERINZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (209, 5, true, NULL, NULL, NULL, NULL, 'CHINAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (210, 5, true, NULL, NULL, NULL, NULL, 'CHIQUINQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (211, 5, true, NULL, NULL, NULL, NULL, 'CHISCAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (212, 5, true, NULL, NULL, NULL, NULL, 'CHITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (213, 5, true, NULL, NULL, NULL, NULL, 'CHITARAQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (214, 5, true, NULL, NULL, NULL, NULL, 'CHIVATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (215, 5, true, NULL, NULL, NULL, NULL, 'CIENEGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (216, 5, true, NULL, NULL, NULL, NULL, 'COMBITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (217, 5, true, NULL, NULL, NULL, NULL, 'COPER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (218, 5, true, NULL, NULL, NULL, NULL, 'CORRALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (219, 5, true, NULL, NULL, NULL, NULL, 'COVARACHIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (220, 5, true, NULL, NULL, NULL, NULL, 'CUBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (221, 5, true, NULL, NULL, NULL, NULL, 'CUCAITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (222, 5, true, NULL, NULL, NULL, NULL, 'CUITIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (223, 5, true, NULL, NULL, NULL, NULL, 'CHIQUIZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (224, 5, true, NULL, NULL, NULL, NULL, 'CHIVOR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (225, 5, true, NULL, NULL, NULL, NULL, 'DUITAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (226, 5, true, NULL, NULL, NULL, NULL, 'EL COCUY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (227, 5, true, NULL, NULL, NULL, NULL, 'EL ESPINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (228, 5, true, NULL, NULL, NULL, NULL, 'FIRAVITOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (229, 5, true, NULL, NULL, NULL, NULL, 'FLORESTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (230, 5, true, NULL, NULL, NULL, NULL, 'GACHANTIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (231, 5, true, NULL, NULL, NULL, NULL, 'GAMEZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (232, 5, true, NULL, NULL, NULL, NULL, 'GARAGOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (233, 5, true, NULL, NULL, NULL, NULL, 'GUACAMAYAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (234, 5, true, NULL, NULL, NULL, NULL, 'GUATEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (235, 5, true, NULL, NULL, NULL, NULL, 'GUAYATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (236, 5, true, NULL, NULL, NULL, NULL, 'GsICAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (237, 5, true, NULL, NULL, NULL, NULL, 'IZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (238, 5, true, NULL, NULL, NULL, NULL, 'JENESANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (239, 5, true, NULL, NULL, NULL, NULL, 'JERICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (240, 5, true, NULL, NULL, NULL, NULL, 'LABRANZAGRANDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (241, 5, true, NULL, NULL, NULL, NULL, 'LA CAPILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (242, 5, true, NULL, NULL, NULL, NULL, 'LA VICTORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (243, 5, true, NULL, NULL, NULL, NULL, 'LA UVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (244, 5, true, NULL, NULL, NULL, NULL, 'VILLA DE LEYVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (245, 5, true, NULL, NULL, NULL, NULL, 'MACANAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (246, 5, true, NULL, NULL, NULL, NULL, 'MARIPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (247, 5, true, NULL, NULL, NULL, NULL, 'MIRAFLORES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (248, 5, true, NULL, NULL, NULL, NULL, 'MONGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (249, 5, true, NULL, NULL, NULL, NULL, 'MONGUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (250, 5, true, NULL, NULL, NULL, NULL, 'MONIQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (251, 5, true, NULL, NULL, NULL, NULL, 'MOTAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (252, 5, true, NULL, NULL, NULL, NULL, 'MUZO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (253, 5, true, NULL, NULL, NULL, NULL, 'NOBSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (254, 5, true, NULL, NULL, NULL, NULL, 'NUEVO COLON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (255, 5, true, NULL, NULL, NULL, NULL, 'OICATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (256, 5, true, NULL, NULL, NULL, NULL, 'OTANCHE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (257, 5, true, NULL, NULL, NULL, NULL, 'PACHAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (258, 5, true, NULL, NULL, NULL, NULL, 'PAEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (259, 5, true, NULL, NULL, NULL, NULL, 'PAIPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (260, 5, true, NULL, NULL, NULL, NULL, 'PAJARITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (261, 5, true, NULL, NULL, NULL, NULL, 'PANQUEBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (262, 5, true, NULL, NULL, NULL, NULL, 'PAUNA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (263, 5, true, NULL, NULL, NULL, NULL, 'PAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (264, 5, true, NULL, NULL, NULL, NULL, 'PAZ DE RIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (265, 5, true, NULL, NULL, NULL, NULL, 'PESCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (266, 5, true, NULL, NULL, NULL, NULL, 'PISBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (267, 5, true, NULL, NULL, NULL, NULL, 'PUERTO BOYACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (268, 5, true, NULL, NULL, NULL, NULL, 'QUIPAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (269, 5, true, NULL, NULL, NULL, NULL, 'RAMIRIQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (270, 5, true, NULL, NULL, NULL, NULL, 'RAQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (271, 5, true, NULL, NULL, NULL, NULL, 'RONDON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (272, 5, true, NULL, NULL, NULL, NULL, 'SABOYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (273, 5, true, NULL, NULL, NULL, NULL, 'SACHICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (274, 5, true, NULL, NULL, NULL, NULL, 'SAMACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (275, 5, true, NULL, NULL, NULL, NULL, 'SAN EDUARDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (276, 5, true, NULL, NULL, NULL, NULL, 'SAN JOSE DE PARE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (277, 5, true, NULL, NULL, NULL, NULL, 'SAN LUIS DE GACENO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (278, 5, true, NULL, NULL, NULL, NULL, 'SAN MATEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (279, 5, true, NULL, NULL, NULL, NULL, 'SAN MIGUEL DE SEMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (280, 5, true, NULL, NULL, NULL, NULL, 'SAN PABLO DE BORBUR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (281, 5, true, NULL, NULL, NULL, NULL, 'SANTANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (282, 5, true, NULL, NULL, NULL, NULL, 'SANTA MARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (283, 5, true, NULL, NULL, NULL, NULL, 'SANTA ROSA DE VITERBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (284, 5, true, NULL, NULL, NULL, NULL, 'SANTA SOFIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (285, 5, true, NULL, NULL, NULL, NULL, 'SATIVANORTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (286, 5, true, NULL, NULL, NULL, NULL, 'SATIVASUR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (287, 5, true, NULL, NULL, NULL, NULL, 'SIACHOQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (288, 5, true, NULL, NULL, NULL, NULL, 'SOATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (289, 5, true, NULL, NULL, NULL, NULL, 'SOCOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (290, 5, true, NULL, NULL, NULL, NULL, 'SOCHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (291, 5, true, NULL, NULL, NULL, NULL, 'SOGAMOSO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (292, 5, true, NULL, NULL, NULL, NULL, 'SOMONDOCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (293, 5, true, NULL, NULL, NULL, NULL, 'SORA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (294, 5, true, NULL, NULL, NULL, NULL, 'SOTAQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (295, 5, true, NULL, NULL, NULL, NULL, 'SORACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (296, 5, true, NULL, NULL, NULL, NULL, 'SUSACON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (297, 5, true, NULL, NULL, NULL, NULL, 'SUTAMARCHAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (298, 5, true, NULL, NULL, NULL, NULL, 'SUTATENZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (299, 5, true, NULL, NULL, NULL, NULL, 'TASCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (300, 5, true, NULL, NULL, NULL, NULL, 'TENZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (301, 5, true, NULL, NULL, NULL, NULL, 'TIBANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (302, 5, true, NULL, NULL, NULL, NULL, 'TIBASOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (303, 5, true, NULL, NULL, NULL, NULL, 'TINJACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (304, 5, true, NULL, NULL, NULL, NULL, 'TIPACOQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (305, 5, true, NULL, NULL, NULL, NULL, 'TOCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (306, 5, true, NULL, NULL, NULL, NULL, 'TOGsI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (307, 5, true, NULL, NULL, NULL, NULL, 'TOPAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (308, 5, true, NULL, NULL, NULL, NULL, 'TOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (309, 5, true, NULL, NULL, NULL, NULL, 'TUNUNGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (310, 5, true, NULL, NULL, NULL, NULL, 'TURMEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (311, 5, true, NULL, NULL, NULL, NULL, 'TUTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (312, 5, true, NULL, NULL, NULL, NULL, 'TUTAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (313, 5, true, NULL, NULL, NULL, NULL, 'UMBITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (314, 5, true, NULL, NULL, NULL, NULL, 'VENTAQUEMADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (315, 5, true, NULL, NULL, NULL, NULL, 'VIRACACHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (316, 5, true, NULL, NULL, NULL, NULL, 'ZETAQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (317, 6, true, NULL, NULL, NULL, NULL, 'MANIZALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (318, 6, true, NULL, NULL, NULL, NULL, 'AGUADAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (319, 6, true, NULL, NULL, NULL, NULL, 'ANSERMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (320, 6, true, NULL, NULL, NULL, NULL, 'ARANZAZU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (321, 6, true, NULL, NULL, NULL, NULL, 'BELALCAZAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (322, 6, true, NULL, NULL, NULL, NULL, 'CHINCHINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (323, 6, true, NULL, NULL, NULL, NULL, 'FILADELFIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (324, 6, true, NULL, NULL, NULL, NULL, 'LA DORADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (325, 6, true, NULL, NULL, NULL, NULL, 'LA MERCED', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (326, 6, true, NULL, NULL, NULL, NULL, 'MANZANARES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (327, 6, true, NULL, NULL, NULL, NULL, 'MARMATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (328, 6, true, NULL, NULL, NULL, NULL, 'MARQUETALIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (329, 6, true, NULL, NULL, NULL, NULL, 'MARULANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (330, 6, true, NULL, NULL, NULL, NULL, 'NEIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (331, 6, true, NULL, NULL, NULL, NULL, 'NORCASIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (332, 6, true, NULL, NULL, NULL, NULL, 'PACORA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (333, 6, true, NULL, NULL, NULL, NULL, 'PALESTINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (334, 6, true, NULL, NULL, NULL, NULL, 'PENSILVANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (335, 6, true, NULL, NULL, NULL, NULL, 'RIOSUCIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (336, 6, true, NULL, NULL, NULL, NULL, 'RISARALDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (337, 6, true, NULL, NULL, NULL, NULL, 'SALAMINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (338, 6, true, NULL, NULL, NULL, NULL, 'SAMANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (339, 6, true, NULL, NULL, NULL, NULL, 'SAN JOSE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (340, 6, true, NULL, NULL, NULL, NULL, 'SUPIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (341, 6, true, NULL, NULL, NULL, NULL, 'VICTORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (342, 6, true, NULL, NULL, NULL, NULL, 'VILLAMARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (343, 6, true, NULL, NULL, NULL, NULL, 'VITERBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (344, 7, true, NULL, NULL, NULL, NULL, 'FLORENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (345, 7, true, NULL, NULL, NULL, NULL, 'ALBANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (346, 7, true, NULL, NULL, NULL, NULL, 'BELEN DE LOS ANDAQUIES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (347, 7, true, NULL, NULL, NULL, NULL, 'CARTAGENA DEL CHAIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (348, 7, true, NULL, NULL, NULL, NULL, 'CURILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (349, 7, true, NULL, NULL, NULL, NULL, 'EL DONCELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (350, 7, true, NULL, NULL, NULL, NULL, 'EL PAUJIL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (351, 7, true, NULL, NULL, NULL, NULL, 'LA MONTAÑITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (352, 7, true, NULL, NULL, NULL, NULL, 'MILAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (353, 7, true, NULL, NULL, NULL, NULL, 'MORELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (354, 7, true, NULL, NULL, NULL, NULL, 'PUERTO RICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (355, 7, true, NULL, NULL, NULL, NULL, 'SAN JOSE DEL FRAGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (356, 7, true, NULL, NULL, NULL, NULL, 'SAN VICENTE DEL CAGUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (357, 7, true, NULL, NULL, NULL, NULL, 'SOLANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (358, 7, true, NULL, NULL, NULL, NULL, 'SOLITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (359, 7, true, NULL, NULL, NULL, NULL, 'VALPARAISO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (360, 8, true, NULL, NULL, NULL, NULL, 'POPAYAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (361, 8, true, NULL, NULL, NULL, NULL, 'ALMAGUER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (362, 8, true, NULL, NULL, NULL, NULL, 'ARGELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (363, 8, true, NULL, NULL, NULL, NULL, 'BALBOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (364, 8, true, NULL, NULL, NULL, NULL, 'BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (365, 8, true, NULL, NULL, NULL, NULL, 'BUENOS AIRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (366, 8, true, NULL, NULL, NULL, NULL, 'CAJIBIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (367, 8, true, NULL, NULL, NULL, NULL, 'CALDONO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (368, 8, true, NULL, NULL, NULL, NULL, 'CALOTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (369, 8, true, NULL, NULL, NULL, NULL, 'CORINTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (370, 8, true, NULL, NULL, NULL, NULL, 'EL TAMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (371, 8, true, NULL, NULL, NULL, NULL, 'FLORENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (372, 8, true, NULL, NULL, NULL, NULL, 'GUAPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (373, 8, true, NULL, NULL, NULL, NULL, 'INZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (374, 8, true, NULL, NULL, NULL, NULL, 'JAMBALO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (375, 8, true, NULL, NULL, NULL, NULL, 'LA SIERRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (376, 8, true, NULL, NULL, NULL, NULL, 'LA VEGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (377, 8, true, NULL, NULL, NULL, NULL, 'LOPEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (378, 8, true, NULL, NULL, NULL, NULL, 'MERCADERES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (379, 8, true, NULL, NULL, NULL, NULL, 'MIRANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (380, 8, true, NULL, NULL, NULL, NULL, 'MORALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (381, 8, true, NULL, NULL, NULL, NULL, 'PADILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (382, 8, true, NULL, NULL, NULL, NULL, 'PAEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (383, 8, true, NULL, NULL, NULL, NULL, 'PATIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (384, 8, true, NULL, NULL, NULL, NULL, 'PIAMONTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (385, 8, true, NULL, NULL, NULL, NULL, 'PIENDAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (386, 8, true, NULL, NULL, NULL, NULL, 'PUERTO TEJADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (387, 8, true, NULL, NULL, NULL, NULL, 'PURACE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (388, 8, true, NULL, NULL, NULL, NULL, 'ROSAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (389, 8, true, NULL, NULL, NULL, NULL, 'SAN SEBASTIAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (390, 8, true, NULL, NULL, NULL, NULL, 'SANTANDER DE QUILICHAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (391, 8, true, NULL, NULL, NULL, NULL, 'SANTA ROSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (392, 8, true, NULL, NULL, NULL, NULL, 'SILVIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (393, 8, true, NULL, NULL, NULL, NULL, 'SOTARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (394, 8, true, NULL, NULL, NULL, NULL, 'SUAREZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (395, 8, true, NULL, NULL, NULL, NULL, 'SUCRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (396, 8, true, NULL, NULL, NULL, NULL, 'TIMBIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (397, 8, true, NULL, NULL, NULL, NULL, 'TIMBIQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (398, 8, true, NULL, NULL, NULL, NULL, 'TORIBIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (399, 8, true, NULL, NULL, NULL, NULL, 'TOTORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (400, 8, true, NULL, NULL, NULL, NULL, 'VILLA RICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (401, 9, true, NULL, NULL, NULL, NULL, 'VALLEDUPAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (402, 9, true, NULL, NULL, NULL, NULL, 'AGUACHICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (403, 9, true, NULL, NULL, NULL, NULL, 'AGUSTIN CODAZZI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (404, 9, true, NULL, NULL, NULL, NULL, 'ASTREA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (405, 9, true, NULL, NULL, NULL, NULL, 'BECERRIL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (406, 9, true, NULL, NULL, NULL, NULL, 'BOSCONIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (407, 9, true, NULL, NULL, NULL, NULL, 'CHIMICHAGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (408, 9, true, NULL, NULL, NULL, NULL, 'CHIRIGUANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (409, 9, true, NULL, NULL, NULL, NULL, 'CURUMANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (410, 9, true, NULL, NULL, NULL, NULL, 'EL COPEY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (411, 9, true, NULL, NULL, NULL, NULL, 'EL PASO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (412, 9, true, NULL, NULL, NULL, NULL, 'GAMARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (413, 9, true, NULL, NULL, NULL, NULL, 'GONZALEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (414, 9, true, NULL, NULL, NULL, NULL, 'LA GLORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (415, 9, true, NULL, NULL, NULL, NULL, 'LA JAGUA DE IBIRICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (416, 9, true, NULL, NULL, NULL, NULL, 'MANAURE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (417, 9, true, NULL, NULL, NULL, NULL, 'PAILITAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (418, 9, true, NULL, NULL, NULL, NULL, 'PELAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (419, 9, true, NULL, NULL, NULL, NULL, 'PUEBLO BELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (420, 9, true, NULL, NULL, NULL, NULL, 'RIO DE ORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (421, 9, true, NULL, NULL, NULL, NULL, 'LA PAZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (422, 9, true, NULL, NULL, NULL, NULL, 'SAN ALBERTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (423, 9, true, NULL, NULL, NULL, NULL, 'SAN DIEGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (424, 9, true, NULL, NULL, NULL, NULL, 'SAN MARTIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (425, 9, true, NULL, NULL, NULL, NULL, 'TAMALAMEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (426, 10, true, NULL, NULL, NULL, NULL, 'MONTERIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (427, 10, true, NULL, NULL, NULL, NULL, 'AYAPEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (428, 10, true, NULL, NULL, NULL, NULL, 'BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (429, 10, true, NULL, NULL, NULL, NULL, 'CANALETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (430, 10, true, NULL, NULL, NULL, NULL, 'CERETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (431, 10, true, NULL, NULL, NULL, NULL, 'CHIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (432, 10, true, NULL, NULL, NULL, NULL, 'CHINU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (433, 10, true, NULL, NULL, NULL, NULL, 'CIENAGA DE ORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (434, 10, true, NULL, NULL, NULL, NULL, 'COTORRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (435, 10, true, NULL, NULL, NULL, NULL, 'LA APARTADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (436, 10, true, NULL, NULL, NULL, NULL, 'LORICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (437, 10, true, NULL, NULL, NULL, NULL, 'LOS CORDOBAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (438, 10, true, NULL, NULL, NULL, NULL, 'MOMIL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (439, 10, true, NULL, NULL, NULL, NULL, 'MONTELIBANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (440, 10, true, NULL, NULL, NULL, NULL, 'MOÑITOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (441, 10, true, NULL, NULL, NULL, NULL, 'PLANETA RICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (442, 10, true, NULL, NULL, NULL, NULL, 'PUEBLO NUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (443, 10, true, NULL, NULL, NULL, NULL, 'PUERTO ESCONDIDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (444, 10, true, NULL, NULL, NULL, NULL, 'PUERTO LIBERTADOR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (445, 10, true, NULL, NULL, NULL, NULL, 'PURISIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (446, 10, true, NULL, NULL, NULL, NULL, 'SAHAGUN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (447, 10, true, NULL, NULL, NULL, NULL, 'SAN ANDRES SOTAVENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (448, 10, true, NULL, NULL, NULL, NULL, 'SAN ANTERO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (449, 10, true, NULL, NULL, NULL, NULL, 'SAN BERNARDO DEL VIENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (450, 10, true, NULL, NULL, NULL, NULL, 'SAN CARLOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (451, 10, true, NULL, NULL, NULL, NULL, 'SAN PELAYO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (452, 10, true, NULL, NULL, NULL, NULL, 'TIERRALTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (453, 10, true, NULL, NULL, NULL, NULL, 'VALENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (454, 11, true, NULL, NULL, NULL, NULL, 'AGUA DE DIOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (455, 11, true, NULL, NULL, NULL, NULL, 'ALBAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (456, 11, true, NULL, NULL, NULL, NULL, 'ANAPOIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (457, 11, true, NULL, NULL, NULL, NULL, 'ANOLAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (458, 11, true, NULL, NULL, NULL, NULL, 'ARBELAEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (459, 11, true, NULL, NULL, NULL, NULL, 'BELTRAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (460, 11, true, NULL, NULL, NULL, NULL, 'BITUIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (461, 11, true, NULL, NULL, NULL, NULL, 'BOJACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (462, 11, true, NULL, NULL, NULL, NULL, 'CABRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (463, 11, true, NULL, NULL, NULL, NULL, 'CACHIPAY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (464, 11, true, NULL, NULL, NULL, NULL, 'CAJICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (465, 11, true, NULL, NULL, NULL, NULL, 'CAPARRAPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (466, 11, true, NULL, NULL, NULL, NULL, 'CAQUEZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (467, 11, true, NULL, NULL, NULL, NULL, 'CARMEN DE CARUPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (468, 11, true, NULL, NULL, NULL, NULL, 'CHAGUANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (469, 11, true, NULL, NULL, NULL, NULL, 'CHIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (470, 11, true, NULL, NULL, NULL, NULL, 'CHIPAQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (471, 11, true, NULL, NULL, NULL, NULL, 'CHOACHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (472, 11, true, NULL, NULL, NULL, NULL, 'CHOCONTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (473, 11, true, NULL, NULL, NULL, NULL, 'COGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (474, 11, true, NULL, NULL, NULL, NULL, 'COTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (475, 11, true, NULL, NULL, NULL, NULL, 'CUCUNUBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (476, 11, true, NULL, NULL, NULL, NULL, 'EL COLEGIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (477, 11, true, NULL, NULL, NULL, NULL, 'EL PEÑON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (478, 11, true, NULL, NULL, NULL, NULL, 'EL ROSAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (479, 11, true, NULL, NULL, NULL, NULL, 'FACATATIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (480, 11, true, NULL, NULL, NULL, NULL, 'FOMEQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (481, 11, true, NULL, NULL, NULL, NULL, 'FOSCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (482, 11, true, NULL, NULL, NULL, NULL, 'FUNZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (483, 11, true, NULL, NULL, NULL, NULL, 'FUQUENE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (484, 11, true, NULL, NULL, NULL, NULL, 'FUSAGASUGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (485, 11, true, NULL, NULL, NULL, NULL, 'GACHALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (486, 11, true, NULL, NULL, NULL, NULL, 'GACHANCIPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (487, 11, true, NULL, NULL, NULL, NULL, 'GACHETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (488, 11, true, NULL, NULL, NULL, NULL, 'GAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (489, 11, true, NULL, NULL, NULL, NULL, 'GIRARDOT', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (490, 11, true, NULL, NULL, NULL, NULL, 'GRANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (491, 11, true, NULL, NULL, NULL, NULL, 'GUACHETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (492, 11, true, NULL, NULL, NULL, NULL, 'GUADUAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (493, 11, true, NULL, NULL, NULL, NULL, 'GUASCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (494, 11, true, NULL, NULL, NULL, NULL, 'GUATAQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (495, 11, true, NULL, NULL, NULL, NULL, 'GUATAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (496, 11, true, NULL, NULL, NULL, NULL, 'GUAYABAL DE SIQUIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (497, 11, true, NULL, NULL, NULL, NULL, 'GUAYABETAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (498, 11, true, NULL, NULL, NULL, NULL, 'GUTIERREZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (499, 11, true, NULL, NULL, NULL, NULL, 'JERUSALEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (500, 11, true, NULL, NULL, NULL, NULL, 'JUNIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (501, 11, true, NULL, NULL, NULL, NULL, 'LA CALERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (502, 11, true, NULL, NULL, NULL, NULL, 'LA MESA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (503, 11, true, NULL, NULL, NULL, NULL, 'LA PALMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (504, 11, true, NULL, NULL, NULL, NULL, 'LA PEÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (505, 11, true, NULL, NULL, NULL, NULL, 'LA VEGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (506, 11, true, NULL, NULL, NULL, NULL, 'LENGUAZAQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (507, 11, true, NULL, NULL, NULL, NULL, 'MACHETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (508, 11, true, NULL, NULL, NULL, NULL, 'MADRID', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (509, 11, true, NULL, NULL, NULL, NULL, 'MANTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (510, 11, true, NULL, NULL, NULL, NULL, 'MEDINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (511, 11, true, NULL, NULL, NULL, NULL, 'MOSQUERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (512, 11, true, NULL, NULL, NULL, NULL, 'NARIÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (513, 11, true, NULL, NULL, NULL, NULL, 'NEMOCON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (514, 11, true, NULL, NULL, NULL, NULL, 'NILO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (515, 11, true, NULL, NULL, NULL, NULL, 'NIMAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (516, 11, true, NULL, NULL, NULL, NULL, 'NOCAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (517, 11, true, NULL, NULL, NULL, NULL, 'VENECIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (518, 11, true, NULL, NULL, NULL, NULL, 'PACHO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (519, 11, true, NULL, NULL, NULL, NULL, 'PAIME', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (520, 11, true, NULL, NULL, NULL, NULL, 'PANDI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (521, 11, true, NULL, NULL, NULL, NULL, 'PARATEBUENO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (522, 11, true, NULL, NULL, NULL, NULL, 'PASCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (523, 11, true, NULL, NULL, NULL, NULL, 'PUERTO SALGAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (524, 11, true, NULL, NULL, NULL, NULL, 'PULI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (525, 11, true, NULL, NULL, NULL, NULL, 'QUEBRADANEGRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (526, 11, true, NULL, NULL, NULL, NULL, 'QUETAME', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (527, 11, true, NULL, NULL, NULL, NULL, 'QUIPILE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (528, 11, true, NULL, NULL, NULL, NULL, 'APULO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (529, 11, true, NULL, NULL, NULL, NULL, 'RICAURTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (530, 11, true, NULL, NULL, NULL, NULL, 'SAN ANTONIO DEL TEQUENDAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (531, 11, true, NULL, NULL, NULL, NULL, 'SAN BERNARDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (532, 11, true, NULL, NULL, NULL, NULL, 'SAN CAYETANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (533, 11, true, NULL, NULL, NULL, NULL, 'SAN FRANCISCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (534, 11, true, NULL, NULL, NULL, NULL, 'SAN JUAN DE RIO SECO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (535, 11, true, NULL, NULL, NULL, NULL, 'SASAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (536, 11, true, NULL, NULL, NULL, NULL, 'SESQUILE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (537, 11, true, NULL, NULL, NULL, NULL, 'SIBATE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (538, 11, true, NULL, NULL, NULL, NULL, 'SILVANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (539, 11, true, NULL, NULL, NULL, NULL, 'SIMIJACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (540, 11, true, NULL, NULL, NULL, NULL, 'SOACHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (541, 11, true, NULL, NULL, NULL, NULL, 'SOPO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (542, 11, true, NULL, NULL, NULL, NULL, 'SUBACHOQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (543, 11, true, NULL, NULL, NULL, NULL, 'SUESCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (544, 11, true, NULL, NULL, NULL, NULL, 'SUPATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (545, 11, true, NULL, NULL, NULL, NULL, 'SUSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (546, 11, true, NULL, NULL, NULL, NULL, 'SUTATAUSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (547, 11, true, NULL, NULL, NULL, NULL, 'TABIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (548, 11, true, NULL, NULL, NULL, NULL, 'TAUSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (549, 11, true, NULL, NULL, NULL, NULL, 'TENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (550, 11, true, NULL, NULL, NULL, NULL, 'TENJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (551, 11, true, NULL, NULL, NULL, NULL, 'TIBACUY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (552, 11, true, NULL, NULL, NULL, NULL, 'TIBIRITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (553, 11, true, NULL, NULL, NULL, NULL, 'TOCAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (554, 11, true, NULL, NULL, NULL, NULL, 'TOCANCIPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (555, 11, true, NULL, NULL, NULL, NULL, 'TOPAIPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (556, 11, true, NULL, NULL, NULL, NULL, 'UBALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (557, 11, true, NULL, NULL, NULL, NULL, 'UBAQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (558, 11, true, NULL, NULL, NULL, NULL, 'VILLA DE SAN DIEGO DE UBATE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (559, 11, true, NULL, NULL, NULL, NULL, 'UNE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (560, 11, true, NULL, NULL, NULL, NULL, 'UTICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (561, 11, true, NULL, NULL, NULL, NULL, 'VERGARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (562, 11, true, NULL, NULL, NULL, NULL, 'VIANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (563, 11, true, NULL, NULL, NULL, NULL, 'VILLAGOMEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (564, 11, true, NULL, NULL, NULL, NULL, 'VILLAPINZON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (565, 11, true, NULL, NULL, NULL, NULL, 'VILLETA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (566, 11, true, NULL, NULL, NULL, NULL, 'VIOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (567, 11, true, NULL, NULL, NULL, NULL, 'YACOPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (568, 11, true, NULL, NULL, NULL, NULL, 'ZIPACON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (569, 11, true, NULL, NULL, NULL, NULL, 'ZIPAQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (570, 12, true, NULL, NULL, NULL, NULL, 'QUIBDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (571, 12, true, NULL, NULL, NULL, NULL, 'ACANDI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (572, 12, true, NULL, NULL, NULL, NULL, 'ALTO BAUDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (573, 12, true, NULL, NULL, NULL, NULL, 'ATRATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (574, 12, true, NULL, NULL, NULL, NULL, 'BAGADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (575, 12, true, NULL, NULL, NULL, NULL, 'BAHIA SOLANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (576, 12, true, NULL, NULL, NULL, NULL, 'BAJO BAUDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (577, 12, true, NULL, NULL, NULL, NULL, 'BELEN DE BAJIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (578, 12, true, NULL, NULL, NULL, NULL, 'BOJAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (579, 12, true, NULL, NULL, NULL, NULL, 'EL CANTON DEL SAN PABLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (580, 12, true, NULL, NULL, NULL, NULL, 'CARMEN DEL DARIEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (581, 12, true, NULL, NULL, NULL, NULL, 'CERTEGUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (582, 12, true, NULL, NULL, NULL, NULL, 'CONDOTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (583, 12, true, NULL, NULL, NULL, NULL, 'EL CARMEN DE ATRATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (584, 12, true, NULL, NULL, NULL, NULL, 'EL LITORAL DEL SAN JUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (585, 12, true, NULL, NULL, NULL, NULL, 'ISTMINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (586, 12, true, NULL, NULL, NULL, NULL, 'JURADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (587, 12, true, NULL, NULL, NULL, NULL, 'LLORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (588, 12, true, NULL, NULL, NULL, NULL, 'MEDIO ATRATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (589, 12, true, NULL, NULL, NULL, NULL, 'MEDIO BAUDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (590, 12, true, NULL, NULL, NULL, NULL, 'MEDIO SAN JUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (591, 12, true, NULL, NULL, NULL, NULL, 'NOVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (592, 12, true, NULL, NULL, NULL, NULL, 'NUQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (593, 12, true, NULL, NULL, NULL, NULL, 'RIO IRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (594, 12, true, NULL, NULL, NULL, NULL, 'RIO QUITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (595, 12, true, NULL, NULL, NULL, NULL, 'RIOSUCIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (596, 12, true, NULL, NULL, NULL, NULL, 'SAN JOSE DEL PALMAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (597, 12, true, NULL, NULL, NULL, NULL, 'SIPI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (598, 12, true, NULL, NULL, NULL, NULL, 'TADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (599, 12, true, NULL, NULL, NULL, NULL, 'UNGUIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (600, 12, true, NULL, NULL, NULL, NULL, 'UNION PANAMERICANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (601, 13, true, NULL, NULL, NULL, NULL, 'NEIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (602, 13, true, NULL, NULL, NULL, NULL, 'ACEVEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (603, 13, true, NULL, NULL, NULL, NULL, 'AGRADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (604, 13, true, NULL, NULL, NULL, NULL, 'AIPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (605, 13, true, NULL, NULL, NULL, NULL, 'ALGECIRAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (606, 13, true, NULL, NULL, NULL, NULL, 'ALTAMIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (607, 13, true, NULL, NULL, NULL, NULL, 'BARAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (608, 13, true, NULL, NULL, NULL, NULL, 'CAMPOALEGRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (609, 13, true, NULL, NULL, NULL, NULL, 'COLOMBIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (610, 13, true, NULL, NULL, NULL, NULL, 'ELIAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (611, 13, true, NULL, NULL, NULL, NULL, 'GARZON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (612, 13, true, NULL, NULL, NULL, NULL, 'GIGANTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (613, 13, true, NULL, NULL, NULL, NULL, 'GUADALUPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (614, 13, true, NULL, NULL, NULL, NULL, 'HOBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (615, 13, true, NULL, NULL, NULL, NULL, 'IQUIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (616, 13, true, NULL, NULL, NULL, NULL, 'ISNOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (617, 13, true, NULL, NULL, NULL, NULL, 'LA ARGENTINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (618, 13, true, NULL, NULL, NULL, NULL, 'LA PLATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (619, 13, true, NULL, NULL, NULL, NULL, 'NATAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (620, 13, true, NULL, NULL, NULL, NULL, 'OPORAPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (621, 13, true, NULL, NULL, NULL, NULL, 'PAICOL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (622, 13, true, NULL, NULL, NULL, NULL, 'PALERMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (623, 13, true, NULL, NULL, NULL, NULL, 'PALESTINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (624, 13, true, NULL, NULL, NULL, NULL, 'PITAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (625, 13, true, NULL, NULL, NULL, NULL, 'PITALITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (626, 13, true, NULL, NULL, NULL, NULL, 'RIVERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (627, 13, true, NULL, NULL, NULL, NULL, 'SALADOBLANCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (628, 13, true, NULL, NULL, NULL, NULL, 'SAN AGUSTIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (629, 13, true, NULL, NULL, NULL, NULL, 'SANTA MARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (630, 13, true, NULL, NULL, NULL, NULL, 'SUAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (631, 13, true, NULL, NULL, NULL, NULL, 'TARQUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (632, 13, true, NULL, NULL, NULL, NULL, 'TESALIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (633, 13, true, NULL, NULL, NULL, NULL, 'TELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (634, 13, true, NULL, NULL, NULL, NULL, 'TERUEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (635, 13, true, NULL, NULL, NULL, NULL, 'TIMANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (636, 13, true, NULL, NULL, NULL, NULL, 'VILLAVIEJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (637, 13, true, NULL, NULL, NULL, NULL, 'YAGUARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (638, 14, true, NULL, NULL, NULL, NULL, 'RIOHACHA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (639, 14, true, NULL, NULL, NULL, NULL, 'ALBANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (640, 14, true, NULL, NULL, NULL, NULL, 'BARRANCAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (641, 14, true, NULL, NULL, NULL, NULL, 'DIBULLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (642, 14, true, NULL, NULL, NULL, NULL, 'DISTRACCION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (643, 14, true, NULL, NULL, NULL, NULL, 'EL MOLINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (644, 14, true, NULL, NULL, NULL, NULL, 'FONSECA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (645, 14, true, NULL, NULL, NULL, NULL, 'HATONUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (646, 14, true, NULL, NULL, NULL, NULL, 'LA JAGUA DEL PILAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (647, 14, true, NULL, NULL, NULL, NULL, 'MAICAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (648, 14, true, NULL, NULL, NULL, NULL, 'MANAURE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (649, 14, true, NULL, NULL, NULL, NULL, 'SAN JUAN DEL CESAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (650, 14, true, NULL, NULL, NULL, NULL, 'URIBIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (651, 14, true, NULL, NULL, NULL, NULL, 'URUMITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (652, 14, true, NULL, NULL, NULL, NULL, 'VILLANUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (653, 15, true, NULL, NULL, NULL, NULL, 'SANTA MARTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (654, 15, true, NULL, NULL, NULL, NULL, 'ALGARROBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (655, 15, true, NULL, NULL, NULL, NULL, 'ARACATACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (656, 15, true, NULL, NULL, NULL, NULL, 'ARIGUANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (657, 15, true, NULL, NULL, NULL, NULL, 'CERRO SAN ANTONIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (658, 15, true, NULL, NULL, NULL, NULL, 'CHIBOLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (659, 15, true, NULL, NULL, NULL, NULL, 'CIENAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (660, 15, true, NULL, NULL, NULL, NULL, 'CONCORDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (661, 15, true, NULL, NULL, NULL, NULL, 'EL BANCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (662, 15, true, NULL, NULL, NULL, NULL, 'EL PIÑON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (663, 15, true, NULL, NULL, NULL, NULL, 'EL RETEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (664, 15, true, NULL, NULL, NULL, NULL, 'FUNDACION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (665, 15, true, NULL, NULL, NULL, NULL, 'GUAMAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (666, 15, true, NULL, NULL, NULL, NULL, 'NUEVA GRANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (667, 15, true, NULL, NULL, NULL, NULL, 'PEDRAZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (668, 15, true, NULL, NULL, NULL, NULL, 'PIJIÑO DEL CARMEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (669, 15, true, NULL, NULL, NULL, NULL, 'PIVIJAY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (670, 15, true, NULL, NULL, NULL, NULL, 'PLATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (671, 15, true, NULL, NULL, NULL, NULL, 'PUEBLOVIEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (672, 15, true, NULL, NULL, NULL, NULL, 'REMOLINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (673, 15, true, NULL, NULL, NULL, NULL, 'SABANAS DE SAN ANGEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (674, 15, true, NULL, NULL, NULL, NULL, 'SALAMINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (675, 15, true, NULL, NULL, NULL, NULL, 'SAN SEBASTIAN DE BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (676, 15, true, NULL, NULL, NULL, NULL, 'SAN ZENON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (677, 15, true, NULL, NULL, NULL, NULL, 'SANTA ANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (678, 15, true, NULL, NULL, NULL, NULL, 'SANTA BARBARA DE PINTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (679, 15, true, NULL, NULL, NULL, NULL, 'SITIONUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (680, 15, true, NULL, NULL, NULL, NULL, 'TENERIFE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (681, 15, true, NULL, NULL, NULL, NULL, 'ZAPAYAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (682, 15, true, NULL, NULL, NULL, NULL, 'ZONA BANANERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (683, 16, true, NULL, NULL, NULL, NULL, 'VILLAVICENCIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (684, 16, true, NULL, NULL, NULL, NULL, 'ACACIAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (685, 16, true, NULL, NULL, NULL, NULL, 'BARRANCA DE UPIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (686, 16, true, NULL, NULL, NULL, NULL, 'CABUYARO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (687, 16, true, NULL, NULL, NULL, NULL, 'CASTILLA LA NUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (688, 16, true, NULL, NULL, NULL, NULL, 'CUBARRAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (689, 16, true, NULL, NULL, NULL, NULL, 'CUMARAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (690, 16, true, NULL, NULL, NULL, NULL, 'EL CALVARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (691, 16, true, NULL, NULL, NULL, NULL, 'EL CASTILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (692, 16, true, NULL, NULL, NULL, NULL, 'EL DORADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (693, 16, true, NULL, NULL, NULL, NULL, 'FUENTE DE ORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (694, 16, true, NULL, NULL, NULL, NULL, 'GRANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (695, 16, true, NULL, NULL, NULL, NULL, 'GUAMAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (696, 16, true, NULL, NULL, NULL, NULL, 'MAPIRIPAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (697, 16, true, NULL, NULL, NULL, NULL, 'MESETAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (698, 16, true, NULL, NULL, NULL, NULL, 'LA MACARENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (699, 16, true, NULL, NULL, NULL, NULL, 'URIBE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (700, 16, true, NULL, NULL, NULL, NULL, 'LEJANIAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (701, 16, true, NULL, NULL, NULL, NULL, 'PUERTO CONCORDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (702, 16, true, NULL, NULL, NULL, NULL, 'PUERTO GAITAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (703, 16, true, NULL, NULL, NULL, NULL, 'PUERTO LOPEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (704, 16, true, NULL, NULL, NULL, NULL, 'PUERTO LLERAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (705, 16, true, NULL, NULL, NULL, NULL, 'PUERTO RICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (706, 16, true, NULL, NULL, NULL, NULL, 'RESTREPO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (707, 16, true, NULL, NULL, NULL, NULL, 'SAN CARLOS DE GUAROA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (708, 16, true, NULL, NULL, NULL, NULL, 'SAN JUAN DE ARAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (709, 16, true, NULL, NULL, NULL, NULL, 'SAN JUANITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (710, 16, true, NULL, NULL, NULL, NULL, 'SAN MARTIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (711, 16, true, NULL, NULL, NULL, NULL, 'VISTAHERMOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (712, 17, true, NULL, NULL, NULL, NULL, 'PASTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (713, 17, true, NULL, NULL, NULL, NULL, 'ALBAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (714, 17, true, NULL, NULL, NULL, NULL, 'ALDANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (715, 17, true, NULL, NULL, NULL, NULL, 'ANCUYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (716, 17, true, NULL, NULL, NULL, NULL, 'ARBOLEDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (717, 17, true, NULL, NULL, NULL, NULL, 'BARBACOAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (718, 17, true, NULL, NULL, NULL, NULL, 'BELEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (719, 17, true, NULL, NULL, NULL, NULL, 'BUESACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (720, 17, true, NULL, NULL, NULL, NULL, 'COLON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (721, 17, true, NULL, NULL, NULL, NULL, 'CONSACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (722, 17, true, NULL, NULL, NULL, NULL, 'CONTADERO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (723, 17, true, NULL, NULL, NULL, NULL, 'CORDOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (724, 17, true, NULL, NULL, NULL, NULL, 'CUASPUD', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (725, 17, true, NULL, NULL, NULL, NULL, 'CUMBAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (726, 17, true, NULL, NULL, NULL, NULL, 'CUMBITARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (727, 17, true, NULL, NULL, NULL, NULL, 'CHACHAGsI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (728, 17, true, NULL, NULL, NULL, NULL, 'EL CHARCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (729, 17, true, NULL, NULL, NULL, NULL, 'EL PEÑOL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (730, 17, true, NULL, NULL, NULL, NULL, 'EL ROSARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (731, 17, true, NULL, NULL, NULL, NULL, 'EL TABLON DE GOMEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (732, 17, true, NULL, NULL, NULL, NULL, 'EL TAMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (733, 17, true, NULL, NULL, NULL, NULL, 'FUNES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (734, 17, true, NULL, NULL, NULL, NULL, 'GUACHUCAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (735, 17, true, NULL, NULL, NULL, NULL, 'GUAITARILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (736, 17, true, NULL, NULL, NULL, NULL, 'GUALMATAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (737, 17, true, NULL, NULL, NULL, NULL, 'ILES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (738, 17, true, NULL, NULL, NULL, NULL, 'IMUES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (739, 17, true, NULL, NULL, NULL, NULL, 'IPIALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (740, 17, true, NULL, NULL, NULL, NULL, 'LA CRUZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (741, 17, true, NULL, NULL, NULL, NULL, 'LA FLORIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (742, 17, true, NULL, NULL, NULL, NULL, 'LA LLANADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (743, 17, true, NULL, NULL, NULL, NULL, 'LA TOLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (744, 17, true, NULL, NULL, NULL, NULL, 'LA UNION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (745, 17, true, NULL, NULL, NULL, NULL, 'LEIVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (746, 17, true, NULL, NULL, NULL, NULL, 'LINARES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (747, 17, true, NULL, NULL, NULL, NULL, 'LOS ANDES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (748, 17, true, NULL, NULL, NULL, NULL, 'MAGsI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (749, 17, true, NULL, NULL, NULL, NULL, 'MALLAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (750, 17, true, NULL, NULL, NULL, NULL, 'MOSQUERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (751, 17, true, NULL, NULL, NULL, NULL, 'NARIÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (752, 17, true, NULL, NULL, NULL, NULL, 'OLAYA HERRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (753, 17, true, NULL, NULL, NULL, NULL, 'OSPINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (754, 17, true, NULL, NULL, NULL, NULL, 'FRANCISCO PIZARRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (755, 17, true, NULL, NULL, NULL, NULL, 'POLICARPA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (756, 17, true, NULL, NULL, NULL, NULL, 'POTOSI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (757, 17, true, NULL, NULL, NULL, NULL, 'PROVIDENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (758, 17, true, NULL, NULL, NULL, NULL, 'PUERRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (759, 17, true, NULL, NULL, NULL, NULL, 'PUPIALES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (760, 17, true, NULL, NULL, NULL, NULL, 'RICAURTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (761, 17, true, NULL, NULL, NULL, NULL, 'ROBERTO PAYAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (762, 17, true, NULL, NULL, NULL, NULL, 'SAMANIEGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (763, 17, true, NULL, NULL, NULL, NULL, 'SANDONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (764, 17, true, NULL, NULL, NULL, NULL, 'SAN BERNARDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (765, 17, true, NULL, NULL, NULL, NULL, 'SAN LORENZO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (766, 17, true, NULL, NULL, NULL, NULL, 'SAN PABLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (767, 17, true, NULL, NULL, NULL, NULL, 'SAN PEDRO DE CARTAGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (768, 17, true, NULL, NULL, NULL, NULL, 'SANTA BARBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (769, 17, true, NULL, NULL, NULL, NULL, 'SANTACRUZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (770, 17, true, NULL, NULL, NULL, NULL, 'SAPUYES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (771, 17, true, NULL, NULL, NULL, NULL, 'TAMINANGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (772, 17, true, NULL, NULL, NULL, NULL, 'TANGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (773, 17, true, NULL, NULL, NULL, NULL, 'SAN ANDRES DE TUMACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (774, 17, true, NULL, NULL, NULL, NULL, 'TUQUERRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (775, 17, true, NULL, NULL, NULL, NULL, 'YACUANQUER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (776, 18, true, NULL, NULL, NULL, NULL, 'CUCUTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (777, 18, true, NULL, NULL, NULL, NULL, 'ABREGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (778, 18, true, NULL, NULL, NULL, NULL, 'ARBOLEDAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (779, 18, true, NULL, NULL, NULL, NULL, 'BOCHALEMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (780, 18, true, NULL, NULL, NULL, NULL, 'BUCARASICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (781, 18, true, NULL, NULL, NULL, NULL, 'CACOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (782, 18, true, NULL, NULL, NULL, NULL, 'CACHIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (783, 18, true, NULL, NULL, NULL, NULL, 'CHINACOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (784, 18, true, NULL, NULL, NULL, NULL, 'CHITAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (785, 18, true, NULL, NULL, NULL, NULL, 'CONVENCION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (786, 18, true, NULL, NULL, NULL, NULL, 'CUCUTILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (787, 18, true, NULL, NULL, NULL, NULL, 'DURANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (788, 18, true, NULL, NULL, NULL, NULL, 'EL CARMEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (789, 18, true, NULL, NULL, NULL, NULL, 'EL TARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (790, 18, true, NULL, NULL, NULL, NULL, 'EL ZULIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (791, 18, true, NULL, NULL, NULL, NULL, 'GRAMALOTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (792, 18, true, NULL, NULL, NULL, NULL, 'HACARI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (793, 18, true, NULL, NULL, NULL, NULL, 'HERRAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (794, 18, true, NULL, NULL, NULL, NULL, 'LABATECA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (795, 18, true, NULL, NULL, NULL, NULL, 'LA ESPERANZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (796, 18, true, NULL, NULL, NULL, NULL, 'LA PLAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (797, 18, true, NULL, NULL, NULL, NULL, 'LOS PATIOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (798, 18, true, NULL, NULL, NULL, NULL, 'LOURDES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (799, 18, true, NULL, NULL, NULL, NULL, 'MUTISCUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (800, 18, true, NULL, NULL, NULL, NULL, 'OCAÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (801, 18, true, NULL, NULL, NULL, NULL, 'PAMPLONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (802, 18, true, NULL, NULL, NULL, NULL, 'PAMPLONITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (803, 18, true, NULL, NULL, NULL, NULL, 'PUERTO SANTANDER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (804, 18, true, NULL, NULL, NULL, NULL, 'RAGONVALIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (805, 18, true, NULL, NULL, NULL, NULL, 'SALAZAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (806, 18, true, NULL, NULL, NULL, NULL, 'SAN CALIXTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (807, 18, true, NULL, NULL, NULL, NULL, 'SAN CAYETANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (808, 18, true, NULL, NULL, NULL, NULL, 'SANTIAGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (809, 18, true, NULL, NULL, NULL, NULL, 'SARDINATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (810, 18, true, NULL, NULL, NULL, NULL, 'SILOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (811, 18, true, NULL, NULL, NULL, NULL, 'TEORAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (812, 18, true, NULL, NULL, NULL, NULL, 'TIBU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (813, 18, true, NULL, NULL, NULL, NULL, 'TOLEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (814, 18, true, NULL, NULL, NULL, NULL, 'VILLA CARO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (815, 18, true, NULL, NULL, NULL, NULL, 'VILLA DEL ROSARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (816, 19, true, NULL, NULL, NULL, NULL, 'ARMENIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (817, 19, true, NULL, NULL, NULL, NULL, 'BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (818, 19, true, NULL, NULL, NULL, NULL, 'CALARCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (819, 19, true, NULL, NULL, NULL, NULL, 'CIRCASIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (820, 19, true, NULL, NULL, NULL, NULL, 'CORDOBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (821, 19, true, NULL, NULL, NULL, NULL, 'FILANDIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (822, 19, true, NULL, NULL, NULL, NULL, 'GENOVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (823, 19, true, NULL, NULL, NULL, NULL, 'LA TEBAIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (824, 19, true, NULL, NULL, NULL, NULL, 'MONTENEGRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (825, 19, true, NULL, NULL, NULL, NULL, 'PIJAO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (826, 19, true, NULL, NULL, NULL, NULL, 'QUIMBAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (827, 19, true, NULL, NULL, NULL, NULL, 'SALENTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (828, 20, true, NULL, NULL, NULL, NULL, 'PEREIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (829, 20, true, NULL, NULL, NULL, NULL, 'APIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (830, 20, true, NULL, NULL, NULL, NULL, 'BALBOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (831, 20, true, NULL, NULL, NULL, NULL, 'BELEN DE UMBRIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (832, 20, true, NULL, NULL, NULL, NULL, 'DOSQUEBRADAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (833, 20, true, NULL, NULL, NULL, NULL, 'GUATICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (834, 20, true, NULL, NULL, NULL, NULL, 'LA CELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (835, 20, true, NULL, NULL, NULL, NULL, 'LA VIRGINIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (836, 20, true, NULL, NULL, NULL, NULL, 'MARSELLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (837, 20, true, NULL, NULL, NULL, NULL, 'MISTRATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (838, 20, true, NULL, NULL, NULL, NULL, 'PUEBLO RICO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (839, 20, true, NULL, NULL, NULL, NULL, 'QUINCHIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (840, 20, true, NULL, NULL, NULL, NULL, 'SANTA ROSA DE CABAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (841, 20, true, NULL, NULL, NULL, NULL, 'SANTUARIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (842, 21, true, NULL, NULL, NULL, NULL, 'BUCARAMANGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (843, 21, true, NULL, NULL, NULL, NULL, 'AGUADA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (844, 21, true, NULL, NULL, NULL, NULL, 'ALBANIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (845, 21, true, NULL, NULL, NULL, NULL, 'ARATOCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (846, 21, true, NULL, NULL, NULL, NULL, 'BARBOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (847, 21, true, NULL, NULL, NULL, NULL, 'BARICHARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (848, 21, true, NULL, NULL, NULL, NULL, 'BARRANCABERMEJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (849, 21, true, NULL, NULL, NULL, NULL, 'BETULIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (850, 21, true, NULL, NULL, NULL, NULL, 'BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (851, 21, true, NULL, NULL, NULL, NULL, 'CABRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (852, 21, true, NULL, NULL, NULL, NULL, 'CALIFORNIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (853, 21, true, NULL, NULL, NULL, NULL, 'CAPITANEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (854, 21, true, NULL, NULL, NULL, NULL, 'CARCASI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (855, 21, true, NULL, NULL, NULL, NULL, 'CEPITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (856, 21, true, NULL, NULL, NULL, NULL, 'CERRITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (857, 21, true, NULL, NULL, NULL, NULL, 'CHARALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (858, 21, true, NULL, NULL, NULL, NULL, 'CHARTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (859, 21, true, NULL, NULL, NULL, NULL, 'CHIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (860, 21, true, NULL, NULL, NULL, NULL, 'CHIPATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (861, 21, true, NULL, NULL, NULL, NULL, 'CIMITARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (862, 21, true, NULL, NULL, NULL, NULL, 'CONCEPCION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (863, 21, true, NULL, NULL, NULL, NULL, 'CONFINES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (864, 21, true, NULL, NULL, NULL, NULL, 'CONTRATACION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (865, 21, true, NULL, NULL, NULL, NULL, 'COROMORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (866, 21, true, NULL, NULL, NULL, NULL, 'CURITI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (867, 21, true, NULL, NULL, NULL, NULL, 'EL CARMEN DE CHUCURI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (868, 21, true, NULL, NULL, NULL, NULL, 'EL GUACAMAYO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (869, 21, true, NULL, NULL, NULL, NULL, 'EL PEÑON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (870, 21, true, NULL, NULL, NULL, NULL, 'EL PLAYON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (871, 21, true, NULL, NULL, NULL, NULL, 'ENCINO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (872, 21, true, NULL, NULL, NULL, NULL, 'ENCISO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (873, 21, true, NULL, NULL, NULL, NULL, 'FLORIAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (874, 21, true, NULL, NULL, NULL, NULL, 'FLORIDABLANCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (875, 21, true, NULL, NULL, NULL, NULL, 'GALAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (876, 21, true, NULL, NULL, NULL, NULL, 'GAMBITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (877, 21, true, NULL, NULL, NULL, NULL, 'GIRON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (878, 21, true, NULL, NULL, NULL, NULL, 'GUACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (879, 21, true, NULL, NULL, NULL, NULL, 'GUADALUPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (880, 21, true, NULL, NULL, NULL, NULL, 'GUAPOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (881, 21, true, NULL, NULL, NULL, NULL, 'GUAVATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (882, 21, true, NULL, NULL, NULL, NULL, 'GsEPSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (883, 21, true, NULL, NULL, NULL, NULL, 'HATO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (884, 21, true, NULL, NULL, NULL, NULL, 'JESUS MARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (885, 21, true, NULL, NULL, NULL, NULL, 'JORDAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (886, 21, true, NULL, NULL, NULL, NULL, 'LA BELLEZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (887, 21, true, NULL, NULL, NULL, NULL, 'LANDAZURI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (888, 21, true, NULL, NULL, NULL, NULL, 'LA PAZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (889, 21, true, NULL, NULL, NULL, NULL, 'LEBRIJA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (890, 21, true, NULL, NULL, NULL, NULL, 'LOS SANTOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (891, 21, true, NULL, NULL, NULL, NULL, 'MACARAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (892, 21, true, NULL, NULL, NULL, NULL, 'MALAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (893, 21, true, NULL, NULL, NULL, NULL, 'MATANZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (894, 21, true, NULL, NULL, NULL, NULL, 'MOGOTES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (895, 21, true, NULL, NULL, NULL, NULL, 'MOLAGAVITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (896, 21, true, NULL, NULL, NULL, NULL, 'OCAMONTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (897, 21, true, NULL, NULL, NULL, NULL, 'OIBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (898, 21, true, NULL, NULL, NULL, NULL, 'ONZAGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (899, 21, true, NULL, NULL, NULL, NULL, 'PALMAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (900, 21, true, NULL, NULL, NULL, NULL, 'PALMAS DEL SOCORRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (901, 21, true, NULL, NULL, NULL, NULL, 'PARAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (902, 21, true, NULL, NULL, NULL, NULL, 'PIEDECUESTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (903, 21, true, NULL, NULL, NULL, NULL, 'PINCHOTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (904, 21, true, NULL, NULL, NULL, NULL, 'PUENTE NACIONAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (905, 21, true, NULL, NULL, NULL, NULL, 'PUERTO PARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (906, 21, true, NULL, NULL, NULL, NULL, 'PUERTO WILCHES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (907, 21, true, NULL, NULL, NULL, NULL, 'RIONEGRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (908, 21, true, NULL, NULL, NULL, NULL, 'SABANA DE TORRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (909, 21, true, NULL, NULL, NULL, NULL, 'SAN ANDRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (910, 21, true, NULL, NULL, NULL, NULL, 'SAN BENITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (911, 21, true, NULL, NULL, NULL, NULL, 'SAN GIL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (912, 21, true, NULL, NULL, NULL, NULL, 'SAN JOAQUIN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (913, 21, true, NULL, NULL, NULL, NULL, 'SAN JOSE DE MIRANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (914, 21, true, NULL, NULL, NULL, NULL, 'SAN MIGUEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (915, 21, true, NULL, NULL, NULL, NULL, 'SAN VICENTE DE CHUCURI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (916, 21, true, NULL, NULL, NULL, NULL, 'SANTA BARBARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (917, 21, true, NULL, NULL, NULL, NULL, 'SANTA HELENA DEL OPON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (918, 21, true, NULL, NULL, NULL, NULL, 'SIMACOTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (919, 21, true, NULL, NULL, NULL, NULL, 'SOCORRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (920, 21, true, NULL, NULL, NULL, NULL, 'SUAITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (921, 21, true, NULL, NULL, NULL, NULL, 'SUCRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (922, 21, true, NULL, NULL, NULL, NULL, 'SURATA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (923, 21, true, NULL, NULL, NULL, NULL, 'TONA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (924, 21, true, NULL, NULL, NULL, NULL, 'VALLE DE SAN JOSE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (925, 21, true, NULL, NULL, NULL, NULL, 'VELEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (926, 21, true, NULL, NULL, NULL, NULL, 'VETAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (927, 21, true, NULL, NULL, NULL, NULL, 'VILLANUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (928, 21, true, NULL, NULL, NULL, NULL, 'ZAPATOCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (929, 22, true, NULL, NULL, NULL, NULL, 'SINCELEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (930, 22, true, NULL, NULL, NULL, NULL, 'BUENAVISTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (931, 22, true, NULL, NULL, NULL, NULL, 'CAIMITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (932, 22, true, NULL, NULL, NULL, NULL, 'COLOSO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (933, 22, true, NULL, NULL, NULL, NULL, 'COROZAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (934, 22, true, NULL, NULL, NULL, NULL, 'COVEÑAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (935, 22, true, NULL, NULL, NULL, NULL, 'CHALAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (936, 22, true, NULL, NULL, NULL, NULL, 'EL ROBLE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (937, 22, true, NULL, NULL, NULL, NULL, 'GALERAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (938, 22, true, NULL, NULL, NULL, NULL, 'GUARANDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (939, 22, true, NULL, NULL, NULL, NULL, 'LA UNION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (940, 22, true, NULL, NULL, NULL, NULL, 'LOS PALMITOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (941, 22, true, NULL, NULL, NULL, NULL, 'MAJAGUAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (942, 22, true, NULL, NULL, NULL, NULL, 'MORROA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (943, 22, true, NULL, NULL, NULL, NULL, 'OVEJAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (944, 22, true, NULL, NULL, NULL, NULL, 'PALMITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (945, 22, true, NULL, NULL, NULL, NULL, 'SAMPUES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (946, 22, true, NULL, NULL, NULL, NULL, 'SAN BENITO ABAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (947, 22, true, NULL, NULL, NULL, NULL, 'SAN JUAN DE BETULIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (948, 22, true, NULL, NULL, NULL, NULL, 'SAN MARCOS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (949, 22, true, NULL, NULL, NULL, NULL, 'SAN ONOFRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (950, 22, true, NULL, NULL, NULL, NULL, 'SAN PEDRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (951, 22, true, NULL, NULL, NULL, NULL, 'SAN LUIS DE SINCE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (952, 22, true, NULL, NULL, NULL, NULL, 'SUCRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (953, 22, true, NULL, NULL, NULL, NULL, 'SANTIAGO DE TOLU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (954, 22, true, NULL, NULL, NULL, NULL, 'TOLU VIEJO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (955, 23, true, NULL, NULL, NULL, NULL, 'IBAGUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (956, 23, true, NULL, NULL, NULL, NULL, 'ALPUJARRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (957, 23, true, NULL, NULL, NULL, NULL, 'ALVARADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (958, 23, true, NULL, NULL, NULL, NULL, 'AMBALEMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (959, 23, true, NULL, NULL, NULL, NULL, 'ANZOATEGUI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (960, 23, true, NULL, NULL, NULL, NULL, 'ARMERO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (961, 23, true, NULL, NULL, NULL, NULL, 'ATACO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (962, 23, true, NULL, NULL, NULL, NULL, 'CAJAMARCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (963, 23, true, NULL, NULL, NULL, NULL, 'CARMEN DE APICALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (964, 23, true, NULL, NULL, NULL, NULL, 'CASABIANCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (965, 23, true, NULL, NULL, NULL, NULL, 'CHAPARRAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (966, 23, true, NULL, NULL, NULL, NULL, 'COELLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (967, 23, true, NULL, NULL, NULL, NULL, 'COYAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (968, 23, true, NULL, NULL, NULL, NULL, 'CUNDAY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (969, 23, true, NULL, NULL, NULL, NULL, 'DOLORES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (970, 23, true, NULL, NULL, NULL, NULL, 'ESPINAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (971, 23, true, NULL, NULL, NULL, NULL, 'FALAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (972, 23, true, NULL, NULL, NULL, NULL, 'FLANDES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (973, 23, true, NULL, NULL, NULL, NULL, 'FRESNO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (974, 23, true, NULL, NULL, NULL, NULL, 'GUAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (975, 23, true, NULL, NULL, NULL, NULL, 'HERVEO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (976, 23, true, NULL, NULL, NULL, NULL, 'HONDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (977, 23, true, NULL, NULL, NULL, NULL, 'ICONONZO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (978, 23, true, NULL, NULL, NULL, NULL, 'LERIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (979, 23, true, NULL, NULL, NULL, NULL, 'LIBANO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (980, 23, true, NULL, NULL, NULL, NULL, 'MARIQUITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (981, 23, true, NULL, NULL, NULL, NULL, 'MELGAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (982, 23, true, NULL, NULL, NULL, NULL, 'MURILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (983, 23, true, NULL, NULL, NULL, NULL, 'NATAGAIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (984, 23, true, NULL, NULL, NULL, NULL, 'ORTEGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (985, 23, true, NULL, NULL, NULL, NULL, 'PALOCABILDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (986, 23, true, NULL, NULL, NULL, NULL, 'PIEDRAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (987, 23, true, NULL, NULL, NULL, NULL, 'PLANADAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (988, 23, true, NULL, NULL, NULL, NULL, 'PRADO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (989, 23, true, NULL, NULL, NULL, NULL, 'PURIFICACION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (990, 23, true, NULL, NULL, NULL, NULL, 'RIOBLANCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (991, 23, true, NULL, NULL, NULL, NULL, 'RONCESVALLES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (992, 23, true, NULL, NULL, NULL, NULL, 'ROVIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (993, 23, true, NULL, NULL, NULL, NULL, 'SALDAÑA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (994, 23, true, NULL, NULL, NULL, NULL, 'SAN ANTONIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (995, 23, true, NULL, NULL, NULL, NULL, 'SAN LUIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (996, 23, true, NULL, NULL, NULL, NULL, 'SANTA ISABEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (997, 23, true, NULL, NULL, NULL, NULL, 'SUAREZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (998, 23, true, NULL, NULL, NULL, NULL, 'VALLE DE SAN JUAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (999, 23, true, NULL, NULL, NULL, NULL, 'VENADILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1000, 23, true, NULL, NULL, NULL, NULL, 'VILLAHERMOSA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1001, 23, true, NULL, NULL, NULL, NULL, 'VILLARRICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1002, 24, true, NULL, NULL, NULL, NULL, 'CALI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1003, 24, true, NULL, NULL, NULL, NULL, 'ALCALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1004, 24, true, NULL, NULL, NULL, NULL, 'ANDALUCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1005, 24, true, NULL, NULL, NULL, NULL, 'ANSERMANUEVO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1006, 24, true, NULL, NULL, NULL, NULL, 'ARGELIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1007, 24, true, NULL, NULL, NULL, NULL, 'BOLIVAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1008, 24, true, NULL, NULL, NULL, NULL, 'BUENAVENTURA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1009, 24, true, NULL, NULL, NULL, NULL, 'GUADALAJARA DE BUGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1010, 24, true, NULL, NULL, NULL, NULL, 'BUGALAGRANDE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1011, 24, true, NULL, NULL, NULL, NULL, 'CAICEDONIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1012, 24, true, NULL, NULL, NULL, NULL, 'CALIMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1013, 24, true, NULL, NULL, NULL, NULL, 'CANDELARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1014, 24, true, NULL, NULL, NULL, NULL, 'CARTAGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1015, 24, true, NULL, NULL, NULL, NULL, 'DAGUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1016, 24, true, NULL, NULL, NULL, NULL, 'EL AGUILA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1017, 24, true, NULL, NULL, NULL, NULL, 'EL CAIRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1018, 24, true, NULL, NULL, NULL, NULL, 'EL CERRITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1019, 24, true, NULL, NULL, NULL, NULL, 'EL DOVIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1020, 24, true, NULL, NULL, NULL, NULL, 'FLORIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1021, 24, true, NULL, NULL, NULL, NULL, 'GINEBRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1022, 24, true, NULL, NULL, NULL, NULL, 'GUACARI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1023, 24, true, NULL, NULL, NULL, NULL, 'JAMUNDI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1024, 24, true, NULL, NULL, NULL, NULL, 'LA CUMBRE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1025, 24, true, NULL, NULL, NULL, NULL, 'LA UNION', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1026, 24, true, NULL, NULL, NULL, NULL, 'LA VICTORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1027, 24, true, NULL, NULL, NULL, NULL, 'OBANDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1028, 24, true, NULL, NULL, NULL, NULL, 'PALMIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1029, 24, true, NULL, NULL, NULL, NULL, 'PRADERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1030, 24, true, NULL, NULL, NULL, NULL, 'RESTREPO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1031, 24, true, NULL, NULL, NULL, NULL, 'RIOFRIO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1032, 24, true, NULL, NULL, NULL, NULL, 'ROLDANILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1033, 24, true, NULL, NULL, NULL, NULL, 'SAN PEDRO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1034, 24, true, NULL, NULL, NULL, NULL, 'SEVILLA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1035, 24, true, NULL, NULL, NULL, NULL, 'TORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1036, 24, true, NULL, NULL, NULL, NULL, 'TRUJILLO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1037, 24, true, NULL, NULL, NULL, NULL, 'TULUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1038, 24, true, NULL, NULL, NULL, NULL, 'ULLOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1039, 24, true, NULL, NULL, NULL, NULL, 'VERSALLES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1040, 24, true, NULL, NULL, NULL, NULL, 'VIJES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1041, 24, true, NULL, NULL, NULL, NULL, 'YOTOCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1042, 24, true, NULL, NULL, NULL, NULL, 'YUMBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1043, 24, true, NULL, NULL, NULL, NULL, 'ZARZAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1044, 25, true, NULL, NULL, NULL, NULL, 'ARAUCA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1045, 25, true, NULL, NULL, NULL, NULL, 'ARAUQUITA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1046, 25, true, NULL, NULL, NULL, NULL, 'CRAVO NORTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1047, 25, true, NULL, NULL, NULL, NULL, 'FORTUL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1048, 25, true, NULL, NULL, NULL, NULL, 'PUERTO RONDON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1049, 25, true, NULL, NULL, NULL, NULL, 'SARAVENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1050, 25, true, NULL, NULL, NULL, NULL, 'TAME', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1051, 26, true, NULL, NULL, NULL, NULL, 'YOPAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1052, 26, true, NULL, NULL, NULL, NULL, 'AGUAZUL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1053, 26, true, NULL, NULL, NULL, NULL, 'CHAMEZA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1054, 26, true, NULL, NULL, NULL, NULL, 'HATO COROZAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1055, 26, true, NULL, NULL, NULL, NULL, 'LA SALINA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1056, 26, true, NULL, NULL, NULL, NULL, 'MANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1057, 26, true, NULL, NULL, NULL, NULL, 'MONTERREY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1058, 26, true, NULL, NULL, NULL, NULL, 'NUNCHIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1059, 26, true, NULL, NULL, NULL, NULL, 'OROCUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1060, 26, true, NULL, NULL, NULL, NULL, 'PAZ DE ARIPORO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1061, 26, true, NULL, NULL, NULL, NULL, 'PORE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1062, 26, true, NULL, NULL, NULL, NULL, 'RECETOR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1063, 26, true, NULL, NULL, NULL, NULL, 'SABANALARGA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1064, 26, true, NULL, NULL, NULL, NULL, 'SACAMA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1065, 26, true, NULL, NULL, NULL, NULL, 'SAN LUIS DE PALENQUE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1066, 26, true, NULL, NULL, NULL, NULL, 'TAMARA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1067, 26, true, NULL, NULL, NULL, NULL, 'TAURAMENA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1068, 26, true, NULL, NULL, NULL, NULL, 'TRINIDAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1069, 26, true, NULL, NULL, NULL, NULL, 'VILLANUEVA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1070, 27, true, NULL, NULL, NULL, NULL, 'MOCOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1071, 27, true, NULL, NULL, NULL, NULL, 'COLON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1072, 27, true, NULL, NULL, NULL, NULL, 'ORITO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1073, 27, true, NULL, NULL, NULL, NULL, 'PUERTO ASIS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1074, 27, true, NULL, NULL, NULL, NULL, 'PUERTO CAICEDO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1075, 27, true, NULL, NULL, NULL, NULL, 'PUERTO GUZMAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1076, 27, true, NULL, NULL, NULL, NULL, 'LEGUIZAMO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1077, 27, true, NULL, NULL, NULL, NULL, 'SIBUNDOY', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1078, 27, true, NULL, NULL, NULL, NULL, 'SAN FRANCISCO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1079, 27, true, NULL, NULL, NULL, NULL, 'SAN MIGUEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1080, 27, true, NULL, NULL, NULL, NULL, 'SANTIAGO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1081, 27, true, NULL, NULL, NULL, NULL, 'VALLE DEL GUAMUEZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1082, 27, true, NULL, NULL, NULL, NULL, 'VILLAGARZON', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1083, 28, true, NULL, NULL, NULL, NULL, 'SAN ANDRES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1084, 28, true, NULL, NULL, NULL, NULL, 'PROVIDENCIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1085, 29, true, NULL, NULL, NULL, NULL, 'LETICIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1086, 29, true, NULL, NULL, NULL, NULL, 'EL ENCANTO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1087, 29, true, NULL, NULL, NULL, NULL, 'LA CHORRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1088, 29, true, NULL, NULL, NULL, NULL, 'LA PEDRERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1089, 29, true, NULL, NULL, NULL, NULL, 'LA VICTORIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1090, 29, true, NULL, NULL, NULL, NULL, 'MIRITI - PARANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1091, 29, true, NULL, NULL, NULL, NULL, 'PUERTO ALEGRIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1092, 29, true, NULL, NULL, NULL, NULL, 'PUERTO ARICA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1093, 29, true, NULL, NULL, NULL, NULL, 'PUERTO NARIÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1094, 29, true, NULL, NULL, NULL, NULL, 'PUERTO SANTANDER', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1095, 29, true, NULL, NULL, NULL, NULL, 'TARAPACA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1096, 30, true, NULL, NULL, NULL, NULL, 'INIRIDA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1097, 30, true, NULL, NULL, NULL, NULL, 'BARRANCO MINAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1098, 30, true, NULL, NULL, NULL, NULL, 'MAPIRIPANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1099, 30, true, NULL, NULL, NULL, NULL, 'SAN FELIPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1100, 30, true, NULL, NULL, NULL, NULL, 'PUERTO COLOMBIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1101, 30, true, NULL, NULL, NULL, NULL, 'LA GUADALUPE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1102, 30, true, NULL, NULL, NULL, NULL, 'CACAHUAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1103, 30, true, NULL, NULL, NULL, NULL, 'PANA PANA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1104, 30, true, NULL, NULL, NULL, NULL, 'MORICHAL', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1105, 31, true, NULL, NULL, NULL, NULL, 'SAN JOSE DEL GUAVIARE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1106, 31, true, NULL, NULL, NULL, NULL, 'CALAMAR', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1107, 31, true, NULL, NULL, NULL, NULL, 'EL RETORNO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1108, 31, true, NULL, NULL, NULL, NULL, 'MIRAFLORES', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1109, 32, true, NULL, NULL, NULL, NULL, 'MITU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1110, 32, true, NULL, NULL, NULL, NULL, 'CARURU', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1111, 32, true, NULL, NULL, NULL, NULL, 'PACOA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1112, 32, true, NULL, NULL, NULL, NULL, 'TARAIRA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1113, 32, true, NULL, NULL, NULL, NULL, 'PAPUNAUA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1114, 32, true, NULL, NULL, NULL, NULL, 'YAVARATE', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1115, 33, true, NULL, NULL, NULL, NULL, 'PUERTO CARREÑO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1116, 33, true, NULL, NULL, NULL, NULL, 'LA PRIMAVERA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1117, 33, true, NULL, NULL, NULL, NULL, 'SANTA ROSALIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1118, 33, true, NULL, NULL, NULL, NULL, 'CUMARIBO', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (148, 3, true, true, true, NULL, NULL, 'BOGOTA, D.C.', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_municipios VALUES (1119, 1, true, false, true, 1, NULL, 'MEDELLIN', 'MED', NULL, NULL, NULL, NULL, NULL, NULL);


INSERT INTO xcm_grupos_permisos VALUES (1, 0, '000000000', '2008-09-24 08:40:40.471', 'dbxdba');
INSERT INTO xcm_grupos_permisos VALUES (2, 0, '000000009', '2008-09-24 08:40:40.471', 'dbxdba');
INSERT INTO xcm_grupos_permisos VALUES (3, 0, '000000006', '2008-09-24 08:40:40.471', 'dbxdba');
INSERT INTO xcm_grupos_permisos VALUES (4, 0, '000000001', '2008-09-24 08:40:40.471', 'dbxdba');
INSERT INTO xcm_grupos_permisos VALUES (5, 0, '000000002', '2008-09-24 08:40:40.471', 'dbxdba');
INSERT INTO xcm_grupos_permisos VALUES (6, 0, '000000003', '2008-09-24 08:40:40.471', 'dbxdba');
INSERT INTO xcm_grupos_permisos VALUES (8, 0, '000000', '2008-09-24 08:40:40.471', 'dbxdba');


INSERT INTO xcm_permisos VALUES ('000', NULL, 'Sistemas AXYS-DBX', NULL, 1, true, NULL);
INSERT INTO xcm_permisos VALUES ('000000', '000', 'Sistema de Seguridad', NULL, 2, true, NULL);
INSERT INTO xcm_permisos VALUES ('000000000', '000000', 'Acceso al Sistema de Seguridad', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000000001', '000000', 'Creación de N.U.I.P.s', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000000002', '000000', 'Creación de Usuarios', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000000003', '000000', 'Modificar Permisos de Usuarios', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000000004', '000000', 'Creación de Grupos', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000000005', '000000', 'Modificación de Permisos de Grupo', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000000006', '000000', 'Cambio de Contraseña', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000000007', '000000', 'Asignar Usuarios a Grupos', 'Permite asignar Usuarios creados en el sistema a uno o varios Grupos Empresariales', 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000000009', '000000', 'Asignar Permisos a Usuarios', 'Permite asignar Permisos creados en el sistema a cada uno de los Usuarios', 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000000010', '000000', 'Asignar Permisos a Grupos', 'Permite asignar Permisos creados en el sistema a uno de los Grupos Empresariales', 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000011000', '000011', 'Acceso al Modulo de Pedidos', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000011001', '000011', 'Creación de Proyectos (Obras)', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000011002', '000011', 'Creación de Proveedores', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000010', '000', 'Sistema Administrador de Archivos', NULL, 2, true, NULL);
INSERT INTO xcm_permisos VALUES ('000011004', '000011', 'Ingreso de Precio por Proveedor', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000010000', '000010', 'Acceso al Sistema Administrador de Archivos', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000011003', '000011', 'Creación de Productos, Categorías y Subcategorias', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000010001', '000010', 'Navegar en los Directorios', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000011', '000', 'Sistema Administrador de Obras (Proyectos)', 'Pedidos (Productos, Insumos, Servicios) Entradas y Salidas', 2, true, NULL);
INSERT INTO xcm_permisos VALUES ('000011005', '000011', 'Aprobación de Pedido', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000011006', '000011', 'Entrega de Recursos', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000011007', '000011', 'Orden de Compra', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000011008', '000011', 'Ingreso de Recursos', NULL, 3, false, NULL);
INSERT INTO xcm_permisos VALUES ('000011009', '000011', 'Consulta de Inventario Inicial', NULL, 3, false, NULL);

INSERT INTO xcm_usuarios VALUES ('dbxdba', '358b45870d2c2e8b8bccb5b8eca6dbc6', 0, 0, '2009-01-01 00:00:00', true, 0, 0);
INSERT INTO xcm_usuarios VALUES ('admin', '827ccb0eea8a706c4c34a16891f84e7b', 1, 0, '2009-01-01 00:00:00', true, 0, 0);

INSERT INTO xcm_usuarios_grupos VALUES (1, 'dbxdba', 0);
INSERT INTO xcm_usuarios_grupos VALUES (23, 'admin', 2);
INSERT INTO xcm_usuarios_grupos VALUES (24, 'dbxdba', 2);
INSERT INTO xcm_usuarios_permisos VALUES (32, 'admin', '000000', '2011-01-21 23:09:02.434028', 'dbxdba');
INSERT INTO xcm_usuarios_permisos VALUES (33, 'admin', '000000001', '2011-01-21 23:09:02.434028', 'dbxdba');
INSERT INTO xcm_usuarios_permisos VALUES (34, 'admin', '000010', '2011-01-21 23:09:02.434028', 'dbxdba');
INSERT INTO xcm_usuarios_permisos VALUES (35, 'admin', '000010000', '2011-01-21 23:09:02.434028', 'dbxdba');
INSERT INTO xcm_usuarios_permisos VALUES (36, 'admin', '000010001', '2011-01-21 23:09:02.434028', 'dbxdba');
INSERT INTO xcm_usuarios_permisos VALUES (37, 'admin', '000011', '2011-01-21 23:09:02.434028', 'dbxdba');
INSERT INTO xcm_usuarios_permisos VALUES (38, 'admin', '000011000', '2011-01-21 23:09:02.434028', 'dbxdba');
INSERT INTO xcm_usuarios_permisos VALUES (39, 'admin', '000011001', '2011-01-21 23:09:02.434028', 'dbxdba');
INSERT INTO xcm_usuarios_permisos VALUES (40, 'admin', '000011002', '2011-01-21 23:09:02.434028', 'dbxdba');
INSERT INTO xcm_usuarios_permisos VALUES (41, 'admin', '000011003', '2011-01-21 23:09:02.434028', 'dbxdba');
INSERT INTO xcm_usuarios_permisos VALUES (42, 'admin', '000011004', '2011-01-21 23:09:02.434028', 'dbxdba');
INSERT INTO xcm_usuarios_permisos VALUES (44, 'admin', '000011006', '2011-01-21 23:09:02.434028', 'dbxdba');

ALTER TABLE ONLY xcm_grupos
    ADD CONSTRAINT ak_cunom_grupo_xcm_grup UNIQUE (nom_grupo);

ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT ak_login_permiso_xcm_usua UNIQUE (login, id_permiso);

ALTER TABLE ONLY xcm_niveles_usuario
    ADD CONSTRAINT ak_nivel_xcm_nive UNIQUE (nom_nivel_usuario);

ALTER TABLE ONLY xcm_permisos
    ADD CONSTRAINT ak_nom_permiso_xcm_perm UNIQUE (nom_permiso);

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT ak_nuip_dig_verifica__xcm_nuip UNIQUE (id_nuip, digito_verif);

ALTER TABLE ONLY xcm_documentos
    ADD CONSTRAINT cu_documento UNIQUE (nom_schema, nom_tabla, nom_campo, id_grupo);

ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT cu_id_permiso_id_grupo UNIQUE (id_grupo, id_permiso);

ALTER TABLE ONLY xcm_documentos
    ADD CONSTRAINT pk_documentos PRIMARY KEY (id_doc);

ALTER TABLE ONLY xcm_campos_db
    ADD CONSTRAINT pk_xcm_campos_db PRIMARY KEY (nom_esquema, nom_tabla, nom_columna);

ALTER TABLE ONLY xcm_db_departamentos
    ADD CONSTRAINT pk_xcm_db_departamentos PRIMARY KEY (id_depto);

ALTER TABLE ONLY xcm_db_municipios
    ADD CONSTRAINT pk_xcm_db_municipios PRIMARY KEY (id_municipio);

ALTER TABLE ONLY xcm_db_paises
    ADD CONSTRAINT pk_xcm_db_paises PRIMARY KEY (id_pais);

ALTER TABLE ONLY xcm_db_sexos
    ADD CONSTRAINT pk_xcm_db_sexos PRIMARY KEY (id_sexo);

ALTER TABLE ONLY xcm_db_tipos_nuips
    ADD CONSTRAINT pk_xcm_db_tipos_nuips PRIMARY KEY (id_tipo_nuip);

ALTER TABLE ONLY xcm_db_tipos_tel
    ADD CONSTRAINT pk_xcm_db_tipos_tel PRIMARY KEY (id_tipo_tel);

ALTER TABLE ONLY xcm_db_titulos_nuips
    ADD CONSTRAINT pk_xcm_db_titulos_nuips PRIMARY KEY (id_titulo_nuip);

ALTER TABLE ONLY xcm_grupos
    ADD CONSTRAINT pk_xcm_grupos PRIMARY KEY (id_grupo);

ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT pk_xcm_grupos_permisos PRIMARY KEY (id_grupo_permiso);

ALTER TABLE ONLY xcm_niveles_usuario
    ADD CONSTRAINT pk_xcm_niveles_usuario PRIMARY KEY (id_nivel_usuario);

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT pk_xcm_nuips PRIMARY KEY (id_nuip_serial);

ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT pk_xcm_nuips_dirs PRIMARY KEY (id_nuip_dir);

ALTER TABLE ONLY xcm_nuips_emails
    ADD CONSTRAINT pk_xcm_nuips_emails PRIMARY KEY (id_nuip_email);

ALTER TABLE ONLY xcm_nuips_grupos
    ADD CONSTRAINT pk_xcm_nuips_grupos PRIMARY KEY (id_nuip_grupo);

ALTER TABLE ONLY xcm_nuips_tels
    ADD CONSTRAINT pk_xcm_nuips_tels PRIMARY KEY (id_nuip_tel);

ALTER TABLE ONLY xcm_permisos
    ADD CONSTRAINT pk_xcm_permisos PRIMARY KEY (id_permiso);

ALTER TABLE ONLY xcm_db_tipos_dir
    ADD CONSTRAINT pk_xcm_tipos_dir PRIMARY KEY (id_tipo_dir);

ALTER TABLE ONLY xcm_usuarios
    ADD CONSTRAINT pk_xcm_usuarios PRIMARY KEY (login);

ALTER TABLE ONLY xcm_usuarios_grupos
    ADD CONSTRAINT pk_xcm_usuarios_grupos PRIMARY KEY (id_usuario_grupo);

ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT pk_xcm_usuarios_permisos PRIMARY KEY (id_usuario_permiso);

CREATE UNIQUE INDEX cu_login ON xcm_usuarios USING btree (login);

CREATE INDEX idx_nom_pais_es ON xcm_db_paises USING btree (nom_pais_es);

CREATE INDEX idx_nombres_apellidos ON xcm_nuips USING btree (nom_nuip, ape_nuip);

CREATE INDEX idx_nuips_grupos_id_grupo ON xcm_nuips_grupos USING btree (id_nuip_serial, id_grupo);

CREATE INDEX ix_rpais ON xcm_db_departamentos USING btree (id_pais);

ALTER TABLE ONLY xcm_documentos
    ADD CONSTRAINT "FK_id_grupo" FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE;

ALTER TABLE ONLY xcm_nuips_grupos
    ADD CONSTRAINT fk___nuips_gru_nuips FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_db_departamentos
    ADD CONSTRAINT fk__db_deptos_db_paises FOREIGN KEY (id_pais) REFERENCES xcm_db_paises(id_pais) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_db_municipios
    ADD CONSTRAINT fk__db_munici_db_depar FOREIGN KEY (id_depto) REFERENCES xcm_db_departamentos(id_depto) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_permisos
    ADD CONSTRAINT fk__id_permiso_id_padre FOREIGN KEY (id_padre) REFERENCES xcm_permisos(id_permiso) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_nuips_grupos
    ADD CONSTRAINT fk__nuips_nuips_grupos FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT fk__permisos_grupos_grupos FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_usuarios_grupos
    ADD CONSTRAINT fk__usuarios_grupos__usuarios FOREIGN KEY (login) REFERENCES xcm_usuarios(login) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_usuarios
    ADD CONSTRAINT fk__usuarios_niveles_usuario FOREIGN KEY (id_nivel_usuario) REFERENCES xcm_niveles_usuario(id_nivel_usuario) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_usuarios
    ADD CONSTRAINT fk__usuarios_nuips FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_usuarios_grupos
    ADD CONSTRAINT fk__usuarios_usuarios__grupos FOREIGN KEY (id_grupo) REFERENCES xcm_grupos(id_grupo) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT fk_db_sexos_1 FOREIGN KEY (id_sexo) REFERENCES xcm_db_sexos(id_sexo) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT fk_db_tipos_nuip_1 FOREIGN KEY (id_tipo_nuip) REFERENCES xcm_db_tipos_nuips(id_tipo_nuip) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_nuips
    ADD CONSTRAINT fk_titulos_nuip_1 FOREIGN KEY (id_titulo_nuip) REFERENCES xcm_db_titulos_nuips(id_titulo_nuip) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT fk_usuarios__permisos_permiso FOREIGN KEY (id_permiso) REFERENCES xcm_permisos(id_permiso) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_usuarios_permisos
    ADD CONSTRAINT fk_usuarios_permisos__usuarios FOREIGN KEY (login) REFERENCES xcm_usuarios(login) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_grupos
    ADD CONSTRAINT fk_xcm_grup_grupos_nu_xcm_nuip FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_grupos_permisos
    ADD CONSTRAINT fk_xcm_grup_gruposper_xcm_perm FOREIGN KEY (id_permiso) REFERENCES xcm_permisos(id_permiso) ON UPDATE RESTRICT ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_nuips_emails
    ADD CONSTRAINT fk_xcm_nuip_email_nuip_tipos FOREIGN KEY (id_tipo_dir) REFERENCES xcm_db_tipos_dir(id_tipo_dir) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT fk_xcm_nuip_nuipsdirs_xcm_nuip FOREIGN KEY (id_tipo_dir) REFERENCES xcm_db_tipos_dir(id_tipo_dir) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_nuips_tels
    ADD CONSTRAINT fk_xcm_nuip_nuipstels_xcm_db_t FOREIGN KEY (id_tipo_tel) REFERENCES xcm_db_tipos_tel(id_tipo_tel) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT fk_xcm_nuips_dirs FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_nuips_emails
    ADD CONSTRAINT fk_xcm_nuips_emails_nuip FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_nuips_tels
    ADD CONSTRAINT fk_xcm_nuips_tels_nuip FOREIGN KEY (id_nuip_serial) REFERENCES xcm_nuips(id_nuip_serial) ON UPDATE CASCADE ON DELETE RESTRICT;

ALTER TABLE ONLY xcm_nuips_dirs
    ADD CONSTRAINT xcm_nuips_dirs_id_municipio_fkey FOREIGN KEY (id_municipio) REFERENCES xcm_db_municipios(id_municipio) ON UPDATE CASCADE;
