--===================================
-- Inserción de registros nuevos en Tablas
-- Ej.: 
-- * Permisos nuevos
-- * Datos básicos
--===================================

--===================================
-- Datos del Cliente (Grupo Corporativo)
--===================================
INSERT INTO xcm_nuips VALUES (1, 999999999, 9, 7, 'NOMBRE DEL CLIENTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'dbxdba');
INSERT INTO xcm_grupos VALUES (1, 0, 'SIGLA (Nombre del Grupo)', 'NOMBRE DEL CLIENTE');


--===================================
-- Datos de Digital Business DBX Ltda.
--===================================
INSERT INTO xcm_nuips (id_nuip_serial, id_nuip, digito_verif, id_tipo_nuip, nom_nuip, ape_nuip, nom_contacto, notas, fec_nacimiento, nom_empresa, id_sexo, id_titulo_nuip, login_tx, fec_tx, id_cls_nuip) VALUES (0, 900084341, 1, 7, 'Digital Business DBX Ltda.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'dbxdba', NULL, 2);
INSERT INTO xcm_grupos VALUES (0, 0, 'DBX', 'Digital Business DBX Ltda.');




--===================================
-- Clases de NUIPS
--===================================
INSERT INTO xcm_db_clases_nuips (id_cls_nuip, orden_db, nom_cls_nuip_es, abr_cls_nuip_es, nom_cls_nuip_en, abr_cls_nuip_en, nom_cls_nuip_de, abr_cls_nuip_de, nom_cls_nuip_fr, abr_cls_nuip_fr, is_activo, cod_interno) VALUES (1, 0, 'Persona Natural', 'Persona', '', '', '', '', '', '', true, '');
INSERT INTO xcm_db_clases_nuips (id_cls_nuip, orden_db, nom_cls_nuip_es, abr_cls_nuip_es, nom_cls_nuip_en, abr_cls_nuip_en, nom_cls_nuip_de, abr_cls_nuip_de, nom_cls_nuip_fr, abr_cls_nuip_fr, is_activo, cod_interno) VALUES (2, 1, 'Empresa', 'Empresa', '', '', '', '', '', '', true, '');


--===================================
-- Perfiles
--===================================
INSERT INTO xcm_perfiles (id_perfil, nom_perfil, orden_db) VALUES (1, 'Proveedores', 1);
INSERT INTO xcm_perfiles (id_perfil, nom_perfil, orden_db) VALUES (2, 'Clientes', 1);
INSERT INTO xcm_perfiles (id_perfil, nom_perfil, orden_db) VALUES (3, 'Vendedores', 1);
SELECT pg_catalog.setval('xcm_perfiles_id_perfil_seq', 3, true);



--===================================
-- Niveles de Usuarios
--===================================
INSERT INTO xcm_niveles_usuario VALUES (0, 'Usuario DBX');
INSERT INTO xcm_niveles_usuario VALUES (1, 'Usuario Propietario');
INSERT INTO xcm_niveles_usuario VALUES (2, 'Usuario Cliente');

--===================================
-- Sexos
--===================================
INSERT INTO xcm_db_sexos VALUES (1, 1, 'Masculino', 'M', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_sexos VALUES (2, 2, 'Femenino', 'F', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

--===================================
-- Tipos de Direcciones
--===================================
INSERT INTO xcm_db_tipos_dir VALUES (1, 1, 'Personal', 'P', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_dir VALUES (2, 2, 'Oficina', 'O', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);

--===================================
-- Tipos de Documentos de Identidad
--===================================
INSERT INTO xcm_db_tipos_nuips VALUES (1, 1, 'Cédula de Ciudadania', 'C.C.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_nuips VALUES (2, 2, 'Tarjeta de Identidad', 'T.I.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_nuips VALUES (3, 3, 'Pasaporte', 'Pas.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_nuips VALUES (4, 4, 'Cédula de Extranjeria', 'C.E.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_nuips VALUES (5, 5, 'Registro Civil', 'R.C.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_nuips VALUES (6, 6, 'Libreta Militar', 'L.M.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_tipos_nuips VALUES (7, 7, 'NIT', 'Nit.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);

--===================================
-- Tipos de Telefonos
--===================================
INSERT INTO xcm_db_tipos_tel VALUES (1, 1, 'Personal', 'Per', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_tipos_tel VALUES (2, 2, 'Trabajo', 'Tra', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_tipos_tel VALUES (3, 3, 'Celular', 'Cel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_tipos_tel VALUES (4, 4, 'Fax', 'Fax', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO xcm_db_tipos_tel VALUES (5, 5, 'Avantel', 'Avt', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

--===================================
-- Tipos de Titulos de Personas
--===================================
INSERT INTO xcm_db_titulos_nuips VALUES (1, 1, 'Señor', 'Sr.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_titulos_nuips VALUES (2, 2, 'Señorita', 'Srta.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_titulos_nuips VALUES (3, 3, 'Señora', 'Sra.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_titulos_nuips VALUES (4, 4, 'Ingeniero', 'Ing.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
INSERT INTO xcm_db_titulos_nuips VALUES (5, 5, 'Doctor', 'Dr.', NULL, NULL, NULL, NULL, NULL, NULL, true, NULL);
