<?php
/* START OF CONFIG */
  // Enable Compression? true or false (case-sensetive)
  define('GZIP_ENABLE_COMPRESSION','true');

  // Compression Level (1 ~ 9)
  define('GZIP_COMPRESSION_LEVEL','9');

  // Enable Logging? true or false (case-sensetive)
  define('GZIP_ENABLE_LOGGING','true');

  // Logging File
  define('GZIP_LOGGING_FILE','gzip_log.txt');

/* END OF CONFIG */

  function check_gzip() {

    global $HTTP_ACCEPT_ENCODING;

    if (headers_sent() || connection_aborted()) return false;

    if (strpos($HTTP_ACCEPT_ENCODING, 'x-gzip') !== false) return 'x-gzip';

    if (strpos($HTTP_ACCEPT_ENCODING,'gzip') !== false) return 'gzip';

    return false;
  }

  function gzip_buffer($buffer){

    $before = strlen($buffer);

    if ($before > 0 && $encoding = check_gzip()) {

      header('Content-Encoding: ' . $encoding);

      $size = strlen($buffer);
      $crc = crc32($buffer);

      $buffer = gzcompress($buffer, GZIP_COMPRESSION_LEVEL);
      $buffer = substr($buffer, 0, strlen($buffer) - 4);

      $buffer = "\x1f\x8b\x08\x00\x00\x00\x00\x00".
                $buffer.pack('V', $crc).pack('V', $size);

      if( GZIP_ENABLE_LOGGING == 'true'
          && ($fp = @fopen(GZIP_LOGGING_FILE,'a'))
        ) {
        $after = strlen($buffer);
        @fwrite($fp, $_SERVER['PHP_SELF']." : ".
                     number_format($before/1024,2)."KB  => ".
                     number_format($after/1024,2)."KB  = ".
                     number_format(($before-$after)/1024,2)."KB  = ".
                     number_format(100-(($after*100)/$before),2)."%\r\n"
               );
        @fflush($fp);
        @fclose($fp);
      }

    }

    return $buffer;
  }

  $start_gzip = (GZIP_ENABLE_COMPRESSION == 'true'
                  && extension_loaded('zlib') && (PHP_VERSION >= '4')
                ) ? TRUE : FALSE;

  if($start_gzip) ob_start('gzip_buffer');

?>
