<?php

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Declaracion de la clase BD
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class BD {
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function BD()
	{
		global $cnf;

		$this->dbname	= $cnf["dbname"];	// Nombre de la base de datos
		$this->host 	= $cnf["dbhost"];	// Nombre del Host
		$this->port 	= $cnf["dbport"];	// Nombre del puerto

		if ($cnf["usuarios_db"])
		{
			$this->user 	= $_SESSION["login"];	// Nombre del Usuario que accede
			$this->pass 	= $_SESSION["passwd"];	// Contraseña
		}
		else
		{
			$this->user 	= $cnf["dbuser"];	// Nombre del Usuario del config.inc.php
			$this->pass 	= $cnf["dbpass"];	// Contraseña
		}

		$this->dbase 	  = false;			   // Objeto base
		$this->error	  = -1;              // numero del Ultimo Error generado
		$this->error_msg = "";              // Cadena String de error
		$this->error_int = -1;              // numero del Ultimo Error generado por el motor DB
		$this->status 	  = "";
		$this->status_msg = "";
		$this->result    = false;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function conectar($cadena="")
	{
		global $cnf;
		switch ($cnf["db"])
		{
			case "postgres":
				if($cadena == "" )
				{
					if ($this->port == "" and $this->host=="")
						$cadena = "dbname=".$this->dbname." user=".$this->user." password=".$this->pass;
					else
						$cadena = "dbname=".$this->dbname." port=".$this->port." host=".$this->host." user=".$this->user." password=".$this->pass;
        		}
				$this->dbase = @pg_connect($cadena);
				@pg_set_client_encoding($this->dbase, $cnf['html_charset']);
			break;
			case "mysql":
				$this->dbase = @mysql_connect($this->host.":".$this->port, $this->user, $this->pass);
				if($this->dbase)
					@mysql_select_db($this->dbname);
			break;
		}

//		echo $cadena;
		$this->status_con();
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function status_con()
	{
		global $cnf;
		global $m_;

		switch ($cnf["db"])
		{
			case "":
				// Colocar codigo para el uso de AXYS sin conexion a la Base de Datos.
			break;
			case "postgres":

				$this->status    = @pg_connection_status($this->dbase);
				$this->error     = $this->status;
     			$this->error_msg = @pg_last_error($this->dbase);

				if($this->dbase)
		   	{
					$this->status    = @pg_connection_status($this->dbase);
					$this->error     = $this->status;
	     			$this->error_msg = @pg_last_error($this->dbase);
			 		return $this->error;
				}
				else
				{
					$this->status    = @pg_connection_status($this->dbase);
					$this->error     = $this->status;
					$this->error     = 1;
		     		$this->error_msg = $m_['err_conectar_db']." - ".@pg_last_error($this->dbase);
				}
			break;
			case "mysql":
   	  		$this->error     = @mysql_errno($this->dbase);
     			$this->error_msg = @mysql_error($this->dbase);
		     	if(!$this->dbase)
		     	{
		     		$this->error     = @mysql_errno($this->dbase);
		     		$this->error_msg = @mysql_error($this->dbase);
				}
				else
				{
		     		//$this->error     = 1;
		     		$this->error_msg = "";
		 			return $this->error;
				}
		break;
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function status($result=-2)
	{
		global $cnf;
		//if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

		//if($result == -2)
		//{
		//	$result = $this->result;
		//}
		switch ($cnf["db"])
		{
			case 'postgres':
		  		if($result != false) // Se compara de esta forma para asegurar el estado booleano FALSE, cualquier otro valor podria resultar como VERDADERO
		  		{
					$this->status = @pg_result_status($this->dbase);
					$this->error  = $this->status;
				}
				else
				{
				 	$this->status = 7;
					$this->error  = 7;
				}
				$this->status_msg = @pg_last_notice($this->dbase);
			  	$this->error_msg = @pg_last_error($this->dbase);
			break;
			case 'mysql':
		  		if($result != false) // Se compara de esta forma para asegurar el estado booleano FALSE, cualquier otro valor podria resultar como VERDADERO
				{
		      	$this->error     = mysql_errno($this->dbase);
		     		$this->error_msg = mysql_error();
				}
				else
				{
				 	$this->status = 7;
					$this->error  = 7;
		     		$this->error_msg = mysql_error();
				}
				//echo "<script>alert(\"DB_FX --- ".$this->error_msg." --- ".$cnf["db"]."\")</script>";
			break;
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function close()
	{
		if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

		switch ($cnf["db"])
		{
		case 'postgres':
			@pg_close($this->dbase);
		break;
		case 'mysql':
			@mysql_close($this->dbase);
		break;
		}
	}

	function free_result($result)
 	{
		if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

      if($result != false)
		{
			switch ($cnf["db"])
			{
			case 'postgres':
				@pg_free_result($result);
			break;
			case 'mysql':
				@mysql_free_result($result);
			break;
			}
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function query($ssql)
	{
		if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

		switch ($cnf["db"])
		{
			case 'postgres':
				$result = @pg_query($this->dbase, $ssql);
				$this->status($result);
				return $result;
			break;
			case 'mysql':
				$result = @mysql_query($ssql, $this->dbase);
				$this->status($result);
				return $result;
			break;
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function fetch_array($resultado = -2)
	{
		if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

		if($resultado == -2)
		{
		   $resultado = $this->result;
		}
		switch ($cnf["db"])
		{
		case 'postgres':
			return @pg_fetch_array($resultado, NULL, PGSQL_BOTH);
		break;
		case 'mysql':
			return @mysql_fetch_array($resultado, mysql_BOTH);
		break;
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function fetch_assoc($resultado = -2)
	{
		if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

		if($resultado == -2)
		{
		   $resultado = $this->result;
		}
		switch ($cnf["db"])
		{
		case 'postgres':
			return @pg_fetch_assoc($resultado);
		break;
		case 'mysql':
			return @mysql_fetch_assoc($resultado);
		break;
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function fetch_row($resultado=-2, $fila = 0)
	{
		global $cnf;
		//if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

		//if($resultado == -2)
		//{
		//   $resultado = $this->result;
		//}
		switch ($cnf["db"])
		{
			case 'postgres':
				return @pg_fetch_row($resultado, $fila);
			break;
			case 'mysql':
				return @mysql_fetch_row($resultado);
			break;
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function result_seek($resultado = -2, $fila = 0)
	{
		global $cnf;
		//if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

		//if($resultado == -2)
		//{
		//   $resultado = $this->result;
		//}
		switch ($cnf["db"])
		{
			case 'postgres':
				return @pg_result_seek($resultado, $fila);
			break;
			case 'mysql':
				return @mysql_data_seek($resultado, $fila);
			break;
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function num_rows($resultado = -2)
	{
		global $cnf;
		//if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

		if($resultado == -2)
		{
		   $resultado = $this->result;
		}
		switch ($cnf["db"])
		{
		case 'postgres':
			return @pg_num_rows($resultado);
		break;
		case 'mysql':
			return @mysql_num_rows($resultado);
		break;
	    }
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function num_fields($resultado = -2)
	{
		global $cnf;
		//if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

		if($resultado == -2)
		{
		  $resultado = $this->result;
		}
		switch ($cnf["db"])
		{
			case 'postgres':
				return @pg_num_fields($resultado);
		 	break;
		 	case 'mysql':
				return @mysql_num_fields($resultado);
		 	break;
	  }
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function field_name($resultado = -2, $col="")
	{
		global $cnf;
		//if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

		if($resultado == -2)
		{
		   $resultado = $this->result;
		}
		switch ($cnf["db"])
		{
		 case 'postgres':
			return @pg_field_name($resultado, $col);
		 break;
		 case 'mysql':
			return @mysql_field_name($resultado, $col);
		 break;
	   }
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function field_table($resultado = -2, $col="")
	{
		global $cnf;
		//if (!isset($cnf)) $cnf = $_SESSION["cnf"]; else {global $cnf;}

		if($resultado == -2)
		{
		   $resultado = $this->result;
		}
		switch ($cnf["db"])
		{
		 case 'postgres':
			return "";
			//return @pg_field_name($resultado, $col);
		 break;
		 case 'mysql':
			return @mysql_field_table($resultado, $col);
		 break;
	   }
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function field_type($resultado = -2, $col="")
	{
		global $cnf;

		if($resultado == -2)
		{
		   $resultado = $this->result;
		}
		switch ($cnf["db"])
		{
			case 'postgres':
				return @pg_field_type($resultado, $col);
			break;
			case 'mysql':
				return @mysql_field_type($resultado, $col);
			break;
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function affected_rows($resultado=-2)
	{
		global $cnf;

		if($resultado == -2)
		{
		   $resultado = $this->result;
		}
		switch ($cnf["db"])
		{
			case 'postgres':
				return @pg_affected_rows($resultado);
			break;
			case 'mysql':
				return @mysql_affected_rows($resultado);
			break;
		}
	}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
} // End -- class BD

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

global $db;
$db = new BD;

////////////////////////////////////////////////////////////
//=========================================================
// FUNCIONES PARA MANEJAR LA DB con o sin Scripts Remotos
//=========================================================
////////////////////////////////////////////////////////////


//===============================
// Function Conectar_DB
//===============================
function conectar_db($cadena="", $remoto=false)
{
	global $cnf;
	global $m_;
	global $db;
	if ($db->user == "")
	{
		$db->user = $cnf["dbuser"];
		$db->pass = $cnf["dbpass"];
	}
	if($cadena == "")
		$db->conectar();
	else
   {
		$db->conectar($cadena);
   }

	if ($db->dbase)
		return "1"; // 1 = Si se conecto
	else
	{
		if($remoto=="true")
		   return $db->error_msg;
		else
		{
	  		echo dialog(array($db->error."<br />".$db->error_msg ,"ERROR",""));
	    	exit;
		}
	}
}

//===============================
// Function query_db($resultado, $fila)
//===============================
function query_db($ssql, $remoto=false, $ignore=false)
{
	global $m_;
	global $db;

	$result = $db->query($ssql);

	if (!$result)
	{
       if($ignore == true)
       {
          return "ignore";
       }
       else
       {
		if ($remoto=="true")
		{
			return "" . $m_['err_query_db'] . "<br /><br />$ssql<br />" . addslashes ( $db->error ) . " - " . addslashes( $db->error_msg ) ;
      	//return dialog(array($m_['err_query_db'] . "<br /><br />$ssql<br />" . $db->error . " - " . $db->error_msg ,"ERROR",""));
		}
		else
		{
			echo dialog(array($m_['err_query_db'] . "<br /><br />$ssql<br />" . $db->error . " - " . $db->error_msg ,"ERROR",""));
			//echo dialog(array(pg_result_error($result).'<br /><br />'.$ssql,"ERROR",""));
			exit;
		}
	}
    }

	return $result;
}

//===============================
// Verifica el estado del ultimo query
// Function query_estado($error, $remoto)
//===============================
function query_estado($error_o_mensaje="err", $remoto = "false")
{
	global $m_;
	global $db;

	if($error_o_mensaje == "err")
		$cad = $db->error;
	elseif($error_o_mensaje == "err_msg")
		$cad = $db->error_msg;
	elseif($error_o_mensaje == "status")
		$cad = $db->status;
	elseif($error_o_mensaje == "status_msg")
		$cad = $db->status_msg;

	if($remoto == "true")
	{
  		return ("" . $cad) ;
	}
	else
	{
		return "";
	}
}

//===============================
// Function fetch_array($resultado)
//===============================
function fetch_array_db($resultado)
{
	global $m_;
	global $db;
	return $db->fetch_array($resultado);
}

//===============================
// Function fetch_assoc($resultado)
//===============================
function fetch_assoc_db($resultado)
{
	global $m_;
	global $db;
	return $db->fetch_assoc($resultado);
}

//===============================
// Function result_seek($resultado, $indice)
//===============================
function result_seek_db($resultado, $indice)
{
	global $m_;
	global $db;
	return $db->result_seek($resultado, $indice);
}

//===============================
// Function num_rows_db($resultado) # de Filas
//===============================
function num_rows_db($resultado)
{
	global $m_;
	global $db;
	return $db->num_rows($resultado);
}

//===============================
// Function num_fields_db($resultado) # de Columnas
//===============================
function num_fields_db($resultado)
{
	global $m_;
	global $db;
	return $db->num_fields($resultado);
}


//===============================
// Function fetch_row_db($resultado, $fila)
//===============================
function fetch_row_db($resultado, $fila)
{
	global $m_;
	global $db;
	return $db->fetch_row($resultado, $fila);
}

//===============================
// Function field_name_db($resultado, $col)
//===============================
function field_name_db($resultado, $col)
{
	global $m_;
	global $db;
	return $db->field_name($resultado, $col);
}

//===============================
// Function field_table_db($resultado, $col)
//===============================
function field_table_db($resultado, $col)
{
  global $m_;
  global $db;
  return $db->field_table($resultado, $col);
}

//===============================
// Function field_type_db($resultado, $col)
//===============================
function field_type_db($resultado, $col)
{
	global $m_;
	global $db;
	return $db->field_type($resultado, $col);
}

//===============================
// Function affected_rows_db($resultado)
//===============================
function affected_rows_db($resultado=-2)
{
	global $m_;
	global $db;
	return $db->affected_rows($resultado);
}

//===============================
// Function close_db($resultado)
//===============================
function close_db()
{
  global $m_;
  global $db;
  return $db->close();
}

//===============================
// Function close_db($resultado)
//===============================
function free_result_db($result = false)
{
  global $m_;
  global $db;
  return $db->free_result($result);
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


//===============================
// Function GEN_CHLIST_DB
//===============================
function gen_chlist_db($params)
{
  global $db;
  //

  //-- $field_key  = * Campo llave a traves del cual se cruza la consulta de la $table_list y la $table_sel de datos
  //-- $table_list = * Nombre de la tabla en la cual se encuentran los campos a listar
  //-- $field_list = * Campo que se muestra al usuario para determinado ID
  //-- $table_sel  = * Nombre de la tabla de la cual se sacan los datos ID de los campos a chequear en la $table_list.
  //-- $field_sel  = * Indica el campo a traves del cual se filtra la info de la tabla
  //-- $selected   = Indica cual es el valor de SELECT que debe marcarse por defecto al abrir el Formulario
  //-- $caption    = Adiciona este Caption a la Forma de Captura (Titulo del Campo)
  //-- $class      = Especifica la Clase CSS a la cual corresponde este campo
  //-- $ch_all     = Indica si se adiciona la funcion 'check_all' en JS para MARCAR todos los campos
  //-- $ch_none    = Indica si se adiciona la funcion 'check_none' en JS para DESMARCAR todos los campos
  //-- $enabled    = Por defecto = TRUE, especifica si el campo se habilita o no
  //-- $visible    = Por defecto = TRUE, especifica si el campo es visible o no
  //-- $readonly   = Por defecto = FALSE, especifica si el campo es de solo lectura o no
  //-- $cols       = Por defecto (1) Nmero de columnas para mostrar el listado de los campos
  //-- $direction  = H o V. Por defecto = H, especifica si el Caption lo ubica al lado del campo a capturar o encima

  $field_key  = $params[0];
  $table_list = $params[1];
  $field_list = $params[2];
  $table_sel  = $params[3];
  $field_sel  = $params[4];
  $selected   = $params[5];
  $caption    = $params[6];
  $class      = $params[7];
  $ch_all     = $params[8];  // x Dev
  $ch_none    = $params[9];  // x Dev
  $enabled    = $params[10]; // x Dev
  $visible    = $params[11]; // x Dev
  $readonly   = $params[12]; // x Dev
  $cols       = $params[13]; // x Dev
  $direction  = $params[14]; // x Dev

  if (!$enabled)
    $enabled = "DISABLE";
  else
    $enabled = '';
  if (!$visible)
    $visible = "style:display='none'";
  else
    $visible = '';
  if ($readonly)
    $readonly = "READONLY";
  else
    $readonly = '';

  conectar_db();

  $ssql = "SELECT $field_key, $field_list FROM $table_list ORDER BY $field_list";

  $result_list = query_db($ssql);

  $ssql = "SELECT $field_key FROM $table_sel WHERE $field_sel = '$selected' ORDER BY $field_key";

  $fields_sel = "";

  $cols=4;
  $new_row = true;
  echo "<table border=0 cellpadding=0 cellspacing=0>";
  while ($row_list = fetch_array_db($result_list))
  {
    $marcar = "";
    $result_sel = query_db($ssql);
    while ($row_sel = fetch_array_db($result_sel))
    {
      if ($row_list[$field_key] == $row_sel[$field_key])
      {
        $marcar = "CHECKED";
        $fields_sel[] = $row_sel[$field_key];
        break;
      }
    }
    // Se debe dejar la variable $row_list[1] en lugar de $row_list[$field_list] porque se pueden enviar campos
    // maquillados con otro nombre de campo diferente al contenido de la variable $field_list
    // Ejemplo:
    //    En el SELECT casa||carro||beca AS deseo;
    //    $field_list es igual al 'casa||carro||beca AS deseo'
    //    y este NO es el nombre del campo, el nombre del campo es 'deseo'.
    if ($new_row)
      echo "<tr>";
    echo "<td><INPUT CLASS='".$class."' TYPE=CHECKBOX NAME=".$field_key."[] ID='".$field_key."' VALUE='".$row_list[$field_key]."' $marcar $enabled $visible $readonly>".$row_list[1]."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<td>";
    $i++;
    if ($i == $cols)
    {
      echo "</tr>";
      $new_row = true;
      $i       = 0;
    }
    else
    {
      $new_row = false;
    }
  }
  echo "</table>";
}

// $table_list  = Nombre de la tabla en la cual se encuentran los campos a listar
// $field_key   = Campo llave a traves del cual se maneja el valor nico del registro
// $field_list  = Campo que se muestra al usuario para determinado ID
// $selected    = Indica cual es el valor de SELECT que debe marcarse por defecto
// $null        = .T. o .F. Indica si el campo en el cual se va a grabar el dato admite NULL o no
// $submit      = .T. o .F. Indica si se ejecuta SUBMIT en el momento de selecionar el campo
// $id_filtro   = Nombre del campo del formulario a traves del cual va a filtrar la informacion mostrada en este select

/*
function gen_select($params)
{
  global $db;
  //

  $table_list = $params[0];
  $field_key  = $params[1];
  $field_list = $params[2];
  $selected   = $params[3];
  $null       = $params[4];
  $submit     = $params[5];
  $id_filtro  = $params[6];

  conectar_db();
  echo $ssql;
  $ssql  = "SELECT $field_key, $field_list FROM $table_list";
  if ($id_filtro <> "")
  {
    if ($_POST[$id_filtro] <> "")
    {
      $ssql .= " WHERE $id_filtro = '".$_POST[$id_filtro]."'";
    }
    else
    {
      $ssql .= " WHERE $id_filtro IS NULL";
    }
  }
  $ssql .= " ORDER BY $field_list";
  $result = $db->query($ssql);

  // *******
  // Revisar el siguiente valor *** se deja temporalmente para solucionar el problema con el FILTRO al cargar el formulario por primera vez
  //if ($_POST[$id_filtro] == "")
  //{
  //  $_POST[$id_filtro] = 1;
  //}
  // *******


  // si el campo se requiere para el formulario verifica si existen datos b?cos en la tabla $table
  if (!$null && ($_POST[$id_filtro] <> ""))
  {
    if ($db->num_filas($result) == 0)
    {
      if ($id_filtro != "")
      {
        echo dialog(array("No existen datos en la tabla <b>$table_list</b><br>relacionado con el dato <b>$id_filtro = $_POST[$id_filtro]</b>.<br><br>
                Antes de continuar por favor dirigase a llenar estos datos o<br>seleccione otro valor para el dato <b>$id_filtro</b>.", "ERROR", ""));
      }
      else
      {
        echo dialog(array("No existen datos en la tabla <b>$table_list</b><br>los cuales son requisito de este formulario.<br><br>Por favor dirigase antes a llenar estos datos.", "ERROR", ""));
      }
      exit;
    }
  }

  $submit_text = "";
  if ($submit)
  {
    $submit_text = "onChange='javascript:document.campos.submit();'";  // Solo envia el formulario de nombre CAMPOS
  }
  echo "<select name=\"$field_key\" $submit_text>";
  if (isset($null) && $null)
  {
    echo "<option value=\"\" SELECTED='SELECTED'>----------</option>";
  }
  while ($row = pg_fetch_array($result))
  {
    if ($selected == $row[$field_key])
    {
      $marcar = "SELECTED='SELECTED'";
      $_POST[$field_list] = $row[$field_list];
    }
    else
    {
      $marcar = "";
    }
    if ($row[$field_key] != "assysdba" || $row[$field_list] != "assysdba")
      echo "<option value=".$row[$field_key]." $marcar>".$row[$field_list]."</option>";
  }
  echo "</select>";
}
*/

//====================================================================================================
//===================================    FUNCIONES DE SEGURIDAD    ===================================
//====================================================================================================

//===============================
// Function verificar_permiso
//===============================
function verificar_permiso($login, $permiso, $remoto=false, $log=false)
{
	global $cnf;
	global $db;
	conectar_db();

	if($remoto == true) { $login = $_SESSION['login']; }

	$ssql   = "SELECT count(*)
              FROM  xcm_usuarios_permisos
              WHERE id_permiso = '$permiso'
                AND login      = '$login'";

	$result = query_db($ssql);
	$row    = fetch_array_db($result);
    $cadena = "false";
// EG - 26 03 2007 agregue que el usuario dbxdba no se le verifique permisos
	if (($row[0] == 1) OR ($login == "dbxdba"))
	{
   	if (!$remoto) return true;
		else return "true";
 	}
	else
	{
		switch (strtoupper($cnf["db"]))
		{
			case "postgres":
				$ssql = "SELECT nom_permiso, desc_permiso
	         	       FROM  xcm_permisos
	            	    WHERE id_permiso = '$permiso'
	               	   AND is_folder  = false";
			break;
			case "mysql":
				$ssql = "SELECT nom_permiso, desc_permiso
	         	       FROM  xcm_permisos
	            	    WHERE id_permiso = '$permiso'
	               	   AND is_folder  = 0";
			break;
		}
    $result = query_db($ssql);
    $row    = fetch_array_db($result);

    if (is_null($row[nom_permiso]))
    {
//		 	if (!$remoto) {
			 	$cadena = "<div style=\"color: Red; text-align: center;\">PERMISO NO DEFINIDO</div><br>Posible Causa: <br>Falta actualizar el listado de Permisos.<br>Por favor comun&iacute;quese con el Administrador del Sistema.<br><a href='javascript:window.history.back();'>Haga click aqu&iacute; para regresar</a>";
//				 }
//		 	else { $cadena = "false"; }
    }
		else
    {
      if (trim($row[desc_permiso]) == '')
      {
//        if (!$remoto) {
		  $cadena = "<div style=\"color: Red; text-align: center;\">PERMISO DENEGADO</div><br> No tiene permiso para:<br><span style=\"font-weight: bolder;\">".$row[nom_permiso]. "</span><br><br>Si desea obtener este permiso, comun&iacute;quese con el Administrador del Sistema.<br><a href='javascript:window.history.back();'>Haga click aqu&iacute; para regresar</a>";
//		  }
//	 			else { $cadena = "false"; }
      }
			else
			{
//        if (!$remoto) {
		  $cadena = "<div style=\"color: Red; text-align: center;\">PERMISO DENEGADO</div><br> No tiene permiso para:<br><span style=\"font-weight: bolder;\">".$row[nom_permiso]. "</span><br><br>Si desea obtener este permiso, comun&iacute;quese con el Administrador del Sistema.<br><a href='javascript:window.history.back();'>Haga click aqu&iacute; para regresar</a>";
//		  }
//	 			else { $cadena = "false"; }
      }
		}

      if ((!$remoto) && ($cadena != "false" ))
		{
		  echo dialog(array($cadena,"ERROR",""));
			if($log)
			{
				session_unset();
				session_destroy();
			}
		  exit;
		}
		else return $cadena;
  }
}

//===============================
// Function LOGIN
//===============================
function login($login, $passwd, $remoto=false, $nivel_usuario=false)
{
//		jsalert("Traigo {$nivel_usuario}");
	global $cnf;
	global $m_;
	global $db;
	$cant_ses = 0;

	$ipRemota = $_SERVER['REMOTE_ADDR'];
	$cnf["nivel_usuario"] = 2;

	if ( ($remoto == true) AND ($login == "") )
	{
   	$login  = $_SESSION["login"];
   	$passwd = $_SESSION["passwd"];
   }

	$db->dbname = $cnf["dbname"];

	conectar_db();

	$passwd = md5($passwd);

	if ($nivel_usuario)
	{
		$ssql   = "SELECT (login), id_nivel_usuario, cant_sesiones_max, cant_sesiones, is_activo, id_nuip_serial, id_nuip
	               FROM  xcm_usuarios_v1
	               WHERE login  = '$login' AND passwd = '$passwd' ";
   }
	else
	{
		$ssql   = "SELECT (login), id_nivel_usuario, cant_sesiones_max, cant_sesiones, is_activo, id_nuip_serial, id_nuip
						FROM  xcm_usuarios_v1 WHERE login  = '$login' AND passwd = '$passwd'";
   }

	$result = query_db($ssql);
	$row    = fetch_array_db($result);
	$cnf["nivel_usuario"] = 2;

	// Datos Adicionales del usuario - v.110812.1
	$cnf["id_nuip_serial_usuario"] = isset($row[5])?$row[5]:"";
	$_SESSION["cnf"]["id_nuip_serial_usuario"] = isset($row[5])?$row[5]:"";
	$cnf["id_nuip_usuario"] = isset($row[6])?$row[6]:"";
	$_SESSION["cnf"]["id_nuip_usuario"] = isset($row[6])?$row[6]:"";

	if(($row[4] == "f") OR ($row[4] == "false") OR ($row[4] == false) )
	{
      if (!$remoto)
      {
//		  echo dialog(array($m_['usuario_inactivo'],"INFO","",true));
		}
		exit;
	}

	if (( $row[0] == $login) AND trim($login)!= "")
	{
		// EG 15/04/2008 - Num Sesiones
	   if( isset($cnf["xesion"]) AND $cnf["xesion"]==true )
	   {
			$cant_ses = $row[3];
			$cant_ses_max = $row[2];
		}
		else
		{
			$cant_ses = 0;
			$cant_ses_max = 1;
		}

	 if( !isset( $_SESSION["cnf"]['EnSistema'] ) AND ( isset($cnf["xesion"]) AND $cnf["xesion"]==true ) )
	 {
		if($row[3] >= $row[2])
		{
	      if (!$remoto)
			{
			  echo dialog(array("<div style='color: Red; text-align: center;'>ERROR: (USR-0003) - MAXIMO DE SESIONES</div><br>Tiene Multiples Sesiones Abiertas<br><br>Si desea obtener Acceso al Sistema, <br />cierre correctamente sus otras sesiones con el Botón Salida Segura, <br />o comun&iacute;quese con el Administrador del Sistema.<br><a href='javascript:window.history.back();'>Haga click aqu&iacute; para regresar</a>", "INFO", "", true));
				$ssql = "SELECT login, fec_ingreso, ip, id_sesion FROM xcm_sesiones WHERE login= '$login' ";
				$result = query_db($ssql);
				$cadena = "<table border='0'>";
				$cadena .= "<tr align='center'><td><b>Acción</b></td><td><b>Usuario</b></td><td><b>Fecha de Ingreso</b></td><td><b>IP</b></td></tr>";
				while($row2 = fetch_array_db($result))
				{
				  $cadena .= "\n<tr><td><a href='".$cnf["lib_path"]."/xSesion.php?sid=".$cnf["nom_session"]."&id=".$row2[3]."' target='pisc1'>Cerrar&nbsp;Sesion</a></td>";
				  $cadena .= "<td>".$row2[0]."</td><td>".$row2[1] ."</td><td>".$row2[2] ."</td></tr>";
				}
				$cadena .= "</table><iframe id='pisc1' name='pisc1' style='display:none; width:0px'></iframe>";
				echo dialog(array($cadena, "INFO", "", true));
			}
			exit;
		}
	 }

		if ($nivel_usuario)
		{
			$id_grupos = "";
			$nom_grupos = "";
			$cnf["nivel_usuario"] = isset($row[1])?$row[1]:"2";

			// Trae los IDs de los grupos a los que el usuario pertenece
			$ssql   = "SELECT id_grupo
		               FROM  xcm_usuarios_grupos
		               WHERE login  = '$login'";
			$result = query_db($ssql);
			while($row = fetch_array_db($result))
				$id_grupos .= $row[0].",";
			$cnf["grupos_usuario"] = substr($id_grupos,0,strlen($id_grupos)-1);

			// Trae los NOMBRES de los grupos a los que el usuario pertenece
			$ssql   = "SELECT nom_grupo
		               FROM  xcm_grupos
		               WHERE id_grupo IN (".$cnf["grupos_usuario"].")";
			$result = query_db($ssql);
			while($row = fetch_array_db($result))
				$nom_grupos .= $row[0]."<br />";
			$cnf["grupos_usuario_maq"] = substr($nom_grupos,0,strlen($nom_grupos)-6);

			// Configuración x Grupo
			$ssql = "SELECT nom_cnf, vr_cnf FROM xcm_cnf_grupos
                     WHERE id_grupo IN (".$cnf["grupos_usuario"].")";
			$result = query_db($ssql, false, true);
			if($result != "ignore")
			{
   			while($row = fetch_array_db($result))
   			{
               $cnf[$row[0]] = $row[1];
               $_SESSION["cnf"][$row[0]] = $row[1];
            }
         }

			if( !isset( $_SESSION["cnf"]['EnSistema'] ) AND ( isset($cnf["xesion"]) AND $cnf["xesion"]==true ) )
			{
			   $cnf['EnSistema'] = true;
			   $_SESSION["cnf"]['EnSistema'] = true;

				if($cant_ses >= $cant_ses_max)
				{
					$semilla = $cant_ses_max;
				}
				else
				{
					$semilla = $cant_ses + 1;
				}

				$ssql = "UPDATE xcm_usuarios SET cant_sesiones = '$semilla'
		               WHERE login  = '$login' AND passwd = '$passwd' ";
				$result = query_db($ssql, false, true);

				$ssql = "INSERT INTO xcm_sesiones ( login, ip, semilla ) VALUES ('$login', '$ipRemota', '$semilla'); ";
				$result = query_db($ssql, false, true);

				$ssql = "SELECT id_sesion FROM xcm_sesiones WHERE login = '$login' AND ip = '$ipRemota' AND semilla = '$semilla' ";
				$result = query_db($ssql, false, true);

   			while($row = fetch_array_db($result))
	  			{
	  			   $cnf['id_sess'] = $row[0];
				}

            $cnf["nom_session_new"] = $cnf['nom_session'].$login.$semilla;
            session_name($cnf['nom_session'].$login.$semilla);
            $cnf["nom_session_new"] = session_name();
            $_SESSION["cnf"] = $cnf;
			}

		}

		if ( isset($cnf["xapito"]) AND $cnf["xapito"])
		xapito_Acceso($ipRemota, $login, 'I');

		if( function_exists('dataLogin') ) dataLogin($login);

		if (!$remoto) return true;
		else return 'true';
	}
	else
	{
		if (!$remoto)
		{
			echo dialog(array($m_['err_login'],"ERROR",""));
			if (isset($cnf["xapito"]) AND $cnf["xapito"])
				xapito_Acceso($ipRemota, $login, 'F');
			return false;
		}
		return 'false';
	}
}

/// EG - 2008/04/15 -
function cierre_sesion($ipRemota, $login, $id_sess)
{
	global $cnf;
	global $db;
	conectar_db();

	if($login == false)
	{
		$ssql = "SELECT login, semilla FROM xcm_sesiones WHERE id_sesion= '$id_sess' ";
		$result = query_db($ssql, false, true);
		while($row = fetch_array_db($result))
		{
			$login = $row[0];
		}
	}

	if($login != false )
	{
		$ssql = "UPDATE xcm_usuarios SET cant_sesiones=(cant_sesiones - 1)
	             WHERE login= '$login' ";
		$result = query_db($ssql, false, true);
	}

	$ssql = "UPDATE xcm_usuarios SET cant_sesiones = 0 WHERE cant_sesiones < 0";
	$result = query_db($ssql, false, true);

	$ssql = "UPDATE xcm_usuarios SET cant_sesiones = cant_sesiones_max WHERE cant_sesiones > cant_sesiones_max";
	$result = query_db($ssql, false, true);

	$ssql = "DELETE FROM xcm_sesiones WHERE id_sesion= '$id_sess' ";
	$result = query_db($ssql, false, true);

	if ( isset($cnf["xapito"]) AND $cnf["xapito"])
	xapito_Acceso($ipRemota, $login, 'O');

	session_unset();
	session_destroy();
}

////////////////////////  FUNCIONES XAPITO
/// EG - 2007 10 - egonpin@gmail.com
////////////////////////////////////////////////////////////////////////////////
function xapito_Acceso($ipRemota, $login, $evento)
{
 	conectar_db();
	$result = query_db("INSERT INTO xap_x_acceso (ip, login, nom_evento) VALUES ( '$ipRemota', '$login', '$evento');");
}

?>
